#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
#  pdfCreate.py
#  
#  Copyright 2017 krasytod <krasytod@krasytod-desktop>


from reportlab.lib.pagesizes import A4 , A3,A2
from reportlab.lib.styles import getSampleStyleSheet
from reportlab.lib.units import mm, inch
from reportlab.pdfgen import canvas
from reportlab.platypus import Image, Paragraph, Table, TableStyle
from reportlab.lib.styles import ParagraphStyle
from reportlab.lib.enums import TA_LEFT, TA_CENTER,TA_RIGHT,TA_JUSTIFY
from reportlab.lib import colors
from reportlab.pdfbase import pdfmetrics
from reportlab.pdfbase.ttfonts import TTFont
from reportlab.lib.fonts import addMapping
from reportlab.platypus import SimpleDocTemplate, Paragraph, Spacer, Image, Table, PageBreak
import math
from reportlab.platypus.flowables import KeepTogether 
from datetime import datetime

class LetterMaker(object):

	def __init__(self, pdf_file,decided_codes_dict,rule,us_jur ):
		self.c = SimpleDocTemplate(pdf_file, pagesize=A2, rightMargin=5,leftMargin=5)
		self.c.title = 'Rates' 
		self.styles = getSampleStyleSheet()
		self.style = self.styles ["BodyText"]
		self.width, self.height = A2
		self.page_width = self.width
		#self.parts = []
		self.Story = []
		self.styleSheet = getSampleStyleSheet()
		self.pdf_file  =pdf_file
		#self.decided_codes_dict = decided_codes_dict
		self. table_list = decided_codes_dict
		self.rule   = rule
		self.us_jur = us_jur

	def minimalist_xldate_as_datetimestr(self,xldate, datemode=0):
		# datemode: 0 for 1900-based, 1 for 1904-based
		return (
			datetime(1899, 12, 30)   + timedelta(days=xldate + 1462 * datemode).strftime("%Y/%m/%d")
        )

	def convertDate(self,effective_date):
		# checks if date is in xlsx format and converts it to standart
		try:
			dat = int(rate_row[effective_date_col])
			return minimalist_xldate_as_datetimestr(rate_row[effective_date_col] )
			
		except:
			#is ok probably
			return effective_date

	def createTable(self):
		print ("createTable")
		dec_codes = self.decided_codes_dict['dec_codes'] 
		inc_codes = self.decided_codes_dict['inc_codes']  
		del_codes = self.decided_codes_dict['del_codes']  
		penalty_codes = self.decided_codes_dict['penalty_codes'] 
		new_codes = self.decided_codes_dict['new_codes']  
		same_codes = self.decided_codes_dict['same_rates']
		rate_col=self.rule['rate_col']
		code_col =self.rule['code_col']
		code_col_name =self.rule['code_name_col']
		effective_date_col=self.rule['effective_date_col']
		table = [[ "Code", "Code Name", "New Rate",  "Effective Date" , "Status"  ] ]
		
		
		for rate_row in dec_codes:
			row = [  rate_row[code_col],rate_row[code_col_name] if code_col_name!= None else "",rate_row[rate_col],rate_row[effective_date_col],"Decreased" ]
			table.append(row)
			
		for rate_row in inc_codes:
			row = [  rate_row[code_col],rate_row[code_col_name] if code_col_name!= None else "",rate_row[rate_col],rate_row[effective_date_col],"Increased" ]
			table.append(row)
		
		for rate_row in del_codes:
			row = [  rate_row[code_col],rate_row[code_col_name] if code_col_name!= None else "",rate_row[rate_col],rate_row[effective_date_col],"Deleted" ]
			table.append(row)

			
		for rate_row in new_codes:
			row = [  rate_row[code_col],rate_row[code_col_name] if code_col_name!= None else "",rate_row[rate_col],rate_row[effective_date_col],"New" ]
			table.append(row)
			
		for rate_row in same_codes:
			row = [  rate_row[code_col],rate_row[code_col_name] if code_col_name!= None else "",rate_row[rate_col],rate_row[effective_date_col],"Same rate" ]
			table.append(row)
			
		if self.rule.get('violation_action',0) ==1:
			
			for rate_row in penalty_codes:
				row = [  rate_row[code_col],rate_row[code_col_name] if code_col_name!= None else "" ,rate_row[rate_col],rate_row[effective_date_col],"Codes with penalty" ]
				table.append(row)
			
		return table

	def createDocument(self):
		
		table = self. table_list #self.createTable() 
		print ("table len",len(table))
		plabel = Paragraph("<b><font size=11 > Rate table</font></b>",self.style  )
		#print (self.us_jur)
		start =0 
		#if len(table)> 2000:
		#	step = 2000
		#else:
		#	step = len(table)
		data = [ [plabel ,""]]
		data.extend(table)
		
		#print(data)
		if not self.us_jur :
			rates_report = Table(
			data, style=[
			('VALIGN', (0, 0), (-1, -1), 'TOP'),
			('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
			('SPAN', (0, 0), (-1, 0)),
			('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
			('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),
			#('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
			('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white)
			#('ALIGN', (1, 2), (1, -1), 'RIGHT'),
			]  , colWidths=[self.width/9,self.width/2,self.width/9,self.width/8,self.width/8.5])
		else:
			rates_report = Table(
			data, style=[
			('VALIGN', (0, 0), (-1, -1), 'TOP'),
			('BACKGROUND', (0, 0), (-1, -1), colors.HexColor('#f4f4f4')),
			('SPAN', (0, 0), (-1, 0)),
			('LINEABOVE', (0, 1), (-1, 1), 0.5, colors.black),
			('BACKGROUND', (0, 1), (-1, 1), colors.HexColor('#b5b5b5')),
			#('BACKGROUND', (0, 3), (-1, -1), colors.HexColor('#e5e5e5')),
			('INNERGRID', (0, 1), (-1, -1), 0.5, colors.white)
			#('ALIGN', (1, 2), (1, -1), 'RIGHT'),
			]  , colWidths=[self.width/2,self.width/9,self.width/9,self.width/8,self.width/8.5])
			
			
		#print (rates_report)
		self.Story.append(rates_report)  #KeepTogether
		self.Story.append(Spacer(self.width, 5))

			
			

	def savePDF(self):
		""""""
		self.c.build(self.Story ) 
 
#----------------------------------------------------------------------
if __name__ == "__main__":
	doc = LetterMaker("example.pdf", "The MVP", 10)
	doc.createDocument()
	doc.savePDF()
		
		


