"""user first/last name

Revision ID: cd72802001ef
Revises: 83775a73e234
Create Date: 2017-11-20 23:07:14.270735

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'cd72802001ef'
down_revision = '83775a73e234'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date', 'client_id'], unique=True)
    op.add_column('users', sa.Column('first_name', sa.String(length=40), nullable=True))
    op.add_column('users', sa.Column('last_name', sa.String(length=40), nullable=True))
    op.drop_column('users', 'fullname')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('users', sa.Column('fullname', sa.VARCHAR(length=100), autoincrement=False, nullable=True))
    op.drop_column('users', 'last_name')
    op.drop_column('users', 'first_name')
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date'], unique=False)
    # ### end Alembic commands ###
