"""rate_auto_import_rule

Revision ID: d2027700f94d
Revises: d1003f3d4088
Create Date: 2018-04-18 21:49:15.780578

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'd2027700f94d'
down_revision = 'd1003f3d4088'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('rate_auto_import_rule',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('active', sa.Boolean(), nullable=True),
    sa.Column('create_by', sa.String(length=100), nullable=True),
    sa.Column('create_on', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::date"), nullable=True),
    sa.Column('update_by', sa.String(length=100), nullable=True),
    sa.Column('update_on', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::date"), nullable=True),
    sa.Column('egress_trunk_id', sa.Integer(), nullable=True),
    sa.Column('from_email', sa.String(length=100), nullable=True),
    sa.Column('subject_keyword', sa.String(length=100), nullable=True),
    sa.Column('pre_info', sa.Text(), nullable=True),
    sa.Column('rate_date_format', sa.String(length=40), nullable=True),
    sa.Column('rate_table_code_deck_id', sa.Integer(), nullable=True),
    sa.Column('reduplicate_rate_action', sa.Integer(), server_default=sa.text('0'), nullable=False),
    sa.Column('code_deck_flag', sa.Integer(), server_default=sa.text('0'), nullable=False),
    sa.Column('use_ocn_lata_code', sa.Integer(), server_default=sa.text('0'), nullable=False),
    sa.ForeignKeyConstraint(['egress_trunk_id'], ['resource.resource_id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_index(op.f('ix_rate_auto_import_rule_egress_trunk_id'), 'rate_auto_import_rule', ['egress_trunk_id'], unique=False)
    op.create_table('rate_auto_import_rule_log',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('rule_id', sa.Integer(), nullable=True),
    sa.Column('status', sa.Integer(), nullable=False),
    sa.Column('start', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::date"), nullable=True),
    sa.Column('finish', sa.DateTime(timezone=True), server_default=sa.text('NULL'), nullable=True),
    sa.ForeignKeyConstraint(['rule_id'], ['rate_auto_import_rule.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_rate_auto_import_rule_log_rule_id'), 'rate_auto_import_rule_log', ['rule_id'], unique=False)
    op.add_column('rate_upload_task', sa.Column('rule_log_id', sa.Integer(), nullable=True))
    op.create_index(op.f('ix_rate_upload_task_rule_log_id'), 'rate_upload_task', ['rule_log_id'], unique=False)
    op.create_foreign_key(None, 'rate_upload_task', 'rate_auto_import_rule_log', ['rule_log_id'], ['id'], ondelete='SET NULL')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'rate_upload_task', type_='foreignkey')
    op.drop_index(op.f('ix_rate_upload_task_rule_log_id'), table_name='rate_upload_task')
    op.drop_column('rate_upload_task', 'rule_log_id')
    op.drop_index(op.f('ix_rate_auto_import_rule_log_rule_id'), table_name='rate_auto_import_rule_log')
    op.drop_table('rate_auto_import_rule_log')
    op.drop_index(op.f('ix_rate_auto_import_rule_egress_trunk_id'), table_name='rate_auto_import_rule')
    op.drop_table('rate_auto_import_rule')
    # ### end Alembic commands ###
