from time import sleep
import traceback
import celery
from api_dnl import settings
from datetime import date,datetime,timedelta
from dateutil.relativedelta import relativedelta
from dateutil.parser import parse as parse_datetime
from pytz import UTC
from time import mktime,gmtime,strftime,strptime,localtime
import calendar
import random
import requests
import io,csv,gzip,zipfile
import os,shutil
import xlwt
import json
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_,or_,not_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select,alias,case
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import SchedulerLog,ScheduledReportLog,Client,PaymentTerm,Invoice,\
    DidBillingPlan,DidBillingRel,Client,Resource,ResourceIp,JurisdictionPrefix,Code,ImportExportLogs,\
    ResourcePrefix,Rate,RateTable,RateSendLog,RouteStrategy,C4ClientBalance,\
    RateSendLogDetail,CrdReportDetailTable,MailSender,FraudDetection,FraudDetectionLog,FraudDetectionLogDetail,\
    ResourceBlock,IngressTrunk,SystemParameter,AlertRule,AlertRuleLog,AlertRulesLogDetail,CdrReportDetail,client_cdr,\
    ProductRouteAnalysis,ProductRouteAnalysisLog,ProductItems,ProductItemsResource
from api_dnl.model import PrimaryKeyConstraint,func,query_to_sting,cast,generate_uuid_str,aliased,get_db
from api_dnl.tasks import app,log,db,SqlAlchemyTask,SchLog
from api_dnl import model
from api_dnl.utils.statisticapi2 import StatisticAPI
from api_dnl.utils.dnl_switch import DnlSwitchSession
from api_dnl.scheme import RateScheme


@app.task(base=SqlAlchemyTask,time_limit=1800,soft_time_limit=1790)
def product_route_analysis(uuid):
    slog = SchLog('product_route_analysis')
    log.debug('product_route_analysis uuid={} sheduled.'.format(uuid))
    req = ProductRouteAnalysis.get(uuid)
    cls = ProductRouteAnalysis
    icls = ProductRouteAnalysisLog
    if req:
        if req.status != 'initial':
            log.error('product_route_analysis uuid {} already started'.format(uuid))
            return
        try:
            req.status = 'process'
            req.rec_num = 0
            req.progress = 'started'
            req.save()
            if req.code_deck_id:
                codes=req.codes
            else:
                codes=Code.filter(Code.code_deck_id.is_(None)).all()
            for c in req.codes[0:10]:
                item=icls(code=c.code,code_name=c.code_name,country=c.country)



                req.items.append(item)
                req.rec_num=req.rec_num+1
                req.save()
            req.status='success'
            req.finish = datetime.now(UTC)
            req.save()
        except Exception as e:
            log.error('product_route_analysis error {}'.format(str(e)))
            req.status = 'fail'
            req.progress = 'product_route_analysis error {}'.format(str(e))
            req.finish = datetime.now(UTC)

@app.task(base=SqlAlchemyTask,time_limit=1800,soft_time_limit=1790)
def product_route_analysis_(uuid):
    slog = SchLog('product_route_analysis')
    log.debug('product_route_analysis uuid={} sheduled.'.format(uuid))
    req = ProductRouteAnalysis.get(uuid)
    cls = ProductRouteAnalysis
    icls = ProductRouteAnalysisLog
    if req:
        if req.status != 'initial':
            log.error('product_route_analysis uuid {} already started'.format(uuid))
            return
        try:
            req.status = 'process'
            req.rec_num = 0
            req.progress = 'started'
            req.save()
            if req.code_deck_id:
                codes=req.codes
            else:
                codes=Code.filter(Code.code_deck_id.is_(None)).all()
            for c in req.codes[0:10]:
                self_rate = Rate.filter(Rate.code.like(c.code + '%'),
                                         Rate.rate_table_id == req.rate_table_id).order_by(Rate.rate).first()
                if self_rate:
                    if req.characteristics=='No Active Egress Trunk':
                        trunks = Resource.filter(Resource.egress == True)
                    else:
                        trunks = Resource.filter(and_(Resource.egress==True,Resource.active==True))
                    for tr in trunks:
                        if not tr.route and not tr.product_items:
                            continue
                        if tr.product_items:
                            q = ProductItems.filter(ProductItems.digits.like(self_rate.code + '%')).all()
                            clist = [i.digits for i in q]
                            if len(q)==0:
                                continue
                        else:
                            clist = [c]
                        for cc in clist:
                            rate = Rate.filter(Rate.code.like(self_rate.code + '%'),
                                               Rate.rate_table_id == tr.rate_table).order_by(
                                Rate.rate).first()
                            item = icls(code=cc, code_name=c.code_name, country=c.country, trunk_count=0,
                                        profitable_trunk_count=0)

                            if rate:
                                if rate.rate < self_rate.rate:
                                    item.profitable_trunk_count=item.profitable_trunk_count+1


                            req.items.append(item)
                            req.rec_num=req.rec_num+1
                            req.save()
            req.status='success'
            req.finish = datetime.now(UTC)
            req.save()
        except Exception as e:
            log.error('product_route_analysis error {}'.format(str(e)))
            req.status = 'fail'
            req.progress = 'product_route_analysis error {}'.format(str(e))
            req.finish = datetime.now(UTC)
            try:
                req.save()
            except:
                pass
    else:
        log.error('product_route_analysis uuid {} not found'.format(uuid))
    slog.close()