import celery
from api_dnl import settings
from datetime import datetime, timedelta
from pytz import UTC
from time import mktime
import io, csv, gzip, zipfile
import xlwt
import json
import traceback
from celery import Celery

from celery.app.log import get_logger, mlevel
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (or_, and_,
                        Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey,
                        BigInteger,
                        Table
                        )
from sqlalchemy import (Column, desc, and_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select, alias, case

import csv

from ..view import IntegrityError
from ..model import DnlApiBaseModel, User, DidBillingPlan, DidBillingRel, DidNumberUpload, DidNumberDeleteTask, \
    DidDisconnectTask
from ..tasks import app, log, db, SqlAlchemyTask
from .. import model
from .. import view
from api_dnl.utils.did_api import DidApiException
from api_dnl.utils.did_api import DidAPIMuliVendor, VendorManual, unprefix, unprefix_2, set_prefix


@app.task(base=SqlAlchemyTask)
def do_did_disconnect():
    log.info('start do_did_disconnect ')
    now = datetime.now()
    q = DidDisconnectTask.filter(and_(DidDisconnectTask.release_on_time < now,
                                      DidDisconnectTask.started_at.is_(None))).first()
    if q:
        did_disconnect.delay(q.id)
    log.info('finish do_did_disconnect ')




import re

PHONE_REGEXP = r'^\+?[0-9]+$'


@app.task(base=SqlAlchemyTask, time_limit=288000, soft_time_limit=287400)
def did_disconnect(id):
    log.info('start did_disconnect {}'.format(id))
    tsk = DidDisconnectTask.get(id)
    ret = []
    if tsk and tsk.started_at is None and 'items' in tsk.data:
        items = tsk.data['items']
        try:
            tsk.started_at = datetime.now(UTC)
            tsk.save()
            for did_item in items:

                number = unprefix_2(did_item['number'])
                did_number = unprefix(did_item['number'])
                cls = model.DidBillingRel
                did = model.DidBillingRel.filter(
                    and_(or_(cls.did == number, cls.did == did_number, cls.did == did_item['number']), cls.end_date.is_(None)
                         )).first()
                if did is None:
                    ret.append(dict(number=number, status='error', error='no such did', vendor_id=None))
                    continue
                vendor_api = None
                if did.vendor_res_id and did.vendor_res:
                    vendor_id = did.vendor_res.client_id
                    vendor_api = model.DidVendor.get(vendor_id)
                if vendor_api and vendor_api.api_enabled:
                    try:
                        api = vendor_api.get_api()
                        if did.is_toll_free:
                            r = api.disconnect_toll_free(items=[dict(number=number)])[0]
                        else:
                            r = api.disconnect_local(items=[dict(number=number)])[0]
                    except Exception as e:
                        r = dict(number=number, status='success', error=str(e), vendor_id=vendor_id)
                    if did.end_date:
                        r['warning'] = "did was already ended {}".format(did.end_date)
                    ret.append(r)
                else:
                    r = dict(number=number, status='success', error='number not managed by any vendor', vendor_id=None)
                    if did.end_date:
                        r['warning'] = "did was already ended {}".format(did.end_date)
                    ret.append(r)
            ret = set_prefix(ret)

            for item in ret:
                try:
                    if item['status'] == 'success':
                        obj = model.DidBillingRel.did_billing_rel_disconnect(
                            unprefix(item['number']), None,
                            vendor_id=item['vendor_id'] if 'vendor_id' in item else None, user_name=tsk.operator_user)
                        # obj.save()
                        item['dnl_status'] = 'success'
                except Exception as e:
                    item['dnl_status'] = str(e)

            log.debug('ret:{}'.format(str(ret)[0:4096]))
            tsk.finished_at = datetime.utcnow()
            tsk.reply = {"result_items": ret}
            succ = 0
            err = 0
            for item in ret:
                if item['status'] == 'success':
                    succ += 1
                else:
                    err += 1
            if err == 0:
                tsk.success = True
            tsk.success_count = succ
            tsk.error_count = err
            tsk.save()
        except Exception as e:
            tsk.finished_at = datetime.now(UTC)
            tsk.reply = {'error': str(e)}
            tsk.success = False
            tsk.success_count = 0
            tsk.error_count = 1  # len(items)
            tsk.save()
            import traceback
            log.error('Import failure: {}'.format(str(traceback.format_exc())))
    else:
        log.info('skip already running did_disconnect {}'.format(id))

    log.info('finish did_disconnect {}'.format(id))
