import celery
from api_dnl import settings
from datetime import date,datetime,timedelta
from pytz import UTC
from time import mktime
import io,csv,gzip,zipfile
import xlwt
import json
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select,alias,case
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import PcapQuery,CdrReportDetail,client_cdr,ClientCdr
from api_dnl.model import PrimaryKeyConstraint,func,query_to_sting,cast
from api_dnl.tasks import app,log,db,SqlAlchemyTask,SchLog
from api_dnl import model
#old
from os.path import exists, join, basename, dirname
import re
import os
import subprocess
from time import sleep, mktime
from shutil import copy, move
from ftplib import FTP
import paramiko
from api_dnl.utils.snippets import Application, compare_file_vs_hash

@app.task(base=SqlAlchemyTask)
def do_pcap_parser():
    if settings.PCAP_STORAGE_TYPE == "gcs":
        import gcs_worker
        app.GCSWorker = gcs_worker.GCSWorker(settings.GOOGLE_DRIVE['client_secret_file'], log)
    log.debug('Start pcap parser!')
    for pcap in PcapQuery.filter(PcapQuery.status=='initial').all():
        #print('start',ad.id)
        if __name__ == '__main__':
            pcap_parser(pcap.query_key)
        else:
            pcap_parser.delay(pcap.query_key)

@app.task(base=SqlAlchemyTask)
def pcap_parser(query_key):
    #log = pcap_parser.get_logger()
    slog = SchLog('pcap_parser')
    try:
        pq=PcapQuery.get(query_key)
        print(pq)

        try:
            if (not pq.start or not pq.finish or not pq.callid or not pq.switch_ip):
                raise ValueError
            start = int(pq.start.timestamp())-settings.PCAP_DURATION_MARGIN
            finish = int(pq.finish.timestamp())+settings.PCAP_DURATION_MARGIN
        except ValueError:
            log.error('Wrong query parameters, query aborted.')
            pq.set_query_status('wrong parameters')
            return False
        pq.set_query_status('progress')
        downloaded_filenames = []
        if settings.PCAP_STORAGE_TYPE == "ftp":
            pcapshash_list = ftpget_remote_pcaphash_names(settings.PCAP_FTP_HOST,
                                                          settings.PCAP_FTP_PORT, settings.PCAP_FTP_USER, settings.PCAP_FTP_PASS,
                                                          settings.PCAP_STORAGE_DIR, pq.switch_ip, start, finish)
            downloaded_filenames = ftpdownload_newhashed(settings.PCAP_FTP_HOST,
                                                         settings.PCAP_FTP_PORT, settings.PCAP_FTP_USER, settings.PCAP_FTP_PASS,
                                                         pcapshash_list, settings.PCAP_PCAP_DIR, settings.PCAP_STORAGE_DIR)
        if settings.PCAP_STORAGE_TYPE == "sftp":
            if settings.PCAP_SFTP_SUPPORT == 'enabled':
                pcapshash_list = sftpget_remote_pcaphash_names(
                    settings.PCAP_FTP_HOST, settings.PCAP_FTP_PORT, settings.PCAP_FTP_USER,
                    settings.PCAP_FTP_PASS, settings.PCAP_STORAGE_DIR,
                    pq.switch_ip, start, finish)
                downloaded_filenames = sftpdownload_newhashed(
                    settings.PCAP_FTP_HOST, settings.PCAP_FTP_PORT, settings.PCAP_FTP_USER,
                    settings.PCAP_FTP_PASS, pcapshash_list,
                    settings.PCAP_PCAP_DIR, settings.PCAP_STORAGE_DIR)
            else:
                log.error("could not use sftp storage due no \'"
                             "settings.PCAP_SFTP_SUPPORT = enabled\' in config")
        if settings.PCAP_STORAGE_TYPE == "local":
            pcapshash_list = get_local_pcaphash_names(settings.PCAP_STORAGE_DIR,
                                                      pq.switch_ip, start, finish)
            downloaded_filenames = copy_newhashed(pcapshash_list,
                                                  settings.PCAP_PCAP_DIR, settings.PCAP_STORAGE_DIR)
        if settings.PCAP_STORAGE_TYPE == "gcs":
            if settings.PCAP_GCS_SUPPORT == 'enabled':
                pcapshash_list = get_gcs_pcaphash_names(settings.PCAP_STORAGE_DIR,
                                                        pq.switch_ip, start, finish)
                downloaded_filenames = gcsdownload_newhashed(
                    pcapshash_list, settings.PCAP_PCAP_DIR, settings.PCAP_STORAGE_DIR)
            else:
                log.error("could not use GCS due "
                             "no \'settings.PCAP_GCS_SUPPORT = enabled\' in config")
        pcaps_lzma = get_pcap_names(pq.switch_ip, start, finish)
        syncro = True
        actual_number_lzma = 0
        for pcap_lzma in list(pcaps_lzma.keys()):
            log.debug("pcap lzma file name is " + pcap_lzma)
            """Yaroslav #join_pcap_from_lzma(pcap_lzma, full_pcap_file)"""
            if not pcaps_lzma[pcap_lzma] == 60:
                syncro = False
                log.debug("syncro set {} for pcap lzma file name {}:"
                             " {} sec.".format(syncro, pcap_lzma,
                                               pcaps_lzma[pcap_lzma]))
            actual_number_lzma += 1
        if actual_number_lzma == 0:
            """Nothing to merge"""
            clean_tmp(downloaded_filenames)
            pq.set_query_status('not found')
            return False
        full_pcap_file = settings.PCAP_STAGING_DIR + query_key + ".fpcap"
        log.debug("full pcap file name is " + full_pcap_file)
        if os.path.isfile(full_pcap_file):
            os.remove(full_pcap_file)
        mergecap_from_lzma(list(pcaps_lzma.keys()), settings.PCAP_STAGING_DIR,
                           full_pcap_file, query_key)
        if not os.path.isfile(full_pcap_file):
            clean_tmp(downloaded_filenames)
            pq.set_query_status('file error')
            return False
        filtered_pcap_file = settings.PCAP_STAGING_DIR + query_key + ".pcap"
        if os.path.isfile(filtered_pcap_file):
            os.remove(filtered_pcap_file)
            log.debug("Removed temporary file {}.".format(
                filtered_pcap_file))
        if check_callid_in_pcap(full_pcap_file, pq.callid):
            extract_callid_from_pcap(full_pcap_file, filtered_pcap_file,
                                     pq.callid)
            os.remove(full_pcap_file)
            log.debug("Removed temporary file {}.".format(
                full_pcap_file))
        else:
            os.remove(full_pcap_file)
            log.debug("Removed temporary file {}.".format(
                full_pcap_file))
            clean_tmp(downloaded_filenames)
            if syncro:
                pq.set_query_status('no call id')
            else:
                pq.set_query_status('no call id', 'No call id in PCAP and probably'
                                           ' some parts are missed in storage, abort query.')
            return False
        # final_directory = web_private_dir+str(token_id)
        # final_pcap_file = final_directory + "/" + str(q_id) + query_key + ".pcap"
        # if not exists(final_directory): os.makedirs(final_directory)
        final_pub_directory = settings.PCAP_WEB_PUBLIC_DIR#.replace('~',os.environ.get('HOME',''))
        q_id=''
        final_pub_pcap_file = final_pub_directory + "/" + str(q_id) + query_key + ".pcap"
        if not exists(settings.PCAP_WEB_PUBLIC_DIR): os.makedirs(settings.PCAP_WEB_PUBLIC_DIR)
        if not os.path.isfile(filtered_pcap_file):
            clean_tmp(downloaded_filenames)
            pq.set_query_status('no call id', 'Can not create filtered pcap in '
                                       'staging due to unknown reason (but have all for that)'
                                       '. Abort query.')
            return False
        log.debug("copying from filtered_pcap_file {} to "
                     "final_pub_pcap_file {}".format(filtered_pcap_file,
                                                     final_pub_pcap_file))
        move(filtered_pcap_file, final_pub_pcap_file)
        if not os.path.isfile(final_pub_pcap_file):
            clean_tmp(downloaded_filenames)
            pq.set_query_status('can not copy')
            return False
        else:
            clean_tmp(downloaded_filenames)
            # URL update
            #public_url = "http://" + settings.PCAP_WEB_PUBLIC_URL + str(q_id) + query_key + ".pcap"
            public_url = settings.API_SCHEME + settings.API_HOST+ settings.API_BASE_PATH+'/tool/pcap/download/'  + query_key
            if syncro:
                pq.set_query_status('success' ,'', public_url)
            else:
                pq.set_query_status('success', 'The filtered pcap result file '
                                           'is ready. But it looks that some parts are '
                                           'missing.', public_url)
            #pq.set_query_status('success')
    except Exception as e:
        log.error('PcapQuery query_key={} error:{}'.format(id,str(e)))
        db.session.rollback()
        pq=PcapQuery.get(query_key)
        if pq:
            pq.set_query_status('unknown error')
    slog.close()
    return True

#
def test_directory(directory):
    # ls -l /proc/$PID/fd  | grep pcap
    try:
        test_file = open(directory+"/.test", 'w')
        test_file.write("0\n")
        test_file.close()
        os.remove(directory+"/.test")
        log.debug("directory " + directory + " is ok to work")
    except IOError:
        log.error("cannot create test file in directory " + directory)
        try:
            os.mkdir(directory)
            log.info("created new directory " + directory)
        except:
            log.error("cannot create test file in directory " + directory)
            return ""
        try:
            test_file = open(directory+"/.test", 'w')
            test_file.write("0\n")
            test_file.close()
            os.remove(directory+"/.test")
            log.debug("directory " + directory + " is ok to work")
        except IOError:
            log.error("directiry still not ok" + directory)
            return ""
    return ""



def ftpget_remote_pcaphash_names(ftp_ip,ftp_port,ftp_login,ftp_pass,ftp_root,
            sw_ip,start,finish):
    start_date = str(date.fromtimestamp(start))
    finish_date = str(date.fromtimestamp(finish))
    start_date_list = start_date.split("-")
    finish_date_list = finish_date.split("-")
    start_year = start_date_list[0]
    start_month = start_date_list[1]
    start_day = start_date_list[2]
    finish_year = finish_date_list[0]
    finish_month = finish_date_list[1]
    finish_day = finish_date_list[2]
    days = 1
    result = []
    if finish_day != start_day: days = 2
    ftp_dir=''
    try:
        ftp = FTP()
        ftp.connect(ftp_ip,int(ftp_port))
        log.debug("connecting to target ftp://"+ftp_login+":password@"
                +ftp_ip+":"+ftp_port+"/")
        ftp.login(ftp_login,ftp_pass)
        ftp_dir = (ftp_root+"/"+sw_ip+"/"+start_year+"/"+start_month+"/"
                +start_day+"/")
        log.debug("making cwd to ftp_dir : "+ftp_dir)
        ftp.cwd("/")
        ftp.cwd(ftp_dir)
        log.debug("cwd ok, making ftp.nlst for "+ftp_dir)
        start_fnames = ftp.nlst("*.pcap.lzma.hash")
        #ftp.quit()
    except Exception as e:
        log.error("can't access to ftp " + ftp_dir + " error" + str(e))
        return result
    ftp_dir_2=''
    if days == 2:
        try:
            ftp_dir_2 = (ftp_root+"/"+sw_ip+"/"+finish_year+"/"
                    +finish_month+"/"+finish_day+"/")
            ftp.cwd("/")
            ftp.cwd(ftp_dir_2)
            finish_fnames = ftp.nlst()
            ftp.quit()
        except Exception as e:
            log.error("can't access to ftp " + ftp_dir_2
                    + " error" + str(e))
            return result
    #ftp.quit()
    if days == 1:
        log.debug("full names are : "+str(start_fnames))
        log.debug("searching from : "+str(int(start))+".pcap.lzma.hash to "
                +str(int(finish))+".pcap.lzma.hash")
        for name in start_fnames:
            if (name >= str(int(start))+".pcap.lzma.hash"
                    and name <= str(int(finish))+".pcap.lzma.hash"):
                result.append("/"+sw_ip+"/"+start_year+"/"+start_month+"/"
                        +start_day+"/"+name)
    finish_fnames=''
    if days == 2:
        log.debug("full names are : "+str(start_fnames)+" and "
                +str(finish_fnames))
        log.debug("searching from : "+str(int(start))+".pcap.lzma.hash to "
                +str(int(finish))+".pcap.lzma.hash")
        for name in start_fnames:
            if name >= str(int(start))+".pcap.lzma.hash":
                result.append("/"+sw_ip+"/"+start_year+"/"+start_month+"/"
                        +start_day+"/"+name)
        for name in finish_fnames:
            if name <= str(int(finish))+".pcap.lzma.hash":
                result.append("/"+sw_ip+"/"+finish_year+"/"+finish_month+"/"
                        +finish_day+"/"+name)
    try: ftp.quit()
    except Exception as e:
            log.debug("ftp connection already closed")
    log.debug("result is: "+str(result))
    return result


def sftpget_remote_pcaphash_names(host,port,login,password,storage_root,sw_ip,
            start,finish):
    start_date = str(date.fromtimestamp(start))
    finish_date = str(date.fromtimestamp(finish))
    start_date_list = start_date.split("-")
    finish_date_list = finish_date.split("-")
    start_year = start_date_list[0]
    start_month = start_date_list[1]
    start_day = start_date_list[2]
    finish_year = finish_date_list[0]
    finish_month = finish_date_list[1]
    finish_day = finish_date_list[2]
    days = 1
    result = []
    if finish_day != start_day: days = 2
    try:
        ssh = paramiko.SSHClient()
        ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
        ssh.connect(host,port=int(port),username=login,password=password)
        sftp = ssh.open_sftp()
        #ftp=FTP()
        #ftp.connect(ftp_ip,int(ftp_port))
        log.debug("connecting to target sftp://" + login + ":password@"
                + host + ":" + port + "/")
        #ftp.login(ftp_login,ftp_pass)
        ftp_dir = (storage_root + "/" + sw_ip + "/" + start_year + "/"
                + start_month + "/" + start_day + "/")
        sftp.chdir(ftp_dir)
        start_fnames = sftp.listdir()
    except Exception as e:
        log.error("can't access via sftp to " + storage_root + " error "
                + str(e))
        return result
    if days == 2:
        try:
            ftp_dir_2 = (storage_root+"/"+sw_ip+"/"+finish_year+"/"
                    +finish_month+"/"+finish_day+"/")
            sftp.chdir()
            sftp.chdir(ftp_dir_2)
            finish_fnames = sftp.listdir()
        except Exception as e:
            log.error("can't access via sftp to " + storage_root
                    + " error" + str(e))
    try:
        sftp.close()
        ssh.close()
    except Exception as e:
        log.error("can't close sftp to correctly" + str(e))
    if days == 1:
        for name in start_fnames:
            if (name.endswith(".pcap.lzma.hash")
                    and name >= str(start)+".pcap.lzma.hash"
                    and name <= str(finish)+".pcap.lzma.hash"):
                result.append("/"+sw_ip+"/"+start_year+"/"+start_month+"/"
                        +start_day+"/"+name)
    if days == 2:
        for name in start_fnames:
            if (name.endswith(".pcap.lzma.hash")
                    and name >= str(start)+".pcap.lzma.hash"):
                result.append("/"+sw_ip+"/"+start_year+"/"+start_month+"/"
                        +start_day+"/"+name)
        for name in finish_fnames:
            if (name.endswith(".pcap.lzma.hash")
                    and name <= str(finish)+".pcap.lzma.hash"):
                result.append("/"+sw_ip+"/"+finish_year+"/"+finish_month+"/"
                        +finish_day+"/"+name)
    return result


def get_local_pcaphash_names(local_root,sw_ip,start,finish):
    start_date = str(datetime.fromtimestamp(start,tz=UTC).date()) #str(date.fromtimestamp(start,tz=UTC))
    finish_date = str(datetime.fromtimestamp(finish,tz=UTC).date()) #str(date.fromtimestamp(finish,tz=UTC))
    start_date_list = start_date.split("-")
    finish_date_list = finish_date.split("-")
    start_year = start_date_list[0]
    start_month = start_date_list[1]
    start_day = start_date_list[2]
    finish_year = finish_date_list[0]
    finish_month = finish_date_list[1]
    finish_day = finish_date_list[2]
    days = 1
    local_dir = local_root#os.path.expanduser("~/" + local_root)
    start_dir = local_dir + "/" + sw_ip + "/" + start_year + "/" + start_month + "/" + start_day + "/"
    if finish_day != start_day: days = 2
    finish_dir = local_dir + "/" + sw_ip + "/" + finish_year + "/" + finish_month + "/" + finish_day + "/"
    log.debug("connecting to local target " + local_dir)
    result = []
    if days == 1:
        if not os.path.isdir(start_dir):
            log.error("can't access to " + start_dir)
            return result
        for name in os.listdir(start_dir):
            if (name.endswith(".pcap.lzma.hash")
                    and name >= str(start)+".pcap.lzma.hash"
                    and name <= str(finish)+".pcap.lzma.hash"):
                result.append("/"+sw_ip+"/"+start_year+"/"+start_month+"/"
                        +start_day+"/"+name)
    if days == 2:
        if not os.path.isdir(start_dir):
            log.error("can't access to " + start_dir)
            return result
        if not os.path.isdir(finish_dir):
            log.error("can't access to " + finish_dir)
            return result
        for name in os.listdir(start_dir):
            if (name.endswith(".pcap.lzma.hash")
                    and name >= str(start)+".pcap.lzma.hash"):
                result.append("/"+sw_ip+"/"+start_year+"/"+start_month+"/"
                        +start_day+"/"+name)
        for name in os.listdir(finish_dir):
            if (name.endswith(".pcap.lzma.hash")
                    and name <= str(finish)+".pcap.lzma.hash"):
                result.append("/"+sw_ip+"/"+finish_year+"/"+finish_month+"/"
                        +finish_day+"/"+name)
    return result


def prefix_substring(start, finish):
    """Returns string with same left part of two numbers

    Keyword arguments:
    start -- UTC start integer
    finish -- UTC finish integer

    Usage: prefix_filename_start(1488417213, 1488417277)
    '14884172'
    """
    str_start = str(start)
    str_finish = str(finish)
    pos = 0
    for digit in str_start:
        if digit != str_finish[pos]:
            return str_start[:pos]
        pos = pos + 1



def get_gcs_pcaphash_names(gcs_root,sw_ip,start,finish):
    """Returns list with hashes relative URL GCS like
    192.99.10.113/2017/03/04/1488597597.pcap.lzma.hash

    Keyword arguments:
    gcs_root -- GCS root directory
    sw_ip -- swithch IP
    start -- UTC start integer
    finish -- UTC finish integer

    """
    log.info("get_gcs_pcaphash_names function called with parameters "
            "gcs_root={0}, sw_ip={1}, start={2}, finish={3}".format(
            gcs_root,sw_ip,start,finish))
    start_date = str(date.fromtimestamp(start))
    finish_date = str(date.fromtimestamp(finish))
    start_date_list = start_date.split("-")
    finish_date_list = finish_date.split("-")
    start_year = start_date_list[0]
    start_month = start_date_list[1]
    start_day = start_date_list[2]
    finish_year = finish_date_list[0]
    finish_month = finish_date_list[1]
    finish_day = finish_date_list[2]
    days = 1
    start_dir = "/".join((gcs_root, sw_ip, start_year, start_month, start_day,
            ""))
    log.debug("Going to search pcap hash in dir {0}".format(start_dir))
    if finish_day != start_day:
        days = 2
        finish_dir = "/".join((gcs_root, sw_ip, finish_year, finish_month,
                finish_day, ""))
        log.debug("Going to search pcap hash in finish dir {0}".format(
                finish_dir))
    log.info("get_gcs_pcaphash_names function will check pcap hash names"
            " with parameters start_dir={0}, days={1}, start={2}, finish={3}"
            .format(start_dir, days, start, finish))
    # setup connection
    bucket = app.GCSWorker.get_bucket()

    result = []
    try:
        if days == 1:
            """blobs = bucket.list_blobs(prefix=prefix, delimiter=delimiter)"""
            for gcs_object in bucket.list_blobs(prefix=join(start_dir,
                    prefix_substring(start, finish))):
                log.debug("Found by prefix list_blobs {0}".format(gcs_object))
                name = gcs_object.name
                ext_pos = name.rfind('.pcap.lzma.hash')
                if ext_pos > 0:
                    right_slash_pos = name.rfind('/')
                    if right_slash_pos > 0:
                        log.debug("Walking preselection list of GCS pcap"
                                " hash {}.".format(name))
                        hash_UTC = int(name[right_slash_pos+1:ext_pos])
                        if hash_UTC >= start and hash_UTC <= finish:
                            result.append(name[name.find("/")+1:])
                            log.info("Have appended {} to hash list"
                                    .format(name[name.find("/")+1:]))
                        else:
                            log.debug("Have skipped out of time scope pcap "
                                    "file:{}.".format(hash_UTC))
        if days == 2:
            for gcs_object in bucket.list_blobs(prefix=join(start_dir,
                    prefix_substring(start, finish))):
                name = gcs_object.name
                ext_pos = name.rfind('.pcap.lzma.hash')
                if ext_pos > 0:
                    right_slash_pos = name.rfind('/')
                    if right_slash_pos > 0:
                        log.debug("Walking preselection list of GCS pcap {}"
                                ".".format(name))
                        hash_UTC = int(name[right_slash_pos+1:ext_pos])
                        if hash_UTC >= start:
                            result.append(name[name.find("/")+1:])
                            log.info("Have appended {} to hash list"
                                    .format(name[name.find("/")+1:]))
                        else:
                            log.debug("Have skipped out of time scope pcap "
                                    "file:{}.".format(hash_UTC))
            for gcs_object in bucket.list_blobs(prefix=join(finish_dir,
                    prefix_substring(start, finish))):
                name = gcs_object.name
                ext_pos = name.rfind('.pcap.lzma.hash')
                if ext_pos > 0:
                    right_slash_pos = name.rfind('/')
                    if right_slash_pos > 0:
                        log.debug("Walking preselection list of GCS pcap {}"
                                ".".format(name))
                        hash_UTC = int(name[right_slash_pos+1:ext_pos])
                        if hash_UTC <= finish:
                            result.append(name[name.find("/")+1:])
                            log.info("Have appended {} to hash list"
                                    .format(name[name.find("/")+1:]))
                        else:
                            log.debug("Have skipped out of time scope pcap "
                                    "file:{}.".format(hash_UTC))
    except Exception as e:
        log.error("Coudn't get list of hash in GCS: {}".format(e))
        return
    return result


def ftpdownload_newhashed(host,port,login,pswd,remhashlist,localdir,ftpdir):
    """Downloads pcap and hash from FTP. Returns downloaded_filenames list.

    Keyword arguments:
    host -- FTP hostname
    port -- FTP port
    login -- login
    pswd -- password
    remhashlist -- list with hashes relative URL.
    ftpdir -- FTP storage directory
    localdir -- directory to put pcap and hash
    """
    downloaded_filenames = []
    if not remhashlist:
        return downloaded_filenames
    for remhash in remhashlist:
        pcap = basename(remhash[0:remhash.find(".pcap.lzma.hash")])
        if pcap.isdigit() and len(pcap) == 10 and not exists(localdir+remhash):
            pcap_name = pcap + ".pcap.lzma"
            try:
                ftp = FTP()
                ftp.connect(host,int(port))
                if not exists(dirname(localdir+remhash)): os.makedirs(dirname(localdir+remhash))
                log.debug("connecting to target ftp://"+login+":password@"+host+"/")
                log.debug("downloading new files "+ftpdir+remhash + " and "+pcap_name+" to local storage "+dirname(localdir+remhash))
                ftp.login(login,pswd)
                ftp.cwd(dirname(ftpdir+remhash))
                #os.makedirs();
                ftpfile = open(dirname(localdir+remhash)+"/"+pcap_name, 'wb')
                ftp.retrbinary('RETR ' + pcap_name, ftpfile.write)
                ftpfile.close()
                downloaded_filenames.append("/".join((dirname(localdir+remhash), pcap_name)))
                #ftp.quit()
                ftpfile = open(localdir+remhash, 'wb')
                ftp.retrbinary('RETR ' + basename(ftpdir+remhash), ftpfile.write)
                ftpfile.close()
                downloaded_filenames.append("".join((localdir, remhash)))
                ftp.quit()
                log.debug("loading ok")
            except Exception as e:
                log.error("can't load file from ftp , error " + str(e))
    return downloaded_filenames


def sftpdownload_newhashed(host,port,login,password,remhashlist,localdir,ftpdir):
    """Downloads pcap and hash from SFTP. Returns downloaded_filenames list.

    Keyword arguments:
    host -- SFTP hostname
    port -- SFTP port
    login -- login
    password -- password
    remhashlist -- list with hashes relative URL.
    ftpdir -- SFTP storage directory
    localdir -- directory to put pcap and hash
    """
    downloaded_filenames = []
    if not remhashlist:
        return downloaded_filenames
    try:
        ssh = paramiko.SSHClient()
        ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
        log.debug("connecting to target sftp://"+login+":password@"+host+":"+port+"/")
        ssh.connect(host,port=int(port),username=login,password=password)
        sftp = ssh.open_sftp()
    except Exception as e:
        log.error("can't connect to sftp , error " + str(e))
        #sftp.close()
        #ssh.close()
        return downloaded_filenames
    for remhash in remhashlist:
        pcap = basename(remhash[0:remhash.find(".pcap.lzma.hash")])
        if pcap.isdigit() and len(pcap) == 10 and not exists(localdir+remhash):
            pcap_name = pcap + ".pcap.lzma"
            try:
                if not exists(dirname(localdir+remhash)): os.makedirs(dirname(localdir+remhash))
                log.debug("downloading new files "+ftpdir+remhash + " and "+pcap_name+" to local storage "+dirname(localdir+remhash))
                sftp.chdir()
                sftp.chdir(ftpdir+"/"+dirname(remhash))
                sftp.get(pcap_name,dirname(localdir+remhash)+"/"+pcap_name)
                downloaded_filenames.append("/".join((dirname(localdir+remhash),
                        pcap_name)))
                sftp.get(basename(ftpdir+remhash),localdir+remhash)
                downloaded_filenames.append("".join((localdir, remhash)))
                log.debug("loading ok")
            except Exception as e:
                log.error("can't load file from sftp , error " + str(e))
    try:
        sftp.close()
        ssh.close()
    except Exception as e:
        log.error("can't close sftp correctly, error " + str(e))
    return downloaded_filenames


def copy_newhashed(hashlist,localdir,storagedir):
    """Copy pcap and hash from local storage. Returns downloaded_filenames list.

    Keyword arguments:
    hashlist -- list with hashes relative URL.
    localdir -- local storage directory
    storagedir -- directory to put pcap and hash
    """
    downloaded_filenames = []
    if not hashlist:
        return downloaded_filenames
    for lochash in hashlist:
        log.debug("locahash " + lochash)
        pcap = basename(lochash[0:lochash.find(".pcap.lzma.hash")])
        if pcap.isdigit() and len(pcap) == 10 and not exists(localdir + lochash):
            pcap_name = pcap + ".pcap.lzma"
            locpcap = dirname(lochash) + "/" + pcap_name
            full_storage_dir = storagedir #os.path.expanduser("~/" + storagedir)
            try:
                if not exists(dirname(localdir+lochash)): os.makedirs(dirname(localdir+lochash))
                log.debug("copying files " + full_storage_dir + "/" + locpcap + " to local temporary place " + localdir + "/" + locpcap)
                copy(full_storage_dir + "/" + locpcap, localdir + "/" + locpcap)
                downloaded_filenames.append("/".join((localdir, locpcap)))
                log.debug("copying files " + full_storage_dir + "/" + lochash + " to local temporary place " + localdir + "/" + lochash)
                copy(full_storage_dir + "/" + lochash, localdir + "/" + lochash)
                downloaded_filenames.append("/".join((localdir, lochash)))
                log.debug("loading ok")
            except Exception as e:
                log.error("can't load file from local storage , error " + str(e))
    return downloaded_filenames


def gcsdownload_newhashed(remhashlist,localdir,storagedir):
    """Downloads pcap and hash from GCS. Returns downloaded_filenames list.

    Keyword arguments:
    remhashlist -- list with hashes GCS bucket relative URL.
    storagedir -- GCS bucket root storage directory
    localdir -- directory to put pcap and hash from GCS
    """
    downloaded_filenames = []
    if not remhashlist:
        return downloaded_filenames
    """Catching connect exception is pointless, because operations can
    not proceed anyway. It is really critical."""
    bucket = app.GCSWorker.get_bucket()

    for lochash in remhashlist:
        pcap = basename(lochash[0:lochash.find(".pcap.lzma.hash")])
        if not (pcap.isdigit() and len(pcap) == 10):
           continue
        pcap_name = pcap + ".pcap.lzma"
        locpcap = join(dirname(lochash),pcap_name)
        local = join(localdir,locpcap)
        local_hash = join(localdir,lochash)
        if (exists(local) and exists(local_hash)):
            if compare_file_vs_hash(local,local_hash):
                """Good local file."""
                continue
        remote = join(storagedir,locpcap)
        remote_hash = join(storagedir,lochash)

        if not exists(dirname(localdir+lochash)):
            os.makedirs(dirname(localdir+lochash))
        log.debug("Copying the remote file {} to the local temporary "
                "place {}.".format(remote,local))
        if app.GCSWorker.download_file(remote,local,bucket):
            downloaded_filenames.append(local)
        log.debug("Copying the remote file {} to the local temporary "
                "place {}.".format(remote_hash,local_hash))
        if app.GCSWorker.download_file(remote_hash,local_hash,bucket):
            downloaded_filenames.append(local_hash)
    return downloaded_filenames


def get_pcap_names(ip,start,finish):
    """Checking what files we have for IP and timestamps and returns list.

        :param ip: Voice switch ip for file path.
        :param start: Call start time UTC timestamp integer.
        :param finish: Call finish time UTC timestamp integer.
        :return (start, finish): List of pcap.lzma files to merge.

        Look among local files in path `settings.PCAP_PCAP_DIR`/`ip` for
        timestamp.pcap.lzma with timestamp between start and finish.

    """
    duration_sec = finish - start
    timer_sec = 0
    timer_previous = 0
    pcaps_existed = {}
    log.debug("Checking what files we have for IP {} and timestamps and "
            "returns list. start {}, finish {}, duration_sec {}.".format(ip,
            start,finish, duration_sec))
    while timer_sec <= duration_sec:
        timer_stamp = start + timer_sec
        timer_date = str(datetime.fromtimestamp(timer_stamp,tz=UTC).date())# str(date.fromtimestamp(timer_stamp))
        timer_date_list = timer_date.split("-")
        timer_year = timer_date_list[0]
        timer_month = timer_date_list[1]
        timer_day = timer_date_list[2]
        name_generated = join(settings.PCAP_PCAP_DIR, ip, timer_year, timer_month, timer_day,
                "{}.pcap.lzma".format(timer_stamp))
        if os.path.isfile(name_generated):
            if not timer_previous:
                timer_delta = 60
            else:
                timer_delta = timer_sec - timer_previous
            pcaps_existed[name_generated] = timer_delta
            timer_previous = timer_sec
            log.debug("pcap in processing dictionary {}: {} sec.".format(
                    name_generated, timer_delta))
        timer_sec += 1
    return pcaps_existed


def join_pcap_from_lzma(arch_name,target_name):
    """Unarch with settings.PCAP_LZCAT and add to pcap.
    """
    cmd = settings.PCAP_LZCAT + " " + arch_name + ">>" + target_name
    log.debug(cmd)
    result = subprocess.Popen(cmd,shell=True,stdout=subprocess.PIPE,
            universal_newlines=True)
    result_str = result.communicate()[0]
    log.debug(result_str)
    return result_str


def check_callid_in_pcap(file_name,call_id):
#    sleep(0.1)
    cmd = "cat " + file_name + " | grep -c  \"Call-ID: " + call_id + "\""
    log.debug(cmd)
    result = subprocess.Popen(cmd,shell=True,stdout=subprocess.PIPE,
            universal_newlines=True)
    result_str = result.communicate()[0]
    log.debug(result_str)
    result_str = re.findall(r'\d+',result_str)[0]
    if result_str.isdigit():
        return int(result_str)

def extract_callid_from_pcap(filename,extract_filename,call_id):
    """Unarhive file, filter call_id packets and store.
    """
#    sleep(1)
    #cmd = "ngrep -I " + filename + " -q \"Call-ID: " + call_id + "\" -O " + extract_filename
    cmd = settings.PCAP_TSHARK + " -r " + filename + " -Y 'sip.Call-ID == \"" + call_id + "\"\'  -w " + extract_filename
    log.debug(cmd)
    result = subprocess.Popen(cmd,shell=True,stdout=subprocess.PIPE,
            universal_newlines=True)
    result_str = result.communicate()[0]
    log.debug(result_str)
#    result_str = re.findall(r'\d+',result_str)[0]
#    sleep(1)
    if result_str.isdigit():
        return int(result_str)

def mergecap_from_lzma(lzma_list,temp_dir,target_file,query_key):
    n = 0
    cmd_unarch = " cd " + temp_dir
    cmd_merge = "  mergecap -w "+target_file + " "
    for pcap_lzma in lzma_list:
        #cmd = settings.PCAP_LZCAT + " " + pcap_lzma + " > " + temp_dir + query_key+"unpacked"+str(n)+".pcap"
        cmd_unarch = cmd_unarch + " ; " + settings.PCAP_LZCAT + " " + pcap_lzma + " > " +\
                     temp_dir + query_key + "unpacked" + str(n) + ".pcap"
        cmd_merge = cmd_merge + " " + query_key + "unpacked" + str(n) + ".pcap"
        if (n%64)==63:
            cmd_merge = cmd_merge + " ; mergecap -w "+target_file + " "
        n = n + 1
    cmd = cmd_unarch + " ; " + cmd_merge
    log.debug(cmd)
    result = subprocess.Popen(cmd,shell=True,stdout=subprocess.PIPE,
            universal_newlines=True)
    result_str = result.communicate()[0]
    log.debug(result_str)
    n = 0
    for pcap_lzma in lzma_list:
        full_temp_dir=temp_dir #.replace('~',os.environ.get('HOME',''))
        os.remove(full_temp_dir + query_key + "unpacked" + str(n) + ".pcap")
        n = n + 1
    return 0


def clean_tmp(downloaded_filenames):
    """Cleans pcap.lzma.hash and pcap.lzma from local tmp dir.
    """
    for file in downloaded_filenames:
        try:
            os.remove(file)
            log.debug("Removed temporary file {}.".format(file))
        except Exception as e:
            log.error("Can not remove temporary file " + file + ". " + str(e))




if __name__ == '__main__':
    import random

    callid = str(random.randint(0, 10000000))
    q=PcapQuery(callid = '60454-10668',start=datetime.now(UTC)-timedelta(hours=6),
                finish=datetime.now(UTC),switch_ip='172.31.1.100')
    q.save()
    print('test pcap query')
    do_pcap_parser()