import csv,io
import json
import xlwt,xlrd
from xmljson import BadgerFish as bf,Parker as X2J,parker as par
from xml.etree.ElementTree import Element,fromstring,tostring
import xml.etree.ElementTree as ET
from xml.dom import minidom

class JsonReader():
    def __init__(self,file):
        d=json.load(file)
        if 'payload' in d:
            d = d['payload']
        if 'items' in d:
            d = d['items']
        else:
            raise Exception('No items array in imported json file')
        self.data=d
        self.current=0

    def __iter__(self):
        return self#.data[self.current]

    def __next__(self):  # Python 3: def __next__(self)
        if self.current >= len(self.data):
            raise StopIteration
        else:
            ret=self.data[self.current]
            self.current += 1
            return ret

class XmlReader():
    def __init__(self,file):
        data=file.read()
        x2j = X2J(xml_fromstring=False, dict_type=dict)
        d = x2j.data(fromstring(data), preserve_root=True)
        if 'xml' in d:
            d=d['xml']
        if 'payload' in d:
            d = d['payload']
        if 'items' in d:
            d = d['items']
        else:
            raise Exception('No items array in imported xml file')
        self.data=d
        self.current=0

    def __iter__(self):
        return self#.data[self.current]

    def __next__(self):  # Python 3: def __next__(self)
        if self.current >= len(self.data):
            raise StopIteration
        else:
            ret=self.data[self.current]
            self.current += 1
            return ret
def prettify(elem):
    """Return a pretty-printed XML string for the Element.
    """
    rough_string = tostring(elem, 'utf-8')
    reparsed = minidom.parseString(rough_string)
    return reparsed.toprettyxml(indent='\t')



def csv2xls(csv_str,name='Excel export sheet'):

    wb = xlwt.Workbook(encoding='utf-8')
    ws = wb.add_sheet(name[:31])
    # Sheet header, first row
    row_num = 0
    font_styleb = xlwt.XFStyle()
    font_styleb.font.bold = True
    font_style = xlwt.XFStyle()
    if isinstance(csv_str,bytes):
        csv_str=csv_str.decode()
    if csv_str[0]=='{':
        data=json.loads(csv_str)
        if 'data' in data:
            data=data['data']
        if 'items' in data:
            data=data['items']
        if len(data):
            for c, col in enumerate(list(data[0].keys())):
                ws.write(0, c, col,font_styleb)
        for r, row in enumerate(data):
            for c, col in enumerate(list(row.values())):
                ws.write(r+1, c, col,font_style)
    else:
        file = io.StringIO(csv_str)
        reader = csv.reader(file)
        row_count=0
        for r, row in enumerate(reader):
            style = font_style if row_count >0 else font_styleb
            for c, col in enumerate(row):
                ws.write(r, c, col,style)
            row_count += 1
    response = io.BytesIO() #StringIO()

    wb.save(response)
    return response.getvalue()

def dict_to_csv(data,fieldnames=None):
    import csv
    import io
    csvfile = io.StringIO()
    if len(data):
        if not fieldnames:
            fieldnames = data[0].keys()
        writer = csv.DictWriter(csvfile, fieldnames=fieldnames)
        writer.writeheader()
        writer.writerows(data)
        return str.encode(csvfile.getvalue())
    else:
        return None


if __name__=='__main__':
    print('hello')
    file = open('example.json','rt')
    r=JsonReader(file)
    for i in r:
        print(i)
    file = open('example.json', 'rt')
    data = json.load(file)
    #result = bf().etree(data=data , root=Element('xml'))

    result = X2J().etree(data=data , root=Element('xml'))
    print(prettify(result))
    file = open('example.xml', 'wt')
    file.write(prettify(result))
    file = open('example.xml', 'rt')
    r = XmlReader(file)
    for i in r:
        print(i)
