"""invoice_task

Revision ID: 86f7dfc88f6d
Revises: e674e300dd2e
Create Date: 2020-10-27 14:24:59.042443

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '86f7dfc88f6d'
down_revision = 'e674e300dd2e'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('invoice_task',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('client_id', sa.Integer(), nullable=True),
    sa.Column('is_auto', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('created_by_user_id', sa.Integer(), nullable=True),
    sa.Column('created_on', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('bill_period_start', sa.Date(), nullable=True),
    sa.Column('bill_period_end', sa.Date(), nullable=True),
    sa.Column('show_acc_summary', sa.Boolean(), server_default=sa.text('true'), nullable=False),
    sa.Column('show_payment_applied', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('show_rec_charge', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('show_non_rec_charge', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('show_usage_charge', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('show_trunk_detail', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('show_daily_summary', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('show_jd_saily_summary', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('show_jd_trunk_detail', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('show_prefix_summary', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('show_code_name_summary', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('show_country_summary', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('show_inbound_summary', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('show_top_100tn_summary', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('enable_email', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('enable_email_with_cdr', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_tax', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('include_scc_charges', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('payment_dur_date', sa.Date(), nullable=True),
    sa.Column('invoice_zone', sa.String(length=20), nullable=True),
    sa.Column('status', api_dnl.migration_types.ChoiceType({}), server_default=sa.text('0'), nullable=False),
    sa.Column('progress', sa.String(length=1024), nullable=True),
    sa.Column('proc_start_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('proc_end_time', sa.DateTime(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.drop_table('manual_invoice_task')
    op.drop_table('invoice_summary_ext')
    op.add_column('invoice_summary', sa.Column('invoice_num', sa.String(length=256), nullable=True))
    op.add_column('invoice_summary', sa.Column('json_content', sa.JSON(), nullable=True))
    op.add_column('invoice_summary', sa.Column('port_charges', api_dnl.migration_types.Numeric(length=32, collation=6), server_default=sa.text('0.00'), nullable=False))
    op.add_column('invoice_summary', sa.Column('scc_calls', api_dnl.migration_types.Numeric(length=32, collation=6), server_default=sa.text('0.00'), nullable=False))
    op.add_column('invoice_summary', sa.Column('task_id', sa.Integer(), nullable=True))
    op.create_index(op.f('ix_invoice_summary_invoice_num'), 'invoice_summary', ['invoice_num'], unique=False)
    op.create_foreign_key(None, 'invoice_summary', 'invoice_task', ['task_id'], ['id'], ondelete='CASCADE')
    op.drop_column('invoice_summary', 'include_code_name_details')
    op.drop_column('invoice_summary', 'include_tax')
    op.drop_column('invoice_summary', 'include_trunk_prefix_details')
    op.drop_column('invoice_summary', 'payment_dur_date')
    op.drop_column('invoice_summary', 'include_daily_details')
    op.drop_column('invoice_summary', 'include_country_details')
    op.drop_column('invoice_summary', 'include_scc_charges')
    op.drop_column('invoice_summary', 'invoice_zone')
    op.drop_column('invoice_summary', 'include_trunk_details')
    op.alter_column('rerate_cdr_task', 'create_time',
               existing_type=sa.BIGINT(),
               nullable=True,
               existing_server_default=sa.text("date_part('epoch'::text, ('now'::text)::timestamp(0) with time zone)"))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('rerate_cdr_task', 'create_time',
               existing_type=sa.BIGINT(),
               nullable=False,
               existing_server_default=sa.text("date_part('epoch'::text, ('now'::text)::timestamp(0) with time zone)"))
    op.add_column('invoice_summary', sa.Column('include_trunk_details', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False))
    op.add_column('invoice_summary', sa.Column('invoice_zone', sa.VARCHAR(length=20), autoincrement=False, nullable=True))
    op.add_column('invoice_summary', sa.Column('include_scc_charges', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False))
    op.add_column('invoice_summary', sa.Column('include_country_details', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False))
    op.add_column('invoice_summary', sa.Column('include_daily_details', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False))
    op.add_column('invoice_summary', sa.Column('payment_dur_date', sa.DATE(), autoincrement=False, nullable=True))
    op.add_column('invoice_summary', sa.Column('include_trunk_prefix_details', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False))
    op.add_column('invoice_summary', sa.Column('include_tax', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False))
    op.add_column('invoice_summary', sa.Column('include_code_name_details', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False))
    op.drop_constraint(None, 'invoice_summary', type_='foreignkey')
    op.drop_index(op.f('ix_invoice_summary_invoice_num'), table_name='invoice_summary')
    op.drop_column('invoice_summary', 'task_id')
    op.drop_column('invoice_summary', 'scc_calls')
    op.drop_column('invoice_summary', 'port_charges')
    op.drop_column('invoice_summary', 'json_content')
    op.drop_column('invoice_summary', 'invoice_num')
    op.create_table('invoice_summary_ext',
    sa.Column('invoice_number', sa.INTEGER(), nullable=False),
    sa.Column('scc_calls', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('port_charges', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('invoice_number', name='invoice_summary_ext_pkey')
    )
    op.create_table('manual_invoice_task',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('operator_user', sa.VARCHAR(length=40), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('start_date', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('end_date', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('timezone', sa.VARCHAR(length=20), autoincrement=False, nullable=True),
    sa.Column('include_tax', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('include_scc_charges', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('include_daily_details', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('include_country_details', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('include_code_name_details', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('include_trunk_details', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('include_trunk_prefix_details', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('status', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('invoice_number', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('progress', sa.VARCHAR(length=1024), autoincrement=False, nullable=True),
    sa.Column('proc_start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('proc_end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('create_time', postgresql.TIMESTAMP(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), autoincrement=False, nullable=True),
    sa.Column('include_mrc', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
    sa.Column('due_date', sa.DATE(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['invoice_number'], ['invoice_summary.invoice_number'], name='manual_invoice_task_invoice_number_fkey', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id', name='manual_invoice_task_pkey')
    )
    op.drop_table('invoice_task')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))