"""orig_invoice

Revision ID: f5b24658bc74
Revises: 3cd4084d7f0f
Create Date: 2020-02-25 21:36:51.225389

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = 'f5b24658bc74'
down_revision = '3cd4084d7f0f'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_host_info_time', table_name='host_info')
    op.drop_table('host_info')
    op.add_column('orig_invoice', sa.Column('cdr_file', sa.String(length=255), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('orig_invoice', 'cdr_file')
    op.create_table('host_info',
    sa.Column('time', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('res_id', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('ip_id', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('acd', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('asr', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ca', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('call_count', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('direction', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('call_count_asr', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('pdd', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('ip', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('res_id', 'ip_id', 'time', name='host_info_pkey')
    )
    op.create_index('ix_host_info_time', 'host_info', ['time'], unique=False)
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))