--
-- PostgreSQL database dump
--

-- Dumped from database version 15.13
-- Dumped by pg_dump version 15.13

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: btree_gist; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS btree_gist WITH SCHEMA public;


--
-- Name: EXTENSION btree_gist; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION btree_gist IS 'support for indexing common datatypes in GiST';


--
-- Name: ip4r; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS ip4r WITH SCHEMA public;


--
-- Name: prefix; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS prefix WITH SCHEMA public;


--
-- Name: EXTENSION prefix; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION prefix IS 'Prefix Range module for PostgreSQL';


--
-- Name: uuid-ossp; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS "uuid-ossp" WITH SCHEMA public;


--
-- Name: EXTENSION "uuid-ossp"; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION "uuid-ossp" IS 'generate universally unique identifiers (UUIDs)';


--
-- Name: parser_type; Type: TYPE; Schema: public; Owner: class4_user
--

CREATE TYPE public.parser_type AS ENUM (
    'cdr',
    'pcap'
);


ALTER TYPE public.parser_type OWNER TO class4_user;

--
-- Name: storage_type; Type: TYPE; Schema: public; Owner: class4_user
--

CREATE TYPE public.storage_type AS ENUM (
    'local',
    'ftp',
    'sftp',
    'gcs'
);


ALTER TYPE public.storage_type OWNER TO class4_user;

--
-- Name: class4_trigfun_record_agent_client_client(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_agent_client_client() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.agent_client_client_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.agent_client_client_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.agent_client_client_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.agent_client_client_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_agent_client_client() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_allowed_sendto_ip(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_allowed_sendto_ip() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.allowed_sendto_ip_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.allowed_sendto_ip_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.allowed_sendto_ip_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.allowed_sendto_ip_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_allowed_sendto_ip() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_banned_ip(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_banned_ip() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.banned_ip_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.banned_ip_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.banned_ip_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.banned_ip_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_banned_ip() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_c4_livecall_user(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_c4_livecall_user() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.c4_livecall_user_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.c4_livecall_user_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.c4_livecall_user_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.c4_livecall_user_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_c4_livecall_user() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_c4_lrn(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_c4_lrn() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.c4_lrn_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.c4_lrn_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.c4_lrn_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.c4_lrn_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_c4_lrn() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_c4_shaken_conf(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_c4_shaken_conf() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.c4_shaken_conf_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.c4_shaken_conf_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.c4_shaken_conf_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.c4_shaken_conf_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_c4_shaken_conf() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_c4_shaken_status(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_c4_shaken_status() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.c4_shaken_status_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.c4_shaken_status_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.c4_shaken_status_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.c4_shaken_status_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_c4_shaken_status() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_client(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_client() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.client_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.client_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.client_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.client_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_client() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_code(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_code() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.code_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.code_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.code_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.code_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_code() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_currency(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_currency() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.currency_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.currency_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.currency_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.currency_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_currency() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_currency_updates(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_currency_updates() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.currency_updates_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.currency_updates_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.currency_updates_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.currency_updates_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_currency_updates() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_did_billing_plan(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_did_billing_plan() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.did_billing_plan_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.did_billing_plan_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.did_billing_plan_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.did_billing_plan_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_did_billing_plan() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_did_billing_rel(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_did_billing_rel() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.did_billing_rel_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.did_billing_rel_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.did_billing_rel_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.did_billing_rel_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_did_billing_rel() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_dynamic_route(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_dynamic_route() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.dynamic_route_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.dynamic_route_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.dynamic_route_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.dynamic_route_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_dynamic_route() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_dynamic_route_items(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_dynamic_route_items() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.dynamic_route_items_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.dynamic_route_items_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.dynamic_route_items_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.dynamic_route_items_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_dynamic_route_items() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_dynamic_route_override(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_dynamic_route_override() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.dynamic_route_override_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.dynamic_route_override_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.dynamic_route_override_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.dynamic_route_override_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_dynamic_route_override() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_dynamic_route_pri(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_dynamic_route_pri() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.dynamic_route_pri_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.dynamic_route_pri_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.dynamic_route_pri_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.dynamic_route_pri_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_dynamic_route_pri() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_dynamic_route_qos(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_dynamic_route_qos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.dynamic_route_qos_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.dynamic_route_qos_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.dynamic_route_qos_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.dynamic_route_qos_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_dynamic_route_qos() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_egress_profile(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_egress_profile() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.egress_profile_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.egress_profile_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.egress_profile_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.egress_profile_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_egress_profile() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_global_route_error(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_global_route_error() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.global_route_error_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.global_route_error_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.global_route_error_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.global_route_error_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_global_route_error() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_jurisdiction_prefix(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_jurisdiction_prefix() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.jurisdiction_prefix_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.jurisdiction_prefix_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.jurisdiction_prefix_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.jurisdiction_prefix_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_jurisdiction_prefix() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_ocn_blocklist(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_ocn_blocklist() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.ocn_blocklist_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.ocn_blocklist_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.ocn_blocklist_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.ocn_blocklist_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_ocn_blocklist() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_origination_global_failover(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_origination_global_failover() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.origination_global_failover_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.origination_global_failover_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.origination_global_failover_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.origination_global_failover_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_origination_global_failover() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_partition_gateway_ref(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_partition_gateway_ref() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.partition_gateway_ref_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.partition_gateway_ref_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.partition_gateway_ref_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.partition_gateway_ref_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_partition_gateway_ref() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_payment_term(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_payment_term() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.payment_term_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.payment_term_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.payment_term_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.payment_term_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_payment_term() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_product(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_product() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.product_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.product_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.product_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.product_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_product() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_product_items(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_product_items() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.product_items_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.product_items_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.product_items_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.product_items_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_product_items() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_product_items_resource(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_product_items_resource() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.product_items_resource_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.product_items_resource_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.product_items_resource_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.product_items_resource_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_product_items_resource() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_product_rout_rate_table(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_product_rout_rate_table() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.product_rout_rate_table_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.product_rout_rate_table_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.product_rout_rate_table_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.product_rout_rate_table_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_product_rout_rate_table() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_random_ani_generation(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_random_ani_generation() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.random_ani_generation_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.random_ani_generation_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.random_ani_generation_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.random_ani_generation_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_random_ani_generation() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_random_ani_group(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_random_ani_group() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.random_ani_group_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.random_ani_group_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.random_ani_group_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.random_ani_group_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_random_ani_group() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_rate(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_rate() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.rate_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.rate_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.rate_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.rate_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_rate() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_rate_table(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_rate_table() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.rate_table_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.rate_table_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.rate_table_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.rate_table_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_rate_table() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_rate_type_override(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_rate_type_override() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.rate_type_override_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.rate_type_override_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.rate_type_override_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.rate_type_override_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_rate_type_override() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_resource(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_resource() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.resource_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.resource_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.resource_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.resource_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_resource() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_resource_block(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_resource_block() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.resource_block_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.resource_block_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.resource_block_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.resource_block_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_resource_block() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_resource_block_items(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_resource_block_items() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.resource_block_items_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.resource_block_items_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.resource_block_items_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.resource_block_items_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_resource_block_items() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_resource_capacity(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_resource_capacity() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.resource_capacity_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.resource_capacity_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.resource_capacity_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.resource_capacity_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_resource_capacity() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_resource_codecs_ref(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_resource_codecs_ref() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.resource_codecs_ref_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.resource_codecs_ref_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.resource_codecs_ref_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.resource_codecs_ref_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_resource_codecs_ref() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_resource_direction(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_resource_direction() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.resource_direction_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.resource_direction_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.resource_direction_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.resource_direction_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_resource_direction() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_resource_ip(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_resource_ip() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.resource_ip_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.resource_ip_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.resource_ip_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.resource_ip_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_resource_ip() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_resource_ip_limit(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_resource_ip_limit() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.resource_ip_limit_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.resource_ip_limit_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.resource_ip_limit_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.resource_ip_limit_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_resource_ip_limit() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_resource_lrn_action(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_resource_lrn_action() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.resource_lrn_action_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.resource_lrn_action_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.resource_lrn_action_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.resource_lrn_action_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_resource_lrn_action() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_resource_next_route_rule(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_resource_next_route_rule() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.resource_next_route_rule_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.resource_next_route_rule_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.resource_next_route_rule_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.resource_next_route_rule_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_resource_next_route_rule() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_resource_prefix(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_resource_prefix() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.resource_prefix_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.resource_prefix_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.resource_prefix_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.resource_prefix_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_resource_prefix() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_resource_replace_action(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_resource_replace_action() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.resource_replace_action_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.resource_replace_action_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.resource_replace_action_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.resource_replace_action_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_resource_replace_action() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_resource_translation_ref(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_resource_translation_ref() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.resource_translation_ref_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.resource_translation_ref_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.resource_translation_ref_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.resource_translation_ref_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_resource_translation_ref() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_route(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_route() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.route_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.route_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.route_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.route_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_route() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_service_charge_items(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_service_charge_items() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.service_charge_items_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.service_charge_items_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.service_charge_items_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.service_charge_items_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_service_charge_items() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_shaken_ani_group_list(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_shaken_ani_group_list() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.shaken_ani_group_list_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.shaken_ani_group_list_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.shaken_ani_group_list_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.shaken_ani_group_list_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_shaken_ani_group_list() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_shaken_ani_group_list_rel(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_shaken_ani_group_list_rel() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.shaken_ani_group_list_rel_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.shaken_ani_group_list_rel_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.shaken_ani_group_list_rel_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.shaken_ani_group_list_rel_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_shaken_ani_group_list_rel() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_shaken_ani_group_rel(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_shaken_ani_group_rel() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.shaken_ani_group_rel_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.shaken_ani_group_rel_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.shaken_ani_group_rel_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.shaken_ani_group_rel_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_shaken_ani_group_rel() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_shaken_sti_sp_conf(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_shaken_sti_sp_conf() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.shaken_sti_sp_conf_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.shaken_sti_sp_conf_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.shaken_sti_sp_conf_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.shaken_sti_sp_conf_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_shaken_sti_sp_conf() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_sip_404_number(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_sip_404_number() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.sip_404_number_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.sip_404_number_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.sip_404_number_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.sip_404_number_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_sip_404_number() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_sip_error_code(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_sip_error_code() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.sip_error_code_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.sip_error_code_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.sip_error_code_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.sip_error_code_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_sip_error_code() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_spam_traffic_ip(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_spam_traffic_ip() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.spam_traffic_ip_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.spam_traffic_ip_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.spam_traffic_ip_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.spam_traffic_ip_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_spam_traffic_ip() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_switch_profile(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_switch_profile() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.switch_profile_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.switch_profile_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.switch_profile_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.switch_profile_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_switch_profile() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_system_configure(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_system_configure() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.system_configure_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.system_configure_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.system_configure_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.system_configure_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_system_configure() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_termination_global_failover(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_termination_global_failover() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.termination_global_failover_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.termination_global_failover_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.termination_global_failover_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.termination_global_failover_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_termination_global_failover() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_time_profile(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_time_profile() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.time_profile_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.time_profile_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.time_profile_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.time_profile_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_time_profile() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_transaction_fee_items(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_transaction_fee_items() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.transaction_fee_items_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.transaction_fee_items_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.transaction_fee_items_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.transaction_fee_items_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_transaction_fee_items() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_translation_item(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_translation_item() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.translation_item_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.translation_item_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.translation_item_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.translation_item_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_translation_item() OWNER TO class4_user;

--
-- Name: class4_trigfun_record_voip_gateway(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.class4_trigfun_record_voip_gateway() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.voip_gateway_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.voip_gateway_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.voip_gateway_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.voip_gateway_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;


ALTER FUNCTION public.class4_trigfun_record_voip_gateway() OWNER TO class4_user;

--
-- Name: process_did_number_upload_task(); Type: FUNCTION; Schema: public; Owner: class4_user
--

CREATE FUNCTION public.process_did_number_upload_task() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
        splited_row varchar[];
        error_count integer;
        success_count integer;
    BEGIN
        --
        -- If operation = update then update import_export_logs_row
        --
        IF (TG_OP = 'UPDATE') THEN
            UPDATE import_export_logs SET finished_time = NEW.end_time, status = NEW.status
            WHERE import_export_logs.id = NEW.import_export_logs_id;

            --
            -- Update uploaded records in import_export_logs when status = success
            --
            IF (NEW.status = 3) THEN

                splited_row = string_to_array(NEW.progress, ',');
                error_count = split_part(splited_row[4], ':', 2)::integer;
                success_count = 0;

                -- Check if progress row has NEW records
                IF (split_part(splited_row[2], ':', 2)::integer > 0) THEN
                    success_count = split_part(splited_row[2], ':', 2)::integer;
                ELSE
                    success_count = split_part(splited_row[3], ':', 2)::integer;
                END IF;

                UPDATE import_export_logs SET (error_row, success_numbers) = (error_count, success_count)
                WHERE import_export_logs.id = NEW.import_export_logs_id;
            ELSEIF (NEW.status = 4) THEN
                UPDATE import_export_logs SET error_file_path = concat(NEW.result_file_path, 'did_upload.log')
                WHERE import_export_logs.id = NEW.import_export_logs_id;
            END IF;

            RETURN NEW;
        END IF;
        RETURN NULL; -- return value for trigger AFTER
    END;
$$;


ALTER FUNCTION public.process_did_number_upload_task() OWNER TO class4_user;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: agent; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.agent (
    agent_id integer NOT NULL,
    agent_name character varying(100) NOT NULL,
    create_on timestamp with time zone NOT NULL,
    email character varying(200) NOT NULL,
    commission numeric(5,2),
    method_type integer NOT NULL,
    frequency_type integer NOT NULL,
    status boolean,
    user_id integer,
    agent_role_id integer,
    update_on timestamp with time zone,
    update_by character varying(100),
    edit_permission boolean DEFAULT true,
    invoice_setting_id bigint,
    mail_sender_id integer,
    mail_template_title character varying(200)
);


ALTER TABLE public.agent OWNER TO class4_user;

--
-- Name: COLUMN agent.method_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.agent.method_type IS '0:By Profit; 1:By  Revenue';


--
-- Name: COLUMN agent.frequency_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.agent.frequency_type IS '0:daily;1:weekly;2:monthly';


--
-- Name: agent_agent_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.agent_agent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.agent_agent_id_seq OWNER TO class4_user;

--
-- Name: agent_agent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.agent_agent_id_seq OWNED BY public.agent.agent_id;


--
-- Name: agent_client_client; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.agent_client_client (
    id integer NOT NULL,
    agent_client_id integer NOT NULL,
    client_id integer NOT NULL,
    commission integer
);


ALTER TABLE public.agent_client_client OWNER TO class4_user;

--
-- Name: agent_client_client_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.agent_client_client_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.agent_client_client_id_seq OWNER TO class4_user;

--
-- Name: agent_client_client_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.agent_client_client_id_seq OWNED BY public.agent_client_client.id;


--
-- Name: agent_client_client_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.agent_client_client_record (
    id integer NOT NULL,
    agent_client_id integer NOT NULL,
    client_id integer NOT NULL,
    commission integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.agent_client_client_record OWNER TO class4_user;

--
-- Name: agent_client_client_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.agent_client_client_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.agent_client_client_record_record_id_seq OWNER TO class4_user;

--
-- Name: agent_client_client_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.agent_client_client_record_record_id_seq OWNED BY public.agent_client_client_record.record_id;


--
-- Name: agent_clients; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.agent_clients (
    id integer NOT NULL,
    agent_id integer NOT NULL,
    client_id integer NOT NULL,
    assigned_on timestamp with time zone DEFAULT now(),
    assigned_by character varying(100),
    method_type smallint DEFAULT 0 NOT NULL,
    commission numeric
);


ALTER TABLE public.agent_clients OWNER TO class4_user;

--
-- Name: agent_clients_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.agent_clients_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.agent_clients_id_seq OWNER TO class4_user;

--
-- Name: agent_clients_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.agent_clients_id_seq OWNED BY public.agent_clients.id;


--
-- Name: agent_commission_history; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.agent_commission_history (
    history_id integer NOT NULL,
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    total_date integer,
    amount numeric,
    agent_id integer,
    create_date date,
    finished boolean
);


ALTER TABLE public.agent_commission_history OWNER TO class4_user;

--
-- Name: agent_commission_history_detail; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.agent_commission_history_detail (
    id integer NOT NULL,
    history_id integer,
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    total_date integer,
    commission numeric,
    client_id integer,
    client_cost numeric
);


ALTER TABLE public.agent_commission_history_detail OWNER TO class4_user;

--
-- Name: agent_commission_history_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.agent_commission_history_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.agent_commission_history_detail_id_seq OWNER TO class4_user;

--
-- Name: agent_commission_history_detail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.agent_commission_history_detail_id_seq OWNED BY public.agent_commission_history_detail.id;


--
-- Name: agent_commission_history_history_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.agent_commission_history_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.agent_commission_history_history_id_seq OWNER TO class4_user;

--
-- Name: agent_commission_history_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.agent_commission_history_history_id_seq OWNED BY public.agent_commission_history.history_id;


--
-- Name: agent_commission_payment; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.agent_commission_payment (
    id integer NOT NULL,
    create_on timestamp with time zone,
    create_by character varying(100),
    amount numeric,
    note text,
    end_time timestamp with time zone,
    start_time timestamp with time zone,
    agent_id integer
);


ALTER TABLE public.agent_commission_payment OWNER TO class4_user;

--
-- Name: agent_commission_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.agent_commission_payment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.agent_commission_payment_id_seq OWNER TO class4_user;

--
-- Name: agent_commission_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.agent_commission_payment_id_seq OWNED BY public.agent_commission_payment.id;


--
-- Name: alembic_version; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.alembic_version (
    version_num character varying(32) NOT NULL
);


ALTER TABLE public.alembic_version OWNER TO class4_user;

--
-- Name: alert_rules; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.alert_rules (
    id integer NOT NULL,
    rule_name character varying(100),
    trunk_type smallint NOT NULL,
    all_trunk boolean NOT NULL,
    include smallint NOT NULL,
    in_codes character varying(500),
    in_code_deck integer,
    in_code_name_id character varying(100),
    exclude smallint,
    ex_code_deck integer,
    ex_code_name_id character varying(100),
    acd character varying(1),
    acd_value double precision,
    asr character varying(1),
    asr_value double precision,
    abr character varying(1),
    abr_value double precision,
    pdd character varying(1),
    pdd_value double precision,
    profitability character varying(1),
    profitability_value double precision,
    revenue character varying(1),
    revenue_value double precision,
    min_call_attempt integer,
    step3_type smallint NOT NULL,
    disable_scope smallint,
    trouble_ticket_sent_to smallint,
    trouble_ticket_sent_from integer,
    trouble_ticket_subject character varying(100),
    trouble_ticket_content text,
    auto_enable_type smallint,
    auto_enable integer,
    execution_schedule smallint,
    specific_minutes integer,
    daily_time smallint,
    weekly_time smallint,
    weekly_value smallint,
    sample_size integer,
    ex_codes character varying(500),
    update_by character varying(100),
    update_at timestamp with time zone,
    last_run_time timestamp with time zone,
    active boolean,
    is_block boolean,
    is_email boolean,
    status boolean,
    monitor_by integer,
    res_id text,
    next_run_time timestamp with time zone,
    sdp_sign integer DEFAULT 0,
    sdp_type integer DEFAULT 0,
    sdp_value integer DEFAULT 0
);


ALTER TABLE public.alert_rules OWNER TO class4_user;

--
-- Name: alert_rules_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.alert_rules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.alert_rules_id_seq OWNER TO class4_user;

--
-- Name: alert_rules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.alert_rules_id_seq OWNED BY public.alert_rules.id;


--
-- Name: alert_rules_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.alert_rules_log (
    id integer NOT NULL,
    alert_rules_id integer,
    create_on timestamp with time zone,
    status integer,
    finish_time timestamp with time zone,
    limit_acd_value real,
    limit_asr_value real,
    limit_abr_value real,
    limit_pdd_value double precision,
    limit_profitability_value real,
    limit_revenue_value real,
    limit_asr character(1),
    limit_abr character(1),
    limit_acd character(1),
    limit_pdd character(1),
    limit_profitability character(1),
    limit_revenue character(1),
    "time" numeric DEFAULT date_part('epoch'::text, ('now'::text)::timestamp(0) with time zone)
);


ALTER TABLE public.alert_rules_log OWNER TO class4_user;

--
-- Name: alert_rules_log_detail; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.alert_rules_log_detail (
    id integer NOT NULL,
    update_at timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    alert_rules_log_id integer,
    resource_id integer,
    code character varying(50),
    asr real,
    abr real,
    acd real,
    pdd real,
    profitability real,
    revenue real,
    system_email_address character varying(100),
    system_email_status boolean,
    partner_email_address character varying(100),
    partner_email_status boolean,
    is_email boolean,
    is_block boolean,
    resource_block_id integer,
    email_type integer,
    "time" numeric DEFAULT date_part('epoch'::text, ('now'::text)::timestamp(0) with time zone)
);


ALTER TABLE public.alert_rules_log_detail OWNER TO class4_user;

--
-- Name: alert_rules_log_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.alert_rules_log_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.alert_rules_log_detail_id_seq OWNER TO class4_user;

--
-- Name: alert_rules_log_detail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.alert_rules_log_detail_id_seq OWNED BY public.alert_rules_log_detail.id;


--
-- Name: alert_rules_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.alert_rules_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.alert_rules_log_id_seq OWNER TO class4_user;

--
-- Name: alert_rules_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.alert_rules_log_id_seq OWNED BY public.alert_rules_log.id;


--
-- Name: allowed_sendto_ip; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.allowed_sendto_ip (
    id integer NOT NULL,
    resource_id integer,
    direction integer,
    sip_profile_ip public.ip4r,
    sip_profile_port integer
);


ALTER TABLE public.allowed_sendto_ip OWNER TO class4_user;

--
-- Name: allowed_sendto_ip_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.allowed_sendto_ip_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.allowed_sendto_ip_id_seq OWNER TO class4_user;

--
-- Name: allowed_sendto_ip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.allowed_sendto_ip_id_seq OWNED BY public.allowed_sendto_ip.id;


--
-- Name: allowed_sendto_ip_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.allowed_sendto_ip_record (
    id integer NOT NULL,
    resource_id integer,
    direction integer,
    sip_profile_ip public.ip4r,
    sip_profile_port integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.allowed_sendto_ip_record OWNER TO class4_user;

--
-- Name: allowed_sendto_ip_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.allowed_sendto_ip_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.allowed_sendto_ip_record_record_id_seq OWNER TO class4_user;

--
-- Name: allowed_sendto_ip_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.allowed_sendto_ip_record_record_id_seq OWNED BY public.allowed_sendto_ip_record.record_id;


--
-- Name: async_ftp_export; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.async_ftp_export (
    request_id character varying(20) NOT NULL,
    job_id bigint NOT NULL,
    username character varying(100),
    status integer DEFAULT 0 NOT NULL,
    err_code integer DEFAULT 0 NOT NULL,
    error_str text,
    "time" timestamp with time zone NOT NULL
);


ALTER TABLE public.async_ftp_export OWNER TO class4_user;

--
-- Name: auth_token; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.auth_token (
    id integer NOT NULL,
    token character varying(200),
    user_name character varying(30),
    start_time timestamp with time zone,
    expired_on timestamp with time zone,
    is_disabled boolean DEFAULT false,
    last_used timestamp with time zone
);


ALTER TABLE public.auth_token OWNER TO class4_user;

--
-- Name: auth_token_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.auth_token_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.auth_token_id_seq OWNER TO class4_user;

--
-- Name: auth_token_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.auth_token_id_seq OWNED BY public.auth_token.id;


--
-- Name: authorization_logs; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.authorization_logs (
    id integer NOT NULL,
    direction integer,
    auth_type integer,
    error_type integer,
    request_ip character varying(100),
    request_port integer,
    username character varying(64),
    authname character varying(64),
    sip_callid character varying(128),
    "time" bigint,
    agent character varying(512),
    referer character varying(512)
);


ALTER TABLE public.authorization_logs OWNER TO class4_user;

--
-- Name: authorization_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.authorization_logs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.authorization_logs_id_seq OWNER TO class4_user;

--
-- Name: authorization_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.authorization_logs_id_seq OWNED BY public.authorization_logs.id;


--
-- Name: auto_rate_import_rule; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.auto_rate_import_rule (
    id integer NOT NULL,
    name character varying(100),
    from_email character varying(100),
    mail_server_ip character varying(100),
    mail_server_password character varying(100),
    create_by character varying(100),
    create_on timestamp with time zone,
    egress_trunk_id integer,
    digits public.prefix_range
);


ALTER TABLE public.auto_rate_import_rule OWNER TO class4_user;

--
-- Name: auto_rate_import_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.auto_rate_import_rule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.auto_rate_import_rule_id_seq OWNER TO class4_user;

--
-- Name: auto_rate_import_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.auto_rate_import_rule_id_seq OWNED BY public.auto_rate_import_rule.id;


--
-- Name: balance_daily_reset_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.balance_daily_reset_task (
    id integer NOT NULL,
    start_time timestamp with time zone,
    reset_balance smallint,
    mutual smallint,
    actual smallint,
    client_id integer,
    status smallint DEFAULT 0,
    finished_time timestamp with time zone,
    create_by character varying(100),
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL,
    did_billing smallint,
    new_amount numeric,
    old_amount numeric
);


ALTER TABLE public.balance_daily_reset_task OWNER TO class4_user;

--
-- Name: COLUMN balance_daily_reset_task.start_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.balance_daily_reset_task.start_time IS 'The start time of balance daily resetting';


--
-- Name: COLUMN balance_daily_reset_task.reset_balance; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.balance_daily_reset_task.reset_balance IS '1 for reset client balance, other for ignore';


--
-- Name: COLUMN balance_daily_reset_task.mutual; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.balance_daily_reset_task.mutual IS '1 for reset mutual balance, other for ignore';


--
-- Name: COLUMN balance_daily_reset_task.actual; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.balance_daily_reset_task.actual IS '1 for reset actual balance, other for ignore';


--
-- Name: COLUMN balance_daily_reset_task.client_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.balance_daily_reset_task.client_id IS '0 for all client, other is the specified client ID';


--
-- Name: COLUMN balance_daily_reset_task.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.balance_daily_reset_task.status IS '0 for initial; 1 for in process, 2 for finished; 3 for error';


--
-- Name: balance_daily_reset_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.balance_daily_reset_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.balance_daily_reset_task_id_seq OWNER TO class4_user;

--
-- Name: balance_daily_reset_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.balance_daily_reset_task_id_seq OWNED BY public.balance_daily_reset_task.id;


--
-- Name: balance_history; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.balance_history (
    id integer NOT NULL,
    date date,
    payment_received numeric(20,5) DEFAULT 0 NOT NULL,
    credit_note_sent numeric(20,5) DEFAULT 0 NOT NULL,
    debit_note_sent numeric(20,5) DEFAULT 0 NOT NULL,
    payment_sent numeric(20,5) DEFAULT 0 NOT NULL,
    credit_note_received numeric(20,5) DEFAULT 0 NOT NULL,
    debit_note_received numeric(20,5) DEFAULT 0 NOT NULL,
    invoice_set numeric(20,5) DEFAULT 0 NOT NULL,
    invoice_received numeric(20,5) DEFAULT 0 NOT NULL,
    mutual_balance numeric(20,5) NOT NULL,
    client_id integer,
    mutual_ingress_balance numeric(20,5) DEFAULT 0 NOT NULL,
    mutual_egress_balance numeric(20,5) DEFAULT 0 NOT NULL
);


ALTER TABLE public.balance_history OWNER TO class4_user;

--
-- Name: balance_history_actual; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.balance_history_actual (
    id integer NOT NULL,
    date date NOT NULL,
    payment_received numeric(20,5) DEFAULT 0 NOT NULL,
    credit_note_sent numeric(20,5) DEFAULT 0 NOT NULL,
    debit_note_sent numeric(20,5) DEFAULT 0 NOT NULL,
    unbilled_incoming_traffic numeric(20,5) DEFAULT 0 NOT NULL,
    short_charges numeric(20,5) DEFAULT 0 NOT NULL,
    payment_sent numeric(20,5) DEFAULT 0 NOT NULL,
    credit_note_received numeric(20,5) DEFAULT 0 NOT NULL,
    debit_note_received numeric(20,5) DEFAULT 0 NOT NULL,
    unbilled_outgoing_traffic numeric(20,5) DEFAULT 0 NOT NULL,
    actual_balance numeric(20,5) NOT NULL,
    client_id integer NOT NULL,
    actual_ingress_balance numeric(20,5) DEFAULT 0 NOT NULL,
    actual_egress_balance numeric(20,5) DEFAULT 0 NOT NULL,
    mrc numeric DEFAULT 0.0 NOT NULL,
    nrc numeric DEFAULT 0.0 NOT NULL,
    port_fee numeric DEFAULT 0.0 NOT NULL,
    sms numeric DEFAULT 0.0 NOT NULL
);


ALTER TABLE public.balance_history_actual OWNER TO class4_user;

--
-- Name: balance_history_actual_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.balance_history_actual_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.balance_history_actual_id_seq OWNER TO class4_user;

--
-- Name: balance_history_actual_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.balance_history_actual_id_seq OWNED BY public.balance_history_actual.id;


--
-- Name: balance_history_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.balance_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.balance_history_id_seq OWNER TO class4_user;

--
-- Name: balance_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.balance_history_id_seq OWNED BY public.balance_history.id;


--
-- Name: balance_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.balance_log (
    id integer NOT NULL,
    client_id integer,
    balance numeric,
    date date,
    egress_balance numeric DEFAULT 0 NOT NULL,
    ingress_balance numeric DEFAULT 0 NOT NULL
);


ALTER TABLE public.balance_log OWNER TO class4_user;

--
-- Name: balance_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.balance_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.balance_log_id_seq OWNER TO class4_user;

--
-- Name: balance_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.balance_log_id_seq OWNED BY public.balance_log.id;


--
-- Name: banned_ip; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.banned_ip (
    ip character varying(30) NOT NULL,
    brief character varying(100),
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone
);


ALTER TABLE public.banned_ip OWNER TO class4_user;

--
-- Name: banned_ip_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.banned_ip_record (
    ip character varying(30) NOT NULL,
    brief character varying(100),
    create_time timestamp with time zone,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.banned_ip_record OWNER TO class4_user;

--
-- Name: banned_ip_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.banned_ip_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.banned_ip_record_record_id_seq OWNER TO class4_user;

--
-- Name: banned_ip_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.banned_ip_record_record_id_seq OWNED BY public.banned_ip_record.record_id;


--
-- Name: block_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.block_log (
    log_id integer NOT NULL,
    block_on timestamp with time zone,
    block_by character varying(100),
    code_detail character varying(500),
    re_enable_time timestamp with time zone,
    asr character varying(100),
    abr character varying(100),
    acd character varying(100),
    pdd character varying(100),
    margin character varying(100),
    re_enable boolean,
    type smallint NOT NULL
);


ALTER TABLE public.block_log OWNER TO class4_user;

--
-- Name: block_log_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.block_log_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.block_log_log_id_seq OWNER TO class4_user;

--
-- Name: block_log_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.block_log_log_id_seq OWNED BY public.block_log.log_id;


--
-- Name: block_number_import_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.block_number_import_task (
    id integer NOT NULL,
    operator_user character varying(40),
    import_file_path character varying(256),
    orig_import_file character varying(256),
    format_import_file character varying(256),
    import_log_path character varying(256),
    redup_in_block_rable_action smallint DEFAULT 0 NOT NULL,
    redup_in_file_action smallint DEFAULT 0 NOT NULL,
    status smallint DEFAULT 0 NOT NULL,
    progress character varying(1024),
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    op_method smallint DEFAULT '0'::smallint NOT NULL
);


ALTER TABLE public.block_number_import_task OWNER TO class4_user;

--
-- Name: block_number_import_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.block_number_import_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.block_number_import_task_id_seq OWNER TO class4_user;

--
-- Name: block_number_import_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.block_number_import_task_id_seq OWNED BY public.block_number_import_task.id;


--
-- Name: c4_client_balance; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.c4_client_balance (
    id integer NOT NULL,
    client_id character varying(100) NOT NULL,
    balance numeric(30,6) DEFAULT 0.00 NOT NULL,
    ingress_balance numeric(30,6) DEFAULT 0.00 NOT NULL,
    egress_balance numeric(30,6) DEFAULT 0.00 NOT NULL,
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL
);


ALTER TABLE public.c4_client_balance OWNER TO class4_user;

--
-- Name: COLUMN c4_client_balance.balance; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.c4_client_balance.balance IS 'current balance';


--
-- Name: COLUMN c4_client_balance.create_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.c4_client_balance.create_time IS 'balance update time';


--
-- Name: c4_client_balance_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.c4_client_balance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.c4_client_balance_id_seq OWNER TO class4_user;

--
-- Name: c4_client_balance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.c4_client_balance_id_seq OWNED BY public.c4_client_balance.id;


--
-- Name: c4_livecall_user; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.c4_livecall_user (
    id integer NOT NULL,
    name character varying(50) NOT NULL,
    password character varying(50) NOT NULL,
    user_type smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.c4_livecall_user OWNER TO class4_user;

--
-- Name: COLUMN c4_livecall_user.user_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.c4_livecall_user.user_type IS '0 for softswitch; 1 for web user';


--
-- Name: c4_livecall_user_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.c4_livecall_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.c4_livecall_user_id_seq OWNER TO class4_user;

--
-- Name: c4_livecall_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.c4_livecall_user_id_seq OWNED BY public.c4_livecall_user.id;


--
-- Name: c4_livecall_user_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.c4_livecall_user_record (
    id integer NOT NULL,
    name character varying(50) NOT NULL,
    password character varying(50) NOT NULL,
    user_type smallint NOT NULL,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.c4_livecall_user_record OWNER TO class4_user;

--
-- Name: c4_livecall_user_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.c4_livecall_user_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.c4_livecall_user_record_record_id_seq OWNER TO class4_user;

--
-- Name: c4_livecall_user_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.c4_livecall_user_record_record_id_seq OWNED BY public.c4_livecall_user_record.record_id;


--
-- Name: c4_lrn; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.c4_lrn (
    id integer NOT NULL,
    srv1_ip character varying(16),
    srv1_port integer DEFAULT 5060 NOT NULL,
    srv2_ip character varying(16),
    srv2_port integer DEFAULT 5060 NOT NULL,
    retry_attempts integer DEFAULT 60,
    timeout integer DEFAULT 60
);


ALTER TABLE public.c4_lrn OWNER TO class4_user;

--
-- Name: COLUMN c4_lrn.srv1_ip; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.c4_lrn.srv1_ip IS 'Master lrn server ip';


--
-- Name: COLUMN c4_lrn.srv2_ip; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.c4_lrn.srv2_ip IS 'Slave lrn server ip';


--
-- Name: c4_lrn_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.c4_lrn_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.c4_lrn_id_seq OWNER TO class4_user;

--
-- Name: c4_lrn_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.c4_lrn_id_seq OWNED BY public.c4_lrn.id;


--
-- Name: c4_lrn_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.c4_lrn_record (
    id integer NOT NULL,
    srv1_ip character varying(16),
    srv1_port integer NOT NULL,
    srv2_ip character varying(16),
    srv2_port integer NOT NULL,
    retry_attempts integer,
    timeout integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.c4_lrn_record OWNER TO class4_user;

--
-- Name: c4_lrn_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.c4_lrn_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.c4_lrn_record_record_id_seq OWNER TO class4_user;

--
-- Name: c4_lrn_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.c4_lrn_record_record_id_seq OWNED BY public.c4_lrn_record.record_id;


--
-- Name: c4_shaken_conf; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.c4_shaken_conf (
    id integer NOT NULL,
    name text,
    is_primary boolean DEFAULT false NOT NULL,
    conn_type character varying(3),
    hostaddr text NOT NULL,
    port integer NOT NULL,
    heartbeat boolean DEFAULT false NOT NULL,
    heartbeat_interval integer,
    type smallint DEFAULT '0'::smallint NOT NULL
);


ALTER TABLE public.c4_shaken_conf OWNER TO class4_user;

--
-- Name: COLUMN c4_shaken_conf.is_primary; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.c4_shaken_conf.is_primary IS 'Whether this is a primary or redundant connection';


--
-- Name: COLUMN c4_shaken_conf.conn_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.c4_shaken_conf.conn_type IS 'tcp / tls / udp';


--
-- Name: COLUMN c4_shaken_conf.heartbeat; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.c4_shaken_conf.heartbeat IS 'Enable heartbeat packet sending';


--
-- Name: COLUMN c4_shaken_conf.heartbeat_interval; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.c4_shaken_conf.heartbeat_interval IS 'How often to send heartbeat packet; Default: every 10 seconds';


--
-- Name: c4_shaken_conf_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.c4_shaken_conf_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.c4_shaken_conf_id_seq OWNER TO class4_user;

--
-- Name: c4_shaken_conf_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.c4_shaken_conf_id_seq OWNED BY public.c4_shaken_conf.id;


--
-- Name: c4_shaken_conf_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.c4_shaken_conf_record (
    id integer NOT NULL,
    name text,
    is_primary boolean NOT NULL,
    conn_type character varying(3),
    hostaddr text NOT NULL,
    port integer NOT NULL,
    heartbeat boolean NOT NULL,
    heartbeat_interval integer,
    type smallint NOT NULL,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.c4_shaken_conf_record OWNER TO class4_user;

--
-- Name: c4_shaken_conf_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.c4_shaken_conf_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.c4_shaken_conf_record_record_id_seq OWNER TO class4_user;

--
-- Name: c4_shaken_conf_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.c4_shaken_conf_record_record_id_seq OWNED BY public.c4_shaken_conf_record.record_id;


--
-- Name: c4_shaken_status; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.c4_shaken_status (
    id bigint NOT NULL,
    name text,
    upd_time timestamp with time zone DEFAULT now(),
    is_primary boolean DEFAULT false NOT NULL,
    is_online boolean DEFAULT false NOT NULL,
    error text
);


ALTER TABLE public.c4_shaken_status OWNER TO class4_user;

--
-- Name: c4_shaken_status_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.c4_shaken_status_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.c4_shaken_status_id_seq OWNER TO class4_user;

--
-- Name: c4_shaken_status_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.c4_shaken_status_id_seq OWNED BY public.c4_shaken_status.id;


--
-- Name: c4_shaken_status_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.c4_shaken_status_record (
    id bigint NOT NULL,
    name text,
    upd_time timestamp with time zone,
    is_primary boolean NOT NULL,
    is_online boolean NOT NULL,
    error text,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.c4_shaken_status_record OWNER TO class4_user;

--
-- Name: c4_shaken_status_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.c4_shaken_status_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.c4_shaken_status_record_record_id_seq OWNER TO class4_user;

--
-- Name: c4_shaken_status_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.c4_shaken_status_record_record_id_seq OWNED BY public.c4_shaken_status_record.record_id;


--
-- Name: c4_us_lerg; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.c4_us_lerg (
    id integer NOT NULL,
    npa character varying(4),
    nxx character varying(4),
    block character varying(4),
    lata character varying(8),
    ocn character varying(8),
    ratecenter character varying(24),
    state character varying(4),
    category character varying(24),
    company character varying(100),
    country character varying(2)
);


ALTER TABLE public.c4_us_lerg OWNER TO class4_user;

--
-- Name: c4_us_lerg_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.c4_us_lerg_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.c4_us_lerg_id_seq OWNER TO class4_user;

--
-- Name: c4_us_lerg_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.c4_us_lerg_id_seq OWNED BY public.c4_us_lerg.id;


--
-- Name: c4db_version; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.c4db_version (
    id integer DEFAULT 1 NOT NULL,
    version_num text NOT NULL,
    tag text,
    CONSTRAINT c4db_version_id_check CHECK ((id = 1))
);


ALTER TABLE public.c4db_version OWNER TO class4_user;

--
-- Name: calling_call; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.calling_call (
    call_id bigint NOT NULL,
    call_uuid character varying(36),
    req_uuid character varying(36),
    start_time timestamp with time zone,
    finish_time timestamp with time zone,
    dst_number character varying(128) NOT NULL,
    track_uuid character varying(36),
    state smallint NOT NULL,
    pdd integer,
    ring_duration integer,
    call_duration integer,
    rbt_packet integer,
    call_packet integer,
    response_code integer,
    result character varying(512),
    rbt_audio_path character varying(256),
    call_audio_path character varying(256),
    sip_pcap_path character varying(256),
    caller_id character varying(128),
    pcap_stat character varying(1024),
    create_by character varying(100)
);


ALTER TABLE public.calling_call OWNER TO class4_user;

--
-- Name: calling_call_call_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.calling_call_call_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.calling_call_call_id_seq OWNER TO class4_user;

--
-- Name: calling_call_call_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.calling_call_call_id_seq OWNED BY public.calling_call.call_id;


--
-- Name: calling_queue; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.calling_queue (
    qid bigint NOT NULL,
    req_uuid character varying(36) NOT NULL,
    call_id bigint NOT NULL
);


ALTER TABLE public.calling_queue OWNER TO class4_user;

--
-- Name: calling_queue_qid_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.calling_queue_qid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.calling_queue_qid_seq OWNER TO class4_user;

--
-- Name: calling_queue_qid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.calling_queue_qid_seq OWNED BY public.calling_queue.qid;


--
-- Name: calling_request; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.calling_request (
    req_uuid character varying(36) NOT NULL,
    req_from_ip character varying(64),
    req_from_port integer,
    start_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL,
    finish_time timestamp with time zone,
    total_call_cnt integer NOT NULL,
    complete_call_cnt integer DEFAULT 0,
    status character varying(64)
);


ALTER TABLE public.calling_request OWNER TO class4_user;

--
-- Name: calling_track; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.calling_track (
    uuid character varying(36) NOT NULL,
    create_by character varying(100),
    create_on timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL,
    orig_file character varying(256)
);


ALTER TABLE public.calling_track OWNER TO class4_user;

--
-- Name: carrier_group; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.carrier_group (
    group_id integer NOT NULL,
    group_name character varying NOT NULL
);


ALTER TABLE public.carrier_group OWNER TO class4_user;

--
-- Name: carrier_group_group_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.carrier_group_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.carrier_group_group_id_seq OWNER TO class4_user;

--
-- Name: carrier_group_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.carrier_group_group_id_seq OWNED BY public.carrier_group.group_id;


--
-- Name: carrier_template; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.carrier_template (
    id integer NOT NULL,
    allowed_credit numeric NOT NULL,
    attach_cdrs_list boolean,
    auto_daily_balance_recipient integer,
    auto_invoice_type integer,
    auto_invoicing boolean,
    auto_send_zone character varying,
    auto_summary_group_by smallint,
    auto_summary_hour integer,
    auto_summary_include_cdr boolean,
    auto_summary_not_zero smallint,
    auto_summary_period integer,
    breakdown_by_rate_table smallint,
    call_limit integer,
    cdr_list_format integer,
    cps_limit integer,
    create_by character varying(100),
    create_on timestamp with time zone,
    currency_id integer,
    daily_balance_notification integer,
    daily_balance_recipient integer,
    daily_balance_send_time time without time zone,
    daily_balance_send_time_zone character varying(20),
    daily_cdr_generation boolean,
    daily_cdr_generation_type smallint,
    daily_cdr_generation_zone character varying,
    daily_limit integer,
    decimal_place integer,
    email_invoice boolean,
    hourly_limit integer,
    include_available_credit smallint,
    include_tax boolean,
    invoice_format integer,
    invoice_include_payment boolean,
    invoice_jurisdictional_detail boolean,
    invoice_show_details boolean,
    invoice_start_from date,
    invoice_use_balance_type integer,
    invoice_zero boolean,
    invoice_zone character varying(10),
    is_auto_balance boolean,
    is_auto_summary boolean,
    is_breakdown_by_rate_table boolean,
    is_daily_balance_notification boolean,
    is_email_invoice boolean,
    is_invoice_account_summary boolean,
    is_send_as_link boolean,
    is_send_trunk_update boolean,
    is_short_duration_call_surcharge_detail boolean,
    is_show_by_date boolean,
    is_show_code_100 boolean,
    is_show_code_name boolean,
    is_show_country boolean,
    is_show_daily_usage boolean,
    is_show_detail_trunk boolean,
    is_show_total_trunk boolean,
    last_invoiced timestamp with time zone,
    mode integer NOT NULL,
    notify_client_balance numeric,
    notify_client_balance_type integer,
    numer_of_days_balance integer,
    payment_term_id integer,
    profit_margin double precision NOT NULL,
    profit_type integer NOT NULL,
    rate_value integer,
    scc_bellow integer,
    scc_charge numeric,
    scc_percent integer,
    scc_type integer,
    tax integer,
    template_name character varying(100),
    update_on timestamp with time zone,
    usage_detail_fields text,
    unlimited_credit boolean,
    test_credit numeric(15,6),
    payment_received_notice boolean
);


ALTER TABLE public.carrier_template OWNER TO class4_user;

--
-- Name: carrier_template_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.carrier_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.carrier_template_id_seq OWNER TO class4_user;

--
-- Name: carrier_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.carrier_template_id_seq OWNED BY public.carrier_template.id;


--
-- Name: carrier_template_low_bal_config; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.carrier_template_low_bal_config (
    carrier_template_id integer NOT NULL,
    is_notify boolean,
    value_type integer,
    actual_notify_balance numeric(30,2),
    percentage_notify_balance numeric(30,2),
    send_time_type integer,
    daily_send_time integer,
    duplicate_days integer,
    send_to integer,
    duplicate_send_days integer DEFAULT 0 NOT NULL,
    last_alert_time timestamp with time zone,
    disable_trunks_days integer DEFAULT 5
);


ALTER TABLE public.carrier_template_low_bal_config OWNER TO class4_user;

--
-- Name: COLUMN carrier_template_low_bal_config.is_notify; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.carrier_template_low_bal_config.is_notify IS '是否检测';


--
-- Name: COLUMN carrier_template_low_bal_config.value_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.carrier_template_low_bal_config.value_type IS '0 =>Actual Balance,1 =>Percentage';


--
-- Name: COLUMN carrier_template_low_bal_config.send_time_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.carrier_template_low_bal_config.send_time_type IS '0 => daily, 1=> hourly';


--
-- Name: COLUMN carrier_template_low_bal_config.daily_send_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.carrier_template_low_bal_config.daily_send_time IS 'if selected daily to choose between 00:00 - 23:00 GMT';


--
-- Name: COLUMN carrier_template_low_bal_config.duplicate_days; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.carrier_template_low_bal_config.duplicate_days IS '重复发送几天';


--
-- Name: COLUMN carrier_template_low_bal_config.send_to; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.carrier_template_low_bal_config.send_to IS '0 => Owner''sBilling Contact,  1 =>  Partner''s Billing Contact,  2 => Both';


--
-- Name: COLUMN carrier_template_low_bal_config.duplicate_send_days; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.carrier_template_low_bal_config.duplicate_send_days IS '已经发送的天数';


--
-- Name: cdr_async_task_job_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.cdr_async_task_job_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cdr_async_task_job_id_seq OWNER TO class4_user;

--
-- Name: cdr_async_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.cdr_async_task (
    request_id character varying(16) NOT NULL,
    fields character varying,
    filter json,
    download_link character varying(512),
    expiration_time integer,
    job_start_time integer,
    job_end_time integer,
    msg character varying(512),
    progress character varying(4),
    count integer,
    size bigint,
    status character varying(32),
    email character varying(512),
    orig_file character varying(512),
    mail_status character varying(512),
    method character varying(32),
    sender_id integer,
    subject character varying(512),
    content text,
    mail_cc character varying(512),
    type smallint DEFAULT '1'::smallint,
    ftp_url character varying(512),
    ftp_port smallint,
    ftp_user character varying(512),
    ftp_password character varying(512),
    ftp_dir character varying(512),
    ftp_file_name character varying(512),
    ftp_max_lines integer,
    ftp_compress character varying(512),
    ftp_include_headers smallint,
    ftp_file_breakdown smallint,
    request_client_id integer,
    job_id integer DEFAULT nextval('public.cdr_async_task_job_id_seq'::regclass),
    user_id integer,
    created_on timestamp with time zone DEFAULT now(),
    do_zip boolean DEFAULT false
);


ALTER TABLE public.cdr_async_task OWNER TO class4_user;

--
-- Name: cdr_download_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.cdr_download_task (
    request_id character varying(16) NOT NULL,
    cached boolean,
    code integer,
    count integer,
    download_link character varying(32),
    end_time integer,
    expiration_time integer,
    job_end_time integer,
    job_start_time integer,
    msg character varying(512),
    progress character varying(4),
    size integer,
    start_time integer,
    status character varying(32),
    email_to character varying(512),
    orig_file character varying(512),
    mail_status character varying(512),
    method character varying(32),
    job_id integer,
    client_id integer,
    content text,
    mail_cc character varying(512),
    sender_id integer,
    subject character varying(512),
    type smallint
);


ALTER TABLE public.cdr_download_task OWNER TO class4_user;

--
-- Name: cdr_export_email_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.cdr_export_email_task (
    id integer NOT NULL,
    email_status smallint DEFAULT '0'::smallint,
    started_on timestamp with time zone,
    finished_on timestamp with time zone,
    email_error text
);


ALTER TABLE public.cdr_export_email_task OWNER TO class4_user;

--
-- Name: cdr_export_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.cdr_export_log (
    id integer NOT NULL,
    export_time timestamp with time zone,
    status integer,
    file_name character varying(500),
    user_id integer,
    is_dipp boolean,
    backend_pid integer,
    cdr_start_time timestamp with time zone,
    cdr_end_time timestamp with time zone,
    sql character varying,
    file_rows integer,
    error_msg text,
    send_mail character varying(200),
    where_sql character varying,
    show_fields_sql character varying,
    total_hours integer,
    finished_hours integer,
    stop_time timestamp with time zone,
    download_cdr_from character varying(200),
    download_cdr_subject text,
    download_cdr_content text,
    download_cdr_cc character varying(200),
    send_type integer,
    total_date integer,
    finished_date integer,
    finished_time timestamp with time zone,
    file_size integer
);


ALTER TABLE public.cdr_export_log OWNER TO class4_user;

--
-- Name: cdr_export_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.cdr_export_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cdr_export_log_id_seq OWNER TO class4_user;

--
-- Name: cdr_export_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.cdr_export_log_id_seq OWNED BY public.cdr_export_log.id;


--
-- Name: cdr_export_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.cdr_export_task (
    id integer NOT NULL,
    operator_user character varying(40),
    export_cdr_file character varying(1024),
    cdr_counts integer DEFAULT 0,
    cdr_start_time timestamp with time zone,
    cdr_end_time timestamp with time zone,
    csv_file_headers character varying(2048),
    cdr_headers character varying(2048),
    cdr_filter character varying(2048),
    status smallint DEFAULT '0'::smallint,
    progress character varying(1024),
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    create_time timestamp with time zone DEFAULT now()
);


ALTER TABLE public.cdr_export_task OWNER TO class4_user;

--
-- Name: cdr_export_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.cdr_export_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cdr_export_task_id_seq OWNER TO class4_user;

--
-- Name: cdr_export_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.cdr_export_task_id_seq OWNED BY public.cdr_export_task.id;


--
-- Name: cdr_report_daily; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.cdr_report_daily (
    id bigint NOT NULL,
    cdr_date character varying NOT NULL,
    report_time timestamp without time zone NOT NULL,
    ingress_client_id integer,
    ingress_id integer,
    egress_client_id integer,
    egress_id integer,
    ingress_code_name character varying,
    egress_code_name character varying,
    ingress_total_calls integer,
    ingress_success_calls integer,
    ingress_busy_calls integer,
    ingress_cancel_calls integer,
    ingress_bill_time integer,
    ingress_bill_time_intra integer,
    ingress_bill_time_inter integer,
    ingress_call_cost real,
    ingress_call_cost_intra real,
    ingress_call_cost_inter real,
    ingress_call_cost_local real,
    ingress_call_cost_ij real,
    ingress_duration integer,
    ingress_duration_6 integer,
    ingress_duration_30 integer,
    ingress_inter_duration integer,
    ingress_intra_duration integer,
    ingress_not_zero_calls integer,
    ingress_not_zero_calls_6 integer,
    ingress_not_zero_calls_30 integer,
    ingress_inter_not_zero_calls integer,
    ingress_intra_not_zero_calls integer,
    ingress_call_12s integer,
    ingress_call_18s integer,
    ingress_call_24s integer,
    ingress_call_2h integer,
    ingress_call_3h integer,
    ingress_call_4h integer,
    egress_total_calls integer,
    egress_success_calls integer,
    egress_busy_calls integer,
    egress_cancel_calls integer,
    egress_bill_time integer,
    egress_bill_time_intra integer,
    egress_bill_time_inter integer,
    egress_call_cost real,
    egress_call_cost_intra real,
    egress_call_cost_inter real,
    egress_call_cost_local real,
    egress_call_cost_ij real,
    duration integer,
    duration_6 integer,
    duration_30 integer,
    inter_duration integer,
    intra_duration integer,
    not_zero_calls integer,
    not_zero_calls_6 integer,
    not_zero_calls_30 integer,
    inter_not_zero_calls integer,
    intra_not_zero_calls integer,
    call_12s integer,
    call_18s integer,
    call_24s integer,
    call_2h integer,
    call_3h integer,
    call_4h integer,
    agent_cost real,
    inter_ingress_total_calls integer,
    intra_ingress_total_calls integer,
    npr_count integer,
    egress_no_ring integer,
    q850_cause_count integer,
    orig_shaken_ocn text,
    orig_shaken_lvl character varying(1),
    term_shaken_ocn text,
    term_shaken_lvl character varying(1),
    ani_in_dno_count integer,
    ani_in_ftc_count integer,
    ani_in_ftc_week_count integer,
    ani_in_ftc_month_count integer,
    ani_in_spam_count integer,
    ani_in_fraud_count integer,
    ani_in_tcpa_count integer,
    dnis_in_dnc_count integer,
    pdd_count bigint,
    origination_remote_payload_ip_address text,
    termination_remote_payload_ip_address text
)
PARTITION BY RANGE (report_time);


ALTER TABLE public.cdr_report_daily OWNER TO class4_user;

--
-- Name: cdr_report_daily_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.cdr_report_daily_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cdr_report_daily_id_seq OWNER TO class4_user;

--
-- Name: cdr_report_daily_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.cdr_report_daily_id_seq OWNED BY public.cdr_report_daily.id;


--
-- Name: cdr_report_detail; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.cdr_report_detail (
    report_time timestamp with time zone,
    duration integer,
    ingress_bill_time integer,
    ingress_call_cost numeric(15,6),
    lnp_cost numeric(15,8),
    ingress_total_calls integer,
    not_zero_calls integer,
    ingress_success_calls integer,
    ingress_busy_calls integer,
    lrn_calls integer,
    pdd bigint,
    ingress_cancel_calls integer,
    ingress_client_id integer,
    ingress_id integer,
    ingress_country character varying(100),
    ingress_code_name character varying(100),
    egress_client_id integer,
    egress_id integer,
    egress_country character varying(100),
    egress_code_name character varying(100),
    egress_code character varying(100),
    ingress_prefix character varying(100),
    egress_bill_time integer,
    egress_call_cost numeric(15,6),
    egress_total_calls integer,
    egress_success_calls integer,
    egress_busy_calls integer,
    egress_cancel_calls integer,
    not_zero_calls_30 integer,
    duration_30 integer,
    not_zero_calls_6 integer,
    duration_6 integer,
    call_18s integer,
    call_24s integer,
    call_2h integer,
    call_3h integer,
    call_4h integer,
    call_12s integer,
    ingress_rate double precision,
    egress_rate double precision,
    product_rout_id integer,
    ingress_rate_date bigint,
    egress_rate_date bigint,
    incoming_bandwidth integer,
    outgoing_bandwidth integer,
    ingress_call_cost_intra numeric(15,6),
    ingress_call_cost_inter numeric(15,6),
    egress_call_cost_intra numeric(15,6),
    egress_call_cost_inter numeric(15,6),
    ingress_bill_time_intra integer,
    ingress_bill_time_inter integer,
    egress_bill_time_intra integer,
    egress_bill_time_inter integer,
    agent_id integer,
    agent_rate double precision,
    agent_cost numeric(12,6),
    ingress_rate_table_id integer,
    route_plan_id integer,
    orig_jur_type integer,
    term_jur_type integer,
    par_id integer,
    origination_destination_host_name character varying(255),
    termination_source_host_name character varying(255),
    binary_value_of_release_cause_from_protocol_stack character varying(100),
    release_cause smallint,
    release_cause_from_protocol_stack character varying(100),
    inter_ingress_total_calls integer,
    intra_ingress_total_calls integer,
    inter_duration integer,
    intra_duration integer,
    inter_not_zero_calls integer,
    intra_not_zero_calls integer,
    q850_cause_count integer,
    npr_count integer,
    ingress_call_cost_local numeric(15,6),
    ingress_call_cost_ij numeric(15,6),
    egress_call_cost_local numeric(15,6),
    egress_call_cost_ij numeric(15,6),
    cdr_date character varying(24),
    ingress_code character varying(100),
    ring_pdd integer,
    egress_no_ring integer,
    ingress_call_12s integer,
    ingress_call_18s integer,
    ingress_call_24s integer,
    ingress_call_2h integer,
    ingress_call_3h integer,
    ingress_call_4h integer,
    ingress_duration integer,
    ingress_duration_30 integer,
    ingress_duration_6 integer,
    ingress_inter_duration integer,
    ingress_inter_not_zero_calls integer,
    ingress_intra_duration integer,
    ingress_intra_not_zero_calls integer,
    ingress_not_zero_calls integer,
    ingress_not_zero_calls_30 integer,
    ingress_not_zero_calls_6 integer,
    dst_lata integer,
    dst_ocn character varying(100),
    lrn_lata integer,
    lrn_ocn character varying(100),
    src_lata integer,
    src_ocn character varying(100),
    origination_source_host_name character varying(255),
    termination_destination_host_name character varying(255),
    orig_shaken_ocn text,
    orig_shaken_lvl character varying(1),
    term_shaken_ocn text,
    term_shaken_lvl character varying(1),
    ani_in_dno_count integer,
    ani_in_ftc_count integer,
    ani_in_ftc_week_count integer,
    ani_in_ftc_month_count integer,
    ani_in_spam_count integer,
    ani_in_fraud_count integer,
    ani_in_tcpa_count integer,
    dnis_in_dnc_count integer,
    origination_remote_payload_ip_address text,
    termination_remote_payload_ip_address text
);


ALTER TABLE public.cdr_report_detail OWNER TO class4_user;

--
-- Name: COLUMN cdr_report_detail.not_zero_calls_30; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.cdr_report_detail.not_zero_calls_30 IS 'calls between 24s and 30s';


--
-- Name: COLUMN cdr_report_detail.duration_30; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.cdr_report_detail.duration_30 IS 'durations between 24s and 30s';


--
-- Name: COLUMN cdr_report_detail.not_zero_calls_6; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.cdr_report_detail.not_zero_calls_6 IS 'calls between 1s and 6s';


--
-- Name: COLUMN cdr_report_detail.duration_6; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.cdr_report_detail.duration_6 IS 'durations between 1s and 6s';


--
-- Name: COLUMN cdr_report_detail.call_18s; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.cdr_report_detail.call_18s IS 'calls between 12s and 18s';


--
-- Name: COLUMN cdr_report_detail.call_24s; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.cdr_report_detail.call_24s IS 'calls between 18s and 24s';


--
-- Name: COLUMN cdr_report_detail.call_2h; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.cdr_report_detail.call_2h IS 'calls between 30s and 2h';


--
-- Name: COLUMN cdr_report_detail.call_3h; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.cdr_report_detail.call_3h IS 'calls between 2h and 3h';


--
-- Name: COLUMN cdr_report_detail.call_4h; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.cdr_report_detail.call_4h IS 'calls between 3h and 4h';


--
-- Name: COLUMN cdr_report_detail.call_12s; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.cdr_report_detail.call_12s IS 'calls between 6s and 12s';


--
-- Name: cdr_rerate; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.cdr_rerate (
    id integer NOT NULL,
    create_time timestamp with time zone,
    finish_time timestamp with time zone,
    status integer NOT NULL,
    rerate_type integer NOT NULL,
    rerate_rate_time timestamp with time zone,
    rate_table_id integer,
    rate_table_name character varying(255),
    cdr_backup_file character varying(255),
    where_condition text,
    start_time timestamp with time zone NOT NULL,
    end_time timestamp with time zone NOT NULL,
    pid integer
);


ALTER TABLE public.cdr_rerate OWNER TO class4_user;

--
-- Name: cdr_rerate_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.cdr_rerate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cdr_rerate_id_seq OWNER TO class4_user;

--
-- Name: cdr_rerate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.cdr_rerate_id_seq OWNED BY public.cdr_rerate.id;


--
-- Name: class4_seq_invoice_no; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.class4_seq_invoice_no
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.class4_seq_invoice_no OWNER TO class4_user;

--
-- Name: client; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.client (
    client_id integer NOT NULL,
    name character varying(500),
    mode integer DEFAULT 1 NOT NULL,
    orig_rate_table_id integer,
    term_rate_table_id integer,
    currency_id integer DEFAULT 1 NOT NULL,
    allowed_credit numeric(30,10) DEFAULT 0 NOT NULL,
    status boolean DEFAULT true NOT NULL,
    auto_invoicing boolean DEFAULT false NOT NULL,
    payment_term_id integer,
    invoice_format integer,
    attach_cdrs_list boolean,
    cdr_list_format integer,
    last_invoiced timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    notify_client_balance numeric(30,10) DEFAULT 0,
    notify_admin_balance numeric(30,10) DEFAULT 0,
    low_balance_notice boolean DEFAULT true NOT NULL,
    company character varying,
    address character varying(500),
    email character varying(250),
    logo character varying(100),
    login character varying(40),
    password character varying(50),
    is_panelaccess boolean,
    is_panel_accountsummary boolean DEFAULT true,
    is_panel_ratetable boolean DEFAULT true,
    is_panel_trunks boolean DEFAULT true,
    is_panel_products boolean DEFAULT true,
    is_panel_balance boolean DEFAULT true,
    is_panel_paymenthistory boolean DEFAULT true,
    is_panel_onlinepayment boolean DEFAULT true,
    role_id integer,
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL,
    profit_margin double precision DEFAULT 0 NOT NULL,
    enough_balance boolean DEFAULT false,
    service_charge_id integer,
    noc_email character varying(250),
    billing_email character varying,
    rate_email character varying(250),
    tax_id character varying(100),
    details character varying(1000),
    invoice_show_details boolean DEFAULT false,
    invoice_past_amount numeric(30,10) DEFAULT 0,
    is_link_cdr boolean DEFAULT true,
    is_trunk boolean DEFAULT false,
    is_route boolean DEFAULT false,
    is_spam boolean DEFAULT false,
    is_location boolean DEFAULT false,
    is_orig_term boolean DEFAULT false,
    is_usage boolean DEFAULT false,
    is_qos boolean DEFAULT false,
    is_discon boolean DEFAULT false,
    is_bill_mismatch boolean DEFAULT false,
    is_active_call boolean DEFAULT false,
    is_termin boolean DEFAULT false,
    database_name character varying(50),
    is_rate_anal boolean DEFAULT false,
    is_capture boolean DEFAULT false,
    is_call_simulation boolean DEFAULT false,
    is_ingress_sim boolean DEFAULT false,
    is_egress_sim boolean DEFAULT false,
    is_report boolean DEFAULT false,
    is_tools boolean DEFAULT false,
    is_manage boolean DEFAULT false,
    mail_sended integer DEFAULT 0,
    scc_bellow integer DEFAULT 0,
    scc_percent integer DEFAULT 0,
    scc_charge numeric(30,10),
    user_id integer,
    profit_type integer DEFAULT 1,
    auto_invoice_type integer DEFAULT 2 NOT NULL,
    cps_limit integer,
    call_limit integer,
    invoice_zone character varying(10),
    invoice_zero boolean DEFAULT true,
    update_at timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    update_by character varying,
    corporate_contact_email character varying(250),
    paypal character varying(100),
    is_auto_summary boolean DEFAULT false,
    auto_send_zone character varying DEFAULT '+00:00'::character varying,
    is_daily_balance_notification boolean DEFAULT false,
    daily_balance_notification integer,
    daily_balance_recipient integer,
    low_balance_number integer,
    is_auto_balance boolean DEFAULT false,
    numer_of_days_balance integer DEFAULT 1,
    auto_daily_balance_recipient integer DEFAULT 0,
    daily_cdr_generation boolean DEFAULT false,
    daily_cdr_generation_zone character varying DEFAULT '+00:00'::character varying,
    daily_cdr_generation_type smallint DEFAULT 0,
    transaction_fee_id integer,
    unlimited_credit boolean DEFAULT false,
    include_payment_history smallint DEFAULT 0,
    include_available_credit smallint DEFAULT 0,
    include_payment_history_days integer DEFAULT 1,
    auto_summary_not_zero smallint DEFAULT 0,
    auto_summary_group_by smallint DEFAULT 0,
    daily_balance_already_sent boolean DEFAULT false,
    last_autoreport_time timestamp with time zone,
    last_lowbalance_time timestamp with time zone,
    last_cdrdown_time timestamp with time zone,
    include_tax boolean DEFAULT false,
    tax numeric(5,2),
    invoice_jurisdictional_detail boolean DEFAULT false,
    decimal_place integer DEFAULT 5,
    par_id integer,
    rate_value integer DEFAULT 0,
    email_invoice boolean DEFAULT false,
    scc_type integer DEFAULT 0,
    is_invoice_account_summary boolean DEFAULT false,
    is_show_daily_usage boolean DEFAULT false,
    invoice_include_payment boolean,
    is_short_duration_call_surcharge_detail boolean DEFAULT false,
    usage_detail_fields text,
    auto_summary_hour integer,
    auto_summary_period integer DEFAULT 24,
    last_autobalance_time timestamp with time zone,
    auto_summary_include_cdr boolean DEFAULT false NOT NULL,
    client_type integer,
    rate_delivery_email character varying(250),
    invoice_use_balance_type integer DEFAULT 0,
    notify_client_balance_type integer DEFAULT 0,
    finance_email_cc character varying,
    decimals_num integer,
    invoice_start_from date,
    low_balance_notification_time_type integer DEFAULT 0,
    low_balance_notification_time_cycle integer DEFAULT 1,
    daily_balance_send_time time without time zone,
    daily_balance_send_time_zone character varying(20),
    is_breakdown_by_rate_table boolean,
    breakdown_by_rate_table smallint,
    offset_balance boolean DEFAULT true,
    is_show_detail_trunk boolean DEFAULT false,
    is_show_total_trunk boolean DEFAULT false,
    is_show_code_100 boolean DEFAULT false,
    is_show_code_name boolean DEFAULT false,
    is_show_country boolean DEFAULT false,
    is_show_by_date boolean DEFAULT false,
    daily_limit integer,
    hourly_limit integer,
    carrier_template_id integer DEFAULT 0 NOT NULL,
    is_send_trunk_update boolean DEFAULT false,
    phone character varying(20),
    is_panel_invoices boolean DEFAULT true,
    is_panel_cdrslist boolean DEFAULT true,
    is_panel_summaryreport boolean DEFAULT true,
    is_panel_sippacket boolean DEFAULT true,
    is_panel_mydid boolean DEFAULT true,
    is_panel_didrequest boolean DEFAULT true,
    is_send_as_link boolean DEFAULT false,
    is_vendor_invoice boolean DEFAULT false,
    vendor_payment_term_id integer,
    group_id integer,
    zero_balance_notice_time integer DEFAULT 0,
    zero_balance_notice_last_sent timestamp with time zone,
    zero_balance_notice_first_sended boolean DEFAULT false,
    zero_balance_notice boolean,
    payment_received_notice boolean,
    enable_payment_alert boolean,
    is_panel_cid_blocking boolean,
    enable_auto_invoice boolean,
    enable_auto_report boolean,
    enable_client_portal boolean,
    enable_notification boolean,
    enable_short_dur_penalty boolean,
    company_type smallint,
    did_billing_by smallint DEFAULT '0'::smallint,
    fee_per_port numeric,
    enable_paypal boolean DEFAULT false,
    enable_sign_in_notification boolean DEFAULT true,
    enable_strip boolean DEFAULT false,
    enable_trunk_edit boolean DEFAULT false,
    enable_trunk_view boolean DEFAULT false,
    is_panel_block_list boolean DEFAULT true,
    invoice_hour integer,
    mask_did_start_post integer,
    mask_did_end_post integer,
    break_call_on_no_balance boolean DEFAULT true NOT NULL
);


ALTER TABLE public.client OWNER TO class4_user;

--
-- Name: TABLE client; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.client IS '客户';


--
-- Name: COLUMN client.name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.name IS '名称';


--
-- Name: COLUMN client.mode; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.mode IS '付费模式：1－预付，2－后付';


--
-- Name: COLUMN client.orig_rate_table_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.orig_rate_table_id IS '打进费率';


--
-- Name: COLUMN client.term_rate_table_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.term_rate_table_id IS '打出费－－没用，准备删除';


--
-- Name: COLUMN client.currency_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.currency_id IS '货币';


--
-- Name: COLUMN client.allowed_credit; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.allowed_credit IS '容许欠费';


--
-- Name: COLUMN client.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.status IS '状态：true-active，false-inactive';


--
-- Name: COLUMN client.auto_invoicing; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.auto_invoicing IS '是否自动生成发票';


--
-- Name: COLUMN client.payment_term_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.payment_term_id IS '缴费规则';


--
-- Name: COLUMN client.invoice_format; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.invoice_format IS '生成发票格式：1－PDF，2－Excel，3－HTML';


--
-- Name: COLUMN client.attach_cdrs_list; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.attach_cdrs_list IS '是否附件话单详细';


--
-- Name: COLUMN client.cdr_list_format; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.cdr_list_format IS '话单格式：1－Excel，2－CSV,3-zip, 4-tar.gz';


--
-- Name: COLUMN client.last_invoiced; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.last_invoiced IS '上次发票生成日期';


--
-- Name: COLUMN client.notify_client_balance; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.notify_client_balance IS '提示客户余额';


--
-- Name: COLUMN client.notify_admin_balance; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.notify_admin_balance IS '提示系统余额';


--
-- Name: COLUMN client.low_balance_notice; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.low_balance_notice IS '是否提供余额不足提示';


--
-- Name: COLUMN client.company; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.company IS '公司名称';


--
-- Name: COLUMN client.address; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.address IS '地址';


--
-- Name: COLUMN client.email; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.email IS '电子邮件';


--
-- Name: COLUMN client.logo; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.logo IS 'logo';


--
-- Name: COLUMN client.login; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.login IS '客户模板访问帐号,客户登录帐号';


--
-- Name: COLUMN client.password; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.password IS '客户模板访问密码';


--
-- Name: COLUMN client.is_panelaccess; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_panelaccess IS '是否能访问客户模板－－不再使用，准备删除';


--
-- Name: COLUMN client.is_panel_accountsummary; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_panel_accountsummary IS '是否能访问 Account Summary';


--
-- Name: COLUMN client.is_panel_ratetable; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_panel_ratetable IS '是否能访问 RateTable';


--
-- Name: COLUMN client.is_panel_trunks; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_panel_trunks IS '是否能访问 Trunks';


--
-- Name: COLUMN client.is_panel_products; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_panel_products IS '是否能访问products';


--
-- Name: COLUMN client.is_panel_balance; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_panel_balance IS '是否能访问 Balance';


--
-- Name: COLUMN client.is_panel_paymenthistory; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_panel_paymenthistory IS '是否可以访问Payment History';


--
-- Name: COLUMN client.is_panel_onlinepayment; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_panel_onlinepayment IS '是否能访问 Online Payment';


--
-- Name: COLUMN client.role_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.role_id IS '角色';


--
-- Name: COLUMN client.create_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.create_time IS '没用－－准备删除';


--
-- Name: COLUMN client.profit_margin; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.profit_margin IS '最低利润率';


--
-- Name: COLUMN client.enough_balance; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.enough_balance IS '是否余额不足';


--
-- Name: COLUMN client.is_link_cdr; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_link_cdr IS '是否可以 链接下载cdr';


--
-- Name: COLUMN client.mail_sended; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.mail_sended IS '0-没有发送,1-余额不足发送';


--
-- Name: COLUMN client.scc_bellow; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.scc_bellow IS 'call_duration呼叫时长少于这个值的计一个short call';


--
-- Name: COLUMN client.scc_percent; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.scc_percent IS 'short call的answered*100/all大于这个值就在invoice中增加短暂呼叫罚款';


--
-- Name: COLUMN client.scc_charge; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.scc_charge IS '短暂呼叫罚款金额';


--
-- Name: COLUMN client.profit_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.profit_type IS '1--百分比,2--数值';


--
-- Name: COLUMN client.auto_invoice_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.auto_invoice_type IS '0:buy(client),1:sell(vendor),2:both';


--
-- Name: COLUMN client.invoice_zero; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.invoice_zero IS '默认不生成';


--
-- Name: COLUMN client.daily_balance_recipient; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.daily_balance_recipient IS '0:Partner''s Billing Contact,1:Owner''s Billing Contact,2:Both';


--
-- Name: COLUMN client.auto_summary_group_by; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.auto_summary_group_by IS '0:By Country; 1:By Code Name; 2:By Code';


--
-- Name: COLUMN client.decimal_place; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.decimal_place IS '小数位数，默认5位';


--
-- Name: COLUMN client.scc_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.scc_type IS '0 meeting the short duration defined above, 1 that exceed the defined percentage';


--
-- Name: COLUMN client.auto_summary_period; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.auto_summary_period IS '1,2,4,6,8,12,24,-15,-30';


--
-- Name: COLUMN client.client_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.client_type IS 'did :0 vendor,1 client';


--
-- Name: COLUMN client.invoice_use_balance_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.invoice_use_balance_type IS '0-actual,1-mutual';


--
-- Name: COLUMN client.is_breakdown_by_rate_table; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_breakdown_by_rate_table IS 'invoice 是否显示 Break Down by Rate Table';


--
-- Name: COLUMN client.breakdown_by_rate_table; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.breakdown_by_rate_table IS 'breakdown_by_rate_table 的类型:1：Breakdown A-Z Rate Table by Destination,2： Breakdown US Rate Table by Jurisdiction';


--
-- Name: COLUMN client.carrier_template_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.carrier_template_id IS '使用Carrier Template模板，默认为0，不使用模板';


--
-- Name: COLUMN client.is_send_trunk_update; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_send_trunk_update IS '在改变其trunk ip时是否发送邮件';


--
-- Name: COLUMN client.is_panel_invoices; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_panel_invoices IS '是否能访问 Invoices';


--
-- Name: COLUMN client.is_panel_cdrslist; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_panel_cdrslist IS '是否能访问 CDRs List';


--
-- Name: COLUMN client.is_panel_summaryreport; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_panel_summaryreport IS '是否能访问 Summary Report';


--
-- Name: COLUMN client.is_panel_sippacket; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_panel_sippacket IS '是否能访问 SIP PACKET Search';


--
-- Name: COLUMN client.is_panel_mydid; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_panel_mydid IS '是否能访问 My DID';


--
-- Name: COLUMN client.is_panel_didrequest; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client.is_panel_didrequest IS '是否能访问 DID Request';


--
-- Name: client_balance; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.client_balance (
    client_id character varying(100) NOT NULL,
    balance character varying(100) NOT NULL,
    create_time timestamp with time zone NOT NULL,
    ingress_balance character varying(100),
    egress_balance character varying(100),
    bod_balance character varying(100) NOT NULL
);


ALTER TABLE public.client_balance OWNER TO class4_user;

--
-- Name: client_balance_operation_action; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.client_balance_operation_action (
    id integer NOT NULL,
    client_id integer,
    balance numeric(12,6) DEFAULT 0.00 NOT NULL,
    ingress_balance numeric(12,6) DEFAULT 0.00 NOT NULL,
    egress_balance numeric(12,6) DEFAULT 0.00 NOT NULL,
    action integer,
    update_result integer DEFAULT 0 NOT NULL,
    update_by character varying(100),
    update_time timestamp with time zone,
    create_by character varying(100),
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL
);


ALTER TABLE public.client_balance_operation_action OWNER TO class4_user;

--
-- Name: COLUMN client_balance_operation_action.action; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_balance_operation_action.action IS '0-Added a new client balance, 1-Reset client balance, ingress balance, egress balance, 2-Increase ingress balance, 3-Decrease ingress balance, 4-Increase egress balance, 5-Decrease egress balance';


--
-- Name: COLUMN client_balance_operation_action.update_result; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_balance_operation_action.update_result IS '0-Initial, 1-Update completed, 2-Update failed';


--
-- Name: client_balance_operation_action_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.client_balance_operation_action_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_balance_operation_action_id_seq OWNER TO class4_user;

--
-- Name: client_balance_operation_action_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.client_balance_operation_action_id_seq OWNED BY public.client_balance_operation_action.id;


--
-- Name: client_cdr_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.client_cdr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_cdr_id_seq OWNER TO class4_user;

--
-- Name: client_cdr; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.client_cdr (
    id bigint DEFAULT nextval('public.client_cdr_id_seq'::regclass),
    record_sequence_number character varying(100),
    version_number character varying(100),
    record_type character varying(100),
    connection_type character varying(100),
    session_id character varying(100),
    release_cause smallint,
    start_time_of_date bigint,
    answer_time_of_date bigint,
    release_tod bigint,
    minutes_west_of_greenwich_mean_time smallint,
    release_cause_from_protocol_stack character varying(100),
    binary_value_of_release_cause_from_protocol_stack character varying(100),
    first_release_dialogue character varying(100),
    trunk_id_origination character varying(100),
    voip_protocol_origination character varying(100),
    origination_source_number character varying(100),
    origination_source_host_name character varying(100),
    origination_destination_number character varying(100),
    origination_destination_host_name character varying(100),
    origination_call_id character varying(150),
    origination_remote_payload_ip_address character varying(100),
    origination_remote_payload_udp_address integer,
    origination_local_payload_ip_address character varying(100),
    origination_local_payload_udp_address integer,
    origination_codec_list character varying(100),
    origination_ingress_packets integer,
    origination_egress_packets integer,
    origination_ingress_octets integer,
    origination_egress_octets integer,
    origination_ingress_packet_loss integer,
    origination_ingress_delay integer,
    origination_ingress_packet_jitter integer,
    trunk_id_termination character varying(100),
    voip_protocol_termination character varying(100),
    termination_source_number character varying(100),
    termination_source_host_name character varying(100),
    termination_destination_number character varying(100),
    termination_destination_host_name character varying(100),
    termination_call_id character varying(150),
    termination_remote_payload_ip_address character varying(100),
    termination_remote_payload_udp_address integer,
    termination_local_payload_ip_address character varying(100),
    termination_local_payload_udp_address integer,
    termination_codec_list character varying(100),
    termination_ingress_packets integer,
    termination_egress_packets integer,
    termination_ingress_octets integer,
    termination_egress_octets integer,
    termination_ingress_packet_loss integer,
    termination_ingress_delay integer,
    termination_ingress_packet_jitter integer,
    final_route_indication character varying(100),
    routing_digits character varying(100),
    call_duration integer,
    pdd integer,
    ring_time bigint,
    callduration_in_ms integer,
    conf_id character varying(100),
    call_type smallint,
    ingress_id integer,
    ingress_client_id integer,
    ingress_client_rate_table_id integer,
    ingress_client_currency_id integer,
    ingress_client_rate double precision,
    ingress_client_currency character varying(100),
    ingress_client_bill_time integer,
    ingress_client_bill_result smallint,
    ingress_client_cost numeric(12,6),
    "time" timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    egress_id integer,
    egress_rate_table_id integer,
    egress_rate double precision,
    egress_cost numeric(12,6),
    egress_bill_time integer,
    egress_client_id integer,
    egress_client_currency_id integer,
    egress_client_currency character varying(100),
    egress_six_seconds integer,
    egress_bill_minutes real,
    egress_bill_result smallint,
    ingress_bill_minutes real,
    ingress_dnis_type smallint,
    ingress_rate_type smallint,
    lrn_dnis character varying(100),
    egress_dnis_type smallint,
    egress_rate_type smallint,
    translation_ani character varying(100),
    ani_code_id integer,
    dnis_code_id integer,
    item_id integer,
    ingress_rate_id integer,
    egress_rate_id integer,
    rerate_time timestamp with time zone,
    orig_code character varying(100),
    orig_code_name character varying(100),
    orig_country character varying(100),
    term_code character varying(100),
    term_code_name character varying(100),
    term_country character varying(100),
    ingress_rate_effective_date bigint,
    egress_rate_effective_date bigint,
    egress_erro_string text,
    route_plan integer,
    dynamic_route integer,
    static_route integer,
    contract_id character varying(100),
    order_id character varying(100),
    order_type character varying(100),
    lrn_number_vendor smallint,
    lnp_dipping_cost numeric(10,8),
    is_final_call smallint,
    egress_code_asr real,
    egress_code_acd real,
    route_prefix character varying(100),
    is_manual_kill boolean DEFAULT false,
    orig_call_duration integer,
    orig_delay_second integer,
    term_delay_second integer,
    trunk_type smallint,
    origination_profile_port integer,
    termination_profile_port integer,
    o_trunk_type2 smallint,
    o_billing_method smallint,
    t_trunk_type2 smallint,
    t_billing_method smallint,
    campaign_id integer,
    tax integer,
    agent_id integer,
    agent_rate double precision,
    agent_cost numeric(12,6),
    orig_jur_type integer,
    term_jur_type integer,
    ring_epoch bigint,
    end_epoch bigint,
    par_id integer,
    paid_user character varying(100),
    rpid_user character varying(100),
    timeout_type smallint,
    q850_cause integer,
    q850_cause_string character varying(100),
    dst_lata integer,
    dst_ocn character varying(100),
    dst_rc character varying(100),
    lrn_lata integer,
    lrn_ocn character varying(100),
    lrn_rc character varying(100),
    src_lata integer,
    src_ocn character varying(100),
    src_rc character varying(100),
    cdr_date character varying(24),
    orig_shaken_lvl character varying(1),
    orig_shaken_ocn character varying(100),
    orig_shaken_status integer,
    orig_shaken_subject character varying(512),
    term_shaken_lvl character varying(1),
    term_shaken_ocn character varying(512),
    term_shaken_status integer,
    term_shaken_subject character varying(512),
    ani_in_dno integer,
    ani_in_ftc timestamp with time zone,
    ani_in_spam boolean,
    ani_in_fraud boolean,
    ani_in_tcpa boolean,
    dnis_in_dnc boolean,
    src_type text,
    dst_type text,
    shaken_key_id bigint
);


ALTER TABLE public.client_cdr OWNER TO class4_user;

--
-- Name: COLUMN client_cdr.release_cause; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.release_cause IS '返回给主叫的错误码，一共20种。

        REC_CALL_ARGS = 0,
        REC_SYSTEM_CAP = 1,
        REC_SYSTEM_CPS = 2,
        REC_INGRESS_IP_CHECK = 3,
        REC_INGRESS_RESOURCE = 4,
        REC_PRODUCT_CHECK = 5,
        REC_IN_RESORUCE_CAP = 6,
        REC_IN_RESORUCE_CPS = 7,
        REC_IN_RESORUCE_IP_CAP = 8,
        REC_IN_RESORUCE_IP_CPS = 9,
        REC_RESOURCE_CODEC = 10,
        REC_INGRESS_LRN_BLOCK = 11,
        REC_INGRESS_RATE = 12,
        REC_EGRESS_NOT_FOUND = 13,
        REC_EGRESS_RESPONSE404 = 14,
        REC_EGRESS_RESPONSE486 = 15,
        REC_EGRESS_RESPONSE487 = 16,
        REC_EGRESS_RESPONSE200 = 17,
        REC_ALL_EGRESS_FAILED = 81,
        REC_NORMAL = 19

        { "0", "404", "Not Found" },
        { "1", "503", "Service Unavailable" },
        { "2", "503", "Service Unavailable" },
        { "3", "403", "Forbidden" },
        { "4", "403", "Forbidden" },
        { "5", "403", "Forbidden" },
        { "6", "503", "Service Unavailable" },
        { "7", "503", "Service Unavailable" },
        { "8", "503", "Service Unavailable" },
        { "9", "503", "Service Unavailable" },
        { "10", "415", "Unsupported Media Type" },
        { "11", "403", "Forbidden" },
        { "12", "403", "Forbidden" },
        { "13", "403", "Forbidden" },
        { "14", "404", "Not Found" },
        { "15", "486", "Busy Here" },
        { "16", "503", "Service Unavailable" },
        { "17", "200", "OK" },
        { "18", "503", "Service Unavailable" },
        { "19", "200", "OK" }



系统定义错误码翻译，如果有不妥当的请恢复一下。

REC_CALL_ARGS Invalid Argument
REC_SYSTEM_CAP System Limit Exceeded
REC_SYSTEM_CPS System Limit Exceeded
REC_INGRESS_IP_CHECK Unauthorized IP Address
REC_INGRESS_RESOURCE No Ingress Resource Found
REC_PRODUCT_CHECK No Product Found
REC_IN_RESORUCE_CAP Trunk Limit Exceeded
REC_IN_RESORUCE_CPS Trunk Limit Exceeded
REC_IN_RESORUCE_IP_CAP IP Limit Exceeded
REC_IN_RESORUCE_IP_CPS IP Limit Exceeded
REC_RESOURCE_CODEC Invalid Codec Negotiation
REC_INGRESS_LRN_BLOCK Block due to LRN
REC_INGRESS_RATE Ingress Rate Not Found
REC_EGRESS_NOT_FOUND Egress Trunk Not Found
REC_EGRESS_RESPONSE404 From egress response 404
REC_EGRESS_RESPONSE486 From egress response 486
REC_EGRESS_RESPONSE487 From egress response 487
REC_EGRESS_RESPONSE200 From egress response 200
REC_ALL_EGRESS_FAILED All egress not available
REC_NORMAL Normal



';


--
-- Name: COLUMN client_cdr.release_cause_from_protocol_stack; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.release_cause_from_protocol_stack IS '
ingress
打进繁忙的call 486
打进没有通道的call  503
被叫返回的

ingress_to_egress

返回给egress 的 原因Response From Egress';


--
-- Name: COLUMN client_cdr.binary_value_of_release_cause_from_protocol_stack; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.binary_value_of_release_cause_from_protocol_stack IS '返回给主叫的原因
ingress_to_ingress

返回给ingress 的原因    Response TO Ingress';


--
-- Name: COLUMN client_cdr.trunk_id_origination; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.trunk_id_origination IS 'trunk_id_origination

对接网关的alais';


--
-- Name: COLUMN client_cdr.trunk_id_termination; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.trunk_id_termination IS '被叫信息，落地网关，egress alias
为空 －－找不到路由的cdr';


--
-- Name: COLUMN client_cdr.routing_digits; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.routing_digits IS '被叫号';


--
-- Name: COLUMN client_cdr.call_duration; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.call_duration IS '通话时长
打进-不为0的call call_duration>0的cdr';


--
-- Name: COLUMN client_cdr.ingress_client_bill_result; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.ingress_client_bill_result IS ' 打进 计费结果
1－－成功
2－－Calls with unknown clients

3－－费率模板找不到
4－－费率找不到
5--Calls with unknown destinations (known clients)
6--';


--
-- Name: COLUMN client_cdr.ingress_client_cost; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.ingress_client_cost IS '通话费用(对接网关的钱)

incoming';


--
-- Name: COLUMN client_cdr."time"; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr."time" IS '插入数据库的时间';


--
-- Name: COLUMN client_cdr.egress_cost; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.egress_cost IS '成本＝＝落地网关的钱
outgoing';


--
-- Name: COLUMN client_cdr.egress_bill_minutes; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.egress_bill_minutes IS '打出  计费结果';


--
-- Name: COLUMN client_cdr.egress_bill_result; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.egress_bill_result IS '
Termination
计费结果
1－－成功
2－－账号找不到
3－－费率模板找不到
4－－费率找不到';


--
-- Name: COLUMN client_cdr.ingress_dnis_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.ingress_dnis_type IS '0-dnis
1-lrn
2-lrn block';


--
-- Name: COLUMN client_cdr.ingress_rate_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.ingress_rate_type IS '1－－interstate
2－－intrastate
3－－others
4 -- error
5 -- local rate';


--
-- Name: COLUMN client_cdr.egress_dnis_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.egress_dnis_type IS '0-dnis
1-lrn
2-lrn block';


--
-- Name: COLUMN client_cdr.egress_rate_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.egress_rate_type IS '1. --interstate
2. --intrastate
3. --others
4. --error
5. --local rate

';


--
-- Name: COLUMN client_cdr.translation_ani; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.translation_ani IS '转换后的主叫号';


--
-- Name: COLUMN client_cdr.item_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.item_id IS '静态路由表prefix ID';


--
-- Name: COLUMN client_cdr.rerate_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.rerate_time IS '重新计费的时间';


--
-- Name: COLUMN client_cdr.orig_code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.orig_code IS '打进号码';


--
-- Name: COLUMN client_cdr.orig_code_name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.orig_code_name IS '打进号码名称';


--
-- Name: COLUMN client_cdr.orig_country; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.orig_country IS '打进国家';


--
-- Name: COLUMN client_cdr.egress_erro_string; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.egress_erro_string IS '返回错误原因';


--
-- Name: COLUMN client_cdr.order_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.order_type IS '1--buy order
2--sell order';


--
-- Name: COLUMN client_cdr.lrn_number_vendor; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.lrn_number_vendor IS '1-client
2-lrn server';


--
-- Name: COLUMN client_cdr.lnp_dipping_cost; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.lnp_dipping_cost IS '－－lrn_number_vendor为2，此变量有效
－－client_balance里实时扣费
－－失败的呼叫也会扣此费用';


--
-- Name: COLUMN client_cdr.is_final_call; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.is_final_call IS '0-默认忽略
1-最后一个路由';


--
-- Name: COLUMN client_cdr.orig_jur_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.orig_jur_type IS 'from rate_table jur_type';


--
-- Name: COLUMN client_cdr.term_jur_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.term_jur_type IS 'from rate_table';


--
-- Name: COLUMN client_cdr.ring_epoch; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.ring_epoch IS '得到180或183的时间';


--
-- Name: COLUMN client_cdr.end_epoch; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.end_epoch IS '被叫收到bye或发给被叫bye的时间';


--
-- Name: COLUMN client_cdr.shaken_key_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_cdr.shaken_key_id IS 'References shaken_sti_sp_conf.id';


--
-- Name: client_client_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.client_client_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_client_id_seq OWNER TO class4_user;

--
-- Name: client_client_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.client_client_id_seq OWNED BY public.client.client_id;


--
-- Name: client_default_ip; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.client_default_ip (
    id integer NOT NULL,
    client_id integer NOT NULL,
    ip character varying(100),
    port integer,
    netmark integer,
    product_id integer
);


ALTER TABLE public.client_default_ip OWNER TO class4_user;

--
-- Name: client_default_ip_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.client_default_ip_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_default_ip_id_seq OWNER TO class4_user;

--
-- Name: client_default_ip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.client_default_ip_id_seq OWNED BY public.client_default_ip.id;


--
-- Name: client_did_product; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.client_did_product (
    client_id integer NOT NULL,
    did_product_id integer,
    enable_sms boolean DEFAULT false,
    created_by character varying(40),
    created_on timestamp with time zone DEFAULT now(),
    rate_table_id integer
);


ALTER TABLE public.client_did_product OWNER TO class4_user;

--
-- Name: client_invoice_settings; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.client_invoice_settings (
    id integer NOT NULL,
    client_id integer NOT NULL,
    invoice_setting_id bigint
);


ALTER TABLE public.client_invoice_settings OWNER TO class4_user;

--
-- Name: client_invoice_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.client_invoice_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_invoice_settings_id_seq OWNER TO class4_user;

--
-- Name: client_invoice_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.client_invoice_settings_id_seq OWNED BY public.client_invoice_settings.id;


--
-- Name: client_low_balance_config; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.client_low_balance_config (
    client_id integer NOT NULL,
    is_notify boolean,
    value_type integer,
    actual_notify_balance numeric(30,2),
    percentage_notify_balance numeric(30,2),
    send_time_type integer,
    daily_send_time integer,
    duplicate_days integer,
    send_to integer,
    duplicate_send_days integer DEFAULT 0 NOT NULL,
    last_alert_time timestamp with time zone,
    disable_trunks_days integer DEFAULT 5
);


ALTER TABLE public.client_low_balance_config OWNER TO class4_user;

--
-- Name: COLUMN client_low_balance_config.is_notify; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_low_balance_config.is_notify IS '是否检测';


--
-- Name: COLUMN client_low_balance_config.value_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_low_balance_config.value_type IS '0 =>Actual Balance,1 =>Percentage';


--
-- Name: COLUMN client_low_balance_config.send_time_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_low_balance_config.send_time_type IS '0 => daily, 1=> hourly';


--
-- Name: COLUMN client_low_balance_config.daily_send_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_low_balance_config.daily_send_time IS 'if selected daily to choose between 00:00 - 23:00 GMT';


--
-- Name: COLUMN client_low_balance_config.duplicate_days; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_low_balance_config.duplicate_days IS '重复发送几天';


--
-- Name: COLUMN client_low_balance_config.send_to; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_low_balance_config.send_to IS '0 => Owner''sBilling Contact,  1 =>  Partner''s Billing Contact,  2 => Both';


--
-- Name: COLUMN client_low_balance_config.duplicate_send_days; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_low_balance_config.duplicate_send_days IS '已经发送的天数';


--
-- Name: client_payment; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.client_payment (
    client_payment_id integer NOT NULL,
    payment_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL,
    amount numeric(20,10) NOT NULL,
    result boolean NOT NULL,
    client_id integer,
    cause character varying(20),
    description character varying(500),
    approved boolean,
    current_balance numeric(30,10) DEFAULT 0,
    invoice_number character varying(100),
    payment_type integer DEFAULT 1,
    payment_method integer,
    email_sended boolean DEFAULT false,
    update_by character varying,
    receiving_time timestamp with time zone,
    egress_amount numeric,
    charge_name character varying(50)
);


ALTER TABLE public.client_payment OWNER TO class4_user;

--
-- Name: TABLE client_payment; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.client_payment IS '客户每次充值记录表';


--
-- Name: COLUMN client_payment.payment_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_payment.payment_time IS '充值时间';


--
-- Name: COLUMN client_payment.amount; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_payment.amount IS '充值金额';


--
-- Name: COLUMN client_payment.result; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_payment.result IS '充值结果(成功/失败)';


--
-- Name: COLUMN client_payment.description; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_payment.description IS '设置reset balance 的note';


--
-- Name: COLUMN client_payment.approved; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_payment.approved IS '是否经过审核';


--
-- Name: COLUMN client_payment.payment_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.client_payment.payment_type IS '3:invoice payment sent
4:invoice payment received
5:prepay payment received
6:payment sent
7:credit note received
8:credit note sent
9:reset
10:offset
11: debit received
12:debit sent
13:mutual reset
14:actual reset
15:scc cost';


--
-- Name: client_payment_client_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.client_payment_client_payment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_payment_client_payment_id_seq OWNER TO class4_user;

--
-- Name: client_payment_client_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.client_payment_client_payment_id_seq OWNED BY public.client_payment.client_payment_id;


--
-- Name: client_rate_generation; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.client_rate_generation (
    id integer NOT NULL,
    client_id integer NOT NULL,
    rate_generation_template_id integer
);


ALTER TABLE public.client_rate_generation OWNER TO class4_user;

--
-- Name: client_rate_generation_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.client_rate_generation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_rate_generation_id_seq OWNER TO class4_user;

--
-- Name: client_rate_generation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.client_rate_generation_id_seq OWNED BY public.client_rate_generation.id;


--
-- Name: client_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.client_record (
    client_id integer NOT NULL,
    name character varying(500),
    mode integer NOT NULL,
    orig_rate_table_id integer,
    term_rate_table_id integer,
    currency_id integer NOT NULL,
    allowed_credit numeric(30,10) NOT NULL,
    status boolean NOT NULL,
    auto_invoicing boolean NOT NULL,
    payment_term_id integer,
    invoice_format integer,
    attach_cdrs_list boolean,
    cdr_list_format integer,
    last_invoiced timestamp with time zone,
    notify_client_balance numeric(30,10),
    notify_admin_balance numeric(30,10),
    low_balance_notice boolean NOT NULL,
    company character varying,
    address character varying(500),
    email character varying(250),
    logo character varying(100),
    login character varying(40),
    password character varying(50),
    is_panelaccess boolean,
    is_panel_accountsummary boolean,
    is_panel_ratetable boolean,
    is_panel_trunks boolean,
    is_panel_products boolean,
    is_panel_balance boolean,
    is_panel_paymenthistory boolean,
    is_panel_onlinepayment boolean,
    role_id integer,
    create_time timestamp with time zone NOT NULL,
    profit_margin double precision NOT NULL,
    enough_balance boolean,
    service_charge_id integer,
    noc_email character varying(250),
    billing_email character varying,
    rate_email character varying(250),
    tax_id character varying(100),
    details character varying(1000),
    invoice_show_details boolean,
    invoice_past_amount numeric(30,10),
    is_link_cdr boolean,
    is_trunk boolean,
    is_route boolean,
    is_spam boolean,
    is_location boolean,
    is_orig_term boolean,
    is_usage boolean,
    is_qos boolean,
    is_discon boolean,
    is_bill_mismatch boolean,
    is_active_call boolean,
    is_termin boolean,
    database_name character varying(50),
    is_rate_anal boolean,
    is_capture boolean,
    is_call_simulation boolean,
    is_ingress_sim boolean,
    is_egress_sim boolean,
    is_report boolean,
    is_tools boolean,
    is_manage boolean,
    mail_sended integer,
    scc_bellow integer,
    scc_percent integer,
    scc_charge numeric(30,10),
    user_id integer,
    profit_type integer,
    auto_invoice_type integer NOT NULL,
    cps_limit integer,
    call_limit integer,
    invoice_zone character varying(10),
    invoice_zero boolean,
    update_at timestamp with time zone,
    update_by character varying,
    corporate_contact_email character varying(250),
    paypal character varying(100),
    is_auto_summary boolean,
    auto_send_zone character varying,
    is_daily_balance_notification boolean,
    daily_balance_notification integer,
    daily_balance_recipient integer,
    low_balance_number integer,
    is_auto_balance boolean,
    numer_of_days_balance integer,
    auto_daily_balance_recipient integer,
    daily_cdr_generation boolean,
    daily_cdr_generation_zone character varying,
    daily_cdr_generation_type smallint,
    transaction_fee_id integer,
    unlimited_credit boolean,
    include_payment_history smallint,
    include_available_credit smallint,
    include_payment_history_days integer,
    auto_summary_not_zero smallint,
    auto_summary_group_by smallint,
    daily_balance_already_sent boolean,
    last_autoreport_time timestamp with time zone,
    last_lowbalance_time timestamp with time zone,
    last_cdrdown_time timestamp with time zone,
    include_tax boolean,
    tax numeric(5,2),
    invoice_jurisdictional_detail boolean,
    decimal_place integer,
    par_id integer,
    rate_value integer,
    email_invoice boolean,
    scc_type integer,
    is_invoice_account_summary boolean,
    is_show_daily_usage boolean,
    invoice_include_payment boolean,
    is_short_duration_call_surcharge_detail boolean,
    usage_detail_fields text,
    auto_summary_hour integer,
    auto_summary_period integer,
    last_autobalance_time timestamp with time zone,
    auto_summary_include_cdr boolean NOT NULL,
    client_type integer,
    rate_delivery_email character varying(250),
    invoice_use_balance_type integer,
    notify_client_balance_type integer,
    finance_email_cc character varying,
    decimals_num integer,
    invoice_start_from date,
    low_balance_notification_time_type integer,
    low_balance_notification_time_cycle integer,
    daily_balance_send_time time without time zone,
    daily_balance_send_time_zone character varying(20),
    is_breakdown_by_rate_table boolean,
    breakdown_by_rate_table smallint,
    offset_balance boolean,
    is_show_detail_trunk boolean,
    is_show_total_trunk boolean,
    is_show_code_100 boolean,
    is_show_code_name boolean,
    is_show_country boolean,
    is_show_by_date boolean,
    daily_limit integer,
    hourly_limit integer,
    carrier_template_id integer NOT NULL,
    is_send_trunk_update boolean,
    phone character varying(20),
    is_panel_invoices boolean,
    is_panel_cdrslist boolean,
    is_panel_summaryreport boolean,
    is_panel_sippacket boolean,
    is_panel_mydid boolean,
    is_panel_didrequest boolean,
    is_send_as_link boolean,
    is_vendor_invoice boolean,
    vendor_payment_term_id integer,
    group_id integer,
    zero_balance_notice_time integer,
    zero_balance_notice_last_sent timestamp with time zone,
    zero_balance_notice_first_sended boolean,
    zero_balance_notice boolean,
    payment_received_notice boolean,
    enable_payment_alert boolean,
    is_panel_cid_blocking boolean,
    enable_auto_invoice boolean,
    enable_auto_report boolean,
    enable_client_portal boolean,
    enable_notification boolean,
    enable_short_dur_penalty boolean,
    company_type smallint,
    did_billing_by smallint,
    fee_per_port numeric,
    enable_paypal boolean,
    enable_sign_in_notification boolean,
    enable_strip boolean,
    enable_trunk_edit boolean,
    enable_trunk_view boolean,
    is_panel_block_list boolean,
    invoice_hour integer,
    mask_did_start_post integer,
    mask_did_end_post integer,
    break_call_on_no_balance boolean NOT NULL,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.client_record OWNER TO class4_user;

--
-- Name: client_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.client_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_record_record_id_seq OWNER TO class4_user;

--
-- Name: client_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.client_record_record_id_seq OWNED BY public.client_record.record_id;


--
-- Name: client_taxes; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.client_taxes (
    id integer NOT NULL,
    client_id integer NOT NULL,
    tax_name character varying(255) NOT NULL,
    tax_percent numeric NOT NULL
);


ALTER TABLE public.client_taxes OWNER TO class4_user;

--
-- Name: client_taxes_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.client_taxes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_taxes_id_seq OWNER TO class4_user;

--
-- Name: client_taxes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.client_taxes_id_seq OWNED BY public.client_taxes.id;


--
-- Name: code; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.code (
    code_id integer NOT NULL,
    code public.prefix_range NOT NULL,
    code_deck_id integer,
    city character varying(20),
    state character varying(20),
    country character varying(100),
    name character varying(100)
);


ALTER TABLE public.code OWNER TO class4_user;

--
-- Name: TABLE code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.code IS '费率前缀';


--
-- Name: COLUMN code.code_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.code.code_id IS '主键';


--
-- Name: COLUMN code.code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.code.code IS '前缀';


--
-- Name: COLUMN code.code_deck_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.code.code_deck_id IS '前缀组(号码组)';


--
-- Name: COLUMN code.city; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.code.city IS '城市';


--
-- Name: COLUMN code.state; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.code.state IS '省份';


--
-- Name: COLUMN code.country; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.code.country IS '国家';


--
-- Name: COLUMN code.name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.code.name IS '名称';


--
-- Name: code_code_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.code_code_id_seq
    START WITH 232332
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.code_code_id_seq OWNER TO class4_user;

--
-- Name: code_code_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.code_code_id_seq OWNED BY public.code.code_id;


--
-- Name: code_country; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.code_country (
    country_code character varying(20) NOT NULL,
    country character varying(80),
    phone_code public.prefix_range
);


ALTER TABLE public.code_country OWNER TO class4_user;

--
-- Name: code_deck; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.code_deck (
    code_deck_id integer NOT NULL,
    name character varying(100) NOT NULL,
    update_at timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    update_by character varying,
    client_id integer
);


ALTER TABLE public.code_deck OWNER TO class4_user;

--
-- Name: TABLE code_deck; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.code_deck IS '费率前缀组';


--
-- Name: COLUMN code_deck.name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.code_deck.name IS '名称';


--
-- Name: COLUMN code_deck.client_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.code_deck.client_id IS '等于零都是默认的,0-a/z,1-us,其它值为该code deck 专用';


--
-- Name: code_deck_code_deck_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.code_deck_code_deck_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.code_deck_code_deck_id_seq OWNER TO class4_user;

--
-- Name: code_deck_code_deck_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.code_deck_code_deck_id_seq OWNED BY public.code_deck.code_deck_id;


--
-- Name: code_deck_import_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.code_deck_import_task (
    id integer NOT NULL,
    operator_user character varying(40),
    orig_import_filename character varying(256),
    format_import_filename character varying(256),
    import_log_filename character varying(256),
    redup_in_file_action smallint DEFAULT '0'::smallint NOT NULL,
    delete_all boolean DEFAULT false NOT NULL,
    code_deck_id integer NOT NULL,
    status smallint DEFAULT '0'::smallint NOT NULL,
    progress character varying(1024),
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    create_time timestamp with time zone DEFAULT now(),
    redup_in_code_deck_table_action smallint DEFAULT '0'::smallint NOT NULL
);


ALTER TABLE public.code_deck_import_task OWNER TO class4_user;

--
-- Name: code_deck_import_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.code_deck_import_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.code_deck_import_task_id_seq OWNER TO class4_user;

--
-- Name: code_deck_import_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.code_deck_import_task_id_seq OWNED BY public.code_deck_import_task.id;


--
-- Name: code_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.code_record (
    code_id integer NOT NULL,
    code public.prefix_range NOT NULL,
    code_deck_id integer,
    city character varying(20),
    state character varying(20),
    country character varying(100),
    name character varying(100),
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.code_record OWNER TO class4_user;

--
-- Name: code_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.code_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.code_record_record_id_seq OWNER TO class4_user;

--
-- Name: code_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.code_record_record_id_seq OWNED BY public.code_record.record_id;


--
-- Name: code_report; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.code_report (
    id bigint NOT NULL,
    cdr_date character varying NOT NULL,
    report_time timestamp without time zone NOT NULL,
    code character varying NOT NULL,
    ingress_client_id integer,
    ingress_id integer,
    egress_client_id integer,
    egress_id integer,
    not_zero_calls integer,
    total_calls integer,
    ingress_not_zero_calls integer,
    ingress_total_calls integer
)
PARTITION BY RANGE (report_time);


ALTER TABLE public.code_report OWNER TO class4_user;

--
-- Name: code_report_daily; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.code_report_daily (
    id bigint NOT NULL,
    cdr_date character varying NOT NULL,
    report_time timestamp without time zone NOT NULL,
    code character varying NOT NULL,
    ingress_client_id integer,
    ingress_id integer,
    egress_client_id integer,
    egress_id integer,
    not_zero_calls integer,
    total_calls integer,
    ingress_not_zero_calls integer,
    ingress_total_calls integer
)
PARTITION BY RANGE (report_time);


ALTER TABLE public.code_report_daily OWNER TO class4_user;

--
-- Name: code_report_daily_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.code_report_daily_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.code_report_daily_id_seq OWNER TO class4_user;

--
-- Name: code_report_daily_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.code_report_daily_id_seq OWNED BY public.code_report_daily.id;


--
-- Name: code_report_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.code_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.code_report_id_seq OWNER TO class4_user;

--
-- Name: code_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.code_report_id_seq OWNED BY public.code_report.id;


--
-- Name: codecs; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.codecs (
    id integer NOT NULL,
    name character varying(40) NOT NULL,
    detail character varying(100)
);


ALTER TABLE public.codecs OWNER TO class4_user;

--
-- Name: TABLE codecs; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.codecs IS '编码';


--
-- Name: COLUMN codecs.id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.codecs.id IS '主键';


--
-- Name: COLUMN codecs.name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.codecs.name IS '名称';


--
-- Name: COLUMN codecs.detail; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.codecs.detail IS '描述';


--
-- Name: credit_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.credit_log (
    id integer NOT NULL,
    modified_by character varying(200),
    modified_from numeric(30,10),
    modified_to numeric(30,10),
    modified_on timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    carrier_name character varying(200)
);


ALTER TABLE public.credit_log OWNER TO class4_user;

--
-- Name: credit_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.credit_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.credit_log_id_seq OWNER TO class4_user;

--
-- Name: credit_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.credit_log_id_seq OWNED BY public.credit_log.id;


--
-- Name: currency; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.currency (
    currency_id integer NOT NULL,
    code character varying(100) NOT NULL,
    active boolean DEFAULT true NOT NULL,
    update_by character varying
);


ALTER TABLE public.currency OWNER TO class4_user;

--
-- Name: TABLE currency; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.currency IS '货币';


--
-- Name: COLUMN currency.code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.currency.code IS '货币国家代号';


--
-- Name: COLUMN currency.active; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.currency.active IS '是否可用';


--
-- Name: currency_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.currency_currency_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.currency_currency_id_seq OWNER TO class4_user;

--
-- Name: currency_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.currency_currency_id_seq OWNED BY public.currency.currency_id;


--
-- Name: currency_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.currency_record (
    currency_id integer NOT NULL,
    code character varying(100) NOT NULL,
    active boolean NOT NULL,
    update_by character varying,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.currency_record OWNER TO class4_user;

--
-- Name: currency_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.currency_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.currency_record_record_id_seq OWNER TO class4_user;

--
-- Name: currency_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.currency_record_record_id_seq OWNED BY public.currency_record.record_id;


--
-- Name: currency_updates; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.currency_updates (
    currency_id integer NOT NULL,
    rate numeric(30,6) NOT NULL,
    currency_updates_id integer NOT NULL
);


ALTER TABLE public.currency_updates OWNER TO class4_user;

--
-- Name: TABLE currency_updates; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.currency_updates IS '货币汇率更新记录';


--
-- Name: COLUMN currency_updates.currency_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.currency_updates.currency_id IS '货币';


--
-- Name: COLUMN currency_updates.rate; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.currency_updates.rate IS '汇率';


--
-- Name: currency_updates_currency_updates_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.currency_updates_currency_updates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.currency_updates_currency_updates_id_seq OWNER TO class4_user;

--
-- Name: currency_updates_currency_updates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.currency_updates_currency_updates_id_seq OWNED BY public.currency_updates.currency_updates_id;


--
-- Name: currency_updates_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.currency_updates_record (
    currency_id integer NOT NULL,
    rate numeric(30,6) NOT NULL,
    currency_updates_id integer NOT NULL,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.currency_updates_record OWNER TO class4_user;

--
-- Name: currency_updates_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.currency_updates_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.currency_updates_record_record_id_seq OWNER TO class4_user;

--
-- Name: currency_updates_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.currency_updates_record_record_id_seq OWNED BY public.currency_updates_record.record_id;


--
-- Name: daily_cdr_fields; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.daily_cdr_fields (
    id integer NOT NULL,
    type smallint,
    field character varying NOT NULL,
    label character varying
);


ALTER TABLE public.daily_cdr_fields OWNER TO class4_user;

--
-- Name: daily_cdr_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.daily_cdr_fields_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.daily_cdr_fields_id_seq OWNER TO class4_user;

--
-- Name: daily_cdr_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.daily_cdr_fields_id_seq OWNED BY public.daily_cdr_fields.id;


--
-- Name: dashboard_time_option; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dashboard_time_option (
    id integer NOT NULL,
    admin_point_time timestamp with time zone,
    client_point_time timestamp with time zone,
    iden character varying(30)
);


ALTER TABLE public.dashboard_time_option OWNER TO class4_user;

--
-- Name: dashboard_time_option_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.dashboard_time_option_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dashboard_time_option_id_seq OWNER TO class4_user;

--
-- Name: dashboard_time_option_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.dashboard_time_option_id_seq OWNED BY public.dashboard_time_option.id;


--
-- Name: data_clean_management_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.data_clean_management_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.data_clean_management_id_seq OWNER TO class4_user;

--
-- Name: data_clean_management; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.data_clean_management (
    id integer DEFAULT nextval('public.data_clean_management_id_seq'::regclass) NOT NULL,
    tbl_name character varying(100) NOT NULL,
    days_of_save_in_db integer DEFAULT 0 NOT NULL,
    create_time timestamp with time zone DEFAULT now()
);


ALTER TABLE public.data_clean_management OWNER TO class4_user;

--
-- Name: COLUMN data_clean_management.tbl_name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.data_clean_management.tbl_name IS 'Basic table name that needs to be cleaned up. client_cdr, cdr_report_detail etc.';


--
-- Name: COLUMN data_clean_management.days_of_save_in_db; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.data_clean_management.days_of_save_in_db IS 'How many days of datas to keep in DB, 0 for permanent storage';


--
-- Name: did_assign; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_assign (
    number character varying(100) NOT NULL,
    egress_id integer NOT NULL,
    created_time timestamp with time zone,
    assigned_time timestamp with time zone,
    status smallint,
    ingress_id integer
);


ALTER TABLE public.did_assign OWNER TO class4_user;

--
-- Name: did_assignments; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_assignments (
    id bigint NOT NULL,
    did character varying(50) NOT NULL,
    vendor_id bigint NOT NULL,
    vendor_trunk_id integer NOT NULL,
    vendor_billing_plan_id integer NOT NULL,
    vendor_mrc_cycle integer,
    vendor_mrc numeric,
    vendor_nrc numeric,
    client_id bigint NOT NULL,
    client_trunk_id integer NOT NULL,
    client_billing_plan_id integer NOT NULL,
    client_mrc_cycle integer,
    client_mrc numeric,
    client_nrc numeric,
    fallback_id integer,
    created_at timestamp with time zone DEFAULT now(),
    created_by integer
);


ALTER TABLE public.did_assignments OWNER TO class4_user;

--
-- Name: COLUMN did_assignments.created_by; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.did_assignments.created_by IS '0 - UI; 1 - API; 2 - Mass Import';


--
-- Name: did_assignments_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_assignments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_assignments_id_seq OWNER TO class4_user;

--
-- Name: did_assignments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_assignments_id_seq OWNED BY public.did_assignments.id;


--
-- Name: did_assignments_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_assignments_log (
    id bigint NOT NULL,
    did character varying(50),
    vendor_id integer,
    vendor_trunk_id integer,
    vendor_billing_plan_id integer,
    vendor_mrc_cycle integer,
    vendor_mrc numeric,
    vendor_nrc numeric,
    client_id integer,
    client_trunk_id integer,
    client_billing_plan_id integer,
    client_mrc_cycle integer,
    client_mrc numeric,
    client_nrc numeric,
    fallback_id integer,
    created_at date NOT NULL,
    created_at_time timestamp with time zone,
    created_by integer,
    deleted_at date,
    deleted_by integer,
    deleted_at_time timestamp with time zone
)
PARTITION BY RANGE (created_at);


ALTER TABLE public.did_assignments_log OWNER TO class4_user;

--
-- Name: did_assignments_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_assignments_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_assignments_log_id_seq OWNER TO class4_user;

--
-- Name: did_assignments_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_assignments_log_id_seq OWNED BY public.did_assignments_log.id;


--
-- Name: did_billing_brief; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_billing_brief (
    id integer NOT NULL,
    did_number character varying(50),
    vendor_billing_plan_id integer,
    client_billing_plan_id integer,
    vendor_trunk_id integer,
    client_trunk_id integer,
    start_date timestamp with time zone,
    enable_for_clients boolean DEFAULT false,
    last_charged_monthly_fees integer DEFAULT '-1'::integer,
    next_mrc_billing_date date,
    nrc_billing_date date,
    end_date timestamp with time zone
);


ALTER TABLE public.did_billing_brief OWNER TO class4_user;

--
-- Name: did_billing_brief_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_billing_brief_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_billing_brief_id_seq OWNER TO class4_user;

--
-- Name: did_billing_brief_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_billing_brief_id_seq OWNED BY public.did_billing_brief.id;


--
-- Name: did_billing_operation_action; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_billing_operation_action (
    id integer NOT NULL,
    did_billing_id integer,
    created_by character varying(100),
    created_on timestamp with time zone DEFAULT now() NOT NULL,
    code smallint,
    error text,
    finished_by character varying(100),
    finished_on timestamp with time zone
);


ALTER TABLE public.did_billing_operation_action OWNER TO class4_user;

--
-- Name: did_billing_operation_action_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_billing_operation_action_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_billing_operation_action_id_seq OWNER TO class4_user;

--
-- Name: did_billing_operation_action_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_billing_operation_action_id_seq OWNED BY public.did_billing_operation_action.id;


--
-- Name: did_billing_plan; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_billing_plan (
    id integer NOT NULL,
    did_price real DEFAULT 0,
    min_price real DEFAULT 0,
    name character varying(255),
    payphone_subcharge character varying,
    monthly_charge numeric,
    rate_table_id integer,
    pay_type smallint DEFAULT '1'::smallint,
    price_type smallint DEFAULT '1'::smallint,
    rate_type smallint DEFAULT '1'::smallint,
    update_at timestamp with time zone,
    update_by character varying,
    "interval" integer,
    min_time integer,
    rate_per_sms_received numeric,
    rate_per_sms_sent numeric,
    client_id integer
);


ALTER TABLE public.did_billing_plan OWNER TO class4_user;

--
-- Name: did_billing_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_billing_plan_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_billing_plan_id_seq OWNER TO class4_user;

--
-- Name: did_billing_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_billing_plan_id_seq OWNED BY public.did_billing_plan.id;


--
-- Name: did_billing_plan_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_billing_plan_record (
    id integer NOT NULL,
    did_price real,
    min_price real,
    name character varying(255),
    payphone_subcharge character varying,
    monthly_charge numeric,
    rate_table_id integer,
    pay_type smallint,
    price_type smallint,
    rate_type smallint,
    update_at timestamp with time zone,
    update_by character varying,
    "interval" integer,
    min_time integer,
    rate_per_sms_received numeric,
    rate_per_sms_sent numeric,
    client_id integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.did_billing_plan_record OWNER TO class4_user;

--
-- Name: did_billing_plan_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_billing_plan_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_billing_plan_record_record_id_seq OWNER TO class4_user;

--
-- Name: did_billing_plan_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_billing_plan_record_record_id_seq OWNED BY public.did_billing_plan_record.record_id;


--
-- Name: did_billing_rel; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_billing_rel (
    id integer NOT NULL,
    did character varying(50) NOT NULL,
    sell_billing_plan_id integer,
    buy_billing_plan_id integer,
    did_billing_id integer,
    start_date timestamp with time zone,
    ingress_res_id integer,
    egress_res_id integer,
    end_date timestamp with time zone,
    is_available boolean,
    status smallint DEFAULT '0'::smallint,
    is_sms boolean,
    assigned_client_id integer,
    ip character varying(50),
    note character varying(16)
);


ALTER TABLE public.did_billing_rel OWNER TO class4_user;

--
-- Name: did_billing_rel_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_billing_rel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_billing_rel_id_seq OWNER TO class4_user;

--
-- Name: did_billing_rel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_billing_rel_id_seq OWNED BY public.did_billing_rel.id;


--
-- Name: did_billing_rel_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_billing_rel_record (
    id integer NOT NULL,
    did character varying(50) NOT NULL,
    sell_billing_plan_id integer,
    buy_billing_plan_id integer,
    did_billing_id integer,
    start_date timestamp with time zone,
    ingress_res_id integer,
    egress_res_id integer,
    end_date timestamp with time zone,
    is_available boolean,
    status smallint,
    is_sms boolean,
    assigned_client_id integer,
    ip character varying(50),
    note character varying(16),
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.did_billing_rel_record OWNER TO class4_user;

--
-- Name: did_billing_rel_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_billing_rel_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_billing_rel_record_record_id_seq OWNER TO class4_user;

--
-- Name: did_billing_rel_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_billing_rel_record_record_id_seq OWNED BY public.did_billing_rel_record.record_id;


--
-- Name: did_charge_detail; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_charge_detail (
    id integer NOT NULL,
    params character varying(4096),
    did_number character varying(64) NOT NULL,
    client_billing_plan_id integer,
    client_trunk_id integer,
    nrc numeric DEFAULT 0.00 NOT NULL,
    mrc numeric DEFAULT 0.00 NOT NULL,
    minutes integer DEFAULT 0,
    attempts integer DEFAULT 0,
    call_charge numeric DEFAULT 0.00 NOT NULL,
    start_date date,
    end_date date,
    mrc_number integer DEFAULT 0,
    pay_type integer DEFAULT 0,
    created_on timestamp with time zone DEFAULT now(),
    vendor_trunk_id integer,
    port_fee numeric DEFAULT 0.00 NOT NULL
);


ALTER TABLE public.did_charge_detail OWNER TO class4_user;

--
-- Name: did_charge_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_charge_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_charge_detail_id_seq OWNER TO class4_user;

--
-- Name: did_charge_detail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_charge_detail_id_seq OWNED BY public.did_charge_detail.id;


--
-- Name: did_client_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_client_log (
    id integer NOT NULL,
    did character varying(50) NOT NULL,
    client_id integer,
    assigned_on timestamp with time zone,
    assigned_by integer,
    released_on timestamp with time zone DEFAULT now(),
    released_by integer,
    assign_method smallint,
    release_method smallint,
    created_on timestamp with time zone DEFAULT now(),
    sell_billing_plan_id integer,
    buy_billing_plan_id integer,
    start_date timestamp with time zone,
    ingress_res_id integer,
    egress_res_id integer
);


ALTER TABLE public.did_client_log OWNER TO class4_user;

--
-- Name: COLUMN did_client_log.assign_method; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.did_client_log.assign_method IS '0 - admin assign via UI/API 1 - admin assign via Import 2- client purchase from portal';


--
-- Name: COLUMN did_client_log.release_method; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.did_client_log.release_method IS '0 - admin release via UI/API 1 - admin release via UI/API 2 - client release via portal 3 - auto expiry due to end-date met';


--
-- Name: did_client_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_client_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_client_log_id_seq OWNER TO class4_user;

--
-- Name: did_client_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_client_log_id_seq OWNED BY public.did_client_log.id;


--
-- Name: did_cost_detail; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_cost_detail (
    id integer NOT NULL,
    params character varying(4096),
    created_on timestamp with time zone DEFAULT now(),
    did_number character varying(64) NOT NULL,
    client_billing_plan_id integer,
    client_trunk_id integer,
    vendor_trunk_id integer,
    nrc numeric DEFAULT 0.00 NOT NULL,
    mrc numeric DEFAULT 0.00 NOT NULL,
    minutes integer DEFAULT 0,
    attempts integer DEFAULT 0,
    vendor_cost numeric DEFAULT 0.00 NOT NULL,
    client_cost numeric DEFAULT 0.00 NOT NULL,
    start_date date,
    end_date date,
    mrc_number integer DEFAULT 0,
    pay_type integer DEFAULT 0
);


ALTER TABLE public.did_cost_detail OWNER TO class4_user;

--
-- Name: did_cost_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_cost_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_cost_detail_id_seq OWNER TO class4_user;

--
-- Name: did_cost_detail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_cost_detail_id_seq OWNED BY public.did_cost_detail.id;


--
-- Name: did_disconnect_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_disconnect_task (
    id integer NOT NULL,
    operator_user character varying(40),
    data json,
    release_on_time timestamp with time zone,
    started_at timestamp with time zone,
    finished_at timestamp with time zone,
    error_count integer,
    reply json,
    success boolean,
    success_count integer
);


ALTER TABLE public.did_disconnect_task OWNER TO class4_user;

--
-- Name: did_disconnect_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_disconnect_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_disconnect_task_id_seq OWNER TO class4_user;

--
-- Name: did_disconnect_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_disconnect_task_id_seq OWNED BY public.did_disconnect_task.id;


--
-- Name: did_export_async_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_export_async_task (
    id integer NOT NULL,
    request_client_id integer,
    user_id integer,
    did_client_id integer,
    did_vendor_id integer,
    did_prefix character varying(30),
    did_is_active boolean,
    did_is_assigned boolean,
    did_end_dated boolean,
    job_start_time integer,
    job_end_time integer,
    msg character varying(512),
    progress character varying(4),
    count integer,
    size integer,
    status smallint,
    action smallint,
    orig_file character varying(512)
);


ALTER TABLE public.did_export_async_task OWNER TO class4_user;

--
-- Name: did_export_async_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_export_async_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_export_async_task_id_seq OWNER TO class4_user;

--
-- Name: did_export_async_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_export_async_task_id_seq OWNED BY public.did_export_async_task.id;


--
-- Name: did_invoice_charge_breakdown; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_invoice_charge_breakdown (
    id integer NOT NULL,
    invoice_number integer,
    client_billing_plan_id integer,
    client_trunk_id integer,
    nrc numeric DEFAULT 0.00 NOT NULL,
    mrc numeric DEFAULT 0.00 NOT NULL,
    minutes integer DEFAULT 0,
    attempts integer DEFAULT 0,
    call_charge numeric DEFAULT 0.00 NOT NULL,
    did_count integer DEFAULT 0
);


ALTER TABLE public.did_invoice_charge_breakdown OWNER TO class4_user;

--
-- Name: did_invoice_charge_breakdown_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_invoice_charge_breakdown_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_invoice_charge_breakdown_id_seq OWNER TO class4_user;

--
-- Name: did_invoice_charge_breakdown_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_invoice_charge_breakdown_id_seq OWNED BY public.did_invoice_charge_breakdown.id;


--
-- Name: did_invoice_charge_detail; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_invoice_charge_detail (
    id integer NOT NULL,
    invoice_number integer,
    did_number character varying(64) NOT NULL,
    client_billing_plan_id integer,
    client_trunk_id integer,
    nrc numeric DEFAULT 0.00 NOT NULL,
    mrc numeric DEFAULT 0.00 NOT NULL,
    minutes integer DEFAULT 0,
    attempts integer DEFAULT 0,
    call_charge numeric DEFAULT 0.00 NOT NULL,
    start_date date,
    end_date date,
    mrc_number integer DEFAULT 0,
    pay_type integer DEFAULT 0
);


ALTER TABLE public.did_invoice_charge_detail OWNER TO class4_user;

--
-- Name: did_invoice_charge_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_invoice_charge_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_invoice_charge_detail_id_seq OWNER TO class4_user;

--
-- Name: did_invoice_charge_detail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_invoice_charge_detail_id_seq OWNED BY public.did_invoice_charge_detail.id;


--
-- Name: did_invoice_port_charge; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_invoice_port_charge (
    id integer NOT NULL,
    invoice_number integer,
    client_trunk_id integer,
    billing_port_type integer DEFAULT 0,
    price_per_max_channel numeric DEFAULT 0.00,
    max_channels integer DEFAULT 0,
    price_per_actual_channel numeric DEFAULT 0.00,
    did_count integer DEFAULT 0,
    cost_per_port numeric DEFAULT 0.00,
    port_charge numeric DEFAULT 0.00,
    capacity integer DEFAULT 0,
    dnis_cap_limit integer DEFAULT 0,
    channels integer DEFAULT 0
);


ALTER TABLE public.did_invoice_port_charge OWNER TO class4_user;

--
-- Name: did_invoice_port_charge_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_invoice_port_charge_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_invoice_port_charge_id_seq OWNER TO class4_user;

--
-- Name: did_invoice_port_charge_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_invoice_port_charge_id_seq OWNED BY public.did_invoice_port_charge.id;


--
-- Name: did_number_assign_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_number_assign_task (
    id integer NOT NULL,
    operator_user character varying(40),
    upload_file_path character varying(256),
    upload_orig_file character varying(100),
    upload_format_file character varying(100),
    orig_name character varying(256),
    repeated_action smallint DEFAULT '0'::smallint,
    status smallint DEFAULT '0'::smallint NOT NULL,
    progress text,
    create_time timestamp with time zone DEFAULT now(),
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    import_export_logs_id integer,
    op_method smallint DEFAULT '0'::smallint,
    client_id integer,
    client_billing_rule_id integer
);


ALTER TABLE public.did_number_assign_task OWNER TO class4_user;

--
-- Name: did_number_assign_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_number_assign_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_number_assign_task_id_seq OWNER TO class4_user;

--
-- Name: did_number_assign_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_number_assign_task_id_seq OWNED BY public.did_number_assign_task.id;


--
-- Name: did_number_delete_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_number_delete_task (
    id integer NOT NULL,
    operator_user character varying(40),
    upload_file_path character varying(256),
    upload_orig_file character varying(100),
    upload_format_file character varying(100),
    repeated_action smallint DEFAULT '0'::smallint,
    status smallint DEFAULT '0'::smallint NOT NULL,
    progress text,
    create_time timestamp with time zone DEFAULT now(),
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    import_export_logs_id integer,
    op_method smallint DEFAULT '0'::smallint,
    client_id integer,
    vendor_id integer,
    orig_name character varying(256)
);


ALTER TABLE public.did_number_delete_task OWNER TO class4_user;

--
-- Name: did_number_delete_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_number_delete_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_number_delete_task_id_seq OWNER TO class4_user;

--
-- Name: did_number_delete_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_number_delete_task_id_seq OWNED BY public.did_number_delete_task.id;


--
-- Name: did_number_upload; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_number_upload (
    uuid character varying(36) NOT NULL,
    file character varying(512),
    created_on timestamp with time zone DEFAULT now(),
    created_by character varying(255),
    finished_on timestamp with time zone,
    status smallint DEFAULT '0'::smallint NOT NULL,
    result text,
    num_records integer,
    num_imported integer,
    num_skiped integer,
    duplicates_action smallint DEFAULT '0'::smallint NOT NULL,
    client_id integer,
    vendor_id integer,
    client_billing_rule_id integer,
    vendor_billing_rule_id integer
);


ALTER TABLE public.did_number_upload OWNER TO class4_user;

--
-- Name: did_number_upload_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_number_upload_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_number_upload_task_id_seq OWNER TO class4_user;

--
-- Name: did_number_upload_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_number_upload_task (
    status smallint DEFAULT '0'::smallint,
    id integer DEFAULT nextval('public.did_number_upload_task_id_seq'::regclass) NOT NULL,
    upload_format_file character varying(100),
    upload_orig_file character varying(100),
    repeated_action smallint,
    progress character varying(200),
    start_time timestamp with time zone,
    create_time timestamp with time zone DEFAULT now(),
    result_file_path character varying(256),
    end_time timestamp with time zone,
    import_export_logs_id integer,
    upload_file_path character varying(256),
    operator_user character varying(40),
    op_method smallint DEFAULT '0'::smallint,
    did_vendor_name character varying(100),
    vendor_billing_rule_name character varying(100),
    enable_for_clients smallint DEFAULT '0'::smallint,
    client_billing_rule_name character varying(100),
    did_client_name character varying(100)
);


ALTER TABLE public.did_number_upload_task OWNER TO class4_user;

--
-- Name: COLUMN did_number_upload_task.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.did_number_upload_task.status IS '0 - Init; 1 - Processing; 2 - Uploading; 3 - Finished; 4 - Error';


--
-- Name: COLUMN did_number_upload_task.repeated_action; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.did_number_upload_task.repeated_action IS '0 - Skip duplicates; 1 - Overwrite duplicates';


--
-- Name: COLUMN did_number_upload_task.op_method; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.did_number_upload_task.op_method IS '0 - Insert; 1 - Release; 2 - Delete; 3 - Assign';


--
-- Name: did_param; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_param (
    did character varying(11) NOT NULL,
    country_iso character varying(3),
    ocn character varying(8),
    lata character varying(8),
    rate_type character varying,
    clec character varying,
    type smallint DEFAULT '0'::smallint,
    state character varying(3),
    company character varying,
    switch character varying
);


ALTER TABLE public.did_param OWNER TO class4_user;

--
-- Name: did_product; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_product (
    id integer NOT NULL,
    name character varying(40),
    created_by character varying(40),
    created_on timestamp with time zone DEFAULT now()
);


ALTER TABLE public.did_product OWNER TO class4_user;

--
-- Name: did_product_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_product_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_product_id_seq OWNER TO class4_user;

--
-- Name: did_product_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_product_id_seq OWNED BY public.did_product.id;


--
-- Name: did_product_item; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_product_item (
    id integer NOT NULL,
    did_product_id integer,
    country character varying(20),
    type smallint DEFAULT '0'::smallint,
    billing_rule_id integer,
    created_by character varying(40),
    created_on timestamp with time zone DEFAULT now()
);


ALTER TABLE public.did_product_item OWNER TO class4_user;

--
-- Name: did_product_item_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_product_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_product_item_id_seq OWNER TO class4_user;

--
-- Name: did_product_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_product_item_id_seq OWNED BY public.did_product_item.id;


--
-- Name: did_report; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_report (
    report_time timestamp with time zone,
    duration integer,
    ingress_bill_time integer,
    ingress_call_cost numeric(15,6),
    ingress_total_calls integer,
    not_zero_calls integer,
    ingress_success_calls integer,
    ingress_client_id integer,
    ingress_id integer,
    egress_client_id integer,
    egress_id integer,
    egress_bill_time integer,
    egress_call_cost numeric(15,6),
    egress_total_calls integer,
    egress_success_calls integer,
    did character varying(100),
    ingress_ip text,
    egress_ip text,
    pdd integer,
    ingress_busy_calls integer,
    egress_busy_calls integer,
    ingress_cancel_calls integer,
    egress_cancel_calls integer,
    cdr_date character varying(24),
    mrc numeric,
    nrc numeric,
    port_fee numeric
);


ALTER TABLE public.did_report OWNER TO class4_user;

--
-- Name: did_repository; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_repository (
    id bigint NOT NULL,
    did character varying(50) NOT NULL,
    vendor_id integer NOT NULL,
    vendor_trunk_id integer NOT NULL,
    vendor_billing_plan_id integer NOT NULL,
    created_at timestamp with time zone DEFAULT now(),
    created_by integer,
    is_available boolean
);


ALTER TABLE public.did_repository OWNER TO class4_user;

--
-- Name: COLUMN did_repository.created_by; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.did_repository.created_by IS '0 - UI; 1 - API; 2 - Mass Import';


--
-- Name: COLUMN did_repository.is_available; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.did_repository.is_available IS 'Is visible for clients';


--
-- Name: did_repository_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_repository_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_repository_id_seq OWNER TO class4_user;

--
-- Name: did_repository_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_repository_id_seq OWNED BY public.did_repository.id;


--
-- Name: did_repository_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_repository_log (
    id bigint NOT NULL,
    did character varying(50),
    vendor_id integer,
    vendor_trunk_id integer,
    vendor_billing_plan_id integer,
    created_at date NOT NULL,
    created_at_time timestamp with time zone,
    created_by integer,
    deleted_at date,
    deleted_by integer,
    deleted_at_time timestamp with time zone
)
PARTITION BY RANGE (created_at);


ALTER TABLE public.did_repository_log OWNER TO class4_user;

--
-- Name: did_repository_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_repository_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_repository_log_id_seq OWNER TO class4_user;

--
-- Name: did_repository_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_repository_log_id_seq OWNED BY public.did_repository_log.id;


--
-- Name: did_transaction; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_transaction (
    id integer NOT NULL,
    date timestamp with time zone DEFAULT now() NOT NULL,
    did_number character varying(50) NOT NULL,
    client_id integer NOT NULL,
    mrc numeric,
    nrc numeric,
    created_on timestamp with time zone DEFAULT now() NOT NULL
)
PARTITION BY RANGE (date);


ALTER TABLE public.did_transaction OWNER TO class4_user;

--
-- Name: did_transaction_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_transaction_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_transaction_id_seq OWNER TO class4_user;

--
-- Name: did_transaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_transaction_id_seq OWNED BY public.did_transaction.id;


--
-- Name: did_vendor_api; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_vendor_api (
    id integer NOT NULL,
    type smallint DEFAULT '1'::smallint,
    username character varying(64),
    password character varying(64),
    sms_enabled boolean,
    default_received_sms_url text,
    vendor_billing_rule_id integer,
    client_billing_rule_id integer,
    api_enabled boolean DEFAULT true,
    trunk_group_name character varying(128),
    msg_api_key character varying(64),
    toll_free_routing_label character varying(128),
    search_type smallint
);


ALTER TABLE public.did_vendor_api OWNER TO class4_user;

--
-- Name: did_vendor_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.did_vendor_log (
    id integer NOT NULL,
    did character varying(50) NOT NULL,
    vendor_id integer,
    created_on timestamp with time zone,
    created_by integer,
    deleted_on timestamp with time zone,
    deleted_by integer,
    created_method smallint,
    delete_method smallint,
    api_vendor_type smallint DEFAULT '0'::smallint
);


ALTER TABLE public.did_vendor_log OWNER TO class4_user;

--
-- Name: did_vendor_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.did_vendor_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.did_vendor_log_id_seq OWNER TO class4_user;

--
-- Name: did_vendor_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.did_vendor_log_id_seq OWNED BY public.did_vendor_log.id;


--
-- Name: digit_translation; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.digit_translation (
    translation_id integer NOT NULL,
    translation_name character varying(100) NOT NULL,
    translation timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL
);


ALTER TABLE public.digit_translation OWNER TO class4_user;

--
-- Name: TABLE digit_translation; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.digit_translation IS '主被叫号码转换';


--
-- Name: COLUMN digit_translation.translation_name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.digit_translation.translation_name IS '名称';


--
-- Name: COLUMN digit_translation.translation; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.digit_translation.translation IS '更新时间';


--
-- Name: digit_translation_translation_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.digit_translation_translation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.digit_translation_translation_id_seq OWNER TO class4_user;

--
-- Name: digit_translation_translation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.digit_translation_translation_id_seq OWNED BY public.digit_translation.translation_id;


--
-- Name: disk_management; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.disk_management (
    id integer NOT NULL,
    days_of_cdr_keep integer DEFAULT 365 NOT NULL,
    days_of_pcap_keep integer DEFAULT 365 NOT NULL,
    create_time timestamp with time zone DEFAULT now()
);


ALTER TABLE public.disk_management OWNER TO class4_user;

--
-- Name: disk_management_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.disk_management_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.disk_management_id_seq OWNER TO class4_user;

--
-- Name: disk_management_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.disk_management_id_seq OWNED BY public.disk_management.id;


--
-- Name: dnis_type_name; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dnis_type_name (
    id integer NOT NULL,
    name character varying(100) NOT NULL
);


ALTER TABLE public.dnis_type_name OWNER TO class4_user;

--
-- Name: dnis_type_name_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.dnis_type_name_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dnis_type_name_id_seq OWNER TO class4_user;

--
-- Name: dnis_type_name_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.dnis_type_name_id_seq OWNED BY public.dnis_type_name.id;


--
-- Name: dnl_cloud_dbman_cfg; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dnl_cloud_dbman_cfg (
    server_name character varying(256) NOT NULL,
    server_use_ssl boolean DEFAULT false,
    cdr_storage_cfg_uuid character varying(36),
    pcap_storage_cfg_uuid character varying(36),
    keep_cdr integer,
    keep_pcap integer,
    keep_cdr_archives integer,
    keep_pcap_archives integer,
    keep_cdr_remote integer,
    keep_pcap_remote integer,
    hourly_cdr_backup boolean DEFAULT false NOT NULL,
    server_ip character varying(16) DEFAULT NULL::character varying,
    server_port integer,
    server_ip_whitelist text,
    server_ip_blacklist text,
    server_con_limit integer,
    server_per_ip_con_limit integer,
    server_con_timeout integer,
    log_level integer DEFAULT 0,
    log_dir_path text,
    disable_logfile boolean DEFAULT false,
    enable_postgresql_log boolean DEFAULT false,
    tmp_dir_path text,
    disable_tmp_dir boolean DEFAULT false,
    startup_delay integer,
    run_on_start boolean DEFAULT false NOT NULL,
    CONSTRAINT dnl_cloud_dbman_cfg_check CHECK ((((server_ip_whitelist IS NOT NULL) AND (server_ip_blacklist IS NOT NULL)) IS FALSE)),
    CONSTRAINT dnl_cloud_dbman_cfg_keep_cdr_archives_check CHECK ((keep_cdr_archives > 0)),
    CONSTRAINT dnl_cloud_dbman_cfg_keep_cdr_check CHECK ((keep_cdr > 0)),
    CONSTRAINT dnl_cloud_dbman_cfg_keep_cdr_remote_check CHECK ((keep_cdr_remote > 0)),
    CONSTRAINT dnl_cloud_dbman_cfg_keep_pcap_archives_check CHECK ((keep_pcap_archives > 0)),
    CONSTRAINT dnl_cloud_dbman_cfg_keep_pcap_check CHECK ((keep_pcap > 0)),
    CONSTRAINT dnl_cloud_dbman_cfg_keep_pcap_remote_check CHECK ((keep_pcap_remote > 0)),
    CONSTRAINT dnl_cloud_dbman_cfg_log_level_check CHECK (((log_level >= '-1'::integer) AND (log_level < 3))),
    CONSTRAINT dnl_cloud_dbman_cfg_server_con_limit_check CHECK ((server_con_limit > 0)),
    CONSTRAINT dnl_cloud_dbman_cfg_server_con_timeout_check CHECK ((server_con_timeout > 0)),
    CONSTRAINT dnl_cloud_dbman_cfg_server_per_ip_con_limit_check CHECK ((server_per_ip_con_limit > 0)),
    CONSTRAINT dnl_cloud_dbman_cfg_server_port_check CHECK (((server_port > 0) AND (server_port < 65536))),
    CONSTRAINT dnl_cloud_dbman_cfg_startup_delay_check CHECK (((startup_delay >= 0) AND (startup_delay < 86400)))
);


ALTER TABLE public.dnl_cloud_dbman_cfg OWNER TO class4_user;

--
-- Name: dnl_cloud_downloader_cfg; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dnl_cloud_downloader_cfg (
    server_name character varying(256) NOT NULL,
    server_use_ssl boolean DEFAULT false,
    server_ip character varying(16) DEFAULT NULL::character varying,
    server_port integer,
    server_ip_whitelist text,
    server_ip_blacklist text,
    server_con_limit integer,
    server_per_ip_con_limit integer,
    server_con_timeout integer,
    log_level integer DEFAULT 0,
    log_dir_path text,
    disable_logfile boolean DEFAULT false,
    enable_postgresql_log boolean DEFAULT false,
    tmp_dir_path text,
    disable_tmp_dir boolean DEFAULT false,
    CONSTRAINT dnl_cloud_downloader_cfg_check CHECK ((((server_ip_whitelist IS NOT NULL) AND (server_ip_blacklist IS NOT NULL)) IS FALSE)),
    CONSTRAINT dnl_cloud_downloader_cfg_log_level_check CHECK (((log_level >= '-1'::integer) AND (log_level < 3))),
    CONSTRAINT dnl_cloud_downloader_cfg_server_con_limit_check CHECK ((server_con_limit > 0)),
    CONSTRAINT dnl_cloud_downloader_cfg_server_con_timeout_check CHECK ((server_con_timeout > 0)),
    CONSTRAINT dnl_cloud_downloader_cfg_server_per_ip_con_limit_check CHECK ((server_per_ip_con_limit > 0)),
    CONSTRAINT dnl_cloud_downloader_cfg_server_port_check CHECK (((server_port > 0) AND (server_port < 65536)))
);


ALTER TABLE public.dnl_cloud_downloader_cfg OWNER TO class4_user;

--
-- Name: dnl_cloud_ftp_cfg; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dnl_cloud_ftp_cfg (
    uuid character varying(36) NOT NULL,
    ip character varying(16) NOT NULL,
    port integer NOT NULL,
    username text,
    password text,
    workdir text,
    use_relative_paths boolean DEFAULT false,
    netrc_path text,
    debug integer,
    CONSTRAINT dnl_cloud_ftp_cfg_check CHECK ((((btrim(username) = 'anonymous'::text) AND (password IS NULL)) OR (((btrim(username) = ''::text) IS FALSE) AND ((btrim(password) = ''::text) IS FALSE)) OR ((username IS NULL) AND (password IS NULL) AND ((btrim(netrc_path) = ''::text) IS FALSE)))),
    CONSTRAINT dnl_cloud_ftp_cfg_debug_check CHECK (((debug >= 0) AND (debug < 3))),
    CONSTRAINT dnl_cloud_ftp_cfg_ip_check CHECK (((btrim((ip)::text) = ''::text) IS FALSE)),
    CONSTRAINT dnl_cloud_ftp_cfg_port_check CHECK (((port > 0) AND (port < 65536)))
);


ALTER TABLE public.dnl_cloud_ftp_cfg OWNER TO class4_user;

--
-- Name: dnl_cloud_gcloud_cfg; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dnl_cloud_gcloud_cfg (
    uuid character varying(36) NOT NULL,
    type character varying(16) NOT NULL,
    bucket text NOT NULL,
    workdir text,
    key_file_path text,
    email text,
    secret text,
    token text,
    debug integer,
    json_key json,
    CONSTRAINT dnl_cloud_gcloud_cfg_bucket_check CHECK (((btrim(bucket) = ''::text) IS FALSE)),
    CONSTRAINT dnl_cloud_gcloud_cfg_check CHECK (((((type)::text = 'service'::text) AND ((btrim(key_file_path) = ''::text) IS FALSE)) OR (((type)::text = 'oauth2'::text) AND ((btrim(email) = ''::text) IS FALSE) AND ((btrim(secret) = ''::text) IS FALSE) AND ((btrim(token) = ''::text) IS FALSE)))),
    CONSTRAINT dnl_cloud_gcloud_cfg_debug_check CHECK (((debug >= 0) AND (debug < 3)))
);


ALTER TABLE public.dnl_cloud_gcloud_cfg OWNER TO class4_user;

--
-- Name: dnl_cloud_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dnl_cloud_log (
    id integer NOT NULL,
    "time" timestamp without time zone DEFAULT now() NOT NULL,
    instance character varying(128) NOT NULL,
    level character varying(16) NOT NULL,
    msg text NOT NULL,
    server_name character varying(256) DEFAULT true NOT NULL,
    CONSTRAINT dnl_cloud_log_instance_check CHECK (((btrim((instance)::text) = ''::text) IS FALSE)),
    CONSTRAINT dnl_cloud_log_level_check CHECK (((btrim((level)::text) = ''::text) IS FALSE))
);


ALTER TABLE public.dnl_cloud_log OWNER TO class4_user;

--
-- Name: dnl_cloud_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.dnl_cloud_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dnl_cloud_log_id_seq OWNER TO class4_user;

--
-- Name: dnl_cloud_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.dnl_cloud_log_id_seq OWNED BY public.dnl_cloud_log.id;


--
-- Name: dnl_cloud_search_cfg; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dnl_cloud_search_cfg (
    server_name character varying(256) NOT NULL,
    server_use_ssl boolean DEFAULT false,
    pcap_time_margin integer,
    req_exp_time integer,
    threads_max integer,
    server_ip character varying(16) DEFAULT NULL::character varying,
    server_port integer,
    server_ip_whitelist text,
    server_ip_blacklist text,
    server_con_limit integer,
    server_per_ip_con_limit integer,
    server_con_timeout integer,
    log_level integer DEFAULT 0,
    log_dir_path text,
    disable_logfile boolean DEFAULT false,
    enable_postgresql_log boolean DEFAULT false,
    tmp_dir_path text,
    CONSTRAINT dnl_cloud_search_cfg_check CHECK ((((server_ip_whitelist IS NOT NULL) AND (server_ip_blacklist IS NOT NULL)) IS FALSE)),
    CONSTRAINT dnl_cloud_search_cfg_log_level_check CHECK (((log_level >= '-1'::integer) AND (log_level < 3))),
    CONSTRAINT dnl_cloud_search_cfg_pcap_time_margin_check CHECK ((pcap_time_margin >= 0)),
    CONSTRAINT dnl_cloud_search_cfg_req_exp_time_check CHECK ((req_exp_time >= 0)),
    CONSTRAINT dnl_cloud_search_cfg_server_con_limit_check CHECK ((server_con_limit > 0)),
    CONSTRAINT dnl_cloud_search_cfg_server_con_timeout_check CHECK ((server_con_timeout > 0)),
    CONSTRAINT dnl_cloud_search_cfg_server_per_ip_con_limit_check CHECK ((server_per_ip_con_limit > 0)),
    CONSTRAINT dnl_cloud_search_cfg_server_port_check CHECK (((server_port > 0) AND (server_port < 65536))),
    CONSTRAINT dnl_cloud_search_cfg_threads_max_check CHECK ((threads_max >= 0))
);


ALTER TABLE public.dnl_cloud_search_cfg OWNER TO class4_user;

--
-- Name: dnl_cloud_sftp_cfg; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dnl_cloud_sftp_cfg (
    uuid character varying(36) NOT NULL,
    ip character varying(16) NOT NULL,
    port integer NOT NULL,
    username text,
    password text,
    workdir text,
    pubkey_path text,
    privkey_path text,
    passphrase text,
    debug integer,
    CONSTRAINT dnl_cloud_sftp_cfg_check CHECK (((((btrim(username) = ''::text) IS FALSE) AND ((btrim(password) = ''::text) IS FALSE)) OR ((username IS NULL) AND (password IS NULL) AND ((btrim(privkey_path) = ''::text) IS FALSE)))),
    CONSTRAINT dnl_cloud_sftp_cfg_debug_check CHECK (((debug >= 0) AND (debug < 3))),
    CONSTRAINT dnl_cloud_sftp_cfg_ip_check CHECK (((btrim((ip)::text) = ''::text) IS FALSE)),
    CONSTRAINT dnl_cloud_sftp_cfg_port_check CHECK (((port > 0) AND (port < 65536)))
);


ALTER TABLE public.dnl_cloud_sftp_cfg OWNER TO class4_user;

--
-- Name: dnl_cloud_status; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dnl_cloud_status (
    server_name character varying(256) NOT NULL,
    instance character varying(128) NOT NULL,
    operation text,
    is_online boolean DEFAULT false,
    upd_time timestamp without time zone DEFAULT now() NOT NULL,
    server_ip character varying(16) DEFAULT NULL::character varying,
    server_port integer,
    server_use_ssl boolean DEFAULT false,
    switch_list text DEFAULT 'NULL'::text,
    CONSTRAINT dnl_cloud_status_server_ip_check CHECK (((btrim((server_ip)::text) = ''::text) IS FALSE)),
    CONSTRAINT dnl_cloud_status_server_port_check CHECK (((server_port > 0) AND (server_port < 65536)))
);


ALTER TABLE public.dnl_cloud_status OWNER TO class4_user;

--
-- Name: dnl_cloud_storages; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dnl_cloud_storages (
    uuid character varying(36) NOT NULL,
    type character varying(16),
    CONSTRAINT dnl_cloud_storages_type_check CHECK ((((type)::text = 'ftp'::text) OR ((type)::text = 'sftp'::text) OR ((type)::text = 'gcloud'::text))),
    CONSTRAINT dnl_cloud_storages_uuid_check CHECK (((btrim((uuid)::text) = ''::text) IS FALSE))
);


ALTER TABLE public.dnl_cloud_storages OWNER TO class4_user;

--
-- Name: dnl_daily_cdr_cloud_cfg; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dnl_daily_cdr_cloud_cfg (
    param_name text NOT NULL,
    param_value text NOT NULL
);


ALTER TABLE public.dnl_daily_cdr_cloud_cfg OWNER TO class4_user;

--
-- Name: dynamic_route; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dynamic_route (
    dynamic_route_id integer NOT NULL,
    name character varying(100) NOT NULL,
    routing_rule integer DEFAULT 6 NOT NULL,
    time_profile_id integer,
    update_at timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    update_by character varying,
    lcr_flag integer DEFAULT 1,
    is_virtual boolean
);


ALTER TABLE public.dynamic_route OWNER TO class4_user;

--
-- Name: TABLE dynamic_route; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.dynamic_route IS '动态路由';


--
-- Name: COLUMN dynamic_route.routing_rule; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.dynamic_route.routing_rule IS '路由规则：4 – 按最大ASR；5 – 按最大ACD；6 – 按最低费用';


--
-- Name: COLUMN dynamic_route.lcr_flag; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.dynamic_route.lcr_flag IS '1-15分钟;2-30分钟;3-1小时;4-1天';


--
-- Name: dynamic_route_dynamic_route_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.dynamic_route_dynamic_route_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dynamic_route_dynamic_route_id_seq OWNER TO class4_user;

--
-- Name: dynamic_route_dynamic_route_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.dynamic_route_dynamic_route_id_seq OWNED BY public.dynamic_route.dynamic_route_id;


--
-- Name: dynamic_route_items; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dynamic_route_items (
    id integer NOT NULL,
    dynamic_route_id integer NOT NULL,
    resource_id integer NOT NULL
);


ALTER TABLE public.dynamic_route_items OWNER TO class4_user;

--
-- Name: dynamic_route_items_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.dynamic_route_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dynamic_route_items_id_seq OWNER TO class4_user;

--
-- Name: dynamic_route_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.dynamic_route_items_id_seq OWNED BY public.dynamic_route_items.id;


--
-- Name: dynamic_route_items_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dynamic_route_items_record (
    id integer NOT NULL,
    dynamic_route_id integer NOT NULL,
    resource_id integer NOT NULL,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.dynamic_route_items_record OWNER TO class4_user;

--
-- Name: dynamic_route_items_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.dynamic_route_items_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dynamic_route_items_record_record_id_seq OWNER TO class4_user;

--
-- Name: dynamic_route_items_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.dynamic_route_items_record_record_id_seq OWNED BY public.dynamic_route_items_record.record_id;


--
-- Name: dynamic_route_override; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dynamic_route_override (
    id integer NOT NULL,
    dynamic_route_id integer NOT NULL,
    digits public.prefix_range DEFAULT ''::public.prefix_range NOT NULL,
    resource_id integer NOT NULL,
    percentage integer NOT NULL
);


ALTER TABLE public.dynamic_route_override OWNER TO class4_user;

--
-- Name: dynamic_route_override_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.dynamic_route_override_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dynamic_route_override_id_seq OWNER TO class4_user;

--
-- Name: dynamic_route_override_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.dynamic_route_override_id_seq OWNED BY public.dynamic_route_override.id;


--
-- Name: dynamic_route_override_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dynamic_route_override_record (
    id integer NOT NULL,
    dynamic_route_id integer NOT NULL,
    digits public.prefix_range NOT NULL,
    resource_id integer NOT NULL,
    percentage integer NOT NULL,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.dynamic_route_override_record OWNER TO class4_user;

--
-- Name: dynamic_route_override_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.dynamic_route_override_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dynamic_route_override_record_record_id_seq OWNER TO class4_user;

--
-- Name: dynamic_route_override_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.dynamic_route_override_record_record_id_seq OWNED BY public.dynamic_route_override_record.record_id;


--
-- Name: dynamic_route_pri; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dynamic_route_pri (
    id integer NOT NULL,
    dynamic_route_id integer NOT NULL,
    digits public.prefix_range DEFAULT ''::public.prefix_range NOT NULL,
    resource_id integer NOT NULL,
    resource_pri integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.dynamic_route_pri OWNER TO class4_user;

--
-- Name: dynamic_route_pri_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.dynamic_route_pri_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dynamic_route_pri_id_seq OWNER TO class4_user;

--
-- Name: dynamic_route_pri_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.dynamic_route_pri_id_seq OWNED BY public.dynamic_route_pri.id;


--
-- Name: dynamic_route_pri_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dynamic_route_pri_record (
    id integer NOT NULL,
    dynamic_route_id integer NOT NULL,
    digits public.prefix_range NOT NULL,
    resource_id integer NOT NULL,
    resource_pri integer NOT NULL,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.dynamic_route_pri_record OWNER TO class4_user;

--
-- Name: dynamic_route_pri_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.dynamic_route_pri_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dynamic_route_pri_record_record_id_seq OWNER TO class4_user;

--
-- Name: dynamic_route_pri_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.dynamic_route_pri_record_record_id_seq OWNED BY public.dynamic_route_pri_record.record_id;


--
-- Name: dynamic_route_qos; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dynamic_route_qos (
    id integer NOT NULL,
    dynamic_route_id integer NOT NULL,
    digits public.prefix_range DEFAULT ''::public.prefix_range NOT NULL,
    min_asr real,
    max_asr real,
    min_abr real,
    max_abr real,
    min_acd real,
    max_acd real,
    min_pdd integer,
    max_pdd integer,
    min_aloc real,
    max_aloc real,
    limit_price real
);


ALTER TABLE public.dynamic_route_qos OWNER TO class4_user;

--
-- Name: dynamic_route_qos_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.dynamic_route_qos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dynamic_route_qos_id_seq OWNER TO class4_user;

--
-- Name: dynamic_route_qos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.dynamic_route_qos_id_seq OWNED BY public.dynamic_route_qos.id;


--
-- Name: dynamic_route_qos_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dynamic_route_qos_record (
    id integer NOT NULL,
    dynamic_route_id integer NOT NULL,
    digits public.prefix_range NOT NULL,
    min_asr real,
    max_asr real,
    min_abr real,
    max_abr real,
    min_acd real,
    max_acd real,
    min_pdd integer,
    max_pdd integer,
    min_aloc real,
    max_aloc real,
    limit_price real,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.dynamic_route_qos_record OWNER TO class4_user;

--
-- Name: dynamic_route_qos_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.dynamic_route_qos_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dynamic_route_qos_record_record_id_seq OWNER TO class4_user;

--
-- Name: dynamic_route_qos_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.dynamic_route_qos_record_record_id_seq OWNED BY public.dynamic_route_qos_record.record_id;


--
-- Name: dynamic_route_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.dynamic_route_record (
    dynamic_route_id integer NOT NULL,
    name character varying(100) NOT NULL,
    routing_rule integer NOT NULL,
    time_profile_id integer,
    update_at timestamp with time zone,
    update_by character varying,
    lcr_flag integer,
    is_virtual boolean,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.dynamic_route_record OWNER TO class4_user;

--
-- Name: dynamic_route_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.dynamic_route_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dynamic_route_record_record_id_seq OWNER TO class4_user;

--
-- Name: dynamic_route_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.dynamic_route_record_record_id_seq OWNED BY public.dynamic_route_record.record_id;


--
-- Name: egress_error_string; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.egress_error_string (
    id integer NOT NULL,
    name character varying(64)
);


ALTER TABLE public.egress_error_string OWNER TO class4_user;

--
-- Name: egress_error_string_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.egress_error_string_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.egress_error_string_id_seq OWNER TO class4_user;

--
-- Name: egress_error_string_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.egress_error_string_id_seq OWNED BY public.egress_error_string.id;


--
-- Name: egress_profile; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.egress_profile (
    id integer NOT NULL,
    egress_id integer,
    profile_id integer,
    server_name character varying(200),
    ingress_id integer
);


ALTER TABLE public.egress_profile OWNER TO class4_user;

--
-- Name: COLUMN egress_profile.ingress_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.egress_profile.ingress_id IS '－－ ingress_id + egress_id + server_name需要唯一';


--
-- Name: egress_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.egress_profile_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.egress_profile_id_seq OWNER TO class4_user;

--
-- Name: egress_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.egress_profile_id_seq OWNED BY public.egress_profile.id;


--
-- Name: egress_profile_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.egress_profile_record (
    id integer NOT NULL,
    egress_id integer,
    profile_id integer,
    server_name character varying(200),
    ingress_id integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.egress_profile_record OWNER TO class4_user;

--
-- Name: egress_profile_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.egress_profile_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.egress_profile_record_record_id_seq OWNER TO class4_user;

--
-- Name: egress_profile_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.egress_profile_record_record_id_seq OWNED BY public.egress_profile_record.record_id;


--
-- Name: email_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.email_log (
    id integer NOT NULL,
    send_time timestamp with time zone,
    client_id integer,
    email_addresses character varying(500),
    files character varying(500),
    type smallint,
    email_res text,
    alert_block_egress_id integer,
    alert_block_code_name text,
    status smallint,
    error text,
    resend_email text,
    subject character varying(100),
    content text,
    is_view integer DEFAULT 0 NOT NULL,
    sent_from character varying(100)
);


ALTER TABLE public.email_log OWNER TO class4_user;

--
-- Name: COLUMN email_log.type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.email_log.type IS '1,low balance
2,daily summary
3,auto delivery
4,alert_route
5,cdr_down
6,exchange_alert_route
7,invoice
21, Payment Received
22, Rule Alert
';


--
-- Name: COLUMN email_log.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.email_log.status IS '0，null-success；1-fail';


--
-- Name: COLUMN email_log.error; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.email_log.error IS 'email error';


--
-- Name: COLUMN email_log.is_view; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.email_log.is_view IS '是否在自助页面查看';


--
-- Name: email_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.email_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.email_log_id_seq OWNER TO class4_user;

--
-- Name: email_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.email_log_id_seq OWNED BY public.email_log.id;


--
-- Name: execution_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.execution_log (
    id integer NOT NULL,
    rule_name character varying(100),
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    ani_find character varying(500),
    of_calls character varying(100),
    msg text,
    status integer,
    exec_type integer
);


ALTER TABLE public.execution_log OWNER TO class4_user;

--
-- Name: TABLE execution_log; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.execution_log IS 'dialer detection 每次执行的时间和结果';


--
-- Name: execution_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.execution_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.execution_log_id_seq OWNER TO class4_user;

--
-- Name: execution_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.execution_log_id_seq OWNED BY public.execution_log.id;


--
-- Name: fault_route_alert_rule; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.fault_route_alert_rule (
    id integer NOT NULL,
    rule_name character varying(100),
    weekly_days character varying(7),
    daily_time time without time zone,
    product_id integer,
    routing_plan_id integer,
    look_days integer,
    min_profitable_trunks integer,
    from_mail_id integer,
    email_to character varying(100),
    subject character varying(200),
    html_content text,
    is_active boolean DEFAULT true,
    last_run_on timestamp with time zone,
    next_run_on timestamp with time zone,
    min_profitability double precision
);


ALTER TABLE public.fault_route_alert_rule OWNER TO class4_user;

--
-- Name: fault_route_alert_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.fault_route_alert_rule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.fault_route_alert_rule_id_seq OWNER TO class4_user;

--
-- Name: fault_route_alert_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.fault_route_alert_rule_id_seq OWNED BY public.fault_route_alert_rule.id;


--
-- Name: fault_route_alert_rule_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.fault_route_alert_rule_log (
    id integer NOT NULL,
    rule_id integer,
    started_on timestamp with time zone,
    finished_on timestamp with time zone,
    result text,
    status smallint,
    mail_sent boolean DEFAULT false,
    profitable_trunks integer,
    profitability double precision
);


ALTER TABLE public.fault_route_alert_rule_log OWNER TO class4_user;

--
-- Name: fault_route_alert_rule_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.fault_route_alert_rule_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.fault_route_alert_rule_log_id_seq OWNER TO class4_user;

--
-- Name: fault_route_alert_rule_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.fault_route_alert_rule_log_id_seq OWNED BY public.fault_route_alert_rule_log.id;


--
-- Name: file; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.file (
    uuid character varying(36) NOT NULL,
    path character varying(1024) NOT NULL,
    belongs_to_table character varying(255) NOT NULL,
    belongs_to_field character varying(255) NOT NULL,
    belongs_to_pk character varying(128),
    uploaded_on timestamp with time zone NOT NULL,
    attached_on timestamp with time zone DEFAULT now(),
    public boolean DEFAULT false
);


ALTER TABLE public.file OWNER TO class4_user;

--
-- Name: fraud_detection; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.fraud_detection (
    id integer NOT NULL,
    rule_name character varying(100),
    active boolean NOT NULL,
    hourly_minute integer,
    hourly_revenue integer,
    daily_minute integer,
    daily_revenue integer,
    is_block boolean,
    is_send_mail boolean,
    email_to integer,
    ingress_ids character varying(500),
    update_on timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    update_by character varying(100)
);


ALTER TABLE public.fraud_detection OWNER TO class4_user;

--
-- Name: COLUMN fraud_detection.hourly_minute; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.fraud_detection.hourly_minute IS '1小时内的分钟数';


--
-- Name: COLUMN fraud_detection.hourly_revenue; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.fraud_detection.hourly_revenue IS '1小时内的利润';


--
-- Name: COLUMN fraud_detection.daily_minute; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.fraud_detection.daily_minute IS '24小时内的分钟数';


--
-- Name: COLUMN fraud_detection.daily_revenue; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.fraud_detection.daily_revenue IS '24小时内的利润';


--
-- Name: COLUMN fraud_detection.email_to; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.fraud_detection.email_to IS '0: switch NOC; 1: Partner’s NOC; 2:both';


--
-- Name: fraud_detection_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.fraud_detection_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.fraud_detection_id_seq OWNER TO class4_user;

--
-- Name: fraud_detection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.fraud_detection_id_seq OWNED BY public.fraud_detection.id;


--
-- Name: fraud_detection_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.fraud_detection_log (
    id integer NOT NULL,
    fraud_detection_id integer,
    create_on timestamp with time zone DEFAULT now(),
    create_by integer,
    status integer,
    finish_time timestamp with time zone,
    "time" numeric DEFAULT date_part('epoch'::text, ('now'::text)::timestamp(0) with time zone)
);


ALTER TABLE public.fraud_detection_log OWNER TO class4_user;

--
-- Name: COLUMN fraud_detection_log.create_by; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.fraud_detection_log.create_by IS '0 auto; 1 Manual';


--
-- Name: COLUMN fraud_detection_log.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.fraud_detection_log.status IS '0 normal; 1 over limit';


--
-- Name: fraud_detection_log_detail; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.fraud_detection_log_detail (
    id integer NOT NULL,
    fraud_detection_log_id integer,
    ingress_id integer,
    block_type integer,
    limit_value integer,
    actual_value character varying(50),
    partner_email_msg text,
    partner_email_status boolean,
    partner_email character varying(200),
    system_email_msg text,
    system_email_status boolean,
    system_email character varying(200),
    is_block boolean DEFAULT false,
    is_send_email boolean DEFAULT false
);


ALTER TABLE public.fraud_detection_log_detail OWNER TO class4_user;

--
-- Name: COLUMN fraud_detection_log_detail.block_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.fraud_detection_log_detail.block_type IS '0 1h minute; 1 1h revenue; 2 24h minute; 3 24h revenue';


--
-- Name: fraud_detection_log_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.fraud_detection_log_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.fraud_detection_log_detail_id_seq OWNER TO class4_user;

--
-- Name: fraud_detection_log_detail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.fraud_detection_log_detail_id_seq OWNED BY public.fraud_detection_log_detail.id;


--
-- Name: fraud_detection_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.fraud_detection_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.fraud_detection_log_id_seq OWNER TO class4_user;

--
-- Name: fraud_detection_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.fraud_detection_log_id_seq OWNED BY public.fraud_detection_log.id;


--
-- Name: frund_detection; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.frund_detection (
    id integer NOT NULL,
    rule_name character varying(100),
    trunk_id_list character varying(100),
    criteria_1hour_min numeric,
    criteria_1hour_revenue numeric,
    criteria_24hour_min numeric,
    criteria_24hour_revenue numeric,
    is_block boolean,
    send_email_type integer,
    email_from integer,
    email_ticket_subject character varying(200),
    email_ticket_content text,
    trigger_criteria_1hour_time timestamp with time zone,
    trigger_criteria_24hour_time timestamp with time zone,
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    daily_acd_of_trunk_is_below integer,
    daily_asr_of_trunk_is_below integer,
    daily_cost_of_trunk_is_above integer,
    daily_minute_of_trunk_is_above integer,
    hourly_acd_of_trunk_is_below integer,
    hourly_asr_of_trunk_is_below integer,
    hourly_cost_of_trunk_is_above integer,
    hourly_minute_of_trunk_is_above integer,
    detection_level smallint
);


ALTER TABLE public.frund_detection OWNER TO class4_user;

--
-- Name: frund_detection_history; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.frund_detection_history (
    id integer NOT NULL,
    frund_detection_id integer,
    ingress_id integer,
    block_type integer,
    criteria_1hour_min numeric,
    criteria_1hour_revenue numeric,
    criteria_24hour_min numeric,
    criteria_24hour_revenue numeric,
    actual_1h_minute numeric,
    actual_24h_minute numeric,
    actual_1h_revenue numeric,
    actual_24h_revenue numeric,
    is_block boolean DEFAULT false,
    send_email_type integer,
    is_send_email boolean DEFAULT false,
    partner_email_msg text,
    partner_email_status boolean,
    partner_email character varying(200),
    system_email_msg text,
    system_email_status boolean,
    system_email character varying(200),
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    api_email_result character varying(1024),
    api_email_send_time timestamp with time zone
);


ALTER TABLE public.frund_detection_history OWNER TO class4_user;

--
-- Name: frund_detection_history_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.frund_detection_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.frund_detection_history_id_seq OWNER TO class4_user;

--
-- Name: frund_detection_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.frund_detection_history_id_seq OWNED BY public.frund_detection_history.id;


--
-- Name: frund_detection_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.frund_detection_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.frund_detection_id_seq OWNER TO class4_user;

--
-- Name: frund_detection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.frund_detection_id_seq OWNED BY public.frund_detection.id;


--
-- Name: ftp_cdr; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.ftp_cdr (
    ftp_user character varying(100) NOT NULL,
    ftp_pw character varying(100),
    run_freq integer,
    cdr_fields text,
    cdr_start_time timestamp with time zone,
    cdr_end_time timestamp with time zone,
    last_run_time timestamp with time zone,
    cdr_alias text
);


ALTER TABLE public.ftp_cdr OWNER TO class4_user;

--
-- Name: ftp_cdr_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.ftp_cdr_log (
    id integer NOT NULL,
    ftp_start_time timestamp with time zone,
    ftp_end_time timestamp with time zone,
    status integer,
    ftp_ip character varying(255),
    ftp_dir character varying,
    alias character varying(255),
    ftp_conf_id integer,
    cdr_start_time timestamp with time zone,
    cdr_end_time timestamp with time zone,
    pid integer,
    detail text
);


ALTER TABLE public.ftp_cdr_log OWNER TO class4_user;

--
-- Name: ftp_cdr_log_detail; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.ftp_cdr_log_detail (
    id integer NOT NULL,
    ftp_cdr_log_id integer NOT NULL,
    create_time timestamp with time zone,
    file_name character varying,
    ftp_ip character varying(255),
    ftp_dir character varying,
    detail text,
    local_file_path character varying(500)
);


ALTER TABLE public.ftp_cdr_log_detail OWNER TO class4_user;

--
-- Name: ftp_cdr_log_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.ftp_cdr_log_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ftp_cdr_log_detail_id_seq OWNER TO class4_user;

--
-- Name: ftp_cdr_log_detail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.ftp_cdr_log_detail_id_seq OWNED BY public.ftp_cdr_log_detail.id;


--
-- Name: ftp_cdr_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.ftp_cdr_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ftp_cdr_log_id_seq OWNER TO class4_user;

--
-- Name: ftp_cdr_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.ftp_cdr_log_id_seq OWNED BY public.ftp_cdr_log.id;


--
-- Name: ftp_conf; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.ftp_conf (
    id integer NOT NULL,
    server_ip character varying(100),
    server_port character varying(100),
    username character varying(100),
    password character varying(100),
    frequency smallint,
    fields text,
    headers text,
    contain_headers boolean,
    file_type integer,
    ingress_carriers text,
    egress_carriers text,
    ingress_carriers_all boolean,
    egress_carriers_all boolean,
    duration integer,
    ingress_release_cause character varying(255),
    egress_release_cause character varying(255),
    conditions text,
    ingresses text,
    egresses text,
    ingresses_all boolean,
    egresses_all boolean,
    "time" character varying(255),
    alias character varying(255),
    server_dir character varying(255),
    max_lines integer NOT NULL,
    active boolean,
    every_hours integer,
    file_breakdown integer,
    every_minutes integer,
    every_day integer,
    status smallint DEFAULT '0'::smallint
);


ALTER TABLE public.ftp_conf OWNER TO class4_user;

--
-- Name: ftp_conf_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.ftp_conf_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ftp_conf_id_seq OWNER TO class4_user;

--
-- Name: ftp_conf_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.ftp_conf_id_seq OWNED BY public.ftp_conf.id;


--
-- Name: ftp_server_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.ftp_server_log (
    id integer NOT NULL,
    "time" timestamp with time zone,
    cmd text,
    response text
);


ALTER TABLE public.ftp_server_log OWNER TO class4_user;

--
-- Name: ftp_server_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.ftp_server_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ftp_server_log_id_seq OWNER TO class4_user;

--
-- Name: ftp_server_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.ftp_server_log_id_seq OWNED BY public.ftp_server_log.id;


--
-- Name: global_route_error; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.global_route_error (
    id integer NOT NULL,
    error_code integer,
    error_description character varying(100),
    to_sip_code integer,
    to_sip_string character varying(100),
    default_to_sip_code integer,
    default_to_sip_string character varying(100)
);


ALTER TABLE public.global_route_error OWNER TO class4_user;

--
-- Name: TABLE global_route_error; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.global_route_error IS 'class4无法路由错误与返回给主叫的错误码全局配置

baohq20140423';


--
-- Name: COLUMN global_route_error.error_code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.global_route_error.error_code IS 'route error type

baohq20140423';


--
-- Name: COLUMN global_route_error.error_description; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.global_route_error.error_description IS 'route error description

baohq20140423';


--
-- Name: COLUMN global_route_error.to_sip_code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.global_route_error.to_sip_code IS '返回给主叫的sip错误码

baohq20140423';


--
-- Name: COLUMN global_route_error.to_sip_string; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.global_route_error.to_sip_string IS '返回给主叫的sip描述

baohq20140423';


--
-- Name: COLUMN global_route_error.default_to_sip_code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.global_route_error.default_to_sip_code IS 'baohq20140423';


--
-- Name: COLUMN global_route_error.default_to_sip_string; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.global_route_error.default_to_sip_string IS 'baohq20140423';


--
-- Name: global_route_error_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.global_route_error_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.global_route_error_id_seq OWNER TO class4_user;

--
-- Name: global_route_error_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.global_route_error_id_seq OWNED BY public.global_route_error.id;


--
-- Name: global_route_error_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.global_route_error_record (
    id integer NOT NULL,
    error_code integer,
    error_description character varying(100),
    to_sip_code integer,
    to_sip_string character varying(100),
    default_to_sip_code integer,
    default_to_sip_string character varying(100),
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.global_route_error_record OWNER TO class4_user;

--
-- Name: global_route_error_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.global_route_error_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.global_route_error_record_record_id_seq OWNER TO class4_user;

--
-- Name: global_route_error_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.global_route_error_record_record_id_seq OWNED BY public.global_route_error_record.record_id;


--
-- Name: host_based_report; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.host_based_report (
    report_time timestamp with time zone,
    duration integer,
    ingress_bill_time integer,
    ingress_call_cost numeric(15,6),
    ingress_total_calls integer,
    not_zero_calls integer,
    ingress_success_calls integer,
    ingress_busy_calls integer,
    pdd bigint,
    ingress_cancel_calls integer,
    ingress_client_id integer,
    egress_client_id integer,
    egress_bill_time integer,
    egress_call_cost numeric(15,6),
    egress_total_calls integer,
    egress_success_calls integer,
    egress_busy_calls integer,
    egress_cancel_calls integer,
    ingress_ip character varying(50),
    egress_ip character varying(50),
    ingress_avg_rate double precision,
    egress_avg_rate double precision,
    cdr_date character varying(24),
    ingress_duration integer,
    ingress_not_zero_calls integer
);


ALTER TABLE public.host_based_report OWNER TO class4_user;

--
-- Name: import_export_logs; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.import_export_logs (
    id integer NOT NULL,
    file_path character varying(300) DEFAULT ''::character varying NOT NULL,
    error_file_path character varying(300) DEFAULT ''::character varying NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    user_id integer DEFAULT 0 NOT NULL,
    obj character varying(80),
    log_type integer DEFAULT 0 NOT NULL,
    "time" timestamp with time zone,
    finished_time timestamp with time zone,
    duplicate_type character varying(16),
    ext_attributes text,
    server_id integer DEFAULT 0 NOT NULL,
    upload_table character varying(100),
    upload_type integer,
    db_error_file_path character varying(100),
    duplicate_numbers integer DEFAULT 0,
    foreign_id integer,
    success_numbers integer DEFAULT 0,
    error_row integer DEFAULT 0,
    error_rollback boolean DEFAULT false,
    php_process_number bigint DEFAULT 0,
    db_process_number bigint DEFAULT 0,
    foreign_name character varying(80),
    auto_enddate integer DEFAULT 0,
    custom_end_date timestamp with time zone,
    pid integer,
    myfile_filename character varying(100),
    is_public boolean,
    task_uuid character varying(36)
);


ALTER TABLE public.import_export_logs OWNER TO class4_user;

--
-- Name: TABLE import_export_logs; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.import_export_logs IS '上载／下载，日志';


--
-- Name: COLUMN import_export_logs.file_path; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.file_path IS '上传 下载 的文件的路径';


--
-- Name: COLUMN import_export_logs.error_file_path; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.error_file_path IS '上传文件时， 处理出错记录文件路径 ';


--
-- Name: COLUMN import_export_logs.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.status IS 'status==0上传文件到服务器
status==10
status==8文件已经验证完毕，成功导入临时表
status==9  PHP开始验证 －－导入临时表处理中
status==7正在进行数据库验证
status==6数据库验证完成  上传完成
status==-1表有错误(外键不存在)
1--processing
2--done
-2--upload file open error
-3--upload error file open error
-4--csv head error
-5--database error';


--
-- Name: COLUMN import_export_logs.log_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.log_type IS 'LOG_TYPE_EXPORT = 0; LOG_TYPE_IMPORT = 1;';


--
-- Name: COLUMN import_export_logs."time"; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs."time" IS '上传 下载的时间';


--
-- Name: COLUMN import_export_logs.finished_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.finished_time IS '上传 处理完的时间';


--
-- Name: COLUMN import_export_logs.duplicate_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.duplicate_type IS '上传时， 重复的处理方式';


--
-- Name: COLUMN import_export_logs.ext_attributes; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.ext_attributes IS '保存一些其它参数， 保存 serialize之后的格式';


--
-- Name: COLUMN import_export_logs.upload_table; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.upload_table IS '临时表名';


--
-- Name: COLUMN import_export_logs.upload_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.upload_type IS '1-ingress
2-egress
3-host
4-resource action
5-resource digit mapping
6-digit translation
7-resource block
8-jurisdiction
9-code deck
10-rate
11-static route
12-route plan';


--
-- Name: COLUMN import_export_logs.db_error_file_path; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.db_error_file_path IS '数据库验证错误文件目录';


--
-- Name: COLUMN import_export_logs.duplicate_numbers; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.duplicate_numbers IS '重复的行数';


--
-- Name: COLUMN import_export_logs.foreign_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.foreign_id IS '外键的id
6-digit translation
9-code deck
10-rate
11-static route
12-route plan';


--
-- Name: COLUMN import_export_logs.error_row; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.error_row IS '错误多少行';


--
-- Name: COLUMN import_export_logs.php_process_number; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.php_process_number IS 'php 验证处理多少行';


--
-- Name: COLUMN import_export_logs.db_process_number; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.db_process_number IS '数据库验证处理多少行';


--
-- Name: COLUMN import_export_logs.foreign_name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.import_export_logs.foreign_name IS '外键对应的name';


--
-- Name: import_export_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.import_export_logs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.import_export_logs_id_seq OWNER TO class4_user;

--
-- Name: import_export_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.import_export_logs_id_seq OWNED BY public.import_export_logs.id;


--
-- Name: import_rate_file_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.import_rate_file_log (
    id integer NOT NULL,
    file_path character varying(256),
    file_name character varying(225),
    client_id integer,
    egress_trunk_id integer,
    end_date character varying(225),
    date_format character varying(225),
    sample_do character varying(225),
    ratetable_id integer,
    status integer,
    product_id integer,
    agent_id integer,
    par_id integer,
    old_file_path character varying
);


ALTER TABLE public.import_rate_file_log OWNER TO class4_user;

--
-- Name: import_rate_file_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.import_rate_file_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.import_rate_file_log_id_seq OWNER TO class4_user;

--
-- Name: import_rate_file_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.import_rate_file_log_id_seq OWNED BY public.import_rate_file_log.id;


--
-- Name: import_rate_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.import_rate_log (
    id integer NOT NULL,
    import_file character varying(300),
    status integer NOT NULL,
    cli_type integer,
    dtmf boolean,
    g729 boolean,
    resource_id integer,
    prefix character varying(30),
    order_type integer NOT NULL,
    client_id integer,
    error_file integer,
    create_time timestamp with time zone,
    duplicate_type character varying(30),
    code_deck_id integer
);


ALTER TABLE public.import_rate_log OWNER TO class4_user;

--
-- Name: import_rate_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.import_rate_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.import_rate_log_id_seq OWNER TO class4_user;

--
-- Name: import_rate_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.import_rate_log_id_seq OWNED BY public.import_rate_log.id;


--
-- Name: import_rate_status; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.import_rate_status (
    id integer NOT NULL,
    rate_table_id integer,
    status integer,
    delete_queue integer,
    update_queue integer,
    insert_queue integer,
    error_counter integer,
    reimport_counter integer,
    error_log_file character varying(256),
    reimport_log_file character varying(256),
    "time" timestamp without time zone,
    upload_file_name character varying(256),
    local_file character varying(256),
    method integer,
    user_id integer,
    start_epoch bigint,
    end_epoch bigint,
    sql_record text,
    default_info character varying(200)
);


ALTER TABLE public.import_rate_status OWNER TO class4_user;

--
-- Name: import_rate_status_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.import_rate_status_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.import_rate_status_id_seq OWNER TO class4_user;

--
-- Name: import_rate_status_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.import_rate_status_id_seq OWNED BY public.import_rate_status.id;


--
-- Name: import_target_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.import_target_log (
    id integer NOT NULL,
    status integer,
    client_id integer,
    create_time timestamp without time zone,
    file_name character varying(256),
    file_path character varying(256),
    error_message character varying(256)
);


ALTER TABLE public.import_target_log OWNER TO class4_user;

--
-- Name: import_target_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.import_target_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.import_target_log_id_seq OWNER TO class4_user;

--
-- Name: import_target_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.import_target_log_id_seq OWNED BY public.import_target_log.id;


--
-- Name: ingress_did_repository; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.ingress_did_repository (
    number character varying(255) NOT NULL,
    ingress_id integer,
    egress_id integer,
    created_time timestamp with time zone,
    updated_time timestamp with time zone,
    state character varying(200),
    country character varying(200),
    city character varying(200),
    rate_center character varying(200),
    status smallint,
    type smallint,
    lata character varying(100)
);


ALTER TABLE public.ingress_did_repository OWNER TO class4_user;

--
-- Name: invoice; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.invoice (
    invoice_id integer NOT NULL,
    invoice_number character varying(20) NOT NULL,
    state integer DEFAULT 0 NOT NULL,
    type integer,
    client_id integer,
    invoice_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL,
    invoice_start timestamp with time zone NOT NULL,
    invoice_end timestamp with time zone NOT NULL,
    total_amount numeric(30,5) DEFAULT 0 NOT NULL,
    paid boolean DEFAULT false NOT NULL,
    due_date date,
    pay_amount numeric(30,5) DEFAULT 0 NOT NULL,
    current_balance numeric(30,10) NOT NULL,
    total_minutes real,
    disputed integer DEFAULT 0,
    send_time timestamp with time zone,
    create_type integer DEFAULT 0,
    buy_total numeric(30,10),
    sell_total numeric(30,10),
    buy_minutes real,
    sell_minutes real,
    buy_service_charge numeric(30,10),
    sell_service_charge numeric(30,10),
    link_cdr character varying(50),
    credit_amount numeric(30,5) DEFAULT 0,
    pdf_path character varying(300),
    cdr_path character varying(300),
    lrn_numbers integer,
    lrn_rate numeric(30,10),
    lrn_cost numeric(30,10),
    disputed_amount numeric(30,10),
    credit_note numeric(30,10),
    invoice_zone character varying(10),
    reconcile_file_path character varying,
    reconcile_state integer DEFAULT 0,
    output_type integer DEFAULT 0,
    status integer,
    include_detail boolean DEFAULT true,
    generate_start_time timestamp with time zone,
    generate_copy_time timestamp with time zone,
    generate_stats_time timestamp with time zone,
    generate_end_time timestamp with time zone,
    invoice_jurisdictional_detail boolean DEFAULT true,
    previous_balance numeric(30,10),
    payment_credit numeric(30,10),
    finance_charge numeric(30,10),
    decurring_charge numeric(30,10),
    non_recurring_charge numeric(30,10),
    tax numeric(30,10),
    decimal_place integer DEFAULT 5,
    rate_value integer DEFAULT 0,
    scc_cost numeric(30,5),
    is_invoice_account_summary boolean DEFAULT false,
    new_balance numeric(30,10),
    is_show_daily_usage boolean DEFAULT false,
    scc_calls integer,
    scc_per real,
    invoice_include_payment boolean,
    scc_sec integer,
    is_short_duration_call_surcharge_detail boolean DEFAULT false,
    usage_detail_fields text,
    ingress_cdr_file character varying(255),
    egress_cdr_file character varying(255),
    current_charge numeric(30,10),
    invoice_log_id integer,
    invoice_use_balance_type integer DEFAULT 0,
    invoice_balance_time timestamp with time zone,
    total_calls integer DEFAULT 0,
    decimals_num integer,
    please_pay numeric(20,5),
    credit_remaining numeric(20,5),
    unlimited_credit_unlimited boolean DEFAULT false,
    payment_term character varying,
    is_show_total_trunk boolean DEFAULT false,
    is_show_detail_trunk boolean DEFAULT false,
    is_show_code_100 boolean DEFAULT false,
    is_show_code_name boolean DEFAULT false,
    is_show_country boolean DEFAULT false,
    is_show_by_date boolean DEFAULT false,
    is_send_as_link boolean DEFAULT false,
    company_type smallint DEFAULT '1'::smallint
);


ALTER TABLE public.invoice OWNER TO class4_user;

--
-- Name: TABLE invoice; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.invoice IS '发票';


--
-- Name: COLUMN invoice.invoice_number; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.invoice_number IS '发票号码';


--
-- Name: COLUMN invoice.state; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.state IS '-1:void;0:normal;1:verify;9:send';


--
-- Name: COLUMN invoice.type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.type IS '0:sent(out--buy);1:received(in--sell);2:sent(all);3:incoming ';


--
-- Name: COLUMN invoice.client_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.client_id IS '批发';


--
-- Name: COLUMN invoice.invoice_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.invoice_time IS '生成时间';


--
-- Name: COLUMN invoice.invoice_start; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.invoice_start IS '开始日期';


--
-- Name: COLUMN invoice.invoice_end; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.invoice_end IS '截止日期';


--
-- Name: COLUMN invoice.total_amount; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.total_amount IS '发票金额';


--
-- Name: COLUMN invoice.paid; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.paid IS '是否付清';


--
-- Name: COLUMN invoice.due_date; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.due_date IS '付款日期 ---过期时间';


--
-- Name: COLUMN invoice.pay_amount; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.pay_amount IS '路由伙伴的付款金额';


--
-- Name: COLUMN invoice.current_balance; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.current_balance IS '当前余额';


--
-- Name: COLUMN invoice.disputed; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.disputed IS '0-Non-Disputed;1-Disputed;2-Dispute Resolved';


--
-- Name: COLUMN invoice.send_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.send_time IS '发送invoice时间';


--
-- Name: COLUMN invoice.create_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.create_type IS '0-Auto-generated Invoice;1-Manual Invoice';


--
-- Name: COLUMN invoice.pdf_path; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.pdf_path IS 'pdf存储路径';


--
-- Name: COLUMN invoice.cdr_path; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.cdr_path IS 'cdr存储路径';


--
-- Name: COLUMN invoice.reconcile_state; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.reconcile_state IS '0: 有可比较的文件;1: 进行中;2: 已经完成';


--
-- Name: COLUMN invoice.output_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.output_type IS '0-pdf;1-excel;2-html';


--
-- Name: COLUMN invoice.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice.status IS '0-creating;1-zero cdr;2-done;-1-only support buy/sell';


--
-- Name: invoice_cdr_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.invoice_cdr_log (
    id integer NOT NULL,
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    type integer,
    invoice_number character varying(255),
    carrier_name character varying(255)
);


ALTER TABLE public.invoice_cdr_log OWNER TO class4_user;

--
-- Name: invoice_cdr_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.invoice_cdr_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.invoice_cdr_log_id_seq OWNER TO class4_user;

--
-- Name: invoice_cdr_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.invoice_cdr_log_id_seq OWNED BY public.invoice_cdr_log.id;


--
-- Name: invoice_daily_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.invoice_daily_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.invoice_daily_detail_id_seq OWNER TO class4_user;

--
-- Name: invoice_debug; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.invoice_debug (
    id integer NOT NULL,
    "time" timestamp with time zone DEFAULT now() NOT NULL,
    client_id integer,
    text text
);


ALTER TABLE public.invoice_debug OWNER TO class4_user;

--
-- Name: invoice_debug_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.invoice_debug_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.invoice_debug_id_seq OWNER TO class4_user;

--
-- Name: invoice_debug_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.invoice_debug_id_seq OWNED BY public.invoice_debug.id;


--
-- Name: invoice_email; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.invoice_email (
    id integer NOT NULL,
    invoice_no character varying(20),
    mail_content character varying(1000),
    send_time timestamp with time zone,
    pdf_file character varying(100),
    send_address character varying(100),
    mail_sub character varying(100)
);


ALTER TABLE public.invoice_email OWNER TO class4_user;

--
-- Name: invoice_email_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.invoice_email_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.invoice_email_id_seq OWNER TO class4_user;

--
-- Name: invoice_email_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.invoice_email_id_seq OWNED BY public.invoice_email.id;


--
-- Name: invoice_history; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.invoice_history (
    id integer NOT NULL,
    client_id integer NOT NULL,
    last_invoice_for date DEFAULT ('now'::text)::date,
    last_invoice_amount numeric,
    last_invoice_period character varying(32),
    next_invoice_date date
);


ALTER TABLE public.invoice_history OWNER TO class4_user;

--
-- Name: invoice_history_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.invoice_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.invoice_history_id_seq OWNER TO class4_user;

--
-- Name: invoice_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.invoice_history_id_seq OWNED BY public.invoice_history.id;


--
-- Name: invoice_invoice_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.invoice_invoice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.invoice_invoice_id_seq OWNER TO class4_user;

--
-- Name: invoice_invoice_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.invoice_invoice_id_seq OWNED BY public.invoice.invoice_id;


--
-- Name: invoice_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.invoice_log (
    id integer NOT NULL,
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    status integer DEFAULT 0,
    cnt integer DEFAULT 1
);


ALTER TABLE public.invoice_log OWNER TO class4_user;

--
-- Name: COLUMN invoice_log.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice_log.status IS '0 begin
1 progress
2 done
3 error';


--
-- Name: COLUMN invoice_log.cnt; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.invoice_log.cnt IS 'invoice 总数
';


--
-- Name: invoice_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.invoice_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.invoice_log_id_seq OWNER TO class4_user;

--
-- Name: invoice_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.invoice_log_id_seq OWNED BY public.invoice_log.id;


--
-- Name: invoice_payment; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.invoice_payment (
    id integer NOT NULL,
    invoice_no character varying(50),
    payment_time timestamp with time zone,
    payment_amount numeric
);


ALTER TABLE public.invoice_payment OWNER TO class4_user;

--
-- Name: invoice_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.invoice_payment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.invoice_payment_id_seq OWNER TO class4_user;

--
-- Name: invoice_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.invoice_payment_id_seq OWNED BY public.invoice_payment.id;


--
-- Name: invoice_settings; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.invoice_settings (
    id bigint NOT NULL,
    invoice_setting_name character varying(200),
    invoice_name character varying(200),
    tpl_number integer,
    company_info_location smallint,
    pdf_tpl text,
    company_info character varying(500),
    overlap_invoice_protection boolean,
    send_cdr_fields text,
    invoice_send_mode smallint,
    invoice_decimal_digits integer,
    created_at timestamp with time zone DEFAULT now(),
    updated_at timestamp with time zone,
    updated_by character varying(255),
    logo_path character varying(256),
    mail_sender_id integer,
    invoices_logo_id integer,
    invoice_send_mode_cdr smallint
);


ALTER TABLE public.invoice_settings OWNER TO class4_user;

--
-- Name: invoice_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.invoice_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.invoice_settings_id_seq OWNER TO class4_user;

--
-- Name: invoice_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.invoice_settings_id_seq OWNED BY public.invoice_settings.id;


--
-- Name: invoice_summary; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.invoice_summary (
    invoice_number integer NOT NULL,
    client_id integer NOT NULL,
    invoice_generation_time timestamp without time zone,
    invoice_start_time timestamp without time zone,
    invoice_end_time timestamp without time zone,
    payment_id integer,
    current_balance numeric DEFAULT 0.00 NOT NULL,
    previous_balance numeric DEFAULT 0.00 NOT NULL,
    payments_and_credits numeric DEFAULT 0.00 NOT NULL,
    balance_forward numeric DEFAULT 0.00 NOT NULL,
    long_distance_charges numeric DEFAULT 0.00 NOT NULL,
    taxes numeric DEFAULT 0.00 NOT NULL,
    scc_amount numeric DEFAULT 0.00 NOT NULL,
    current_charges numeric DEFAULT 0.00 NOT NULL,
    total_calls integer DEFAULT 0 NOT NULL,
    total_minutes numeric DEFAULT 0.00 NOT NULL,
    total_amount numeric DEFAULT 0.00 NOT NULL,
    unlimited_credit boolean DEFAULT false NOT NULL,
    invoice_type smallint DEFAULT 0 NOT NULL,
    did_mrc numeric DEFAULT 0.00 NOT NULL,
    did_nrc numeric DEFAULT 0.00 NOT NULL,
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    invoice_num character varying(256),
    json_content json,
    port_charges numeric DEFAULT 0.00 NOT NULL,
    scc_calls numeric DEFAULT 0.00 NOT NULL,
    task_id integer,
    invoice_zone character varying(20),
    payment_dur_date date
);


ALTER TABLE public.invoice_summary OWNER TO class4_user;

--
-- Name: invoice_summary_invoice_number_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.invoice_summary_invoice_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.invoice_summary_invoice_number_seq OWNER TO class4_user;

--
-- Name: invoice_summary_invoice_number_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.invoice_summary_invoice_number_seq OWNED BY public.invoice_summary.invoice_number;


--
-- Name: invoice_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.invoice_task (
    id integer NOT NULL,
    client_id integer,
    is_auto boolean DEFAULT false NOT NULL,
    created_by_user_id integer,
    created_on timestamp with time zone DEFAULT now(),
    bill_period_start date,
    bill_period_end date,
    show_acc_summary boolean DEFAULT true NOT NULL,
    show_payment_applied boolean DEFAULT false NOT NULL,
    show_rec_charge boolean DEFAULT false NOT NULL,
    show_non_rec_charge boolean DEFAULT false NOT NULL,
    show_usage_charge boolean DEFAULT false NOT NULL,
    show_trunk_detail boolean DEFAULT false NOT NULL,
    show_daily_summary boolean DEFAULT false NOT NULL,
    show_jd_trunk_detail boolean DEFAULT false NOT NULL,
    show_prefix_summary boolean DEFAULT false NOT NULL,
    show_code_name_summary boolean DEFAULT false NOT NULL,
    show_country_summary boolean DEFAULT false NOT NULL,
    show_inbound_summary boolean DEFAULT false NOT NULL,
    show_top_100tn_summary boolean DEFAULT false NOT NULL,
    enable_email boolean DEFAULT false NOT NULL,
    enable_email_with_cdr boolean DEFAULT false NOT NULL,
    include_tax boolean DEFAULT false NOT NULL,
    include_scc_charges boolean DEFAULT false NOT NULL,
    payment_dur_date date,
    invoice_zone character varying(20),
    status smallint DEFAULT 0 NOT NULL,
    progress character varying(1024),
    proc_start_time timestamp with time zone,
    proc_end_time timestamp with time zone,
    show_jd_daily_summary boolean DEFAULT false NOT NULL,
    show_did_charge_breakdown boolean DEFAULT false NOT NULL,
    show_did_charge_summary boolean DEFAULT false NOT NULL,
    show_summary_of_charges boolean
);


ALTER TABLE public.invoice_task OWNER TO class4_user;

--
-- Name: invoice_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.invoice_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.invoice_task_id_seq OWNER TO class4_user;

--
-- Name: invoice_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.invoice_task_id_seq OWNED BY public.invoice_task.id;


--
-- Name: invoice_trunk_prefix_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.invoice_trunk_prefix_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.invoice_trunk_prefix_detail_id_seq OWNER TO class4_user;

--
-- Name: ip_modif_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.ip_modif_log (
    modify integer,
    detail character(100),
    update_at timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    update_by character varying,
    trunk_id integer,
    id integer NOT NULL,
    email character varying(100),
    old character varying(100),
    new character varying(100)
);


ALTER TABLE public.ip_modif_log OWNER TO class4_user;

--
-- Name: TABLE ip_modif_log; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.ip_modif_log IS 'ip的增删改的 记录';


--
-- Name: COLUMN ip_modif_log.modify; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.ip_modif_log.modify IS '0-- 修改
1-- add
2-- delete';


--
-- Name: COLUMN ip_modif_log.detail; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.ip_modif_log.detail IS 'add、delete为所改ip
modify 为 oldip=》newip
';


--
-- Name: COLUMN ip_modif_log.update_at; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.ip_modif_log.update_at IS '修改时间';


--
-- Name: COLUMN ip_modif_log.update_by; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.ip_modif_log.update_by IS '操作人';


--
-- Name: COLUMN ip_modif_log.old; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.ip_modif_log.old IS 'old values';


--
-- Name: COLUMN ip_modif_log.new; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.ip_modif_log.new IS 'new values';


--
-- Name: ip_modif_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.ip_modif_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ip_modif_log_id_seq OWNER TO class4_user;

--
-- Name: ip_modif_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.ip_modif_log_id_seq OWNED BY public.ip_modif_log.id;


--
-- Name: jur_type_name; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.jur_type_name (
    id integer NOT NULL,
    name character varying(100) NOT NULL
);


ALTER TABLE public.jur_type_name OWNER TO class4_user;

--
-- Name: jur_type_name_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.jur_type_name_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.jur_type_name_id_seq OWNER TO class4_user;

--
-- Name: jur_type_name_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.jur_type_name_id_seq OWNED BY public.jur_type_name.id;


--
-- Name: jurisdiction_prefix; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.jurisdiction_prefix (
    id integer NOT NULL,
    alias character varying(40),
    prefix public.prefix_range NOT NULL,
    jurisdiction_id integer DEFAULT 1,
    jurisdiction_country_id integer DEFAULT 1,
    jurisdiction_name character varying(100),
    jurisdiction_country_name character varying(100),
    ocn character varying(10),
    lata character varying(10),
    block_id character(1),
    effective_date timestamp with time zone
);


ALTER TABLE public.jurisdiction_prefix OWNER TO class4_user;

--
-- Name: TABLE jurisdiction_prefix; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.jurisdiction_prefix IS '计费区域前缀';


--
-- Name: COLUMN jurisdiction_prefix.alias; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.jurisdiction_prefix.alias IS '别名';


--
-- Name: COLUMN jurisdiction_prefix.prefix; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.jurisdiction_prefix.prefix IS '前缀';


--
-- Name: COLUMN jurisdiction_prefix.jurisdiction_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.jurisdiction_prefix.jurisdiction_id IS '所属计费区域';


--
-- Name: COLUMN jurisdiction_prefix.jurisdiction_name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.jurisdiction_prefix.jurisdiction_name IS '区域';


--
-- Name: COLUMN jurisdiction_prefix.jurisdiction_country_name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.jurisdiction_prefix.jurisdiction_country_name IS 'guojia ';


--
-- Name: jurisdiction_prefix_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.jurisdiction_prefix_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.jurisdiction_prefix_id_seq OWNER TO class4_user;

--
-- Name: jurisdiction_prefix_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.jurisdiction_prefix_id_seq OWNED BY public.jurisdiction_prefix.id;


--
-- Name: jurisdiction_prefix_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.jurisdiction_prefix_record (
    id integer NOT NULL,
    alias character varying(40),
    prefix public.prefix_range NOT NULL,
    jurisdiction_id integer,
    jurisdiction_country_id integer,
    jurisdiction_name character varying(100),
    jurisdiction_country_name character varying(100),
    ocn character varying(10),
    lata character varying(10),
    block_id character(1),
    effective_date timestamp with time zone,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.jurisdiction_prefix_record OWNER TO class4_user;

--
-- Name: jurisdiction_prefix_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.jurisdiction_prefix_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.jurisdiction_prefix_record_record_id_seq OWNER TO class4_user;

--
-- Name: jurisdiction_prefix_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.jurisdiction_prefix_record_record_id_seq OWNED BY public.jurisdiction_prefix_record.record_id;


--
-- Name: jurisdiction_update_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.jurisdiction_update_log (
    id integer NOT NULL,
    tigger_time timestamp with time zone,
    is_new_file boolean,
    import_log_id integer,
    file_update_time_flg character varying(10),
    status integer
);


ALTER TABLE public.jurisdiction_update_log OWNER TO class4_user;

--
-- Name: jurisdiction_update_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.jurisdiction_update_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.jurisdiction_update_log_id_seq OWNER TO class4_user;

--
-- Name: jurisdiction_update_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.jurisdiction_update_log_id_seq OWNED BY public.jurisdiction_update_log.id;


--
-- Name: kill_pg_sql_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.kill_pg_sql_log (
    id integer NOT NULL,
    query text,
    start_time timestamp with time zone,
    kill_time timestamp with time zone
);


ALTER TABLE public.kill_pg_sql_log OWNER TO class4_user;

--
-- Name: kill_pg_sql_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.kill_pg_sql_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.kill_pg_sql_log_id_seq OWNER TO class4_user;

--
-- Name: kill_pg_sql_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.kill_pg_sql_log_id_seq OWNED BY public.kill_pg_sql_log.id;


--
-- Name: lcr_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.lcr_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.lcr_task_id_seq OWNER TO class4_user;

--
-- Name: lcr_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.lcr_task (
    task_id integer DEFAULT nextval('public.lcr_task_id_seq'::regclass) NOT NULL,
    target_rate_table_id integer NOT NULL,
    egress_id integer[],
    lcr_rate_table_id integer[] NOT NULL,
    created_on timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    started_on timestamp with time zone,
    finished_on timestamp with time zone,
    result_path character varying(256),
    effective_date character varying(40) DEFAULT ('now'::text)::timestamp(0) with time zone
);


ALTER TABLE public.lcr_task OWNER TO class4_user;

--
-- Name: lcr_test; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.lcr_test (
    id integer NOT NULL,
    name character varying(100),
    type integer,
    client_id integer,
    trunk_id integer,
    ip_id integer,
    prefix_id integer,
    rate_table_id integer,
    switch_id integer,
    routing_plan_id integer,
    static_route_id integer,
    egress_id integer,
    product_item_id integer,
    product_item_resource_id integer,
    route_id integer
);


ALTER TABLE public.lcr_test OWNER TO class4_user;

--
-- Name: lcr_test_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.lcr_test_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.lcr_test_id_seq OWNER TO class4_user;

--
-- Name: lcr_test_id_seq1; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.lcr_test_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.lcr_test_id_seq1 OWNER TO class4_user;

--
-- Name: lcr_test_id_seq1; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.lcr_test_id_seq1 OWNED BY public.lcr_test.id;


--
-- Name: lcr_test_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.lcr_test_log (
    id integer NOT NULL,
    test_time timestamp with time zone,
    ani character varying(64),
    dnis character varying(64),
    test_result text
);


ALTER TABLE public.lcr_test_log OWNER TO class4_user;

--
-- Name: lcr_test_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.lcr_test_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.lcr_test_log_id_seq OWNER TO class4_user;

--
-- Name: lcr_test_log_id_seq1; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.lcr_test_log_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.lcr_test_log_id_seq1 OWNER TO class4_user;

--
-- Name: lcr_test_log_id_seq1; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.lcr_test_log_id_seq1 OWNED BY public.lcr_test_log.id;


--
-- Name: lerg; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.lerg (
    uuid character varying(36) DEFAULT public.uuid_generate_v4() NOT NULL,
    npa character varying(3),
    nxx character varying(3),
    thousands character varying(2),
    state character varying(2),
    company character varying(128),
    ocn character varying(6),
    ratecenter character varying(16),
    clli character varying(16),
    assign_date character varying(10),
    prefix_type character varying(18),
    switch_name character varying(48),
    switch_type character varying(64),
    lata character varying(3),
    country character varying(2)
);


ALTER TABLE public.lerg OWNER TO class4_user;

--
-- Name: lerg_download_schedule; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.lerg_download_schedule (
    id integer NOT NULL,
    url character varying(100),
    schedule_hour integer,
    created_on timestamp with time zone DEFAULT now(),
    created_by character varying(255),
    last_downloaded_count integer,
    last_downloaded_on timestamp with time zone
);


ALTER TABLE public.lerg_download_schedule OWNER TO class4_user;

--
-- Name: lerg_download_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.lerg_download_schedule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.lerg_download_schedule_id_seq OWNER TO class4_user;

--
-- Name: lerg_download_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.lerg_download_schedule_id_seq OWNED BY public.lerg_download_schedule.id;


--
-- Name: lerg_download_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.lerg_download_task (
    uuid character varying(36) DEFAULT public.uuid_generate_v4() NOT NULL,
    status smallint DEFAULT '0'::smallint NOT NULL,
    result text,
    created_on timestamp with time zone DEFAULT now(),
    finished_on timestamp with time zone,
    lerg_import_task_uuid character varying(36),
    schedule_id integer NOT NULL,
    url character varying(100)
);


ALTER TABLE public.lerg_download_task OWNER TO class4_user;

--
-- Name: lerg_import_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.lerg_import_task (
    uuid character varying(36) DEFAULT public.uuid_generate_v4() NOT NULL,
    status smallint DEFAULT '0'::smallint NOT NULL,
    result text,
    file character varying(512),
    created_on timestamp with time zone DEFAULT now(),
    created_by character varying(255),
    finished_on timestamp with time zone
);


ALTER TABLE public.lerg_import_task OWNER TO class4_user;

--
-- Name: loop_detection; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.loop_detection (
    id integer NOT NULL,
    rule_name character varying,
    number integer,
    counter_time integer,
    block_time integer
);


ALTER TABLE public.loop_detection OWNER TO class4_user;

--
-- Name: loop_detection_detail; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.loop_detection_detail (
    id integer NOT NULL,
    loop_detection_id integer NOT NULL,
    resource_id integer
);


ALTER TABLE public.loop_detection_detail OWNER TO class4_user;

--
-- Name: loop_detection_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.loop_detection_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loop_detection_detail_id_seq OWNER TO class4_user;

--
-- Name: loop_detection_detail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.loop_detection_detail_id_seq OWNED BY public.loop_detection_detail.id;


--
-- Name: loop_detection_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.loop_detection_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loop_detection_id_seq OWNER TO class4_user;

--
-- Name: loop_detection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.loop_detection_id_seq OWNED BY public.loop_detection.id;


--
-- Name: mail_cdr_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.mail_cdr_log (
    id integer NOT NULL,
    start_time timestamp with time zone,
    cdr_counts integer,
    user_id integer,
    finish_time timestamp with time zone,
    cdr_start_time timestamp with time zone,
    cdr_end_time timestamp with time zone,
    file_counts integer,
    mail_content text,
    mail_subject character varying(500),
    status integer
);


ALTER TABLE public.mail_cdr_log OWNER TO class4_user;

--
-- Name: mail_cdr_log_detail; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.mail_cdr_log_detail (
    id integer NOT NULL,
    mail_cdr_log_id integer,
    "order" integer,
    cdr_start_time timestamp with time zone,
    cdr_end_time timestamp with time zone,
    file_size integer,
    filename character varying(255)
);


ALTER TABLE public.mail_cdr_log_detail OWNER TO class4_user;

--
-- Name: mail_cdr_log_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.mail_cdr_log_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mail_cdr_log_detail_id_seq OWNER TO class4_user;

--
-- Name: mail_cdr_log_detail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.mail_cdr_log_detail_id_seq OWNED BY public.mail_cdr_log_detail.id;


--
-- Name: mail_cdr_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.mail_cdr_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mail_cdr_log_id_seq OWNER TO class4_user;

--
-- Name: mail_cdr_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.mail_cdr_log_id_seq OWNED BY public.mail_cdr_log.id;


--
-- Name: mail_sender; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.mail_sender (
    id integer NOT NULL,
    smtp_host character varying(255),
    smtp_port character varying(255),
    username character varying(255),
    password character varying(255),
    email character varying(255),
    name character varying(255),
    secure integer DEFAULT 0 NOT NULL,
    loginemail character varying(12),
    last_modified_on timestamp with time zone,
    modified_by character varying(40),
    enable_auth boolean
);


ALTER TABLE public.mail_sender OWNER TO class4_user;

--
-- Name: mail_sender_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.mail_sender_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mail_sender_id_seq OWNER TO class4_user;

--
-- Name: mail_sender_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.mail_sender_id_seq OWNED BY public.mail_sender.id;


--
-- Name: mail_template; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.mail_template (
    title character varying(200) NOT NULL,
    subject character varying(200),
    from_mail_id integer,
    cc_mail character varying(200),
    html_content text,
    to_mail character varying(200)
);


ALTER TABLE public.mail_template OWNER TO class4_user;

--
-- Name: media_asr_filter; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.media_asr_filter (
    id integer NOT NULL,
    ip_address character varying(32),
    number character varying(32),
    enabled boolean DEFAULT true NOT NULL,
    comment character varying(128),
    add_dt timestamp with time zone DEFAULT now(),
    num_filter_type integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.media_asr_filter OWNER TO class4_user;

--
-- Name: media_asr_filter_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.media_asr_filter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.media_asr_filter_id_seq OWNER TO class4_user;

--
-- Name: media_asr_filter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.media_asr_filter_id_seq OWNED BY public.media_asr_filter.id;


--
-- Name: media_capture_filter; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.media_capture_filter (
    id integer NOT NULL,
    ip_address character varying(32),
    number character varying(32),
    enabled boolean DEFAULT true NOT NULL,
    comment character varying(128),
    add_dt timestamp with time zone DEFAULT now(),
    num_filter_type integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.media_capture_filter OWNER TO class4_user;

--
-- Name: media_capture_filter_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.media_capture_filter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.media_capture_filter_id_seq OWNER TO class4_user;

--
-- Name: media_capture_filter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.media_capture_filter_id_seq OWNED BY public.media_capture_filter.id;


--
-- Name: modif_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.modif_log (
    id integer NOT NULL,
    "time" timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    module character varying(100),
    type smallint,
    name character varying(100),
    detail character varying(200),
    rollback text,
    rollback_msg character varying(500),
    rollback_flg smallint,
    rollback_extra_info text
);


ALTER TABLE public.modif_log OWNER TO class4_user;

--
-- Name: COLUMN modif_log.type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.modif_log.type IS '0 -- creation
1-- deletion
2 -- modification';


--
-- Name: COLUMN modif_log.rollback; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.modif_log.rollback IS '记录回滚的sql';


--
-- Name: COLUMN modif_log.rollback_msg; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.modif_log.rollback_msg IS '记录回滚的提示信息';


--
-- Name: COLUMN modif_log.rollback_flg; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.modif_log.rollback_flg IS '0：还没有回滚
1：成功回滚
2：回滚失败';


--
-- Name: COLUMN modif_log.rollback_extra_info; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.modif_log.rollback_extra_info IS '储存json格式
记录rollback_type:
1：直接运行rollback_sql
2：Digit Mapping的删除回滚
3：Static Route的删除回滚';


--
-- Name: modif_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.modif_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.modif_log_id_seq OWNER TO class4_user;

--
-- Name: modif_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.modif_log_id_seq OWNED BY public.modif_log.id;


--
-- Name: monitored_rule; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.monitored_rule (
    id integer NOT NULL,
    rule_name character varying(100),
    is_active boolean DEFAULT true NOT NULL,
    is_ingress_trunk boolean DEFAULT true,
    is_all_trunk boolean DEFAULT false NOT NULL,
    trunk_id_list character varying(200),
    include_codes character varying(500),
    exclude_codes character varying(500),
    monitored_type integer DEFAULT 0,
    acd_action smallint,
    acd_value integer,
    asr_action smallint,
    asr_value numeric,
    sdp_action smallint,
    sdp_value numeric,
    sdp_duation integer,
    pdd_action smallint,
    pdd_value integer,
    profit_action smallint,
    profit_value numeric,
    revenue_action smallint,
    revenue_value numeric,
    min_call_attempt integer,
    exe_schedule_type smallint,
    specific_minutes integer,
    daily_run_time time without time zone,
    weekly_run_time time without time zone,
    run_day_of_week smallint,
    sample_size integer DEFAULT 5 NOT NULL,
    is_block boolean DEFAULT false,
    is_auto_unblock boolean DEFAULT false,
    unblock_after_min integer,
    last_run_time timestamp with time zone,
    next_run_time timestamp with time zone,
    send_email_type integer DEFAULT 3,
    email_from integer,
    email_ticket_subject character varying(200),
    email_ticket_content text,
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    updated_at timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    updated_by character varying(200),
    action_type smallint
);


ALTER TABLE public.monitored_rule OWNER TO class4_user;

--
-- Name: monitored_rule_history; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.monitored_rule_history (
    id integer NOT NULL,
    monitored_rule_id integer,
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    is_ingress_trunk boolean,
    trunk_id integer,
    dnis character varying(64),
    ani character varying(64),
    code_name character varying(100),
    country character varying(100),
    code character varying(64),
    total_call integer,
    not_zero_call integer,
    sdp_call integer,
    call_duration integer,
    pdd integer,
    ingress_cost numeric,
    egress_cost numeric,
    block_id_list text,
    unblock_time timestamp with time zone,
    unblock_exe_time timestamp with time zone,
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    api_email_result character varying(1024),
    api_email_send_time timestamp with time zone
);


ALTER TABLE public.monitored_rule_history OWNER TO class4_user;

--
-- Name: monitored_rule_history_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.monitored_rule_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.monitored_rule_history_id_seq OWNER TO class4_user;

--
-- Name: monitored_rule_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.monitored_rule_history_id_seq OWNED BY public.monitored_rule_history.id;


--
-- Name: monitored_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.monitored_rule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.monitored_rule_id_seq OWNER TO class4_user;

--
-- Name: monitored_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.monitored_rule_id_seq OWNED BY public.monitored_rule.id;


--
-- Name: object_revision; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.object_revision (
    id bigint NOT NULL,
    user_id integer NOT NULL,
    entity_name character varying(64) NOT NULL,
    entity_pk character varying(64) NOT NULL,
    action character varying(16) NOT NULL,
    revision_number integer NOT NULL,
    revision_time timestamp with time zone NOT NULL,
    restored_from_revision_id bigint,
    module character varying(64),
    object_name character varying(256)
);


ALTER TABLE public.object_revision OWNER TO class4_user;

--
-- Name: object_revision_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.object_revision_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.object_revision_id_seq OWNER TO class4_user;

--
-- Name: object_revision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.object_revision_id_seq OWNED BY public.object_revision.id;


--
-- Name: object_revision_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.object_revision_record (
    id bigint NOT NULL,
    object_revision_id bigint NOT NULL,
    field_name character varying(64) NOT NULL,
    old_value text,
    new_value text
);


ALTER TABLE public.object_revision_record OWNER TO class4_user;

--
-- Name: object_revision_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.object_revision_record_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.object_revision_record_id_seq OWNER TO class4_user;

--
-- Name: object_revision_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.object_revision_record_id_seq OWNED BY public.object_revision_record.id;


--
-- Name: ocn_blocklist; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.ocn_blocklist (
    id bigint NOT NULL,
    res_id integer,
    ocn character varying(100) NOT NULL,
    created_at timestamp with time zone,
    created_by character varying(100)
);


ALTER TABLE public.ocn_blocklist OWNER TO class4_user;

--
-- Name: ocn_blocklist_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.ocn_blocklist_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ocn_blocklist_id_seq OWNER TO class4_user;

--
-- Name: ocn_blocklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.ocn_blocklist_id_seq OWNED BY public.ocn_blocklist.id;


--
-- Name: ocn_blocklist_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.ocn_blocklist_record (
    id bigint NOT NULL,
    res_id integer,
    ocn character varying(100) NOT NULL,
    created_at timestamp with time zone,
    created_by character varying(100),
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.ocn_blocklist_record OWNER TO class4_user;

--
-- Name: ocn_blocklist_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.ocn_blocklist_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ocn_blocklist_record_record_id_seq OWNER TO class4_user;

--
-- Name: ocn_blocklist_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.ocn_blocklist_record_record_id_seq OWNED BY public.ocn_blocklist_record.record_id;


--
-- Name: orig_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.orig_log (
    log_id integer NOT NULL,
    update_on timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    update_by character varying(100),
    module character varying(100),
    type smallint,
    detail character varying(500)
);


ALTER TABLE public.orig_log OWNER TO class4_user;

--
-- Name: COLUMN orig_log.type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.orig_log.type IS '0 -- creation
1-- deletion
2 -- modification';


--
-- Name: orig_log_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.orig_log_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.orig_log_log_id_seq OWNER TO class4_user;

--
-- Name: orig_log_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.orig_log_log_id_seq OWNED BY public.orig_log.log_id;


--
-- Name: origination_global_failover; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.origination_global_failover (
    id integer NOT NULL,
    failover_strategy integer,
    from_sip_code integer,
    to_sip_code integer,
    to_sip_string character varying(100)
);


ALTER TABLE public.origination_global_failover OWNER TO class4_user;

--
-- Name: TABLE origination_global_failover; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.origination_global_failover IS '主叫方跳转策略

baohq20140422';


--
-- Name: COLUMN origination_global_failover.failover_strategy; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.origination_global_failover.failover_strategy IS '跳转策略类型

baohq20140422';


--
-- Name: COLUMN origination_global_failover.from_sip_code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.origination_global_failover.from_sip_code IS '从被叫收到的sip码

baohq20140422';


--
-- Name: COLUMN origination_global_failover.to_sip_code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.origination_global_failover.to_sip_code IS '返回给主叫的sip码

baohq20140422';


--
-- Name: COLUMN origination_global_failover.to_sip_string; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.origination_global_failover.to_sip_string IS '返回给主叫的sip描述字符串

baohq20140422';


--
-- Name: origination_global_failover_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.origination_global_failover_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.origination_global_failover_id_seq OWNER TO class4_user;

--
-- Name: origination_global_failover_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.origination_global_failover_id_seq OWNED BY public.origination_global_failover.id;


--
-- Name: origination_global_failover_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.origination_global_failover_record (
    id integer NOT NULL,
    failover_strategy integer,
    from_sip_code integer,
    to_sip_code integer,
    to_sip_string character varying(100),
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.origination_global_failover_record OWNER TO class4_user;

--
-- Name: origination_global_failover_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.origination_global_failover_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.origination_global_failover_record_record_id_seq OWNER TO class4_user;

--
-- Name: origination_global_failover_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.origination_global_failover_record_record_id_seq OWNED BY public.origination_global_failover_record.record_id;


--
-- Name: partition_gateway_ref; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.partition_gateway_ref (
    id integer NOT NULL,
    partition_id integer,
    gateway_ip integer,
    gateway_port integer
);


ALTER TABLE public.partition_gateway_ref OWNER TO class4_user;

--
-- Name: TABLE partition_gateway_ref; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.partition_gateway_ref IS 'partition和switch_profile表的映射关系';


--
-- Name: COLUMN partition_gateway_ref.gateway_ip; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.partition_gateway_ref.gateway_ip IS '跟switch_profile表sip_ip对应';


--
-- Name: COLUMN partition_gateway_ref.gateway_port; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.partition_gateway_ref.gateway_port IS '跟switch_profile表sip_port对应';


--
-- Name: partition_gateway_ref_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.partition_gateway_ref_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.partition_gateway_ref_id_seq OWNER TO class4_user;

--
-- Name: partition_gateway_ref_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.partition_gateway_ref_id_seq OWNED BY public.partition_gateway_ref.id;


--
-- Name: partition_gateway_ref_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.partition_gateway_ref_record (
    id integer NOT NULL,
    partition_id integer,
    gateway_ip integer,
    gateway_port integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.partition_gateway_ref_record OWNER TO class4_user;

--
-- Name: partition_gateway_ref_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.partition_gateway_ref_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.partition_gateway_ref_record_record_id_seq OWNER TO class4_user;

--
-- Name: partition_gateway_ref_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.partition_gateway_ref_record_record_id_seq OWNED BY public.partition_gateway_ref_record.record_id;


--
-- Name: payment_gateway_history; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.payment_gateway_history (
    chargetotal numeric,
    method smallint,
    cardnumber character varying,
    cardexpmonth character varying,
    cardexpyear character varying,
    created_time timestamp without time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    modified_time timestamp without time zone,
    error character varying,
    confirmed boolean DEFAULT false,
    client_id integer,
    fee numeric,
    status smallint DEFAULT 0,
    id integer NOT NULL,
    invoice_id character varying(255),
    par_id integer,
    address1 character varying(255),
    address2 character varying(255),
    city character varying(255),
    state_province character varying(255),
    zip_code character varying(255),
    country character varying(255),
    credit_card_type integer,
    paypal_id character varying(100),
    transaction_id character varying(100),
    return_code character varying(100),
    charge_type numeric DEFAULT 0,
    charge_amount numeric DEFAULT 0,
    response text,
    from_ip character varying(36),
    transaction_src json
);


ALTER TABLE public.payment_gateway_history OWNER TO class4_user;

--
-- Name: payment_gateway_history_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.payment_gateway_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.payment_gateway_history_id_seq OWNER TO class4_user;

--
-- Name: payment_gateway_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.payment_gateway_history_id_seq OWNED BY public.payment_gateway_history.id;


--
-- Name: payment_invoice; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.payment_invoice (
    id integer NOT NULL,
    payment_id integer,
    invoice_id integer,
    amount numeric(20,5)
);


ALTER TABLE public.payment_invoice OWNER TO class4_user;

--
-- Name: payment_invoice_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.payment_invoice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.payment_invoice_id_seq OWNER TO class4_user;

--
-- Name: payment_invoice_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.payment_invoice_id_seq OWNED BY public.payment_invoice.id;


--
-- Name: payment_term; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.payment_term (
    payment_term_id integer NOT NULL,
    name character varying(100) NOT NULL,
    type integer NOT NULL,
    days integer NOT NULL,
    grace_days integer,
    notify_days integer,
    more_days character varying(100),
    finance_rate real
);


ALTER TABLE public.payment_term OWNER TO class4_user;

--
-- Name: TABLE payment_term; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.payment_term IS '缴费设置';


--
-- Name: COLUMN payment_term.name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.payment_term.name IS '名字';


--
-- Name: COLUMN payment_term.type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.payment_term.type IS '付款时间：1－每隔多少天，2－每月哪一天,3－每周几，4－每月哪几天';


--
-- Name: COLUMN payment_term.days; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.payment_term.days IS '天数或日期';


--
-- Name: COLUMN payment_term.grace_days; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.payment_term.grace_days IS '缴款的宽限天数';


--
-- Name: COLUMN payment_term.notify_days; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.payment_term.notify_days IS '宽限期结束前，多小天前通知';


--
-- Name: payment_term_payment_term_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.payment_term_payment_term_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.payment_term_payment_term_id_seq OWNER TO class4_user;

--
-- Name: payment_term_payment_term_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.payment_term_payment_term_id_seq OWNED BY public.payment_term.payment_term_id;


--
-- Name: payment_term_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.payment_term_record (
    payment_term_id integer NOT NULL,
    name character varying(100) NOT NULL,
    type integer NOT NULL,
    days integer NOT NULL,
    grace_days integer,
    notify_days integer,
    more_days character varying(100),
    finance_rate real,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.payment_term_record OWNER TO class4_user;

--
-- Name: payment_term_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.payment_term_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.payment_term_record_record_id_seq OWNER TO class4_user;

--
-- Name: payment_term_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.payment_term_record_record_id_seq OWNED BY public.payment_term_record.record_id;


--
-- Name: pcap_query; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.pcap_query (
    query_key character varying(100) NOT NULL,
    callid character varying(100) NOT NULL,
    switch_ip character varying(15) NOT NULL,
    start timestamp with time zone NOT NULL,
    finish timestamp with time zone NOT NULL,
    queued_time timestamp with time zone,
    complete_time timestamp with time zone,
    status smallint,
    msg character varying(100),
    public_url character varying(255),
    requested_by character varying(100)
);


ALTER TABLE public.pcap_query OWNER TO class4_user;

--
-- Name: pcap_query_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.pcap_query_task (
    id integer NOT NULL,
    operator_user character varying(40),
    pcap_start_time timestamp with time zone,
    pcap_end_time timestamp with time zone,
    filter character varying(1024),
    result_file character varying(1024),
    status smallint DEFAULT '0'::smallint NOT NULL,
    progress character varying(1024),
    create_time timestamp with time zone DEFAULT now(),
    proc_start_time timestamp with time zone,
    proc_end_time timestamp with time zone,
    comment_number character varying(32),
    capture_uuid character varying(36)
);


ALTER TABLE public.pcap_query_task OWNER TO class4_user;

--
-- Name: pcap_query_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.pcap_query_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pcap_query_task_id_seq OWNER TO class4_user;

--
-- Name: pcap_query_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.pcap_query_task_id_seq OWNED BY public.pcap_query_task.id;


--
-- Name: pcap_query_task_mail; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.pcap_query_task_mail (
    id integer NOT NULL,
    direct json,
    email character varying(255),
    client_id integer,
    job_start_time timestamp with time zone,
    job_end_time timestamp with time zone,
    status smallint DEFAULT '0'::smallint NOT NULL,
    progress character varying(1024)
);


ALTER TABLE public.pcap_query_task_mail OWNER TO class4_user;

--
-- Name: product; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product (
    product_id integer NOT NULL,
    name character varying(100),
    modify_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL,
    introduction character varying(80),
    dynamic_route_id integer,
    update_by character varying,
    code_type integer DEFAULT 0,
    code_deck_id integer,
    route_lrn integer
);


ALTER TABLE public.product OWNER TO class4_user;

--
-- Name: TABLE product; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.product IS '静态路由表';


--
-- Name: COLUMN product.name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.product.name IS '名称';


--
-- Name: COLUMN product.modify_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.product.modify_time IS '修改时间';


--
-- Name: COLUMN product.introduction; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.product.introduction IS '说明';


--
-- Name: COLUMN product.dynamic_route_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.product.dynamic_route_id IS '动态路由转换生成';


--
-- Name: COLUMN product.route_lrn; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.product.route_lrn IS '0-dnis,1-lrn';


--
-- Name: product_agents_ref; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product_agents_ref (
    id integer NOT NULL,
    product_id integer,
    agent_id integer
);


ALTER TABLE public.product_agents_ref OWNER TO class4_user;

--
-- Name: product_agents_ref_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.product_agents_ref_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_agents_ref_id_seq OWNER TO class4_user;

--
-- Name: product_agents_ref_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.product_agents_ref_id_seq OWNED BY public.product_agents_ref.id;


--
-- Name: product_clients_ref; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product_clients_ref (
    id integer NOT NULL,
    product_id integer,
    client_id integer
);


ALTER TABLE public.product_clients_ref OWNER TO class4_user;

--
-- Name: product_clients_ref_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.product_clients_ref_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_clients_ref_id_seq OWNER TO class4_user;

--
-- Name: product_clients_ref_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.product_clients_ref_id_seq OWNED BY public.product_clients_ref.id;


--
-- Name: product_clients_ref_used; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product_clients_ref_used (
    id integer NOT NULL,
    product_id integer,
    client_id integer,
    _rate_last_sent timestamp with time zone
);


ALTER TABLE public.product_clients_ref_used OWNER TO class4_user;

--
-- Name: product_clients_ref_used_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.product_clients_ref_used_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_clients_ref_used_id_seq OWNER TO class4_user;

--
-- Name: product_clients_ref_used_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.product_clients_ref_used_id_seq OWNED BY public.product_clients_ref_used.id;


--
-- Name: product_codename; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product_codename (
    item_id integer NOT NULL,
    product_id integer,
    code_name character varying(255) NOT NULL
);


ALTER TABLE public.product_codename OWNER TO class4_user;

--
-- Name: product_codename_item_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.product_codename_item_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_codename_item_id_seq OWNER TO class4_user;

--
-- Name: product_codename_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.product_codename_item_id_seq OWNED BY public.product_codename.item_id;


--
-- Name: product_codename_resource; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product_codename_resource (
    item_id integer NOT NULL,
    resource_id integer
);


ALTER TABLE public.product_codename_resource OWNER TO class4_user;

--
-- Name: product_codename_resource_item_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.product_codename_resource_item_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_codename_resource_item_id_seq OWNER TO class4_user;

--
-- Name: product_codename_resource_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.product_codename_resource_item_id_seq OWNED BY public.product_codename_resource.item_id;


--
-- Name: product_items; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product_items (
    item_id integer NOT NULL,
    product_id integer,
    alias character varying(100),
    digits public.prefix_range DEFAULT ''::public.prefix_range NOT NULL,
    strategy integer DEFAULT 1 NOT NULL,
    time_profile_id integer,
    min_len integer DEFAULT 0,
    max_len integer DEFAULT 32,
    min_asr real,
    max_asr real,
    min_abr real,
    max_abr real,
    min_acd real,
    max_acd real,
    min_pdd integer,
    max_pdd integer,
    min_aloc real,
    max_aloc real,
    limit_price real,
    update_at timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    update_by character varying,
    code_name character(100)
);


ALTER TABLE public.product_items OWNER TO class4_user;

--
-- Name: TABLE product_items; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.product_items IS '静态路由';


--
-- Name: COLUMN product_items.strategy; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.product_items.strategy IS '0-;By Percentage;1-Top-Down;2-Round-Robin';


--
-- Name: product_items_item_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.product_items_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_items_item_id_seq OWNER TO class4_user;

--
-- Name: product_items_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.product_items_item_id_seq OWNED BY public.product_items.item_id;


--
-- Name: product_items_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product_items_record (
    item_id integer NOT NULL,
    product_id integer,
    alias character varying(100),
    digits public.prefix_range NOT NULL,
    strategy integer NOT NULL,
    time_profile_id integer,
    min_len integer,
    max_len integer,
    min_asr real,
    max_asr real,
    min_abr real,
    max_abr real,
    min_acd real,
    max_acd real,
    min_pdd integer,
    max_pdd integer,
    min_aloc real,
    max_aloc real,
    limit_price real,
    update_at timestamp with time zone,
    update_by character varying,
    code_name character(100),
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.product_items_record OWNER TO class4_user;

--
-- Name: product_items_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.product_items_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_items_record_record_id_seq OWNER TO class4_user;

--
-- Name: product_items_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.product_items_record_record_id_seq OWNED BY public.product_items_record.record_id;


--
-- Name: product_items_resource; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product_items_resource (
    id integer NOT NULL,
    item_id integer NOT NULL,
    resource_id integer NOT NULL,
    by_percentage integer,
    order_id integer,
    order_type integer
);


ALTER TABLE public.product_items_resource OWNER TO class4_user;

--
-- Name: COLUMN product_items_resource.order_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.product_items_resource.order_type IS '1-buy order;2-sell order';


--
-- Name: product_items_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.product_items_resource_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_items_resource_id_seq OWNER TO class4_user;

--
-- Name: product_items_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.product_items_resource_id_seq OWNED BY public.product_items_resource.id;


--
-- Name: product_items_resource_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product_items_resource_record (
    id integer NOT NULL,
    item_id integer NOT NULL,
    resource_id integer NOT NULL,
    by_percentage integer,
    order_id integer,
    order_type integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.product_items_resource_record OWNER TO class4_user;

--
-- Name: product_items_resource_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.product_items_resource_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_items_resource_record_record_id_seq OWNER TO class4_user;

--
-- Name: product_items_resource_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.product_items_resource_record_record_id_seq OWNED BY public.product_items_resource_record.record_id;


--
-- Name: product_product_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.product_product_id_seq
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_product_id_seq OWNER TO class4_user;

--
-- Name: product_product_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.product_product_id_seq OWNED BY public.product.product_id;


--
-- Name: product_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product_record (
    product_id integer NOT NULL,
    name character varying(100),
    modify_time timestamp with time zone NOT NULL,
    introduction character varying(80),
    dynamic_route_id integer,
    update_by character varying,
    code_type integer,
    code_deck_id integer,
    route_lrn integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.product_record OWNER TO class4_user;

--
-- Name: product_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.product_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_record_record_id_seq OWNER TO class4_user;

--
-- Name: product_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.product_record_record_id_seq OWNED BY public.product_record.record_id;


--
-- Name: product_rout_rate_table; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product_rout_rate_table (
    id integer NOT NULL,
    rout_id integer NOT NULL,
    rate_table_id integer NOT NULL,
    product_name character varying(256) NOT NULL,
    agent_id integer,
    status integer DEFAULT 1,
    type integer DEFAULT 0,
    marketplace integer DEFAULT 0,
    par_id integer,
    prefix character varying,
    description text,
    allowed_client text,
    update_by character varying,
    update_at timestamp with time zone
);


ALTER TABLE public.product_rout_rate_table OWNER TO class4_user;

--
-- Name: COLUMN product_rout_rate_table.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.product_rout_rate_table.status IS '0:Inactive; 1:Active';


--
-- Name: COLUMN product_rout_rate_table.type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.product_rout_rate_table.type IS '0:Public; 1:Private';


--
-- Name: COLUMN product_rout_rate_table.marketplace; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.product_rout_rate_table.marketplace IS '0:A-Z; 1:US';


--
-- Name: product_rout_rate_table_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.product_rout_rate_table_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_rout_rate_table_id_seq OWNER TO class4_user;

--
-- Name: product_rout_rate_table_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.product_rout_rate_table_id_seq OWNED BY public.product_rout_rate_table.id;


--
-- Name: product_rout_rate_table_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product_rout_rate_table_record (
    id integer NOT NULL,
    rout_id integer NOT NULL,
    rate_table_id integer NOT NULL,
    product_name character varying(256) NOT NULL,
    agent_id integer,
    status integer,
    type integer,
    marketplace integer,
    par_id integer,
    prefix character varying,
    description text,
    allowed_client text,
    update_by character varying,
    update_at timestamp with time zone,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.product_rout_rate_table_record OWNER TO class4_user;

--
-- Name: product_rout_rate_table_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.product_rout_rate_table_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_rout_rate_table_record_record_id_seq OWNER TO class4_user;

--
-- Name: product_rout_rate_table_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.product_rout_rate_table_record_record_id_seq OWNED BY public.product_rout_rate_table_record.record_id;


--
-- Name: product_route_analysis; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product_route_analysis (
    uuid character varying(36) NOT NULL,
    count_profiltable_routes integer,
    route_plan_id integer NOT NULL,
    rate_table_id integer NOT NULL,
    code_deck_id integer,
    date timestamp without time zone,
    status smallint,
    finish timestamp without time zone,
    process text,
    rec_num integer,
    create_by character varying(100),
    characteristics smallint
);


ALTER TABLE public.product_route_analysis OWNER TO class4_user;

--
-- Name: product_route_analysis_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.product_route_analysis_log (
    id integer NOT NULL,
    uuid character varying(36),
    code public.prefix_range,
    code_name character varying(100),
    country character varying(100),
    rate numeric,
    trunk_count integer,
    profitable_trunk_count integer
);


ALTER TABLE public.product_route_analysis_log OWNER TO class4_user;

--
-- Name: product_route_analysis_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.product_route_analysis_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_route_analysis_log_id_seq OWNER TO class4_user;

--
-- Name: product_route_analysis_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.product_route_analysis_log_id_seq OWNED BY public.product_route_analysis_log.id;


--
-- Name: qos_client; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.qos_client (
    report_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL,
    client_id integer,
    call integer,
    inbound_cps integer,
    inbound_chan integer,
    outbound_cps integer,
    outbound_chan integer,
    server_ip character varying(50),
    server_port integer
);


ALTER TABLE public.qos_client OWNER TO class4_user;

--
-- Name: qos_ip; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.qos_ip (
    report_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    ip_id integer,
    call integer,
    cps integer,
    direction integer,
    server_ip character varying(50),
    server_port integer,
    channels integer
);


ALTER TABLE public.qos_ip OWNER TO class4_user;

--
-- Name: qos_resource; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.qos_resource (
    report_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL,
    res_id integer,
    call integer,
    cps integer,
    direction integer,
    server_ip character varying(50),
    server_port integer,
    channels integer
);


ALTER TABLE public.qos_resource OWNER TO class4_user;

--
-- Name: qos_route_report; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.qos_route_report (
    report_time timestamp with time zone NOT NULL,
    resource_id integer,
    code character varying(32),
    not_zero_calls integer,
    total_calls integer,
    bill_time integer,
    cancel_calls integer,
    busy_calls integer,
    direction integer,
    server_ip character varying(36),
    pdd integer,
    cost numeric(12,6),
    egress_channels integer,
    total_pdd integer,
    call_duration integer
);


ALTER TABLE public.qos_route_report OWNER TO class4_user;

--
-- Name: TABLE qos_route_report; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.qos_route_report IS '统计resource + code的asr, acd等，保存时间可以限制在一个小时，一个小时以前的在报表服务器可以查询。';


--
-- Name: COLUMN qos_route_report.report_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.qos_route_report.report_time IS '产生报表数据的时间';


--
-- Name: COLUMN qos_route_report.code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.qos_route_report.code IS '例如：86，86755等';


--
-- Name: COLUMN qos_route_report.bill_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.qos_route_report.bill_time IS '秒单位';


--
-- Name: COLUMN qos_route_report.direction; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.qos_route_report.direction IS '0 --- ingress;1 --- egress';


--
-- Name: COLUMN qos_route_report.server_ip; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.qos_route_report.server_ip IS 'switch的sip profile IP';


--
-- Name: qos_total; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.qos_total (
    report_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    call integer,
    cps integer,
    server_ip character varying(50),
    server_port integer,
    channels integer,
    ingress_channels integer,
    ingress_cps integer,
    egress_cps integer,
    egress_channels integer
);


ALTER TABLE public.qos_total OWNER TO class4_user;

--
-- Name: random_ani_generation; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.random_ani_generation (
    id integer NOT NULL,
    ani_number character varying(32),
    random_table_id integer,
    enabled boolean DEFAULT true NOT NULL
);


ALTER TABLE public.random_ani_generation OWNER TO class4_user;

--
-- Name: TABLE random_ani_generation; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.random_ani_generation IS '随机替换呼出主角号码，针对不同供应商使用不同号码。';


--
-- Name: COLUMN random_ani_generation.ani_number; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.random_ani_generation.ani_number IS '随机替换的号码。';


--
-- Name: random_ani_generation_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.random_ani_generation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.random_ani_generation_id_seq OWNER TO class4_user;

--
-- Name: random_ani_generation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.random_ani_generation_id_seq OWNED BY public.random_ani_generation.id;


--
-- Name: random_ani_generation_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.random_ani_generation_record (
    id integer NOT NULL,
    ani_number character varying(32),
    random_table_id integer,
    enabled boolean NOT NULL,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.random_ani_generation_record OWNER TO class4_user;

--
-- Name: random_ani_generation_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.random_ani_generation_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.random_ani_generation_record_record_id_seq OWNER TO class4_user;

--
-- Name: random_ani_generation_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.random_ani_generation_record_record_id_seq OWNED BY public.random_ani_generation_record.record_id;


--
-- Name: random_ani_group; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.random_ani_group (
    id integer NOT NULL,
    group_name character varying(100),
    create_time timestamp with time zone DEFAULT now()
);


ALTER TABLE public.random_ani_group OWNER TO class4_user;

--
-- Name: random_ani_group_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.random_ani_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.random_ani_group_id_seq OWNER TO class4_user;

--
-- Name: random_ani_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.random_ani_group_id_seq OWNED BY public.random_ani_group.id;


--
-- Name: random_ani_group_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.random_ani_group_record (
    id integer NOT NULL,
    group_name character varying(100),
    create_time timestamp with time zone,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.random_ani_group_record OWNER TO class4_user;

--
-- Name: random_ani_group_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.random_ani_group_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.random_ani_group_record_record_id_seq OWNER TO class4_user;

--
-- Name: random_ani_group_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.random_ani_group_record_record_id_seq OWNED BY public.random_ani_group_record.record_id;


--
-- Name: rate; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate (
    rate_id integer NOT NULL,
    rate_table_id integer NOT NULL,
    code public.prefix_range DEFAULT ''::public.prefix_range,
    rate numeric(30,10),
    setup_fee numeric(30,10) DEFAULT 0 NOT NULL,
    effective_date timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    end_date timestamp with time zone,
    min_time integer DEFAULT 0 NOT NULL,
    grace_time integer DEFAULT 0 NOT NULL,
    "interval" integer DEFAULT 1 NOT NULL,
    time_profile_id integer,
    seconds integer DEFAULT 60 NOT NULL,
    code_name character varying(100),
    basic_percentages real DEFAULT 0,
    gift_percentages real DEFAULT 0,
    rate_type integer DEFAULT 3 NOT NULL,
    intra_rate numeric(30,10),
    inter_rate numeric(30,10),
    local_rate numeric(30,10),
    country character varying(1000),
    zone character varying(10) DEFAULT 0,
    ocn character varying(10),
    lata character varying(10),
    create_time timestamp with time zone,
    did_type integer
);


ALTER TABLE public.rate OWNER TO class4_user;

--
-- Name: TABLE rate; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.rate IS '详细费率';


--
-- Name: COLUMN rate.rate_table_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.rate_table_id IS 'rate_table';


--
-- Name: COLUMN rate.code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.code IS '前缀号码和cdr表的被叫号匹配 ';


--
-- Name: COLUMN rate.rate; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.rate IS '每分钟费用';


--
-- Name: COLUMN rate.setup_fee; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.setup_fee IS '固定费用';


--
-- Name: COLUMN rate.effective_date; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.effective_date IS '开始时间';


--
-- Name: COLUMN rate.end_date; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.end_date IS '结束时间';


--
-- Name: COLUMN rate.min_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.min_time IS '首次时长(秒)';


--
-- Name: COLUMN rate.grace_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.grace_time IS '免费时长(秒)';


--
-- Name: COLUMN rate."interval"; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate."interval" IS '计费周期;6秒计费;不足6秒的要补;8秒算2个6秒';


--
-- Name: COLUMN rate.time_profile_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.time_profile_id IS '时间段设置';


--
-- Name: COLUMN rate.seconds; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.seconds IS '每分钟多少秒';


--
-- Name: COLUMN rate.code_name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.code_name IS '号码名称';


--
-- Name: COLUMN rate.basic_percentages; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.basic_percentages IS '基础金比例';


--
-- Name: COLUMN rate.gift_percentages; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.gift_percentages IS '赠送金比例';


--
-- Name: COLUMN rate.rate_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.rate_type IS '1－－interstate，不同的地区;2－－intrastate，同一个地区;3－－others，其他';


--
-- Name: COLUMN rate.intra_rate; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.intra_rate IS '2－－intrastate，同一个地区';


--
-- Name: COLUMN rate.inter_rate; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.inter_rate IS '1－－interstate，不同的地区';


--
-- Name: COLUMN rate.did_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate.did_type IS '1:未分配;2:已分配';


--
-- Name: rate_analysis_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_analysis_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_analysis_task_id_seq OWNER TO class4_user;

--
-- Name: rate_analysis_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_analysis_task (
    task_id integer DEFAULT nextval('public.rate_analysis_task_id_seq'::regclass) NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    progress integer,
    operator_user character varying(40),
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    create_time timestamp with time zone,
    expense_detail character varying(100),
    source_rate_table_id integer,
    source_effective_date timestamp with time zone,
    target_rate_table_id integer,
    target_effective_date timestamp with time zone,
    target_file_name character varying(512),
    rate_generation_history_id integer,
    created_on timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL,
    started_on timestamp with time zone,
    finished_on timestamp with time zone,
    result_json character varying(512)
);


ALTER TABLE public.rate_analysis_task OWNER TO class4_user;

--
-- Name: rate_auto_import_mailbox_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_auto_import_mailbox_log (
    id integer NOT NULL,
    start timestamp with time zone DEFAULT now(),
    finish timestamp with time zone,
    error text
);


ALTER TABLE public.rate_auto_import_mailbox_log OWNER TO class4_user;

--
-- Name: rate_auto_import_mailbox_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_auto_import_mailbox_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_auto_import_mailbox_log_id_seq OWNER TO class4_user;

--
-- Name: rate_auto_import_mailbox_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_auto_import_mailbox_log_id_seq OWNED BY public.rate_auto_import_mailbox_log.id;


--
-- Name: rate_auto_import_rule; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_auto_import_rule (
    id integer NOT NULL,
    name character varying(100),
    active boolean,
    create_by character varying(100),
    create_on timestamp with time zone DEFAULT ('now'::text)::date,
    update_by character varying(100),
    update_on timestamp with time zone DEFAULT ('now'::text)::date,
    egress_trunk_id integer,
    from_email character varying(100),
    subject_keyword character varying(100),
    pre_info text,
    rate_date_format character varying(40),
    rate_table_code_deck_id integer,
    reduplicate_rate_action integer DEFAULT 0 NOT NULL,
    code_deck_flag integer DEFAULT 0 NOT NULL,
    use_ocn_lata_code integer DEFAULT 0 NOT NULL,
    is_link boolean,
    read_effective_date_from smallint,
    mail_server_ip character varying(100)
);


ALTER TABLE public.rate_auto_import_rule OWNER TO class4_user;

--
-- Name: rate_auto_import_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_auto_import_rule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_auto_import_rule_id_seq OWNER TO class4_user;

--
-- Name: rate_auto_import_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_auto_import_rule_id_seq OWNED BY public.rate_auto_import_rule.id;


--
-- Name: rate_auto_import_rule_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_auto_import_rule_log (
    id integer NOT NULL,
    rule_id integer,
    status integer NOT NULL,
    start timestamp with time zone DEFAULT ('now'::text)::date,
    finish timestamp with time zone,
    error text,
    received_from_ip character varying(16)
);


ALTER TABLE public.rate_auto_import_rule_log OWNER TO class4_user;

--
-- Name: rate_auto_import_rule_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_auto_import_rule_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_auto_import_rule_log_id_seq OWNER TO class4_user;

--
-- Name: rate_auto_import_rule_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_auto_import_rule_log_id_seq OWNED BY public.rate_auto_import_rule_log.id;


--
-- Name: rate_download_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_download_log (
    id integer NOT NULL,
    resource_id integer,
    file_path character varying,
    download_time timestamp with time zone,
    download_ip character varying,
    log_detail_id integer,
    download_username character varying(100)
);


ALTER TABLE public.rate_download_log OWNER TO class4_user;

--
-- Name: rate_download_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_download_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_download_log_id_seq OWNER TO class4_user;

--
-- Name: rate_download_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_download_log_id_seq OWNED BY public.rate_download_log.id;


--
-- Name: rate_generation_code_deck; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_generation_code_deck (
    rate_generation_template_id integer,
    code character varying(30),
    code_name character varying(100),
    country character varying(100)
);


ALTER TABLE public.rate_generation_code_deck OWNER TO class4_user;

--
-- Name: rate_generation_history; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_generation_history (
    id integer NOT NULL,
    is_applied boolean DEFAULT false,
    rate_generation_template_id integer,
    status smallint DEFAULT 0 NOT NULL,
    finished_time timestamp with time zone,
    rate_count integer DEFAULT 0 NOT NULL,
    processing_time integer DEFAULT 0 NOT NULL,
    progress character varying(200),
    create_on timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    create_by character varying(100),
    rate_table_type integer
);


ALTER TABLE public.rate_generation_history OWNER TO class4_user;

--
-- Name: COLUMN rate_generation_history.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_generation_history.status IS '0 for initial; 1 for in process, 2 for finished; 3 for error';


--
-- Name: rate_generation_history_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_generation_history_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_generation_history_detail_id_seq OWNER TO class4_user;

--
-- Name: rate_generation_history_detail; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_generation_history_detail (
    id integer DEFAULT nextval('public.rate_generation_history_detail_id_seq'::regclass) NOT NULL,
    rate_table_id integer,
    effective_date_new timestamp with time zone,
    effective_date_increase timestamp with time zone,
    effective_date_decrease timestamp with time zone,
    is_send_mail boolean,
    end_date date,
    email_template_id integer,
    rate_generation_history_id integer,
    create_on timestamp with time zone,
    create_by character varying(100),
    finished_time timestamp with time zone,
    end_date_method integer DEFAULT 1,
    rand_flg character varying(100),
    new_rate_end_date date,
    progress character varying(200),
    rate_import_task_id integer,
    code_deck_id integer
);


ALTER TABLE public.rate_generation_history_detail OWNER TO class4_user;

--
-- Name: rate_generation_history_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_generation_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_generation_history_id_seq OWNER TO class4_user;

--
-- Name: rate_generation_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_generation_history_id_seq OWNED BY public.rate_generation_history.id;


--
-- Name: rate_generation_rate; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_generation_rate (
    rate_generation_history_id integer NOT NULL,
    code public.prefix_range DEFAULT ''::public.prefix_range NOT NULL,
    rate numeric(30,10),
    setup_fee numeric(30,10) DEFAULT 0 NOT NULL,
    effective_date timestamp with time zone,
    end_date timestamp with time zone,
    min_time integer DEFAULT 0 NOT NULL,
    grace_time integer DEFAULT 0 NOT NULL,
    "interval" integer DEFAULT 1 NOT NULL,
    time_profile_id integer,
    seconds integer DEFAULT 60 NOT NULL,
    code_name character varying(100),
    rate_type integer DEFAULT 3 NOT NULL,
    intra_rate numeric(30,10),
    inter_rate numeric(30,10),
    local_rate numeric(30,10),
    country character varying(1000),
    zone character varying(10) DEFAULT 0,
    ocn character varying(10),
    lata character varying(10),
    generation_rate_id integer NOT NULL,
    lcr_rate character varying(100),
    lcr_intra_rate character varying(100),
    lcr_inter_rate character varying(100),
    lcr_local_rate character varying(100)
);


ALTER TABLE public.rate_generation_rate OWNER TO class4_user;

--
-- Name: rate_generation_rate_generation_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_generation_rate_generation_rate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_generation_rate_generation_rate_id_seq OWNER TO class4_user;

--
-- Name: rate_generation_rate_generation_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_generation_rate_generation_rate_id_seq OWNED BY public.rate_generation_rate.generation_rate_id;


--
-- Name: rate_generation_template; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_generation_template (
    id integer NOT NULL,
    name character varying(50),
    include_blocked_route boolean DEFAULT false,
    rate_table_type integer DEFAULT 1 NOT NULL,
    lcr_digit integer,
    default_rate numeric(30,10),
    margin_default_type integer,
    margin_default_value character varying(30),
    default_interval integer,
    default_min_time integer,
    create_by character varying(100),
    create_on timestamp with time zone,
    last_generated timestamp with time zone,
    code_deck_id integer,
    egress_str character varying(500),
    include_local_rate boolean DEFAULT false,
    effective_days integer DEFAULT 0,
    decimal_places integer DEFAULT 0,
    user_defined_code_deck boolean DEFAULT false,
    min_asr real,
    asr_days integer,
    ignore_zero_rates boolean DEFAULT false NOT NULL
);


ALTER TABLE public.rate_generation_template OWNER TO class4_user;

--
-- Name: COLUMN rate_generation_template.rate_table_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_generation_template.rate_table_type IS '0 for A-Z; 1 for US Jurisdictional; 2 for US Non Jurisdictional, 3 for OCN-LATA';


--
-- Name: COLUMN rate_generation_template.lcr_digit; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_generation_template.lcr_digit IS 'Which LCR selection';


--
-- Name: COLUMN rate_generation_template.default_rate; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_generation_template.default_rate IS 'Default rate if no egress is available';


--
-- Name: COLUMN rate_generation_template.margin_default_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_generation_template.margin_default_type IS '1 for Percentage; 2 for Fix Value';


--
-- Name: COLUMN rate_generation_template.egress_str; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_generation_template.egress_str IS 'Egress trunk list, format: trunk_1_id,trunk_1_rate_table_id;trunk_2_id,trunk_2_rate_table_id;...';


--
-- Name: COLUMN rate_generation_template.decimal_places; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_generation_template.decimal_places IS '0 for use system default, other is rate decimal places';


--
-- Name: rate_generation_template_detail; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_generation_template_detail (
    id integer NOT NULL,
    rate_generation_template_id integer,
    rate_interval integer,
    min_time integer,
    code character varying(50)
);


ALTER TABLE public.rate_generation_template_detail OWNER TO class4_user;

--
-- Name: rate_generation_template_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_generation_template_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_generation_template_detail_id_seq OWNER TO class4_user;

--
-- Name: rate_generation_template_detail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_generation_template_detail_id_seq OWNED BY public.rate_generation_template_detail.id;


--
-- Name: rate_generation_template_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_generation_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_generation_template_id_seq OWNER TO class4_user;

--
-- Name: rate_generation_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_generation_template_id_seq OWNED BY public.rate_generation_template.id;


--
-- Name: rate_generation_template_margin; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_generation_template_margin (
    id integer NOT NULL,
    rate_generation_template_id integer,
    min_rate numeric(30,10),
    max_rate numeric(30,10),
    markup_type integer,
    markup_value numeric(30,10)
);


ALTER TABLE public.rate_generation_template_margin OWNER TO class4_user;

--
-- Name: COLUMN rate_generation_template_margin.markup_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_generation_template_margin.markup_type IS '1 for Percentage; 2 for Fix Value';


--
-- Name: rate_generation_template_margin_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_generation_template_margin_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_generation_template_margin_id_seq OWNER TO class4_user;

--
-- Name: rate_generation_template_margin_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_generation_template_margin_id_seq OWNED BY public.rate_generation_template_margin.id;


--
-- Name: rate_import_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_import_task_id_seq
    START WITH 610
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_import_task_id_seq OWNER TO class4_user;

--
-- Name: rate_import_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_import_task (
    id integer DEFAULT nextval('public.rate_import_task_id_seq'::regclass) NOT NULL,
    operator_user character varying(40),
    import_file_path character varying(256),
    orig_rate_file character varying(256),
    format_rate_file character varying(256),
    import_log_path character varying(256),
    rate_table_id integer NOT NULL,
    code_deck_id integer,
    code_name_provider smallint DEFAULT '0'::smallint NOT NULL,
    import_rate_date_format character varying(40),
    end_date_all_records_time timestamp with time zone,
    end_date_other_code_time timestamp with time zone,
    redup_in_file_action smallint DEFAULT '0'::smallint NOT NULL,
    status smallint DEFAULT 0,
    progress character varying(1024),
    expense_detail character varying(100),
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    create_time timestamp with time zone,
    redup_in_rate_table_action smallint DEFAULT '0'::smallint NOT NULL
);


ALTER TABLE public.rate_import_task OWNER TO class4_user;

--
-- Name: rate_mass_edit_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_mass_edit_log (
    id integer NOT NULL,
    action_time timestamp with time zone,
    client_id integer,
    action_type smallint,
    down_file_path text,
    rate_table_id integer,
    action_rate_rows integer,
    edited_by character varying(100)
);


ALTER TABLE public.rate_mass_edit_log OWNER TO class4_user;

--
-- Name: COLUMN rate_mass_edit_log.action_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_mass_edit_log.action_type IS '0 => ''delete found rates'',
1 => ''insert as new rates'',
2 => ''update current rates'',
3 => ''update all rates'',';


--
-- Name: rate_mass_edit_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_mass_edit_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_mass_edit_log_id_seq OWNER TO class4_user;

--
-- Name: rate_mass_edit_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_mass_edit_log_id_seq OWNED BY public.rate_mass_edit_log.id;


--
-- Name: rate_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_rate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_rate_id_seq OWNER TO class4_user;

--
-- Name: rate_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_rate_id_seq OWNED BY public.rate.rate_id;


--
-- Name: rate_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_record (
    rate_id integer NOT NULL,
    rate_table_id integer NOT NULL,
    code public.prefix_range,
    rate numeric(30,10),
    setup_fee numeric(30,10) NOT NULL,
    effective_date timestamp with time zone,
    end_date timestamp with time zone,
    min_time integer NOT NULL,
    grace_time integer NOT NULL,
    "interval" integer NOT NULL,
    time_profile_id integer,
    seconds integer NOT NULL,
    code_name character varying(100),
    basic_percentages real,
    gift_percentages real,
    rate_type integer NOT NULL,
    intra_rate numeric(30,10),
    inter_rate numeric(30,10),
    local_rate numeric(30,10),
    country character varying(1000),
    zone character varying(10),
    ocn character varying(10),
    lata character varying(10),
    create_time timestamp with time zone,
    did_type integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.rate_record OWNER TO class4_user;

--
-- Name: rate_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_record_record_id_seq OWNER TO class4_user;

--
-- Name: rate_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_record_record_id_seq OWNED BY public.rate_record.record_id;


--
-- Name: rate_send_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_send_log (
    rate_table_id integer NOT NULL,
    status smallint NOT NULL,
    zip smallint,
    file character varying(500),
    error character varying(500),
    format smallint NOT NULL,
    id integer NOT NULL,
    email_template_id integer,
    create_time timestamp with time zone,
    effective_date character varying(50),
    start_effective_date character varying(50),
    download_deadline date,
    is_email_alert boolean DEFAULT false NOT NULL,
    is_disable boolean DEFAULT false NOT NULL,
    is_temp boolean DEFAULT false,
    headers character varying(500),
    send_type integer DEFAULT 0,
    send_specify_email character varying,
    resource_ids character varying(500),
    download_method integer DEFAULT 1,
    total_records integer,
    completed_records integer,
    sent_area smallint DEFAULT 1,
    date_format smallint DEFAULT 0,
    indicate_inc_dec boolean DEFAULT false
);


ALTER TABLE public.rate_send_log OWNER TO class4_user;

--
-- Name: COLUMN rate_send_log.rate_table_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_send_log.rate_table_id IS '发送费率的 rate table id ';


--
-- Name: COLUMN rate_send_log.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_send_log.status IS '1:正在执行
2:发送成功
3:发送失败';


--
-- Name: COLUMN rate_send_log.zip; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_send_log.zip IS '1：打包
2：没有打包';


--
-- Name: COLUMN rate_send_log.file; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_send_log.file IS '发送的rate文件';


--
-- Name: COLUMN rate_send_log.error; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_send_log.error IS '错误的提示';


--
-- Name: COLUMN rate_send_log.format; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_send_log.format IS '1:csv
2:xls';


--
-- Name: COLUMN rate_send_log.effective_date; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_send_log.effective_date IS '发出去费率的生效日期范围';


--
-- Name: COLUMN rate_send_log.download_deadline; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_send_log.download_deadline IS '下载截至日期';


--
-- Name: rate_send_log_detail; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_send_log_detail (
    id integer NOT NULL,
    log_id integer,
    resource_id integer,
    send_to character varying(100),
    status integer,
    error text,
    salt character varying,
    download_date date,
    sent_on timestamp with time zone
);


ALTER TABLE public.rate_send_log_detail OWNER TO class4_user;

--
-- Name: rate_send_log_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_send_log_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_send_log_detail_id_seq OWNER TO class4_user;

--
-- Name: rate_send_log_detail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_send_log_detail_id_seq OWNED BY public.rate_send_log_detail.id;


--
-- Name: rate_send_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_send_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_send_log_id_seq OWNER TO class4_user;

--
-- Name: rate_send_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_send_log_id_seq OWNED BY public.rate_send_log.id;


--
-- Name: rate_table; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_table (
    rate_table_id integer NOT NULL,
    name character varying(100) NOT NULL,
    modify_time timestamp with time zone,
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL,
    code_deck_id integer,
    currency_id integer DEFAULT 1,
    rate_type integer DEFAULT 0,
    jurisdiction_country_id integer,
    update_at timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    update_by character varying,
    lnp_dipping_rate real,
    jurisdiction_prefix public.prefix_range,
    noprefix_min_length integer,
    noprefix_max_length integer,
    prefix_min_length integer,
    prefix_max_length integer,
    jur_type smallint DEFAULT 0,
    origination boolean DEFAULT false,
    is_virtual boolean,
    default_setup_fee double precision DEFAULT '0'::double precision,
    require_local_rate boolean DEFAULT false,
    require_setup_fee boolean DEFAULT false
);


ALTER TABLE public.rate_table OWNER TO class4_user;

--
-- Name: TABLE rate_table; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.rate_table IS '费率模板';


--
-- Name: COLUMN rate_table.name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_table.name IS '名称';


--
-- Name: COLUMN rate_table.modify_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_table.modify_time IS '上次修改时间';


--
-- Name: COLUMN rate_table.create_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_table.create_time IS '生成时间';


--
-- Name: COLUMN rate_table.code_deck_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_table.code_deck_id IS '前缀号码组';


--
-- Name: COLUMN rate_table.currency_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_table.currency_id IS '货币';


--
-- Name: COLUMN rate_table.rate_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_table.rate_type IS '0-dnis;1-lrn;2-lrn block';


--
-- Name: COLUMN rate_table.jurisdiction_country_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_table.jurisdiction_country_id IS '计费区域国家，有值表示费率是按照intra/inter来计算，没有值表示dnis计费。';


--
-- Name: rate_table_rate_table_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_table_rate_table_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_table_rate_table_id_seq OWNER TO class4_user;

--
-- Name: rate_table_rate_table_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_table_rate_table_id_seq OWNED BY public.rate_table.rate_table_id;


--
-- Name: rate_table_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_table_record (
    rate_table_id integer NOT NULL,
    name character varying(100) NOT NULL,
    modify_time timestamp with time zone,
    create_time timestamp with time zone NOT NULL,
    code_deck_id integer,
    currency_id integer,
    rate_type integer,
    jurisdiction_country_id integer,
    update_at timestamp with time zone,
    update_by character varying,
    lnp_dipping_rate real,
    jurisdiction_prefix public.prefix_range,
    noprefix_min_length integer,
    noprefix_max_length integer,
    prefix_min_length integer,
    prefix_max_length integer,
    jur_type smallint,
    origination boolean,
    is_virtual boolean,
    default_setup_fee double precision,
    require_local_rate boolean,
    require_setup_fee boolean,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.rate_table_record OWNER TO class4_user;

--
-- Name: rate_table_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_table_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_table_record_record_id_seq OWNER TO class4_user;

--
-- Name: rate_table_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_table_record_record_id_seq OWNED BY public.rate_table_record.record_id;


--
-- Name: rate_type_name; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_type_name (
    id integer NOT NULL,
    name character varying(100) NOT NULL
);


ALTER TABLE public.rate_type_name OWNER TO class4_user;

--
-- Name: rate_type_name_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_type_name_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_type_name_id_seq OWNER TO class4_user;

--
-- Name: rate_type_name_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_type_name_id_seq OWNED BY public.rate_type_name.id;


--
-- Name: rate_type_override; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_type_override (
    id integer NOT NULL,
    src_country character varying(4) NOT NULL,
    dest_country character varying(2) DEFAULT 'US'::character varying NOT NULL,
    rate_type integer DEFAULT 1 NOT NULL,
    comment text,
    resource_id integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.rate_type_override OWNER TO class4_user;

--
-- Name: rate_type_override_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_type_override_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_type_override_id_seq OWNER TO class4_user;

--
-- Name: rate_type_override_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_type_override_id_seq OWNED BY public.rate_type_override.id;


--
-- Name: rate_type_override_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_type_override_record (
    id integer NOT NULL,
    src_country character varying(4) NOT NULL,
    dest_country character varying(2) NOT NULL,
    rate_type integer NOT NULL,
    comment text,
    resource_id integer NOT NULL,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.rate_type_override_record OWNER TO class4_user;

--
-- Name: rate_type_override_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_type_override_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_type_override_record_record_id_seq OWNER TO class4_user;

--
-- Name: rate_type_override_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_type_override_record_record_id_seq OWNED BY public.rate_type_override_record.record_id;


--
-- Name: rate_upload_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_upload_task (
    id integer NOT NULL,
    operator_user character varying(40),
    upload_file_path character varying(256),
    upload_orig_file character(256),
    upload_format_file character(256),
    result_file_path character varying(256),
    rate_table_id integer NOT NULL,
    rate_table_code_deck_id integer,
    rate_date_format character varying(40),
    rate_end_date character varying(40),
    reduplicate_rate_action smallint DEFAULT 0 NOT NULL,
    code_deck_flag smallint DEFAULT 0 NOT NULL,
    use_ocn_lata_code smallint DEFAULT 0 NOT NULL,
    status smallint DEFAULT 0 NOT NULL,
    progress character varying(200),
    expense_detail character varying(100),
    create_time bigint,
    start_time bigint,
    end_time bigint,
    default_info character varying(200),
    all_rate_end_date timestamp with time zone,
    code_name_match boolean,
    start_from integer,
    pre_info text,
    pre_status smallint NOT NULL,
    task_id character varying(36),
    rule_log_id integer,
    import_task_id integer
);


ALTER TABLE public.rate_upload_task OWNER TO class4_user;

--
-- Name: COLUMN rate_upload_task.rate_date_format; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_upload_task.rate_date_format IS 'Upload rate date format';


--
-- Name: COLUMN rate_upload_task.rate_end_date; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_upload_task.rate_end_date IS 'Rate end date, a specified date or NULL(use current time)';


--
-- Name: COLUMN rate_upload_task.reduplicate_rate_action; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_upload_task.reduplicate_rate_action IS 'reduplicate rate action: 0 for Ingore, 1 for Delete, 2 for Update';


--
-- Name: COLUMN rate_upload_task.code_deck_flag; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_upload_task.code_deck_flag IS 'Use system code deck, 0 for use rate code, 1 for use system global code deck';


--
-- Name: COLUMN rate_upload_task.use_ocn_lata_code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_upload_task.use_ocn_lata_code IS 'Use OCN code deck, 0 for No, 1 for Yes';


--
-- Name: COLUMN rate_upload_task.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_upload_task.status IS '0 for initial; 1 for download rate; 2 for process rate, 3 for commit rate to db; 4 for finished; 5 for error';


--
-- Name: COLUMN rate_upload_task.expense_detail; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rate_upload_task.expense_detail IS 'Detailed processing time: download, process, delete, update, copy action elapsed time';


--
-- Name: rate_upload_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_upload_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_upload_task_id_seq OWNER TO class4_user;

--
-- Name: rate_upload_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_upload_task_id_seq OWNED BY public.rate_upload_task.id;


--
-- Name: rate_upload_template; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_upload_template (
    id integer NOT NULL,
    create_by character varying(100),
    create_on timestamp with time zone,
    update_on timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    update_by character varying(100),
    name character varying(100),
    auto_ij_rate smallint,
    code_deck_id integer,
    code_name_provider smallint DEFAULT '0'::smallint NOT NULL,
    effective_date timestamp with time zone,
    end_date_other_code_time timestamp with time zone,
    import_rate_date_format character varying(40),
    rate_table_id integer,
    redup_in_file_action smallint DEFAULT '0'::smallint NOT NULL,
    redup_in_rate_table_action smallint DEFAULT '0'::smallint NOT NULL,
    end_date_all_records_time timestamp with time zone,
    default_interval integer,
    default_min_time integer,
    ignore_fields text,
    replace_fields text,
    replace_values text,
    map_header text
);


ALTER TABLE public.rate_upload_template OWNER TO class4_user;

--
-- Name: rate_upload_template_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_upload_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_upload_template_id_seq OWNER TO class4_user;

--
-- Name: rate_upload_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_upload_template_id_seq OWNED BY public.rate_upload_template.id;


--
-- Name: rate_upload_values; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rate_upload_values (
    id integer NOT NULL,
    task_id integer,
    "Code" public.prefix_range DEFAULT ''::public.prefix_range,
    "Rate" numeric,
    "Inter_rate" numeric,
    "Intra_rate" numeric,
    "Local_rate" numeric,
    "Min_time" integer DEFAULT 1 NOT NULL,
    "Interval" integer DEFAULT 0 NOT NULL,
    "Code_name" character varying(100),
    "Country" character varying(1000),
    "Effective_date" character varying(10)
);


ALTER TABLE public.rate_upload_values OWNER TO class4_user;

--
-- Name: rate_upload_values_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rate_upload_values_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_upload_values_id_seq OWNER TO class4_user;

--
-- Name: rate_upload_values_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rate_upload_values_id_seq OWNED BY public.rate_upload_values.id;


--
-- Name: register_of_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.register_of_record (
    id integer NOT NULL,
    "time" bigint,
    state smallint,
    username character varying(100),
    direction integer,
    ip public.ip4r,
    port integer,
    expires_time bigint
);


ALTER TABLE public.register_of_record OWNER TO class4_user;

--
-- Name: register_of_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.register_of_record_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.register_of_record_id_seq OWNER TO class4_user;

--
-- Name: register_of_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.register_of_record_id_seq OWNED BY public.register_of_record.id;


--
-- Name: release_cause_string; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.release_cause_string (
    id integer NOT NULL,
    name character varying(64),
    err integer,
    err_string character varying(64)
);


ALTER TABLE public.release_cause_string OWNER TO class4_user;

--
-- Name: release_cause_string_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.release_cause_string_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.release_cause_string_id_seq OWNER TO class4_user;

--
-- Name: release_cause_string_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.release_cause_string_id_seq OWNED BY public.release_cause_string.id;


--
-- Name: report_template; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.report_template (
    id integer NOT NULL,
    created_by character varying(40),
    created_on timestamp with time zone DEFAULT now(),
    template_name character varying(100),
    period smallint DEFAULT '0'::smallint,
    params json
);


ALTER TABLE public.report_template OWNER TO class4_user;

--
-- Name: report_template_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.report_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.report_template_id_seq OWNER TO class4_user;

--
-- Name: report_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.report_template_id_seq OWNED BY public.report_template.id;


--
-- Name: rerate_cdr_download_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rerate_cdr_download_log (
    id integer NOT NULL,
    task_id integer,
    create_by character varying(100),
    create_on timestamp with time zone,
    download_file character varying(200),
    finished_time timestamp with time zone,
    status integer DEFAULT 0
);


ALTER TABLE public.rerate_cdr_download_log OWNER TO class4_user;

--
-- Name: rerate_cdr_download_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rerate_cdr_download_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rerate_cdr_download_log_id_seq OWNER TO class4_user;

--
-- Name: rerate_cdr_download_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rerate_cdr_download_log_id_seq OWNED BY public.rerate_cdr_download_log.id;


--
-- Name: rerate_cdr_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rerate_cdr_task (
    id integer NOT NULL,
    from_time bigint,
    to_time bigint,
    timezone integer DEFAULT 0 NOT NULL,
    update_lrn smallint DEFAULT 0 NOT NULL,
    update_us_jurisdiction smallint DEFAULT 0 NOT NULL,
    ingress_trunk character varying(1024),
    egress_trunk character varying(1024),
    lrn_server_ip character varying(16),
    lrn_server_port integer DEFAULT 5060 NOT NULL,
    cdr_file character varying(4096),
    err_code integer DEFAULT 0 NOT NULL,
    include_q850 smallint DEFAULT 0 NOT NULL,
    progress character varying(200),
    status smallint DEFAULT 0 NOT NULL,
    load_cdr_elapsed_sec integer DEFAULT 0 NOT NULL,
    load_rate_elapsed_sec integer DEFAULT 0 NOT NULL,
    rerate_elapsed_sec integer DEFAULT 0 NOT NULL,
    create_time bigint DEFAULT date_part('epoch'::text, ('now'::text)::timestamp(0) with time zone),
    start_time bigint,
    end_time bigint,
    cdr_file_path character varying(100),
    download_file character varying(200),
    client_ids character varying(1024),
    update_local_rate smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.rerate_cdr_task OWNER TO class4_user;

--
-- Name: COLUMN rerate_cdr_task.from_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rerate_cdr_task.from_time IS 'rerate cdr start time';


--
-- Name: COLUMN rerate_cdr_task.to_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rerate_cdr_task.to_time IS 'rerate cdr end time';


--
-- Name: COLUMN rerate_cdr_task.ingress_trunk; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rerate_cdr_task.ingress_trunk IS 'ingress trunk info, format: trunk_id,update_rate,rate_table_id,rate_effective_date;trunk_id_1,...';


--
-- Name: COLUMN rerate_cdr_task.egress_trunk; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rerate_cdr_task.egress_trunk IS 'egress trunk info, format: trunk_id,update_rate,rate_table_id,rate_effective_date;trunk_id_1,...  (update_rate: 0 for No, 1 for Yes; rate_effective_date:a specified date or 0(same as CDR time) )';


--
-- Name: COLUMN rerate_cdr_task.include_q850; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rerate_cdr_task.include_q850 IS 'Rerate CDR MUST include Q.850 column, 0 for none; 1 for include';


--
-- Name: COLUMN rerate_cdr_task.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rerate_cdr_task.status IS '0 for initial; 1 for download cdr; 2 for load rate, 3 for rerate cdr; 4 for finished; 5 for error';


--
-- Name: rerate_cdr_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rerate_cdr_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rerate_cdr_task_id_seq OWNER TO class4_user;

--
-- Name: rerate_cdr_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rerate_cdr_task_id_seq OWNED BY public.rerate_cdr_task.id;


--
-- Name: rerate_report_exec_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rerate_report_exec_log (
    id integer NOT NULL,
    start_time timestamp with time zone,
    finish_time timestamp with time zone,
    create_by character varying(100),
    status integer,
    exec_type integer,
    task_id integer,
    total_files_count integer,
    success_files_count integer,
    create_on timestamp with time zone
);


ALTER TABLE public.rerate_report_exec_log OWNER TO class4_user;

--
-- Name: COLUMN rerate_report_exec_log.exec_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.rerate_report_exec_log.exec_type IS '1:report;2:balance';


--
-- Name: rerate_report_exec_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rerate_report_exec_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rerate_report_exec_log_id_seq OWNER TO class4_user;

--
-- Name: rerate_report_exec_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rerate_report_exec_log_id_seq OWNED BY public.rerate_report_exec_log.id;


--
-- Name: resource; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource (
    resource_id integer NOT NULL,
    name character varying(100),
    ingress boolean,
    egress boolean,
    active boolean DEFAULT true NOT NULL,
    rfc_2833 boolean DEFAULT false NOT NULL,
    t38 boolean DEFAULT false NOT NULL,
    alias character varying(100) DEFAULT NULL::character varying NOT NULL,
    res_strategy smallint,
    cps_limit integer,
    capacity integer,
    lnp boolean DEFAULT false NOT NULL,
    lrn_block boolean DEFAULT false NOT NULL,
    client_id integer,
    tdm boolean DEFAULT true NOT NULL,
    rate_table_id integer,
    transnexus integer,
    route_strategy_id integer,
    media_type integer DEFAULT 2 NOT NULL,
    pass_through integer,
    profit_margin double precision DEFAULT 0 NOT NULL,
    enough_balance boolean DEFAULT false,
    egress_bill_after_action boolean DEFAULT true,
    proto integer DEFAULT 1,
    dnis_only boolean DEFAULT true NOT NULL,
    ring_timeout integer DEFAULT 60 NOT NULL,
    ignore_ring boolean DEFAULT false,
    ignore_early_media boolean DEFAULT false,
    disable_by_alert boolean DEFAULT false,
    priority integer DEFAULT 0,
    last_priority integer DEFAULT 0,
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    update_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    status integer DEFAULT 1,
    wait_ringtime180 integer DEFAULT 60000,
    profit_type integer DEFAULT 1 NOT NULL,
    lnp_dipping boolean DEFAULT false,
    lnp_dipping_rate real,
    update_at timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    update_by character varying,
    cli_type integer,
    auth_type integer DEFAULT 0,
    delay_bye_second integer,
    delay_bye_limit integer,
    max_duration integer,
    marketplace integer DEFAULT 0,
    rating_type integer DEFAULT 0,
    billing_type integer DEFAULT 0,
    trunk_type integer,
    switch_profile_id integer,
    transaction_fee_id integer,
    service_type integer DEFAULT 0 NOT NULL,
    product_id integer,
    rpid smallint,
    paid smallint,
    oli smallint,
    pci smallint,
    priv smallint,
    div smallint,
    trunk_type2 smallint DEFAULT 0 NOT NULL,
    account_id character(32),
    billing_method smallint,
    amount_per_port numeric,
    billing_rule integer,
    ignore_early_nosdp integer,
    media_timeout integer,
    private integer DEFAULT 0 NOT NULL,
    agent_type integer,
    bill_by integer DEFAULT 4,
    us_route integer DEFAULT 0,
    intl_route integer DEFAULT 0,
    canada_route integer DEFAULT 0,
    rate_decimal integer DEFAULT 6,
    rate_rounding integer DEFAULT 0,
    us_other integer DEFAULT 0,
    canada_other integer DEFAULT 0,
    redirect integer DEFAULT 0,
    lrn_prefix integer DEFAULT 1 NOT NULL,
    pass_response_code integer DEFAULT 0,
    is_del integer DEFAULT 0,
    dtmf_type integer DEFAULT 3,
    dtmf_detect integer DEFAULT 0,
    rpid_screen integer DEFAULT 0,
    rpid_party integer DEFAULT 0,
    display_name integer,
    rpid_id_type integer DEFAULT 0,
    rpid_privacy integer DEFAULT 0,
    counter_time integer,
    number integer,
    block_time integer,
    re_invite integer,
    re_invite_interval integer,
    info integer,
    rfc2833 integer,
    inband integer,
    dummy_trunk boolean,
    random_table_id integer,
    is_virtual boolean,
    rfc_r833_payload integer,
    resource_template_id integer,
    rate_use_rpid boolean DEFAULT false,
    group_id integer,
    resource_block_group_id integer,
    enfource_cid boolean,
    ani_cps_limit integer,
    ani_cap_limit integer,
    dnis_cps_limit integer,
    dnis_cap_limit integer,
    jurisdiction_use_dnis boolean DEFAULT false,
    price_per_max_channel double precision,
    rate_profile integer,
    priv_value integer DEFAULT 0,
    billing_port_type integer,
    cost_per_port numeric,
    price_per_actual_channel double precision,
    old_detail_table json,
    max_failover_route_count integer,
    shaken_allow_resign boolean DEFAULT false NOT NULL,
    shaken_sign_policy smallint DEFAULT '0'::smallint NOT NULL,
    shaken_vfy_policy smallint DEFAULT '0'::smallint,
    shaken_ani_group_list_id integer,
    shaken_default_attest_lvl character varying(1) DEFAULT 'A'::character varying NOT NULL,
    block_dnc boolean DEFAULT false NOT NULL,
    block_wireless boolean DEFAULT false NOT NULL,
    purged boolean DEFAULT false NOT NULL,
    ym_fraud_prob real,
    ym_spam_score real,
    ym_tcpa_prob real,
    shaken_p_headers integer DEFAULT 0,
    vfy_policy smallint DEFAULT '0'::smallint NOT NULL,
    ani_country_whitelist character varying,
    block_toll_free_ani boolean,
    block_wireless_ani boolean,
    invalid_ani_action integer,
    block_dno character(15),
    paid_privacy integer DEFAULT 0,
    shaken_force_validation boolean,
    ftc_days integer,
    ani_type_block text,
    dnis_type_block text,
    shaken_sign_tollfree boolean,
    shaken_vfy_us_ca_only boolean,
    paid_uri text,
    paid_display text,
    pani smallint,
    pani_value text,
    shaken_vfy_countries text,
    reject_no_pani boolean,
    shaken_sti_sp_id bigint,
    shaken_vfy_min_attest_lvl character varying(1),
    block_404_days integer,
    CONSTRAINT resource_shaken_default_attest_lvl_check CHECK ((((shaken_default_attest_lvl)::text = 'A'::text) OR ((shaken_default_attest_lvl)::text = 'B'::text) OR ((shaken_default_attest_lvl)::text = 'C'::text)))
);


ALTER TABLE public.resource OWNER TO class4_user;

--
-- Name: TABLE resource; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.resource IS '网关组';


--
-- Name: COLUMN resource.name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.name IS '名字';


--
-- Name: COLUMN resource.ingress; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.ingress IS '对接网关';


--
-- Name: COLUMN resource.egress; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.egress IS '落地网关';


--
-- Name: COLUMN resource.active; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.active IS '启用／禁用';


--
-- Name: COLUMN resource.rfc_2833; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.rfc_2833 IS 'rfc_2833';


--
-- Name: COLUMN resource.t38; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.t38 IS 't38';


--
-- Name: COLUMN resource.alias; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.alias IS '别名resourceID';


--
-- Name: COLUMN resource.res_strategy; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.res_strategy IS '落地网关选择策略:1－－top-down,2－－round-robin';


--
-- Name: COLUMN resource.cps_limit; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.cps_limit IS '容许每秒呼叫数';


--
-- Name: COLUMN resource.capacity; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.capacity IS '容许在线呼叫数';


--
-- Name: COLUMN resource.lnp; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.lnp IS 'lrn';


--
-- Name: COLUMN resource.lrn_block; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.lrn_block IS 'lrn block';


--
-- Name: COLUMN resource.client_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.client_id IS '批发商';


--
-- Name: COLUMN resource.tdm; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.tdm IS 'TDM';


--
-- Name: COLUMN resource.rate_table_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.rate_table_id IS '费率模板';


--
-- Name: COLUMN resource.transnexus; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.transnexus IS 'transnexus';


--
-- Name: COLUMN resource.route_strategy_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.route_strategy_id IS '路由策略';


--
-- Name: COLUMN resource.media_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.media_type IS '0－－Proxy Media + Transcoding;1－－Proxy Media ;2－－Bypass Media';


--
-- Name: COLUMN resource.pass_through; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.pass_through IS '号码透传规则:1--透传;2--不透传;3--不透传禁显 ';


--
-- Name: COLUMN resource.profit_margin; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.profit_margin IS '最低利润率';


--
-- Name: COLUMN resource.enough_balance; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.enough_balance IS '是否余额不足';


--
-- Name: COLUMN resource.proto; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.proto IS '1--sip;2--h323;0--all';


--
-- Name: COLUMN resource.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.status IS '1--untested;2--tested;3--failed';


--
-- Name: COLUMN resource.profit_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.profit_type IS '1--百分比;2--数值';


--
-- Name: COLUMN resource.cli_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.cli_type IS '0-white;1-white non cli;2-grey';


--
-- Name: COLUMN resource.auth_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.auth_type IS '权限字段:0 - ALL;1 - resource_auth;';


--
-- Name: COLUMN resource.marketplace; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.marketplace IS '0:International A-Z;1:US Domestic';


--
-- Name: COLUMN resource.rating_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.rating_type IS '0:US JD;1:US Non-JD;2:OCN-LATA JD;3:OCN-LATA Non-JD';


--
-- Name: COLUMN resource.billing_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.billing_type IS '0:DNIS;1:LRN;2:LRN Block All;3:LRN Block Higher Rate Codes Only';


--
-- Name: COLUMN resource.trunk_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.trunk_type IS '1-class4;2-exchange;3-product_default;4-product_agent';


--
-- Name: COLUMN resource.service_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.service_type IS '0:Self  Service;1:Standand Deck';


--
-- Name: COLUMN resource.rpid; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.rpid IS 'Remote-Party-ID: egress:0 - false 不信任;1 - true 信任; ingress:0 - NEVER 不写;1 - PASS_THROUGH 透穿;2 - ALWAYS 新建';


--
-- Name: COLUMN resource.paid; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.paid IS 'P-Asserted-Identity: egress:0 - false 不信任;1 - true 信任 ingress:0 - NEVER 不写;1 - PASS_THROUGH 透穿;2 - ALWAYS 新建';


--
-- Name: COLUMN resource.oli; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.oli IS 'egress:0 - false 不信任;1 - true 信任 ingress:0 - NEVER 不写;1 - PASS_THROUGH 透穿;2 - ALWAYS 新建';


--
-- Name: COLUMN resource.pci; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.pci IS '0 - Drop; 1 - Pass Through; 2 - Always';


--
-- Name: COLUMN resource.priv; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.priv IS 'Privacy: egress:0 - false 不信任;1 - true 信任 ingress:0 - NEVER 不写;1 - PASS_THROUGH 透穿;2 - ALWAYS 新建';


--
-- Name: COLUMN resource.div; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.div IS 'Diversion: egress:0 - false 不信任;1 - true 信任;ingress:0 - NEVER 不写;1 - PASS_THROUGH 透穿;2 - ALWAYS 新建';


--
-- Name: COLUMN resource.billing_method; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.billing_method IS '0 - by minutes;1- by port';


--
-- Name: COLUMN resource.amount_per_port; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.amount_per_port IS 'money per port';


--
-- Name: COLUMN resource.agent_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.agent_type IS '1-exchange;2-default agent;3-client agent';


--
-- Name: COLUMN resource.bill_by; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.bill_by IS '0 -- DNIS，DNIS计费，不需要查询LRN
1 -- LRN，LRN计费，忽略运营商变化
2 -- LRN Block，LRN计费号码运营商有改变，则拒绝
3 -- LRN Block Higher Rate，LRN费率高于DNIS费率
4 -- Follow Rate Deck，使用费率表的以上配置';


--
-- Name: COLUMN resource.us_route; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.us_route IS '0 --- other;1 --- intra;2 --- inter;3 --- highest';


--
-- Name: COLUMN resource.intl_route; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.intl_route IS '0 --- other;1 --- intra;2 --- inter;3 --- highest';


--
-- Name: COLUMN resource.canada_route; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.canada_route IS '0 --- other;1 --- intra;2 --- inter;3 --- highest';


--
-- Name: COLUMN resource.rate_decimal; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.rate_decimal IS '决定费率的小数位取多少位。';


--
-- Name: COLUMN resource.rate_rounding; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.rate_rounding IS '费率小数位方法：0 --- 舍入;1 --- 舍弃';


--
-- Name: COLUMN resource.us_other; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.us_other IS '0 --- other;1 --- intra;2 --- inter;3 --- highest';


--
-- Name: COLUMN resource.canada_other; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.canada_other IS '0 --- other;1 --- intra;2 --- inter;3 --- highest';


--
-- Name: COLUMN resource.redirect; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.redirect IS '0 --- false;1 --- true';


--
-- Name: COLUMN resource.lrn_prefix; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.lrn_prefix IS '0 --- false;1 --- true (default)';


--
-- Name: COLUMN resource.pass_response_code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.pass_response_code IS '0 -- false, 1 -- true, 如果此选项设置true, 则从egress返回过来的最后一个sip错误码返回给ingress';


--
-- Name: COLUMN resource.is_del; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.is_del IS '0: not del;1: is del';


--
-- Name: COLUMN resource.dtmf_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.dtmf_type IS '0 -- 所有;1 -- info;2 -- rfc2833;3 -- inband';


--
-- Name: COLUMN resource.dtmf_detect; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.dtmf_detect IS '0 -- 自动检测，media_type = transcode; 1 -- 预定检测，media_type = transcode并且主被叫dtmf不同并且有相同语音编码';


--
-- Name: COLUMN resource.rpid_screen; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.rpid_screen IS '0 -- none 不带screen;1 -- no;2 -- yes;3 -- proxy 使用主叫RPID screen';


--
-- Name: COLUMN resource.rpid_party; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.rpid_party IS '0 --- none 呼出不带party;1 --- calling;2 --- called;3 --- proxy 使用主叫RPID party';


--
-- Name: COLUMN resource.display_name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.display_name IS '0 --- false;1 --- true;呼出时是否透传主叫的显示名字';


--
-- Name: COLUMN resource.rpid_id_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.rpid_id_type IS '0 --- none 呼出不带id_type:1 --- subscriber;2 --- user;3 --- term;4 --- proxy 使用主叫RPID id_type';


--
-- Name: COLUMN resource.rpid_privacy; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.rpid_privacy IS '0 --- none 呼出不带privacy:1 --- full;2 --- name;3 --- url;4 --- off;5 --- ipaddr;6 --- proxy 使用主叫RPID privacy';


--
-- Name: COLUMN resource.counter_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.counter_time IS 'loop detection使用，单位秒,这个时间段内收到多少个主被叫一样的呼叫，则block';


--
-- Name: COLUMN resource.number; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.number IS 'loop detection使用，表示数量,某个时间段内收到这个数字的主被叫一样的呼叫，则block';


--
-- Name: COLUMN resource.block_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.block_time IS 'loop detection使用，单位秒.满足block的条件后block多长时间';


--
-- Name: COLUMN resource.re_invite; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.re_invite IS '0 -- false;1 -- true;发送re-INVITE检测对方是否活跃';


--
-- Name: COLUMN resource.re_invite_interval; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.re_invite_interval IS '秒单位，建议不小于60秒';


--
-- Name: COLUMN resource.info; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.info IS '0 Does Not Support/Does Not Require;1 Support/Require';


--
-- Name: COLUMN resource.rfc2833; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.rfc2833 IS '0 Does Not Support/Does Not Require;1 Support/Require';


--
-- Name: COLUMN resource.inband; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.inband IS '0 Does Not Support/Does Not Require;1 Support/Require';


--
-- Name: COLUMN resource.dummy_trunk; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.dummy_trunk IS '是否为origination client中的failover的trunk';


--
-- Name: COLUMN resource.shaken_allow_resign; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.shaken_allow_resign IS '
Allow signing a new Identity header if original one does not match outgoing source/destination';


--
-- Name: COLUMN resource.shaken_sign_policy; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.shaken_sign_policy IS '
0 - Do not sign calls;
1 - Sign only US numbers;
2 - Sign any phone number;
3 - Sign only numbers from the SHAKEN ANI group.';


--
-- Name: COLUMN resource.shaken_vfy_policy; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.shaken_vfy_policy IS '
0 - Do not check identity;
1 - Block if no identity;
2 - Block if identity is not valid or missing;
3 - Verify identity, but bypass if invalid.';


--
-- Name: COLUMN resource.shaken_ani_group_list_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.shaken_ani_group_list_id IS 'SHAKEN ANI pool configuration';


--
-- Name: COLUMN resource.shaken_default_attest_lvl; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.shaken_default_attest_lvl IS 'Default SHAKEN attestation level (for numbers outside of ANI pools)';


--
-- Name: COLUMN resource.block_dnc; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.block_dnc IS 'Block call if DNIS is in Do Not Call list';


--
-- Name: COLUMN resource.block_wireless; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.block_wireless IS 'Block call if DNIS is Wireless';


--
-- Name: COLUMN resource.shaken_sign_tollfree; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.shaken_sign_tollfree IS 'Sign toll-free numbers';


--
-- Name: COLUMN resource.shaken_vfy_us_ca_only; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.shaken_vfy_us_ca_only IS 'DEPRECATED';


--
-- Name: COLUMN resource.pani; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.pani IS '0 - Drop; 1 - Pass Through; 2 - Always (use text from resource.pani_value)';


--
-- Name: COLUMN resource.shaken_vfy_countries; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.shaken_vfy_countries IS 'Comma-separated list of countries';


--
-- Name: COLUMN resource.reject_no_pani; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.reject_no_pani IS 'Reject calls without P-Access-Network-Info header';


--
-- Name: COLUMN resource.shaken_sti_sp_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.shaken_sti_sp_id IS 'STI SP key to use for signing calls';


--
-- Name: COLUMN resource.shaken_vfy_min_attest_lvl; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.shaken_vfy_min_attest_lvl IS 'Require min attestation level for STIR/SHAKEN signatures: A, B, C';


--
-- Name: COLUMN resource.block_404_days; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource.block_404_days IS 'Block SIP404 DNIS (allowed values 7, 14 days)';


--
-- Name: resource_block; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_block (
    ingress_res_id integer,
    engress_res_id integer,
    digit public.prefix_range DEFAULT ''::public.prefix_range,
    res_block_id integer NOT NULL,
    time_profile_id integer,
    ingress_client_id integer,
    egress_client_id integer,
    disable_by_alert boolean DEFAULT false,
    ani_prefix public.prefix_range,
    ani_length integer,
    dnis_length integer,
    ani_method integer,
    dnis_method integer,
    ani_empty boolean DEFAULT false,
    action_type integer DEFAULT 0,
    block_log_id integer,
    loop_block_id integer,
    ticket_log_id integer,
    code_name character varying,
    country character varying,
    create_by character varying,
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    update_by character varying,
    dialer_detection_id integer,
    ani_max_length integer DEFAULT 32,
    dnis_max_length integer DEFAULT 32,
    ingress_group_id integer,
    egress_group_id integer,
    full_match integer DEFAULT 0,
    unblock_at numeric,
    block_at numeric,
    unblock_after numeric,
    block_type smallint,
    dnis_block_type smallint
);


ALTER TABLE public.resource_block OWNER TO class4_user;

--
-- Name: TABLE resource_block; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.resource_block IS '拒绝号码管理';


--
-- Name: COLUMN resource_block.ingress_res_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_block.ingress_res_id IS '接入网关';


--
-- Name: COLUMN resource_block.engress_res_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_block.engress_res_id IS '落地网关';


--
-- Name: COLUMN resource_block.digit; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_block.digit IS '匹配的前缀';


--
-- Name: COLUMN resource_block.res_block_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_block.res_block_id IS '主键';


--
-- Name: COLUMN resource_block.time_profile_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_block.time_profile_id IS '时间段';


--
-- Name: COLUMN resource_block.ani_method; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_block.ani_method IS '0:<;1:=;2:>';


--
-- Name: COLUMN resource_block.dnis_method; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_block.dnis_method IS '0:<;1:=;2:>';


--
-- Name: COLUMN resource_block.action_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_block.action_type IS '0 - manual;1 - automatic';


--
-- Name: COLUMN resource_block.ani_max_length; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_block.ani_max_length IS '跟ani_prefix, ani_length（最小长度）一起使用，开合。';


--
-- Name: COLUMN resource_block.dnis_max_length; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_block.dnis_max_length IS '跟digit, dnis_length（最小长度）一起使用，开合。';


--
-- Name: resource_block_items; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_block_items (
    id integer NOT NULL,
    resource_id integer,
    block_resource_id integer,
    active smallint DEFAULT 1
);


ALTER TABLE public.resource_block_items OWNER TO class4_user;

--
-- Name: TABLE resource_block_items; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.resource_block_items IS '只有ingress时有效，一个ingress可以设置多个不能去的egress';


--
-- Name: COLUMN resource_block_items.resource_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_block_items.resource_id IS 'ingress id';


--
-- Name: COLUMN resource_block_items.block_resource_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_block_items.block_resource_id IS '被过滤的resource_id，也就是egress_id';


--
-- Name: COLUMN resource_block_items.active; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_block_items.active IS '0 -- false, 1 -- true';


--
-- Name: resource_block_items_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_block_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_block_items_id_seq OWNER TO class4_user;

--
-- Name: resource_block_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_block_items_id_seq OWNED BY public.resource_block_items.id;


--
-- Name: resource_block_items_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_block_items_record (
    id integer NOT NULL,
    resource_id integer,
    block_resource_id integer,
    active smallint,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.resource_block_items_record OWNER TO class4_user;

--
-- Name: resource_block_items_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_block_items_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_block_items_record_record_id_seq OWNER TO class4_user;

--
-- Name: resource_block_items_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_block_items_record_record_id_seq OWNED BY public.resource_block_items_record.record_id;


--
-- Name: resource_block_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_block_record (
    ingress_res_id integer,
    engress_res_id integer,
    digit public.prefix_range,
    res_block_id integer NOT NULL,
    time_profile_id integer,
    ingress_client_id integer,
    egress_client_id integer,
    disable_by_alert boolean,
    ani_prefix public.prefix_range,
    ani_length integer,
    dnis_length integer,
    ani_method integer,
    dnis_method integer,
    ani_empty boolean,
    action_type integer,
    block_log_id integer,
    loop_block_id integer,
    ticket_log_id integer,
    code_name character varying,
    country character varying,
    create_by character varying,
    create_time timestamp with time zone,
    update_by character varying,
    dialer_detection_id integer,
    ani_max_length integer,
    dnis_max_length integer,
    ingress_group_id integer,
    egress_group_id integer,
    full_match integer,
    unblock_at numeric,
    block_at numeric,
    unblock_after numeric,
    block_type smallint,
    dnis_block_type smallint,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.resource_block_record OWNER TO class4_user;

--
-- Name: resource_block_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_block_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_block_record_record_id_seq OWNER TO class4_user;

--
-- Name: resource_block_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_block_record_record_id_seq OWNED BY public.resource_block_record.record_id;


--
-- Name: resource_block_res_block_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_block_res_block_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_block_res_block_id_seq OWNER TO class4_user;

--
-- Name: resource_block_res_block_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_block_res_block_id_seq OWNED BY public.resource_block.res_block_id;


--
-- Name: resource_capacity; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_capacity (
    egress_id integer,
    ingress_id integer,
    max_cps integer,
    max_cap integer
);


ALTER TABLE public.resource_capacity OWNER TO class4_user;

--
-- Name: resource_capacity_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_capacity_record (
    egress_id integer,
    ingress_id integer,
    max_cps integer,
    max_cap integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.resource_capacity_record OWNER TO class4_user;

--
-- Name: resource_capacity_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_capacity_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_capacity_record_record_id_seq OWNER TO class4_user;

--
-- Name: resource_capacity_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_capacity_record_record_id_seq OWNED BY public.resource_capacity_record.record_id;


--
-- Name: resource_cid_block_config; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_cid_block_config (
    resource_id integer NOT NULL,
    min_asr integer,
    min_acd integer,
    max_sdp integer,
    max_cpm integer
);


ALTER TABLE public.resource_cid_block_config OWNER TO class4_user;

--
-- Name: resource_cid_block_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_cid_block_log (
    id integer NOT NULL,
    "time" timestamp with time zone DEFAULT now(),
    result text,
    data json,
    resource_id integer
);


ALTER TABLE public.resource_cid_block_log OWNER TO class4_user;

--
-- Name: resource_cid_block_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_cid_block_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_cid_block_log_id_seq OWNER TO class4_user;

--
-- Name: resource_cid_block_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_cid_block_log_id_seq OWNED BY public.resource_cid_block_log.id;


--
-- Name: resource_codecs_ref; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_codecs_ref (
    id integer NOT NULL,
    resource_id integer NOT NULL,
    codec_id integer
);


ALTER TABLE public.resource_codecs_ref OWNER TO class4_user;

--
-- Name: COLUMN resource_codecs_ref.resource_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_codecs_ref.resource_id IS '网关组';


--
-- Name: resource_codecs_ref_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_codecs_ref_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_codecs_ref_id_seq OWNER TO class4_user;

--
-- Name: resource_codecs_ref_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_codecs_ref_id_seq OWNED BY public.resource_codecs_ref.id;


--
-- Name: resource_codecs_ref_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_codecs_ref_record (
    id integer NOT NULL,
    resource_id integer NOT NULL,
    codec_id integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.resource_codecs_ref_record OWNER TO class4_user;

--
-- Name: resource_codecs_ref_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_codecs_ref_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_codecs_ref_record_record_id_seq OWNER TO class4_user;

--
-- Name: resource_codecs_ref_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_codecs_ref_record_record_id_seq OWNED BY public.resource_codecs_ref_record.record_id;


--
-- Name: resource_direction; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_direction (
    direction smallint NOT NULL,
    action smallint NOT NULL,
    digits character varying(16) NOT NULL,
    direction_id integer NOT NULL,
    dnis public.prefix_range DEFAULT ''::public.prefix_range,
    resource_id integer NOT NULL,
    time_profile_id integer,
    type integer NOT NULL,
    number_length integer,
    number_type integer
);


ALTER TABLE public.resource_direction OWNER TO class4_user;

--
-- Name: TABLE resource_direction; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.resource_direction IS 'action(号码转换)';


--
-- Name: COLUMN resource_direction.direction; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_direction.direction IS '0－－ALL;1－－打进  ingress;2－－打出egress';


--
-- Name: COLUMN resource_direction.action; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_direction.action IS '1－－加前缀;2－－加后缀;3－－减前缀;4－－减后缀';


--
-- Name: COLUMN resource_direction.digits; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_direction.digits IS '要添加的字符或删除的位数';


--
-- Name: COLUMN resource_direction.dnis; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_direction.dnis IS '主叫或者被叫前缀';


--
-- Name: COLUMN resource_direction.resource_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_direction.resource_id IS '网关组';


--
-- Name: COLUMN resource_direction.time_profile_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_direction.time_profile_id IS '时间段';


--
-- Name: COLUMN resource_direction.type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_direction.type IS '0－－修改主叫;1－－修改被叫';


--
-- Name: COLUMN resource_direction.number_length; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_direction.number_length IS '号码的长度';


--
-- Name: COLUMN resource_direction.number_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_direction.number_type IS '0－－所有;1－－大于;2－－等于;3－－小于';


--
-- Name: resource_direction_direction_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_direction_direction_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_direction_direction_id_seq OWNER TO class4_user;

--
-- Name: resource_direction_direction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_direction_direction_id_seq OWNED BY public.resource_direction.direction_id;


--
-- Name: resource_direction_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_direction_record (
    direction smallint NOT NULL,
    action smallint NOT NULL,
    digits character varying(16) NOT NULL,
    direction_id integer NOT NULL,
    dnis public.prefix_range,
    resource_id integer NOT NULL,
    time_profile_id integer,
    type integer NOT NULL,
    number_length integer,
    number_type integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.resource_direction_record OWNER TO class4_user;

--
-- Name: resource_direction_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_direction_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_direction_record_record_id_seq OWNER TO class4_user;

--
-- Name: resource_direction_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_direction_record_record_id_seq OWNED BY public.resource_direction_record.record_id;


--
-- Name: resource_ext; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_ext (
    resource_id integer NOT NULL,
    vendor_tech_prefix public.prefix_range
);


ALTER TABLE public.resource_ext OWNER TO class4_user;

--
-- Name: resource_ext_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_ext_resource_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_ext_resource_id_seq OWNER TO class4_user;

--
-- Name: resource_ext_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_ext_resource_id_seq OWNED BY public.resource_ext.resource_id;


--
-- Name: resource_ip; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_ip (
    resource_id integer NOT NULL,
    resource_ip_id integer NOT NULL,
    ip character varying(50),
    port integer,
    fqdn character varying(100),
    sip_rpid character varying(64),
    disable_by_alert boolean DEFAULT false,
    priority integer DEFAULT 0,
    last_priority integer DEFAULT 0,
    addr_type integer DEFAULT 0,
    direction integer,
    username character varying(50),
    password character varying(50),
    reg_type smallint DEFAULT 0 NOT NULL,
    reg_status smallint DEFAULT 0 NOT NULL,
    reg_srv_ip character varying(100),
    reg_srv_port integer DEFAULT 5060 NOT NULL,
    expires integer DEFAULT 3600 NOT NULL,
    profile_id integer DEFAULT 0 NOT NULL,
    need_register boolean,
    options_ping_inv integer
);


ALTER TABLE public.resource_ip OWNER TO class4_user;

--
-- Name: TABLE resource_ip; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.resource_ip IS '网关';


--
-- Name: COLUMN resource_ip.resource_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_ip.resource_id IS '网关组';


--
-- Name: COLUMN resource_ip.resource_ip_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_ip.resource_ip_id IS '主键';


--
-- Name: COLUMN resource_ip.ip; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_ip.ip IS 'ip地址';


--
-- Name: COLUMN resource_ip.port; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_ip.port IS '端口';


--
-- Name: COLUMN resource_ip.fqdn; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_ip.fqdn IS '域名';


--
-- Name: COLUMN resource_ip.sip_rpid; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_ip.sip_rpid IS 'opensips';


--
-- Name: COLUMN resource_ip.direction; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_ip.direction IS '标注此ip是incoming还是outgoing:0 -- incoming;1 -- outgoing';


--
-- Name: COLUMN resource_ip.reg_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_ip.reg_type IS 'register user type, 0 for none; 1 for register user; 2 for register gateway account';


--
-- Name: COLUMN resource_ip.reg_status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_ip.reg_status IS '0 for un-register; 1 for registered; 2 for register failed';


--
-- Name: COLUMN resource_ip.need_register; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_ip.need_register IS '0:Authorized by IP Only;1:Authorized by SIP Registration';


--
-- Name: resource_ip_limit; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_ip_limit (
    limit_id integer NOT NULL,
    ip_id integer NOT NULL,
    cps integer,
    capacity integer,
    time_profile_id integer
);


ALTER TABLE public.resource_ip_limit OWNER TO class4_user;

--
-- Name: TABLE resource_ip_limit; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.resource_ip_limit IS '不同时间段，不同的limit值';


--
-- Name: COLUMN resource_ip_limit.ip_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_ip_limit.ip_id IS 'ip地址－－外键';


--
-- Name: COLUMN resource_ip_limit.cps; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_ip_limit.cps IS '每秒呼叫数';


--
-- Name: COLUMN resource_ip_limit.capacity; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_ip_limit.capacity IS '同时在线通话数';


--
-- Name: COLUMN resource_ip_limit.time_profile_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_ip_limit.time_profile_id IS '时间段－－外键';


--
-- Name: resource_ip_limit_limit_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_ip_limit_limit_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_ip_limit_limit_id_seq OWNER TO class4_user;

--
-- Name: resource_ip_limit_limit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_ip_limit_limit_id_seq OWNED BY public.resource_ip_limit.limit_id;


--
-- Name: resource_ip_limit_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_ip_limit_record (
    limit_id integer NOT NULL,
    ip_id integer NOT NULL,
    cps integer,
    capacity integer,
    time_profile_id integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.resource_ip_limit_record OWNER TO class4_user;

--
-- Name: resource_ip_limit_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_ip_limit_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_ip_limit_record_record_id_seq OWNER TO class4_user;

--
-- Name: resource_ip_limit_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_ip_limit_record_record_id_seq OWNED BY public.resource_ip_limit_record.record_id;


--
-- Name: resource_ip_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_ip_record (
    resource_id integer NOT NULL,
    resource_ip_id integer NOT NULL,
    ip character varying(50),
    port integer,
    fqdn character varying(100),
    sip_rpid character varying(64),
    disable_by_alert boolean,
    priority integer,
    last_priority integer,
    addr_type integer,
    direction integer,
    username character varying(50),
    password character varying(50),
    reg_type smallint NOT NULL,
    reg_status smallint NOT NULL,
    reg_srv_ip character varying(100),
    reg_srv_port integer NOT NULL,
    expires integer NOT NULL,
    profile_id integer NOT NULL,
    need_register boolean,
    options_ping_inv integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.resource_ip_record OWNER TO class4_user;

--
-- Name: resource_ip_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_ip_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_ip_record_record_id_seq OWNER TO class4_user;

--
-- Name: resource_ip_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_ip_record_record_id_seq OWNED BY public.resource_ip_record.record_id;


--
-- Name: resource_ip_resource_ip_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_ip_resource_ip_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_ip_resource_ip_id_seq OWNER TO class4_user;

--
-- Name: resource_ip_resource_ip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_ip_resource_ip_id_seq OWNED BY public.resource_ip.resource_ip_id;


--
-- Name: resource_lrn_action; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_lrn_action (
    id integer NOT NULL,
    direction smallint NOT NULL,
    action smallint NOT NULL,
    digits character varying(10) NOT NULL,
    dnis public.prefix_range DEFAULT ''::public.prefix_range,
    resource_id integer NOT NULL
);


ALTER TABLE public.resource_lrn_action OWNER TO class4_user;

--
-- Name: COLUMN resource_lrn_action.direction; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_lrn_action.direction IS '1－lrn之前;2－lrn之后';


--
-- Name: COLUMN resource_lrn_action.action; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_lrn_action.action IS '1－－加前缀;2－－加后缀;3－－减前缀;4－－减后缀';


--
-- Name: resource_lrn_action_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_lrn_action_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_lrn_action_id_seq OWNER TO class4_user;

--
-- Name: resource_lrn_action_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_lrn_action_id_seq OWNED BY public.resource_lrn_action.id;


--
-- Name: resource_lrn_action_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_lrn_action_record (
    id integer NOT NULL,
    direction smallint NOT NULL,
    action smallint NOT NULL,
    digits character varying(10) NOT NULL,
    dnis public.prefix_range,
    resource_id integer NOT NULL,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.resource_lrn_action_record OWNER TO class4_user;

--
-- Name: resource_lrn_action_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_lrn_action_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_lrn_action_record_record_id_seq OWNER TO class4_user;

--
-- Name: resource_lrn_action_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_lrn_action_record_record_id_seq OWNED BY public.resource_lrn_action_record.record_id;


--
-- Name: resource_next_route_rule; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_next_route_rule (
    id integer NOT NULL,
    route_type integer,
    reponse_code character varying(100),
    resource_id integer,
    return_code character varying(100),
    return_string character varying(100)
);


ALTER TABLE public.resource_next_route_rule OWNER TO class4_user;

--
-- Name: TABLE resource_next_route_rule; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.resource_next_route_rule IS 'next_rule';


--
-- Name: COLUMN resource_next_route_rule.route_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_next_route_rule.route_type IS '1--next host;2--next route;3--stop';


--
-- Name: COLUMN resource_next_route_rule.reponse_code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_next_route_rule.reponse_code IS '200,486,404,487';


--
-- Name: resource_next_route_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_next_route_rule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_next_route_rule_id_seq OWNER TO class4_user;

--
-- Name: resource_next_route_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_next_route_rule_id_seq OWNED BY public.resource_next_route_rule.id;


--
-- Name: resource_next_route_rule_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_next_route_rule_record (
    id integer NOT NULL,
    route_type integer,
    reponse_code character varying(100),
    resource_id integer,
    return_code character varying(100),
    return_string character varying(100),
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.resource_next_route_rule_record OWNER TO class4_user;

--
-- Name: resource_next_route_rule_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_next_route_rule_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_next_route_rule_record_record_id_seq OWNER TO class4_user;

--
-- Name: resource_next_route_rule_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_next_route_rule_record_record_id_seq OWNED BY public.resource_next_route_rule_record.record_id;


--
-- Name: resource_prefix; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_prefix (
    id integer NOT NULL,
    resource_id integer,
    tech_prefix public.prefix_range DEFAULT ''::public.prefix_range NOT NULL,
    route_strategy_id integer,
    rate_table_id integer,
    code public.prefix_range,
    code_cps integer,
    code_cap integer,
    product_id integer
);


ALTER TABLE public.resource_prefix OWNER TO class4_user;

--
-- Name: COLUMN resource_prefix.tech_prefix; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_prefix.tech_prefix IS '匹配号码的前缀';


--
-- Name: COLUMN resource_prefix.code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_prefix.code IS '被叫号码前缀，跟tech_prefix不一样的，不需要删除前缀，选routing_palan和rate_table的作用。同一个ingress+tech_prefix内code必须是唯一的。';


--
-- Name: COLUMN resource_prefix.code_cps; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_prefix.code_cps IS 'code为分类的cps';


--
-- Name: COLUMN resource_prefix.code_cap; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_prefix.code_cap IS 'code为分类的cap';


--
-- Name: resource_prefix_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_prefix_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_prefix_id_seq OWNER TO class4_user;

--
-- Name: resource_prefix_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_prefix_id_seq OWNED BY public.resource_prefix.id;


--
-- Name: resource_prefix_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_prefix_record (
    id integer NOT NULL,
    resource_id integer,
    tech_prefix public.prefix_range NOT NULL,
    route_strategy_id integer,
    rate_table_id integer,
    code public.prefix_range,
    code_cps integer,
    code_cap integer,
    product_id integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.resource_prefix_record OWNER TO class4_user;

--
-- Name: resource_prefix_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_prefix_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_prefix_record_record_id_seq OWNER TO class4_user;

--
-- Name: resource_prefix_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_prefix_record_record_id_seq OWNED BY public.resource_prefix_record.record_id;


--
-- Name: resource_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_record (
    resource_id integer NOT NULL,
    name character varying(100),
    ingress boolean,
    egress boolean,
    active boolean NOT NULL,
    rfc_2833 boolean NOT NULL,
    t38 boolean NOT NULL,
    alias character varying(100) NOT NULL,
    res_strategy smallint,
    cps_limit integer,
    capacity integer,
    lnp boolean NOT NULL,
    lrn_block boolean NOT NULL,
    client_id integer,
    tdm boolean NOT NULL,
    rate_table_id integer,
    transnexus integer,
    route_strategy_id integer,
    media_type integer NOT NULL,
    pass_through integer,
    profit_margin double precision NOT NULL,
    enough_balance boolean,
    egress_bill_after_action boolean,
    proto integer,
    dnis_only boolean NOT NULL,
    ring_timeout integer NOT NULL,
    ignore_ring boolean,
    ignore_early_media boolean,
    disable_by_alert boolean,
    priority integer,
    last_priority integer,
    create_time timestamp with time zone,
    update_time timestamp with time zone,
    status integer,
    wait_ringtime180 integer,
    profit_type integer NOT NULL,
    lnp_dipping boolean,
    lnp_dipping_rate real,
    update_at timestamp with time zone,
    update_by character varying,
    cli_type integer,
    auth_type integer,
    delay_bye_second integer,
    delay_bye_limit integer,
    max_duration integer,
    marketplace integer,
    rating_type integer,
    billing_type integer,
    trunk_type integer,
    switch_profile_id integer,
    transaction_fee_id integer,
    service_type integer NOT NULL,
    product_id integer,
    rpid smallint,
    paid smallint,
    oli smallint,
    pci smallint,
    priv smallint,
    div smallint,
    trunk_type2 smallint NOT NULL,
    account_id character(32),
    billing_method smallint,
    amount_per_port numeric,
    billing_rule integer,
    ignore_early_nosdp integer,
    media_timeout integer,
    private integer NOT NULL,
    agent_type integer,
    bill_by integer,
    us_route integer,
    intl_route integer,
    canada_route integer,
    rate_decimal integer,
    rate_rounding integer,
    us_other integer,
    canada_other integer,
    redirect integer,
    lrn_prefix integer NOT NULL,
    pass_response_code integer,
    is_del integer,
    dtmf_type integer,
    dtmf_detect integer,
    rpid_screen integer,
    rpid_party integer,
    display_name integer,
    rpid_id_type integer,
    rpid_privacy integer,
    counter_time integer,
    number integer,
    block_time integer,
    re_invite integer,
    re_invite_interval integer,
    info integer,
    rfc2833 integer,
    inband integer,
    dummy_trunk boolean,
    random_table_id integer,
    is_virtual boolean,
    rfc_r833_payload integer,
    resource_template_id integer,
    rate_use_rpid boolean,
    group_id integer,
    resource_block_group_id integer,
    enfource_cid boolean,
    ani_cps_limit integer,
    ani_cap_limit integer,
    dnis_cps_limit integer,
    dnis_cap_limit integer,
    jurisdiction_use_dnis boolean,
    price_per_max_channel double precision,
    rate_profile integer,
    priv_value integer,
    billing_port_type integer,
    cost_per_port numeric,
    price_per_actual_channel double precision,
    old_detail_table json,
    max_failover_route_count integer,
    shaken_allow_resign boolean NOT NULL,
    shaken_sign_policy smallint NOT NULL,
    shaken_vfy_policy smallint,
    shaken_ani_group_list_id integer,
    shaken_default_attest_lvl character varying(1) NOT NULL,
    block_dnc boolean NOT NULL,
    block_wireless boolean NOT NULL,
    purged boolean NOT NULL,
    ym_fraud_prob real,
    ym_spam_score real,
    ym_tcpa_prob real,
    shaken_p_headers integer,
    vfy_policy smallint NOT NULL,
    ani_country_whitelist character varying,
    block_toll_free_ani boolean,
    block_wireless_ani boolean,
    invalid_ani_action integer,
    block_dno character(15),
    paid_privacy integer,
    shaken_force_validation boolean,
    ftc_days integer,
    ani_type_block text,
    dnis_type_block text,
    shaken_sign_tollfree boolean,
    shaken_vfy_us_ca_only boolean,
    paid_uri text,
    paid_display text,
    pani smallint,
    pani_value text,
    shaken_vfy_countries text,
    reject_no_pani boolean,
    shaken_sti_sp_id bigint,
    shaken_vfy_min_attest_lvl character varying(1),
    block_404_days integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.resource_record OWNER TO class4_user;

--
-- Name: resource_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_record_record_id_seq OWNER TO class4_user;

--
-- Name: resource_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_record_record_id_seq OWNED BY public.resource_record.record_id;


--
-- Name: resource_replace_action; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_replace_action (
    id integer NOT NULL,
    resource_id integer,
    ani_prefix character varying(50),
    ani character varying(30),
    ani_min_length integer,
    ani_max_length integer,
    type integer,
    dnis_prefix character varying(30),
    dnis character varying(30),
    dnis_min_length integer,
    dnis_max_length integer
);


ALTER TABLE public.resource_replace_action OWNER TO class4_user;

--
-- Name: COLUMN resource_replace_action.ani_min_length; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_replace_action.ani_min_length IS '匹配的主叫号最小长度，跟最大长度并且关系，大于等于。';


--
-- Name: COLUMN resource_replace_action.ani_max_length; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_replace_action.ani_max_length IS '匹配的主叫号最大长度，跟最小长度并且关系，小于。';


--
-- Name: COLUMN resource_replace_action.type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_replace_action.type IS '0 -- ani 只替换主叫;1 -- dnis 只替换被叫;2 -- both 替换主叫和被叫';


--
-- Name: COLUMN resource_replace_action.dnis_prefix; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_replace_action.dnis_prefix IS '匹配被叫的前缀';


--
-- Name: COLUMN resource_replace_action.dnis; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_replace_action.dnis IS '匹配成功后替换的被叫号码';


--
-- Name: COLUMN resource_replace_action.dnis_min_length; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_replace_action.dnis_min_length IS '匹配的被叫号最小长度，跟最大长度并且关系，大于等于。';


--
-- Name: COLUMN resource_replace_action.dnis_max_length; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_replace_action.dnis_max_length IS '匹配的被叫号最大长度，跟最小长度并且关系，小于。';


--
-- Name: resource_replace_action_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_replace_action_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_replace_action_id_seq OWNER TO class4_user;

--
-- Name: resource_replace_action_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_replace_action_id_seq OWNED BY public.resource_replace_action.id;


--
-- Name: resource_replace_action_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_replace_action_record (
    id integer NOT NULL,
    resource_id integer,
    ani_prefix character varying(50),
    ani character varying(30),
    ani_min_length integer,
    ani_max_length integer,
    type integer,
    dnis_prefix character varying(30),
    dnis character varying(30),
    dnis_min_length integer,
    dnis_max_length integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.resource_replace_action_record OWNER TO class4_user;

--
-- Name: resource_replace_action_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_replace_action_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_replace_action_record_record_id_seq OWNER TO class4_user;

--
-- Name: resource_replace_action_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_replace_action_record_record_id_seq OWNED BY public.resource_replace_action_record.record_id;


--
-- Name: resource_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_resource_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_resource_id_seq OWNER TO class4_user;

--
-- Name: resource_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_resource_id_seq OWNED BY public.resource.resource_id;


--
-- Name: resource_template; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_template (
    name character varying(100),
    resource_template_id integer NOT NULL,
    create_by character varying(100),
    update_on timestamp with time zone,
    create_on timestamp with time zone,
    trunk_type integer,
    media_type integer,
    profit_margin double precision NOT NULL,
    profit_type integer NOT NULL,
    wait_ringtime180 integer,
    lnp_dipping_rate double precision,
    lnp_dipping boolean,
    delay_bye_second integer,
    ignore_early_media boolean,
    re_invite integer,
    re_invite_interval integer,
    media_timeout integer,
    res_strategy smallint,
    max_duration integer,
    trunk_type2 smallint NOT NULL,
    billing_rule integer,
    billing_method smallint,
    rate_table_id integer,
    random_table_id integer,
    amount_per_port numeric,
    info integer,
    rfc2833 integer,
    inband integer,
    ring_timeout integer NOT NULL,
    codecs_str character varying(200),
    paid smallint,
    oli smallint,
    pci smallint,
    priv smallint,
    div smallint,
    display_name smallint,
    rpid_screen integer,
    rpid_party integer,
    rpid_id_type integer,
    rpid_privacy integer,
    rate_rounding integer,
    rate_decimal integer,
    rate_profile integer,
    us_route integer,
    us_other integer,
    canada_route integer,
    canada_other integer,
    intl_route integer,
    ignore_early_nosdp integer,
    bill_by integer,
    ignore_ring boolean,
    hosts character varying(4096),
    direction smallint,
    t38 boolean DEFAULT false,
    rpid smallint,
    failover character varying(4096)
);


ALTER TABLE public.resource_template OWNER TO class4_user;

--
-- Name: resource_template_resource_template_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_template_resource_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_template_resource_template_id_seq OWNER TO class4_user;

--
-- Name: resource_template_resource_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_template_resource_template_id_seq OWNED BY public.resource_template.resource_template_id;


--
-- Name: resource_translation_ref; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_translation_ref (
    ref_id integer NOT NULL,
    resource_id integer,
    translation_id integer,
    time_profile_id integer
);


ALTER TABLE public.resource_translation_ref OWNER TO class4_user;

--
-- Name: TABLE resource_translation_ref; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.resource_translation_ref IS '不同时间段，不同的主被叫转换';


--
-- Name: COLUMN resource_translation_ref.resource_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_translation_ref.resource_id IS '网关组－－外键;对接网关';


--
-- Name: COLUMN resource_translation_ref.translation_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_translation_ref.translation_id IS '转换规则－－外键';


--
-- Name: COLUMN resource_translation_ref.time_profile_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.resource_translation_ref.time_profile_id IS '时间段－－外键';


--
-- Name: resource_translation_ref_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.resource_translation_ref_record (
    ref_id integer NOT NULL,
    resource_id integer,
    translation_id integer,
    time_profile_id integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.resource_translation_ref_record OWNER TO class4_user;

--
-- Name: resource_translation_ref_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_translation_ref_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_translation_ref_record_record_id_seq OWNER TO class4_user;

--
-- Name: resource_translation_ref_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_translation_ref_record_record_id_seq OWNED BY public.resource_translation_ref_record.record_id;


--
-- Name: resource_translation_ref_ref_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.resource_translation_ref_ref_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_translation_ref_ref_id_seq OWNER TO class4_user;

--
-- Name: resource_translation_ref_ref_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.resource_translation_ref_ref_id_seq OWNED BY public.resource_translation_ref.ref_id;


--
-- Name: retrieve_password_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.retrieve_password_log (
    id integer NOT NULL,
    username character varying(500),
    operation_time timestamp with time zone,
    email_addresses character varying(500),
    modify_time timestamp with time zone,
    status smallint,
    confirm_ip character varying(16),
    request_ip character varying(16)
);


ALTER TABLE public.retrieve_password_log OWNER TO class4_user;

--
-- Name: COLUMN retrieve_password_log.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.retrieve_password_log.status IS '1,failure

2,E-mail has been sent

3,Modified successfully
';


--
-- Name: retrieve_password_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.retrieve_password_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.retrieve_password_log_id_seq OWNER TO class4_user;

--
-- Name: retrieve_password_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.retrieve_password_log_id_seq OWNED BY public.retrieve_password_log.id;


--
-- Name: role; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.role (
    role_id integer NOT NULL,
    role_name character varying(100) NOT NULL,
    view_pw boolean,
    default_sysfunc_id integer,
    del_able boolean,
    edit_able boolean,
    client_id integer,
    is_carriers boolean,
    is_transaction boolean,
    is_mutual_settlements boolean,
    is_invoices boolean,
    is_payment boolean,
    is_spam_report boolean,
    is_location_report boolean,
    is_origterm boolean,
    is_summary_report boolean,
    is_usage_report boolean,
    is_qos_report boolean,
    is_disconnect_cause boolean,
    is_billing_mismatch boolean,
    is_active_call boolean,
    is_termination_report boolean,
    is_rates_analysis boolean,
    is_call_simulation boolean,
    is_ingress_trunk_simulation boolean,
    is_egress_trunk_simulation boolean,
    is_sip_capture boolean,
    is_digit_mapping boolean,
    is_trunk boolean,
    is_dynamic_routing boolean,
    is_static_route_table boolean,
    is_block_list boolean,
    is_routing_plan boolean,
    is_active_web_session boolean,
    is_payment_term boolean,
    is_jurisdiction boolean,
    is_capicity boolean,
    is_rate_table boolean,
    is_code_deck boolean,
    is_time_profile boolean,
    is_currency boolean,
    is_task_schedulers boolean,
    is_mail_template boolean,
    is_role boolean,
    is_user boolean,
    is_change_password boolean,
    is_setting boolean,
    is_import_log boolean,
    is_export_log boolean,
    is_lrn_setting boolean,
    active boolean,
    is_unpaid_bills boolean,
    is_service_charge boolean,
    is_voip_gateway boolean,
    is_trouble_shoot boolean,
    is_event boolean,
    is_ticket boolean,
    is_buy_select_country boolean,
    is_search_private_buy boolean,
    is_buy_confirm_order boolean,
    is_sell_select_country boolean,
    is_search_private_sell boolean,
    is_sell_confirm_order boolean,
    role_type integer,
    default_mod character varying(100),
    default_mod2 character varying(100),
    landing_page smallint,
    sync_backup boolean,
    sync_list boolean,
    delete_credit boolean,
    delete_invoice boolean,
    delete_payment boolean,
    modify_credit_limit boolean,
    modify_min_profit boolean,
    reset_balance boolean
);


ALTER TABLE public.role OWNER TO class4_user;

--
-- Name: role_privilege; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.role_privilege (
    role_privilege_id integer NOT NULL,
    role_id integer NOT NULL,
    system_function_id integer NOT NULL,
    writable boolean NOT NULL,
    readable boolean NOT NULL,
    executable boolean NOT NULL,
    reseller_id integer
);


ALTER TABLE public.role_privilege OWNER TO class4_user;

--
-- Name: role_privilege_role_privilege_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.role_privilege_role_privilege_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.role_privilege_role_privilege_id_seq OWNER TO class4_user;

--
-- Name: role_privilege_role_privilege_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.role_privilege_role_privilege_id_seq OWNED BY public.role_privilege.role_privilege_id;


--
-- Name: role_role_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.role_role_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.role_role_id_seq OWNER TO class4_user;

--
-- Name: role_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.role_role_id_seq OWNED BY public.role.role_id;


--
-- Name: role_submenu_rel; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.role_submenu_rel (
    id integer NOT NULL,
    role_id integer NOT NULL,
    submenu_id integer NOT NULL,
    editable boolean NOT NULL,
    readable boolean NOT NULL,
    executable boolean NOT NULL
);


ALTER TABLE public.role_submenu_rel OWNER TO class4_user;

--
-- Name: role_submenu_rel_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.role_submenu_rel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.role_submenu_rel_id_seq OWNER TO class4_user;

--
-- Name: role_submenu_rel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.role_submenu_rel_id_seq OWNED BY public.role_submenu_rel.id;


--
-- Name: route; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.route (
    route_id integer NOT NULL,
    digits public.prefix_range DEFAULT ''::public.prefix_range,
    dynamic_route_id integer,
    static_route_id integer,
    route_type integer NOT NULL,
    route_strategy_id integer NOT NULL,
    lnp boolean DEFAULT false,
    lrn_block boolean DEFAULT false,
    dnis_only boolean DEFAULT true,
    code_deck_type integer DEFAULT 0,
    update_at timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    update_by character varying,
    intra_static_route_id integer,
    inter_static_route_id integer,
    jurisdiction_country_id integer,
    ani_prefix public.prefix_range,
    ani_min_length integer DEFAULT 0,
    ani_max_length integer DEFAULT 32,
    digits_min_length integer DEFAULT 0,
    digits_max_length integer DEFAULT 32,
    code_name character varying,
    country character varying(50),
    route_type_flg integer
);


ALTER TABLE public.route OWNER TO class4_user;

--
-- Name: TABLE route; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.route IS '路由';


--
-- Name: COLUMN route.digits; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.route.digits IS '前缀';


--
-- Name: COLUMN route.dynamic_route_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.route.dynamic_route_id IS '动态路由';


--
-- Name: COLUMN route.static_route_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.route.static_route_id IS '静态路由';


--
-- Name: COLUMN route.route_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.route.route_type IS '路由方式:1--动态路由;2--静态路由;3--动态路由后再静态路由;4--静态路由后再动态路由';


--
-- Name: COLUMN route.route_strategy_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.route.route_strategy_id IS '路由策略';


--
-- Name: COLUMN route.code_deck_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.route.code_deck_type IS '0-icx code deck;1-custom code deck';


--
-- Name: route_block; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.route_block (
    id integer NOT NULL,
    egress_trunk_id integer,
    code_name character varying(256),
    create_by character varying(256),
    create_on timestamp without time zone
);


ALTER TABLE public.route_block OWNER TO class4_user;

--
-- Name: route_block_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.route_block_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.route_block_id_seq OWNER TO class4_user;

--
-- Name: route_block_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.route_block_id_seq OWNED BY public.route_block.id;


--
-- Name: route_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.route_record (
    route_id integer NOT NULL,
    digits public.prefix_range,
    dynamic_route_id integer,
    static_route_id integer,
    route_type integer NOT NULL,
    route_strategy_id integer NOT NULL,
    lnp boolean,
    lrn_block boolean,
    dnis_only boolean,
    code_deck_type integer,
    update_at timestamp with time zone,
    update_by character varying,
    intra_static_route_id integer,
    inter_static_route_id integer,
    jurisdiction_country_id integer,
    ani_prefix public.prefix_range,
    ani_min_length integer,
    ani_max_length integer,
    digits_min_length integer,
    digits_max_length integer,
    code_name character varying,
    country character varying(50),
    route_type_flg integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.route_record OWNER TO class4_user;

--
-- Name: route_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.route_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.route_record_record_id_seq OWNER TO class4_user;

--
-- Name: route_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.route_record_record_id_seq OWNED BY public.route_record.record_id;


--
-- Name: route_route_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.route_route_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.route_route_id_seq OWNER TO class4_user;

--
-- Name: route_route_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.route_route_id_seq OWNED BY public.route.route_id;


--
-- Name: route_strategy; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.route_strategy (
    route_strategy_id integer NOT NULL,
    name character varying(256) NOT NULL,
    update_at timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    update_by character varying,
    is_virtual boolean
);


ALTER TABLE public.route_strategy OWNER TO class4_user;

--
-- Name: TABLE route_strategy; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.route_strategy IS '路由策略';


--
-- Name: COLUMN route_strategy.name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.route_strategy.name IS '名称';


--
-- Name: route_strategy_route_strategy_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.route_strategy_route_strategy_id_seq
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.route_strategy_route_strategy_id_seq OWNER TO class4_user;

--
-- Name: route_strategy_route_strategy_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.route_strategy_route_strategy_id_seq OWNED BY public.route_strategy.route_strategy_id;


--
-- Name: rtp_proxy_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.rtp_proxy_log (
    id integer NOT NULL,
    session_uuid text NOT NULL,
    source_addr character varying(16) NOT NULL,
    source_port integer NOT NULL,
    dest_addr character varying(16) NOT NULL,
    dest_port integer NOT NULL,
    timeout integer NOT NULL,
    start_time timestamp with time zone NOT NULL,
    end_time timestamp with time zone NOT NULL,
    is_killed boolean NOT NULL,
    last_caller_packet timestamp with time zone,
    caller_packets bigint NOT NULL,
    caller_bytes bigint NOT NULL,
    last_callee_packet timestamp with time zone,
    callee_packets bigint NOT NULL,
    callee_bytes bigint NOT NULL
);


ALTER TABLE public.rtp_proxy_log OWNER TO class4_user;

--
-- Name: rtp_proxy_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.rtp_proxy_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rtp_proxy_log_id_seq OWNER TO class4_user;

--
-- Name: rtp_proxy_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.rtp_proxy_log_id_seq OWNED BY public.rtp_proxy_log.id;


--
-- Name: scheduled_report_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.scheduled_report_log (
    id integer NOT NULL,
    email_to character varying(500),
    report_name character(50),
    attachment_path character varying(500),
    execute_time timestamp with time zone
);


ALTER TABLE public.scheduled_report_log OWNER TO class4_user;

--
-- Name: COLUMN scheduled_report_log.attachment_path; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.scheduled_report_log.attachment_path IS '发送的附件路径';


--
-- Name: scheduled_report_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.scheduled_report_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.scheduled_report_log_id_seq OWNER TO class4_user;

--
-- Name: scheduled_report_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.scheduled_report_log_id_seq OWNED BY public.scheduled_report_log.id;


--
-- Name: scheduler_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.scheduler_log (
    id integer NOT NULL,
    script_name character varying(200),
    start_time timestamp without time zone,
    end_time timestamp without time zone
);


ALTER TABLE public.scheduler_log OWNER TO class4_user;

--
-- Name: COLUMN scheduler_log.script_name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.scheduler_log.script_name IS '脚本名字';


--
-- Name: COLUMN scheduler_log.start_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.scheduler_log.start_time IS '脚本开始执行时间';


--
-- Name: COLUMN scheduler_log.end_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.scheduler_log.end_time IS '执行结束时间';


--
-- Name: scheduler_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.scheduler_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.scheduler_log_id_seq OWNER TO class4_user;

--
-- Name: scheduler_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.scheduler_log_id_seq OWNED BY public.scheduler_log.id;


--
-- Name: send_cdr_direct; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.send_cdr_direct (
    subject character varying(200),
    html_content text,
    sender_id integer,
    cc_mail character varying(200),
    to_mail character varying(200),
    uuid character varying(16) NOT NULL
);


ALTER TABLE public.send_cdr_direct OWNER TO class4_user;

--
-- Name: send_cdr_export_template; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.send_cdr_export_template (
    id integer NOT NULL,
    subject character varying(200),
    html_content text,
    sender_id integer,
    cc_mail character varying(200),
    to_mail character varying(200)
);


ALTER TABLE public.send_cdr_export_template OWNER TO class4_user;

--
-- Name: send_mails; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.send_mails (
    id integer NOT NULL,
    client_id integer,
    mail_subject character varying(200),
    mail_content text,
    mail_to character varying(200),
    mail_cc character varying(200),
    files character varying(200)[],
    status integer,
    send_time time with time zone
);


ALTER TABLE public.send_mails OWNER TO class4_user;

--
-- Name: send_mails_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.send_mails_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.send_mails_id_seq OWNER TO class4_user;

--
-- Name: send_mails_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.send_mails_id_seq OWNED BY public.send_mails.id;


--
-- Name: send_rate_direct; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.send_rate_direct (
    id integer NOT NULL,
    subject character varying(200),
    content text,
    download_method smallint,
    header text,
    sender_id integer,
    mail_cc character varying(200),
    to_mail character varying(200)
);


ALTER TABLE public.send_rate_direct OWNER TO class4_user;

--
-- Name: send_rate_template; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.send_rate_template (
    id integer NOT NULL,
    name character varying(200),
    subject character varying(200),
    content text,
    download_method smallint,
    header text,
    mail_cc character varying(200),
    sender_id integer,
    to_mail character varying(200)
);


ALTER TABLE public.send_rate_template OWNER TO class4_user;

--
-- Name: send_rate_template_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.send_rate_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.send_rate_template_id_seq OWNER TO class4_user;

--
-- Name: send_rate_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.send_rate_template_id_seq OWNED BY public.send_rate_template.id;


--
-- Name: service_charge_items; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.service_charge_items (
    id integer NOT NULL,
    min_rate numeric(30,10),
    max_rate numeric(30,10),
    charge_value real,
    service_charge_id integer
);


ALTER TABLE public.service_charge_items OWNER TO class4_user;

--
-- Name: TABLE service_charge_items; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.service_charge_items IS 'exchange的服务费表';


--
-- Name: service_charge_items_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.service_charge_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.service_charge_items_id_seq OWNER TO class4_user;

--
-- Name: service_charge_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.service_charge_items_id_seq OWNED BY public.service_charge_items.id;


--
-- Name: service_charge_items_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.service_charge_items_record (
    id integer NOT NULL,
    min_rate numeric(30,10),
    max_rate numeric(30,10),
    charge_value real,
    service_charge_id integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.service_charge_items_record OWNER TO class4_user;

--
-- Name: service_charge_items_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.service_charge_items_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.service_charge_items_record_record_id_seq OWNER TO class4_user;

--
-- Name: service_charge_items_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.service_charge_items_record_record_id_seq OWNED BY public.service_charge_items_record.record_id;


--
-- Name: shaken_ani_group; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.shaken_ani_group (
    id integer NOT NULL,
    name text,
    created_by character varying(100),
    created_on timestamp with time zone DEFAULT now()
);


ALTER TABLE public.shaken_ani_group OWNER TO class4_user;

--
-- Name: shaken_ani_group_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.shaken_ani_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shaken_ani_group_id_seq OWNER TO class4_user;

--
-- Name: shaken_ani_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.shaken_ani_group_id_seq OWNED BY public.shaken_ani_group.id;


--
-- Name: shaken_ani_group_list; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.shaken_ani_group_list (
    id integer NOT NULL,
    name text,
    created_by character varying(100),
    created_on timestamp with time zone DEFAULT now()
);


ALTER TABLE public.shaken_ani_group_list OWNER TO class4_user;

--
-- Name: shaken_ani_group_list_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.shaken_ani_group_list_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shaken_ani_group_list_id_seq OWNER TO class4_user;

--
-- Name: shaken_ani_group_list_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.shaken_ani_group_list_id_seq OWNED BY public.shaken_ani_group_list.id;


--
-- Name: shaken_ani_group_list_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.shaken_ani_group_list_record (
    id integer NOT NULL,
    name text,
    created_by character varying(100),
    created_on timestamp with time zone,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.shaken_ani_group_list_record OWNER TO class4_user;

--
-- Name: shaken_ani_group_list_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.shaken_ani_group_list_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shaken_ani_group_list_record_record_id_seq OWNER TO class4_user;

--
-- Name: shaken_ani_group_list_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.shaken_ani_group_list_record_record_id_seq OWNED BY public.shaken_ani_group_list_record.record_id;


--
-- Name: shaken_ani_group_list_rel; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.shaken_ani_group_list_rel (
    ani_group_list_id integer NOT NULL,
    ani_group_id integer NOT NULL,
    attest_lvl character varying(1) NOT NULL,
    created_by character varying(100),
    created_on timestamp with time zone DEFAULT now(),
    id integer NOT NULL,
    CONSTRAINT shaken_ani_group_list_rel_attest_lvl_check CHECK ((((attest_lvl)::text = 'A'::text) OR ((attest_lvl)::text = 'B'::text) OR ((attest_lvl)::text = 'C'::text)))
);


ALTER TABLE public.shaken_ani_group_list_rel OWNER TO class4_user;

--
-- Name: COLUMN shaken_ani_group_list_rel.attest_lvl; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.shaken_ani_group_list_rel.attest_lvl IS 'SHAKEN attestation level: A/B/C';


--
-- Name: shaken_ani_group_list_rel_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.shaken_ani_group_list_rel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shaken_ani_group_list_rel_id_seq OWNER TO class4_user;

--
-- Name: shaken_ani_group_list_rel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.shaken_ani_group_list_rel_id_seq OWNED BY public.shaken_ani_group_list_rel.id;


--
-- Name: shaken_ani_group_list_rel_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.shaken_ani_group_list_rel_record (
    ani_group_list_id integer NOT NULL,
    ani_group_id integer NOT NULL,
    attest_lvl character varying(1) NOT NULL,
    created_by character varying(100),
    created_on timestamp with time zone,
    id integer NOT NULL,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.shaken_ani_group_list_rel_record OWNER TO class4_user;

--
-- Name: shaken_ani_group_list_rel_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.shaken_ani_group_list_rel_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shaken_ani_group_list_rel_record_record_id_seq OWNER TO class4_user;

--
-- Name: shaken_ani_group_list_rel_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.shaken_ani_group_list_rel_record_record_id_seq OWNED BY public.shaken_ani_group_list_rel_record.record_id;


--
-- Name: shaken_ani_group_rel; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.shaken_ani_group_rel (
    group_id integer NOT NULL,
    did character varying(16) NOT NULL,
    created_on timestamp with time zone DEFAULT now(),
    created_by character varying(100)
);


ALTER TABLE public.shaken_ani_group_rel OWNER TO class4_user;

--
-- Name: shaken_ani_group_rel_import_task; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.shaken_ani_group_rel_import_task (
    id integer NOT NULL,
    operator_user character varying(40),
    upload_file_path character varying(256),
    upload_orig_file character varying(100),
    upload_format_file character varying(100),
    orig_name character varying(256),
    repeated_action smallint DEFAULT '0'::smallint,
    status smallint DEFAULT '0'::smallint NOT NULL,
    progress text,
    create_time timestamp with time zone DEFAULT now(),
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    op_method smallint DEFAULT '1'::smallint,
    group_id integer,
    first_number bigint,
    last_number bigint
);


ALTER TABLE public.shaken_ani_group_rel_import_task OWNER TO class4_user;

--
-- Name: shaken_ani_group_rel_import_task_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.shaken_ani_group_rel_import_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shaken_ani_group_rel_import_task_id_seq OWNER TO class4_user;

--
-- Name: shaken_ani_group_rel_import_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.shaken_ani_group_rel_import_task_id_seq OWNED BY public.shaken_ani_group_rel_import_task.id;


--
-- Name: shaken_ani_group_rel_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.shaken_ani_group_rel_record (
    group_id integer NOT NULL,
    did character varying(16) NOT NULL,
    created_on timestamp with time zone,
    created_by character varying(100),
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.shaken_ani_group_rel_record OWNER TO class4_user;

--
-- Name: shaken_ani_group_rel_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.shaken_ani_group_rel_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shaken_ani_group_rel_record_record_id_seq OWNER TO class4_user;

--
-- Name: shaken_ani_group_rel_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.shaken_ani_group_rel_record_record_id_seq OWNED BY public.shaken_ani_group_rel_record.record_id;


--
-- Name: shaken_sti_sp_conf_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.shaken_sti_sp_conf_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shaken_sti_sp_conf_id_seq OWNER TO class4_user;

--
-- Name: shaken_sti_sp_conf; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.shaken_sti_sp_conf (
    priv_key character varying,
    passphrase character varying,
    x5u character varying,
    id bigint DEFAULT nextval('public.shaken_sti_sp_conf_id_seq'::regclass) NOT NULL,
    default_key boolean
);


ALTER TABLE public.shaken_sti_sp_conf OWNER TO class4_user;

--
-- Name: shaken_sti_sp_conf_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.shaken_sti_sp_conf_record (
    priv_key character varying,
    passphrase character varying,
    x5u character varying,
    id bigint NOT NULL,
    default_key boolean,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.shaken_sti_sp_conf_record OWNER TO class4_user;

--
-- Name: shaken_sti_sp_conf_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.shaken_sti_sp_conf_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shaken_sti_sp_conf_record_record_id_seq OWNER TO class4_user;

--
-- Name: shaken_sti_sp_conf_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.shaken_sti_sp_conf_record_record_id_seq OWNED BY public.shaken_sti_sp_conf_record.record_id;


--
-- Name: signal_capture_filter; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.signal_capture_filter (
    id integer NOT NULL,
    ip_address character varying(32),
    number character varying(32),
    enabled boolean DEFAULT true NOT NULL,
    comment character varying(128),
    add_dt timestamp with time zone DEFAULT now(),
    num_filter_type integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.signal_capture_filter OWNER TO class4_user;

--
-- Name: signal_capture_filter_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.signal_capture_filter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.signal_capture_filter_id_seq OWNER TO class4_user;

--
-- Name: signal_capture_filter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.signal_capture_filter_id_seq OWNED BY public.signal_capture_filter.id;


--
-- Name: signup; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.signup (
    id integer NOT NULL,
    company character varying(100),
    login character varying(40),
    password character varying(50),
    address character varying(500),
    email character varying(100),
    noc_email character varying(100),
    billing_email character varying(100),
    rate_email character varying(100),
    rate_delivery_email character varying(100),
    tax_id character varying(100),
    details character varying(1000),
    phone character varying(32),
    status smallint,
    modify_time timestamp with time zone,
    signup_time timestamp with time zone,
    send_email smallint,
    contact_name character varying(100),
    city character varying(40),
    state character varying(40),
    zip character varying(40),
    country character varying(40),
    billing_address character varying(40),
    billing_city character varying(40),
    billing_state character varying(40),
    billing_zip character varying(40),
    billing_country character varying(40),
    billing_contact_name character varying(40),
    billing_phone character varying(40),
    product_id character varying(100),
    agent_id integer,
    referral character varying(500),
    client_id integer,
    company_type smallint DEFAULT '1'::smallint,
    client_type smallint DEFAULT '1'::smallint,
    confirmed_at timestamp with time zone,
    confirmed_ip character varying(100)
);


ALTER TABLE public.signup OWNER TO class4_user;

--
-- Name: signup_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.signup_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.signup_id_seq OWNER TO class4_user;

--
-- Name: signup_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.signup_id_seq OWNED BY public.signup.id;


--
-- Name: signup_ip; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.signup_ip (
    id integer NOT NULL,
    signup_id integer NOT NULL,
    ip character varying(100),
    port integer,
    netmark integer
);


ALTER TABLE public.signup_ip OWNER TO class4_user;

--
-- Name: signup_ip_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.signup_ip_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.signup_ip_id_seq OWNER TO class4_user;

--
-- Name: signup_ip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.signup_ip_id_seq OWNED BY public.signup_ip.id;


--
-- Name: sip_error_code; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.sip_error_code (
    sip_error_code_id integer NOT NULL,
    return_code integer NOT NULL,
    return_code_str character varying(100),
    switch_error_code integer,
    switch_error_code_str character varying(100),
    resource_id integer
);


ALTER TABLE public.sip_error_code OWNER TO class4_user;

--
-- Name: TABLE sip_error_code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.sip_error_code IS '错误码';


--
-- Name: COLUMN sip_error_code.return_code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.sip_error_code.return_code IS '返回状态值';


--
-- Name: sip_error_code_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.sip_error_code_record (
    sip_error_code_id integer NOT NULL,
    return_code integer NOT NULL,
    return_code_str character varying(100),
    switch_error_code integer,
    switch_error_code_str character varying(100),
    resource_id integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.sip_error_code_record OWNER TO class4_user;

--
-- Name: sip_error_code_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.sip_error_code_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sip_error_code_record_record_id_seq OWNER TO class4_user;

--
-- Name: sip_error_code_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.sip_error_code_record_record_id_seq OWNED BY public.sip_error_code_record.record_id;


--
-- Name: sip_error_code_sip_error_code_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.sip_error_code_sip_error_code_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sip_error_code_sip_error_code_id_seq OWNER TO class4_user;

--
-- Name: sip_error_code_sip_error_code_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.sip_error_code_sip_error_code_id_seq OWNED BY public.sip_error_code.sip_error_code_id;


--
-- Name: sip_registrations; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.sip_registrations (
    id integer NOT NULL,
    username character varying(40) NOT NULL,
    network_ip public.ip4r,
    network_port integer,
    status smallint DEFAULT 0 NOT NULL,
    expires integer,
    contact character varying(256),
    uptime bigint
);


ALTER TABLE public.sip_registrations OWNER TO class4_user;

--
-- Name: COLUMN sip_registrations.status; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.sip_registrations.status IS '0 for un-register; 1 for registered; 2 for register failed';


--
-- Name: sip_registrations_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.sip_registrations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sip_registrations_id_seq OWNER TO class4_user;

--
-- Name: sip_registrations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.sip_registrations_id_seq OWNED BY public.sip_registrations.id;


--
-- Name: sms; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.sms (
    id integer NOT NULL,
    client_id integer,
    created_on timestamp with time zone DEFAULT now(),
    sender character varying(128),
    receiver character varying(128),
    message character varying(256),
    cost numeric,
    direction smallint DEFAULT '1'::smallint,
    reference_id character varying(128),
    stat character varying(128),
    delivered_on timestamp with time zone,
    delivery_error character varying(128),
    vendor_cost numeric DEFAULT 0.0,
    vendor_id integer
);


ALTER TABLE public.sms OWNER TO class4_user;

--
-- Name: sms_dlr_hook; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.sms_dlr_hook (
    id integer NOT NULL,
    dlr_url character varying(1024),
    dlr_fail_url character varying(1024)
);


ALTER TABLE public.sms_dlr_hook OWNER TO class4_user;

--
-- Name: sms_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.sms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sms_id_seq OWNER TO class4_user;

--
-- Name: sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.sms_id_seq OWNED BY public.sms.id;


--
-- Name: sms_rate; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.sms_rate (
    id integer NOT NULL,
    sms_rate_table_id integer,
    code public.prefix_range DEFAULT ''::public.prefix_range,
    country character varying(1000),
    effective_date timestamp with time zone,
    end_date timestamp with time zone,
    rate numeric DEFAULT 0.0
);


ALTER TABLE public.sms_rate OWNER TO class4_user;

--
-- Name: sms_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.sms_rate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sms_rate_id_seq OWNER TO class4_user;

--
-- Name: sms_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.sms_rate_id_seq OWNED BY public.sms_rate.id;


--
-- Name: sms_rate_table; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.sms_rate_table (
    id integer NOT NULL,
    name character varying(100) NOT NULL,
    created_on timestamp with time zone,
    created_by character varying
);


ALTER TABLE public.sms_rate_table OWNER TO class4_user;

--
-- Name: sms_rate_table_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.sms_rate_table_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sms_rate_table_id_seq OWNER TO class4_user;

--
-- Name: sms_rate_table_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.sms_rate_table_id_seq OWNED BY public.sms_rate_table.id;


--
-- Name: spam_traffic_ip; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.spam_traffic_ip (
    ip character varying(30) NOT NULL,
    brief character varying(100),
    create_time timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    netmask integer,
    auto_block boolean DEFAULT true,
    created_by character varying(100)
);


ALTER TABLE public.spam_traffic_ip OWNER TO class4_user;

--
-- Name: spam_traffic_ip_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.spam_traffic_ip_record (
    ip character varying(30) NOT NULL,
    brief character varying(100),
    create_time timestamp with time zone,
    netmask integer,
    auto_block boolean,
    created_by character varying(100),
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.spam_traffic_ip_record OWNER TO class4_user;

--
-- Name: spam_traffic_ip_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.spam_traffic_ip_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.spam_traffic_ip_record_record_id_seq OWNER TO class4_user;

--
-- Name: spam_traffic_ip_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.spam_traffic_ip_record_record_id_seq OWNED BY public.spam_traffic_ip_record.record_id;


--
-- Name: storage_config; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.storage_config (
    storage public.storage_type NOT NULL,
    conf_type public.parser_type NOT NULL,
    remote_server_port integer,
    ftp_port integer,
    storage_days integer DEFAULT 60,
    storage_days_local integer DEFAULT 60,
    remote_server_ip text,
    storage_path text,
    username text,
    password text,
    ftp_ip text,
    google_drive_key text,
    google_drive_name text,
    active boolean
);


ALTER TABLE public.storage_config OWNER TO class4_user;

--
-- Name: switch_profile; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.switch_profile (
    id integer NOT NULL,
    switch_name character varying(100),
    profile_name character varying(100),
    sip_ip character varying(64),
    sip_port integer,
    sip_debug integer DEFAULT 0,
    sip_trace boolean DEFAULT false NOT NULL,
    proxy_ip character varying(64),
    proxy_port integer,
    voip_gateway_id integer,
    support_rpid integer DEFAULT 0 NOT NULL,
    support_oli integer DEFAULT 0 NOT NULL,
    support_priv integer DEFAULT 0 NOT NULL,
    support_div integer DEFAULT 0 NOT NULL,
    support_paid integer DEFAULT 0 NOT NULL,
    support_pci integer DEFAULT 0 NOT NULL,
    support_x_lrn integer DEFAULT 1 NOT NULL,
    support_x_header integer DEFAULT 1 NOT NULL,
    sip_capture_ip character varying(255),
    sip_capture_port integer,
    sip_capture_path character varying(255),
    lan_ip character varying(255),
    lan_port integer,
    profile_status smallint,
    paid_replace_ip integer DEFAULT 0,
    auth_register integer,
    default_register integer,
    report_ip character varying(100),
    report_port integer DEFAULT 3300,
    active_call_ip character(64),
    active_call_port integer,
    cps integer,
    cap integer,
    pcap_token character varying(255),
    last_started_on timestamp without time zone
);


ALTER TABLE public.switch_profile OWNER TO class4_user;

--
-- Name: COLUMN switch_profile.paid_replace_ip; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.switch_profile.paid_replace_ip IS 'PAID呼出IP用switch profile sip ip替换;0 -- false;1 -- true';


--
-- Name: COLUMN switch_profile.auth_register; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.switch_profile.auth_register IS '是否检测注册状态 0 false 1 true';


--
-- Name: COLUMN switch_profile.default_register; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.switch_profile.default_register IS '注册使用的默认profile，一个switch_name里至少有个一个设置为默认';


--
-- Name: COLUMN switch_profile.report_ip; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.switch_profile.report_ip IS '报表服务器的IP 端口共用info_port(lan_port)';


--
-- Name: switch_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.switch_profile_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.switch_profile_id_seq OWNER TO class4_user;

--
-- Name: switch_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.switch_profile_id_seq OWNED BY public.switch_profile.id;


--
-- Name: switch_profile_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.switch_profile_record (
    id integer NOT NULL,
    switch_name character varying(100),
    profile_name character varying(100),
    sip_ip character varying(64),
    sip_port integer,
    sip_debug integer,
    sip_trace boolean NOT NULL,
    proxy_ip character varying(64),
    proxy_port integer,
    voip_gateway_id integer,
    support_rpid integer NOT NULL,
    support_oli integer NOT NULL,
    support_priv integer NOT NULL,
    support_div integer NOT NULL,
    support_paid integer NOT NULL,
    support_pci integer NOT NULL,
    support_x_lrn integer NOT NULL,
    support_x_header integer NOT NULL,
    sip_capture_ip character varying(255),
    sip_capture_port integer,
    sip_capture_path character varying(255),
    lan_ip character varying(255),
    lan_port integer,
    profile_status smallint,
    paid_replace_ip integer,
    auth_register integer,
    default_register integer,
    report_ip character varying(100),
    report_port integer,
    active_call_ip character(64),
    active_call_port integer,
    cps integer,
    cap integer,
    pcap_token character varying(255),
    last_started_on timestamp without time zone,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.switch_profile_record OWNER TO class4_user;

--
-- Name: switch_profile_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.switch_profile_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.switch_profile_record_record_id_seq OWNER TO class4_user;

--
-- Name: switch_profile_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.switch_profile_record_record_id_seq OWNED BY public.switch_profile_record.record_id;


--
-- Name: sys_main_menu; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.sys_main_menu (
    id integer NOT NULL,
    display_name character varying(50),
    ordering integer,
    enabled boolean
);


ALTER TABLE public.sys_main_menu OWNER TO class4_user;

--
-- Name: sys_main_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.sys_main_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_main_menu_id_seq OWNER TO class4_user;

--
-- Name: sys_main_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.sys_main_menu_id_seq OWNED BY public.sys_main_menu.id;


--
-- Name: sys_submenu; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.sys_submenu (
    id integer NOT NULL,
    display_name character varying(50),
    ordering integer,
    is_readable boolean,
    is_editable boolean,
    is_executable boolean,
    enabled boolean,
    main_menu_id integer,
    web_url character varying
);


ALTER TABLE public.sys_submenu OWNER TO class4_user;

--
-- Name: sys_submenu_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.sys_submenu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_submenu_id_seq OWNER TO class4_user;

--
-- Name: sys_submenu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.sys_submenu_id_seq OWNED BY public.sys_submenu.id;


--
-- Name: system_function; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.system_function (
    system_function_id integer NOT NULL,
    description character varying(40),
    func_name character varying(50),
    is_read boolean,
    is_write boolean,
    is_exe boolean,
    func_url character varying,
    func_type integer NOT NULL,
    key_118n character varying(50),
    parent_id integer,
    image_name character varying(50),
    develop_status integer NOT NULL,
    group_id integer,
    ordering integer
);


ALTER TABLE public.system_function OWNER TO class4_user;

--
-- Name: system_function_group; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.system_function_group (
    id integer NOT NULL,
    group_name character varying(50),
    description text,
    ordering integer
);


ALTER TABLE public.system_function_group OWNER TO class4_user;

--
-- Name: system_function_group_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.system_function_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.system_function_group_id_seq OWNER TO class4_user;

--
-- Name: system_function_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.system_function_group_id_seq OWNED BY public.system_function_group.id;


--
-- Name: system_function_system_function_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.system_function_system_function_id_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.system_function_system_function_id_seq OWNER TO class4_user;

--
-- Name: system_function_system_function_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.system_function_system_function_id_seq OWNED BY public.system_function.system_function_id;


--
-- Name: system_limit; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.system_limit (
    ingress_call_limit integer DEFAULT 1 NOT NULL,
    ingress_cps_limit integer DEFAULT 1 NOT NULL,
    egress_call_limit integer DEFAULT 1 NOT NULL,
    egress_cps_limit integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.system_limit OWNER TO class4_user;

--
-- Name: TABLE system_limit; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.system_limit IS '系统呼叫限制';


--
-- Name: COLUMN system_limit.ingress_call_limit; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_limit.ingress_call_limit IS 'call limit';


--
-- Name: COLUMN system_limit.ingress_cps_limit; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_limit.ingress_cps_limit IS 'cps limit ';


--
-- Name: COLUMN system_limit.egress_call_limit; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_limit.egress_call_limit IS 'call limit ';


--
-- Name: COLUMN system_limit.egress_cps_limit; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_limit.egress_cps_limit IS 'cps limit ';


--
-- Name: system_parameter; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.system_parameter (
    sys_timezone character varying(20),
    sys_area character varying(50),
    mailserver_host character varying(20),
    mail_server_from character varying(50),
    de_pin_len integer,
    ftp_username character varying(50),
    ftp_pass character varying(20),
    date_format character varying(20),
    datetime_format character varying(20),
    sys_currency character varying(20),
    sys_id integer NOT NULL,
    invoices_tplno character varying(20),
    invoices_lastno character varying(20),
    invoices_fields character varying(50),
    invoices_delay character varying(10),
    invoices_separate character varying(10),
    invoices_cdr_fields character varying(80),
    dr_period character varying(10),
    radius_log_routes character varying(10),
    events_notfoundaccount boolean,
    events_notfoundtariff boolean,
    events_unprofitable boolean,
    events_alertszerotime boolean,
    "lowBalance_period" integer,
    events_deleteafterdays character varying(10),
    stats_rotate_delay character varying(10),
    rates_deleteafterdays character varying(10),
    cdrs_deleteafterdays character varying(20),
    logs_deleteafterdays character varying(10),
    backup_period character varying(10),
    backup_leave_last character varying(10),
    csv_delimiter character varying(5),
    sys_ani public.prefix_range,
    conf_number character varying(10),
    msgmonthlyfee numeric(20,3),
    fail_calls integer,
    forbidden_times integer,
    conf_max_duration integer,
    smtphost character varying(50),
    smtpport character varying(50),
    emailusername character varying(50),
    emailpassword character varying(50),
    fromemail character varying(50),
    emailname character varying(50),
    loginemail character varying(12),
    system_admin_email character varying(1000),
    switch_ip character varying(20),
    switch_port character varying(20),
    noc_email character varying(1000),
    finance_email character varying(1000),
    pdf_tpl text,
    tpl_number integer DEFAULT 0,
    rate_clean_days integer,
    smtp_secure integer DEFAULT 0,
    default_code_deck integer,
    qos_sample_period integer,
    minimal_call_attempt_required integer,
    low_call_attempt_handling integer,
    welcome_message character varying,
    report_count integer DEFAULT 0,
    realm character varying,
    workstation character varying,
    landing_page smallint DEFAULT 0,
    invoice_name character varying(200),
    auto_delivery_timezone character varying(20) DEFAULT '+00'::character varying,
    auto_delivery_address character varying(200),
    allow_cdr_fields text,
    company_info character varying(500),
    bar_color character varying(20) DEFAULT '6B9B20'::character varying,
    auto_delivery_group_by smallint DEFAULT 0,
    inactivity_timeout integer DEFAULT 30,
    is_preload boolean DEFAULT true,
    yourpay_store_number character varying(255),
    paypal_account character varying(255),
    withdraw_email character varying(1000),
    switch_alias character varying(255),
    overlap_invoice_protection boolean DEFAULT true,
    send_cdr_fields text,
    system_rate_mail character varying(255),
    ingress_pdd_timeout integer DEFAULT 60000 NOT NULL,
    egress_pdd_timeout integer DEFAULT 6000 NOT NULL,
    ring_timeout integer DEFAULT 60 NOT NULL,
    call_timeout integer DEFAULT 3600,
    invoice_send_mode integer DEFAULT 0,
    company_info_location smallint DEFAULT 0,
    daily_payment_confirmation boolean,
    daily_payment_email text,
    notify_carrier boolean,
    notify_carrier_cc text,
    payment_setting_subject character(100),
    payment_content text,
    is_show_mutual_balance smallint DEFAULT 1,
    ftp_email character varying(50),
    is_hide_unauthorized_ip smallint DEFAULT 0,
    stripe_account character varying(255),
    require_comment integer,
    auto_rate_smtp character varying(50),
    auto_rate_username character varying(100),
    auto_rate_pwd character varying(100),
    auto_rate_smtp_port integer,
    auto_rate_mail_ssl integer DEFAULT 1,
    themer integer DEFAULT 0,
    default_us_ij_rule integer,
    report_hourly_save_days integer DEFAULT 30,
    report_daily_save_days integer DEFAULT 180,
    report_code_save_days integer DEFAULT 60,
    full_cdr_save_days integer DEFAULT 30,
    simple_cdr_save_days integer DEFAULT 180,
    non_zero_cdr_save_days integer DEFAULT 60,
    invoice_decimal_digits integer DEFAULT 2,
    stripe_public_account character varying(255),
    default_billing_decimal integer DEFAULT 6 NOT NULL,
    auto_carrier_notification boolean,
    login_page_content text,
    payment_received_confirmation boolean,
    paypal_service_charge integer DEFAULT 0,
    stripe_service_charge integer DEFAULT 0,
    signup_content character varying(200),
    login_fit_image boolean,
    login_captcha boolean,
    login_image character varying,
    billing_info text,
    billing_info_location smallint,
    charge_type smallint,
    default_avatar_id integer,
    logo_image_id integer,
    base_url character varying(512),
    invoices_logo_id integer,
    logo_icon_id integer,
    favicon_id integer,
    codedeck_last_az_update timestamp with time zone,
    codedeck_last_us_update timestamp with time zone,
    codedeck_prompt_az_update timestamp with time zone,
    codedeck_prompt_us_update timestamp with time zone,
    doc_url character varying(512),
    portal_display_sip_ip boolean,
    portal_enable_egress_trunks boolean,
    portal_enable_ingress_trunks boolean,
    portal_enable_ip_change boolean,
    portal_enable_public_products boolean,
    portal_offset boolean,
    invoice_send_mode_cdr smallint,
    paypal_skey character varying(255),
    paypal_test_mode boolean,
    default_report_decimal integer DEFAULT 2 NOT NULL,
    enable_first_time_wizard boolean DEFAULT true,
    enable_origination_traffic boolean,
    enable_termination_traffic boolean,
    stripe_charge_type smallint,
    enable_user_registration boolean,
    public_logo_url character varying(20) DEFAULT '/logo'::character varying,
    company_name character varying(200),
    login_footer_color character varying(12)
);


ALTER TABLE public.system_parameter OWNER TO class4_user;

--
-- Name: TABLE system_parameter; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.system_parameter IS '系统参数';


--
-- Name: COLUMN system_parameter.sys_timezone; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.sys_timezone IS '默认时区';


--
-- Name: COLUMN system_parameter.sys_area; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.sys_area IS '默认地区';


--
-- Name: COLUMN system_parameter.mailserver_host; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.mailserver_host IS '邮件服务器地址:';


--
-- Name: COLUMN system_parameter.mail_server_from; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.mail_server_from IS '邮箱地址';


--
-- Name: COLUMN system_parameter.de_pin_len; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.de_pin_len IS '默认卡的密码长度';


--
-- Name: COLUMN system_parameter.ftp_pass; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.ftp_pass IS 'ftp密码';


--
-- Name: COLUMN system_parameter.datetime_format; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.datetime_format IS '日期和时间格式';


--
-- Name: COLUMN system_parameter.sys_currency; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.sys_currency IS '默认货币:   ';


--
-- Name: COLUMN system_parameter.invoices_tplno; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.invoices_tplno IS '发票序列号模板';


--
-- Name: COLUMN system_parameter.invoices_lastno; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.invoices_lastno IS '序列号开始:';


--
-- Name: COLUMN system_parameter.invoices_fields; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.invoices_fields IS '默认量位显示';


--
-- Name: COLUMN system_parameter.invoices_delay; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.invoices_delay IS '自动发票生成延期';


--
-- Name: COLUMN system_parameter.invoices_separate; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.invoices_separate IS '自动发票生成方式:       ';


--
-- Name: COLUMN system_parameter.invoices_cdr_fields; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.invoices_cdr_fields IS '发票里面的cdr量位';


--
-- Name: COLUMN system_parameter.dr_period; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.dr_period IS '分析时长';


--
-- Name: COLUMN system_parameter.radius_log_routes; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.radius_log_routes IS '日志';


--
-- Name: COLUMN system_parameter.events_notfoundaccount; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.events_notfoundaccount IS '是否记录找不到帐户的话单';


--
-- Name: COLUMN system_parameter.events_notfoundtariff; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.events_notfoundtariff IS '   是否记录找不到费率的话单';


--
-- Name: COLUMN system_parameter.events_unprofitable; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.events_unprofitable IS '是否记录亏钱的话单';


--
-- Name: COLUMN system_parameter.events_alertszerotime; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.events_alertszerotime IS '是否记录零时长的话单';


--
-- Name: COLUMN system_parameter."lowBalance_period"; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter."lowBalance_period" IS '每隔多久记录客户余额不足(小时):';


--
-- Name: COLUMN system_parameter.events_deleteafterdays; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.events_deleteafterdays IS '删除系统日志:';


--
-- Name: COLUMN system_parameter.stats_rotate_delay; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.stats_rotate_delay IS '删除系统统计数据';


--
-- Name: COLUMN system_parameter.rates_deleteafterdays; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.rates_deleteafterdays IS '删除过期费率数据:';


--
-- Name: COLUMN system_parameter.cdrs_deleteafterdays; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.cdrs_deleteafterdays IS '删除CDR档案';


--
-- Name: COLUMN system_parameter.logs_deleteafterdays; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.logs_deleteafterdays IS '删除日志文件';


--
-- Name: COLUMN system_parameter.backup_period; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.backup_period IS 'backup_period';


--
-- Name: COLUMN system_parameter.backup_leave_last; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.backup_leave_last IS '只保留的备份档案数';


--
-- Name: COLUMN system_parameter.sys_ani; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.sys_ani IS '系统主叫';


--
-- Name: COLUMN system_parameter.fail_calls; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.fail_calls IS '连续失败次数';


--
-- Name: COLUMN system_parameter.forbidden_times; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.forbidden_times IS '禁止呼叫间隔时间（分钟）';


--
-- Name: COLUMN system_parameter.conf_max_duration; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.conf_max_duration IS '会议最长多少分钟';


--
-- Name: COLUMN system_parameter.pdf_tpl; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.pdf_tpl IS '生成pdf时在pdf里附加的信息内容';


--
-- Name: COLUMN system_parameter.smtp_secure; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.smtp_secure IS '0-no;1-tls;2-ssl';


--
-- Name: COLUMN system_parameter.auto_delivery_group_by; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.auto_delivery_group_by IS '0 - Country;1 - Code Name;2 - Code;3 - Trunk';


--
-- Name: COLUMN system_parameter.notify_carrier; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.notify_carrier IS '是否每次Payment 产生，就发邮件';


--
-- Name: COLUMN system_parameter.notify_carrier_cc; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.notify_carrier_cc IS 'Payment 产生，就发邮件的抄送地址';


--
-- Name: COLUMN system_parameter.require_comment; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.require_comment IS '修改log时如果No ，就不需要每次修改或添加，或删去都需要填写Comment.';


--
-- Name: COLUMN system_parameter.auto_rate_mail_ssl; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.auto_rate_mail_ssl IS '1:ssl else:tls';


--
-- Name: COLUMN system_parameter.themer; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.themer IS '主题配色';


--
-- Name: COLUMN system_parameter.default_us_ij_rule; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.system_parameter.default_us_ij_rule IS '0:A-Z; 1:US Non-JD; 2:US JD; 3:OCN-LATA-JD; 4:OCN-LATA-NON-JD';


--
-- Name: system_parameter_sys_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.system_parameter_sys_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.system_parameter_sys_id_seq OWNER TO class4_user;

--
-- Name: system_parameter_sys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.system_parameter_sys_id_seq OWNED BY public.system_parameter.sys_id;


--
-- Name: termination_global_failover; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.termination_global_failover (
    id integer NOT NULL,
    failover_strategy integer,
    from_sip_code integer,
    to_sip_code integer,
    to_sip_string character varying(100)
);


ALTER TABLE public.termination_global_failover OWNER TO class4_user;

--
-- Name: TABLE termination_global_failover; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.termination_global_failover IS '被叫方跳转策略

baohq20140422';


--
-- Name: COLUMN termination_global_failover.failover_strategy; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.termination_global_failover.failover_strategy IS '跳转策略类型

baohq20140422';


--
-- Name: COLUMN termination_global_failover.from_sip_code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.termination_global_failover.from_sip_code IS '从被叫收到的sip码

baohq20140422';


--
-- Name: COLUMN termination_global_failover.to_sip_code; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.termination_global_failover.to_sip_code IS '返回给主叫的sip码

baohq20140422';


--
-- Name: COLUMN termination_global_failover.to_sip_string; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.termination_global_failover.to_sip_string IS '返回给主叫的sip描述字符串

baohq20140422';


--
-- Name: termination_global_failover_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.termination_global_failover_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.termination_global_failover_id_seq OWNER TO class4_user;

--
-- Name: termination_global_failover_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.termination_global_failover_id_seq OWNED BY public.termination_global_failover.id;


--
-- Name: termination_global_failover_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.termination_global_failover_record (
    id integer NOT NULL,
    failover_strategy integer,
    from_sip_code integer,
    to_sip_code integer,
    to_sip_string character varying(100),
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.termination_global_failover_record OWNER TO class4_user;

--
-- Name: termination_global_failover_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.termination_global_failover_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.termination_global_failover_record_record_id_seq OWNER TO class4_user;

--
-- Name: termination_global_failover_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.termination_global_failover_record_record_id_seq OWNED BY public.termination_global_failover_record.record_id;


--
-- Name: ticket; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.ticket (
    id integer NOT NULL,
    user_ip character varying(32),
    gateway_ip character varying(32),
    user_name character varying(100),
    url character varying(500),
    content text,
    subject character varying(100),
    create_on timestamp with time zone,
    status smallint,
    department smallint,
    ticket_id integer,
    ticket_status integer,
    update_by character varying(100),
    update_on timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    ticket_type character varying(50)
);


ALTER TABLE public.ticket OWNER TO class4_user;

--
-- Name: ticket_attachment; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.ticket_attachment (
    ticket_id integer,
    orig_file character varying(500),
    create_on timestamp with time zone,
    uuid character varying(36) NOT NULL
);


ALTER TABLE public.ticket_attachment OWNER TO class4_user;

--
-- Name: ticket_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.ticket_attachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ticket_attachment_id_seq OWNER TO class4_user;

--
-- Name: ticket_history; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.ticket_history (
    id integer NOT NULL,
    ticket_id integer,
    update_by character varying(100),
    update_on timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    ticket_status integer
);


ALTER TABLE public.ticket_history OWNER TO class4_user;

--
-- Name: ticket_history_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.ticket_history_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ticket_history_id_seq OWNER TO class4_user;

--
-- Name: ticket_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.ticket_history_id_seq OWNED BY public.ticket_history.id;


--
-- Name: ticket_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.ticket_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ticket_id_seq OWNER TO class4_user;

--
-- Name: ticket_id_seq1; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.ticket_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ticket_id_seq1 OWNER TO class4_user;

--
-- Name: ticket_id_seq1; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.ticket_id_seq1 OWNED BY public.ticket.id;


--
-- Name: ticket_type; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.ticket_type (
    ticket_type character varying(50) NOT NULL
);


ALTER TABLE public.ticket_type OWNER TO class4_user;

--
-- Name: time_profile; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.time_profile (
    time_profile_id integer NOT NULL,
    name character varying(100) NOT NULL,
    start_time time without time zone,
    end_time time without time zone,
    start_week integer,
    end_week integer,
    type integer NOT NULL,
    time_zone character varying(10)
);


ALTER TABLE public.time_profile OWNER TO class4_user;

--
-- Name: TABLE time_profile; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.time_profile IS '时间段管理';


--
-- Name: COLUMN time_profile.name; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.time_profile.name IS '名称';


--
-- Name: COLUMN time_profile.start_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.time_profile.start_time IS ' 开始时间';


--
-- Name: COLUMN time_profile.end_time; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.time_profile.end_time IS '结束时间';


--
-- Name: COLUMN time_profile.start_week; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.time_profile.start_week IS '0：星期天;1－6：星期1－星期6';


--
-- Name: COLUMN time_profile.end_week; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.time_profile.end_week IS '0：星期天l;1－6：星期1－星期6';


--
-- Name: COLUMN time_profile.type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.time_profile.type IS '0：all time;1：weekly;2：daily';


--
-- Name: time_profile_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.time_profile_record (
    time_profile_id integer NOT NULL,
    name character varying(100) NOT NULL,
    start_time time without time zone,
    end_time time without time zone,
    start_week integer,
    end_week integer,
    type integer NOT NULL,
    time_zone character varying(10),
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.time_profile_record OWNER TO class4_user;

--
-- Name: time_profile_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.time_profile_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.time_profile_record_record_id_seq OWNER TO class4_user;

--
-- Name: time_profile_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.time_profile_record_record_id_seq OWNED BY public.time_profile_record.record_id;


--
-- Name: time_profile_time_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.time_profile_time_profile_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.time_profile_time_profile_id_seq OWNER TO class4_user;

--
-- Name: time_profile_time_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.time_profile_time_profile_id_seq OWNED BY public.time_profile.time_profile_id;


--
-- Name: transaction_fee_items; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.transaction_fee_items (
    id integer NOT NULL,
    trans_type integer,
    transaction_fee_id integer,
    trans_id integer,
    use_fee real
);


ALTER TABLE public.transaction_fee_items OWNER TO class4_user;

--
-- Name: COLUMN transaction_fee_items.trans_type; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.transaction_fee_items.trans_type IS '1-payment;2-service charge';


--
-- Name: COLUMN transaction_fee_items.trans_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.transaction_fee_items.trans_id IS 'payment_term_id,server_charge_items_id';


--
-- Name: transaction_fee_items_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.transaction_fee_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transaction_fee_items_id_seq OWNER TO class4_user;

--
-- Name: transaction_fee_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.transaction_fee_items_id_seq OWNED BY public.transaction_fee_items.id;


--
-- Name: transaction_fee_items_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.transaction_fee_items_record (
    id integer NOT NULL,
    trans_type integer,
    transaction_fee_id integer,
    trans_id integer,
    use_fee real,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.transaction_fee_items_record OWNER TO class4_user;

--
-- Name: transaction_fee_items_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.transaction_fee_items_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transaction_fee_items_record_record_id_seq OWNER TO class4_user;

--
-- Name: transaction_fee_items_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.transaction_fee_items_record_record_id_seq OWNED BY public.transaction_fee_items_record.record_id;


--
-- Name: translation_item; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.translation_item (
    ref_id integer NOT NULL,
    translation_id integer NOT NULL,
    ani public.prefix_range,
    dnis public.prefix_range,
    action_ani character varying(30) NOT NULL,
    action_dnis character varying(30) NOT NULL,
    ani_method integer NOT NULL,
    dnis_method integer NOT NULL
);


ALTER TABLE public.translation_item OWNER TO class4_user;

--
-- Name: TABLE translation_item; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON TABLE public.translation_item IS '主被叫转换';


--
-- Name: COLUMN translation_item.translation_id; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.translation_item.translation_id IS '号码转换';


--
-- Name: COLUMN translation_item.ani; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.translation_item.ani IS '主叫';


--
-- Name: COLUMN translation_item.dnis; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.translation_item.dnis IS '被叫';


--
-- Name: COLUMN translation_item.action_ani; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.translation_item.action_ani IS '转换后的主叫';


--
-- Name: COLUMN translation_item.action_dnis; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.translation_item.action_dnis IS '转换后的被叫';


--
-- Name: COLUMN translation_item.ani_method; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.translation_item.ani_method IS '0－－忽略;1－－部分替换;2－－全部替换';


--
-- Name: COLUMN translation_item.dnis_method; Type: COMMENT; Schema: public; Owner: class4_user
--

COMMENT ON COLUMN public.translation_item.dnis_method IS '0－－忽略;1－－部分替换;2－－全部替换';


--
-- Name: translation_item_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.translation_item_record (
    ref_id integer NOT NULL,
    translation_id integer NOT NULL,
    ani public.prefix_range,
    dnis public.prefix_range,
    action_ani character varying(30) NOT NULL,
    action_dnis character varying(30) NOT NULL,
    ani_method integer NOT NULL,
    dnis_method integer NOT NULL,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.translation_item_record OWNER TO class4_user;

--
-- Name: translation_item_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.translation_item_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.translation_item_record_record_id_seq OWNER TO class4_user;

--
-- Name: translation_item_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.translation_item_record_record_id_seq OWNED BY public.translation_item_record.record_id;


--
-- Name: translation_item_ref_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.translation_item_ref_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.translation_item_ref_id_seq OWNER TO class4_user;

--
-- Name: translation_item_ref_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.translation_item_ref_id_seq OWNED BY public.translation_item.ref_id;


--
-- Name: trouble_tickets_template; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.trouble_tickets_template (
    id integer NOT NULL,
    name character varying(255),
    title character varying(255),
    content text,
    created_at timestamp with time zone,
    updated_at timestamp with time zone,
    updated_by character varying(255)
);


ALTER TABLE public.trouble_tickets_template OWNER TO class4_user;

--
-- Name: trouble_tickets_template_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.trouble_tickets_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.trouble_tickets_template_id_seq OWNER TO class4_user;

--
-- Name: trouble_tickets_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.trouble_tickets_template_id_seq OWNED BY public.trouble_tickets_template.id;


--
-- Name: trunk_group; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.trunk_group (
    group_id integer NOT NULL,
    group_name character varying NOT NULL,
    trunk_type integer
);


ALTER TABLE public.trunk_group OWNER TO class4_user;

--
-- Name: trunk_group_group_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.trunk_group_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.trunk_group_group_id_seq OWNER TO class4_user;

--
-- Name: trunk_group_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.trunk_group_group_id_seq OWNED BY public.trunk_group.group_id;


--
-- Name: user_api_key; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.user_api_key (
    user_id integer NOT NULL,
    token character varying(1024),
    expired_on timestamp with time zone
);


ALTER TABLE public.user_api_key OWNER TO class4_user;

--
-- Name: user_auth_ip; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.user_auth_ip (
    id integer NOT NULL,
    user_id integer,
    ip character varying(100)
);


ALTER TABLE public.user_auth_ip OWNER TO class4_user;

--
-- Name: user_auth_ip_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.user_auth_ip_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_auth_ip_id_seq OWNER TO class4_user;

--
-- Name: user_auth_ip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.user_auth_ip_id_seq OWNED BY public.user_auth_ip.id;


--
-- Name: user_codedeck_alerts; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.user_codedeck_alerts (
    id integer NOT NULL,
    user_id integer,
    show_az_codedeck boolean NOT NULL,
    show_us_codedeck boolean NOT NULL
);


ALTER TABLE public.user_codedeck_alerts OWNER TO class4_user;

--
-- Name: user_codedeck_alerts_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.user_codedeck_alerts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_codedeck_alerts_id_seq OWNER TO class4_user;

--
-- Name: user_codedeck_alerts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.user_codedeck_alerts_id_seq OWNED BY public.user_codedeck_alerts.id;


--
-- Name: users; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.users (
    user_id integer NOT NULL,
    name character varying(40) NOT NULL,
    password character varying(60) NOT NULL,
    role_id integer,
    reseller_id integer,
    create_time timestamp with time zone DEFAULT now() NOT NULL,
    active boolean NOT NULL,
    client_id integer,
    email character varying(100),
    user_type integer NOT NULL,
    create_user_id integer,
    last_login_time timestamp with time zone,
    card_id integer,
    is_online integer NOT NULL,
    login_ip character varying(40),
    default_mod character varying(100),
    default_mod2 character varying(100),
    last_seen timestamp with time zone,
    report_group boolean NOT NULL,
    outbound_report boolean NOT NULL,
    all_termination boolean NOT NULL,
    show_carrier_trunk_drop_only boolean NOT NULL,
    report_fields text,
    landing_page text,
    cdr_api_token character varying(64),
    cdr_expire timestamp with time zone,
    avatar_id integer,
    first_name character varying(40),
    last_name character varying(40)
);


ALTER TABLE public.users OWNER TO class4_user;

--
-- Name: users_limit; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.users_limit (
    id integer NOT NULL,
    user_id integer,
    client_id integer
);


ALTER TABLE public.users_limit OWNER TO class4_user;

--
-- Name: users_limit_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.users_limit_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.users_limit_id_seq OWNER TO class4_user;

--
-- Name: users_limit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.users_limit_id_seq OWNED BY public.users_limit.id;


--
-- Name: users_user_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.users_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.users_user_id_seq OWNER TO class4_user;

--
-- Name: users_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.users_user_id_seq OWNED BY public.users.user_id;


--
-- Name: version_information; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.version_information (
    id integer NOT NULL,
    program_name character varying(50),
    major_ver character varying(100),
    minor_ver character varying(100),
    build_date character varying(11),
    start_time timestamp with time zone,
    cli_ip character varying(30),
    cli_port integer,
    last_status_time timestamp with time zone,
    status integer,
    expires timestamp with time zone,
    licensed_channel integer,
    licensed_cps integer,
    serial_number character varying(100),
    switch_name character varying(100)
);


ALTER TABLE public.version_information OWNER TO class4_user;

--
-- Name: version_information_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.version_information_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.version_information_id_seq OWNER TO class4_user;

--
-- Name: version_information_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.version_information_id_seq OWNED BY public.version_information.id;


--
-- Name: voip_gateway; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.voip_gateway (
    id integer NOT NULL,
    name character varying(200),
    paid_replace_ip integer DEFAULT 0,
    lan_ip character varying(255),
    lan_port integer,
    active_call_ip character varying(64),
    active_call_port integer,
    sip_capture_ip character varying(255),
    sip_capture_port integer,
    sip_capture_path character varying(255),
    self_cap integer,
    self_cps integer
);


ALTER TABLE public.voip_gateway OWNER TO class4_user;

--
-- Name: voip_gateway_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.voip_gateway_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.voip_gateway_id_seq OWNER TO class4_user;

--
-- Name: voip_gateway_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.voip_gateway_id_seq OWNED BY public.voip_gateway.id;


--
-- Name: voip_gateway_info; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.voip_gateway_info (
    id integer NOT NULL,
    "time" timestamp with time zone DEFAULT now(),
    connected boolean,
    limits json,
    sip_profile_show json,
    get_disk_info json,
    system_call_stat json,
    system_peak_stats json
);


ALTER TABLE public.voip_gateway_info OWNER TO class4_user;

--
-- Name: voip_gateway_record; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.voip_gateway_record (
    id integer NOT NULL,
    name character varying(200),
    paid_replace_ip integer,
    lan_ip character varying(255),
    lan_port integer,
    active_call_ip character varying(64),
    active_call_port integer,
    sip_capture_ip character varying(255),
    sip_capture_port integer,
    sip_capture_path character varying(255),
    self_cap integer,
    self_cps integer,
    "time" integer,
    flag character(1),
    record_id integer NOT NULL
);


ALTER TABLE public.voip_gateway_record OWNER TO class4_user;

--
-- Name: voip_gateway_record_record_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.voip_gateway_record_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.voip_gateway_record_record_id_seq OWNER TO class4_user;

--
-- Name: voip_gateway_record_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.voip_gateway_record_record_id_seq OWNED BY public.voip_gateway_record.record_id;


--
-- Name: watchdog_systemd_log_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.watchdog_systemd_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.watchdog_systemd_log_id_seq OWNER TO class4_user;

--
-- Name: watchdog_systemd_events; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.watchdog_systemd_events (
    id integer DEFAULT nextval('public.watchdog_systemd_log_id_seq'::regclass) NOT NULL,
    server_name text NOT NULL,
    "time" timestamp without time zone DEFAULT now() NOT NULL,
    service text NOT NULL,
    unit text NOT NULL,
    event text NOT NULL,
    message text NOT NULL
);


ALTER TABLE public.watchdog_systemd_events OWNER TO class4_user;

--
-- Name: watchdog_systemd_log; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.watchdog_systemd_log (
    id integer DEFAULT nextval('public.watchdog_systemd_log_id_seq'::regclass) NOT NULL,
    server_name text NOT NULL,
    "time" timestamp without time zone DEFAULT now() NOT NULL,
    service text NOT NULL,
    unit text NOT NULL,
    priority integer NOT NULL,
    message text NOT NULL
);


ALTER TABLE public.watchdog_systemd_log OWNER TO class4_user;

--
-- Name: web_session; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.web_session (
    id integer NOT NULL,
    create_time timestamp with time zone DEFAULT now() NOT NULL,
    user_id integer,
    host character varying(1000),
    agent character varying(1000),
    msg character varying,
    exp timestamp with time zone,
    token character varying(1000)
);


ALTER TABLE public.web_session OWNER TO class4_user;

--
-- Name: web_session_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.web_session_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.web_session_id_seq OWNER TO class4_user;

--
-- Name: web_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.web_session_id_seq OWNED BY public.web_session.id;


--
-- Name: webhook; Type: TABLE; Schema: public; Owner: class4_user
--

CREATE TABLE public.webhook (
    id integer NOT NULL,
    client_id integer,
    number character varying(128) NOT NULL,
    url character varying(1024) NOT NULL,
    header_vars json,
    created_on timestamp with time zone DEFAULT now()
);


ALTER TABLE public.webhook OWNER TO class4_user;

--
-- Name: webhook_id_seq; Type: SEQUENCE; Schema: public; Owner: class4_user
--

CREATE SEQUENCE public.webhook_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.webhook_id_seq OWNER TO class4_user;

--
-- Name: webhook_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: class4_user
--

ALTER SEQUENCE public.webhook_id_seq OWNED BY public.webhook.id;


--
-- Name: agent agent_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent ALTER COLUMN agent_id SET DEFAULT nextval('public.agent_agent_id_seq'::regclass);


--
-- Name: agent_client_client id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_client_client ALTER COLUMN id SET DEFAULT nextval('public.agent_client_client_id_seq'::regclass);


--
-- Name: agent_client_client_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_client_client_record ALTER COLUMN record_id SET DEFAULT nextval('public.agent_client_client_record_record_id_seq'::regclass);


--
-- Name: agent_clients id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_clients ALTER COLUMN id SET DEFAULT nextval('public.agent_clients_id_seq'::regclass);


--
-- Name: agent_commission_history history_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_commission_history ALTER COLUMN history_id SET DEFAULT nextval('public.agent_commission_history_history_id_seq'::regclass);


--
-- Name: agent_commission_history_detail id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_commission_history_detail ALTER COLUMN id SET DEFAULT nextval('public.agent_commission_history_detail_id_seq'::regclass);


--
-- Name: agent_commission_payment id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_commission_payment ALTER COLUMN id SET DEFAULT nextval('public.agent_commission_payment_id_seq'::regclass);


--
-- Name: alert_rules id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.alert_rules ALTER COLUMN id SET DEFAULT nextval('public.alert_rules_id_seq'::regclass);


--
-- Name: alert_rules_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.alert_rules_log ALTER COLUMN id SET DEFAULT nextval('public.alert_rules_log_id_seq'::regclass);


--
-- Name: alert_rules_log_detail id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.alert_rules_log_detail ALTER COLUMN id SET DEFAULT nextval('public.alert_rules_log_detail_id_seq'::regclass);


--
-- Name: allowed_sendto_ip id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.allowed_sendto_ip ALTER COLUMN id SET DEFAULT nextval('public.allowed_sendto_ip_id_seq'::regclass);


--
-- Name: allowed_sendto_ip_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.allowed_sendto_ip_record ALTER COLUMN record_id SET DEFAULT nextval('public.allowed_sendto_ip_record_record_id_seq'::regclass);


--
-- Name: auth_token id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.auth_token ALTER COLUMN id SET DEFAULT nextval('public.auth_token_id_seq'::regclass);


--
-- Name: authorization_logs id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.authorization_logs ALTER COLUMN id SET DEFAULT nextval('public.authorization_logs_id_seq'::regclass);


--
-- Name: auto_rate_import_rule id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.auto_rate_import_rule ALTER COLUMN id SET DEFAULT nextval('public.auto_rate_import_rule_id_seq'::regclass);


--
-- Name: balance_daily_reset_task id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.balance_daily_reset_task ALTER COLUMN id SET DEFAULT nextval('public.balance_daily_reset_task_id_seq'::regclass);


--
-- Name: balance_history id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.balance_history ALTER COLUMN id SET DEFAULT nextval('public.balance_history_id_seq'::regclass);


--
-- Name: balance_history_actual id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.balance_history_actual ALTER COLUMN id SET DEFAULT nextval('public.balance_history_actual_id_seq'::regclass);


--
-- Name: balance_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.balance_log ALTER COLUMN id SET DEFAULT nextval('public.balance_log_id_seq'::regclass);


--
-- Name: banned_ip_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.banned_ip_record ALTER COLUMN record_id SET DEFAULT nextval('public.banned_ip_record_record_id_seq'::regclass);


--
-- Name: block_log log_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.block_log ALTER COLUMN log_id SET DEFAULT nextval('public.block_log_log_id_seq'::regclass);


--
-- Name: block_number_import_task id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.block_number_import_task ALTER COLUMN id SET DEFAULT nextval('public.block_number_import_task_id_seq'::regclass);


--
-- Name: c4_client_balance id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_client_balance ALTER COLUMN id SET DEFAULT nextval('public.c4_client_balance_id_seq'::regclass);


--
-- Name: c4_livecall_user id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_livecall_user ALTER COLUMN id SET DEFAULT nextval('public.c4_livecall_user_id_seq'::regclass);


--
-- Name: c4_livecall_user_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_livecall_user_record ALTER COLUMN record_id SET DEFAULT nextval('public.c4_livecall_user_record_record_id_seq'::regclass);


--
-- Name: c4_lrn id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_lrn ALTER COLUMN id SET DEFAULT nextval('public.c4_lrn_id_seq'::regclass);


--
-- Name: c4_lrn_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_lrn_record ALTER COLUMN record_id SET DEFAULT nextval('public.c4_lrn_record_record_id_seq'::regclass);


--
-- Name: c4_shaken_conf id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_shaken_conf ALTER COLUMN id SET DEFAULT nextval('public.c4_shaken_conf_id_seq'::regclass);


--
-- Name: c4_shaken_conf_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_shaken_conf_record ALTER COLUMN record_id SET DEFAULT nextval('public.c4_shaken_conf_record_record_id_seq'::regclass);


--
-- Name: c4_shaken_status id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_shaken_status ALTER COLUMN id SET DEFAULT nextval('public.c4_shaken_status_id_seq'::regclass);


--
-- Name: c4_shaken_status_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_shaken_status_record ALTER COLUMN record_id SET DEFAULT nextval('public.c4_shaken_status_record_record_id_seq'::regclass);


--
-- Name: c4_us_lerg id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_us_lerg ALTER COLUMN id SET DEFAULT nextval('public.c4_us_lerg_id_seq'::regclass);


--
-- Name: calling_call call_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.calling_call ALTER COLUMN call_id SET DEFAULT nextval('public.calling_call_call_id_seq'::regclass);


--
-- Name: calling_queue qid; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.calling_queue ALTER COLUMN qid SET DEFAULT nextval('public.calling_queue_qid_seq'::regclass);


--
-- Name: carrier_group group_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.carrier_group ALTER COLUMN group_id SET DEFAULT nextval('public.carrier_group_group_id_seq'::regclass);


--
-- Name: carrier_template id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.carrier_template ALTER COLUMN id SET DEFAULT nextval('public.carrier_template_id_seq'::regclass);


--
-- Name: cdr_export_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_export_log ALTER COLUMN id SET DEFAULT nextval('public.cdr_export_log_id_seq'::regclass);


--
-- Name: cdr_export_task id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_export_task ALTER COLUMN id SET DEFAULT nextval('public.cdr_export_task_id_seq'::regclass);


--
-- Name: cdr_report_daily id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_report_daily ALTER COLUMN id SET DEFAULT nextval('public.cdr_report_daily_id_seq'::regclass);


--
-- Name: cdr_rerate id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_rerate ALTER COLUMN id SET DEFAULT nextval('public.cdr_rerate_id_seq'::regclass);


--
-- Name: client client_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client ALTER COLUMN client_id SET DEFAULT nextval('public.client_client_id_seq'::regclass);


--
-- Name: client_balance_operation_action id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_balance_operation_action ALTER COLUMN id SET DEFAULT nextval('public.client_balance_operation_action_id_seq'::regclass);


--
-- Name: client_default_ip id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_default_ip ALTER COLUMN id SET DEFAULT nextval('public.client_default_ip_id_seq'::regclass);


--
-- Name: client_invoice_settings id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_invoice_settings ALTER COLUMN id SET DEFAULT nextval('public.client_invoice_settings_id_seq'::regclass);


--
-- Name: client_payment client_payment_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_payment ALTER COLUMN client_payment_id SET DEFAULT nextval('public.client_payment_client_payment_id_seq'::regclass);


--
-- Name: client_rate_generation id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_rate_generation ALTER COLUMN id SET DEFAULT nextval('public.client_rate_generation_id_seq'::regclass);


--
-- Name: client_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_record ALTER COLUMN record_id SET DEFAULT nextval('public.client_record_record_id_seq'::regclass);


--
-- Name: client_taxes id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_taxes ALTER COLUMN id SET DEFAULT nextval('public.client_taxes_id_seq'::regclass);


--
-- Name: code code_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.code ALTER COLUMN code_id SET DEFAULT nextval('public.code_code_id_seq'::regclass);


--
-- Name: code_deck code_deck_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.code_deck ALTER COLUMN code_deck_id SET DEFAULT nextval('public.code_deck_code_deck_id_seq'::regclass);


--
-- Name: code_deck_import_task id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.code_deck_import_task ALTER COLUMN id SET DEFAULT nextval('public.code_deck_import_task_id_seq'::regclass);


--
-- Name: code_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.code_record ALTER COLUMN record_id SET DEFAULT nextval('public.code_record_record_id_seq'::regclass);


--
-- Name: code_report id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.code_report ALTER COLUMN id SET DEFAULT nextval('public.code_report_id_seq'::regclass);


--
-- Name: code_report_daily id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.code_report_daily ALTER COLUMN id SET DEFAULT nextval('public.code_report_daily_id_seq'::regclass);


--
-- Name: credit_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.credit_log ALTER COLUMN id SET DEFAULT nextval('public.credit_log_id_seq'::regclass);


--
-- Name: currency currency_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.currency ALTER COLUMN currency_id SET DEFAULT nextval('public.currency_currency_id_seq'::regclass);


--
-- Name: currency_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.currency_record ALTER COLUMN record_id SET DEFAULT nextval('public.currency_record_record_id_seq'::regclass);


--
-- Name: currency_updates currency_updates_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.currency_updates ALTER COLUMN currency_updates_id SET DEFAULT nextval('public.currency_updates_currency_updates_id_seq'::regclass);


--
-- Name: currency_updates_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.currency_updates_record ALTER COLUMN record_id SET DEFAULT nextval('public.currency_updates_record_record_id_seq'::regclass);


--
-- Name: daily_cdr_fields id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.daily_cdr_fields ALTER COLUMN id SET DEFAULT nextval('public.daily_cdr_fields_id_seq'::regclass);


--
-- Name: dashboard_time_option id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dashboard_time_option ALTER COLUMN id SET DEFAULT nextval('public.dashboard_time_option_id_seq'::regclass);


--
-- Name: did_assignments id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_assignments ALTER COLUMN id SET DEFAULT nextval('public.did_assignments_id_seq'::regclass);


--
-- Name: did_assignments_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_assignments_log ALTER COLUMN id SET DEFAULT nextval('public.did_assignments_log_id_seq'::regclass);


--
-- Name: did_billing_brief id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_brief ALTER COLUMN id SET DEFAULT nextval('public.did_billing_brief_id_seq'::regclass);


--
-- Name: did_billing_operation_action id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_operation_action ALTER COLUMN id SET DEFAULT nextval('public.did_billing_operation_action_id_seq'::regclass);


--
-- Name: did_billing_plan id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_plan ALTER COLUMN id SET DEFAULT nextval('public.did_billing_plan_id_seq'::regclass);


--
-- Name: did_billing_plan_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_plan_record ALTER COLUMN record_id SET DEFAULT nextval('public.did_billing_plan_record_record_id_seq'::regclass);


--
-- Name: did_billing_rel id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_rel ALTER COLUMN id SET DEFAULT nextval('public.did_billing_rel_id_seq'::regclass);


--
-- Name: did_billing_rel_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_rel_record ALTER COLUMN record_id SET DEFAULT nextval('public.did_billing_rel_record_record_id_seq'::regclass);


--
-- Name: did_charge_detail id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_charge_detail ALTER COLUMN id SET DEFAULT nextval('public.did_charge_detail_id_seq'::regclass);


--
-- Name: did_client_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_client_log ALTER COLUMN id SET DEFAULT nextval('public.did_client_log_id_seq'::regclass);


--
-- Name: did_cost_detail id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_cost_detail ALTER COLUMN id SET DEFAULT nextval('public.did_cost_detail_id_seq'::regclass);


--
-- Name: did_disconnect_task id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_disconnect_task ALTER COLUMN id SET DEFAULT nextval('public.did_disconnect_task_id_seq'::regclass);


--
-- Name: did_export_async_task id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_export_async_task ALTER COLUMN id SET DEFAULT nextval('public.did_export_async_task_id_seq'::regclass);


--
-- Name: did_invoice_charge_breakdown id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_invoice_charge_breakdown ALTER COLUMN id SET DEFAULT nextval('public.did_invoice_charge_breakdown_id_seq'::regclass);


--
-- Name: did_invoice_charge_detail id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_invoice_charge_detail ALTER COLUMN id SET DEFAULT nextval('public.did_invoice_charge_detail_id_seq'::regclass);


--
-- Name: did_invoice_port_charge id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_invoice_port_charge ALTER COLUMN id SET DEFAULT nextval('public.did_invoice_port_charge_id_seq'::regclass);


--
-- Name: did_number_assign_task id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_number_assign_task ALTER COLUMN id SET DEFAULT nextval('public.did_number_assign_task_id_seq'::regclass);


--
-- Name: did_number_delete_task id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_number_delete_task ALTER COLUMN id SET DEFAULT nextval('public.did_number_delete_task_id_seq'::regclass);


--
-- Name: did_product id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_product ALTER COLUMN id SET DEFAULT nextval('public.did_product_id_seq'::regclass);


--
-- Name: did_product_item id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_product_item ALTER COLUMN id SET DEFAULT nextval('public.did_product_item_id_seq'::regclass);


--
-- Name: did_repository id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_repository ALTER COLUMN id SET DEFAULT nextval('public.did_repository_id_seq'::regclass);


--
-- Name: did_repository_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_repository_log ALTER COLUMN id SET DEFAULT nextval('public.did_repository_log_id_seq'::regclass);


--
-- Name: did_transaction id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_transaction ALTER COLUMN id SET DEFAULT nextval('public.did_transaction_id_seq'::regclass);


--
-- Name: did_vendor_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_vendor_log ALTER COLUMN id SET DEFAULT nextval('public.did_vendor_log_id_seq'::regclass);


--
-- Name: digit_translation translation_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.digit_translation ALTER COLUMN translation_id SET DEFAULT nextval('public.digit_translation_translation_id_seq'::regclass);


--
-- Name: disk_management id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.disk_management ALTER COLUMN id SET DEFAULT nextval('public.disk_management_id_seq'::regclass);


--
-- Name: dnis_type_name id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnis_type_name ALTER COLUMN id SET DEFAULT nextval('public.dnis_type_name_id_seq'::regclass);


--
-- Name: dnl_cloud_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_log ALTER COLUMN id SET DEFAULT nextval('public.dnl_cloud_log_id_seq'::regclass);


--
-- Name: dynamic_route dynamic_route_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route ALTER COLUMN dynamic_route_id SET DEFAULT nextval('public.dynamic_route_dynamic_route_id_seq'::regclass);


--
-- Name: dynamic_route_items id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_items ALTER COLUMN id SET DEFAULT nextval('public.dynamic_route_items_id_seq'::regclass);


--
-- Name: dynamic_route_items_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_items_record ALTER COLUMN record_id SET DEFAULT nextval('public.dynamic_route_items_record_record_id_seq'::regclass);


--
-- Name: dynamic_route_override id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_override ALTER COLUMN id SET DEFAULT nextval('public.dynamic_route_override_id_seq'::regclass);


--
-- Name: dynamic_route_override_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_override_record ALTER COLUMN record_id SET DEFAULT nextval('public.dynamic_route_override_record_record_id_seq'::regclass);


--
-- Name: dynamic_route_pri id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_pri ALTER COLUMN id SET DEFAULT nextval('public.dynamic_route_pri_id_seq'::regclass);


--
-- Name: dynamic_route_pri_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_pri_record ALTER COLUMN record_id SET DEFAULT nextval('public.dynamic_route_pri_record_record_id_seq'::regclass);


--
-- Name: dynamic_route_qos id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_qos ALTER COLUMN id SET DEFAULT nextval('public.dynamic_route_qos_id_seq'::regclass);


--
-- Name: dynamic_route_qos_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_qos_record ALTER COLUMN record_id SET DEFAULT nextval('public.dynamic_route_qos_record_record_id_seq'::regclass);


--
-- Name: dynamic_route_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_record ALTER COLUMN record_id SET DEFAULT nextval('public.dynamic_route_record_record_id_seq'::regclass);


--
-- Name: egress_error_string id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.egress_error_string ALTER COLUMN id SET DEFAULT nextval('public.egress_error_string_id_seq'::regclass);


--
-- Name: egress_profile id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.egress_profile ALTER COLUMN id SET DEFAULT nextval('public.egress_profile_id_seq'::regclass);


--
-- Name: egress_profile_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.egress_profile_record ALTER COLUMN record_id SET DEFAULT nextval('public.egress_profile_record_record_id_seq'::regclass);


--
-- Name: email_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.email_log ALTER COLUMN id SET DEFAULT nextval('public.email_log_id_seq'::regclass);


--
-- Name: execution_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.execution_log ALTER COLUMN id SET DEFAULT nextval('public.execution_log_id_seq'::regclass);


--
-- Name: fault_route_alert_rule id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fault_route_alert_rule ALTER COLUMN id SET DEFAULT nextval('public.fault_route_alert_rule_id_seq'::regclass);


--
-- Name: fault_route_alert_rule_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fault_route_alert_rule_log ALTER COLUMN id SET DEFAULT nextval('public.fault_route_alert_rule_log_id_seq'::regclass);


--
-- Name: fraud_detection id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fraud_detection ALTER COLUMN id SET DEFAULT nextval('public.fraud_detection_id_seq'::regclass);


--
-- Name: fraud_detection_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fraud_detection_log ALTER COLUMN id SET DEFAULT nextval('public.fraud_detection_log_id_seq'::regclass);


--
-- Name: fraud_detection_log_detail id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fraud_detection_log_detail ALTER COLUMN id SET DEFAULT nextval('public.fraud_detection_log_detail_id_seq'::regclass);


--
-- Name: frund_detection id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.frund_detection ALTER COLUMN id SET DEFAULT nextval('public.frund_detection_id_seq'::regclass);


--
-- Name: frund_detection_history id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.frund_detection_history ALTER COLUMN id SET DEFAULT nextval('public.frund_detection_history_id_seq'::regclass);


--
-- Name: ftp_cdr_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ftp_cdr_log ALTER COLUMN id SET DEFAULT nextval('public.ftp_cdr_log_id_seq'::regclass);


--
-- Name: ftp_cdr_log_detail id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ftp_cdr_log_detail ALTER COLUMN id SET DEFAULT nextval('public.ftp_cdr_log_detail_id_seq'::regclass);


--
-- Name: ftp_conf id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ftp_conf ALTER COLUMN id SET DEFAULT nextval('public.ftp_conf_id_seq'::regclass);


--
-- Name: ftp_server_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ftp_server_log ALTER COLUMN id SET DEFAULT nextval('public.ftp_server_log_id_seq'::regclass);


--
-- Name: global_route_error id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.global_route_error ALTER COLUMN id SET DEFAULT nextval('public.global_route_error_id_seq'::regclass);


--
-- Name: global_route_error_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.global_route_error_record ALTER COLUMN record_id SET DEFAULT nextval('public.global_route_error_record_record_id_seq'::regclass);


--
-- Name: import_export_logs id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.import_export_logs ALTER COLUMN id SET DEFAULT nextval('public.import_export_logs_id_seq'::regclass);


--
-- Name: import_rate_file_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.import_rate_file_log ALTER COLUMN id SET DEFAULT nextval('public.import_rate_file_log_id_seq'::regclass);


--
-- Name: import_rate_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.import_rate_log ALTER COLUMN id SET DEFAULT nextval('public.import_rate_log_id_seq'::regclass);


--
-- Name: import_rate_status id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.import_rate_status ALTER COLUMN id SET DEFAULT nextval('public.import_rate_status_id_seq'::regclass);


--
-- Name: import_target_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.import_target_log ALTER COLUMN id SET DEFAULT nextval('public.import_target_log_id_seq'::regclass);


--
-- Name: invoice invoice_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice ALTER COLUMN invoice_id SET DEFAULT nextval('public.invoice_invoice_id_seq'::regclass);


--
-- Name: invoice_cdr_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_cdr_log ALTER COLUMN id SET DEFAULT nextval('public.invoice_cdr_log_id_seq'::regclass);


--
-- Name: invoice_debug id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_debug ALTER COLUMN id SET DEFAULT nextval('public.invoice_debug_id_seq'::regclass);


--
-- Name: invoice_email id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_email ALTER COLUMN id SET DEFAULT nextval('public.invoice_email_id_seq'::regclass);


--
-- Name: invoice_history id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_history ALTER COLUMN id SET DEFAULT nextval('public.invoice_history_id_seq'::regclass);


--
-- Name: invoice_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_log ALTER COLUMN id SET DEFAULT nextval('public.invoice_log_id_seq'::regclass);


--
-- Name: invoice_payment id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_payment ALTER COLUMN id SET DEFAULT nextval('public.invoice_payment_id_seq'::regclass);


--
-- Name: invoice_settings id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_settings ALTER COLUMN id SET DEFAULT nextval('public.invoice_settings_id_seq'::regclass);


--
-- Name: invoice_summary invoice_number; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_summary ALTER COLUMN invoice_number SET DEFAULT nextval('public.invoice_summary_invoice_number_seq'::regclass);


--
-- Name: invoice_task id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_task ALTER COLUMN id SET DEFAULT nextval('public.invoice_task_id_seq'::regclass);


--
-- Name: ip_modif_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ip_modif_log ALTER COLUMN id SET DEFAULT nextval('public.ip_modif_log_id_seq'::regclass);


--
-- Name: jur_type_name id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.jur_type_name ALTER COLUMN id SET DEFAULT nextval('public.jur_type_name_id_seq'::regclass);


--
-- Name: jurisdiction_prefix id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.jurisdiction_prefix ALTER COLUMN id SET DEFAULT nextval('public.jurisdiction_prefix_id_seq'::regclass);


--
-- Name: jurisdiction_prefix_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.jurisdiction_prefix_record ALTER COLUMN record_id SET DEFAULT nextval('public.jurisdiction_prefix_record_record_id_seq'::regclass);


--
-- Name: jurisdiction_update_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.jurisdiction_update_log ALTER COLUMN id SET DEFAULT nextval('public.jurisdiction_update_log_id_seq'::regclass);


--
-- Name: kill_pg_sql_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.kill_pg_sql_log ALTER COLUMN id SET DEFAULT nextval('public.kill_pg_sql_log_id_seq'::regclass);


--
-- Name: lcr_test id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test ALTER COLUMN id SET DEFAULT nextval('public.lcr_test_id_seq1'::regclass);


--
-- Name: lcr_test_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test_log ALTER COLUMN id SET DEFAULT nextval('public.lcr_test_log_id_seq1'::regclass);


--
-- Name: lerg_download_schedule id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lerg_download_schedule ALTER COLUMN id SET DEFAULT nextval('public.lerg_download_schedule_id_seq'::regclass);


--
-- Name: loop_detection id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.loop_detection ALTER COLUMN id SET DEFAULT nextval('public.loop_detection_id_seq'::regclass);


--
-- Name: loop_detection_detail id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.loop_detection_detail ALTER COLUMN id SET DEFAULT nextval('public.loop_detection_detail_id_seq'::regclass);


--
-- Name: mail_cdr_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.mail_cdr_log ALTER COLUMN id SET DEFAULT nextval('public.mail_cdr_log_id_seq'::regclass);


--
-- Name: mail_cdr_log_detail id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.mail_cdr_log_detail ALTER COLUMN id SET DEFAULT nextval('public.mail_cdr_log_detail_id_seq'::regclass);


--
-- Name: mail_sender id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.mail_sender ALTER COLUMN id SET DEFAULT nextval('public.mail_sender_id_seq'::regclass);


--
-- Name: media_asr_filter id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.media_asr_filter ALTER COLUMN id SET DEFAULT nextval('public.media_asr_filter_id_seq'::regclass);


--
-- Name: media_capture_filter id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.media_capture_filter ALTER COLUMN id SET DEFAULT nextval('public.media_capture_filter_id_seq'::regclass);


--
-- Name: modif_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.modif_log ALTER COLUMN id SET DEFAULT nextval('public.modif_log_id_seq'::regclass);


--
-- Name: monitored_rule id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.monitored_rule ALTER COLUMN id SET DEFAULT nextval('public.monitored_rule_id_seq'::regclass);


--
-- Name: monitored_rule_history id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.monitored_rule_history ALTER COLUMN id SET DEFAULT nextval('public.monitored_rule_history_id_seq'::regclass);


--
-- Name: object_revision id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.object_revision ALTER COLUMN id SET DEFAULT nextval('public.object_revision_id_seq'::regclass);


--
-- Name: object_revision_record id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.object_revision_record ALTER COLUMN id SET DEFAULT nextval('public.object_revision_record_id_seq'::regclass);


--
-- Name: ocn_blocklist id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ocn_blocklist ALTER COLUMN id SET DEFAULT nextval('public.ocn_blocklist_id_seq'::regclass);


--
-- Name: ocn_blocklist_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ocn_blocklist_record ALTER COLUMN record_id SET DEFAULT nextval('public.ocn_blocklist_record_record_id_seq'::regclass);


--
-- Name: orig_log log_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.orig_log ALTER COLUMN log_id SET DEFAULT nextval('public.orig_log_log_id_seq'::regclass);


--
-- Name: origination_global_failover id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.origination_global_failover ALTER COLUMN id SET DEFAULT nextval('public.origination_global_failover_id_seq'::regclass);


--
-- Name: origination_global_failover_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.origination_global_failover_record ALTER COLUMN record_id SET DEFAULT nextval('public.origination_global_failover_record_record_id_seq'::regclass);


--
-- Name: partition_gateway_ref id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.partition_gateway_ref ALTER COLUMN id SET DEFAULT nextval('public.partition_gateway_ref_id_seq'::regclass);


--
-- Name: partition_gateway_ref_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.partition_gateway_ref_record ALTER COLUMN record_id SET DEFAULT nextval('public.partition_gateway_ref_record_record_id_seq'::regclass);


--
-- Name: payment_gateway_history id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.payment_gateway_history ALTER COLUMN id SET DEFAULT nextval('public.payment_gateway_history_id_seq'::regclass);


--
-- Name: payment_invoice id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.payment_invoice ALTER COLUMN id SET DEFAULT nextval('public.payment_invoice_id_seq'::regclass);


--
-- Name: payment_term payment_term_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.payment_term ALTER COLUMN payment_term_id SET DEFAULT nextval('public.payment_term_payment_term_id_seq'::regclass);


--
-- Name: payment_term_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.payment_term_record ALTER COLUMN record_id SET DEFAULT nextval('public.payment_term_record_record_id_seq'::regclass);


--
-- Name: pcap_query_task id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.pcap_query_task ALTER COLUMN id SET DEFAULT nextval('public.pcap_query_task_id_seq'::regclass);


--
-- Name: product product_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product ALTER COLUMN product_id SET DEFAULT nextval('public.product_product_id_seq'::regclass);


--
-- Name: product_agents_ref id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_agents_ref ALTER COLUMN id SET DEFAULT nextval('public.product_agents_ref_id_seq'::regclass);


--
-- Name: product_clients_ref id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_clients_ref ALTER COLUMN id SET DEFAULT nextval('public.product_clients_ref_id_seq'::regclass);


--
-- Name: product_clients_ref_used id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_clients_ref_used ALTER COLUMN id SET DEFAULT nextval('public.product_clients_ref_used_id_seq'::regclass);


--
-- Name: product_codename item_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_codename ALTER COLUMN item_id SET DEFAULT nextval('public.product_codename_item_id_seq'::regclass);


--
-- Name: product_codename_resource item_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_codename_resource ALTER COLUMN item_id SET DEFAULT nextval('public.product_codename_resource_item_id_seq'::regclass);


--
-- Name: product_items item_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_items ALTER COLUMN item_id SET DEFAULT nextval('public.product_items_item_id_seq'::regclass);


--
-- Name: product_items_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_items_record ALTER COLUMN record_id SET DEFAULT nextval('public.product_items_record_record_id_seq'::regclass);


--
-- Name: product_items_resource id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_items_resource ALTER COLUMN id SET DEFAULT nextval('public.product_items_resource_id_seq'::regclass);


--
-- Name: product_items_resource_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_items_resource_record ALTER COLUMN record_id SET DEFAULT nextval('public.product_items_resource_record_record_id_seq'::regclass);


--
-- Name: product_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_record ALTER COLUMN record_id SET DEFAULT nextval('public.product_record_record_id_seq'::regclass);


--
-- Name: product_rout_rate_table id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_rout_rate_table ALTER COLUMN id SET DEFAULT nextval('public.product_rout_rate_table_id_seq'::regclass);


--
-- Name: product_rout_rate_table_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_rout_rate_table_record ALTER COLUMN record_id SET DEFAULT nextval('public.product_rout_rate_table_record_record_id_seq'::regclass);


--
-- Name: product_route_analysis_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_route_analysis_log ALTER COLUMN id SET DEFAULT nextval('public.product_route_analysis_log_id_seq'::regclass);


--
-- Name: random_ani_generation id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.random_ani_generation ALTER COLUMN id SET DEFAULT nextval('public.random_ani_generation_id_seq'::regclass);


--
-- Name: random_ani_generation_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.random_ani_generation_record ALTER COLUMN record_id SET DEFAULT nextval('public.random_ani_generation_record_record_id_seq'::regclass);


--
-- Name: random_ani_group id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.random_ani_group ALTER COLUMN id SET DEFAULT nextval('public.random_ani_group_id_seq'::regclass);


--
-- Name: random_ani_group_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.random_ani_group_record ALTER COLUMN record_id SET DEFAULT nextval('public.random_ani_group_record_record_id_seq'::regclass);


--
-- Name: rate rate_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate ALTER COLUMN rate_id SET DEFAULT nextval('public.rate_rate_id_seq'::regclass);


--
-- Name: rate_auto_import_mailbox_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_auto_import_mailbox_log ALTER COLUMN id SET DEFAULT nextval('public.rate_auto_import_mailbox_log_id_seq'::regclass);


--
-- Name: rate_auto_import_rule id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_auto_import_rule ALTER COLUMN id SET DEFAULT nextval('public.rate_auto_import_rule_id_seq'::regclass);


--
-- Name: rate_auto_import_rule_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_auto_import_rule_log ALTER COLUMN id SET DEFAULT nextval('public.rate_auto_import_rule_log_id_seq'::regclass);


--
-- Name: rate_download_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_download_log ALTER COLUMN id SET DEFAULT nextval('public.rate_download_log_id_seq'::regclass);


--
-- Name: rate_generation_history id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_history ALTER COLUMN id SET DEFAULT nextval('public.rate_generation_history_id_seq'::regclass);


--
-- Name: rate_generation_rate generation_rate_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_rate ALTER COLUMN generation_rate_id SET DEFAULT nextval('public.rate_generation_rate_generation_rate_id_seq'::regclass);


--
-- Name: rate_generation_template id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_template ALTER COLUMN id SET DEFAULT nextval('public.rate_generation_template_id_seq'::regclass);


--
-- Name: rate_generation_template_detail id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_template_detail ALTER COLUMN id SET DEFAULT nextval('public.rate_generation_template_detail_id_seq'::regclass);


--
-- Name: rate_generation_template_margin id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_template_margin ALTER COLUMN id SET DEFAULT nextval('public.rate_generation_template_margin_id_seq'::regclass);


--
-- Name: rate_mass_edit_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_mass_edit_log ALTER COLUMN id SET DEFAULT nextval('public.rate_mass_edit_log_id_seq'::regclass);


--
-- Name: rate_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_record ALTER COLUMN record_id SET DEFAULT nextval('public.rate_record_record_id_seq'::regclass);


--
-- Name: rate_send_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_send_log ALTER COLUMN id SET DEFAULT nextval('public.rate_send_log_id_seq'::regclass);


--
-- Name: rate_send_log_detail id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_send_log_detail ALTER COLUMN id SET DEFAULT nextval('public.rate_send_log_detail_id_seq'::regclass);


--
-- Name: rate_table rate_table_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_table ALTER COLUMN rate_table_id SET DEFAULT nextval('public.rate_table_rate_table_id_seq'::regclass);


--
-- Name: rate_table_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_table_record ALTER COLUMN record_id SET DEFAULT nextval('public.rate_table_record_record_id_seq'::regclass);


--
-- Name: rate_type_name id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_type_name ALTER COLUMN id SET DEFAULT nextval('public.rate_type_name_id_seq'::regclass);


--
-- Name: rate_type_override id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_type_override ALTER COLUMN id SET DEFAULT nextval('public.rate_type_override_id_seq'::regclass);


--
-- Name: rate_type_override_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_type_override_record ALTER COLUMN record_id SET DEFAULT nextval('public.rate_type_override_record_record_id_seq'::regclass);


--
-- Name: rate_upload_task id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_upload_task ALTER COLUMN id SET DEFAULT nextval('public.rate_upload_task_id_seq'::regclass);


--
-- Name: rate_upload_template id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_upload_template ALTER COLUMN id SET DEFAULT nextval('public.rate_upload_template_id_seq'::regclass);


--
-- Name: rate_upload_values id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_upload_values ALTER COLUMN id SET DEFAULT nextval('public.rate_upload_values_id_seq'::regclass);


--
-- Name: register_of_record id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.register_of_record ALTER COLUMN id SET DEFAULT nextval('public.register_of_record_id_seq'::regclass);


--
-- Name: release_cause_string id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.release_cause_string ALTER COLUMN id SET DEFAULT nextval('public.release_cause_string_id_seq'::regclass);


--
-- Name: report_template id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.report_template ALTER COLUMN id SET DEFAULT nextval('public.report_template_id_seq'::regclass);


--
-- Name: rerate_cdr_download_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rerate_cdr_download_log ALTER COLUMN id SET DEFAULT nextval('public.rerate_cdr_download_log_id_seq'::regclass);


--
-- Name: rerate_cdr_task id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rerate_cdr_task ALTER COLUMN id SET DEFAULT nextval('public.rerate_cdr_task_id_seq'::regclass);


--
-- Name: rerate_report_exec_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rerate_report_exec_log ALTER COLUMN id SET DEFAULT nextval('public.rerate_report_exec_log_id_seq'::regclass);


--
-- Name: resource resource_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource ALTER COLUMN resource_id SET DEFAULT nextval('public.resource_resource_id_seq'::regclass);


--
-- Name: resource_block res_block_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_block ALTER COLUMN res_block_id SET DEFAULT nextval('public.resource_block_res_block_id_seq'::regclass);


--
-- Name: resource_block_items id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_block_items ALTER COLUMN id SET DEFAULT nextval('public.resource_block_items_id_seq'::regclass);


--
-- Name: resource_block_items_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_block_items_record ALTER COLUMN record_id SET DEFAULT nextval('public.resource_block_items_record_record_id_seq'::regclass);


--
-- Name: resource_block_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_block_record ALTER COLUMN record_id SET DEFAULT nextval('public.resource_block_record_record_id_seq'::regclass);


--
-- Name: resource_capacity_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_capacity_record ALTER COLUMN record_id SET DEFAULT nextval('public.resource_capacity_record_record_id_seq'::regclass);


--
-- Name: resource_cid_block_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_cid_block_log ALTER COLUMN id SET DEFAULT nextval('public.resource_cid_block_log_id_seq'::regclass);


--
-- Name: resource_codecs_ref id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_codecs_ref ALTER COLUMN id SET DEFAULT nextval('public.resource_codecs_ref_id_seq'::regclass);


--
-- Name: resource_codecs_ref_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_codecs_ref_record ALTER COLUMN record_id SET DEFAULT nextval('public.resource_codecs_ref_record_record_id_seq'::regclass);


--
-- Name: resource_direction direction_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_direction ALTER COLUMN direction_id SET DEFAULT nextval('public.resource_direction_direction_id_seq'::regclass);


--
-- Name: resource_direction_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_direction_record ALTER COLUMN record_id SET DEFAULT nextval('public.resource_direction_record_record_id_seq'::regclass);


--
-- Name: resource_ext resource_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_ext ALTER COLUMN resource_id SET DEFAULT nextval('public.resource_ext_resource_id_seq'::regclass);


--
-- Name: resource_ip resource_ip_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_ip ALTER COLUMN resource_ip_id SET DEFAULT nextval('public.resource_ip_resource_ip_id_seq'::regclass);


--
-- Name: resource_ip_limit limit_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_ip_limit ALTER COLUMN limit_id SET DEFAULT nextval('public.resource_ip_limit_limit_id_seq'::regclass);


--
-- Name: resource_ip_limit_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_ip_limit_record ALTER COLUMN record_id SET DEFAULT nextval('public.resource_ip_limit_record_record_id_seq'::regclass);


--
-- Name: resource_ip_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_ip_record ALTER COLUMN record_id SET DEFAULT nextval('public.resource_ip_record_record_id_seq'::regclass);


--
-- Name: resource_lrn_action id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_lrn_action ALTER COLUMN id SET DEFAULT nextval('public.resource_lrn_action_id_seq'::regclass);


--
-- Name: resource_lrn_action_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_lrn_action_record ALTER COLUMN record_id SET DEFAULT nextval('public.resource_lrn_action_record_record_id_seq'::regclass);


--
-- Name: resource_next_route_rule id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_next_route_rule ALTER COLUMN id SET DEFAULT nextval('public.resource_next_route_rule_id_seq'::regclass);


--
-- Name: resource_next_route_rule_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_next_route_rule_record ALTER COLUMN record_id SET DEFAULT nextval('public.resource_next_route_rule_record_record_id_seq'::regclass);


--
-- Name: resource_prefix id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_prefix ALTER COLUMN id SET DEFAULT nextval('public.resource_prefix_id_seq'::regclass);


--
-- Name: resource_prefix_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_prefix_record ALTER COLUMN record_id SET DEFAULT nextval('public.resource_prefix_record_record_id_seq'::regclass);


--
-- Name: resource_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_record ALTER COLUMN record_id SET DEFAULT nextval('public.resource_record_record_id_seq'::regclass);


--
-- Name: resource_replace_action id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_replace_action ALTER COLUMN id SET DEFAULT nextval('public.resource_replace_action_id_seq'::regclass);


--
-- Name: resource_replace_action_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_replace_action_record ALTER COLUMN record_id SET DEFAULT nextval('public.resource_replace_action_record_record_id_seq'::regclass);


--
-- Name: resource_template resource_template_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_template ALTER COLUMN resource_template_id SET DEFAULT nextval('public.resource_template_resource_template_id_seq'::regclass);


--
-- Name: resource_translation_ref ref_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_translation_ref ALTER COLUMN ref_id SET DEFAULT nextval('public.resource_translation_ref_ref_id_seq'::regclass);


--
-- Name: resource_translation_ref_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_translation_ref_record ALTER COLUMN record_id SET DEFAULT nextval('public.resource_translation_ref_record_record_id_seq'::regclass);


--
-- Name: retrieve_password_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.retrieve_password_log ALTER COLUMN id SET DEFAULT nextval('public.retrieve_password_log_id_seq'::regclass);


--
-- Name: role role_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.role ALTER COLUMN role_id SET DEFAULT nextval('public.role_role_id_seq'::regclass);


--
-- Name: role_privilege role_privilege_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.role_privilege ALTER COLUMN role_privilege_id SET DEFAULT nextval('public.role_privilege_role_privilege_id_seq'::regclass);


--
-- Name: role_submenu_rel id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.role_submenu_rel ALTER COLUMN id SET DEFAULT nextval('public.role_submenu_rel_id_seq'::regclass);


--
-- Name: route route_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.route ALTER COLUMN route_id SET DEFAULT nextval('public.route_route_id_seq'::regclass);


--
-- Name: route_block id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.route_block ALTER COLUMN id SET DEFAULT nextval('public.route_block_id_seq'::regclass);


--
-- Name: route_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.route_record ALTER COLUMN record_id SET DEFAULT nextval('public.route_record_record_id_seq'::regclass);


--
-- Name: route_strategy route_strategy_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.route_strategy ALTER COLUMN route_strategy_id SET DEFAULT nextval('public.route_strategy_route_strategy_id_seq'::regclass);


--
-- Name: rtp_proxy_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rtp_proxy_log ALTER COLUMN id SET DEFAULT nextval('public.rtp_proxy_log_id_seq'::regclass);


--
-- Name: scheduled_report_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.scheduled_report_log ALTER COLUMN id SET DEFAULT nextval('public.scheduled_report_log_id_seq'::regclass);


--
-- Name: scheduler_log id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.scheduler_log ALTER COLUMN id SET DEFAULT nextval('public.scheduler_log_id_seq'::regclass);


--
-- Name: send_mails id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.send_mails ALTER COLUMN id SET DEFAULT nextval('public.send_mails_id_seq'::regclass);


--
-- Name: send_rate_template id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.send_rate_template ALTER COLUMN id SET DEFAULT nextval('public.send_rate_template_id_seq'::regclass);


--
-- Name: service_charge_items id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.service_charge_items ALTER COLUMN id SET DEFAULT nextval('public.service_charge_items_id_seq'::regclass);


--
-- Name: service_charge_items_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.service_charge_items_record ALTER COLUMN record_id SET DEFAULT nextval('public.service_charge_items_record_record_id_seq'::regclass);


--
-- Name: shaken_ani_group id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group ALTER COLUMN id SET DEFAULT nextval('public.shaken_ani_group_id_seq'::regclass);


--
-- Name: shaken_ani_group_list id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_list ALTER COLUMN id SET DEFAULT nextval('public.shaken_ani_group_list_id_seq'::regclass);


--
-- Name: shaken_ani_group_list_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_list_record ALTER COLUMN record_id SET DEFAULT nextval('public.shaken_ani_group_list_record_record_id_seq'::regclass);


--
-- Name: shaken_ani_group_list_rel id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_list_rel ALTER COLUMN id SET DEFAULT nextval('public.shaken_ani_group_list_rel_id_seq'::regclass);


--
-- Name: shaken_ani_group_list_rel_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_list_rel_record ALTER COLUMN record_id SET DEFAULT nextval('public.shaken_ani_group_list_rel_record_record_id_seq'::regclass);


--
-- Name: shaken_ani_group_rel_import_task id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_rel_import_task ALTER COLUMN id SET DEFAULT nextval('public.shaken_ani_group_rel_import_task_id_seq'::regclass);


--
-- Name: shaken_ani_group_rel_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_rel_record ALTER COLUMN record_id SET DEFAULT nextval('public.shaken_ani_group_rel_record_record_id_seq'::regclass);


--
-- Name: shaken_sti_sp_conf_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_sti_sp_conf_record ALTER COLUMN record_id SET DEFAULT nextval('public.shaken_sti_sp_conf_record_record_id_seq'::regclass);


--
-- Name: signal_capture_filter id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.signal_capture_filter ALTER COLUMN id SET DEFAULT nextval('public.signal_capture_filter_id_seq'::regclass);


--
-- Name: signup id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.signup ALTER COLUMN id SET DEFAULT nextval('public.signup_id_seq'::regclass);


--
-- Name: signup_ip id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.signup_ip ALTER COLUMN id SET DEFAULT nextval('public.signup_ip_id_seq'::regclass);


--
-- Name: sip_error_code sip_error_code_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sip_error_code ALTER COLUMN sip_error_code_id SET DEFAULT nextval('public.sip_error_code_sip_error_code_id_seq'::regclass);


--
-- Name: sip_error_code_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sip_error_code_record ALTER COLUMN record_id SET DEFAULT nextval('public.sip_error_code_record_record_id_seq'::regclass);


--
-- Name: sip_registrations id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sip_registrations ALTER COLUMN id SET DEFAULT nextval('public.sip_registrations_id_seq'::regclass);


--
-- Name: sms id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sms ALTER COLUMN id SET DEFAULT nextval('public.sms_id_seq'::regclass);


--
-- Name: sms_rate id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sms_rate ALTER COLUMN id SET DEFAULT nextval('public.sms_rate_id_seq'::regclass);


--
-- Name: sms_rate_table id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sms_rate_table ALTER COLUMN id SET DEFAULT nextval('public.sms_rate_table_id_seq'::regclass);


--
-- Name: spam_traffic_ip_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.spam_traffic_ip_record ALTER COLUMN record_id SET DEFAULT nextval('public.spam_traffic_ip_record_record_id_seq'::regclass);


--
-- Name: switch_profile id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.switch_profile ALTER COLUMN id SET DEFAULT nextval('public.switch_profile_id_seq'::regclass);


--
-- Name: switch_profile_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.switch_profile_record ALTER COLUMN record_id SET DEFAULT nextval('public.switch_profile_record_record_id_seq'::regclass);


--
-- Name: sys_submenu id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sys_submenu ALTER COLUMN id SET DEFAULT nextval('public.sys_submenu_id_seq'::regclass);


--
-- Name: system_function system_function_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.system_function ALTER COLUMN system_function_id SET DEFAULT nextval('public.system_function_system_function_id_seq'::regclass);


--
-- Name: system_function_group id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.system_function_group ALTER COLUMN id SET DEFAULT nextval('public.system_function_group_id_seq'::regclass);


--
-- Name: system_parameter sys_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.system_parameter ALTER COLUMN sys_id SET DEFAULT nextval('public.system_parameter_sys_id_seq'::regclass);


--
-- Name: termination_global_failover id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.termination_global_failover ALTER COLUMN id SET DEFAULT nextval('public.termination_global_failover_id_seq'::regclass);


--
-- Name: termination_global_failover_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.termination_global_failover_record ALTER COLUMN record_id SET DEFAULT nextval('public.termination_global_failover_record_record_id_seq'::regclass);


--
-- Name: ticket id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ticket ALTER COLUMN id SET DEFAULT nextval('public.ticket_id_seq1'::regclass);


--
-- Name: ticket_history id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ticket_history ALTER COLUMN id SET DEFAULT nextval('public.ticket_history_id_seq'::regclass);


--
-- Name: time_profile time_profile_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.time_profile ALTER COLUMN time_profile_id SET DEFAULT nextval('public.time_profile_time_profile_id_seq'::regclass);


--
-- Name: time_profile_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.time_profile_record ALTER COLUMN record_id SET DEFAULT nextval('public.time_profile_record_record_id_seq'::regclass);


--
-- Name: transaction_fee_items id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.transaction_fee_items ALTER COLUMN id SET DEFAULT nextval('public.transaction_fee_items_id_seq'::regclass);


--
-- Name: transaction_fee_items_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.transaction_fee_items_record ALTER COLUMN record_id SET DEFAULT nextval('public.transaction_fee_items_record_record_id_seq'::regclass);


--
-- Name: translation_item ref_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.translation_item ALTER COLUMN ref_id SET DEFAULT nextval('public.translation_item_ref_id_seq'::regclass);


--
-- Name: translation_item_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.translation_item_record ALTER COLUMN record_id SET DEFAULT nextval('public.translation_item_record_record_id_seq'::regclass);


--
-- Name: trouble_tickets_template id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.trouble_tickets_template ALTER COLUMN id SET DEFAULT nextval('public.trouble_tickets_template_id_seq'::regclass);


--
-- Name: trunk_group group_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.trunk_group ALTER COLUMN group_id SET DEFAULT nextval('public.trunk_group_group_id_seq'::regclass);


--
-- Name: user_auth_ip id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.user_auth_ip ALTER COLUMN id SET DEFAULT nextval('public.user_auth_ip_id_seq'::regclass);


--
-- Name: user_codedeck_alerts id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.user_codedeck_alerts ALTER COLUMN id SET DEFAULT nextval('public.user_codedeck_alerts_id_seq'::regclass);


--
-- Name: users user_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.users ALTER COLUMN user_id SET DEFAULT nextval('public.users_user_id_seq'::regclass);


--
-- Name: users_limit id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.users_limit ALTER COLUMN id SET DEFAULT nextval('public.users_limit_id_seq'::regclass);


--
-- Name: version_information id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.version_information ALTER COLUMN id SET DEFAULT nextval('public.version_information_id_seq'::regclass);


--
-- Name: voip_gateway id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.voip_gateway ALTER COLUMN id SET DEFAULT nextval('public.voip_gateway_id_seq'::regclass);


--
-- Name: voip_gateway_record record_id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.voip_gateway_record ALTER COLUMN record_id SET DEFAULT nextval('public.voip_gateway_record_record_id_seq'::regclass);


--
-- Name: web_session id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.web_session ALTER COLUMN id SET DEFAULT nextval('public.web_session_id_seq'::regclass);


--
-- Name: webhook id; Type: DEFAULT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.webhook ALTER COLUMN id SET DEFAULT nextval('public.webhook_id_seq'::regclass);


--
-- Name: agent agent_agent_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent
    ADD CONSTRAINT agent_agent_name_key UNIQUE (agent_name);


--
-- Name: agent_client_client agent_client_client_client_id_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_client_client
    ADD CONSTRAINT agent_client_client_client_id_key UNIQUE (client_id);


--
-- Name: agent_client_client agent_client_client_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_client_client
    ADD CONSTRAINT agent_client_client_pkey PRIMARY KEY (id);


--
-- Name: agent_client_client_record agent_client_client_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_client_client_record
    ADD CONSTRAINT agent_client_client_record_pkey PRIMARY KEY (record_id);


--
-- Name: agent_clients agent_clients_agent_id_client_id_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_clients
    ADD CONSTRAINT agent_clients_agent_id_client_id_key UNIQUE (agent_id, client_id);


--
-- Name: agent_clients agent_clients_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_clients
    ADD CONSTRAINT agent_clients_pkey PRIMARY KEY (id);


--
-- Name: agent_commission_history_detail agent_commission_history_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_commission_history_detail
    ADD CONSTRAINT agent_commission_history_detail_pkey PRIMARY KEY (id);


--
-- Name: agent_commission_history agent_commission_history_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_commission_history
    ADD CONSTRAINT agent_commission_history_pkey PRIMARY KEY (history_id);


--
-- Name: agent_commission_payment agent_commission_payment_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_commission_payment
    ADD CONSTRAINT agent_commission_payment_pkey PRIMARY KEY (id);


--
-- Name: agent agent_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent
    ADD CONSTRAINT agent_pkey PRIMARY KEY (agent_id);


--
-- Name: alembic_version alembic_version_pkc; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.alembic_version
    ADD CONSTRAINT alembic_version_pkc PRIMARY KEY (version_num);


--
-- Name: alert_rules_log_detail alert_rules_log_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.alert_rules_log_detail
    ADD CONSTRAINT alert_rules_log_detail_pkey PRIMARY KEY (id);


--
-- Name: alert_rules_log alert_rules_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.alert_rules_log
    ADD CONSTRAINT alert_rules_log_pkey PRIMARY KEY (id);


--
-- Name: alert_rules alert_rules_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.alert_rules
    ADD CONSTRAINT alert_rules_pkey PRIMARY KEY (id);


--
-- Name: alert_rules alert_rules_rule_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.alert_rules
    ADD CONSTRAINT alert_rules_rule_name_key UNIQUE (rule_name);


--
-- Name: allowed_sendto_ip_record allowed_sendto_ip_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.allowed_sendto_ip_record
    ADD CONSTRAINT allowed_sendto_ip_record_pkey PRIMARY KEY (record_id);


--
-- Name: async_ftp_export async_ftp_export_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.async_ftp_export
    ADD CONSTRAINT async_ftp_export_pkey PRIMARY KEY (request_id);


--
-- Name: auth_token auth_token_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.auth_token
    ADD CONSTRAINT auth_token_pkey PRIMARY KEY (id);


--
-- Name: authorization_logs authorization_logs_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.authorization_logs
    ADD CONSTRAINT authorization_logs_pkey PRIMARY KEY (id);


--
-- Name: auto_rate_import_rule auto_rate_import_rule_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.auto_rate_import_rule
    ADD CONSTRAINT auto_rate_import_rule_name_key UNIQUE (name);


--
-- Name: auto_rate_import_rule auto_rate_import_rule_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.auto_rate_import_rule
    ADD CONSTRAINT auto_rate_import_rule_pkey PRIMARY KEY (id);


--
-- Name: balance_daily_reset_task balance_daily_reset_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.balance_daily_reset_task
    ADD CONSTRAINT balance_daily_reset_task_pkey PRIMARY KEY (id);


--
-- Name: balance_history_actual balance_history_actual_date_client_id_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.balance_history_actual
    ADD CONSTRAINT balance_history_actual_date_client_id_key UNIQUE (date, client_id);


--
-- Name: balance_history_actual balance_history_actual_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.balance_history_actual
    ADD CONSTRAINT balance_history_actual_pkey PRIMARY KEY (id);


--
-- Name: balance_history balance_history_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.balance_history
    ADD CONSTRAINT balance_history_pkey PRIMARY KEY (id);


--
-- Name: balance_log balance_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.balance_log
    ADD CONSTRAINT balance_log_pkey PRIMARY KEY (id);


--
-- Name: banned_ip_record banned_ip_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.banned_ip_record
    ADD CONSTRAINT banned_ip_record_pkey PRIMARY KEY (record_id);


--
-- Name: block_log block_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.block_log
    ADD CONSTRAINT block_log_pkey PRIMARY KEY (log_id);


--
-- Name: block_number_import_task block_number_import_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.block_number_import_task
    ADD CONSTRAINT block_number_import_task_pkey PRIMARY KEY (id);


--
-- Name: c4_client_balance c4_client_balance_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_client_balance
    ADD CONSTRAINT c4_client_balance_pkey PRIMARY KEY (id);


--
-- Name: c4_livecall_user c4_livecall_user_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_livecall_user
    ADD CONSTRAINT c4_livecall_user_pkey PRIMARY KEY (id);


--
-- Name: c4_livecall_user_record c4_livecall_user_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_livecall_user_record
    ADD CONSTRAINT c4_livecall_user_record_pkey PRIMARY KEY (record_id);


--
-- Name: c4_lrn c4_lrn_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_lrn
    ADD CONSTRAINT c4_lrn_pkey PRIMARY KEY (id);


--
-- Name: c4_lrn_record c4_lrn_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_lrn_record
    ADD CONSTRAINT c4_lrn_record_pkey PRIMARY KEY (record_id);


--
-- Name: c4_shaken_conf c4_shaken_conf_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_shaken_conf
    ADD CONSTRAINT c4_shaken_conf_pkey PRIMARY KEY (id);


--
-- Name: c4_shaken_conf_record c4_shaken_conf_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_shaken_conf_record
    ADD CONSTRAINT c4_shaken_conf_record_pkey PRIMARY KEY (record_id);


--
-- Name: c4_shaken_status c4_shaken_status_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_shaken_status
    ADD CONSTRAINT c4_shaken_status_pkey PRIMARY KEY (id);


--
-- Name: c4_shaken_status_record c4_shaken_status_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_shaken_status_record
    ADD CONSTRAINT c4_shaken_status_record_pkey PRIMARY KEY (record_id);


--
-- Name: c4_us_lerg c4_us_lerg_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4_us_lerg
    ADD CONSTRAINT c4_us_lerg_pkey PRIMARY KEY (id);


--
-- Name: c4db_version c4db_version_id_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.c4db_version
    ADD CONSTRAINT c4db_version_id_key UNIQUE (id);


--
-- Name: calling_call calling_call_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.calling_call
    ADD CONSTRAINT calling_call_pkey PRIMARY KEY (call_id);


--
-- Name: calling_call calling_call_req_uuid_dst_number_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.calling_call
    ADD CONSTRAINT calling_call_req_uuid_dst_number_key UNIQUE (req_uuid, dst_number);


--
-- Name: calling_queue calling_queue_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.calling_queue
    ADD CONSTRAINT calling_queue_pkey PRIMARY KEY (qid);


--
-- Name: calling_queue calling_queue_req_uuid_call_id_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.calling_queue
    ADD CONSTRAINT calling_queue_req_uuid_call_id_key UNIQUE (req_uuid, call_id);


--
-- Name: calling_request calling_request_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.calling_request
    ADD CONSTRAINT calling_request_pkey PRIMARY KEY (req_uuid);


--
-- Name: calling_track calling_track_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.calling_track
    ADD CONSTRAINT calling_track_pkey PRIMARY KEY (uuid);


--
-- Name: carrier_group carrier_group_group_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.carrier_group
    ADD CONSTRAINT carrier_group_group_name_key UNIQUE (group_name);


--
-- Name: carrier_group carrier_group_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.carrier_group
    ADD CONSTRAINT carrier_group_pkey PRIMARY KEY (group_id);


--
-- Name: carrier_template_low_bal_config carrier_template_low_bal_config_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.carrier_template_low_bal_config
    ADD CONSTRAINT carrier_template_low_bal_config_pkey PRIMARY KEY (carrier_template_id);


--
-- Name: carrier_template carrier_template_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.carrier_template
    ADD CONSTRAINT carrier_template_pkey PRIMARY KEY (id);


--
-- Name: carrier_template carrier_template_template_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.carrier_template
    ADD CONSTRAINT carrier_template_template_name_key UNIQUE (template_name);


--
-- Name: cdr_async_task cdr_async_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_async_task
    ADD CONSTRAINT cdr_async_task_pkey PRIMARY KEY (request_id);


--
-- Name: cdr_download_task cdr_download_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_download_task
    ADD CONSTRAINT cdr_download_task_pkey PRIMARY KEY (request_id);


--
-- Name: cdr_export_email_task cdr_export_email_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_export_email_task
    ADD CONSTRAINT cdr_export_email_task_pkey PRIMARY KEY (id);


--
-- Name: cdr_export_log cdr_export_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_export_log
    ADD CONSTRAINT cdr_export_log_pkey PRIMARY KEY (id);


--
-- Name: cdr_export_task cdr_export_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_export_task
    ADD CONSTRAINT cdr_export_task_pkey PRIMARY KEY (id);


--
-- Name: cdr_rerate cdr_rerate_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_rerate
    ADD CONSTRAINT cdr_rerate_pkey PRIMARY KEY (id);


--
-- Name: invoice_log class4_fkey_invoice_log_id; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_log
    ADD CONSTRAINT class4_fkey_invoice_log_id PRIMARY KEY (id);


--
-- Name: code class4_pkey_code_id; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.code
    ADD CONSTRAINT class4_pkey_code_id PRIMARY KEY (code_id);


--
-- Name: dynamic_route_override class4_pkey_dynamic_route_override_id; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_override
    ADD CONSTRAINT class4_pkey_dynamic_route_override_id PRIMARY KEY (id);


--
-- Name: invoice_email class4_pkey_invoice_email_id; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_email
    ADD CONSTRAINT class4_pkey_invoice_email_id PRIMARY KEY (id);


--
-- Name: client_balance_operation_action client_balance_operation_action_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_balance_operation_action
    ADD CONSTRAINT client_balance_operation_action_pkey PRIMARY KEY (id);


--
-- Name: client_balance client_balance_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_balance
    ADD CONSTRAINT client_balance_pkey PRIMARY KEY (client_id);


--
-- Name: client_default_ip client_default_ip_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_default_ip
    ADD CONSTRAINT client_default_ip_pkey PRIMARY KEY (id);


--
-- Name: client_did_product client_did_product_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_did_product
    ADD CONSTRAINT client_did_product_pkey PRIMARY KEY (client_id);


--
-- Name: client_invoice_settings client_invoice_settings_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_invoice_settings
    ADD CONSTRAINT client_invoice_settings_pkey PRIMARY KEY (id);


--
-- Name: client client_login_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client
    ADD CONSTRAINT client_login_key UNIQUE (login);


--
-- Name: client_low_balance_config client_low_balance_config_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_low_balance_config
    ADD CONSTRAINT client_low_balance_config_pkey PRIMARY KEY (client_id);


--
-- Name: client_payment client_payment_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_payment
    ADD CONSTRAINT client_payment_pkey PRIMARY KEY (client_payment_id);


--
-- Name: client client_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client
    ADD CONSTRAINT client_pkey PRIMARY KEY (client_id);


--
-- Name: client_rate_generation client_rate_generation_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_rate_generation
    ADD CONSTRAINT client_rate_generation_pkey PRIMARY KEY (id);


--
-- Name: client_record client_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_record
    ADD CONSTRAINT client_record_pkey PRIMARY KEY (record_id);


--
-- Name: client_taxes client_taxes_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_taxes
    ADD CONSTRAINT client_taxes_pkey PRIMARY KEY (id);


--
-- Name: code_country code_country_country_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.code_country
    ADD CONSTRAINT code_country_country_key UNIQUE (country);


--
-- Name: code_country code_country_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.code_country
    ADD CONSTRAINT code_country_pkey PRIMARY KEY (country_code);


--
-- Name: code_deck_import_task code_deck_import_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.code_deck_import_task
    ADD CONSTRAINT code_deck_import_task_pkey PRIMARY KEY (id);


--
-- Name: code_deck code_deck_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.code_deck
    ADD CONSTRAINT code_deck_name_key UNIQUE (name);


--
-- Name: code_deck code_deck_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.code_deck
    ADD CONSTRAINT code_deck_pkey PRIMARY KEY (code_deck_id);


--
-- Name: code_record code_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.code_record
    ADD CONSTRAINT code_record_pkey PRIMARY KEY (record_id);


--
-- Name: codecs codecs_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.codecs
    ADD CONSTRAINT codecs_name_key UNIQUE (name);


--
-- Name: codecs codecs_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.codecs
    ADD CONSTRAINT codecs_pkey PRIMARY KEY (id);


--
-- Name: credit_log credit_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.credit_log
    ADD CONSTRAINT credit_log_pkey PRIMARY KEY (id);


--
-- Name: currency currency_code_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.currency
    ADD CONSTRAINT currency_code_key UNIQUE (code);


--
-- Name: currency currency_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.currency
    ADD CONSTRAINT currency_pkey PRIMARY KEY (currency_id);


--
-- Name: currency_record currency_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.currency_record
    ADD CONSTRAINT currency_record_pkey PRIMARY KEY (record_id);


--
-- Name: currency_updates currency_updates_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.currency_updates
    ADD CONSTRAINT currency_updates_pkey PRIMARY KEY (currency_updates_id);


--
-- Name: currency_updates_record currency_updates_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.currency_updates_record
    ADD CONSTRAINT currency_updates_record_pkey PRIMARY KEY (record_id);


--
-- Name: daily_cdr_fields daily_cdr_fields_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.daily_cdr_fields
    ADD CONSTRAINT daily_cdr_fields_pkey PRIMARY KEY (id);


--
-- Name: dashboard_time_option dashboard_time_option_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dashboard_time_option
    ADD CONSTRAINT dashboard_time_option_pkey PRIMARY KEY (id);


--
-- Name: data_clean_management data_clean_management_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.data_clean_management
    ADD CONSTRAINT data_clean_management_pkey PRIMARY KEY (id);


--
-- Name: data_clean_management data_clean_management_tbl_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.data_clean_management
    ADD CONSTRAINT data_clean_management_tbl_name_key UNIQUE (tbl_name);


--
-- Name: did_assign did_assign_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_assign
    ADD CONSTRAINT did_assign_pkey PRIMARY KEY (number);


--
-- Name: did_assignments_log did_assignments_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_assignments_log
    ADD CONSTRAINT did_assignments_log_pkey PRIMARY KEY (id, created_at);


--
-- Name: did_assignments did_assignments_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_assignments
    ADD CONSTRAINT did_assignments_pkey PRIMARY KEY (id);


--
-- Name: did_billing_brief did_billing_brief_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_brief
    ADD CONSTRAINT did_billing_brief_pkey PRIMARY KEY (id);


--
-- Name: did_billing_operation_action did_billing_operation_action_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_operation_action
    ADD CONSTRAINT did_billing_operation_action_pkey PRIMARY KEY (id);


--
-- Name: did_billing_plan did_billing_plan_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_plan
    ADD CONSTRAINT did_billing_plan_name_key UNIQUE (name);


--
-- Name: did_billing_plan did_billing_plan_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_plan
    ADD CONSTRAINT did_billing_plan_pkey PRIMARY KEY (id);


--
-- Name: did_billing_plan_record did_billing_plan_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_plan_record
    ADD CONSTRAINT did_billing_plan_record_pkey PRIMARY KEY (record_id);


--
-- Name: did_billing_rel did_billing_rel_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_rel
    ADD CONSTRAINT did_billing_rel_pkey PRIMARY KEY (id);


--
-- Name: did_billing_rel_record did_billing_rel_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_rel_record
    ADD CONSTRAINT did_billing_rel_record_pkey PRIMARY KEY (record_id);


--
-- Name: did_charge_detail did_charge_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_charge_detail
    ADD CONSTRAINT did_charge_detail_pkey PRIMARY KEY (id);


--
-- Name: did_client_log did_client_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_client_log
    ADD CONSTRAINT did_client_log_pkey PRIMARY KEY (id);


--
-- Name: did_cost_detail did_cost_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_cost_detail
    ADD CONSTRAINT did_cost_detail_pkey PRIMARY KEY (id);


--
-- Name: did_disconnect_task did_disconnect_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_disconnect_task
    ADD CONSTRAINT did_disconnect_task_pkey PRIMARY KEY (id);


--
-- Name: did_export_async_task did_export_async_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_export_async_task
    ADD CONSTRAINT did_export_async_task_pkey PRIMARY KEY (id);


--
-- Name: did_invoice_charge_breakdown did_invoice_charge_breakdown_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_invoice_charge_breakdown
    ADD CONSTRAINT did_invoice_charge_breakdown_pkey PRIMARY KEY (id);


--
-- Name: did_invoice_charge_detail did_invoice_charge_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_invoice_charge_detail
    ADD CONSTRAINT did_invoice_charge_detail_pkey PRIMARY KEY (id);


--
-- Name: did_invoice_port_charge did_invoice_port_charge_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_invoice_port_charge
    ADD CONSTRAINT did_invoice_port_charge_pkey PRIMARY KEY (id);


--
-- Name: did_number_assign_task did_number_assign_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_number_assign_task
    ADD CONSTRAINT did_number_assign_task_pkey PRIMARY KEY (id);


--
-- Name: did_number_delete_task did_number_delete_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_number_delete_task
    ADD CONSTRAINT did_number_delete_task_pkey PRIMARY KEY (id);


--
-- Name: did_number_upload did_number_upload_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_number_upload
    ADD CONSTRAINT did_number_upload_pkey PRIMARY KEY (uuid);


--
-- Name: did_param did_param_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_param
    ADD CONSTRAINT did_param_pkey PRIMARY KEY (did);


--
-- Name: did_product_item did_product_item_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_product_item
    ADD CONSTRAINT did_product_item_pkey PRIMARY KEY (id);


--
-- Name: did_product did_product_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_product
    ADD CONSTRAINT did_product_pkey PRIMARY KEY (id);


--
-- Name: did_repository_log did_repository_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_repository_log
    ADD CONSTRAINT did_repository_log_pkey PRIMARY KEY (id, created_at);


--
-- Name: did_repository did_repository_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_repository
    ADD CONSTRAINT did_repository_pkey PRIMARY KEY (id);


--
-- Name: did_transaction did_transaction_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_transaction
    ADD CONSTRAINT did_transaction_pkey PRIMARY KEY (id, date);


--
-- Name: did_vendor_api did_vendor_api_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_vendor_api
    ADD CONSTRAINT did_vendor_api_pkey PRIMARY KEY (id);


--
-- Name: did_vendor_log did_vendor_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_vendor_log
    ADD CONSTRAINT did_vendor_log_pkey PRIMARY KEY (id);


--
-- Name: digit_translation digit_translation_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.digit_translation
    ADD CONSTRAINT digit_translation_pkey PRIMARY KEY (translation_id);


--
-- Name: digit_translation digit_translation_translation_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.digit_translation
    ADD CONSTRAINT digit_translation_translation_name_key UNIQUE (translation_name);


--
-- Name: disk_management disk_management_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.disk_management
    ADD CONSTRAINT disk_management_pkey PRIMARY KEY (id);


--
-- Name: dnis_type_name dnis_type_name_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnis_type_name
    ADD CONSTRAINT dnis_type_name_name_key UNIQUE (name);


--
-- Name: dnis_type_name dnis_type_name_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnis_type_name
    ADD CONSTRAINT dnis_type_name_pkey PRIMARY KEY (id);


--
-- Name: dnl_cloud_dbman_cfg dnl_cloud_dbman_cfg_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_dbman_cfg
    ADD CONSTRAINT dnl_cloud_dbman_cfg_pkey PRIMARY KEY (server_name);


--
-- Name: dnl_cloud_downloader_cfg dnl_cloud_downloader_cfg_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_downloader_cfg
    ADD CONSTRAINT dnl_cloud_downloader_cfg_pkey PRIMARY KEY (server_name);


--
-- Name: dnl_cloud_ftp_cfg dnl_cloud_ftp_cfg_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_ftp_cfg
    ADD CONSTRAINT dnl_cloud_ftp_cfg_pkey PRIMARY KEY (uuid);


--
-- Name: dnl_cloud_gcloud_cfg dnl_cloud_gcloud_cfg_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_gcloud_cfg
    ADD CONSTRAINT dnl_cloud_gcloud_cfg_pkey PRIMARY KEY (uuid);


--
-- Name: dnl_cloud_log dnl_cloud_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_log
    ADD CONSTRAINT dnl_cloud_log_pkey PRIMARY KEY (id);


--
-- Name: dnl_cloud_search_cfg dnl_cloud_search_cfg_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_search_cfg
    ADD CONSTRAINT dnl_cloud_search_cfg_pkey PRIMARY KEY (server_name);


--
-- Name: dnl_cloud_sftp_cfg dnl_cloud_sftp_cfg_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_sftp_cfg
    ADD CONSTRAINT dnl_cloud_sftp_cfg_pkey PRIMARY KEY (uuid);


--
-- Name: dnl_cloud_status dnl_cloud_status_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_status
    ADD CONSTRAINT dnl_cloud_status_pkey PRIMARY KEY (server_name, instance);


--
-- Name: dnl_cloud_storages dnl_cloud_storages_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_storages
    ADD CONSTRAINT dnl_cloud_storages_pkey PRIMARY KEY (uuid);


--
-- Name: dnl_daily_cdr_cloud_cfg dnl_daily_cdr_cloud_cfg_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_daily_cdr_cloud_cfg
    ADD CONSTRAINT dnl_daily_cdr_cloud_cfg_pkey PRIMARY KEY (param_name);


--
-- Name: dynamic_route_items dynamic_route_items_dynamic_route_id_resource_id_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_items
    ADD CONSTRAINT dynamic_route_items_dynamic_route_id_resource_id_key UNIQUE (dynamic_route_id, resource_id);


--
-- Name: dynamic_route_items dynamic_route_items_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_items
    ADD CONSTRAINT dynamic_route_items_pkey PRIMARY KEY (id);


--
-- Name: dynamic_route_items_record dynamic_route_items_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_items_record
    ADD CONSTRAINT dynamic_route_items_record_pkey PRIMARY KEY (record_id);


--
-- Name: dynamic_route dynamic_route_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route
    ADD CONSTRAINT dynamic_route_name_key UNIQUE (name);


--
-- Name: dynamic_route_override_record dynamic_route_override_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_override_record
    ADD CONSTRAINT dynamic_route_override_record_pkey PRIMARY KEY (record_id);


--
-- Name: dynamic_route dynamic_route_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route
    ADD CONSTRAINT dynamic_route_pkey PRIMARY KEY (dynamic_route_id);


--
-- Name: dynamic_route_pri dynamic_route_pri_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_pri
    ADD CONSTRAINT dynamic_route_pri_pkey PRIMARY KEY (id);


--
-- Name: dynamic_route_pri_record dynamic_route_pri_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_pri_record
    ADD CONSTRAINT dynamic_route_pri_record_pkey PRIMARY KEY (record_id);


--
-- Name: dynamic_route_qos dynamic_route_qos_digits_unique; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_qos
    ADD CONSTRAINT dynamic_route_qos_digits_unique UNIQUE (dynamic_route_id, digits);


--
-- Name: dynamic_route_qos dynamic_route_qos_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_qos
    ADD CONSTRAINT dynamic_route_qos_pkey PRIMARY KEY (id);


--
-- Name: dynamic_route_qos_record dynamic_route_qos_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_qos_record
    ADD CONSTRAINT dynamic_route_qos_record_pkey PRIMARY KEY (record_id);


--
-- Name: dynamic_route_record dynamic_route_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_record
    ADD CONSTRAINT dynamic_route_record_pkey PRIMARY KEY (record_id);


--
-- Name: egress_error_string egress_error_string_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.egress_error_string
    ADD CONSTRAINT egress_error_string_pkey PRIMARY KEY (id);


--
-- Name: egress_profile egress_profile_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.egress_profile
    ADD CONSTRAINT egress_profile_pkey PRIMARY KEY (id);


--
-- Name: egress_profile_record egress_profile_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.egress_profile_record
    ADD CONSTRAINT egress_profile_record_pkey PRIMARY KEY (record_id);


--
-- Name: email_log email_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.email_log
    ADD CONSTRAINT email_log_pkey PRIMARY KEY (id);


--
-- Name: execution_log execution_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.execution_log
    ADD CONSTRAINT execution_log_pkey PRIMARY KEY (id);


--
-- Name: fault_route_alert_rule_log fault_route_alert_rule_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fault_route_alert_rule_log
    ADD CONSTRAINT fault_route_alert_rule_log_pkey PRIMARY KEY (id);


--
-- Name: fault_route_alert_rule fault_route_alert_rule_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fault_route_alert_rule
    ADD CONSTRAINT fault_route_alert_rule_pkey PRIMARY KEY (id);


--
-- Name: fault_route_alert_rule fault_route_alert_rule_rule_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fault_route_alert_rule
    ADD CONSTRAINT fault_route_alert_rule_rule_name_key UNIQUE (rule_name);


--
-- Name: file file_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.file
    ADD CONSTRAINT file_pkey PRIMARY KEY (uuid);


--
-- Name: fraud_detection_log_detail fraud_detection_log_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fraud_detection_log_detail
    ADD CONSTRAINT fraud_detection_log_detail_pkey PRIMARY KEY (id);


--
-- Name: fraud_detection_log fraud_detection_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fraud_detection_log
    ADD CONSTRAINT fraud_detection_log_pkey PRIMARY KEY (id);


--
-- Name: fraud_detection fraud_detection_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fraud_detection
    ADD CONSTRAINT fraud_detection_pkey PRIMARY KEY (id);


--
-- Name: fraud_detection fraud_detection_rule_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fraud_detection
    ADD CONSTRAINT fraud_detection_rule_name_key UNIQUE (rule_name);


--
-- Name: frund_detection_history frund_detection_history_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.frund_detection_history
    ADD CONSTRAINT frund_detection_history_pkey PRIMARY KEY (id);


--
-- Name: frund_detection frund_detection_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.frund_detection
    ADD CONSTRAINT frund_detection_pkey PRIMARY KEY (id);


--
-- Name: ftp_cdr_log_detail ftp_cdr_log_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ftp_cdr_log_detail
    ADD CONSTRAINT ftp_cdr_log_detail_pkey PRIMARY KEY (id);


--
-- Name: ftp_cdr_log ftp_cdr_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ftp_cdr_log
    ADD CONSTRAINT ftp_cdr_log_pkey PRIMARY KEY (id);


--
-- Name: ftp_cdr ftp_cdr_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ftp_cdr
    ADD CONSTRAINT ftp_cdr_pkey PRIMARY KEY (ftp_user);


--
-- Name: ftp_conf ftp_conf_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ftp_conf
    ADD CONSTRAINT ftp_conf_pkey PRIMARY KEY (id);


--
-- Name: ftp_server_log ftp_server_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ftp_server_log
    ADD CONSTRAINT ftp_server_log_pkey PRIMARY KEY (id);


--
-- Name: global_route_error global_route_error_error_code_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.global_route_error
    ADD CONSTRAINT global_route_error_error_code_key UNIQUE (error_code);


--
-- Name: global_route_error global_route_error_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.global_route_error
    ADD CONSTRAINT global_route_error_pkey PRIMARY KEY (id);


--
-- Name: global_route_error_record global_route_error_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.global_route_error_record
    ADD CONSTRAINT global_route_error_record_pkey PRIMARY KEY (record_id);


--
-- Name: import_rate_file_log import_rate_file_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.import_rate_file_log
    ADD CONSTRAINT import_rate_file_log_pkey PRIMARY KEY (id);


--
-- Name: import_rate_log import_rate_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.import_rate_log
    ADD CONSTRAINT import_rate_log_pkey PRIMARY KEY (id);


--
-- Name: import_rate_status import_rate_status_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.import_rate_status
    ADD CONSTRAINT import_rate_status_pkey PRIMARY KEY (id);


--
-- Name: import_target_log import_target_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.import_target_log
    ADD CONSTRAINT import_target_log_pkey PRIMARY KEY (id);


--
-- Name: ingress_did_repository ingress_did_repository_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ingress_did_repository
    ADD CONSTRAINT ingress_did_repository_pkey PRIMARY KEY (number);


--
-- Name: invoice_cdr_log invoice_cdr_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_cdr_log
    ADD CONSTRAINT invoice_cdr_log_pkey PRIMARY KEY (id);


--
-- Name: invoice_debug invoice_debug_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_debug
    ADD CONSTRAINT invoice_debug_pkey PRIMARY KEY (id);


--
-- Name: invoice_history invoice_history_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_history
    ADD CONSTRAINT invoice_history_pkey PRIMARY KEY (id);


--
-- Name: invoice invoice_invoice_number_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice
    ADD CONSTRAINT invoice_invoice_number_key UNIQUE (invoice_number);


--
-- Name: invoice_payment invoice_payment_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_payment
    ADD CONSTRAINT invoice_payment_pkey PRIMARY KEY (id);


--
-- Name: invoice invoice_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice
    ADD CONSTRAINT invoice_pkey PRIMARY KEY (invoice_id);


--
-- Name: invoice_settings invoice_settings_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_settings
    ADD CONSTRAINT invoice_settings_pkey PRIMARY KEY (id);


--
-- Name: invoice_summary invoice_summary_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_summary
    ADD CONSTRAINT invoice_summary_pkey PRIMARY KEY (invoice_number);


--
-- Name: invoice_task invoice_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_task
    ADD CONSTRAINT invoice_task_pkey PRIMARY KEY (id);


--
-- Name: ip_modif_log ip_modif_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ip_modif_log
    ADD CONSTRAINT ip_modif_log_pkey PRIMARY KEY (id);


--
-- Name: jur_type_name jur_type_name_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.jur_type_name
    ADD CONSTRAINT jur_type_name_name_key UNIQUE (name);


--
-- Name: jur_type_name jur_type_name_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.jur_type_name
    ADD CONSTRAINT jur_type_name_pkey PRIMARY KEY (id);


--
-- Name: jurisdiction_prefix jurisdiction_prefix_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.jurisdiction_prefix
    ADD CONSTRAINT jurisdiction_prefix_pkey PRIMARY KEY (id);


--
-- Name: jurisdiction_prefix_record jurisdiction_prefix_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.jurisdiction_prefix_record
    ADD CONSTRAINT jurisdiction_prefix_record_pkey PRIMARY KEY (record_id);


--
-- Name: jurisdiction_update_log jurisdiction_update_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.jurisdiction_update_log
    ADD CONSTRAINT jurisdiction_update_log_pkey PRIMARY KEY (id);


--
-- Name: kill_pg_sql_log kill_pg_sql_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.kill_pg_sql_log
    ADD CONSTRAINT kill_pg_sql_log_pkey PRIMARY KEY (id);


--
-- Name: lcr_task lcr_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_task
    ADD CONSTRAINT lcr_task_pkey PRIMARY KEY (task_id);


--
-- Name: lcr_test_log lcr_test_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test_log
    ADD CONSTRAINT lcr_test_log_pkey PRIMARY KEY (id);


--
-- Name: lcr_test lcr_test_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test
    ADD CONSTRAINT lcr_test_name_key UNIQUE (name);


--
-- Name: lcr_test lcr_test_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test
    ADD CONSTRAINT lcr_test_pkey PRIMARY KEY (id);


--
-- Name: lerg_download_schedule lerg_download_schedule_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lerg_download_schedule
    ADD CONSTRAINT lerg_download_schedule_pkey PRIMARY KEY (id);


--
-- Name: lerg_download_task lerg_download_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lerg_download_task
    ADD CONSTRAINT lerg_download_task_pkey PRIMARY KEY (uuid);


--
-- Name: lerg_import_task lerg_import_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lerg_import_task
    ADD CONSTRAINT lerg_import_task_pkey PRIMARY KEY (uuid);


--
-- Name: lerg lerg_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lerg
    ADD CONSTRAINT lerg_pkey PRIMARY KEY (uuid);


--
-- Name: loop_detection_detail loop_detection_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.loop_detection_detail
    ADD CONSTRAINT loop_detection_detail_pkey PRIMARY KEY (id);


--
-- Name: loop_detection_detail loop_detection_detail_resource_id_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.loop_detection_detail
    ADD CONSTRAINT loop_detection_detail_resource_id_key UNIQUE (resource_id);


--
-- Name: loop_detection loop_detection_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.loop_detection
    ADD CONSTRAINT loop_detection_pkey PRIMARY KEY (id);


--
-- Name: mail_cdr_log_detail mail_cdr_log_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.mail_cdr_log_detail
    ADD CONSTRAINT mail_cdr_log_detail_pkey PRIMARY KEY (id);


--
-- Name: mail_cdr_log mail_cdr_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.mail_cdr_log
    ADD CONSTRAINT mail_cdr_log_pkey PRIMARY KEY (id);


--
-- Name: mail_sender mail_sender_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.mail_sender
    ADD CONSTRAINT mail_sender_name_key UNIQUE (name);


--
-- Name: mail_sender mail_sender_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.mail_sender
    ADD CONSTRAINT mail_sender_pkey PRIMARY KEY (id);


--
-- Name: mail_template mail_template_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.mail_template
    ADD CONSTRAINT mail_template_pkey PRIMARY KEY (title);


--
-- Name: media_asr_filter media_asr_filter_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.media_asr_filter
    ADD CONSTRAINT media_asr_filter_pkey PRIMARY KEY (id);


--
-- Name: media_capture_filter media_capture_filter_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.media_capture_filter
    ADD CONSTRAINT media_capture_filter_pkey PRIMARY KEY (id);


--
-- Name: modif_log modif_log_id; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.modif_log
    ADD CONSTRAINT modif_log_id PRIMARY KEY (id);


--
-- Name: monitored_rule_history monitored_rule_history_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.monitored_rule_history
    ADD CONSTRAINT monitored_rule_history_pkey PRIMARY KEY (id);


--
-- Name: monitored_rule monitored_rule_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.monitored_rule
    ADD CONSTRAINT monitored_rule_pkey PRIMARY KEY (id);


--
-- Name: object_revision object_revision_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.object_revision
    ADD CONSTRAINT object_revision_pkey PRIMARY KEY (id);


--
-- Name: object_revision_record object_revision_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.object_revision_record
    ADD CONSTRAINT object_revision_record_pkey PRIMARY KEY (id);


--
-- Name: ocn_blocklist ocn_blocklist_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ocn_blocklist
    ADD CONSTRAINT ocn_blocklist_pkey PRIMARY KEY (id);


--
-- Name: ocn_blocklist_record ocn_blocklist_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ocn_blocklist_record
    ADD CONSTRAINT ocn_blocklist_record_pkey PRIMARY KEY (record_id);


--
-- Name: orig_log orig_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.orig_log
    ADD CONSTRAINT orig_log_pkey PRIMARY KEY (log_id);


--
-- Name: origination_global_failover_record origination_global_failover_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.origination_global_failover_record
    ADD CONSTRAINT origination_global_failover_record_pkey PRIMARY KEY (record_id);


--
-- Name: partition_gateway_ref_record partition_gateway_ref_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.partition_gateway_ref_record
    ADD CONSTRAINT partition_gateway_ref_record_pkey PRIMARY KEY (record_id);


--
-- Name: payment_gateway_history payment_gateway_history_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.payment_gateway_history
    ADD CONSTRAINT payment_gateway_history_pkey PRIMARY KEY (id);


--
-- Name: payment_invoice payment_invoice_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.payment_invoice
    ADD CONSTRAINT payment_invoice_pkey PRIMARY KEY (id);


--
-- Name: payment_term payment_term_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.payment_term
    ADD CONSTRAINT payment_term_name_key UNIQUE (name);


--
-- Name: payment_term payment_term_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.payment_term
    ADD CONSTRAINT payment_term_pkey PRIMARY KEY (payment_term_id);


--
-- Name: payment_term_record payment_term_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.payment_term_record
    ADD CONSTRAINT payment_term_record_pkey PRIMARY KEY (record_id);


--
-- Name: pcap_query pcap_query_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.pcap_query
    ADD CONSTRAINT pcap_query_pkey PRIMARY KEY (query_key);


--
-- Name: pcap_query_task_mail pcap_query_task_mail_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.pcap_query_task_mail
    ADD CONSTRAINT pcap_query_task_mail_pkey PRIMARY KEY (id);


--
-- Name: pcap_query_task pcap_query_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.pcap_query_task
    ADD CONSTRAINT pcap_query_task_pkey PRIMARY KEY (id);


--
-- Name: product_agents_ref product_agents_ref_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_agents_ref
    ADD CONSTRAINT product_agents_ref_pkey PRIMARY KEY (id);


--
-- Name: product_clients_ref product_clients_ref_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_clients_ref
    ADD CONSTRAINT product_clients_ref_pkey PRIMARY KEY (id);


--
-- Name: product_clients_ref product_clients_ref_product_id_client_id_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_clients_ref
    ADD CONSTRAINT product_clients_ref_product_id_client_id_key UNIQUE (product_id, client_id);


--
-- Name: product_clients_ref_used product_clients_ref_used_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_clients_ref_used
    ADD CONSTRAINT product_clients_ref_used_pkey PRIMARY KEY (id);


--
-- Name: product_clients_ref_used product_clients_ref_used_product_id_client_id_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_clients_ref_used
    ADD CONSTRAINT product_clients_ref_used_product_id_client_id_key UNIQUE (product_id, client_id);


--
-- Name: product_codename product_codename_code_name_product_id_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_codename
    ADD CONSTRAINT product_codename_code_name_product_id_key UNIQUE (code_name, product_id);


--
-- Name: product_codename product_codename_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_codename
    ADD CONSTRAINT product_codename_pkey PRIMARY KEY (item_id);


--
-- Name: product_codename_resource product_codename_resource_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_codename_resource
    ADD CONSTRAINT product_codename_resource_pkey PRIMARY KEY (item_id);


--
-- Name: product_items product_items_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_items
    ADD CONSTRAINT product_items_pkey PRIMARY KEY (item_id);


--
-- Name: product_items product_items_product_id_digits_uni; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_items
    ADD CONSTRAINT product_items_product_id_digits_uni UNIQUE (product_id, digits, time_profile_id);


--
-- Name: product_items_record product_items_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_items_record
    ADD CONSTRAINT product_items_record_pkey PRIMARY KEY (record_id);


--
-- Name: product_items_resource product_items_resource_item_id_resource_id_uni; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_items_resource
    ADD CONSTRAINT product_items_resource_item_id_resource_id_uni UNIQUE (item_id, resource_id);


--
-- Name: product_items_resource product_items_resource_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_items_resource
    ADD CONSTRAINT product_items_resource_pkey PRIMARY KEY (id);


--
-- Name: product_items_resource_record product_items_resource_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_items_resource_record
    ADD CONSTRAINT product_items_resource_record_pkey PRIMARY KEY (record_id);


--
-- Name: product product_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product
    ADD CONSTRAINT product_pkey PRIMARY KEY (product_id);


--
-- Name: product_record product_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_record
    ADD CONSTRAINT product_record_pkey PRIMARY KEY (record_id);


--
-- Name: product_rout_rate_table product_rout_rate_table_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_rout_rate_table
    ADD CONSTRAINT product_rout_rate_table_pkey PRIMARY KEY (id);


--
-- Name: product_rout_rate_table product_rout_rate_table_product_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_rout_rate_table
    ADD CONSTRAINT product_rout_rate_table_product_name_key UNIQUE (product_name);


--
-- Name: product_rout_rate_table_record product_rout_rate_table_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_rout_rate_table_record
    ADD CONSTRAINT product_rout_rate_table_record_pkey PRIMARY KEY (record_id);


--
-- Name: product_route_analysis_log product_route_analysis_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_route_analysis_log
    ADD CONSTRAINT product_route_analysis_log_pkey PRIMARY KEY (id);


--
-- Name: product_route_analysis product_route_analysis_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_route_analysis
    ADD CONSTRAINT product_route_analysis_pkey PRIMARY KEY (uuid);


--
-- Name: random_ani_generation random_ani_generation_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.random_ani_generation
    ADD CONSTRAINT random_ani_generation_pkey PRIMARY KEY (id);


--
-- Name: random_ani_generation_record random_ani_generation_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.random_ani_generation_record
    ADD CONSTRAINT random_ani_generation_record_pkey PRIMARY KEY (record_id);


--
-- Name: random_ani_group random_ani_group_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.random_ani_group
    ADD CONSTRAINT random_ani_group_pkey PRIMARY KEY (id);


--
-- Name: random_ani_group_record random_ani_group_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.random_ani_group_record
    ADD CONSTRAINT random_ani_group_record_pkey PRIMARY KEY (record_id);


--
-- Name: rate_analysis_task rate_analysis_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_analysis_task
    ADD CONSTRAINT rate_analysis_task_pkey PRIMARY KEY (task_id);


--
-- Name: rate_auto_import_mailbox_log rate_auto_import_mailbox_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_auto_import_mailbox_log
    ADD CONSTRAINT rate_auto_import_mailbox_log_pkey PRIMARY KEY (id);


--
-- Name: rate_auto_import_rule_log rate_auto_import_rule_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_auto_import_rule_log
    ADD CONSTRAINT rate_auto_import_rule_log_pkey PRIMARY KEY (id);


--
-- Name: rate_auto_import_rule rate_auto_import_rule_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_auto_import_rule
    ADD CONSTRAINT rate_auto_import_rule_name_key UNIQUE (name);


--
-- Name: rate_auto_import_rule rate_auto_import_rule_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_auto_import_rule
    ADD CONSTRAINT rate_auto_import_rule_pkey PRIMARY KEY (id);


--
-- Name: rate_download_log rate_download_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_download_log
    ADD CONSTRAINT rate_download_log_pkey PRIMARY KEY (id);


--
-- Name: rate_generation_history_detail rate_generation_history_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_history_detail
    ADD CONSTRAINT rate_generation_history_detail_pkey PRIMARY KEY (id);


--
-- Name: rate_generation_history rate_generation_history_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_history
    ADD CONSTRAINT rate_generation_history_pkey PRIMARY KEY (id);


--
-- Name: rate_generation_rate rate_generation_rate_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_rate
    ADD CONSTRAINT rate_generation_rate_pkey PRIMARY KEY (generation_rate_id);


--
-- Name: rate_generation_template_detail rate_generation_template_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_template_detail
    ADD CONSTRAINT rate_generation_template_detail_pkey PRIMARY KEY (id);


--
-- Name: rate_generation_template_margin rate_generation_template_margin_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_template_margin
    ADD CONSTRAINT rate_generation_template_margin_pkey PRIMARY KEY (id);


--
-- Name: rate_generation_template rate_generation_template_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_template
    ADD CONSTRAINT rate_generation_template_pkey PRIMARY KEY (id);


--
-- Name: rate_import_task rate_import_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_import_task
    ADD CONSTRAINT rate_import_task_pkey PRIMARY KEY (id);


--
-- Name: rate_mass_edit_log rate_mass_edit_log_id; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_mass_edit_log
    ADD CONSTRAINT rate_mass_edit_log_id PRIMARY KEY (id);


--
-- Name: rate rate_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate
    ADD CONSTRAINT rate_pkey PRIMARY KEY (rate_id);


--
-- Name: rate rate_rate_table_id_code_effective_date_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate
    ADD CONSTRAINT rate_rate_table_id_code_effective_date_key UNIQUE (rate_table_id, code, effective_date);


--
-- Name: rate_record rate_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_record
    ADD CONSTRAINT rate_record_pkey PRIMARY KEY (record_id);


--
-- Name: rate_send_log_detail rate_send_log_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_send_log_detail
    ADD CONSTRAINT rate_send_log_detail_pkey PRIMARY KEY (id);


--
-- Name: rate_send_log rate_send_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_send_log
    ADD CONSTRAINT rate_send_log_pkey PRIMARY KEY (id);


--
-- Name: rate_table rate_table_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_table
    ADD CONSTRAINT rate_table_name_key UNIQUE (name);


--
-- Name: rate_table rate_table_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_table
    ADD CONSTRAINT rate_table_pkey PRIMARY KEY (rate_table_id);


--
-- Name: rate_table_record rate_table_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_table_record
    ADD CONSTRAINT rate_table_record_pkey PRIMARY KEY (record_id);


--
-- Name: rate_type_name rate_type_name_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_type_name
    ADD CONSTRAINT rate_type_name_name_key UNIQUE (name);


--
-- Name: rate_type_name rate_type_name_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_type_name
    ADD CONSTRAINT rate_type_name_pkey PRIMARY KEY (id);


--
-- Name: rate_type_override rate_type_override_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_type_override
    ADD CONSTRAINT rate_type_override_pkey PRIMARY KEY (id);


--
-- Name: rate_type_override_record rate_type_override_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_type_override_record
    ADD CONSTRAINT rate_type_override_record_pkey PRIMARY KEY (record_id);


--
-- Name: rate_type_override rate_type_override_resource_id_src_country_dest_country_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_type_override
    ADD CONSTRAINT rate_type_override_resource_id_src_country_dest_country_key UNIQUE (resource_id, src_country, dest_country);


--
-- Name: rate_upload_task rate_upload_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_upload_task
    ADD CONSTRAINT rate_upload_task_pkey PRIMARY KEY (id);


--
-- Name: rate_upload_template rate_upload_template_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_upload_template
    ADD CONSTRAINT rate_upload_template_name_key UNIQUE (name);


--
-- Name: rate_upload_template rate_upload_template_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_upload_template
    ADD CONSTRAINT rate_upload_template_pkey PRIMARY KEY (id);


--
-- Name: rate_upload_values rate_upload_values_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_upload_values
    ADD CONSTRAINT rate_upload_values_pkey PRIMARY KEY (id);


--
-- Name: rate_upload_values rate_upload_values_task_id_Code_Effective_date_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_upload_values
    ADD CONSTRAINT "rate_upload_values_task_id_Code_Effective_date_key" UNIQUE (task_id, "Code", "Effective_date");


--
-- Name: register_of_record register_of_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.register_of_record
    ADD CONSTRAINT register_of_record_pkey PRIMARY KEY (id);


--
-- Name: release_cause_string release_cause_string_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.release_cause_string
    ADD CONSTRAINT release_cause_string_pkey PRIMARY KEY (id);


--
-- Name: report_template report_template_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.report_template
    ADD CONSTRAINT report_template_pkey PRIMARY KEY (id);


--
-- Name: rerate_cdr_download_log rerate_cdr_download_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rerate_cdr_download_log
    ADD CONSTRAINT rerate_cdr_download_log_pkey PRIMARY KEY (id);


--
-- Name: rerate_cdr_task rerate_cdr_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rerate_cdr_task
    ADD CONSTRAINT rerate_cdr_task_pkey PRIMARY KEY (id);


--
-- Name: rerate_report_exec_log rerate_report_exec_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rerate_report_exec_log
    ADD CONSTRAINT rerate_report_exec_log_pkey PRIMARY KEY (id);


--
-- Name: resource_block_items resource_block_items_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_block_items
    ADD CONSTRAINT resource_block_items_pkey PRIMARY KEY (id);


--
-- Name: resource_block_items_record resource_block_items_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_block_items_record
    ADD CONSTRAINT resource_block_items_record_pkey PRIMARY KEY (record_id);


--
-- Name: resource_block resource_block_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_block
    ADD CONSTRAINT resource_block_pkey PRIMARY KEY (res_block_id);


--
-- Name: resource_block_record resource_block_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_block_record
    ADD CONSTRAINT resource_block_record_pkey PRIMARY KEY (record_id);


--
-- Name: resource_capacity_record resource_capacity_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_capacity_record
    ADD CONSTRAINT resource_capacity_record_pkey PRIMARY KEY (record_id);


--
-- Name: resource_cid_block_config resource_cid_block_config_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_cid_block_config
    ADD CONSTRAINT resource_cid_block_config_pkey PRIMARY KEY (resource_id);


--
-- Name: resource_cid_block_log resource_cid_block_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_cid_block_log
    ADD CONSTRAINT resource_cid_block_log_pkey PRIMARY KEY (id);


--
-- Name: resource_codecs_ref resource_codecs_ref_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_codecs_ref
    ADD CONSTRAINT resource_codecs_ref_pkey PRIMARY KEY (id);


--
-- Name: resource_codecs_ref_record resource_codecs_ref_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_codecs_ref_record
    ADD CONSTRAINT resource_codecs_ref_record_pkey PRIMARY KEY (record_id);


--
-- Name: resource_direction resource_direction_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_direction
    ADD CONSTRAINT resource_direction_pkey PRIMARY KEY (direction_id);


--
-- Name: resource_direction_record resource_direction_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_direction_record
    ADD CONSTRAINT resource_direction_record_pkey PRIMARY KEY (record_id);


--
-- Name: resource_ext resource_ext_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_ext
    ADD CONSTRAINT resource_ext_pkey PRIMARY KEY (resource_id);


--
-- Name: resource_ip_limit resource_ip_limit_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_ip_limit
    ADD CONSTRAINT resource_ip_limit_pkey PRIMARY KEY (limit_id);


--
-- Name: resource_ip_limit_record resource_ip_limit_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_ip_limit_record
    ADD CONSTRAINT resource_ip_limit_record_pkey PRIMARY KEY (record_id);


--
-- Name: resource_ip resource_ip_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_ip
    ADD CONSTRAINT resource_ip_pkey PRIMARY KEY (resource_ip_id);


--
-- Name: resource_ip_record resource_ip_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_ip_record
    ADD CONSTRAINT resource_ip_record_pkey PRIMARY KEY (record_id);


--
-- Name: resource_lrn_action resource_lrn_action_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_lrn_action
    ADD CONSTRAINT resource_lrn_action_pkey PRIMARY KEY (id);


--
-- Name: resource_lrn_action_record resource_lrn_action_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_lrn_action_record
    ADD CONSTRAINT resource_lrn_action_record_pkey PRIMARY KEY (record_id);


--
-- Name: resource_next_route_rule resource_next_route_rule_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_next_route_rule
    ADD CONSTRAINT resource_next_route_rule_pkey PRIMARY KEY (id);


--
-- Name: resource_next_route_rule_record resource_next_route_rule_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_next_route_rule_record
    ADD CONSTRAINT resource_next_route_rule_record_pkey PRIMARY KEY (record_id);


--
-- Name: resource_next_route_rule resource_next_route_rule_reponse_code_resource_id_uni; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_next_route_rule
    ADD CONSTRAINT resource_next_route_rule_reponse_code_resource_id_uni UNIQUE (reponse_code, resource_id);


--
-- Name: resource resource_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource
    ADD CONSTRAINT resource_pkey PRIMARY KEY (resource_id);


--
-- Name: resource_prefix resource_prefix_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_prefix
    ADD CONSTRAINT resource_prefix_pkey PRIMARY KEY (id);


--
-- Name: resource_prefix_record resource_prefix_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_prefix_record
    ADD CONSTRAINT resource_prefix_record_pkey PRIMARY KEY (record_id);


--
-- Name: resource_prefix resource_prefix_resource_id_tech_prefix_code_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_prefix
    ADD CONSTRAINT resource_prefix_resource_id_tech_prefix_code_key UNIQUE (resource_id, tech_prefix, code);


--
-- Name: resource_record resource_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_record
    ADD CONSTRAINT resource_record_pkey PRIMARY KEY (record_id);


--
-- Name: resource_replace_action resource_replace_action_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_replace_action
    ADD CONSTRAINT resource_replace_action_pkey PRIMARY KEY (id);


--
-- Name: resource_replace_action_record resource_replace_action_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_replace_action_record
    ADD CONSTRAINT resource_replace_action_record_pkey PRIMARY KEY (record_id);


--
-- Name: resource_template resource_template_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_template
    ADD CONSTRAINT resource_template_pkey PRIMARY KEY (resource_template_id);


--
-- Name: resource_translation_ref resource_translation_ref_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_translation_ref
    ADD CONSTRAINT resource_translation_ref_pkey PRIMARY KEY (ref_id);


--
-- Name: resource_translation_ref_record resource_translation_ref_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_translation_ref_record
    ADD CONSTRAINT resource_translation_ref_record_pkey PRIMARY KEY (record_id);


--
-- Name: retrieve_password_log retrieve_password_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.retrieve_password_log
    ADD CONSTRAINT retrieve_password_log_pkey PRIMARY KEY (id);


--
-- Name: role role_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.role
    ADD CONSTRAINT role_pkey PRIMARY KEY (role_id);


--
-- Name: role_privilege role_privilege_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.role_privilege
    ADD CONSTRAINT role_privilege_pkey PRIMARY KEY (role_privilege_id);


--
-- Name: role_privilege role_privilege_role_id_system_function_id_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.role_privilege
    ADD CONSTRAINT role_privilege_role_id_system_function_id_key UNIQUE (role_id, system_function_id);


--
-- Name: role role_role_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.role
    ADD CONSTRAINT role_role_name_key UNIQUE (role_name);


--
-- Name: role_submenu_rel role_submenu_rel_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.role_submenu_rel
    ADD CONSTRAINT role_submenu_rel_pkey PRIMARY KEY (id);


--
-- Name: role_submenu_rel role_submenu_rel_role_id_submenu_id_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.role_submenu_rel
    ADD CONSTRAINT role_submenu_rel_role_id_submenu_id_key UNIQUE (role_id, submenu_id);


--
-- Name: route_block route_block_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.route_block
    ADD CONSTRAINT route_block_pkey PRIMARY KEY (id);


--
-- Name: route route_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.route
    ADD CONSTRAINT route_pkey PRIMARY KEY (route_id);


--
-- Name: route_record route_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.route_record
    ADD CONSTRAINT route_record_pkey PRIMARY KEY (record_id);


--
-- Name: route route_route_strategy_id_digits_ani_prefix_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.route
    ADD CONSTRAINT route_route_strategy_id_digits_ani_prefix_key UNIQUE (route_strategy_id, digits, ani_prefix);


--
-- Name: route_strategy route_strategy_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.route_strategy
    ADD CONSTRAINT route_strategy_name_key UNIQUE (name);


--
-- Name: route_strategy route_strategy_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.route_strategy
    ADD CONSTRAINT route_strategy_pkey PRIMARY KEY (route_strategy_id);


--
-- Name: rtp_proxy_log rtp_proxy_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rtp_proxy_log
    ADD CONSTRAINT rtp_proxy_log_pkey PRIMARY KEY (id);


--
-- Name: scheduled_report_log scheduled_report_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.scheduled_report_log
    ADD CONSTRAINT scheduled_report_log_pkey PRIMARY KEY (id);


--
-- Name: scheduler_log scheduler_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.scheduler_log
    ADD CONSTRAINT scheduler_log_pkey PRIMARY KEY (id);


--
-- Name: send_cdr_export_template send_cdr_export_template_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.send_cdr_export_template
    ADD CONSTRAINT send_cdr_export_template_pkey PRIMARY KEY (id);


--
-- Name: send_mails send_mails_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.send_mails
    ADD CONSTRAINT send_mails_pkey PRIMARY KEY (id);


--
-- Name: send_rate_direct send_rate_direct_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.send_rate_direct
    ADD CONSTRAINT send_rate_direct_pkey PRIMARY KEY (id);


--
-- Name: send_rate_template send_rate_template_id; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.send_rate_template
    ADD CONSTRAINT send_rate_template_id PRIMARY KEY (id);


--
-- Name: send_rate_template send_rate_template_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.send_rate_template
    ADD CONSTRAINT send_rate_template_name_key UNIQUE (name);


--
-- Name: service_charge_items service_charge_items_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.service_charge_items
    ADD CONSTRAINT service_charge_items_pkey PRIMARY KEY (id);


--
-- Name: service_charge_items_record service_charge_items_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.service_charge_items_record
    ADD CONSTRAINT service_charge_items_record_pkey PRIMARY KEY (record_id);


--
-- Name: shaken_ani_group_list shaken_ani_group_list_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_list
    ADD CONSTRAINT shaken_ani_group_list_pkey PRIMARY KEY (id);


--
-- Name: shaken_ani_group_list_record shaken_ani_group_list_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_list_record
    ADD CONSTRAINT shaken_ani_group_list_record_pkey PRIMARY KEY (record_id);


--
-- Name: shaken_ani_group_list_rel shaken_ani_group_list_rel_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_list_rel
    ADD CONSTRAINT shaken_ani_group_list_rel_pkey PRIMARY KEY (id);


--
-- Name: shaken_ani_group_list_rel_record shaken_ani_group_list_rel_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_list_rel_record
    ADD CONSTRAINT shaken_ani_group_list_rel_record_pkey PRIMARY KEY (record_id);


--
-- Name: shaken_ani_group shaken_ani_group_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group
    ADD CONSTRAINT shaken_ani_group_pkey PRIMARY KEY (id);


--
-- Name: shaken_ani_group_rel_import_task shaken_ani_group_rel_import_task_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_rel_import_task
    ADD CONSTRAINT shaken_ani_group_rel_import_task_pkey PRIMARY KEY (id);


--
-- Name: shaken_ani_group_rel shaken_ani_group_rel_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_rel
    ADD CONSTRAINT shaken_ani_group_rel_pkey PRIMARY KEY (group_id, did);


--
-- Name: shaken_ani_group_rel_record shaken_ani_group_rel_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_rel_record
    ADD CONSTRAINT shaken_ani_group_rel_record_pkey PRIMARY KEY (record_id);


--
-- Name: shaken_sti_sp_conf shaken_sti_sp_conf_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_sti_sp_conf
    ADD CONSTRAINT shaken_sti_sp_conf_pkey PRIMARY KEY (id);


--
-- Name: shaken_sti_sp_conf_record shaken_sti_sp_conf_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_sti_sp_conf_record
    ADD CONSTRAINT shaken_sti_sp_conf_record_pkey PRIMARY KEY (record_id);


--
-- Name: signal_capture_filter signal_capture_filter_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.signal_capture_filter
    ADD CONSTRAINT signal_capture_filter_pkey PRIMARY KEY (id);


--
-- Name: signup_ip signup_ip_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.signup_ip
    ADD CONSTRAINT signup_ip_pkey PRIMARY KEY (id);


--
-- Name: signup signup_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.signup
    ADD CONSTRAINT signup_pkey PRIMARY KEY (id);


--
-- Name: sip_error_code sip_error_code_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sip_error_code
    ADD CONSTRAINT sip_error_code_pkey PRIMARY KEY (sip_error_code_id);


--
-- Name: sip_error_code_record sip_error_code_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sip_error_code_record
    ADD CONSTRAINT sip_error_code_record_pkey PRIMARY KEY (record_id);


--
-- Name: sip_registrations sip_registrations_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sip_registrations
    ADD CONSTRAINT sip_registrations_pkey PRIMARY KEY (id);


--
-- Name: sms_dlr_hook sms_dlr_hook_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sms_dlr_hook
    ADD CONSTRAINT sms_dlr_hook_pkey PRIMARY KEY (id);


--
-- Name: sms sms_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sms
    ADD CONSTRAINT sms_pkey PRIMARY KEY (id);


--
-- Name: sms_rate sms_rate_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sms_rate
    ADD CONSTRAINT sms_rate_pkey PRIMARY KEY (id);


--
-- Name: sms_rate_table sms_rate_table_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sms_rate_table
    ADD CONSTRAINT sms_rate_table_name_key UNIQUE (name);


--
-- Name: sms_rate_table sms_rate_table_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sms_rate_table
    ADD CONSTRAINT sms_rate_table_pkey PRIMARY KEY (id);


--
-- Name: spam_traffic_ip spam_traffic_ip_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.spam_traffic_ip
    ADD CONSTRAINT spam_traffic_ip_pkey PRIMARY KEY (ip);


--
-- Name: spam_traffic_ip_record spam_traffic_ip_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.spam_traffic_ip_record
    ADD CONSTRAINT spam_traffic_ip_record_pkey PRIMARY KEY (record_id);


--
-- Name: storage_config storage_config_conf_type_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.storage_config
    ADD CONSTRAINT storage_config_conf_type_key UNIQUE (conf_type);


--
-- Name: switch_profile switch_profile_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.switch_profile
    ADD CONSTRAINT switch_profile_pkey PRIMARY KEY (id);


--
-- Name: switch_profile_record switch_profile_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.switch_profile_record
    ADD CONSTRAINT switch_profile_record_pkey PRIMARY KEY (record_id);


--
-- Name: sys_main_menu sys_main_menu_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sys_main_menu
    ADD CONSTRAINT sys_main_menu_pkey PRIMARY KEY (id);


--
-- Name: sys_submenu sys_submenu_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sys_submenu
    ADD CONSTRAINT sys_submenu_pkey PRIMARY KEY (id);


--
-- Name: system_function_group system_function_group_group_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.system_function_group
    ADD CONSTRAINT system_function_group_group_name_key UNIQUE (group_name);


--
-- Name: system_function_group system_function_group_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.system_function_group
    ADD CONSTRAINT system_function_group_pkey PRIMARY KEY (id);


--
-- Name: system_function system_function_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.system_function
    ADD CONSTRAINT system_function_pkey PRIMARY KEY (system_function_id);


--
-- Name: system_parameter system_parameter_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.system_parameter
    ADD CONSTRAINT system_parameter_pkey PRIMARY KEY (sys_id);


--
-- Name: termination_global_failover termination_global_failover_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.termination_global_failover
    ADD CONSTRAINT termination_global_failover_pkey PRIMARY KEY (id);


--
-- Name: termination_global_failover_record termination_global_failover_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.termination_global_failover_record
    ADD CONSTRAINT termination_global_failover_record_pkey PRIMARY KEY (record_id);


--
-- Name: ticket_history ticket_history_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ticket_history
    ADD CONSTRAINT ticket_history_pkey PRIMARY KEY (id);


--
-- Name: ticket ticket_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ticket
    ADD CONSTRAINT ticket_pkey PRIMARY KEY (id);


--
-- Name: ticket_type ticket_type_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ticket_type
    ADD CONSTRAINT ticket_type_pkey PRIMARY KEY (ticket_type);


--
-- Name: time_profile time_profile_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.time_profile
    ADD CONSTRAINT time_profile_name_key UNIQUE (name);


--
-- Name: time_profile time_profile_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.time_profile
    ADD CONSTRAINT time_profile_pkey PRIMARY KEY (time_profile_id);


--
-- Name: time_profile_record time_profile_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.time_profile_record
    ADD CONSTRAINT time_profile_record_pkey PRIMARY KEY (record_id);


--
-- Name: transaction_fee_items transaction_fee_items_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.transaction_fee_items
    ADD CONSTRAINT transaction_fee_items_pkey PRIMARY KEY (id);


--
-- Name: transaction_fee_items_record transaction_fee_items_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.transaction_fee_items_record
    ADD CONSTRAINT transaction_fee_items_record_pkey PRIMARY KEY (record_id);


--
-- Name: translation_item translation_item_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.translation_item
    ADD CONSTRAINT translation_item_pkey PRIMARY KEY (ref_id);


--
-- Name: translation_item_record translation_item_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.translation_item_record
    ADD CONSTRAINT translation_item_record_pkey PRIMARY KEY (record_id);


--
-- Name: trouble_tickets_template trouble_tickets_template_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.trouble_tickets_template
    ADD CONSTRAINT trouble_tickets_template_pkey PRIMARY KEY (id);


--
-- Name: trunk_group trunk_group_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.trunk_group
    ADD CONSTRAINT trunk_group_name_key UNIQUE (group_name);


--
-- Name: trunk_group trunk_group_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.trunk_group
    ADD CONSTRAINT trunk_group_pkey PRIMARY KEY (group_id);


--
-- Name: user_api_key user_api_key_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.user_api_key
    ADD CONSTRAINT user_api_key_pkey PRIMARY KEY (user_id);


--
-- Name: user_auth_ip user_auth_ip_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.user_auth_ip
    ADD CONSTRAINT user_auth_ip_pkey PRIMARY KEY (id);


--
-- Name: user_codedeck_alerts user_codedeck_alerts_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.user_codedeck_alerts
    ADD CONSTRAINT user_codedeck_alerts_pkey PRIMARY KEY (id);


--
-- Name: users_limit users_limit_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.users_limit
    ADD CONSTRAINT users_limit_pkey PRIMARY KEY (id);


--
-- Name: users users_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_name_key UNIQUE (name);


--
-- Name: users users_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_pkey PRIMARY KEY (user_id);


--
-- Name: version_information version_information_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.version_information
    ADD CONSTRAINT version_information_pkey PRIMARY KEY (id);


--
-- Name: voip_gateway_info voip_gateway_info_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.voip_gateway_info
    ADD CONSTRAINT voip_gateway_info_pkey PRIMARY KEY (id);


--
-- Name: voip_gateway voip_gateway_lan_ip_lan_port_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.voip_gateway
    ADD CONSTRAINT voip_gateway_lan_ip_lan_port_key UNIQUE (lan_ip, lan_port);


--
-- Name: voip_gateway voip_gateway_name_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.voip_gateway
    ADD CONSTRAINT voip_gateway_name_key UNIQUE (name);


--
-- Name: voip_gateway voip_gateway_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.voip_gateway
    ADD CONSTRAINT voip_gateway_pkey PRIMARY KEY (id);


--
-- Name: voip_gateway_record voip_gateway_record_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.voip_gateway_record
    ADD CONSTRAINT voip_gateway_record_pkey PRIMARY KEY (record_id);


--
-- Name: watchdog_systemd_events watchdog_systemd_events_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.watchdog_systemd_events
    ADD CONSTRAINT watchdog_systemd_events_pkey PRIMARY KEY (id);


--
-- Name: watchdog_systemd_log watchdog_systemd_log_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.watchdog_systemd_log
    ADD CONSTRAINT watchdog_systemd_log_pkey PRIMARY KEY (id);


--
-- Name: web_session web_session_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.web_session
    ADD CONSTRAINT web_session_pkey PRIMARY KEY (id);


--
-- Name: webhook webhook_client_id_number_key; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.webhook
    ADD CONSTRAINT webhook_client_id_number_key UNIQUE (client_id, number);


--
-- Name: webhook webhook_pkey; Type: CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.webhook
    ADD CONSTRAINT webhook_pkey PRIMARY KEY (id);


--
-- Name: agent_client_client_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX agent_client_client_record_time_idx ON public.agent_client_client_record USING btree ("time");


--
-- Name: allowed_sendto_ip_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX allowed_sendto_ip_record_time_idx ON public.allowed_sendto_ip_record USING btree ("time");


--
-- Name: banned_ip_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX banned_ip_record_time_idx ON public.banned_ip_record USING btree ("time");


--
-- Name: c4_livecall_user_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX c4_livecall_user_record_time_idx ON public.c4_livecall_user_record USING btree ("time");


--
-- Name: c4_lrn_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX c4_lrn_record_time_idx ON public.c4_lrn_record USING btree ("time");


--
-- Name: c4_shaken_conf_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX c4_shaken_conf_record_time_idx ON public.c4_shaken_conf_record USING btree ("time");


--
-- Name: c4_shaken_status_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX c4_shaken_status_record_time_idx ON public.c4_shaken_status_record USING btree ("time");


--
-- Name: c4_us_lerg_npanxx_block_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX c4_us_lerg_npanxx_block_idx ON public.c4_us_lerg USING btree (npa, nxx, block);


--
-- Name: c4_us_lerg_npanxx_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX c4_us_lerg_npanxx_idx ON public.c4_us_lerg USING btree (npa, nxx);


--
-- Name: cdr_report_daily_report_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX cdr_report_daily_report_time_idx ON ONLY public.cdr_report_daily USING btree (report_time);


--
-- Name: class4_idx_code_code_deck_prefix; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX class4_idx_code_code_deck_prefix ON public.code USING btree (code_deck_id, code);


--
-- Name: class4_idx_rate_table_id_code; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX class4_idx_rate_table_id_code ON public.rate USING gist (code, rate_table_id);


--
-- Name: client_cdr_cdr_date_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX client_cdr_cdr_date_idx ON public.client_cdr USING btree (cdr_date);


--
-- Name: client_cdr_origination_destination_number_prefix_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX client_cdr_origination_destination_number_prefix_idx ON public.client_cdr USING gist (((origination_destination_number)::public.prefix_range));


--
-- Name: client_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX client_record_time_idx ON public.client_record USING btree ("time");


--
-- Name: code_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX code_record_time_idx ON public.code_record USING btree ("time");


--
-- Name: code_report_daily_report_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX code_report_daily_report_time_idx ON ONLY public.code_report_daily USING btree (report_time);


--
-- Name: code_report_report_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX code_report_report_time_idx ON ONLY public.code_report USING btree (report_time);


--
-- Name: currency_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX currency_record_time_idx ON public.currency_record USING btree ("time");


--
-- Name: currency_updates_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX currency_updates_record_time_idx ON public.currency_updates_record USING btree ("time");


--
-- Name: did_billing_plan_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX did_billing_plan_record_time_idx ON public.did_billing_plan_record USING btree ("time");


--
-- Name: did_billing_rel_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX did_billing_rel_record_time_idx ON public.did_billing_rel_record USING btree ("time");


--
-- Name: did_transaction_client_id_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX did_transaction_client_id_idx ON ONLY public.did_transaction USING btree (client_id);


--
-- Name: did_transaction_date_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX did_transaction_date_idx ON ONLY public.did_transaction USING btree (date);


--
-- Name: dynamic_route_items_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX dynamic_route_items_record_time_idx ON public.dynamic_route_items_record USING btree ("time");


--
-- Name: dynamic_route_override_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX dynamic_route_override_record_time_idx ON public.dynamic_route_override_record USING btree ("time");


--
-- Name: dynamic_route_pri_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX dynamic_route_pri_record_time_idx ON public.dynamic_route_pri_record USING btree ("time");


--
-- Name: dynamic_route_qos_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX dynamic_route_qos_record_time_idx ON public.dynamic_route_qos_record USING btree ("time");


--
-- Name: dynamic_route_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX dynamic_route_record_time_idx ON public.dynamic_route_record USING btree ("time");


--
-- Name: egress_profile_egress_ingress_profile_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX egress_profile_egress_ingress_profile_idx ON public.egress_profile USING btree (server_name, egress_id, ingress_id);


--
-- Name: egress_profile_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX egress_profile_record_time_idx ON public.egress_profile_record USING btree ("time");


--
-- Name: global_route_error_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX global_route_error_record_time_idx ON public.global_route_error_record USING btree ("time");


--
-- Name: ix_alert_rules_log_detail_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_alert_rules_log_detail_time ON public.alert_rules_log_detail USING btree ("time");


--
-- Name: ix_alert_rules_log_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_alert_rules_log_time ON public.alert_rules_log USING btree ("time");


--
-- Name: ix_auto_rate_import_rule_egress_trunk_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_auto_rate_import_rule_egress_trunk_id ON public.auto_rate_import_rule USING btree (egress_trunk_id);


--
-- Name: ix_balance_history_actual_date; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_balance_history_actual_date ON public.balance_history_actual USING btree (date);


--
-- Name: ix_balance_log_client_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_balance_log_client_id ON public.balance_log USING btree (client_id);


--
-- Name: ix_balance_log_date; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_balance_log_date ON public.balance_log USING btree (date);


--
-- Name: ix_banned_ip_ip; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_banned_ip_ip ON public.banned_ip USING btree (ip);


--
-- Name: ix_c4_client_balance_client_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX ix_c4_client_balance_client_id ON public.c4_client_balance USING btree (client_id);


--
-- Name: ix_c4_livecall_user_name; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_c4_livecall_user_name ON public.c4_livecall_user USING btree (name);


--
-- Name: ix_c4_us_lerg_country; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_c4_us_lerg_country ON public.c4_us_lerg USING btree (country);


--
-- Name: ix_c4_us_lerg_lata; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_c4_us_lerg_lata ON public.c4_us_lerg USING btree (lata);


--
-- Name: ix_c4_us_lerg_ocn; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_c4_us_lerg_ocn ON public.c4_us_lerg USING btree (ocn);


--
-- Name: ix_c4_us_lerg_state; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_c4_us_lerg_state ON public.c4_us_lerg USING btree (state);


--
-- Name: ix_client_balance_operation_action_client_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_client_balance_operation_action_client_id ON public.client_balance_operation_action USING btree (client_id);


--
-- Name: ix_client_balance_operation_action_update_result; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_client_balance_operation_action_update_result ON public.client_balance_operation_action USING btree (update_result);


--
-- Name: ix_client_cdr_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_client_cdr_time ON public.client_cdr USING btree ("time");


--
-- Name: ix_client_currency_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_client_currency_id ON public.client USING btree (currency_id);


--
-- Name: ix_client_group_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_client_group_id ON public.client USING btree (group_id);


--
-- Name: ix_client_orig_rate_table_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_client_orig_rate_table_id ON public.client USING btree (orig_rate_table_id);


--
-- Name: ix_client_payment_client_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_client_payment_client_id ON public.client_payment USING btree (client_id);


--
-- Name: ix_client_payment_invoice_number; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_client_payment_invoice_number ON public.client_payment USING btree (invoice_number);


--
-- Name: ix_client_payment_term_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_client_payment_term_id ON public.client USING btree (payment_term_id);


--
-- Name: ix_client_role_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_client_role_id ON public.client USING btree (role_id);


--
-- Name: ix_client_term_rate_table_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_client_term_rate_table_id ON public.client USING btree (term_rate_table_id);


--
-- Name: ix_code_code; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_code_code ON public.code USING btree (code);


--
-- Name: ix_code_code_deck_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_code_code_deck_id ON public.code USING btree (code_deck_id);


--
-- Name: ix_currency_updates_currency_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_currency_updates_currency_id ON public.currency_updates USING btree (currency_id);


--
-- Name: ix_dashboard_time_option_admin_point_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_dashboard_time_option_admin_point_time ON public.dashboard_time_option USING btree (admin_point_time);


--
-- Name: ix_dashboard_time_option_client_point_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_dashboard_time_option_client_point_time ON public.dashboard_time_option USING btree (client_point_time);


--
-- Name: ix_dashboard_time_option_iden; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_dashboard_time_option_iden ON public.dashboard_time_option USING btree (iden);


--
-- Name: ix_did_assignments_did; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX ix_did_assignments_did ON public.did_assignments USING btree (did);


--
-- Name: ix_did_assignments_log_created_at; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_assignments_log_created_at ON ONLY public.did_assignments_log USING btree (created_at);


--
-- Name: ix_did_billing_brief_next_mrc_billing_date; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_billing_brief_next_mrc_billing_date ON public.did_billing_brief USING btree (next_mrc_billing_date);


--
-- Name: ix_did_billing_brief_nrc_billing_date; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_billing_brief_nrc_billing_date ON public.did_billing_brief USING btree (nrc_billing_date);


--
-- Name: ix_did_billing_operation_action_did_billing_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_billing_operation_action_did_billing_id ON public.did_billing_operation_action USING btree (did_billing_id);


--
-- Name: ix_did_billing_rel_assigned_client_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_billing_rel_assigned_client_id ON public.did_billing_rel USING btree (assigned_client_id);


--
-- Name: ix_did_billing_rel_did; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX ix_did_billing_rel_did ON public.did_billing_rel USING btree (did);


--
-- Name: ix_did_billing_rel_egress_res_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_billing_rel_egress_res_id ON public.did_billing_rel USING btree (egress_res_id);


--
-- Name: ix_did_billing_rel_end_date; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_billing_rel_end_date ON public.did_billing_rel USING btree (end_date);


--
-- Name: ix_did_billing_rel_ingress_res_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_billing_rel_ingress_res_id ON public.did_billing_rel USING btree (ingress_res_id);


--
-- Name: ix_did_billing_rel_ip; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_billing_rel_ip ON public.did_billing_rel USING btree (ip);


--
-- Name: ix_did_billing_rel_note; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_billing_rel_note ON public.did_billing_rel USING btree (note);


--
-- Name: ix_did_billing_rel_start_date; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_billing_rel_start_date ON public.did_billing_rel USING btree (start_date);


--
-- Name: ix_did_charge_detail_did_number; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_charge_detail_did_number ON public.did_charge_detail USING btree (did_number);


--
-- Name: ix_did_charge_detail_params; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_charge_detail_params ON public.did_charge_detail USING btree (params);


--
-- Name: ix_did_client_log_did; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_client_log_did ON public.did_client_log USING btree (did);


--
-- Name: ix_did_cost_detail_did_number; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_cost_detail_did_number ON public.did_cost_detail USING btree (did_number);


--
-- Name: ix_did_cost_detail_params; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_cost_detail_params ON public.did_cost_detail USING btree (params);


--
-- Name: ix_did_invoice_charge_detail_did_number; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_invoice_charge_detail_did_number ON public.did_invoice_charge_detail USING btree (did_number);


--
-- Name: ix_did_param_clec; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_param_clec ON public.did_param USING btree (clec);


--
-- Name: ix_did_param_company; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_param_company ON public.did_param USING btree (company);


--
-- Name: ix_did_param_country_iso; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_param_country_iso ON public.did_param USING btree (country_iso);


--
-- Name: ix_did_param_lata; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_param_lata ON public.did_param USING btree (lata);


--
-- Name: ix_did_param_ocn; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_param_ocn ON public.did_param USING btree (ocn);


--
-- Name: ix_did_param_rate_type; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_param_rate_type ON public.did_param USING btree (rate_type);


--
-- Name: ix_did_param_state; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_param_state ON public.did_param USING btree (state);


--
-- Name: ix_did_param_switch; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_param_switch ON public.did_param USING btree (switch);


--
-- Name: ix_did_repository_did; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX ix_did_repository_did ON public.did_repository USING btree (did);


--
-- Name: ix_did_repository_log_created_at; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_repository_log_created_at ON ONLY public.did_repository_log USING btree (created_at);


--
-- Name: ix_did_vendor_log_did; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_did_vendor_log_did ON public.did_vendor_log USING btree (did);


--
-- Name: ix_dynamic_route_items_dynamic_route_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_dynamic_route_items_dynamic_route_id ON public.dynamic_route_items USING btree (dynamic_route_id);


--
-- Name: ix_dynamic_route_items_resource_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_dynamic_route_items_resource_id ON public.dynamic_route_items USING btree (resource_id);


--
-- Name: ix_dynamic_route_override_dynamic_route_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_dynamic_route_override_dynamic_route_id ON public.dynamic_route_override USING btree (dynamic_route_id);


--
-- Name: ix_dynamic_route_override_resource_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_dynamic_route_override_resource_id ON public.dynamic_route_override USING btree (resource_id);


--
-- Name: ix_dynamic_route_pri_dynamic_route_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_dynamic_route_pri_dynamic_route_id ON public.dynamic_route_pri USING btree (dynamic_route_id);


--
-- Name: ix_dynamic_route_pri_resource_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_dynamic_route_pri_resource_id ON public.dynamic_route_pri USING btree (resource_id);


--
-- Name: ix_dynamic_route_qos_dynamic_route_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_dynamic_route_qos_dynamic_route_id ON public.dynamic_route_qos USING btree (dynamic_route_id);


--
-- Name: ix_dynamic_route_time_profile_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_dynamic_route_time_profile_id ON public.dynamic_route USING btree (time_profile_id);


--
-- Name: ix_fraud_detection_log_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_fraud_detection_log_time ON public.fraud_detection_log USING btree ("time");


--
-- Name: ix_frund_detection_history_api_email_send_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_frund_detection_history_api_email_send_time ON public.frund_detection_history USING btree (api_email_send_time);


--
-- Name: ix_frund_detection_history_frund_detection_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_frund_detection_history_frund_detection_id ON public.frund_detection_history USING btree (frund_detection_id);


--
-- Name: ix_frund_detection_rule_name; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_frund_detection_rule_name ON public.frund_detection USING btree (rule_name);


--
-- Name: ix_invoice_client_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_invoice_client_id ON public.invoice USING btree (client_id);


--
-- Name: ix_invoice_debug_client_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_invoice_debug_client_id ON public.invoice_debug USING btree (client_id);


--
-- Name: ix_invoice_debug_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_invoice_debug_time ON public.invoice_debug USING btree ("time");


--
-- Name: ix_invoice_history_client_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_invoice_history_client_id ON public.invoice_history USING btree (client_id);


--
-- Name: ix_invoice_history_last_invoice_for; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_invoice_history_last_invoice_for ON public.invoice_history USING btree (last_invoice_for);


--
-- Name: ix_invoice_invoice_log_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_invoice_invoice_log_id ON public.invoice USING btree (invoice_log_id);


--
-- Name: ix_invoice_summary_client_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_invoice_summary_client_id ON public.invoice_summary USING btree (client_id);


--
-- Name: ix_invoice_summary_invoice_generation_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_invoice_summary_invoice_generation_time ON public.invoice_summary USING btree (invoice_generation_time);


--
-- Name: ix_invoice_summary_invoice_num; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_invoice_summary_invoice_num ON public.invoice_summary USING btree (invoice_num);


--
-- Name: ix_jurisdiction_prefix_jurisdiction_country_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_jurisdiction_prefix_jurisdiction_country_id ON public.jurisdiction_prefix USING btree (jurisdiction_country_id);


--
-- Name: ix_jurisdiction_prefix_jurisdiction_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_jurisdiction_prefix_jurisdiction_id ON public.jurisdiction_prefix USING btree (jurisdiction_id);


--
-- Name: ix_jurisdiction_prefix_prefix; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX ix_jurisdiction_prefix_prefix ON public.jurisdiction_prefix USING btree (prefix);


--
-- Name: ix_lerg_download_task_lerg_import_task_uuid; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_lerg_download_task_lerg_import_task_uuid ON public.lerg_download_task USING btree (lerg_import_task_uuid);


--
-- Name: ix_lerg_download_task_schedule_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_lerg_download_task_schedule_id ON public.lerg_download_task USING btree (schedule_id);


--
-- Name: ix_lerg_lata; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_lerg_lata ON public.lerg USING btree (lata);


--
-- Name: ix_lerg_npa; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_lerg_npa ON public.lerg USING btree (npa);


--
-- Name: ix_lerg_nxx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_lerg_nxx ON public.lerg USING btree (nxx);


--
-- Name: ix_lerg_ocn; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_lerg_ocn ON public.lerg USING btree (ocn);


--
-- Name: ix_lerg_thousands; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_lerg_thousands ON public.lerg USING btree (thousands);


--
-- Name: ix_monitored_rule_history_api_email_send_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_monitored_rule_history_api_email_send_time ON public.monitored_rule_history USING btree (api_email_send_time);


--
-- Name: ix_monitored_rule_history_monitored_rule_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_monitored_rule_history_monitored_rule_id ON public.monitored_rule_history USING btree (monitored_rule_id);


--
-- Name: ix_monitored_rule_history_unblock_exe_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_monitored_rule_history_unblock_exe_time ON public.monitored_rule_history USING btree (unblock_exe_time);


--
-- Name: ix_monitored_rule_history_unblock_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_monitored_rule_history_unblock_time ON public.monitored_rule_history USING btree (unblock_time);


--
-- Name: ix_object_revision_action; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_object_revision_action ON public.object_revision USING btree (action);


--
-- Name: ix_object_revision_entity_name; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_object_revision_entity_name ON public.object_revision USING btree (entity_name);


--
-- Name: ix_object_revision_entity_pk; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_object_revision_entity_pk ON public.object_revision USING btree (entity_pk);


--
-- Name: ix_object_revision_module; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_object_revision_module ON public.object_revision USING btree (module);


--
-- Name: ix_object_revision_object_name; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_object_revision_object_name ON public.object_revision USING btree (object_name);


--
-- Name: ix_object_revision_revision_number; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_object_revision_revision_number ON public.object_revision USING btree (revision_number);


--
-- Name: ix_object_revision_user_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_object_revision_user_id ON public.object_revision USING btree (user_id);


--
-- Name: ix_payment_gateway_history_client_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_payment_gateway_history_client_id ON public.payment_gateway_history USING btree (client_id);


--
-- Name: ix_payment_gateway_history_status; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_payment_gateway_history_status ON public.payment_gateway_history USING btree (status);


--
-- Name: ix_payment_gateway_history_transaction_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_payment_gateway_history_transaction_id ON public.payment_gateway_history USING btree (transaction_id);


--
-- Name: ix_product_items_resource_item_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_product_items_resource_item_id ON public.product_items_resource USING btree (item_id);


--
-- Name: ix_product_items_resource_resource_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_product_items_resource_resource_id ON public.product_items_resource USING btree (resource_id);


--
-- Name: ix_qos_ip_report_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_qos_ip_report_time ON public.qos_ip USING btree (report_time);


--
-- Name: ix_qos_ip_server_ip; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_qos_ip_server_ip ON public.qos_ip USING btree (server_ip);


--
-- Name: ix_qos_ip_server_port; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_qos_ip_server_port ON public.qos_ip USING btree (server_port);


--
-- Name: ix_qos_resource_report_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_qos_resource_report_time ON public.qos_resource USING btree (report_time);


--
-- Name: ix_qos_resource_server_ip; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_qos_resource_server_ip ON public.qos_resource USING btree (server_ip);


--
-- Name: ix_qos_resource_server_port; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_qos_resource_server_port ON public.qos_resource USING btree (server_port);


--
-- Name: ix_qos_route_report_report_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_qos_route_report_report_time ON public.qos_route_report USING btree (report_time);


--
-- Name: ix_qos_total_report_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_qos_total_report_time ON public.qos_total USING btree (report_time);


--
-- Name: ix_random_ani_generation_ani_number; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_random_ani_generation_ani_number ON public.random_ani_generation USING btree (ani_number);


--
-- Name: ix_random_ani_generation_random_table_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_random_ani_generation_random_table_id ON public.random_ani_generation USING btree (random_table_id);


--
-- Name: ix_random_ani_group_group_name; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_random_ani_group_group_name ON public.random_ani_group USING btree (group_name);


--
-- Name: ix_rate_auto_import_rule_egress_trunk_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_auto_import_rule_egress_trunk_id ON public.rate_auto_import_rule USING btree (egress_trunk_id);


--
-- Name: ix_rate_auto_import_rule_log_rule_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_auto_import_rule_log_rule_id ON public.rate_auto_import_rule_log USING btree (rule_id);


--
-- Name: ix_rate_code; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_code ON public.rate USING btree (code);


--
-- Name: ix_rate_did_type; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_did_type ON public.rate USING btree (did_type);


--
-- Name: ix_rate_effective_date; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_effective_date ON public.rate USING btree (effective_date);


--
-- Name: ix_rate_end_date; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_end_date ON public.rate USING btree (end_date);


--
-- Name: ix_rate_generation_code_deck_rate_generation_template_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_generation_code_deck_rate_generation_template_id ON public.rate_generation_code_deck USING btree (rate_generation_template_id);


--
-- Name: ix_rate_generation_history_status; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_generation_history_status ON public.rate_generation_history USING btree (status);


--
-- Name: ix_rate_generation_rate_rate_generation_history_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_generation_rate_rate_generation_history_id ON public.rate_generation_rate USING btree (rate_generation_history_id);


--
-- Name: ix_rate_generation_template_detail_rate_generation_template_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_generation_template_detail_rate_generation_template_id ON public.rate_generation_template_detail USING btree (rate_generation_template_id);


--
-- Name: ix_rate_generation_template_margin_rate_generation_template_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_generation_template_margin_rate_generation_template_id ON public.rate_generation_template_margin USING btree (rate_generation_template_id);


--
-- Name: ix_rate_rate_table_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_rate_table_id ON public.rate USING btree (rate_table_id);


--
-- Name: ix_rate_table_code_deck_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_table_code_deck_id ON public.rate_table USING btree (code_deck_id);


--
-- Name: ix_rate_table_currency_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_table_currency_id ON public.rate_table USING btree (currency_id);


--
-- Name: ix_rate_table_jurisdiction_country_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_table_jurisdiction_country_id ON public.rate_table USING btree (jurisdiction_country_id);


--
-- Name: ix_rate_time_profile_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_time_profile_id ON public.rate USING btree (time_profile_id);


--
-- Name: ix_rate_upload_task_rule_log_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_upload_task_rule_log_id ON public.rate_upload_task USING btree (rule_log_id);


--
-- Name: ix_rate_upload_values_task_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_rate_upload_values_task_id ON public.rate_upload_values USING btree (task_id);


--
-- Name: ix_register_of_record_username; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_register_of_record_username ON public.register_of_record USING btree (username);


--
-- Name: ix_resource_block_create_time; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_block_create_time ON public.resource_block USING btree (create_time);


--
-- Name: ix_resource_block_time_profile_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_block_time_profile_id ON public.resource_block USING btree (time_profile_id);


--
-- Name: ix_resource_capacity_egress_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_capacity_egress_id ON public.resource_capacity USING btree (egress_id);


--
-- Name: ix_resource_capacity_ingress_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_capacity_ingress_id ON public.resource_capacity USING btree (ingress_id);


--
-- Name: ix_resource_client_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_client_id ON public.resource USING btree (client_id);


--
-- Name: ix_resource_codecs_ref_codec_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_codecs_ref_codec_id ON public.resource_codecs_ref USING btree (codec_id);


--
-- Name: ix_resource_codecs_ref_resource_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_codecs_ref_resource_id ON public.resource_codecs_ref USING btree (resource_id);


--
-- Name: ix_resource_direction_resource_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_direction_resource_id ON public.resource_direction USING btree (resource_id);


--
-- Name: ix_resource_direction_time_profile_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_direction_time_profile_id ON public.resource_direction USING btree (time_profile_id);


--
-- Name: ix_resource_ip_limit_ip_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_ip_limit_ip_id ON public.resource_ip_limit USING btree (ip_id);


--
-- Name: ix_resource_ip_limit_time_profile_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_ip_limit_time_profile_id ON public.resource_ip_limit USING btree (time_profile_id);


--
-- Name: ix_resource_ip_resource_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_ip_resource_id ON public.resource_ip USING btree (resource_id);


--
-- Name: ix_resource_prefix_product_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_prefix_product_id ON public.resource_prefix USING btree (product_id);


--
-- Name: ix_resource_prefix_rate_table_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_prefix_rate_table_id ON public.resource_prefix USING btree (rate_table_id);


--
-- Name: ix_resource_prefix_resource_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_prefix_resource_id ON public.resource_prefix USING btree (resource_id);


--
-- Name: ix_resource_prefix_route_strategy_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_prefix_route_strategy_id ON public.resource_prefix USING btree (route_strategy_id);


--
-- Name: ix_resource_prefix_tech_prefix; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_prefix_tech_prefix ON public.resource_prefix USING btree (tech_prefix);


--
-- Name: ix_resource_rate_table_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_rate_table_id ON public.resource USING btree (rate_table_id);


--
-- Name: ix_resource_replace_action_resource_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_replace_action_resource_id ON public.resource_replace_action USING btree (resource_id);


--
-- Name: ix_resource_route_strategy_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_route_strategy_id ON public.resource USING btree (route_strategy_id);


--
-- Name: ix_resource_shaken_ani_group_list_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_shaken_ani_group_list_id ON public.resource USING btree (shaken_ani_group_list_id);


--
-- Name: ix_resource_translation_ref_resource_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_translation_ref_resource_id ON public.resource_translation_ref USING btree (resource_id);


--
-- Name: ix_resource_translation_ref_time_profile_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_translation_ref_time_profile_id ON public.resource_translation_ref USING btree (time_profile_id);


--
-- Name: ix_resource_translation_ref_translation_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_resource_translation_ref_translation_id ON public.resource_translation_ref USING btree (translation_id);


--
-- Name: ix_role_privilege_role_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_role_privilege_role_id ON public.role_privilege USING btree (role_id);


--
-- Name: ix_role_privilege_system_function_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_role_privilege_system_function_id ON public.role_privilege USING btree (system_function_id);


--
-- Name: ix_role_submenu_rel_role_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_role_submenu_rel_role_id ON public.role_submenu_rel USING btree (role_id);


--
-- Name: ix_role_submenu_rel_submenu_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_role_submenu_rel_submenu_id ON public.role_submenu_rel USING btree (submenu_id);


--
-- Name: ix_route_dynamic_route_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_route_dynamic_route_id ON public.route USING btree (dynamic_route_id);


--
-- Name: ix_route_route_strategy_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_route_route_strategy_id ON public.route USING btree (route_strategy_id);


--
-- Name: ix_route_static_route_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_route_static_route_id ON public.route USING btree (static_route_id);


--
-- Name: ix_shaken_ani_group_list_created_by; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_shaken_ani_group_list_created_by ON public.shaken_ani_group_list USING btree (created_by);


--
-- Name: ix_shaken_ani_group_list_rel_created_by; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_shaken_ani_group_list_rel_created_by ON public.shaken_ani_group_list_rel USING btree (created_by);


--
-- Name: ix_shaken_ani_group_rel_created_by; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_shaken_ani_group_rel_created_by ON public.shaken_ani_group_rel USING btree (created_by);


--
-- Name: ix_sip_registrations_username; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_sip_registrations_username ON public.sip_registrations USING btree (username);


--
-- Name: ix_sms_message; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_sms_message ON public.sms USING btree (message);


--
-- Name: ix_sms_rate_code; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_sms_rate_code ON public.sms_rate USING btree (code);


--
-- Name: ix_sms_rate_country; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_sms_rate_country ON public.sms_rate USING btree (country);


--
-- Name: ix_sms_rate_effective_date; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_sms_rate_effective_date ON public.sms_rate USING btree (effective_date);


--
-- Name: ix_sms_rate_end_date; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_sms_rate_end_date ON public.sms_rate USING btree (end_date);


--
-- Name: ix_sms_rate_sms_rate_table_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_sms_rate_sms_rate_table_id ON public.sms_rate USING btree (sms_rate_table_id);


--
-- Name: ix_sms_receiver; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_sms_receiver ON public.sms USING btree (receiver);


--
-- Name: ix_sms_reference_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_sms_reference_id ON public.sms USING btree (reference_id);


--
-- Name: ix_sms_sender; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_sms_sender ON public.sms USING btree (sender);


--
-- Name: ix_sms_stat; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_sms_stat ON public.sms USING btree (stat);


--
-- Name: ix_spam_traffic_ip_ip; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_spam_traffic_ip_ip ON public.spam_traffic_ip USING btree (ip);


--
-- Name: ix_switch_profile_voip_gateway_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_switch_profile_voip_gateway_id ON public.switch_profile USING btree (voip_gateway_id);


--
-- Name: ix_sys_main_menu_display_name; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX ix_sys_main_menu_display_name ON public.sys_main_menu USING btree (display_name);


--
-- Name: ix_sys_submenu_display_name; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX ix_sys_submenu_display_name ON public.sys_submenu USING btree (display_name);


--
-- Name: ix_sys_submenu_main_menu_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_sys_submenu_main_menu_id ON public.sys_submenu USING btree (main_menu_id);


--
-- Name: ix_system_function_func_name; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX ix_system_function_func_name ON public.system_function USING btree (func_name);


--
-- Name: ix_system_function_func_url; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX ix_system_function_func_url ON public.system_function USING btree (func_url);


--
-- Name: ix_system_function_group_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_system_function_group_id ON public.system_function USING btree (group_id);


--
-- Name: ix_translation_item_translation_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_translation_item_translation_id ON public.translation_item USING btree (translation_id);


--
-- Name: ix_user_api_key_token; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_user_api_key_token ON public.user_api_key USING btree (token);


--
-- Name: ix_users_client_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_users_client_id ON public.users USING btree (client_id);


--
-- Name: ix_users_role_id; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_users_role_id ON public.users USING btree (role_id);


--
-- Name: ix_web_session_host; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_web_session_host ON public.web_session USING btree (host);


--
-- Name: ix_web_session_token; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ix_web_session_token ON public.web_session USING btree (token);


--
-- Name: jurisdiction_prefix_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX jurisdiction_prefix_record_time_idx ON public.jurisdiction_prefix_record USING btree ("time");


--
-- Name: ocn_blocklist_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX ocn_blocklist_record_time_idx ON public.ocn_blocklist_record USING btree ("time");


--
-- Name: origination_global_failover_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX origination_global_failover_record_time_idx ON public.origination_global_failover_record USING btree ("time");


--
-- Name: partition_gateway_ref_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX partition_gateway_ref_record_time_idx ON public.partition_gateway_ref_record USING btree ("time");


--
-- Name: payment_term_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX payment_term_record_time_idx ON public.payment_term_record USING btree ("time");


--
-- Name: product_items_product_id_digits_key; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX product_items_product_id_digits_key ON public.product_items USING btree (product_id, digits, time_profile_id) WHERE ((digits)::text <> ''::text);


--
-- Name: product_items_product_id_digits_min_len_max_len_key; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX product_items_product_id_digits_min_len_max_len_key ON public.product_items USING btree (product_id, digits, min_len, max_len);


--
-- Name: product_items_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX product_items_record_time_idx ON public.product_items_record USING btree ("time");


--
-- Name: product_items_resource_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX product_items_resource_record_time_idx ON public.product_items_resource_record USING btree ("time");


--
-- Name: product_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX product_record_time_idx ON public.product_record USING btree ("time");


--
-- Name: product_rout_rate_table_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX product_rout_rate_table_record_time_idx ON public.product_rout_rate_table_record USING btree ("time");


--
-- Name: qos_route_report_report_time_resource_id_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX qos_route_report_report_time_resource_id_idx ON public.qos_route_report USING btree (report_time, resource_id);


--
-- Name: random_ani_generation_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX random_ani_generation_record_time_idx ON public.random_ani_generation_record USING btree ("time");


--
-- Name: random_ani_group_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX random_ani_group_record_time_idx ON public.random_ani_group_record USING btree ("time");


--
-- Name: rate_generation_rate_rate_generation_history_id_code_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX rate_generation_rate_rate_generation_history_id_code_idx ON public.rate_generation_rate USING btree (rate_generation_history_id, code);


--
-- Name: rate_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX rate_record_time_idx ON public.rate_record USING btree ("time");


--
-- Name: rate_table_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX rate_table_record_time_idx ON public.rate_table_record USING btree ("time");


--
-- Name: rate_type_override_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX rate_type_override_record_time_idx ON public.rate_type_override_record USING btree ("time");


--
-- Name: resource_block_items_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX resource_block_items_record_time_idx ON public.resource_block_items_record USING btree ("time");


--
-- Name: resource_block_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX resource_block_record_time_idx ON public.resource_block_record USING btree ("time");


--
-- Name: resource_capacity_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX resource_capacity_record_time_idx ON public.resource_capacity_record USING btree ("time");


--
-- Name: resource_codecs_ref_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX resource_codecs_ref_record_time_idx ON public.resource_codecs_ref_record USING btree ("time");


--
-- Name: resource_direction_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX resource_direction_record_time_idx ON public.resource_direction_record USING btree ("time");


--
-- Name: resource_ip_limit_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX resource_ip_limit_record_time_idx ON public.resource_ip_limit_record USING btree ("time");


--
-- Name: resource_ip_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX resource_ip_record_time_idx ON public.resource_ip_record USING btree ("time");


--
-- Name: resource_ip_username_key; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX resource_ip_username_key ON public.resource_ip USING btree (username) WHERE (username IS NOT NULL);


--
-- Name: resource_lrn_action_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX resource_lrn_action_record_time_idx ON public.resource_lrn_action_record USING btree ("time");


--
-- Name: resource_next_route_rule_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX resource_next_route_rule_record_time_idx ON public.resource_next_route_rule_record USING btree ("time");


--
-- Name: resource_prefix_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX resource_prefix_record_time_idx ON public.resource_prefix_record USING btree ("time");


--
-- Name: resource_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX resource_record_time_idx ON public.resource_record USING btree ("time");


--
-- Name: resource_replace_action_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX resource_replace_action_record_time_idx ON public.resource_replace_action_record USING btree ("time");


--
-- Name: resource_translation_ref_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX resource_translation_ref_record_time_idx ON public.resource_translation_ref_record USING btree ("time");


--
-- Name: route_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX route_record_time_idx ON public.route_record USING btree ("time");


--
-- Name: service_charge_items_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX service_charge_items_record_time_idx ON public.service_charge_items_record USING btree ("time");


--
-- Name: shaken_ani_group_list_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX shaken_ani_group_list_record_time_idx ON public.shaken_ani_group_list_record USING btree ("time");


--
-- Name: shaken_ani_group_list_rel_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX shaken_ani_group_list_rel_record_time_idx ON public.shaken_ani_group_list_rel_record USING btree ("time");


--
-- Name: shaken_ani_group_rel_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX shaken_ani_group_rel_record_time_idx ON public.shaken_ani_group_rel_record USING btree ("time");


--
-- Name: shaken_sti_sp_conf_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX shaken_sti_sp_conf_record_time_idx ON public.shaken_sti_sp_conf_record USING btree ("time");


--
-- Name: sip_error_code_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX sip_error_code_record_time_idx ON public.sip_error_code_record USING btree ("time");


--
-- Name: spam_traffic_ip_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX spam_traffic_ip_record_time_idx ON public.spam_traffic_ip_record USING btree ("time");


--
-- Name: switch_profile_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX switch_profile_record_time_idx ON public.switch_profile_record USING btree ("time");


--
-- Name: switch_profile_sip_ip_sip_port_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE UNIQUE INDEX switch_profile_sip_ip_sip_port_idx ON public.switch_profile USING btree (sip_ip, sip_port);


--
-- Name: termination_global_failover_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX termination_global_failover_record_time_idx ON public.termination_global_failover_record USING btree ("time");


--
-- Name: time_profile_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX time_profile_record_time_idx ON public.time_profile_record USING btree ("time");


--
-- Name: transaction_fee_items_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX transaction_fee_items_record_time_idx ON public.transaction_fee_items_record USING btree ("time");


--
-- Name: translation_item_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX translation_item_record_time_idx ON public.translation_item_record USING btree ("time");


--
-- Name: voip_gateway_record_time_idx; Type: INDEX; Schema: public; Owner: class4_user
--

CREATE INDEX voip_gateway_record_time_idx ON public.voip_gateway_record USING btree ("time");


--
-- Name: agent_client_client class4_trig_record_agent_client_client; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_agent_client_client AFTER INSERT OR DELETE OR UPDATE ON public.agent_client_client FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_agent_client_client();


--
-- Name: allowed_sendto_ip class4_trig_record_allowed_sendto_ip; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_allowed_sendto_ip AFTER INSERT OR DELETE OR UPDATE ON public.allowed_sendto_ip FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_allowed_sendto_ip();


--
-- Name: banned_ip class4_trig_record_banned_ip; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_banned_ip AFTER INSERT OR DELETE OR UPDATE ON public.banned_ip FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_banned_ip();


--
-- Name: c4_livecall_user class4_trig_record_c4_livecall_user; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_c4_livecall_user AFTER INSERT OR DELETE OR UPDATE ON public.c4_livecall_user FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_c4_livecall_user();


--
-- Name: c4_lrn class4_trig_record_c4_lrn; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_c4_lrn AFTER INSERT OR DELETE OR UPDATE ON public.c4_lrn FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_c4_lrn();


--
-- Name: c4_shaken_conf class4_trig_record_c4_shaken_conf; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_c4_shaken_conf AFTER INSERT OR DELETE OR UPDATE ON public.c4_shaken_conf FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_c4_shaken_conf();


--
-- Name: c4_shaken_status class4_trig_record_c4_shaken_status; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_c4_shaken_status AFTER INSERT OR DELETE OR UPDATE ON public.c4_shaken_status FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_c4_shaken_status();


--
-- Name: client class4_trig_record_client; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_client AFTER INSERT OR DELETE OR UPDATE ON public.client FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_client();


--
-- Name: code class4_trig_record_code; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_code AFTER INSERT OR DELETE OR UPDATE ON public.code FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_code();


--
-- Name: currency class4_trig_record_currency; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_currency AFTER INSERT OR DELETE OR UPDATE ON public.currency FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_currency();


--
-- Name: currency_updates class4_trig_record_currency_updates; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_currency_updates AFTER INSERT OR DELETE OR UPDATE ON public.currency_updates FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_currency_updates();


--
-- Name: did_billing_plan class4_trig_record_did_billing_plan; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_did_billing_plan AFTER INSERT OR DELETE OR UPDATE ON public.did_billing_plan FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_did_billing_plan();


--
-- Name: did_billing_rel class4_trig_record_did_billing_rel; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_did_billing_rel AFTER INSERT OR DELETE OR UPDATE ON public.did_billing_rel FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_did_billing_rel();


--
-- Name: dynamic_route class4_trig_record_dynamic_route; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_dynamic_route AFTER INSERT OR DELETE OR UPDATE ON public.dynamic_route FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_dynamic_route();


--
-- Name: dynamic_route_items class4_trig_record_dynamic_route_items; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_dynamic_route_items AFTER INSERT OR DELETE OR UPDATE ON public.dynamic_route_items FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_dynamic_route_items();


--
-- Name: dynamic_route_override class4_trig_record_dynamic_route_override; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_dynamic_route_override AFTER INSERT OR DELETE OR UPDATE ON public.dynamic_route_override FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_dynamic_route_override();


--
-- Name: dynamic_route_pri class4_trig_record_dynamic_route_pri; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_dynamic_route_pri AFTER INSERT OR DELETE OR UPDATE ON public.dynamic_route_pri FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_dynamic_route_pri();


--
-- Name: dynamic_route_qos class4_trig_record_dynamic_route_qos; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_dynamic_route_qos AFTER INSERT OR DELETE OR UPDATE ON public.dynamic_route_qos FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_dynamic_route_qos();


--
-- Name: egress_profile class4_trig_record_egress_profile; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_egress_profile AFTER INSERT OR DELETE OR UPDATE ON public.egress_profile FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_egress_profile();


--
-- Name: global_route_error class4_trig_record_global_route_error; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_global_route_error AFTER INSERT OR DELETE OR UPDATE ON public.global_route_error FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_global_route_error();


--
-- Name: jurisdiction_prefix class4_trig_record_jurisdiction_prefix; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_jurisdiction_prefix AFTER INSERT OR DELETE OR UPDATE ON public.jurisdiction_prefix FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_jurisdiction_prefix();


--
-- Name: ocn_blocklist class4_trig_record_ocn_blocklist; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_ocn_blocklist AFTER INSERT OR DELETE OR UPDATE ON public.ocn_blocklist FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_ocn_blocklist();


--
-- Name: origination_global_failover class4_trig_record_origination_global_failover; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_origination_global_failover AFTER INSERT OR DELETE OR UPDATE ON public.origination_global_failover FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_origination_global_failover();


--
-- Name: partition_gateway_ref class4_trig_record_partition_gateway_ref; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_partition_gateway_ref AFTER INSERT OR DELETE OR UPDATE ON public.partition_gateway_ref FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_partition_gateway_ref();


--
-- Name: payment_term class4_trig_record_payment_term; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_payment_term AFTER INSERT OR DELETE OR UPDATE ON public.payment_term FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_payment_term();


--
-- Name: product class4_trig_record_product; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_product AFTER INSERT OR DELETE OR UPDATE ON public.product FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_product();


--
-- Name: product_items class4_trig_record_product_items; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_product_items AFTER INSERT OR DELETE OR UPDATE ON public.product_items FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_product_items();


--
-- Name: product_items_resource class4_trig_record_product_items_resource; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_product_items_resource AFTER INSERT OR DELETE OR UPDATE ON public.product_items_resource FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_product_items_resource();


--
-- Name: product_rout_rate_table class4_trig_record_product_rout_rate_table; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_product_rout_rate_table AFTER INSERT OR DELETE OR UPDATE ON public.product_rout_rate_table FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_product_rout_rate_table();


--
-- Name: random_ani_generation class4_trig_record_random_ani_generation; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_random_ani_generation AFTER INSERT OR DELETE OR UPDATE ON public.random_ani_generation FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_random_ani_generation();


--
-- Name: random_ani_group class4_trig_record_random_ani_group; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_random_ani_group AFTER INSERT OR DELETE OR UPDATE ON public.random_ani_group FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_random_ani_group();


--
-- Name: rate class4_trig_record_rate; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_rate AFTER INSERT OR DELETE OR UPDATE ON public.rate FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_rate();


--
-- Name: rate_table class4_trig_record_rate_table; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_rate_table AFTER INSERT OR DELETE OR UPDATE ON public.rate_table FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_rate_table();


--
-- Name: rate_type_override class4_trig_record_rate_type_override; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_rate_type_override AFTER INSERT OR DELETE OR UPDATE ON public.rate_type_override FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_rate_type_override();


--
-- Name: resource class4_trig_record_resource; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_resource AFTER INSERT OR DELETE OR UPDATE ON public.resource FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_resource();


--
-- Name: resource_block class4_trig_record_resource_block; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_resource_block AFTER INSERT OR DELETE OR UPDATE ON public.resource_block FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_resource_block();


--
-- Name: resource_block_items class4_trig_record_resource_block_items; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_resource_block_items AFTER INSERT OR DELETE OR UPDATE ON public.resource_block_items FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_resource_block_items();


--
-- Name: resource_capacity class4_trig_record_resource_capacity; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_resource_capacity AFTER INSERT OR DELETE OR UPDATE ON public.resource_capacity FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_resource_capacity();


--
-- Name: resource_codecs_ref class4_trig_record_resource_codecs_ref; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_resource_codecs_ref AFTER INSERT OR DELETE OR UPDATE ON public.resource_codecs_ref FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_resource_codecs_ref();


--
-- Name: resource_direction class4_trig_record_resource_direction; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_resource_direction AFTER INSERT OR DELETE OR UPDATE ON public.resource_direction FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_resource_direction();


--
-- Name: resource_ip class4_trig_record_resource_ip; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_resource_ip AFTER INSERT OR DELETE OR UPDATE ON public.resource_ip FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_resource_ip();


--
-- Name: resource_ip_limit class4_trig_record_resource_ip_limit; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_resource_ip_limit AFTER INSERT OR DELETE OR UPDATE ON public.resource_ip_limit FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_resource_ip_limit();


--
-- Name: resource_lrn_action class4_trig_record_resource_lrn_action; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_resource_lrn_action AFTER INSERT OR DELETE OR UPDATE ON public.resource_lrn_action FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_resource_lrn_action();


--
-- Name: resource_next_route_rule class4_trig_record_resource_next_route_rule; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_resource_next_route_rule AFTER INSERT OR DELETE OR UPDATE ON public.resource_next_route_rule FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_resource_next_route_rule();


--
-- Name: resource_prefix class4_trig_record_resource_prefix; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_resource_prefix AFTER INSERT OR DELETE OR UPDATE ON public.resource_prefix FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_resource_prefix();


--
-- Name: resource_replace_action class4_trig_record_resource_replace_action; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_resource_replace_action AFTER INSERT OR DELETE OR UPDATE ON public.resource_replace_action FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_resource_replace_action();


--
-- Name: resource_translation_ref class4_trig_record_resource_translation_ref; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_resource_translation_ref AFTER INSERT OR DELETE OR UPDATE ON public.resource_translation_ref FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_resource_translation_ref();


--
-- Name: route class4_trig_record_route; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_route AFTER INSERT OR DELETE OR UPDATE ON public.route FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_route();


--
-- Name: service_charge_items class4_trig_record_service_charge_items; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_service_charge_items AFTER INSERT OR DELETE OR UPDATE ON public.service_charge_items FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_service_charge_items();


--
-- Name: shaken_ani_group_list class4_trig_record_shaken_ani_group_list; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_shaken_ani_group_list AFTER INSERT OR DELETE OR UPDATE ON public.shaken_ani_group_list FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_shaken_ani_group_list();


--
-- Name: shaken_ani_group_list_rel class4_trig_record_shaken_ani_group_list_rel; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_shaken_ani_group_list_rel AFTER INSERT OR DELETE OR UPDATE ON public.shaken_ani_group_list_rel FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_shaken_ani_group_list_rel();


--
-- Name: shaken_ani_group_rel class4_trig_record_shaken_ani_group_rel; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_shaken_ani_group_rel AFTER INSERT OR DELETE OR UPDATE ON public.shaken_ani_group_rel FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_shaken_ani_group_rel();


--
-- Name: shaken_sti_sp_conf class4_trig_record_shaken_sti_sp_conf; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_shaken_sti_sp_conf AFTER INSERT OR DELETE OR UPDATE ON public.shaken_sti_sp_conf FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_shaken_sti_sp_conf();


--
-- Name: sip_error_code class4_trig_record_sip_error_code; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_sip_error_code AFTER INSERT OR DELETE OR UPDATE ON public.sip_error_code FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_sip_error_code();


--
-- Name: spam_traffic_ip class4_trig_record_spam_traffic_ip; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_spam_traffic_ip AFTER INSERT OR DELETE OR UPDATE ON public.spam_traffic_ip FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_spam_traffic_ip();


--
-- Name: switch_profile class4_trig_record_switch_profile; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_switch_profile AFTER INSERT OR DELETE OR UPDATE ON public.switch_profile FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_switch_profile();


--
-- Name: termination_global_failover class4_trig_record_termination_global_failover; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_termination_global_failover AFTER INSERT OR DELETE OR UPDATE ON public.termination_global_failover FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_termination_global_failover();


--
-- Name: time_profile class4_trig_record_time_profile; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_time_profile AFTER INSERT OR DELETE OR UPDATE ON public.time_profile FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_time_profile();


--
-- Name: transaction_fee_items class4_trig_record_transaction_fee_items; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_transaction_fee_items AFTER INSERT OR DELETE OR UPDATE ON public.transaction_fee_items FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_transaction_fee_items();


--
-- Name: translation_item class4_trig_record_translation_item; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_translation_item AFTER INSERT OR DELETE OR UPDATE ON public.translation_item FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_translation_item();


--
-- Name: voip_gateway class4_trig_record_voip_gateway; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER class4_trig_record_voip_gateway AFTER INSERT OR DELETE OR UPDATE ON public.voip_gateway FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_voip_gateway();


--
-- Name: did_number_upload_task process_did_number_upload_task; Type: TRIGGER; Schema: public; Owner: class4_user
--

CREATE TRIGGER process_did_number_upload_task AFTER INSERT OR DELETE OR UPDATE ON public.did_number_upload_task FOR EACH ROW EXECUTE FUNCTION public.process_did_number_upload_task();


--
-- Name: agent_clients agent_clients_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_clients
    ADD CONSTRAINT agent_clients_agent_id_fkey FOREIGN KEY (agent_id) REFERENCES public.agent(agent_id) ON DELETE CASCADE;


--
-- Name: agent_clients agent_clients_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_clients
    ADD CONSTRAINT agent_clients_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: agent_commission_history agent_commission_history_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_commission_history
    ADD CONSTRAINT agent_commission_history_agent_id_fkey FOREIGN KEY (agent_id) REFERENCES public.agent(agent_id) ON DELETE CASCADE;


--
-- Name: agent_commission_history_detail agent_commission_history_detail_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_commission_history_detail
    ADD CONSTRAINT agent_commission_history_detail_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: agent_commission_history_detail agent_commission_history_detail_history_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_commission_history_detail
    ADD CONSTRAINT agent_commission_history_detail_history_id_fkey FOREIGN KEY (history_id) REFERENCES public.agent_commission_history(history_id) ON DELETE CASCADE;


--
-- Name: agent_commission_payment agent_commission_payment_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent_commission_payment
    ADD CONSTRAINT agent_commission_payment_agent_id_fkey FOREIGN KEY (agent_id) REFERENCES public.agent(agent_id) ON DELETE CASCADE;


--
-- Name: agent agent_invoice_setting_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent
    ADD CONSTRAINT agent_invoice_setting_id_fkey FOREIGN KEY (invoice_setting_id) REFERENCES public.invoice_settings(id) ON DELETE CASCADE;


--
-- Name: agent agent_mail_sender_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent
    ADD CONSTRAINT agent_mail_sender_id_fkey FOREIGN KEY (mail_sender_id) REFERENCES public.mail_sender(id) ON DELETE CASCADE;


--
-- Name: agent agent_mail_template_title_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.agent
    ADD CONSTRAINT agent_mail_template_title_fkey FOREIGN KEY (mail_template_title) REFERENCES public.mail_template(title) ON DELETE CASCADE;


--
-- Name: alert_rules_log alert_rules_log_alert_rules_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.alert_rules_log
    ADD CONSTRAINT alert_rules_log_alert_rules_id_fkey FOREIGN KEY (alert_rules_id) REFERENCES public.alert_rules(id) ON DELETE CASCADE;


--
-- Name: alert_rules_log_detail alert_rules_log_detail_alert_rules_log_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.alert_rules_log_detail
    ADD CONSTRAINT alert_rules_log_detail_alert_rules_log_id_fkey FOREIGN KEY (alert_rules_log_id) REFERENCES public.alert_rules_log(id) ON DELETE CASCADE;


--
-- Name: allowed_sendto_ip allowed_sendto_ip_resource_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.allowed_sendto_ip
    ADD CONSTRAINT allowed_sendto_ip_resource_id_fkey FOREIGN KEY (resource_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: auto_rate_import_rule auto_rate_import_rule_egress_trunk_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.auto_rate_import_rule
    ADD CONSTRAINT auto_rate_import_rule_egress_trunk_id_fkey FOREIGN KEY (egress_trunk_id) REFERENCES public.resource(resource_id) ON DELETE SET NULL;


--
-- Name: calling_call calling_call_req_uuid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.calling_call
    ADD CONSTRAINT calling_call_req_uuid_fkey FOREIGN KEY (req_uuid) REFERENCES public.calling_request(req_uuid) ON DELETE CASCADE;


--
-- Name: calling_call calling_call_track_uuid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.calling_call
    ADD CONSTRAINT calling_call_track_uuid_fkey FOREIGN KEY (track_uuid) REFERENCES public.calling_track(uuid) ON DELETE CASCADE;


--
-- Name: cdr_async_task cdr_async_task_request_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_async_task
    ADD CONSTRAINT cdr_async_task_request_client_id_fkey FOREIGN KEY (request_client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: cdr_async_task cdr_async_task_sender_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_async_task
    ADD CONSTRAINT cdr_async_task_sender_id_fkey FOREIGN KEY (sender_id) REFERENCES public.mail_sender(id) ON DELETE CASCADE;


--
-- Name: cdr_async_task cdr_async_task_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_async_task
    ADD CONSTRAINT cdr_async_task_user_id_fkey FOREIGN KEY (user_id) REFERENCES public.users(user_id) ON DELETE CASCADE;


--
-- Name: cdr_download_task cdr_download_task_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_download_task
    ADD CONSTRAINT cdr_download_task_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: cdr_download_task cdr_download_task_sender_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_download_task
    ADD CONSTRAINT cdr_download_task_sender_id_fkey FOREIGN KEY (sender_id) REFERENCES public.mail_sender(id) ON DELETE CASCADE;


--
-- Name: cdr_export_email_task cdr_export_email_task_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.cdr_export_email_task
    ADD CONSTRAINT cdr_export_email_task_id_fkey FOREIGN KEY (id) REFERENCES public.cdr_export_task(id) ON DELETE CASCADE;


--
-- Name: dynamic_route_override class4_fkey_dynamic_route_override_dynamic_route_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_override
    ADD CONSTRAINT class4_fkey_dynamic_route_override_dynamic_route_id FOREIGN KEY (dynamic_route_id) REFERENCES public.dynamic_route(dynamic_route_id) ON DELETE CASCADE;


--
-- Name: dynamic_route_override class4_fkey_dynamic_route_override_resource_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_override
    ADD CONSTRAINT class4_fkey_dynamic_route_override_resource_id FOREIGN KEY (resource_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: client_default_ip client_default_ip_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_default_ip
    ADD CONSTRAINT client_default_ip_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: client_did_product client_did_product_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_did_product
    ADD CONSTRAINT client_did_product_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: client_did_product client_did_product_did_product_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_did_product
    ADD CONSTRAINT client_did_product_did_product_id_fkey FOREIGN KEY (did_product_id) REFERENCES public.did_product(id) ON DELETE CASCADE;


--
-- Name: client_did_product client_did_product_rate_table_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_did_product
    ADD CONSTRAINT client_did_product_rate_table_id_fkey FOREIGN KEY (rate_table_id) REFERENCES public.sms_rate_table(id) ON DELETE CASCADE;


--
-- Name: client client_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client
    ADD CONSTRAINT client_group_id_fkey FOREIGN KEY (group_id) REFERENCES public.carrier_group(group_id) ON DELETE SET NULL;


--
-- Name: client_invoice_settings client_invoice_settings_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_invoice_settings
    ADD CONSTRAINT client_invoice_settings_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: client_invoice_settings client_invoice_settings_invoice_setting_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_invoice_settings
    ADD CONSTRAINT client_invoice_settings_invoice_setting_id_fkey FOREIGN KEY (invoice_setting_id) REFERENCES public.invoice_settings(id) ON DELETE CASCADE;


--
-- Name: client_rate_generation client_rate_generation_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_rate_generation
    ADD CONSTRAINT client_rate_generation_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id);


--
-- Name: client_rate_generation client_rate_generation_rate_generation_template_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_rate_generation
    ADD CONSTRAINT client_rate_generation_rate_generation_template_id_fkey FOREIGN KEY (rate_generation_template_id) REFERENCES public.rate_generation_template(id) ON DELETE CASCADE;


--
-- Name: client_taxes client_taxes_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_taxes
    ADD CONSTRAINT client_taxes_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: code code_code_deck_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.code
    ADD CONSTRAINT code_code_deck_id_fkey FOREIGN KEY (code_deck_id) REFERENCES public.code_deck(code_deck_id) ON DELETE CASCADE;


--
-- Name: currency_updates currency_updates_currency_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.currency_updates
    ADD CONSTRAINT currency_updates_currency_id_fkey FOREIGN KEY (currency_id) REFERENCES public.currency(currency_id) ON DELETE SET NULL;


--
-- Name: did_assign did_assign_egress_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_assign
    ADD CONSTRAINT did_assign_egress_id_fkey FOREIGN KEY (egress_id) REFERENCES public.resource(resource_id);


--
-- Name: did_assignments did_assignments_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_assignments
    ADD CONSTRAINT did_assignments_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id);


--
-- Name: did_assignments did_assignments_vendor_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_assignments
    ADD CONSTRAINT did_assignments_vendor_id_fkey FOREIGN KEY (vendor_id) REFERENCES public.client(client_id) ON DELETE RESTRICT;


--
-- Name: did_billing_operation_action did_billing_operation_action_did_billing_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_operation_action
    ADD CONSTRAINT did_billing_operation_action_did_billing_id_fkey FOREIGN KEY (did_billing_id) REFERENCES public.did_billing_rel(id) ON DELETE CASCADE;


--
-- Name: did_billing_plan did_billing_plan_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_plan
    ADD CONSTRAINT did_billing_plan_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: did_billing_plan did_billing_plan_rate_table_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_billing_plan
    ADD CONSTRAINT did_billing_plan_rate_table_id_fkey FOREIGN KEY (rate_table_id) REFERENCES public.rate_table(rate_table_id) ON DELETE SET NULL;


--
-- Name: did_charge_detail did_charge_detail_client_billing_plan_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_charge_detail
    ADD CONSTRAINT did_charge_detail_client_billing_plan_id_fkey FOREIGN KEY (client_billing_plan_id) REFERENCES public.did_billing_plan(id) ON DELETE CASCADE;


--
-- Name: did_charge_detail did_charge_detail_client_trunk_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_charge_detail
    ADD CONSTRAINT did_charge_detail_client_trunk_id_fkey FOREIGN KEY (client_trunk_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: did_charge_detail did_charge_detail_vendor_trunk_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_charge_detail
    ADD CONSTRAINT did_charge_detail_vendor_trunk_id_fkey FOREIGN KEY (vendor_trunk_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: did_cost_detail did_cost_detail_client_billing_plan_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_cost_detail
    ADD CONSTRAINT did_cost_detail_client_billing_plan_id_fkey FOREIGN KEY (client_billing_plan_id) REFERENCES public.did_billing_plan(id) ON DELETE CASCADE;


--
-- Name: did_cost_detail did_cost_detail_client_trunk_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_cost_detail
    ADD CONSTRAINT did_cost_detail_client_trunk_id_fkey FOREIGN KEY (client_trunk_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: did_cost_detail did_cost_detail_vendor_trunk_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_cost_detail
    ADD CONSTRAINT did_cost_detail_vendor_trunk_id_fkey FOREIGN KEY (vendor_trunk_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: did_export_async_task did_export_async_task_request_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_export_async_task
    ADD CONSTRAINT did_export_async_task_request_client_id_fkey FOREIGN KEY (request_client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: did_export_async_task did_export_async_task_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_export_async_task
    ADD CONSTRAINT did_export_async_task_user_id_fkey FOREIGN KEY (user_id) REFERENCES public.users(user_id) ON DELETE CASCADE;


--
-- Name: did_invoice_charge_breakdown did_invoice_charge_breakdown_client_billing_plan_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_invoice_charge_breakdown
    ADD CONSTRAINT did_invoice_charge_breakdown_client_billing_plan_id_fkey FOREIGN KEY (client_billing_plan_id) REFERENCES public.did_billing_plan(id) ON DELETE CASCADE;


--
-- Name: did_invoice_charge_breakdown did_invoice_charge_breakdown_client_trunk_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_invoice_charge_breakdown
    ADD CONSTRAINT did_invoice_charge_breakdown_client_trunk_id_fkey FOREIGN KEY (client_trunk_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: did_invoice_charge_breakdown did_invoice_charge_breakdown_invoice_number_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_invoice_charge_breakdown
    ADD CONSTRAINT did_invoice_charge_breakdown_invoice_number_fkey FOREIGN KEY (invoice_number) REFERENCES public.invoice_summary(invoice_number) ON DELETE CASCADE;


--
-- Name: did_invoice_charge_detail did_invoice_charge_detail_client_billing_plan_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_invoice_charge_detail
    ADD CONSTRAINT did_invoice_charge_detail_client_billing_plan_id_fkey FOREIGN KEY (client_billing_plan_id) REFERENCES public.did_billing_plan(id) ON DELETE CASCADE;


--
-- Name: did_invoice_charge_detail did_invoice_charge_detail_client_trunk_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_invoice_charge_detail
    ADD CONSTRAINT did_invoice_charge_detail_client_trunk_id_fkey FOREIGN KEY (client_trunk_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: did_invoice_charge_detail did_invoice_charge_detail_invoice_number_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_invoice_charge_detail
    ADD CONSTRAINT did_invoice_charge_detail_invoice_number_fkey FOREIGN KEY (invoice_number) REFERENCES public.invoice_summary(invoice_number) ON DELETE CASCADE;


--
-- Name: did_invoice_port_charge did_invoice_port_charge_client_trunk_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_invoice_port_charge
    ADD CONSTRAINT did_invoice_port_charge_client_trunk_id_fkey FOREIGN KEY (client_trunk_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: did_invoice_port_charge did_invoice_port_charge_invoice_number_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_invoice_port_charge
    ADD CONSTRAINT did_invoice_port_charge_invoice_number_fkey FOREIGN KEY (invoice_number) REFERENCES public.invoice_summary(invoice_number) ON DELETE CASCADE;


--
-- Name: did_product_item did_product_item_billing_rule_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_product_item
    ADD CONSTRAINT did_product_item_billing_rule_id_fkey FOREIGN KEY (billing_rule_id) REFERENCES public.did_billing_plan(id) ON DELETE CASCADE;


--
-- Name: did_product_item did_product_item_country_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_product_item
    ADD CONSTRAINT did_product_item_country_fkey FOREIGN KEY (country) REFERENCES public.code_country(country_code) ON DELETE CASCADE;


--
-- Name: did_product_item did_product_item_did_product_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_product_item
    ADD CONSTRAINT did_product_item_did_product_id_fkey FOREIGN KEY (did_product_id) REFERENCES public.did_product(id) ON DELETE CASCADE;


--
-- Name: did_repository did_repository_vendor_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_repository
    ADD CONSTRAINT did_repository_vendor_id_fkey FOREIGN KEY (vendor_id) REFERENCES public.client(client_id) ON DELETE RESTRICT;


--
-- Name: did_vendor_api did_vendor_api_client_billing_rule_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_vendor_api
    ADD CONSTRAINT did_vendor_api_client_billing_rule_id_fkey FOREIGN KEY (client_billing_rule_id) REFERENCES public.did_billing_plan(id) ON DELETE CASCADE;


--
-- Name: did_vendor_api did_vendor_api_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_vendor_api
    ADD CONSTRAINT did_vendor_api_id_fkey FOREIGN KEY (id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: did_vendor_api did_vendor_api_vendor_billing_rule_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_vendor_api
    ADD CONSTRAINT did_vendor_api_vendor_billing_rule_id_fkey FOREIGN KEY (vendor_billing_rule_id) REFERENCES public.did_billing_plan(id) ON DELETE CASCADE;


--
-- Name: dnl_cloud_dbman_cfg dnl_cloud_dbman_cfg_cdr_storage_cfg_uuid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_dbman_cfg
    ADD CONSTRAINT dnl_cloud_dbman_cfg_cdr_storage_cfg_uuid_fkey FOREIGN KEY (cdr_storage_cfg_uuid) REFERENCES public.dnl_cloud_storages(uuid);


--
-- Name: dnl_cloud_dbman_cfg dnl_cloud_dbman_cfg_pcap_storage_cfg_uuid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_dbman_cfg
    ADD CONSTRAINT dnl_cloud_dbman_cfg_pcap_storage_cfg_uuid_fkey FOREIGN KEY (pcap_storage_cfg_uuid) REFERENCES public.dnl_cloud_storages(uuid);


--
-- Name: dnl_cloud_ftp_cfg dnl_cloud_ftp_cfg_uuid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_ftp_cfg
    ADD CONSTRAINT dnl_cloud_ftp_cfg_uuid_fkey FOREIGN KEY (uuid) REFERENCES public.dnl_cloud_storages(uuid) ON DELETE CASCADE;


--
-- Name: dnl_cloud_gcloud_cfg dnl_cloud_gcloud_cfg_uuid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_gcloud_cfg
    ADD CONSTRAINT dnl_cloud_gcloud_cfg_uuid_fkey FOREIGN KEY (uuid) REFERENCES public.dnl_cloud_storages(uuid) ON DELETE CASCADE;


--
-- Name: dnl_cloud_sftp_cfg dnl_cloud_sftp_cfg_uuid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dnl_cloud_sftp_cfg
    ADD CONSTRAINT dnl_cloud_sftp_cfg_uuid_fkey FOREIGN KEY (uuid) REFERENCES public.dnl_cloud_storages(uuid) ON DELETE CASCADE;


--
-- Name: fault_route_alert_rule_log fault_route_alert_rule_log_rule_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fault_route_alert_rule_log
    ADD CONSTRAINT fault_route_alert_rule_log_rule_id_fkey FOREIGN KEY (rule_id) REFERENCES public.fault_route_alert_rule(id) ON DELETE CASCADE;


--
-- Name: fault_route_alert_rule fault_route_alert_rule_product_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fault_route_alert_rule
    ADD CONSTRAINT fault_route_alert_rule_product_id_fkey FOREIGN KEY (product_id) REFERENCES public.product_rout_rate_table(id) ON DELETE CASCADE;


--
-- Name: did_assignments fk_did_assignments_client_billing_plan_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_assignments
    ADD CONSTRAINT fk_did_assignments_client_billing_plan_id FOREIGN KEY (client_billing_plan_id) REFERENCES public.did_billing_plan(id) ON DELETE RESTRICT;


--
-- Name: did_assignments fk_did_assignments_client_trunk_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_assignments
    ADD CONSTRAINT fk_did_assignments_client_trunk_id FOREIGN KEY (client_trunk_id) REFERENCES public.resource(resource_id) ON DELETE RESTRICT;


--
-- Name: did_assignments fk_did_assignments_fallback_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_assignments
    ADD CONSTRAINT fk_did_assignments_fallback_id FOREIGN KEY (fallback_id) REFERENCES public.resource(resource_id) ON DELETE RESTRICT;


--
-- Name: did_assignments fk_did_assignments_vendor_billing_plan_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_assignments
    ADD CONSTRAINT fk_did_assignments_vendor_billing_plan_id FOREIGN KEY (vendor_billing_plan_id) REFERENCES public.did_billing_plan(id) ON DELETE RESTRICT;


--
-- Name: did_assignments fk_did_assignments_vendor_trunk_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_assignments
    ADD CONSTRAINT fk_did_assignments_vendor_trunk_id FOREIGN KEY (vendor_trunk_id) REFERENCES public.resource(resource_id) ON DELETE RESTRICT;


--
-- Name: did_repository fk_did_repository_vendor_billing_plan_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_repository
    ADD CONSTRAINT fk_did_repository_vendor_billing_plan_id FOREIGN KEY (vendor_billing_plan_id) REFERENCES public.did_billing_plan(id) ON DELETE RESTRICT;


--
-- Name: did_repository fk_did_repository_vendor_trunk_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.did_repository
    ADD CONSTRAINT fk_did_repository_vendor_trunk_id FOREIGN KEY (vendor_trunk_id) REFERENCES public.resource(resource_id) ON DELETE RESTRICT;


--
-- Name: balance_history_actual fkey_balance_history_actual_client_client_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.balance_history_actual
    ADD CONSTRAINT fkey_balance_history_actual_client_client_id FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: balance_history fkey_balance_history_client_client_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.balance_history
    ADD CONSTRAINT fkey_balance_history_client_client_id FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: carrier_template_low_bal_config fkey_carrier_template_low_bal_config_carrier_template_carrier_t; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.carrier_template_low_bal_config
    ADD CONSTRAINT fkey_carrier_template_low_bal_config_carrier_template_carrier_t FOREIGN KEY (carrier_template_id) REFERENCES public.carrier_template(id) ON DELETE CASCADE;


--
-- Name: client fkey_client_currency_currency_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client
    ADD CONSTRAINT fkey_client_currency_currency_id FOREIGN KEY (currency_id) REFERENCES public.currency(currency_id) ON DELETE SET NULL;


--
-- Name: client_low_balance_config fkey_client_low_balance_config_client_client_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_low_balance_config
    ADD CONSTRAINT fkey_client_low_balance_config_client_client_id FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: client_payment fkey_client_payment_client_client_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client_payment
    ADD CONSTRAINT fkey_client_payment_client_client_id FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE SET NULL;


--
-- Name: client fkey_client_payment_term_payment_term_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.client
    ADD CONSTRAINT fkey_client_payment_term_payment_term_id FOREIGN KEY (payment_term_id) REFERENCES public.payment_term(payment_term_id) ON DELETE SET NULL;


--
-- Name: dynamic_route_items fkey_dynamic_route_items_dynamic_route_dynamic_route_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_items
    ADD CONSTRAINT fkey_dynamic_route_items_dynamic_route_dynamic_route_id FOREIGN KEY (dynamic_route_id) REFERENCES public.dynamic_route(dynamic_route_id) ON DELETE CASCADE;


--
-- Name: dynamic_route_items fkey_dynamic_route_items_resource_resource_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_items
    ADD CONSTRAINT fkey_dynamic_route_items_resource_resource_id FOREIGN KEY (resource_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: dynamic_route_pri fkey_dynamic_route_pri_dynamic_route_dynamic_route_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_pri
    ADD CONSTRAINT fkey_dynamic_route_pri_dynamic_route_dynamic_route_id FOREIGN KEY (dynamic_route_id) REFERENCES public.dynamic_route(dynamic_route_id) ON DELETE CASCADE;


--
-- Name: dynamic_route_pri fkey_dynamic_route_pri_resource_resource_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_pri
    ADD CONSTRAINT fkey_dynamic_route_pri_resource_resource_id FOREIGN KEY (resource_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: dynamic_route_qos fkey_dynamic_route_qos_dynamic_route_dynamic_route_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route_qos
    ADD CONSTRAINT fkey_dynamic_route_qos_dynamic_route_dynamic_route_id FOREIGN KEY (dynamic_route_id) REFERENCES public.dynamic_route(dynamic_route_id) ON DELETE CASCADE;


--
-- Name: dynamic_route fkey_dynamic_route_time_profile_time_profile_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.dynamic_route
    ADD CONSTRAINT fkey_dynamic_route_time_profile_time_profile_id FOREIGN KEY (time_profile_id) REFERENCES public.time_profile(time_profile_id) ON DELETE SET NULL;


--
-- Name: egress_profile fkey_egress_profile_resource_egress_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.egress_profile
    ADD CONSTRAINT fkey_egress_profile_resource_egress_id FOREIGN KEY (egress_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: egress_profile fkey_egress_profile_switch_profile_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.egress_profile
    ADD CONSTRAINT fkey_egress_profile_switch_profile_id FOREIGN KEY (profile_id) REFERENCES public.switch_profile(id) ON DELETE CASCADE;


--
-- Name: fraud_detection_log_detail fkey_fraud_detection_log_detail_fraud_detection_log_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fraud_detection_log_detail
    ADD CONSTRAINT fkey_fraud_detection_log_detail_fraud_detection_log_id FOREIGN KEY (fraud_detection_log_id) REFERENCES public.fraud_detection_log(id) ON DELETE CASCADE;


--
-- Name: fraud_detection_log fkey_fraud_detection_log_fraud_detection_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.fraud_detection_log
    ADD CONSTRAINT fkey_fraud_detection_log_fraud_detection_id FOREIGN KEY (fraud_detection_id) REFERENCES public.fraud_detection(id) ON DELETE CASCADE;


--
-- Name: invoice fkey_invoice_client_client_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice
    ADD CONSTRAINT fkey_invoice_client_client_id FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: product_items fkey_product_items_product_product_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_items
    ADD CONSTRAINT fkey_product_items_product_product_id FOREIGN KEY (product_id) REFERENCES public.product(product_id) ON DELETE CASCADE;


--
-- Name: product_items_resource fkey_product_items_resource_product_items_item_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_items_resource
    ADD CONSTRAINT fkey_product_items_resource_product_items_item_id FOREIGN KEY (item_id) REFERENCES public.product_items(item_id) ON DELETE CASCADE;


--
-- Name: product_items_resource fkey_product_items_resource_resource_resource_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_items_resource
    ADD CONSTRAINT fkey_product_items_resource_resource_resource_id FOREIGN KEY (resource_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: product_items fkey_product_items_time_profile_time_profile_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_items
    ADD CONSTRAINT fkey_product_items_time_profile_time_profile_id FOREIGN KEY (time_profile_id) REFERENCES public.time_profile(time_profile_id) ON DELETE SET NULL;


--
-- Name: rate_generation_history fkey_rate_generation_history_rate_gen_template_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_history
    ADD CONSTRAINT fkey_rate_generation_history_rate_gen_template_id FOREIGN KEY (rate_generation_template_id) REFERENCES public.rate_generation_template(id) ON DELETE CASCADE;


--
-- Name: rate_generation_template_detail fkey_rate_generation_template_detail_rate_gen_template_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_template_detail
    ADD CONSTRAINT fkey_rate_generation_template_detail_rate_gen_template_id FOREIGN KEY (rate_generation_template_id) REFERENCES public.rate_generation_template(id) ON DELETE CASCADE;


--
-- Name: rate fkey_rate_rate_table_rate_table_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate
    ADD CONSTRAINT fkey_rate_rate_table_rate_table_id FOREIGN KEY (rate_table_id) REFERENCES public.rate_table(rate_table_id) ON DELETE CASCADE;


--
-- Name: rate_table fkey_rate_table_code_deck_code_deck_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_table
    ADD CONSTRAINT fkey_rate_table_code_deck_code_deck_id FOREIGN KEY (code_deck_id) REFERENCES public.code_deck(code_deck_id) ON DELETE SET NULL;


--
-- Name: rate_table fkey_rate_table_currency_currency_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_table
    ADD CONSTRAINT fkey_rate_table_currency_currency_id FOREIGN KEY (currency_id) REFERENCES public.currency(currency_id) ON DELETE SET NULL;


--
-- Name: resource_block fkey_resource_block_resource_ingress_res_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_block
    ADD CONSTRAINT fkey_resource_block_resource_ingress_res_id FOREIGN KEY (ingress_res_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: resource_block fkey_resource_block_time_profile_time_profile_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_block
    ADD CONSTRAINT fkey_resource_block_time_profile_time_profile_id FOREIGN KEY (time_profile_id) REFERENCES public.time_profile(time_profile_id) ON DELETE SET NULL;


--
-- Name: resource fkey_resource_client_client_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource
    ADD CONSTRAINT fkey_resource_client_client_id FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE SET NULL;


--
-- Name: resource_codecs_ref fkey_resource_codecs_ref_resource_resource_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_codecs_ref
    ADD CONSTRAINT fkey_resource_codecs_ref_resource_resource_id FOREIGN KEY (resource_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: resource_direction fkey_resource_direction_resource_resource_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_direction
    ADD CONSTRAINT fkey_resource_direction_resource_resource_id FOREIGN KEY (resource_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: resource_direction fkey_resource_direction_time_profile_time_profile_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_direction
    ADD CONSTRAINT fkey_resource_direction_time_profile_time_profile_id FOREIGN KEY (time_profile_id) REFERENCES public.time_profile(time_profile_id) ON DELETE SET NULL;


--
-- Name: resource_ip_limit fkey_resource_ip_limit_resource_ip_ip_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_ip_limit
    ADD CONSTRAINT fkey_resource_ip_limit_resource_ip_ip_id FOREIGN KEY (ip_id) REFERENCES public.resource_ip(resource_ip_id) ON DELETE CASCADE;


--
-- Name: resource_ip_limit fkey_resource_ip_limit_time_profile_time_profile_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_ip_limit
    ADD CONSTRAINT fkey_resource_ip_limit_time_profile_time_profile_id FOREIGN KEY (time_profile_id) REFERENCES public.time_profile(time_profile_id) ON DELETE SET NULL;


--
-- Name: resource_ip fkey_resource_ip_resource_resource_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_ip
    ADD CONSTRAINT fkey_resource_ip_resource_resource_id FOREIGN KEY (resource_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: resource_prefix fkey_resource_prefix_resource_resource_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_prefix
    ADD CONSTRAINT fkey_resource_prefix_resource_resource_id FOREIGN KEY (resource_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: resource fkey_resource_rate_table_rate_table_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource
    ADD CONSTRAINT fkey_resource_rate_table_rate_table_id FOREIGN KEY (rate_table_id) REFERENCES public.rate_table(rate_table_id) ON DELETE SET NULL;


--
-- Name: resource fkey_resource_route_strategy_route_strategy_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource
    ADD CONSTRAINT fkey_resource_route_strategy_route_strategy_id FOREIGN KEY (route_strategy_id) REFERENCES public.route_strategy(route_strategy_id) ON DELETE SET NULL;


--
-- Name: resource fkey_resource_trunk_group_group_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource
    ADD CONSTRAINT fkey_resource_trunk_group_group_id FOREIGN KEY (group_id) REFERENCES public.trunk_group(group_id) ON DELETE SET NULL;


--
-- Name: route fkey_route_dynamic_route_dynamic_route_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.route
    ADD CONSTRAINT fkey_route_dynamic_route_dynamic_route_id FOREIGN KEY (dynamic_route_id) REFERENCES public.dynamic_route(dynamic_route_id) ON DELETE SET NULL;


--
-- Name: route fkey_route_product_static_route_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.route
    ADD CONSTRAINT fkey_route_product_static_route_id FOREIGN KEY (static_route_id) REFERENCES public.product(product_id) ON DELETE SET NULL;


--
-- Name: route fkey_route_route_strategy_route_strategy_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.route
    ADD CONSTRAINT fkey_route_route_strategy_route_strategy_id FOREIGN KEY (route_strategy_id) REFERENCES public.route_strategy(route_strategy_id) ON DELETE CASCADE;


--
-- Name: translation_item fkey_translation_item_digit_translation_translation_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.translation_item
    ADD CONSTRAINT fkey_translation_item_digit_translation_translation_id FOREIGN KEY (translation_id) REFERENCES public.digit_translation(translation_id) ON DELETE CASCADE;


--
-- Name: ftp_cdr_log_detail ftp_cdr_log_detail_ftp_cdr_log_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ftp_cdr_log_detail
    ADD CONSTRAINT ftp_cdr_log_detail_ftp_cdr_log_id_fkey FOREIGN KEY (ftp_cdr_log_id) REFERENCES public.ftp_cdr_log(id) ON DELETE CASCADE;


--
-- Name: ingress_did_repository ingress_did_repository_egress_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ingress_did_repository
    ADD CONSTRAINT ingress_did_repository_egress_id_fkey FOREIGN KEY (egress_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: ingress_did_repository ingress_did_repository_ingress_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ingress_did_repository
    ADD CONSTRAINT ingress_did_repository_ingress_id_fkey FOREIGN KEY (ingress_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: invoice invoice_invoice_log_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice
    ADD CONSTRAINT invoice_invoice_log_id_fkey FOREIGN KEY (invoice_log_id) REFERENCES public.invoice_log(id) ON DELETE SET NULL;


--
-- Name: invoice_summary invoice_summary_task_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.invoice_summary
    ADD CONSTRAINT invoice_summary_task_id_fkey FOREIGN KEY (task_id) REFERENCES public.invoice_task(id) ON DELETE CASCADE;


--
-- Name: lcr_test lcr_test_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test
    ADD CONSTRAINT lcr_test_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: lcr_test lcr_test_egress_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test
    ADD CONSTRAINT lcr_test_egress_id_fkey FOREIGN KEY (egress_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: lcr_test lcr_test_ip_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test
    ADD CONSTRAINT lcr_test_ip_id_fkey FOREIGN KEY (ip_id) REFERENCES public.resource_ip(resource_ip_id) ON DELETE CASCADE;


--
-- Name: lcr_test lcr_test_prefix_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test
    ADD CONSTRAINT lcr_test_prefix_id_fkey FOREIGN KEY (prefix_id) REFERENCES public.resource_prefix(id) ON DELETE CASCADE;


--
-- Name: lcr_test lcr_test_product_id_key; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test
    ADD CONSTRAINT lcr_test_product_id_key FOREIGN KEY (static_route_id) REFERENCES public.product(product_id) ON DELETE CASCADE;


--
-- Name: lcr_test lcr_test_product_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test
    ADD CONSTRAINT lcr_test_product_item_id_fkey FOREIGN KEY (product_item_id) REFERENCES public.product_items(item_id) ON DELETE CASCADE;


--
-- Name: lcr_test lcr_test_product_item_resource_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test
    ADD CONSTRAINT lcr_test_product_item_resource_id_fkey FOREIGN KEY (product_item_resource_id) REFERENCES public.product_items_resource(id) ON DELETE CASCADE;


--
-- Name: lcr_test lcr_test_rate_table_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test
    ADD CONSTRAINT lcr_test_rate_table_id_fkey FOREIGN KEY (rate_table_id) REFERENCES public.rate_table(rate_table_id) ON DELETE CASCADE;


--
-- Name: lcr_test lcr_test_route_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test
    ADD CONSTRAINT lcr_test_route_id_fkey FOREIGN KEY (route_id) REFERENCES public.route(route_id) ON DELETE CASCADE;


--
-- Name: lcr_test lcr_test_route_strategy_id_key; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test
    ADD CONSTRAINT lcr_test_route_strategy_id_key FOREIGN KEY (routing_plan_id) REFERENCES public.route_strategy(route_strategy_id) ON DELETE CASCADE;


--
-- Name: lcr_test lcr_test_switch_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test
    ADD CONSTRAINT lcr_test_switch_id_fkey FOREIGN KEY (switch_id) REFERENCES public.voip_gateway(id) ON DELETE CASCADE;


--
-- Name: lcr_test lcr_test_trunk_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lcr_test
    ADD CONSTRAINT lcr_test_trunk_id_fkey FOREIGN KEY (trunk_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: lerg_download_task lerg_download_task_lerg_import_task_uuid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lerg_download_task
    ADD CONSTRAINT lerg_download_task_lerg_import_task_uuid_fkey FOREIGN KEY (lerg_import_task_uuid) REFERENCES public.lerg_import_task(uuid) ON DELETE CASCADE;


--
-- Name: lerg_download_task lerg_download_task_schedule_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.lerg_download_task
    ADD CONSTRAINT lerg_download_task_schedule_id_fkey FOREIGN KEY (schedule_id) REFERENCES public.lerg_download_schedule(id) ON DELETE CASCADE;


--
-- Name: loop_detection_detail loop_detection_detail_loop_detection_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.loop_detection_detail
    ADD CONSTRAINT loop_detection_detail_loop_detection_id_fkey FOREIGN KEY (loop_detection_id) REFERENCES public.loop_detection(id) ON DELETE CASCADE;


--
-- Name: loop_detection_detail loop_detection_detail_resource_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.loop_detection_detail
    ADD CONSTRAINT loop_detection_detail_resource_id_fkey FOREIGN KEY (resource_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: mail_cdr_log_detail mail_cdr_log_detail_mail_cdr_log_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.mail_cdr_log_detail
    ADD CONSTRAINT mail_cdr_log_detail_mail_cdr_log_id_fkey FOREIGN KEY (mail_cdr_log_id) REFERENCES public.mail_cdr_log(id);


--
-- Name: mail_template mail_template_from_mail_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.mail_template
    ADD CONSTRAINT mail_template_from_mail_id_fkey FOREIGN KEY (from_mail_id) REFERENCES public.mail_sender(id) ON DELETE SET NULL;


--
-- Name: object_revision_record object_revision_record_object_revision_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.object_revision_record
    ADD CONSTRAINT object_revision_record_object_revision_id_fkey FOREIGN KEY (object_revision_id) REFERENCES public.object_revision(id) ON DELETE CASCADE;


--
-- Name: payment_gateway_history payment_gateway_history_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.payment_gateway_history
    ADD CONSTRAINT payment_gateway_history_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE SET NULL;


--
-- Name: payment_invoice payment_invoice_invoice_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.payment_invoice
    ADD CONSTRAINT payment_invoice_invoice_id_fkey FOREIGN KEY (invoice_id) REFERENCES public.invoice(invoice_id);


--
-- Name: payment_invoice payment_invoice_payment_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.payment_invoice
    ADD CONSTRAINT payment_invoice_payment_id_fkey FOREIGN KEY (payment_id) REFERENCES public.client_payment(client_payment_id);


--
-- Name: pcap_query_task_mail pcap_query_task_mail_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.pcap_query_task_mail
    ADD CONSTRAINT pcap_query_task_mail_id_fkey FOREIGN KEY (id) REFERENCES public.pcap_query_task(id) ON DELETE CASCADE;


--
-- Name: product_agents_ref product_agents_ref_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_agents_ref
    ADD CONSTRAINT product_agents_ref_agent_id_fkey FOREIGN KEY (agent_id) REFERENCES public.agent(agent_id) ON DELETE CASCADE;


--
-- Name: product_agents_ref product_agents_ref_product_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_agents_ref
    ADD CONSTRAINT product_agents_ref_product_id_fkey FOREIGN KEY (product_id) REFERENCES public.product_rout_rate_table(id) ON DELETE CASCADE;


--
-- Name: product_clients_ref product_clients_ref_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_clients_ref
    ADD CONSTRAINT product_clients_ref_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: product_clients_ref product_clients_ref_product_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_clients_ref
    ADD CONSTRAINT product_clients_ref_product_id_fkey FOREIGN KEY (product_id) REFERENCES public.product_rout_rate_table(id) ON DELETE CASCADE;


--
-- Name: product_clients_ref_used product_clients_ref_used_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_clients_ref_used
    ADD CONSTRAINT product_clients_ref_used_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: product_clients_ref_used product_clients_ref_used_product_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_clients_ref_used
    ADD CONSTRAINT product_clients_ref_used_product_id_fkey FOREIGN KEY (product_id) REFERENCES public.product_rout_rate_table(id) ON DELETE CASCADE;


--
-- Name: product product_code_deck_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product
    ADD CONSTRAINT product_code_deck_id_fkey FOREIGN KEY (code_deck_id) REFERENCES public.code_deck(code_deck_id) ON DELETE SET NULL;


--
-- Name: product_rout_rate_table product_rout_rate_table_rate_table_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_rout_rate_table
    ADD CONSTRAINT product_rout_rate_table_rate_table_id FOREIGN KEY (rate_table_id) REFERENCES public.rate_table(rate_table_id) ON DELETE CASCADE;


--
-- Name: product_rout_rate_table product_rout_rate_table_rout_id; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_rout_rate_table
    ADD CONSTRAINT product_rout_rate_table_rout_id FOREIGN KEY (rout_id) REFERENCES public.route_strategy(route_strategy_id) ON DELETE CASCADE;


--
-- Name: product_route_analysis product_route_analysis_code_deck_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_route_analysis
    ADD CONSTRAINT product_route_analysis_code_deck_id_fkey FOREIGN KEY (code_deck_id) REFERENCES public.code_deck(code_deck_id) ON DELETE SET NULL;


--
-- Name: product_route_analysis_log product_route_analysis_log_uuid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_route_analysis_log
    ADD CONSTRAINT product_route_analysis_log_uuid_fkey FOREIGN KEY (uuid) REFERENCES public.product_route_analysis(uuid) ON DELETE CASCADE;


--
-- Name: product_route_analysis product_route_analysis_rate_table_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_route_analysis
    ADD CONSTRAINT product_route_analysis_rate_table_id_fkey FOREIGN KEY (rate_table_id) REFERENCES public.rate_table(rate_table_id) ON DELETE CASCADE;


--
-- Name: product_route_analysis product_route_analysis_route_plan_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.product_route_analysis
    ADD CONSTRAINT product_route_analysis_route_plan_id_fkey FOREIGN KEY (route_plan_id) REFERENCES public.route_strategy(route_strategy_id) ON DELETE CASCADE;


--
-- Name: rate_auto_import_rule rate_auto_import_rule_egress_trunk_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_auto_import_rule
    ADD CONSTRAINT rate_auto_import_rule_egress_trunk_id_fkey FOREIGN KEY (egress_trunk_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: rate_auto_import_rule_log rate_auto_import_rule_log_rule_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_auto_import_rule_log
    ADD CONSTRAINT rate_auto_import_rule_log_rule_id_fkey FOREIGN KEY (rule_id) REFERENCES public.rate_auto_import_rule(id) ON DELETE CASCADE;


--
-- Name: rate_generation_code_deck rate_generation_code_deck_rate_generation_template_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_code_deck
    ADD CONSTRAINT rate_generation_code_deck_rate_generation_template_id_fkey FOREIGN KEY (rate_generation_template_id) REFERENCES public.rate_generation_template(id) ON DELETE CASCADE;


--
-- Name: rate_generation_history_detail rate_generation_history_detail_email_template_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_history_detail
    ADD CONSTRAINT rate_generation_history_detail_email_template_id_fkey FOREIGN KEY (email_template_id) REFERENCES public.send_rate_template(id) ON DELETE SET NULL;


--
-- Name: rate_generation_history_detail rate_generation_history_detail_rate_generation_history_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_history_detail
    ADD CONSTRAINT rate_generation_history_detail_rate_generation_history_id_fkey FOREIGN KEY (rate_generation_history_id) REFERENCES public.rate_generation_history(id) ON DELETE CASCADE;


--
-- Name: rate_generation_history_detail rate_generation_history_detail_rate_import_task_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_history_detail
    ADD CONSTRAINT rate_generation_history_detail_rate_import_task_id_fkey FOREIGN KEY (rate_import_task_id) REFERENCES public.rate_import_task(id) ON DELETE SET NULL;


--
-- Name: rate_generation_rate rate_generation_rate_rate_generation_history_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_rate
    ADD CONSTRAINT rate_generation_rate_rate_generation_history_id_fkey FOREIGN KEY (rate_generation_history_id) REFERENCES public.rate_generation_history(id) ON DELETE CASCADE;


--
-- Name: rate_generation_template_margin rate_generation_template_margi_rate_generation_template_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_generation_template_margin
    ADD CONSTRAINT rate_generation_template_margi_rate_generation_template_id_fkey FOREIGN KEY (rate_generation_template_id) REFERENCES public.rate_generation_template(id) ON DELETE CASCADE;


--
-- Name: rate_send_log_detail rate_send_log_detail_log_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_send_log_detail
    ADD CONSTRAINT rate_send_log_detail_log_id_fkey FOREIGN KEY (log_id) REFERENCES public.rate_send_log(id) ON DELETE CASCADE;


--
-- Name: rate rate_time_profile_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate
    ADD CONSTRAINT rate_time_profile_id_fkey FOREIGN KEY (time_profile_id) REFERENCES public.time_profile(time_profile_id) ON DELETE CASCADE;


--
-- Name: rate_upload_task rate_upload_task_import_task_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_upload_task
    ADD CONSTRAINT rate_upload_task_import_task_id_fkey FOREIGN KEY (import_task_id) REFERENCES public.rate_import_task(id);


--
-- Name: rate_upload_task rate_upload_task_rule_log_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_upload_task
    ADD CONSTRAINT rate_upload_task_rule_log_id_fkey FOREIGN KEY (rule_log_id) REFERENCES public.rate_auto_import_rule_log(id) ON DELETE SET NULL;


--
-- Name: rate_upload_values rate_upload_values_task_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rate_upload_values
    ADD CONSTRAINT rate_upload_values_task_id_fkey FOREIGN KEY (task_id) REFERENCES public.rate_upload_task(id) ON DELETE CASCADE;


--
-- Name: rerate_cdr_download_log rerate_cdr_download_log_task_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rerate_cdr_download_log
    ADD CONSTRAINT rerate_cdr_download_log_task_id_fkey FOREIGN KEY (task_id) REFERENCES public.rerate_cdr_task(id) ON DELETE SET NULL;


--
-- Name: rerate_report_exec_log rerate_report_exec_log_task_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.rerate_report_exec_log
    ADD CONSTRAINT rerate_report_exec_log_task_id_fkey FOREIGN KEY (task_id) REFERENCES public.rerate_cdr_task(id) ON DELETE SET NULL;


--
-- Name: resource_block resource_block_egress_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_block
    ADD CONSTRAINT resource_block_egress_client_id_fkey FOREIGN KEY (egress_client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: resource_block resource_block_engress_res_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_block
    ADD CONSTRAINT resource_block_engress_res_id_fkey FOREIGN KEY (engress_res_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: resource_block resource_block_ingress_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_block
    ADD CONSTRAINT resource_block_ingress_client_id_fkey FOREIGN KEY (ingress_client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: resource_cid_block_config resource_cid_block_config_resource_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_cid_block_config
    ADD CONSTRAINT resource_cid_block_config_resource_id_fkey FOREIGN KEY (resource_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: resource_codecs_ref resource_codecs_ref_codec_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_codecs_ref
    ADD CONSTRAINT resource_codecs_ref_codec_id_fkey FOREIGN KEY (codec_id) REFERENCES public.codecs(id);


--
-- Name: resource_ext resource_ext_resource_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_ext
    ADD CONSTRAINT resource_ext_resource_id_fkey FOREIGN KEY (resource_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: resource_replace_action resource_replace_action_resource_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_replace_action
    ADD CONSTRAINT resource_replace_action_resource_id_fkey FOREIGN KEY (resource_id) REFERENCES public.resource(resource_id) ON DELETE CASCADE;


--
-- Name: resource resource_shaken_ani_group_list_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource
    ADD CONSTRAINT resource_shaken_ani_group_list_id_fkey FOREIGN KEY (shaken_ani_group_list_id) REFERENCES public.shaken_ani_group_list(id) ON DELETE SET NULL;


--
-- Name: resource resource_shaken_sti_sp_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource
    ADD CONSTRAINT resource_shaken_sti_sp_id_fkey FOREIGN KEY (shaken_sti_sp_id) REFERENCES public.shaken_sti_sp_conf(id) ON DELETE RESTRICT;


--
-- Name: resource_translation_ref resource_translation_ref_resource_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_translation_ref
    ADD CONSTRAINT resource_translation_ref_resource_id_fkey FOREIGN KEY (resource_id) REFERENCES public.resource(resource_id);


--
-- Name: resource_translation_ref resource_translation_ref_time_profile_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_translation_ref
    ADD CONSTRAINT resource_translation_ref_time_profile_id_fkey FOREIGN KEY (time_profile_id) REFERENCES public.time_profile(time_profile_id);


--
-- Name: resource_translation_ref resource_translation_ref_translation_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.resource_translation_ref
    ADD CONSTRAINT resource_translation_ref_translation_id_fkey FOREIGN KEY (translation_id) REFERENCES public.digit_translation(translation_id);


--
-- Name: role_privilege role_privilege_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.role_privilege
    ADD CONSTRAINT role_privilege_role_id_fkey FOREIGN KEY (role_id) REFERENCES public.role(role_id);


--
-- Name: role_privilege role_privilege_system_function_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.role_privilege
    ADD CONSTRAINT role_privilege_system_function_id_fkey FOREIGN KEY (system_function_id) REFERENCES public.system_function(system_function_id);


--
-- Name: role_submenu_rel role_submenu_rel_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.role_submenu_rel
    ADD CONSTRAINT role_submenu_rel_role_id_fkey FOREIGN KEY (role_id) REFERENCES public.role(role_id);


--
-- Name: role_submenu_rel role_submenu_rel_submenu_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.role_submenu_rel
    ADD CONSTRAINT role_submenu_rel_submenu_id_fkey FOREIGN KEY (submenu_id) REFERENCES public.sys_submenu(id);


--
-- Name: send_cdr_direct send_cdr_direct_sender_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.send_cdr_direct
    ADD CONSTRAINT send_cdr_direct_sender_id_fkey FOREIGN KEY (sender_id) REFERENCES public.mail_sender(id) ON DELETE SET NULL;


--
-- Name: send_cdr_direct send_cdr_direct_uuid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.send_cdr_direct
    ADD CONSTRAINT send_cdr_direct_uuid_fkey FOREIGN KEY (uuid) REFERENCES public.cdr_async_task(request_id) ON DELETE CASCADE;


--
-- Name: send_cdr_export_template send_cdr_export_template_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.send_cdr_export_template
    ADD CONSTRAINT send_cdr_export_template_id_fkey FOREIGN KEY (id) REFERENCES public.cdr_export_email_task(id) ON DELETE CASCADE;


--
-- Name: send_cdr_export_template send_cdr_export_template_sender_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.send_cdr_export_template
    ADD CONSTRAINT send_cdr_export_template_sender_id_fkey FOREIGN KEY (sender_id) REFERENCES public.mail_sender(id) ON DELETE SET NULL;


--
-- Name: send_rate_direct send_rate_direct_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.send_rate_direct
    ADD CONSTRAINT send_rate_direct_id_fkey FOREIGN KEY (id) REFERENCES public.rate_send_log(id) ON DELETE CASCADE;


--
-- Name: send_rate_direct send_rate_direct_sender_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.send_rate_direct
    ADD CONSTRAINT send_rate_direct_sender_id_fkey FOREIGN KEY (sender_id) REFERENCES public.mail_sender(id) ON DELETE SET NULL;


--
-- Name: send_rate_template send_rate_template_sender_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.send_rate_template
    ADD CONSTRAINT send_rate_template_sender_id_fkey FOREIGN KEY (sender_id) REFERENCES public.mail_sender(id) ON DELETE SET NULL;


--
-- Name: shaken_ani_group_list_rel shaken_ani_group_list_rel_ani_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_list_rel
    ADD CONSTRAINT shaken_ani_group_list_rel_ani_group_id_fkey FOREIGN KEY (ani_group_id) REFERENCES public.shaken_ani_group(id) ON DELETE CASCADE;


--
-- Name: shaken_ani_group_list_rel shaken_ani_group_list_rel_ani_group_list_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_list_rel
    ADD CONSTRAINT shaken_ani_group_list_rel_ani_group_list_id_fkey FOREIGN KEY (ani_group_list_id) REFERENCES public.shaken_ani_group_list(id) ON DELETE CASCADE;


--
-- Name: shaken_ani_group_rel shaken_ani_group_rel_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.shaken_ani_group_rel
    ADD CONSTRAINT shaken_ani_group_rel_group_id_fkey FOREIGN KEY (group_id) REFERENCES public.shaken_ani_group(id) ON DELETE CASCADE;


--
-- Name: signup_ip signup_ip_signup_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.signup_ip
    ADD CONSTRAINT signup_ip_signup_id_fkey FOREIGN KEY (signup_id) REFERENCES public.signup(id) ON DELETE CASCADE;


--
-- Name: sms_dlr_hook sms_dlr_hook_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sms_dlr_hook
    ADD CONSTRAINT sms_dlr_hook_id_fkey FOREIGN KEY (id) REFERENCES public.sms(id) ON DELETE CASCADE;


--
-- Name: sms_rate sms_rate_sms_rate_table_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sms_rate
    ADD CONSTRAINT sms_rate_sms_rate_table_id_fkey FOREIGN KEY (sms_rate_table_id) REFERENCES public.sms_rate_table(id) ON DELETE CASCADE;


--
-- Name: switch_profile switch_profile_voip_gateway_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.switch_profile
    ADD CONSTRAINT switch_profile_voip_gateway_id_fkey FOREIGN KEY (voip_gateway_id) REFERENCES public.voip_gateway(id) ON DELETE CASCADE;


--
-- Name: sys_submenu sys_submenu_main_menu_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.sys_submenu
    ADD CONSTRAINT sys_submenu_main_menu_id_fkey FOREIGN KEY (main_menu_id) REFERENCES public.sys_main_menu(id) ON DELETE SET NULL;


--
-- Name: system_function system_function_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.system_function
    ADD CONSTRAINT system_function_group_id_fkey FOREIGN KEY (group_id) REFERENCES public.system_function_group(id) ON DELETE SET NULL;


--
-- Name: ticket_attachment ticket_attachment_ticket_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ticket_attachment
    ADD CONSTRAINT ticket_attachment_ticket_id_fkey FOREIGN KEY (ticket_id) REFERENCES public.ticket(id) ON DELETE CASCADE;


--
-- Name: ticket_history ticket_history_ticket_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ticket_history
    ADD CONSTRAINT ticket_history_ticket_id_fkey FOREIGN KEY (ticket_id) REFERENCES public.ticket(id) ON DELETE CASCADE;


--
-- Name: ticket ticket_ticket_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ticket
    ADD CONSTRAINT ticket_ticket_id_fkey FOREIGN KEY (ticket_id) REFERENCES public.ticket(id) ON DELETE CASCADE;


--
-- Name: ticket ticket_user_name_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.ticket
    ADD CONSTRAINT ticket_user_name_fkey FOREIGN KEY (user_name) REFERENCES public.users(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_api_key user_api_key_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.user_api_key
    ADD CONSTRAINT user_api_key_user_id_fkey FOREIGN KEY (user_id) REFERENCES public.users(user_id) ON DELETE CASCADE;


--
-- Name: user_auth_ip user_auth_ip_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.user_auth_ip
    ADD CONSTRAINT user_auth_ip_user_id_fkey FOREIGN KEY (user_id) REFERENCES public.users(user_id) ON DELETE CASCADE;


--
-- Name: user_codedeck_alerts user_codedeck_alerts_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.user_codedeck_alerts
    ADD CONSTRAINT user_codedeck_alerts_user_id_fkey FOREIGN KEY (user_id) REFERENCES public.users(user_id) ON DELETE CASCADE;


--
-- Name: users users_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: users_limit users_limit_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.users_limit
    ADD CONSTRAINT users_limit_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: users_limit users_limit_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.users_limit
    ADD CONSTRAINT users_limit_user_id_fkey FOREIGN KEY (user_id) REFERENCES public.users(user_id) ON DELETE CASCADE;


--
-- Name: users users_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_role_id_fkey FOREIGN KEY (role_id) REFERENCES public.role(role_id) ON DELETE SET NULL;


--
-- Name: voip_gateway_info voip_gateway_info_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.voip_gateway_info
    ADD CONSTRAINT voip_gateway_info_id_fkey FOREIGN KEY (id) REFERENCES public.voip_gateway(id) ON DELETE CASCADE;


--
-- Name: webhook webhook_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: class4_user
--

ALTER TABLE ONLY public.webhook
    ADD CONSTRAINT webhook_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.client(client_id) ON DELETE CASCADE;


--
-- Name: SCHEMA public; Type: ACL; Schema: -; Owner: pg_database_owner
--

GRANT ALL ON SCHEMA public TO class4_user;


--
-- Name: TABLE agent; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.agent TO webbackend;


--
-- Name: SEQUENCE agent_agent_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.agent_agent_id_seq TO webbackend;


--
-- Name: TABLE agent_client_client; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.agent_client_client TO webbackend;


--
-- Name: SEQUENCE agent_client_client_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.agent_client_client_id_seq TO webbackend;


--
-- Name: TABLE agent_client_client_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.agent_client_client_record TO webbackend;


--
-- Name: SEQUENCE agent_client_client_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.agent_client_client_record_record_id_seq TO webbackend;


--
-- Name: TABLE agent_clients; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.agent_clients TO webbackend;


--
-- Name: SEQUENCE agent_clients_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.agent_clients_id_seq TO webbackend;


--
-- Name: TABLE agent_commission_history; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.agent_commission_history TO webbackend;


--
-- Name: TABLE agent_commission_history_detail; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.agent_commission_history_detail TO webbackend;


--
-- Name: SEQUENCE agent_commission_history_detail_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.agent_commission_history_detail_id_seq TO webbackend;


--
-- Name: SEQUENCE agent_commission_history_history_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.agent_commission_history_history_id_seq TO webbackend;


--
-- Name: TABLE agent_commission_payment; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.agent_commission_payment TO webbackend;


--
-- Name: SEQUENCE agent_commission_payment_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.agent_commission_payment_id_seq TO webbackend;


--
-- Name: TABLE alembic_version; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.alembic_version TO webbackend;


--
-- Name: TABLE alert_rules; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.alert_rules TO webbackend;


--
-- Name: SEQUENCE alert_rules_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.alert_rules_id_seq TO webbackend;


--
-- Name: TABLE alert_rules_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.alert_rules_log TO webbackend;


--
-- Name: TABLE alert_rules_log_detail; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.alert_rules_log_detail TO webbackend;


--
-- Name: SEQUENCE alert_rules_log_detail_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.alert_rules_log_detail_id_seq TO webbackend;


--
-- Name: SEQUENCE alert_rules_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.alert_rules_log_id_seq TO webbackend;


--
-- Name: TABLE allowed_sendto_ip; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.allowed_sendto_ip TO webbackend;


--
-- Name: SEQUENCE allowed_sendto_ip_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.allowed_sendto_ip_id_seq TO webbackend;


--
-- Name: TABLE allowed_sendto_ip_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.allowed_sendto_ip_record TO webbackend;


--
-- Name: SEQUENCE allowed_sendto_ip_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.allowed_sendto_ip_record_record_id_seq TO webbackend;


--
-- Name: TABLE async_ftp_export; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.async_ftp_export TO webbackend;


--
-- Name: TABLE auth_token; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.auth_token TO webbackend;


--
-- Name: SEQUENCE auth_token_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.auth_token_id_seq TO webbackend;


--
-- Name: TABLE authorization_logs; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.authorization_logs TO webbackend;


--
-- Name: SEQUENCE authorization_logs_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.authorization_logs_id_seq TO webbackend;


--
-- Name: TABLE auto_rate_import_rule; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.auto_rate_import_rule TO webbackend;


--
-- Name: SEQUENCE auto_rate_import_rule_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.auto_rate_import_rule_id_seq TO webbackend;


--
-- Name: TABLE balance_daily_reset_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.balance_daily_reset_task TO webbackend;


--
-- Name: SEQUENCE balance_daily_reset_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.balance_daily_reset_task_id_seq TO webbackend;


--
-- Name: TABLE balance_history; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.balance_history TO webbackend;


--
-- Name: TABLE balance_history_actual; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.balance_history_actual TO webbackend;


--
-- Name: SEQUENCE balance_history_actual_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.balance_history_actual_id_seq TO webbackend;


--
-- Name: SEQUENCE balance_history_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.balance_history_id_seq TO webbackend;


--
-- Name: TABLE balance_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.balance_log TO webbackend;


--
-- Name: SEQUENCE balance_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.balance_log_id_seq TO webbackend;


--
-- Name: TABLE banned_ip; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.banned_ip TO webbackend;


--
-- Name: TABLE banned_ip_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.banned_ip_record TO webbackend;


--
-- Name: SEQUENCE banned_ip_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.banned_ip_record_record_id_seq TO webbackend;


--
-- Name: TABLE block_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.block_log TO webbackend;


--
-- Name: SEQUENCE block_log_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.block_log_log_id_seq TO webbackend;


--
-- Name: TABLE block_number_import_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.block_number_import_task TO webbackend;


--
-- Name: SEQUENCE block_number_import_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.block_number_import_task_id_seq TO webbackend;


--
-- Name: TABLE c4_client_balance; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4_client_balance TO webbackend;


--
-- Name: SEQUENCE c4_client_balance_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.c4_client_balance_id_seq TO webbackend;


--
-- Name: TABLE c4_livecall_user; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4_livecall_user TO webbackend;


--
-- Name: SEQUENCE c4_livecall_user_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.c4_livecall_user_id_seq TO webbackend;


--
-- Name: TABLE c4_livecall_user_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4_livecall_user_record TO webbackend;


--
-- Name: SEQUENCE c4_livecall_user_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.c4_livecall_user_record_record_id_seq TO webbackend;


--
-- Name: TABLE c4_lrn; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4_lrn TO webbackend;


--
-- Name: SEQUENCE c4_lrn_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.c4_lrn_id_seq TO webbackend;


--
-- Name: TABLE c4_lrn_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4_lrn_record TO webbackend;


--
-- Name: SEQUENCE c4_lrn_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.c4_lrn_record_record_id_seq TO webbackend;


--
-- Name: TABLE c4_shaken_conf; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4_shaken_conf TO webbackend;


--
-- Name: SEQUENCE c4_shaken_conf_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.c4_shaken_conf_id_seq TO webbackend;


--
-- Name: TABLE c4_shaken_conf_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4_shaken_conf_record TO webbackend;


--
-- Name: SEQUENCE c4_shaken_conf_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.c4_shaken_conf_record_record_id_seq TO webbackend;


--
-- Name: TABLE c4_shaken_status; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4_shaken_status TO webbackend;


--
-- Name: SEQUENCE c4_shaken_status_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.c4_shaken_status_id_seq TO webbackend;


--
-- Name: TABLE c4_shaken_status_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4_shaken_status_record TO webbackend;


--
-- Name: SEQUENCE c4_shaken_status_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.c4_shaken_status_record_record_id_seq TO webbackend;


--
-- Name: TABLE c4_us_lerg; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4_us_lerg TO webbackend;


--
-- Name: SEQUENCE c4_us_lerg_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.c4_us_lerg_id_seq TO webbackend;


--
-- Name: TABLE c4db_version; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.c4db_version TO webbackend;


--
-- Name: TABLE calling_call; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.calling_call TO webbackend;


--
-- Name: SEQUENCE calling_call_call_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.calling_call_call_id_seq TO webbackend;


--
-- Name: TABLE calling_queue; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.calling_queue TO webbackend;


--
-- Name: SEQUENCE calling_queue_qid_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.calling_queue_qid_seq TO webbackend;


--
-- Name: TABLE calling_request; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.calling_request TO webbackend;


--
-- Name: TABLE calling_track; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.calling_track TO webbackend;


--
-- Name: TABLE carrier_group; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.carrier_group TO webbackend;


--
-- Name: SEQUENCE carrier_group_group_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.carrier_group_group_id_seq TO webbackend;


--
-- Name: TABLE carrier_template; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.carrier_template TO webbackend;


--
-- Name: SEQUENCE carrier_template_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.carrier_template_id_seq TO webbackend;


--
-- Name: TABLE carrier_template_low_bal_config; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.carrier_template_low_bal_config TO webbackend;


--
-- Name: SEQUENCE cdr_async_task_job_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.cdr_async_task_job_id_seq TO webbackend;


--
-- Name: TABLE cdr_async_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.cdr_async_task TO webbackend;


--
-- Name: TABLE cdr_download_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.cdr_download_task TO webbackend;


--
-- Name: TABLE cdr_export_email_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.cdr_export_email_task TO webbackend;


--
-- Name: TABLE cdr_export_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.cdr_export_log TO webbackend;


--
-- Name: SEQUENCE cdr_export_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.cdr_export_log_id_seq TO webbackend;


--
-- Name: TABLE cdr_export_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.cdr_export_task TO webbackend;


--
-- Name: SEQUENCE cdr_export_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.cdr_export_task_id_seq TO webbackend;


--
-- Name: TABLE cdr_report_daily; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.cdr_report_daily TO webbackend;


--
-- Name: SEQUENCE cdr_report_daily_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.cdr_report_daily_id_seq TO webbackend;


--
-- Name: TABLE cdr_report_detail; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.cdr_report_detail TO webbackend;


--
-- Name: TABLE cdr_rerate; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.cdr_rerate TO webbackend;


--
-- Name: SEQUENCE cdr_rerate_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.cdr_rerate_id_seq TO webbackend;


--
-- Name: SEQUENCE class4_seq_invoice_no; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.class4_seq_invoice_no TO webbackend;


--
-- Name: TABLE client; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.client TO webbackend;


--
-- Name: TABLE client_balance; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.client_balance TO webbackend;


--
-- Name: TABLE client_balance_operation_action; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.client_balance_operation_action TO webbackend;


--
-- Name: SEQUENCE client_balance_operation_action_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.client_balance_operation_action_id_seq TO webbackend;


--
-- Name: SEQUENCE client_cdr_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.client_cdr_id_seq TO webbackend;


--
-- Name: TABLE client_cdr; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.client_cdr TO webbackend;


--
-- Name: SEQUENCE client_client_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.client_client_id_seq TO webbackend;


--
-- Name: TABLE client_default_ip; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.client_default_ip TO webbackend;


--
-- Name: SEQUENCE client_default_ip_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.client_default_ip_id_seq TO webbackend;


--
-- Name: TABLE client_did_product; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.client_did_product TO webbackend;


--
-- Name: TABLE client_invoice_settings; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.client_invoice_settings TO webbackend;


--
-- Name: SEQUENCE client_invoice_settings_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.client_invoice_settings_id_seq TO webbackend;


--
-- Name: TABLE client_low_balance_config; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.client_low_balance_config TO webbackend;


--
-- Name: TABLE client_payment; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.client_payment TO webbackend;


--
-- Name: SEQUENCE client_payment_client_payment_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.client_payment_client_payment_id_seq TO webbackend;


--
-- Name: TABLE client_rate_generation; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.client_rate_generation TO webbackend;


--
-- Name: SEQUENCE client_rate_generation_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.client_rate_generation_id_seq TO webbackend;


--
-- Name: TABLE client_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.client_record TO webbackend;


--
-- Name: SEQUENCE client_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.client_record_record_id_seq TO webbackend;


--
-- Name: TABLE client_taxes; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.client_taxes TO webbackend;


--
-- Name: SEQUENCE client_taxes_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.client_taxes_id_seq TO webbackend;


--
-- Name: TABLE code; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.code TO webbackend;


--
-- Name: SEQUENCE code_code_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.code_code_id_seq TO webbackend;


--
-- Name: TABLE code_country; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.code_country TO webbackend;


--
-- Name: TABLE code_deck; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.code_deck TO webbackend;


--
-- Name: SEQUENCE code_deck_code_deck_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.code_deck_code_deck_id_seq TO webbackend;


--
-- Name: TABLE code_deck_import_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.code_deck_import_task TO webbackend;


--
-- Name: SEQUENCE code_deck_import_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.code_deck_import_task_id_seq TO webbackend;


--
-- Name: TABLE code_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.code_record TO webbackend;


--
-- Name: SEQUENCE code_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.code_record_record_id_seq TO webbackend;


--
-- Name: TABLE code_report; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.code_report TO webbackend;


--
-- Name: TABLE code_report_daily; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.code_report_daily TO webbackend;


--
-- Name: SEQUENCE code_report_daily_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.code_report_daily_id_seq TO webbackend;


--
-- Name: SEQUENCE code_report_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.code_report_id_seq TO webbackend;


--
-- Name: TABLE codecs; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.codecs TO webbackend;


--
-- Name: TABLE credit_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.credit_log TO webbackend;


--
-- Name: SEQUENCE credit_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.credit_log_id_seq TO webbackend;


--
-- Name: TABLE currency; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.currency TO webbackend;


--
-- Name: SEQUENCE currency_currency_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.currency_currency_id_seq TO webbackend;


--
-- Name: TABLE currency_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.currency_record TO webbackend;


--
-- Name: SEQUENCE currency_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.currency_record_record_id_seq TO webbackend;


--
-- Name: TABLE currency_updates; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.currency_updates TO webbackend;


--
-- Name: SEQUENCE currency_updates_currency_updates_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.currency_updates_currency_updates_id_seq TO webbackend;


--
-- Name: TABLE currency_updates_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.currency_updates_record TO webbackend;


--
-- Name: SEQUENCE currency_updates_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.currency_updates_record_record_id_seq TO webbackend;


--
-- Name: TABLE daily_cdr_fields; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.daily_cdr_fields TO webbackend;


--
-- Name: SEQUENCE daily_cdr_fields_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.daily_cdr_fields_id_seq TO webbackend;


--
-- Name: TABLE dashboard_time_option; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dashboard_time_option TO webbackend;


--
-- Name: SEQUENCE dashboard_time_option_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.dashboard_time_option_id_seq TO webbackend;


--
-- Name: SEQUENCE data_clean_management_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.data_clean_management_id_seq TO webbackend;


--
-- Name: TABLE data_clean_management; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.data_clean_management TO webbackend;


--
-- Name: TABLE did_assign; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_assign TO webbackend;


--
-- Name: TABLE did_assignments; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_assignments TO webbackend;


--
-- Name: SEQUENCE did_assignments_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_assignments_id_seq TO webbackend;


--
-- Name: TABLE did_assignments_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_assignments_log TO webbackend;


--
-- Name: SEQUENCE did_assignments_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_assignments_log_id_seq TO webbackend;


--
-- Name: TABLE did_billing_brief; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_billing_brief TO webbackend;


--
-- Name: SEQUENCE did_billing_brief_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_billing_brief_id_seq TO webbackend;


--
-- Name: TABLE did_billing_operation_action; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_billing_operation_action TO webbackend;


--
-- Name: SEQUENCE did_billing_operation_action_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_billing_operation_action_id_seq TO webbackend;


--
-- Name: TABLE did_billing_plan; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_billing_plan TO webbackend;


--
-- Name: SEQUENCE did_billing_plan_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_billing_plan_id_seq TO webbackend;


--
-- Name: TABLE did_billing_plan_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_billing_plan_record TO webbackend;


--
-- Name: SEQUENCE did_billing_plan_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_billing_plan_record_record_id_seq TO webbackend;


--
-- Name: TABLE did_billing_rel; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_billing_rel TO webbackend;


--
-- Name: SEQUENCE did_billing_rel_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_billing_rel_id_seq TO webbackend;


--
-- Name: TABLE did_billing_rel_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_billing_rel_record TO webbackend;


--
-- Name: SEQUENCE did_billing_rel_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_billing_rel_record_record_id_seq TO webbackend;


--
-- Name: TABLE did_charge_detail; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_charge_detail TO webbackend;


--
-- Name: SEQUENCE did_charge_detail_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_charge_detail_id_seq TO webbackend;


--
-- Name: TABLE did_client_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_client_log TO webbackend;


--
-- Name: SEQUENCE did_client_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_client_log_id_seq TO webbackend;


--
-- Name: TABLE did_cost_detail; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_cost_detail TO webbackend;


--
-- Name: SEQUENCE did_cost_detail_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_cost_detail_id_seq TO webbackend;


--
-- Name: TABLE did_disconnect_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_disconnect_task TO webbackend;


--
-- Name: SEQUENCE did_disconnect_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_disconnect_task_id_seq TO webbackend;


--
-- Name: TABLE did_export_async_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_export_async_task TO webbackend;


--
-- Name: SEQUENCE did_export_async_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_export_async_task_id_seq TO webbackend;


--
-- Name: TABLE did_invoice_charge_breakdown; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_invoice_charge_breakdown TO webbackend;


--
-- Name: SEQUENCE did_invoice_charge_breakdown_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_invoice_charge_breakdown_id_seq TO webbackend;


--
-- Name: TABLE did_invoice_charge_detail; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_invoice_charge_detail TO webbackend;


--
-- Name: SEQUENCE did_invoice_charge_detail_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_invoice_charge_detail_id_seq TO webbackend;


--
-- Name: TABLE did_invoice_port_charge; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_invoice_port_charge TO webbackend;


--
-- Name: SEQUENCE did_invoice_port_charge_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_invoice_port_charge_id_seq TO webbackend;


--
-- Name: TABLE did_number_assign_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_number_assign_task TO webbackend;


--
-- Name: SEQUENCE did_number_assign_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_number_assign_task_id_seq TO webbackend;


--
-- Name: TABLE did_number_delete_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_number_delete_task TO webbackend;


--
-- Name: SEQUENCE did_number_delete_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_number_delete_task_id_seq TO webbackend;


--
-- Name: TABLE did_number_upload; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_number_upload TO webbackend;


--
-- Name: SEQUENCE did_number_upload_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_number_upload_task_id_seq TO webbackend;


--
-- Name: TABLE did_number_upload_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_number_upload_task TO webbackend;


--
-- Name: TABLE did_param; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_param TO webbackend;


--
-- Name: TABLE did_product; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_product TO webbackend;


--
-- Name: SEQUENCE did_product_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_product_id_seq TO webbackend;


--
-- Name: TABLE did_product_item; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_product_item TO webbackend;


--
-- Name: SEQUENCE did_product_item_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_product_item_id_seq TO webbackend;


--
-- Name: TABLE did_report; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_report TO webbackend;


--
-- Name: TABLE did_repository; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_repository TO webbackend;


--
-- Name: SEQUENCE did_repository_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_repository_id_seq TO webbackend;


--
-- Name: TABLE did_repository_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_repository_log TO webbackend;


--
-- Name: SEQUENCE did_repository_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_repository_log_id_seq TO webbackend;


--
-- Name: TABLE did_transaction; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_transaction TO webbackend;


--
-- Name: SEQUENCE did_transaction_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_transaction_id_seq TO webbackend;


--
-- Name: TABLE did_vendor_api; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_vendor_api TO webbackend;


--
-- Name: TABLE did_vendor_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.did_vendor_log TO webbackend;


--
-- Name: SEQUENCE did_vendor_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.did_vendor_log_id_seq TO webbackend;


--
-- Name: TABLE digit_translation; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.digit_translation TO webbackend;


--
-- Name: SEQUENCE digit_translation_translation_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.digit_translation_translation_id_seq TO webbackend;


--
-- Name: TABLE disk_management; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.disk_management TO webbackend;


--
-- Name: SEQUENCE disk_management_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.disk_management_id_seq TO webbackend;


--
-- Name: TABLE dnis_type_name; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dnis_type_name TO webbackend;


--
-- Name: SEQUENCE dnis_type_name_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.dnis_type_name_id_seq TO webbackend;


--
-- Name: TABLE dnl_cloud_dbman_cfg; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dnl_cloud_dbman_cfg TO webbackend;


--
-- Name: TABLE dnl_cloud_downloader_cfg; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dnl_cloud_downloader_cfg TO webbackend;


--
-- Name: TABLE dnl_cloud_ftp_cfg; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dnl_cloud_ftp_cfg TO webbackend;


--
-- Name: TABLE dnl_cloud_gcloud_cfg; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dnl_cloud_gcloud_cfg TO webbackend;


--
-- Name: TABLE dnl_cloud_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dnl_cloud_log TO webbackend;


--
-- Name: SEQUENCE dnl_cloud_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.dnl_cloud_log_id_seq TO webbackend;


--
-- Name: TABLE dnl_cloud_search_cfg; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dnl_cloud_search_cfg TO webbackend;


--
-- Name: TABLE dnl_cloud_sftp_cfg; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dnl_cloud_sftp_cfg TO webbackend;


--
-- Name: TABLE dnl_cloud_status; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dnl_cloud_status TO webbackend;


--
-- Name: TABLE dnl_cloud_storages; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dnl_cloud_storages TO webbackend;


--
-- Name: TABLE dnl_daily_cdr_cloud_cfg; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dnl_daily_cdr_cloud_cfg TO webbackend;


--
-- Name: TABLE dynamic_route; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route TO webbackend;


--
-- Name: SEQUENCE dynamic_route_dynamic_route_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.dynamic_route_dynamic_route_id_seq TO webbackend;


--
-- Name: TABLE dynamic_route_items; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route_items TO webbackend;


--
-- Name: SEQUENCE dynamic_route_items_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.dynamic_route_items_id_seq TO webbackend;


--
-- Name: TABLE dynamic_route_items_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route_items_record TO webbackend;


--
-- Name: SEQUENCE dynamic_route_items_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.dynamic_route_items_record_record_id_seq TO webbackend;


--
-- Name: TABLE dynamic_route_override; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route_override TO webbackend;


--
-- Name: SEQUENCE dynamic_route_override_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.dynamic_route_override_id_seq TO webbackend;


--
-- Name: TABLE dynamic_route_override_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route_override_record TO webbackend;


--
-- Name: SEQUENCE dynamic_route_override_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.dynamic_route_override_record_record_id_seq TO webbackend;


--
-- Name: TABLE dynamic_route_pri; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route_pri TO webbackend;


--
-- Name: SEQUENCE dynamic_route_pri_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.dynamic_route_pri_id_seq TO webbackend;


--
-- Name: TABLE dynamic_route_pri_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route_pri_record TO webbackend;


--
-- Name: SEQUENCE dynamic_route_pri_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.dynamic_route_pri_record_record_id_seq TO webbackend;


--
-- Name: TABLE dynamic_route_qos; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route_qos TO webbackend;


--
-- Name: SEQUENCE dynamic_route_qos_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.dynamic_route_qos_id_seq TO webbackend;


--
-- Name: TABLE dynamic_route_qos_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route_qos_record TO webbackend;


--
-- Name: SEQUENCE dynamic_route_qos_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.dynamic_route_qos_record_record_id_seq TO webbackend;


--
-- Name: TABLE dynamic_route_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.dynamic_route_record TO webbackend;


--
-- Name: SEQUENCE dynamic_route_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.dynamic_route_record_record_id_seq TO webbackend;


--
-- Name: TABLE egress_error_string; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.egress_error_string TO webbackend;


--
-- Name: SEQUENCE egress_error_string_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.egress_error_string_id_seq TO webbackend;


--
-- Name: TABLE egress_profile; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.egress_profile TO webbackend;


--
-- Name: SEQUENCE egress_profile_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.egress_profile_id_seq TO webbackend;


--
-- Name: TABLE egress_profile_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.egress_profile_record TO webbackend;


--
-- Name: SEQUENCE egress_profile_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.egress_profile_record_record_id_seq TO webbackend;


--
-- Name: TABLE email_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.email_log TO webbackend;


--
-- Name: SEQUENCE email_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.email_log_id_seq TO webbackend;


--
-- Name: TABLE execution_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.execution_log TO webbackend;


--
-- Name: SEQUENCE execution_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.execution_log_id_seq TO webbackend;


--
-- Name: TABLE fault_route_alert_rule; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.fault_route_alert_rule TO webbackend;


--
-- Name: SEQUENCE fault_route_alert_rule_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.fault_route_alert_rule_id_seq TO webbackend;


--
-- Name: TABLE fault_route_alert_rule_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.fault_route_alert_rule_log TO webbackend;


--
-- Name: SEQUENCE fault_route_alert_rule_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.fault_route_alert_rule_log_id_seq TO webbackend;


--
-- Name: TABLE file; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.file TO webbackend;


--
-- Name: TABLE fraud_detection; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.fraud_detection TO webbackend;


--
-- Name: SEQUENCE fraud_detection_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.fraud_detection_id_seq TO webbackend;


--
-- Name: TABLE fraud_detection_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.fraud_detection_log TO webbackend;


--
-- Name: TABLE fraud_detection_log_detail; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.fraud_detection_log_detail TO webbackend;


--
-- Name: SEQUENCE fraud_detection_log_detail_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.fraud_detection_log_detail_id_seq TO webbackend;


--
-- Name: SEQUENCE fraud_detection_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.fraud_detection_log_id_seq TO webbackend;


--
-- Name: TABLE frund_detection; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.frund_detection TO webbackend;


--
-- Name: TABLE frund_detection_history; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.frund_detection_history TO webbackend;


--
-- Name: SEQUENCE frund_detection_history_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.frund_detection_history_id_seq TO webbackend;


--
-- Name: SEQUENCE frund_detection_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.frund_detection_id_seq TO webbackend;


--
-- Name: TABLE ftp_cdr; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.ftp_cdr TO webbackend;


--
-- Name: TABLE ftp_cdr_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.ftp_cdr_log TO webbackend;


--
-- Name: TABLE ftp_cdr_log_detail; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.ftp_cdr_log_detail TO webbackend;


--
-- Name: SEQUENCE ftp_cdr_log_detail_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.ftp_cdr_log_detail_id_seq TO webbackend;


--
-- Name: SEQUENCE ftp_cdr_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.ftp_cdr_log_id_seq TO webbackend;


--
-- Name: TABLE ftp_conf; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.ftp_conf TO webbackend;


--
-- Name: SEQUENCE ftp_conf_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.ftp_conf_id_seq TO webbackend;


--
-- Name: TABLE ftp_server_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.ftp_server_log TO webbackend;


--
-- Name: SEQUENCE ftp_server_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.ftp_server_log_id_seq TO webbackend;


--
-- Name: TABLE global_route_error; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.global_route_error TO webbackend;


--
-- Name: SEQUENCE global_route_error_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.global_route_error_id_seq TO webbackend;


--
-- Name: TABLE global_route_error_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.global_route_error_record TO webbackend;


--
-- Name: SEQUENCE global_route_error_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.global_route_error_record_record_id_seq TO webbackend;


--
-- Name: TABLE host_based_report; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.host_based_report TO webbackend;


--
-- Name: TABLE import_export_logs; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.import_export_logs TO webbackend;


--
-- Name: SEQUENCE import_export_logs_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.import_export_logs_id_seq TO webbackend;


--
-- Name: TABLE import_rate_file_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.import_rate_file_log TO webbackend;


--
-- Name: SEQUENCE import_rate_file_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.import_rate_file_log_id_seq TO webbackend;


--
-- Name: TABLE import_rate_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.import_rate_log TO webbackend;


--
-- Name: SEQUENCE import_rate_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.import_rate_log_id_seq TO webbackend;


--
-- Name: TABLE import_rate_status; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.import_rate_status TO webbackend;


--
-- Name: SEQUENCE import_rate_status_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.import_rate_status_id_seq TO webbackend;


--
-- Name: TABLE import_target_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.import_target_log TO webbackend;


--
-- Name: SEQUENCE import_target_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.import_target_log_id_seq TO webbackend;


--
-- Name: TABLE ingress_did_repository; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.ingress_did_repository TO webbackend;


--
-- Name: TABLE invoice; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.invoice TO webbackend;


--
-- Name: TABLE invoice_cdr_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.invoice_cdr_log TO webbackend;


--
-- Name: SEQUENCE invoice_cdr_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.invoice_cdr_log_id_seq TO webbackend;


--
-- Name: SEQUENCE invoice_daily_detail_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.invoice_daily_detail_id_seq TO webbackend;


--
-- Name: TABLE invoice_debug; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.invoice_debug TO webbackend;


--
-- Name: SEQUENCE invoice_debug_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.invoice_debug_id_seq TO webbackend;


--
-- Name: TABLE invoice_email; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.invoice_email TO webbackend;


--
-- Name: SEQUENCE invoice_email_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.invoice_email_id_seq TO webbackend;


--
-- Name: TABLE invoice_history; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.invoice_history TO webbackend;


--
-- Name: SEQUENCE invoice_history_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.invoice_history_id_seq TO webbackend;


--
-- Name: SEQUENCE invoice_invoice_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.invoice_invoice_id_seq TO webbackend;


--
-- Name: TABLE invoice_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.invoice_log TO webbackend;


--
-- Name: SEQUENCE invoice_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.invoice_log_id_seq TO webbackend;


--
-- Name: TABLE invoice_payment; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.invoice_payment TO webbackend;


--
-- Name: SEQUENCE invoice_payment_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.invoice_payment_id_seq TO webbackend;


--
-- Name: TABLE invoice_settings; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.invoice_settings TO webbackend;


--
-- Name: SEQUENCE invoice_settings_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.invoice_settings_id_seq TO webbackend;


--
-- Name: TABLE invoice_summary; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.invoice_summary TO webbackend;


--
-- Name: SEQUENCE invoice_summary_invoice_number_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.invoice_summary_invoice_number_seq TO webbackend;


--
-- Name: TABLE invoice_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.invoice_task TO webbackend;


--
-- Name: SEQUENCE invoice_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.invoice_task_id_seq TO webbackend;


--
-- Name: SEQUENCE invoice_trunk_prefix_detail_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.invoice_trunk_prefix_detail_id_seq TO webbackend;


--
-- Name: TABLE ip_modif_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.ip_modif_log TO webbackend;


--
-- Name: SEQUENCE ip_modif_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.ip_modif_log_id_seq TO webbackend;


--
-- Name: TABLE jur_type_name; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.jur_type_name TO webbackend;


--
-- Name: SEQUENCE jur_type_name_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.jur_type_name_id_seq TO webbackend;


--
-- Name: TABLE jurisdiction_prefix; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.jurisdiction_prefix TO webbackend;


--
-- Name: SEQUENCE jurisdiction_prefix_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.jurisdiction_prefix_id_seq TO webbackend;


--
-- Name: TABLE jurisdiction_prefix_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.jurisdiction_prefix_record TO webbackend;


--
-- Name: SEQUENCE jurisdiction_prefix_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.jurisdiction_prefix_record_record_id_seq TO webbackend;


--
-- Name: TABLE jurisdiction_update_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.jurisdiction_update_log TO webbackend;


--
-- Name: SEQUENCE jurisdiction_update_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.jurisdiction_update_log_id_seq TO webbackend;


--
-- Name: TABLE kill_pg_sql_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.kill_pg_sql_log TO webbackend;


--
-- Name: SEQUENCE kill_pg_sql_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.kill_pg_sql_log_id_seq TO webbackend;


--
-- Name: SEQUENCE lcr_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.lcr_task_id_seq TO webbackend;


--
-- Name: TABLE lcr_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.lcr_task TO webbackend;


--
-- Name: TABLE lcr_test; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.lcr_test TO webbackend;


--
-- Name: SEQUENCE lcr_test_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.lcr_test_id_seq TO webbackend;


--
-- Name: SEQUENCE lcr_test_id_seq1; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.lcr_test_id_seq1 TO webbackend;


--
-- Name: TABLE lcr_test_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.lcr_test_log TO webbackend;


--
-- Name: SEQUENCE lcr_test_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.lcr_test_log_id_seq TO webbackend;


--
-- Name: SEQUENCE lcr_test_log_id_seq1; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.lcr_test_log_id_seq1 TO webbackend;


--
-- Name: TABLE lerg; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.lerg TO webbackend;


--
-- Name: TABLE lerg_download_schedule; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.lerg_download_schedule TO webbackend;


--
-- Name: SEQUENCE lerg_download_schedule_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.lerg_download_schedule_id_seq TO webbackend;


--
-- Name: TABLE lerg_download_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.lerg_download_task TO webbackend;


--
-- Name: TABLE lerg_import_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.lerg_import_task TO webbackend;


--
-- Name: TABLE loop_detection; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.loop_detection TO webbackend;


--
-- Name: TABLE loop_detection_detail; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.loop_detection_detail TO webbackend;


--
-- Name: SEQUENCE loop_detection_detail_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.loop_detection_detail_id_seq TO webbackend;


--
-- Name: SEQUENCE loop_detection_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.loop_detection_id_seq TO webbackend;


--
-- Name: TABLE mail_cdr_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.mail_cdr_log TO webbackend;


--
-- Name: TABLE mail_cdr_log_detail; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.mail_cdr_log_detail TO webbackend;


--
-- Name: SEQUENCE mail_cdr_log_detail_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.mail_cdr_log_detail_id_seq TO webbackend;


--
-- Name: SEQUENCE mail_cdr_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.mail_cdr_log_id_seq TO webbackend;


--
-- Name: TABLE mail_sender; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.mail_sender TO webbackend;


--
-- Name: SEQUENCE mail_sender_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.mail_sender_id_seq TO webbackend;


--
-- Name: TABLE mail_template; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.mail_template TO webbackend;


--
-- Name: TABLE media_asr_filter; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.media_asr_filter TO webbackend;


--
-- Name: SEQUENCE media_asr_filter_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.media_asr_filter_id_seq TO webbackend;


--
-- Name: TABLE media_capture_filter; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.media_capture_filter TO webbackend;


--
-- Name: SEQUENCE media_capture_filter_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.media_capture_filter_id_seq TO webbackend;


--
-- Name: TABLE modif_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.modif_log TO webbackend;


--
-- Name: SEQUENCE modif_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.modif_log_id_seq TO webbackend;


--
-- Name: TABLE monitored_rule; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.monitored_rule TO webbackend;


--
-- Name: TABLE monitored_rule_history; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.monitored_rule_history TO webbackend;


--
-- Name: SEQUENCE monitored_rule_history_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.monitored_rule_history_id_seq TO webbackend;


--
-- Name: SEQUENCE monitored_rule_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.monitored_rule_id_seq TO webbackend;


--
-- Name: TABLE object_revision; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.object_revision TO webbackend;


--
-- Name: SEQUENCE object_revision_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.object_revision_id_seq TO webbackend;


--
-- Name: TABLE object_revision_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.object_revision_record TO webbackend;


--
-- Name: SEQUENCE object_revision_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.object_revision_record_id_seq TO webbackend;


--
-- Name: TABLE ocn_blocklist; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.ocn_blocklist TO webbackend;


--
-- Name: SEQUENCE ocn_blocklist_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.ocn_blocklist_id_seq TO webbackend;


--
-- Name: TABLE ocn_blocklist_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.ocn_blocklist_record TO webbackend;


--
-- Name: SEQUENCE ocn_blocklist_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.ocn_blocklist_record_record_id_seq TO webbackend;


--
-- Name: TABLE orig_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.orig_log TO webbackend;


--
-- Name: SEQUENCE orig_log_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.orig_log_log_id_seq TO webbackend;


--
-- Name: TABLE origination_global_failover; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.origination_global_failover TO webbackend;


--
-- Name: SEQUENCE origination_global_failover_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.origination_global_failover_id_seq TO webbackend;


--
-- Name: TABLE origination_global_failover_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.origination_global_failover_record TO webbackend;


--
-- Name: SEQUENCE origination_global_failover_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.origination_global_failover_record_record_id_seq TO webbackend;


--
-- Name: TABLE partition_gateway_ref; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.partition_gateway_ref TO webbackend;


--
-- Name: SEQUENCE partition_gateway_ref_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.partition_gateway_ref_id_seq TO webbackend;


--
-- Name: TABLE partition_gateway_ref_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.partition_gateway_ref_record TO webbackend;


--
-- Name: SEQUENCE partition_gateway_ref_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.partition_gateway_ref_record_record_id_seq TO webbackend;


--
-- Name: TABLE payment_gateway_history; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.payment_gateway_history TO webbackend;


--
-- Name: SEQUENCE payment_gateway_history_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.payment_gateway_history_id_seq TO webbackend;


--
-- Name: TABLE payment_invoice; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.payment_invoice TO webbackend;


--
-- Name: SEQUENCE payment_invoice_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.payment_invoice_id_seq TO webbackend;


--
-- Name: TABLE payment_term; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.payment_term TO webbackend;


--
-- Name: SEQUENCE payment_term_payment_term_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.payment_term_payment_term_id_seq TO webbackend;


--
-- Name: TABLE payment_term_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.payment_term_record TO webbackend;


--
-- Name: SEQUENCE payment_term_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.payment_term_record_record_id_seq TO webbackend;


--
-- Name: TABLE pcap_query; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.pcap_query TO webbackend;


--
-- Name: TABLE pcap_query_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.pcap_query_task TO webbackend;


--
-- Name: SEQUENCE pcap_query_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.pcap_query_task_id_seq TO webbackend;


--
-- Name: TABLE pcap_query_task_mail; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.pcap_query_task_mail TO webbackend;


--
-- Name: TABLE product; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product TO webbackend;


--
-- Name: TABLE product_agents_ref; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_agents_ref TO webbackend;


--
-- Name: SEQUENCE product_agents_ref_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.product_agents_ref_id_seq TO webbackend;


--
-- Name: TABLE product_clients_ref; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_clients_ref TO webbackend;


--
-- Name: SEQUENCE product_clients_ref_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.product_clients_ref_id_seq TO webbackend;


--
-- Name: TABLE product_clients_ref_used; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_clients_ref_used TO webbackend;


--
-- Name: SEQUENCE product_clients_ref_used_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.product_clients_ref_used_id_seq TO webbackend;


--
-- Name: TABLE product_codename; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_codename TO webbackend;


--
-- Name: SEQUENCE product_codename_item_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.product_codename_item_id_seq TO webbackend;


--
-- Name: TABLE product_codename_resource; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_codename_resource TO webbackend;


--
-- Name: SEQUENCE product_codename_resource_item_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.product_codename_resource_item_id_seq TO webbackend;


--
-- Name: TABLE product_items; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_items TO webbackend;


--
-- Name: SEQUENCE product_items_item_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.product_items_item_id_seq TO webbackend;


--
-- Name: TABLE product_items_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_items_record TO webbackend;


--
-- Name: SEQUENCE product_items_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.product_items_record_record_id_seq TO webbackend;


--
-- Name: TABLE product_items_resource; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_items_resource TO webbackend;


--
-- Name: SEQUENCE product_items_resource_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.product_items_resource_id_seq TO webbackend;


--
-- Name: TABLE product_items_resource_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_items_resource_record TO webbackend;


--
-- Name: SEQUENCE product_items_resource_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.product_items_resource_record_record_id_seq TO webbackend;


--
-- Name: SEQUENCE product_product_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.product_product_id_seq TO webbackend;


--
-- Name: TABLE product_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_record TO webbackend;


--
-- Name: SEQUENCE product_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.product_record_record_id_seq TO webbackend;


--
-- Name: TABLE product_rout_rate_table; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_rout_rate_table TO webbackend;


--
-- Name: SEQUENCE product_rout_rate_table_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.product_rout_rate_table_id_seq TO webbackend;


--
-- Name: TABLE product_rout_rate_table_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_rout_rate_table_record TO webbackend;


--
-- Name: SEQUENCE product_rout_rate_table_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.product_rout_rate_table_record_record_id_seq TO webbackend;


--
-- Name: TABLE product_route_analysis; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_route_analysis TO webbackend;


--
-- Name: TABLE product_route_analysis_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.product_route_analysis_log TO webbackend;


--
-- Name: SEQUENCE product_route_analysis_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.product_route_analysis_log_id_seq TO webbackend;


--
-- Name: TABLE qos_client; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.qos_client TO webbackend;


--
-- Name: TABLE qos_ip; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.qos_ip TO webbackend;


--
-- Name: TABLE qos_resource; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.qos_resource TO webbackend;


--
-- Name: TABLE qos_route_report; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.qos_route_report TO webbackend;


--
-- Name: TABLE qos_total; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.qos_total TO webbackend;


--
-- Name: TABLE random_ani_generation; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.random_ani_generation TO webbackend;


--
-- Name: SEQUENCE random_ani_generation_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.random_ani_generation_id_seq TO webbackend;


--
-- Name: TABLE random_ani_generation_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.random_ani_generation_record TO webbackend;


--
-- Name: SEQUENCE random_ani_generation_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.random_ani_generation_record_record_id_seq TO webbackend;


--
-- Name: TABLE random_ani_group; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.random_ani_group TO webbackend;


--
-- Name: SEQUENCE random_ani_group_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.random_ani_group_id_seq TO webbackend;


--
-- Name: TABLE random_ani_group_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.random_ani_group_record TO webbackend;


--
-- Name: SEQUENCE random_ani_group_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.random_ani_group_record_record_id_seq TO webbackend;


--
-- Name: TABLE rate; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate TO webbackend;


--
-- Name: SEQUENCE rate_analysis_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_analysis_task_id_seq TO webbackend;


--
-- Name: TABLE rate_analysis_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_analysis_task TO webbackend;


--
-- Name: TABLE rate_auto_import_mailbox_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_auto_import_mailbox_log TO webbackend;


--
-- Name: SEQUENCE rate_auto_import_mailbox_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_auto_import_mailbox_log_id_seq TO webbackend;


--
-- Name: TABLE rate_auto_import_rule; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_auto_import_rule TO webbackend;


--
-- Name: SEQUENCE rate_auto_import_rule_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_auto_import_rule_id_seq TO webbackend;


--
-- Name: TABLE rate_auto_import_rule_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_auto_import_rule_log TO webbackend;


--
-- Name: SEQUENCE rate_auto_import_rule_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_auto_import_rule_log_id_seq TO webbackend;


--
-- Name: TABLE rate_download_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_download_log TO webbackend;


--
-- Name: SEQUENCE rate_download_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_download_log_id_seq TO webbackend;


--
-- Name: TABLE rate_generation_code_deck; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_generation_code_deck TO webbackend;


--
-- Name: TABLE rate_generation_history; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_generation_history TO webbackend;


--
-- Name: SEQUENCE rate_generation_history_detail_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_generation_history_detail_id_seq TO webbackend;


--
-- Name: TABLE rate_generation_history_detail; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_generation_history_detail TO webbackend;


--
-- Name: SEQUENCE rate_generation_history_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_generation_history_id_seq TO webbackend;


--
-- Name: TABLE rate_generation_rate; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_generation_rate TO webbackend;


--
-- Name: SEQUENCE rate_generation_rate_generation_rate_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_generation_rate_generation_rate_id_seq TO webbackend;


--
-- Name: TABLE rate_generation_template; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_generation_template TO webbackend;


--
-- Name: TABLE rate_generation_template_detail; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_generation_template_detail TO webbackend;


--
-- Name: SEQUENCE rate_generation_template_detail_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_generation_template_detail_id_seq TO webbackend;


--
-- Name: SEQUENCE rate_generation_template_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_generation_template_id_seq TO webbackend;


--
-- Name: TABLE rate_generation_template_margin; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_generation_template_margin TO webbackend;


--
-- Name: SEQUENCE rate_generation_template_margin_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_generation_template_margin_id_seq TO webbackend;


--
-- Name: SEQUENCE rate_import_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_import_task_id_seq TO webbackend;


--
-- Name: TABLE rate_import_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_import_task TO webbackend;


--
-- Name: TABLE rate_mass_edit_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_mass_edit_log TO webbackend;


--
-- Name: SEQUENCE rate_mass_edit_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_mass_edit_log_id_seq TO webbackend;


--
-- Name: SEQUENCE rate_rate_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_rate_id_seq TO webbackend;


--
-- Name: TABLE rate_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_record TO webbackend;


--
-- Name: SEQUENCE rate_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_record_record_id_seq TO webbackend;


--
-- Name: TABLE rate_send_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_send_log TO webbackend;


--
-- Name: TABLE rate_send_log_detail; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_send_log_detail TO webbackend;


--
-- Name: SEQUENCE rate_send_log_detail_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_send_log_detail_id_seq TO webbackend;


--
-- Name: SEQUENCE rate_send_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_send_log_id_seq TO webbackend;


--
-- Name: TABLE rate_table; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_table TO webbackend;


--
-- Name: SEQUENCE rate_table_rate_table_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_table_rate_table_id_seq TO webbackend;


--
-- Name: TABLE rate_table_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_table_record TO webbackend;


--
-- Name: SEQUENCE rate_table_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_table_record_record_id_seq TO webbackend;


--
-- Name: TABLE rate_type_name; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_type_name TO webbackend;


--
-- Name: SEQUENCE rate_type_name_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_type_name_id_seq TO webbackend;


--
-- Name: TABLE rate_type_override; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_type_override TO webbackend;


--
-- Name: SEQUENCE rate_type_override_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_type_override_id_seq TO webbackend;


--
-- Name: TABLE rate_type_override_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_type_override_record TO webbackend;


--
-- Name: SEQUENCE rate_type_override_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_type_override_record_record_id_seq TO webbackend;


--
-- Name: TABLE rate_upload_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_upload_task TO webbackend;


--
-- Name: SEQUENCE rate_upload_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_upload_task_id_seq TO webbackend;


--
-- Name: TABLE rate_upload_template; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_upload_template TO webbackend;


--
-- Name: SEQUENCE rate_upload_template_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_upload_template_id_seq TO webbackend;


--
-- Name: TABLE rate_upload_values; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rate_upload_values TO webbackend;


--
-- Name: SEQUENCE rate_upload_values_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rate_upload_values_id_seq TO webbackend;


--
-- Name: TABLE register_of_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.register_of_record TO webbackend;


--
-- Name: SEQUENCE register_of_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.register_of_record_id_seq TO webbackend;


--
-- Name: TABLE release_cause_string; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.release_cause_string TO webbackend;


--
-- Name: SEQUENCE release_cause_string_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.release_cause_string_id_seq TO webbackend;


--
-- Name: TABLE report_template; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.report_template TO webbackend;


--
-- Name: SEQUENCE report_template_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.report_template_id_seq TO webbackend;


--
-- Name: TABLE rerate_cdr_download_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rerate_cdr_download_log TO webbackend;


--
-- Name: SEQUENCE rerate_cdr_download_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rerate_cdr_download_log_id_seq TO webbackend;


--
-- Name: TABLE rerate_cdr_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rerate_cdr_task TO webbackend;


--
-- Name: SEQUENCE rerate_cdr_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rerate_cdr_task_id_seq TO webbackend;


--
-- Name: TABLE rerate_report_exec_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rerate_report_exec_log TO webbackend;


--
-- Name: SEQUENCE rerate_report_exec_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rerate_report_exec_log_id_seq TO webbackend;


--
-- Name: TABLE resource; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource TO webbackend;


--
-- Name: TABLE resource_block; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_block TO webbackend;


--
-- Name: TABLE resource_block_items; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_block_items TO webbackend;


--
-- Name: SEQUENCE resource_block_items_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_block_items_id_seq TO webbackend;


--
-- Name: TABLE resource_block_items_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_block_items_record TO webbackend;


--
-- Name: SEQUENCE resource_block_items_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_block_items_record_record_id_seq TO webbackend;


--
-- Name: TABLE resource_block_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_block_record TO webbackend;


--
-- Name: SEQUENCE resource_block_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_block_record_record_id_seq TO webbackend;


--
-- Name: SEQUENCE resource_block_res_block_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_block_res_block_id_seq TO webbackend;


--
-- Name: TABLE resource_capacity; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_capacity TO webbackend;


--
-- Name: TABLE resource_capacity_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_capacity_record TO webbackend;


--
-- Name: SEQUENCE resource_capacity_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_capacity_record_record_id_seq TO webbackend;


--
-- Name: TABLE resource_cid_block_config; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_cid_block_config TO webbackend;


--
-- Name: TABLE resource_cid_block_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_cid_block_log TO webbackend;


--
-- Name: SEQUENCE resource_cid_block_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_cid_block_log_id_seq TO webbackend;


--
-- Name: TABLE resource_codecs_ref; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_codecs_ref TO webbackend;


--
-- Name: SEQUENCE resource_codecs_ref_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_codecs_ref_id_seq TO webbackend;


--
-- Name: TABLE resource_codecs_ref_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_codecs_ref_record TO webbackend;


--
-- Name: SEQUENCE resource_codecs_ref_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_codecs_ref_record_record_id_seq TO webbackend;


--
-- Name: TABLE resource_direction; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_direction TO webbackend;


--
-- Name: SEQUENCE resource_direction_direction_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_direction_direction_id_seq TO webbackend;


--
-- Name: TABLE resource_direction_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_direction_record TO webbackend;


--
-- Name: SEQUENCE resource_direction_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_direction_record_record_id_seq TO webbackend;


--
-- Name: TABLE resource_ext; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_ext TO webbackend;


--
-- Name: SEQUENCE resource_ext_resource_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_ext_resource_id_seq TO webbackend;


--
-- Name: TABLE resource_ip; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_ip TO webbackend;


--
-- Name: TABLE resource_ip_limit; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_ip_limit TO webbackend;


--
-- Name: SEQUENCE resource_ip_limit_limit_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_ip_limit_limit_id_seq TO webbackend;


--
-- Name: TABLE resource_ip_limit_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_ip_limit_record TO webbackend;


--
-- Name: SEQUENCE resource_ip_limit_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_ip_limit_record_record_id_seq TO webbackend;


--
-- Name: TABLE resource_ip_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_ip_record TO webbackend;


--
-- Name: SEQUENCE resource_ip_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_ip_record_record_id_seq TO webbackend;


--
-- Name: SEQUENCE resource_ip_resource_ip_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_ip_resource_ip_id_seq TO webbackend;


--
-- Name: TABLE resource_lrn_action; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_lrn_action TO webbackend;


--
-- Name: SEQUENCE resource_lrn_action_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_lrn_action_id_seq TO webbackend;


--
-- Name: TABLE resource_lrn_action_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_lrn_action_record TO webbackend;


--
-- Name: SEQUENCE resource_lrn_action_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_lrn_action_record_record_id_seq TO webbackend;


--
-- Name: TABLE resource_next_route_rule; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_next_route_rule TO webbackend;


--
-- Name: SEQUENCE resource_next_route_rule_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_next_route_rule_id_seq TO webbackend;


--
-- Name: TABLE resource_next_route_rule_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_next_route_rule_record TO webbackend;


--
-- Name: SEQUENCE resource_next_route_rule_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_next_route_rule_record_record_id_seq TO webbackend;


--
-- Name: TABLE resource_prefix; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_prefix TO webbackend;


--
-- Name: SEQUENCE resource_prefix_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_prefix_id_seq TO webbackend;


--
-- Name: TABLE resource_prefix_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_prefix_record TO webbackend;


--
-- Name: SEQUENCE resource_prefix_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_prefix_record_record_id_seq TO webbackend;


--
-- Name: TABLE resource_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_record TO webbackend;


--
-- Name: SEQUENCE resource_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_record_record_id_seq TO webbackend;


--
-- Name: TABLE resource_replace_action; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_replace_action TO webbackend;


--
-- Name: SEQUENCE resource_replace_action_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_replace_action_id_seq TO webbackend;


--
-- Name: TABLE resource_replace_action_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_replace_action_record TO webbackend;


--
-- Name: SEQUENCE resource_replace_action_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_replace_action_record_record_id_seq TO webbackend;


--
-- Name: SEQUENCE resource_resource_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_resource_id_seq TO webbackend;


--
-- Name: TABLE resource_template; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_template TO webbackend;


--
-- Name: SEQUENCE resource_template_resource_template_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_template_resource_template_id_seq TO webbackend;


--
-- Name: TABLE resource_translation_ref; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_translation_ref TO webbackend;


--
-- Name: TABLE resource_translation_ref_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.resource_translation_ref_record TO webbackend;


--
-- Name: SEQUENCE resource_translation_ref_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_translation_ref_record_record_id_seq TO webbackend;


--
-- Name: SEQUENCE resource_translation_ref_ref_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.resource_translation_ref_ref_id_seq TO webbackend;


--
-- Name: TABLE retrieve_password_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.retrieve_password_log TO webbackend;


--
-- Name: SEQUENCE retrieve_password_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.retrieve_password_log_id_seq TO webbackend;


--
-- Name: TABLE role; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.role TO webbackend;


--
-- Name: TABLE role_privilege; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.role_privilege TO webbackend;


--
-- Name: SEQUENCE role_privilege_role_privilege_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.role_privilege_role_privilege_id_seq TO webbackend;


--
-- Name: SEQUENCE role_role_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.role_role_id_seq TO webbackend;


--
-- Name: TABLE role_submenu_rel; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.role_submenu_rel TO webbackend;


--
-- Name: SEQUENCE role_submenu_rel_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.role_submenu_rel_id_seq TO webbackend;


--
-- Name: TABLE route; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.route TO webbackend;


--
-- Name: TABLE route_block; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.route_block TO webbackend;


--
-- Name: SEQUENCE route_block_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.route_block_id_seq TO webbackend;


--
-- Name: TABLE route_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.route_record TO webbackend;


--
-- Name: SEQUENCE route_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.route_record_record_id_seq TO webbackend;


--
-- Name: SEQUENCE route_route_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.route_route_id_seq TO webbackend;


--
-- Name: TABLE route_strategy; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.route_strategy TO webbackend;


--
-- Name: SEQUENCE route_strategy_route_strategy_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.route_strategy_route_strategy_id_seq TO webbackend;


--
-- Name: TABLE rtp_proxy_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.rtp_proxy_log TO webbackend;


--
-- Name: SEQUENCE rtp_proxy_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.rtp_proxy_log_id_seq TO webbackend;


--
-- Name: TABLE scheduled_report_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.scheduled_report_log TO webbackend;


--
-- Name: SEQUENCE scheduled_report_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.scheduled_report_log_id_seq TO webbackend;


--
-- Name: TABLE scheduler_log; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.scheduler_log TO webbackend;


--
-- Name: SEQUENCE scheduler_log_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.scheduler_log_id_seq TO webbackend;


--
-- Name: TABLE send_cdr_direct; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.send_cdr_direct TO webbackend;


--
-- Name: TABLE send_cdr_export_template; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.send_cdr_export_template TO webbackend;


--
-- Name: TABLE send_mails; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.send_mails TO webbackend;


--
-- Name: SEQUENCE send_mails_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.send_mails_id_seq TO webbackend;


--
-- Name: TABLE send_rate_direct; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.send_rate_direct TO webbackend;


--
-- Name: TABLE send_rate_template; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.send_rate_template TO webbackend;


--
-- Name: SEQUENCE send_rate_template_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.send_rate_template_id_seq TO webbackend;


--
-- Name: TABLE service_charge_items; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.service_charge_items TO webbackend;


--
-- Name: SEQUENCE service_charge_items_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.service_charge_items_id_seq TO webbackend;


--
-- Name: TABLE service_charge_items_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.service_charge_items_record TO webbackend;


--
-- Name: SEQUENCE service_charge_items_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.service_charge_items_record_record_id_seq TO webbackend;


--
-- Name: TABLE shaken_ani_group; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.shaken_ani_group TO webbackend;


--
-- Name: SEQUENCE shaken_ani_group_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.shaken_ani_group_id_seq TO webbackend;


--
-- Name: TABLE shaken_ani_group_list; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.shaken_ani_group_list TO webbackend;


--
-- Name: SEQUENCE shaken_ani_group_list_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.shaken_ani_group_list_id_seq TO webbackend;


--
-- Name: TABLE shaken_ani_group_list_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.shaken_ani_group_list_record TO webbackend;


--
-- Name: SEQUENCE shaken_ani_group_list_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.shaken_ani_group_list_record_record_id_seq TO webbackend;


--
-- Name: TABLE shaken_ani_group_list_rel; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.shaken_ani_group_list_rel TO webbackend;


--
-- Name: SEQUENCE shaken_ani_group_list_rel_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.shaken_ani_group_list_rel_id_seq TO webbackend;


--
-- Name: TABLE shaken_ani_group_list_rel_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.shaken_ani_group_list_rel_record TO webbackend;


--
-- Name: SEQUENCE shaken_ani_group_list_rel_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.shaken_ani_group_list_rel_record_record_id_seq TO webbackend;


--
-- Name: TABLE shaken_ani_group_rel; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.shaken_ani_group_rel TO webbackend;


--
-- Name: TABLE shaken_ani_group_rel_import_task; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.shaken_ani_group_rel_import_task TO webbackend;


--
-- Name: SEQUENCE shaken_ani_group_rel_import_task_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.shaken_ani_group_rel_import_task_id_seq TO webbackend;


--
-- Name: TABLE shaken_ani_group_rel_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.shaken_ani_group_rel_record TO webbackend;


--
-- Name: SEQUENCE shaken_ani_group_rel_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.shaken_ani_group_rel_record_record_id_seq TO webbackend;


--
-- Name: SEQUENCE shaken_sti_sp_conf_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.shaken_sti_sp_conf_id_seq TO webbackend;


--
-- Name: TABLE shaken_sti_sp_conf; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.shaken_sti_sp_conf TO webbackend;


--
-- Name: TABLE shaken_sti_sp_conf_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.shaken_sti_sp_conf_record TO webbackend;


--
-- Name: SEQUENCE shaken_sti_sp_conf_record_record_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.shaken_sti_sp_conf_record_record_id_seq TO webbackend;


--
-- Name: TABLE signal_capture_filter; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.signal_capture_filter TO webbackend;


--
-- Name: SEQUENCE signal_capture_filter_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.signal_capture_filter_id_seq TO webbackend;


--
-- Name: TABLE signup; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.signup TO webbackend;


--
-- Name: SEQUENCE signup_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.signup_id_seq TO webbackend;


--
-- Name: TABLE signup_ip; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.signup_ip TO webbackend;


--
-- Name: SEQUENCE signup_ip_id_seq; Type: ACL; Schema: public; Owner: class4_user
--

GRANT USAGE ON SEQUENCE public.signup_ip_id_seq TO webbackend;


--
-- Name: TABLE sip_error_code; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.sip_error_code TO webbackend;


--
-- Name: TABLE sip_error_code_record; Type: ACL; Schema: public; Owner: class4_user
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.sip_error_c