#from distutils.core import setup
from setuptools import setup,find_packages,find_namespace_packages
from api_dnl.__version__ import __version__
from setuptools.command.install import install
import atexit
API_HOME='/opt/denovo_v6/api_dnl'
BIN_HOME='/usr/local/bin'
with open('requirements.txt') as f:
    required = f.read().splitlines()

def _post_install():
    import os
    os.system('cp -n {}/.config_files/* {}/'.format(API_HOME, API_HOME))
    os.system('/usr/bin/sudo useradd -d {} webbackend'.format(API_HOME))
    os.system('/usr/bin/sudo chown -R webbackend:webbackend {}'.format(API_HOME))
    # for m in ('run','worker','beat','pjsipcall','pcapload','ws_broker'):
    #     os.system('sudo {}/nuitka3 --show-progress --follow-imports {}/api_dnl_{}'.format(BIN_HOME,BIN_HOME,m))
    #os.system('sudo cp /usr/local/lib/python3.5/site-packages/api_dnl/etc/supervisor.d/api_dnl.ini /etc/supervisor.d/api_dnl.ini')
    #os.system('sudo cp /usr/local/lib/python3.5/site-packages/api_dnl/etc/ngnix/default.d/api_dnl.conf /ngnix/default.d/api_dnl.conf')

class new_install(install):
    def __init__(self, *args, **kwargs):
        super(new_install, self).__init__(*args, **kwargs)
        atexit.register(_post_install)



setup(
    name='api-dnl',
    version=__version__,
#    packages=['api_dnl'],
#    packages=find_packages(include=['api_dnl']),
    packages=find_packages(),
    url='http://stash.denovolab.com/projects/CLAS6/repos/webbackend/browse',
    license='MIT',
    author='novvvster',
    author_email='novvvster@gmail.com',
    description='DNL Class4V6 REST API',
    install_requires=[r for r in required if not 'git+' in r],
    data_files=[('./',['requirements.txt']),
                (API_HOME+'/schema',['schema/schema.sql','schema/data.sql','schema/class4_update_record.sql']),
                ('/etc/supervisord.d',['api_dnl/etc/supervisord.d/api_dnl.ini']),
                ('/etc/nginx/default.d',['api_dnl/etc/nginx/default.d/api_dnl.conf']),
                (API_HOME+'/.config_files',['api.ini','alembic.ini']),
                (API_HOME+'/files',['.keep']),
                (API_HOME+'/files/invoices',['.keep'])
                ],
    cmdclass={'install': new_install},
    entry_points={
        'console_scripts': [
            'api_dnl_pcaploader = api_dnl.task.pcaploader:main_func',
            'api_dnl_pjsipcall = api_dnl.task.pjsip_testcall:main_func',
            'api_dnl_ws_broker = api_dnl.task.ws_broker:run',
            'api_dnl_run = api_dnl.utils.run:my_gunicorn [gunicorn]',
            'api_dnl_worker = api_dnl.utils.run:my_worker [celery,gevent]',
            'api_dnl_beat = api_dnl.utils.run:my_beat',
        ]
    },

    extras_require={
        'gevent':  ["gevent==1.2.2"],
        'celery':  ["celery==4.1.1","billiard==3.5.0.5",'kombu==4.2.0'],
        'gunicorn': ["gunicorn>=19.7.1"],

    },

    # dependency_links=[
    #     "git+ssh://git@stash.denovolab.com:7999/af/falcon_rest.git",
    #     "git+https://github.com/dpallot/simple-websocket-server.git"
    # ]
)



