"""replace_actions csacade

Revision ID: aeb7bac01749
Revises: 7dedf59ddb8f
Create Date: 2017-11-06 23:03:39.937608

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'aeb7bac01749'
down_revision = '7dedf59ddb8f'
branch_labels = None
depends_on = None


def upgrade():
    
    
    connection = op.get_bind()
    connection.execute("delete from origination_global_failover where ctid not in (select max(ctid) from origination_global_failover s  group by s.from_sip_code)")
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index(op.f('ix_balance_history_actual_date'), 'balance_history_actual', ['date'], unique=False)
    op.create_unique_constraint(None, 'origination_global_failover', ['from_sip_code'])
    op.drop_constraint('fkey_resource_replace_action_resource_resource_id', 'resource_replace_action', type_='foreignkey')
    op.create_foreign_key(None, 'resource_replace_action', 'resource', ['resource_id'], ['resource_id'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'resource_replace_action', type_='foreignkey')
    op.create_foreign_key('fkey_resource_replace_action_resource_resource_id', 'resource_replace_action', 'resource', ['resource_id'], ['resource_id'])
    op.drop_constraint(None, 'origination_global_failover', type_='unique')
    op.drop_index(op.f('ix_balance_history_actual_date'), table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date', 'client_id'], unique=True)
    # ### end Alembic commands ###
