import celery
from api_dnl import settings
from datetime import datetime,timedelta
from pytz import UTC
from time import mktime
import io,csv,gzip,zipfile
import xlwt
import json
import traceback
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select,alias,case
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import Client,Client,Resource,Rate,RateTable,RateSendLog,BalanceHistoryActual,C4ClientBalance,\
    RateSendLogDetail,CrdReportDetailTable,MailSender,FraudDetection,FraudDetectionLog,FraudDetectionLogDetail,\
    ResourceBlock,IngressTrunk,SystemParameter,AlertRule,AlertRuleLog,AlertRulesLogDetail,CdrReportDetail,client_cdr,\
    ImportExportLogs,User
from api_dnl.model import PrimaryKeyConstraint,func,query_to_sting,cast,generate_uuid_str
from api_dnl.tasks import app,log,db,SqlAlchemyTask,SchLog
from api_dnl import model
from api_dnl.utils.statisticapi2 import StatisticAPI
from api_dnl.utils.ws_broker_api import WSBrokerAPI
from api_dnl.scheme import RateScheme,ValidationError,BaseModelScheme
from api_dnl import view
from api_dnl.view import _create_get,_scheme,IntegrityError
from api_dnl.utils.imp_exp import (csv2xls,dict_to_csv)

@app.task(base=SqlAlchemyTask)
def do_import_file():
    log.debug('Import file started')
    sr=ImportExportLogs.filter(and_(ImportExportLogs.log_type == 'import',ImportExportLogs.status=='initial')).all()
    log.debug('Import file waiting {}'.format(len(sr)))
    #tasks = [send_rate_task.s(r.id) for r in sr]
    #results = group(tasks)()
    #log.debug('Send rate group results:'.format(results.get()))
    work = ImportExportLogs.filter(and_(ImportExportLogs.log_type == 'import',
                                        ImportExportLogs.status=='in progress', ImportExportLogs.task_uuid.isnot(None))).first()
    if work:
        if work.time < datetime.now(UTC)-timedelta(hours=4):
            log.debug('Import file {} timeout...count as failed'.format(work.id))
            work.status = 'fail'
            work.task_uuid = None
            work.save()
        else:
            log.debug('Import file working on {}...skip'.format(work.id))
        return
    todo = ImportExportLogs.filter(and_(ImportExportLogs.log_type == 'import',ImportExportLogs.status=='initial',ImportExportLogs.task_uuid.is_(None))).first()
    if todo:
        log.debug('Import file will start {}...'.format(todo.id))
        ret = import_file.delay(todo.id)
        todo.task_uuid = ret.id
        todo.save()
    else:
        log.debug('Import file nothing todo...skip'.format(work))
    #for r in ImportExportLogs.filter(status='initial').all():
    #    import_file.delay(r.id)
    #    send_rate_task.apply_async(args=(r.id,),coundown=0.5)
    #log.debug('Send rate initiate finished')

class LocalLog():
    def __init__(self,error_file_path):
        self.error_file_path = error_file_path
        self.local_file_err = None
    def _log(self,msg,item=None,e=None):
        if not self.local_file_err:
            self.local_file_err = open(self.error_file_path, 'wt')
        if item:
            self.local_file_err.write(json.dumps(item))
        self.local_file_err.write(str(msg))
        if e:
            try:
                self.local_file_err.write(str(e))
            except Exception as e1:
                self.local_file_err.write('cannot save exception')
                pass
        self.local_file_err.write('\r\n')

class CallbackTask(SqlAlchemyTask):
    def on_success(self, retval, task_id, args, kwargs):
        obj = ImportExportLogs.get(args[0])
        obj.finished_time = datetime.now(UTC)
        obj.status = 'success'
        obj.task_uuid = None
        obj.save()
        pass

    def on_failure(self, exc, task_id, args, kwargs, einfo):
        obj = ImportExportLogs.get(args[0])
        obj.finished_time = datetime.now(UTC)
        obj.status = 'fail'
        obj.task_uuid = None
        obj.save()
        pass


# @app.task(base=CallbackTask, time_limit=288000, soft_time_limit=287400)
@app.task(base=SqlAlchemyTask, time_limit=288000, soft_time_limit=287400)
def import_file(id):
    obj = ImportExportLogs.get(id)
    if obj.status == 'in progress':
        slog = SchLog('import_file already running')
        return True
    if obj.log_type != 'import':
        log.debug('import_file got not not import id {}'.format(id))
        return
    if 'upload_ani_dnis' in obj._query:
        return upload_ani_dnis(id)
    obj.status = 'in progress'
    # obj.time = datetime.now(UTC)
    obj.records_succ = 0
    obj.records_fail = 0
    obj.records_dup = 0
    obj.save()

    ws = WSBrokerAPI()
    ws.set_task_id('import_file', id)

    file_path = obj.file_path + '/' + obj.file_name
    error_file_path = obj.file_path + '/' + obj.error_file_path
    loc = LocalLog(error_file_path)
    try:
        text_obj = open(file_path, 'rt').read()
        q = obj._query
        fmt = q['format']
        if fmt not in ('png', 'jpg'):
            if obj.obj not in model.__dict__:
                raise ValidationError('Entity does not exists :{}'.format(obj.obj))
            if 'delete_dublicates' in obj._query and obj._query['delete_dublicates'] == 'true':
                delete_dublicates = True
            else:
                delete_dublicates = False
            delete_mode = None
            if 'delete_mode' in obj._query and obj._query['delete_mode']:
                delete_mode = obj._query['delete_mode']
            if 'ignore_invalid_fields' in obj._query and obj._query['ignore_invalid_fields'] == 'true':
                ignore_invalid_fields = True
            else:
                ignore_invalid_fields = False
            obj.records_succ = 0
            obj.records_fail = 0
            obj.records_dup = 0
            if obj.obj in 'User':
                obj.status = 'fail'
                obj.save()
                return False
            create = _create_get(obj.obj)
            if not create:
                loc._log('Import file Cannot find entity create resource :{}'.format(obj.obj))
                log.warning('Import file Cannot find create resource for entity:{}'.format(obj.obj))
                obj.status = 'fail'
                obj.save()
                return False
                # raise ValidationError('Cannot find entity create resource :{}'.format(obj.obj))
            cls = model.__dict__[obj.obj]  # create.model_class
            BaseSchemeClass = _scheme(obj.obj)
            if not BaseSchemeClass:
                log.warning('Scheme class for {} not found. Use default.'.format(obj.obj))
                BaseSchemeClass = BaseModelScheme

            class SchemeClass(BaseSchemeClass):
                class Meta:
                    model = cls
                    fields = []

            meta = inspect(cls)
            colnames = [c.name for c in meta.columns]
            synames = list(meta.synonyms.keys())
            # Use text_obj how you see fit!
            file = io.StringIO(text_obj)
            from api_dnl.utils.imp_exp import JsonReader, XmlReader
            if fmt == 'csv':
                reader = csv.DictReader(file)
                max_lines = len(text_obj.split('\n'))
            elif fmt == 'json':
                reader = JsonReader(file)
                max_lines = len(reader.data)
            elif fmt == 'xml':
                reader = XmlReader(file)
                max_lines = len(reader.data)
            else:
                raise ValidationError('Not supported import format: {}'.format(fmt))
            ignore = []
            if 'ignore_fields' in obj._query:
                ignore = obj._query['ignore_fields'].split(',')

            replace = {}
            if 'replace_fields' in obj._query:
                rnames = obj._query['replace_fields'].split(',')
                if not 'replace_values' in obj._query:
                    raise ValidationError('No values for replace!')
                rvalues = obj._query['replace_values'].split(',')
                if len(rnames) != len(rvalues):
                    raise ValidationError('Values for replace not match with names!')
                replace = dict(zip(rnames, rvalues))
            key = meta.primary_key[0]
            dup_keys = []
            dup_key_names = None
            if hasattr(create, 'import_key_fields'):
                dup_key_names = create.import_key_fields
            else:
                dup_key_names = [key.name]
            for dup_key_name in dup_key_names:
                if not dup_key_name in colnames:
                    raise ValidationError('Wrong field for unique key!')
                else:
                    dup_keys.append(meta.columns[dup_key_name])
            line_number=0
            for item in reader:
                if line_number%100==0:
                    ws.notify(100*line_number/(max_lines or 1))
                line_number = line_number + 1
                accepted_fields = []
                for i in item:
                    if i in colnames + synames and not i in ignore:
                        accepted_fields.append(i)
                SchemeClass.Meta.fields = list(set(list(BaseSchemeClass.Meta.fields) + accepted_fields))


                item_ = {}
                for i in item:
                    if i in replace:
                        item_[i] = replace[i]
                        continue
                    if i in ignore:
                        continue
                    if item[i] in ['', 'None']:
                        continue
                        # item_[i] = None
                    # item_[i]=str(item[i])
                    if isinstance(item[i], datetime):
                        item_[i] = str(item[i])
                    else:
                        item_[i] = item[i]
                    continue

                # inject missing fields
                for i in replace:
                    if not i in item_:
                        item_[i] = replace[i]
                try:
                    scheme = SchemeClass().load(item_)
                except Exception as e:
                    loc._log('Row not imported bad scheme:', item_, e)
                    obj.records_fail += 1
                    obj.status = 'fail'
                    continue
                if scheme.errors:
                    if ignore_invalid_fields:
                        loc._log('Import warning: fields not imported:' + json.dumps(scheme.errors), item_)
                        for err in scheme.errors:
                            if err in item_:
                                del item_[err]
                        scheme = SchemeClass().load(item_)
                        if scheme.errors:
                            loc._log('Import row not imported schema errors:' + json.dumps(scheme.errors), item_)
                            obj.records_fail += 1
                            obj.status = 'fail'
                            continue
                    else:
                        loc._log('Import error fields invalid:' + json.dumps(scheme.errors), item_)
                        obj.records_fail += 1
                        obj.status = 'fail'
                        continue

                try:
                    # rec = cls(**scheme.data)
                    rec = scheme.data

                    filt = []
                    for dup_key in dup_keys:
                        filt.append((dup_key == getattr(rec,dup_key.name, None)))
                    filt = and_(*tuple(filt))
                    if delete_mode:
                        if hasattr(cls, 'on_import_delete'):
                            cls.on_import_delete(rec,delete_mode)
                            obj.records_dup += 1
                        else:
                            ret = cls.filter(filt).delete(synchronize_session='fetch')
                            if ret:
                                obj.records_dup += 1
                                db.session.commit()
                        continue
                    if delete_dublicates:
                        ret = cls.filter(filt).delete(synchronize_session='fetch')
                        if ret:
                            obj.records_dup += 1
                            db.session.commit()
                    else:
                        inst = cls.filter(filt).first()
                        if inst:
                            loc._log('Import: skip duplicate: {}'.format(str(rec)))
                            obj.records_dup += 1
                            if (obj.records_dup % 100) == 0:
                                obj.save()
                                log.warning('Import: skip duplicates: {}'.format(obj.records_dup))
                            continue
                    try:
                        _create = create()
                        from falcon import Request
                        req = Request({'wsgi.input': None, 'wsgi.errors': None, 'REQUEST_METHOD': 'post', 'PATH_INFO': None})
                        req.data = item_
                        req.context['user']=User.get(obj.user_id)
                        _create.init_req(req)
                        rec = _create.before_create(rec, **item_)
                    except Exception as e:
                        loc._log('Import: not processed before import record:', item_,e)
                        log.warning('Import: not processed before import record: {}'.format(str(e)))
                        pass
                    try:
                        if 'update_by' in colnames:
                            rec.update_by = model.User.get(obj.user_id).name+' initiated file import'
                        if 'update_on' in colnames:
                            rec.udate_on = datetime.now(UTC)
                        if 'update_at' in colnames:
                            rec.udate_at = datetime.now(UTC)
                    except Exception as e:
                        loc._log('Import: not processed update_by set: {}'.format(str(e)))
                        log.warning('Import: not processed update_by set: {}'.format(str(e)))
                        pass

                    rec.save()  # (save_history=True, user=loc.get_user(loc.req))
                    obj.records_succ += 1
                    if (obj.records_succ % 10)==1:
                        obj.status = 'in progress'
                        obj.save()
                    continue
                except IntegrityError  as e:
                    msg = str(e).split('\n')[1].split(':')[1]
                    loc._log('Import: Row not imported constraint violation:' + str(msg), item_)
                    obj.records_dup += 1
                    if (obj.records_dup % 10)==1:
                        obj.save()
                    # obj.status = 'fail'
                    continue
                except Exception as e:
                    loc._log('Import: Row not imported general error:', item_, e)
                    obj.records_fail += 1
                    obj.status = 'fail'
                    if (obj.records_fail % 10)==1:
                        obj.save()
                    # obj.status = 'fail'
                    continue
        # local_file.close()
        if loc.local_file_err:
            loc.local_file_err.close()
        # else:
        #    obj.error_file_path = None
        obj.finished_time = datetime.now()
        obj.status = 'success'
        obj.save()
        ws.state('success')

        return True
    except Exception as e:
        loc._log('Import failure: {}'.format(str(e)))
        if loc.local_file_err:
            loc.local_file_err.close()
        obj.status = 'fail'
        obj.save()
        log.error('Import failure: {}'.format(str(e)))
        ws.state('fail')

        raise ValidationError('Import failure: {}'.format(traceback.format_exc()))

    slog.close()

def upload_ani_dnis(id):
    obj = ImportExportLogs.get(id)
    slog = SchLog('import_resource_block_ani_dnis')
    obj.status = 'in progress'
    #obj.time = datetime.now(UTC)
    obj.records_succ = 0
    obj.records_fail = 0
    obj.records_dup = 0
    obj.save()
    file_path = obj.file_path + '/' + obj.file_name
    error_file_path = obj.file_path + '/' + obj.error_file_path
    local_file_err = None
    loc = LocalLog(error_file_path)
    try:
        text_obj = open(file_path, 'rt').read()
        q=obj._query
        number_type = q.get('number_type','ANI')
        clients_type = q.get('clients_type','Origination')
        block_by = q.get('block_by',None)
        client_id = q.get('client_id',None)
        trunk_id = q.get('trunk_id',None)
        delete_dublicates = q.get('delete_dublicates',False)
        fmt= q.get('format','csv')
        delete_mode = None
        if 'delete_mode' in obj._query and obj._query['delete_mode']:
            delete_mode = obj._query['delete_mode']
        if not fmt in ('png', 'jpg'):
            if not obj.obj in model.__dict__:
                raise ValidationError('Entity does not exists :{}'.format(obj.obj))
            obj.records_succ = 0
            obj.records_fail = 0
            obj.records_dup = 0
            create = _create_get(obj.obj)
            if not create:
                loc._log('Import file Cannot find entity create resource :{}'.format(obj.obj))
                log.warning('Import file Cannot find create resource for entity:{}'.format(obj.obj))
                #raise ValidationError('Cannot find entity create resource :{}'.format(obj.obj))
            #cls = model.__dict__[obj.obj]  # create.model_class
            cls = model.ResourceBlock
            BaseSchemeClass = _scheme(obj.obj)
            if not BaseSchemeClass:
                log.warning('Scheme class for {} not found. Use default.'.format(obj.obj))
                BaseSchemeClass = BaseModelScheme

            class SchemeClass(BaseSchemeClass):
                class Meta:
                    model = cls
                    fields = []

            meta = inspect(cls)
            colnames = [c.name for c in meta.columns]
            synames = list(meta.synonyms.keys())
            # Use text_obj how you see fit!
            file = io.StringIO(text_obj)
            from api_dnl.utils.imp_exp import JsonReader, XmlReader
            if fmt == 'csv':
                reader = csv.DictReader(file)
            elif fmt == 'json':
                reader = JsonReader(file)
            elif fmt == 'xml':
                reader = XmlReader(file)
            else:
                raise ValidationError('Not supported import format: {}'.format(fmt))
            ignore = []

            replace = {}
            if 'replace_fields' in obj._query:
                rnames = obj._query['replace_fields'].split(',')
                if not 'replace_values' in obj._query:
                    raise ValidationError('No values for replace!')
                rvalues = obj._query['replace_values'].split(',')
                if len(rnames) != len(rvalues):
                    raise ValidationError('Values for replace not match with names!')
                replace = dict(zip(rnames, rvalues))
            key = meta.primary_key[0]
            dup_key = None
            dup_key_name = None

            fields=['block_type']
            if number_type == 'ANI':
                key_name = 'ani_prefix'
                dup_key_name = 'ani_prefix'
                alt_name = 'ANI_prefix'
                fields.append('ani_prefix')
            else:
                key_name = 'digit'
                dup_key_name = 'digit'
                alt_name = 'DNIS_prefix'
                fields.append('digit')
            dup_key = meta.columns[dup_key_name]

            dup_keys = []
            dup_key_names = None
            if hasattr(create, 'import_key_fields'):
                dup_key_names = create.import_key_fields
            else:
                dup_key_names = [key.name]
            for dup_key_name in dup_key_names:
                if not dup_key_name in colnames:
                    raise ValidationError('Wrong field for unique key!')
                else:
                    dup_keys.append(meta.columns[dup_key_name])


            def_val = dict()
            if clients_type == 'Origination':
                if block_by == 'block by trunk':
                    def_val['ingress_res_id'] = trunk_id
                    def_val['block_type'] = 'specific trunk'
                    fields.append('ingress_res_id')
                elif block_by == 'block by group':
                    def_val['ingress_group_id'] = trunk_id
                    def_val['block_type'] = 'specific group'
                    fields.append('ingress_group_id')
                else:
                    if client_id:
                        def_val['ingress_client_id'] = client_id
                        def_val['block_type'] = 'specific carrier'
                        fields.append('ingress_client_id')
                    else:
                        def_val['block_type'] = 'all'
            else:#Termination
                if block_by == 'block by trunk':
                    def_val['engress_res_id'] = trunk_id
                    def_val['block_type'] = 'specific trunk'
                    fields.append('ingress_res_id')
                elif block_by == 'block by group':
                    def_val['egress_group_id'] = trunk_id
                    def_val['block_type'] = 'specific group'
                    fields.append('ingress_group_id')
                else:
                    if client_id:
                        def_val['egress_client_id'] = client_id
                        def_val['block_type'] = 'specific carrier'
                        fields.append('ingress_client_id')
                    else:
                        def_val['block_type'] = 'all'
            SchemeClass.Meta.fields = fields  # list(set(list(BaseSchemeClass.Meta.fields) + fields))
            for item in reader:
                item_ = {}
                if key_name in item:
                    item_[key_name] = str(item[key_name])
                elif alt_name in item:
                    item_[key_name] = str(item[alt_name])
                else:
                    if type(list(item.values())[0]) == type([]):
                        item_[key_name] = str(list(item.values())[0][0])
                    else:
                        item_[key_name] = str(list(item.values())[0])
                # inject missing fields
                for i in def_val:
                    if not i in item_:
                        item_[i] = def_val[i]
                try:
                    scheme = SchemeClass().load(item_)
                except Exception as e:
                    loc._log('Row not imported bad scheme:', item_, e)
                    obj.records_fail += 1
                    obj.status = 'fail'
                    continue
                if scheme.errors:
                    loc._log('Import warning: fields not imported:' + json.dumps(scheme.errors), item_)
                    for err in scheme.errors:
                        if err in item_:
                            del item_[err]
                    scheme = SchemeClass().load(item_)
                    if scheme.errors:
                        loc._log('Import row not imported schema errors:' + json.dumps(scheme.errors), item_)
                        obj.records_fail += 1
                        obj.status = 'fail'
                        continue
                try:
                    # rec = cls(**scheme.data)
                    rec = scheme.data
                    if delete_mode:
                        ret = cls.filter(getattr(cls, key_name) == getattr(rec, key_name)).delete(synchronize_session='fetch')
                        if ret:
                            cls.session().commit()
                        obj.records_dup += 1
                        continue
                    try:
                        _create = create()
                        from falcon import Request
                        req = Request({'wsgi.input': None, 'wsgi.errors': None, 'REQUEST_METHOD': 'post', 'PATH_INFO': None})
                        req.data = item_
                        req.context['user']=User.get(obj.user_id)
                        _create.init_req(req)
                        rec = _create.before_create(rec, **item_)
                    except Exception as e:
                        loc._log('Warning import: not processed before import record:', item_,e)
                        log.warning('Warning import: not processed before import record: {}'.format(str(e)))
                        pass
                    try:
                        if 'update_by' in colnames:
                            rec.update_by = model.User.get(obj.user_id).name+' initiated file import'
                        if 'create_by' in colnames:
                            rec.create_by = model.User.get(obj.user_id).name+' initiated file import'
                        if 'update_on' in colnames:
                            rec.udate_on = datetime.now(UTC)
                        if 'update_at' in colnames:
                            rec.udate_at = datetime.now(UTC)
                        if 'block_at' in colnames:
                            rec.block_at = int(datetime.now(UTC).timestamp())
                    except Exception as e:
                        loc._log('Import: not processed update_by set: {}'.format(str(e)))
                        log.warning('Import: not processed update_by set: {}'.format(str(e)))
                        pass
                    #filt = (dup_key == getattr(rec.dup_key_name,None))
                    filt = []
                    for dup_key in dup_keys:
                        filt.append((dup_key == getattr(rec, dup_key.name, None)))
                    filt = and_(*tuple(filt))

                    if delete_dublicates:
                        ret=cls.filter(filt).delete(synchronize_session='fetch')
                        if ret:
                            db.session.commit()
                    else:
                        inst = cls.filter(filt).first()
                        if inst:
                            loc._log('Import: skip duplicate: {}'.format(str(rec)))
                            log.warning('Import: skip duplicate: {}'.format(str(rec)))
                            obj.records_dup += 1
                            # continue

                    rec.save()  # (save_history=True, user=loc.get_user(loc.req))
                    obj.records_succ += 1
                    if (obj.records_succ % 10)==1:
                        obj.status = 'in progress'
                        obj.save()
                    continue
                except IntegrityError  as e:
                    msg = str(e).split('\n')[1].split(':')[1]
                    loc._log('Import: Row not imported constraint violation:' + str(msg), item_)
                    obj.records_dup += 1
                    if (obj.records_dup % 10)==1:
                        obj.save()
                    # obj.status = 'fail'
                    continue
                except Exception as e:
                    loc._log('Import: Row not imported general error:', item_, e)
                    obj.records_fail += 1
                    obj.status = 'fail'
                    if (obj.records_fail % 10)==1:
                        obj.save()
                    # obj.status = 'fail'
                    continue
        #local_file.close()
        if loc.local_file_err:
            loc.local_file_err.close()
        #else:
        #    obj.error_file_path = None
        obj.finished_time = datetime.now()
        obj.status = 'success'
        obj.save()
        return True
    except Exception as e:
        loc._log('Import failure: {}'.format(str(e)))
        if loc.local_file_err:
            loc.local_file_err.close()
        obj.status = 'fail'
        obj.save()
        log.error('Import failure: {}'.format(str(e)))
        raise ValidationError('Import failure: {}'.format(traceback.format_exc()))
    slog.close()

    return