from .did_api import DidAPI
from api_dnl.model import log, DidBillingRel, Client, Resource, DidRepository, DidAssignments
from api_dnl import model
from sqlalchemy import not_, and_, or_, func


class DidAPIManual(DidAPI):
    def __init__(self, user, password=None, vendor=None):
        self.vendor = vendor

    def coverage_local(self, country=None, state=None, npa=None, lata=None,group=None):
        def object_as_dict(obj):
            if obj:
                return {key: getattr(obj, key) for key in obj._fields}
            else:
                return {}
        log.debug('manual vendor COVERAGE ')
        cls = DidBillingRel
        ret = []
        _select=[func.count(cls.did.distinct()).label('tn_count'),cls.country]
        _group=[cls.country]
        _filter=[]
        if country:
            _filter.append(cls.country==country)
        if state:
            _filter.append(cls.state==state)
        if npa:
            _filter.append(cls.npa == npa)
        if lata:
            _filter.append(cls.lata == lata)
        if group:
            if 'state' in group:
                _select.append(cls.state)
                _group.append(cls.state)
            if 'npa' in group:
                _select.append(cls.npa)
                _group.append(cls.npa)
            if 'lata' in group:
                _select.append(cls.lata)
                _group.append(cls.lata)
        q = cls.session().query(*_select).filter(and_(and_(*_filter),
                                                      cls.end_date.is_(None),cls.egress_res_id.is_(None))).group_by(*_group)
        ret=[]
        for item in q:
            ret.append(object_as_dict(item))
        return ret


    def order_local(self, items, client_id=None):
        log.debug('manual vendor order {}'.format(items))
        cls = DidRepository
        ret = []
        for i in items:
            did = cls.filter(
                and_(or_(cls.did.like('_' + i['number']), cls.did == i['number']), cls.is_toll_free == False,
                     cls.vendor_trunk_id.isnot(None)
                     )).first()
            if did:
                vendor_id = client_id
                ret.append(dict(number=i['number'], vendor_id=vendor_id, status='success'))
            else:
                ret.append(
                    dict(number=i['number'], status='error', error='number:{} not in repository'.format(i['number'])))
        log.debug('manual vendor returned:{}'.format(ret))
        return ret

    def search_local(self, country=None, state=None, npa=None, lata=None, pattern=None, count=100, client_id=None, nxx=None):
        log.debug('manual vendor search state={} lata={} pattern={} count={}'.format(state, lata, pattern, count))
        cls = DidRepository
        filt = and_(cls.is_toll_free == False, cls.is_assigned == False,
                    cls.vendor_trunk_id.isnot(None))
        if npa is not None:
            filt = and_(filt, or_(
                and_(func.substr(cls.did, 2, 3) == npa, func.length(cls.did) == 11),
                and_(func.substr(cls.did, 1, 3) == npa, func.length(cls.did) < 10),
            )
                        )
        if nxx is not None:
            filt = and_(filt, or_(
                and_(func.substr(cls.did, 5, 3) == nxx, func.length(cls.did) == 11),
                and_(func.substr(cls.did, 4, 3) == nxx, func.length(cls.did) < 10),
            )
                        )
        if pattern is not None:
            pat = pattern.replace('*', '_').replace('x', '_') + '%'
            pat1 = '_' + pattern
            filt = and_(filt, or_(cls.did.like(pat), cls.did.like(pat1)))
        if state is not None:
            filt = and_(filt, cls.state == state)
        if lata is not None:
            filt = and_(filt, cls.lata == lata)
        if country is not None:
            filt = and_(filt, cls.country == country)
        subquery = model.get_db().session.query(DidAssignments).filter(DidAssignments.did == cls.did).exists()
        filt = and_(filt, not_(subquery))
        # if client_id is not None:
        #     client_products = DidProductItem.filter(DidProductItem.client_id == client_id).all()
        #     allowed_ids = [client_product.billing_rule_id for client_product in client_products]
        #     filt = and_(filt, cls.buy_billing_plan_id.in_(allowed_ids))
        ret = []
        for did in cls.filter(filt):
            vendor_id = client_id
            ret.append(dict(number=did.did, vendor_id=vendor_id, country=did.country,state=did.state,lata=did.lata,
                            mrc=did.mrc, nrc=did.nrc, npa=did.npa, rate_table_id=did.rate_table_id))
        log.debug('manual vendor returned:{}'.format(ret))
        return ret

    def search_toll_free(self, pattern=None, count=100, client_id=None):
        log.debug('manual vendor search pattern={} count={}'.format(pattern, count))
        cls = DidRepository
        filt = and_(cls.is_toll_free == True,
                    cls.vendor_trunk_id.isnot(None))
        if pattern is not None:
            pat = pattern.replace('*', '_').replace('x', '_') + '%'
            pat1 = '_' + pattern
            filt = and_(filt, or_(cls.did.like(pat), cls.did.like(pat1)))
        subquery = model.get_db().session.query(DidAssignments).filter(DidAssignments.did == cls.did).exists()
        filt = and_(filt, not_(subquery))
        ret = []
        for did in cls.filter(filt):
            vendor_id = client_id
            # did_transaction = DidTransaction.filter(DidTransaction.did_billing_id == did.id).order_by(DidTransaction.date.desc()).first()
            # mrc, nrc = did.mrc, did.nrc
            # if did_transaction:
            #     mrc, nrc = did_transaction.mrc, did_transaction.nrc
            ret.append(dict(number=did.did, vendor_id=vendor_id, country=did.country,state=did.state,lata=did.lata,
                            rate_table_id=did.rate_table_id, rate_per_min=did.rate_per_min))#, mrc=mrc, nrc=nrc))
        log.debug('manual vendor returned:{}'.format(ret))
        return ret

    def order_toll_free(self, items, routing_label=None, client_id=None):
        log.debug('manual vendor order {}'.format(items))
        cls = DidRepository
        ret = []
        for i in items:
            did = cls.filter(
                and_(or_(cls.did.like('_' + i['number']), cls.did == i['number']), cls.is_toll_free == True,
                     cls.vendor_trunk_id.isnot(None)
                     )).first()
            log.debug('manual vendor did found {}'.format(did))
            if did:
                vendor_id = client_id
                ret.append(dict(number=i['number'], vendor_id=vendor_id, status='sucess', hint='manual'))
            else:
                ret.append(
                    dict(number=i['number'], status='error', error='number:{} not in repository'.format(i['number'])))
        log.debug('manual vendor returned:{}'.format(ret))
        return ret

    def pending(self):
        return []


class VendorManual(object):

    def __init__(self):
        self.vendor = self
        self.id = None
        self.name = 'Local manual repository'

    def get_api(self):
        return DidAPIManual(None, None, self)

    pass
