from marshmallow import validate
from marshmallow.fields import Bool, Str, Decimal, Int, Nested, DateTime, Float, List, UUID, Dict

from api_dnl import model
from api_dnl.fields import Choice
from api_dnl.scheme import BaseModelScheme

from api_dnl.scheme import IP_REGEXP, NAME_REGEXP, PREFIX_REGEXP, TIME_REGEXP
from api_dnl.scheme import _valid,_valid_unique
WDAYS_REGEXP = r'^([1-7],){,6}[1-7]$'


# region +++FaultRouteAlertRule+++
class FaultRouteAlertRuleScheme(BaseModelScheme):
    id = Int()
    rule_name = Str(validate=[validate.Length(max=100),lambda value:_valid_unique('FaultRouteAlertRule','rule_name',value)])
    weekly_days = Str(allow_none=True, validate=[validate.Length(max=7), \
                                                 validate.Regexp(WDAYS_REGEXP)])
    daily_time = Str(allow_none=True, validate=[validate.Regexp(TIME_REGEXP)])
    product_id = Int(allow_none=True, validate=lambda value:_valid('ProductRoutRateTable','id',value))
    routing_plan_id = Int(allow_none=True,validate=lambda value:_valid('RouteStrategy','route_strategy_id',value))
    look_days = Int(validate=[validate.Range(0,90)])
    min_profitable_trunks = Int(allow_none=True,)
    min_profitability = Float()
    from_mail_id = Int(validate=lambda value:_valid('MailSender','id',value))
    email_to = Str(validate=[validate.Length(max=100)])
    subject = Str(validate=[validate.Length(max=200)])
    html_content = Str()
    is_active = Bool()
    last_run_on = DateTime()
    next_run_on = DateTime()

    class Meta:
        model = model.FaultRouteAlertRule
        fields = (
        'rule_name', 'weekly_days', 'daily_time', 'product_id', 'routing_plan_id', 'look_days', 'min_profitable_trunks',
        'min_profitability', 'from_mail_id', 'email_to', 'subject', 'html_content', 'is_active',)


class FaultRouteAlertRuleSchemeGet(FaultRouteAlertRuleScheme):
    class Meta:
        model = model.FaultRouteAlertRule
        fields = ('id', 'rule_name', 'weekly_days', 'daily_time', 'product_id', 'routing_plan_id', 'look_days',
                  'min_profitable_trunks', 'min_profitability', 'from_mail_id', 'email_to', 'subject', 'html_content',
                  'is_active', 'last_run_on', 'next_run_on', 'based_on', 'frequency')
        search_fields = ('id', 'rule_name', 'weekly_days', 'daily_time', 'product_id', 'routing_plan_id', 'look_days',
                         'min_profitable_trunks', 'from_mail_id', 'email_to', 'subject', 'html_content', 'is_active',)
        query_fields = (
        'min_profitability_gt', 'min_profitability_lt', 'last_run_on_gt', 'last_run_on_lt', 'next_run_on_gt',
        'next_run_on_lt',)


class FaultRouteAlertRuleSchemeModify(FaultRouteAlertRuleScheme):
    rule_name = Str(validate=[validate.Length(max=100)])
    pass


# endregion ---FaultRouteAlertRule---
# region +++FaultRouteAlertRuleLog+++
class FaultRouteAlertRuleLogScheme(BaseModelScheme):
    id = Int()
    rule_id = Int()
    started_on = DateTime()
    finished_on = DateTime()
    result = Str()
    status = Choice()
    mail_sent = Bool()
    profitable_trunks = Int(allow_none=True, )
    profitability = Float()
    class Meta:
        model = model.FaultRouteAlertRuleLog
        fields = ('rule_id', 'started_on', 'finished_on', 'result', 'status', 'mail_sent',)


class FaultRouteAlertRuleLogSchemeGet(FaultRouteAlertRuleLogScheme):
    min_profitable_trunks = Int(allow_none=True, )
    min_profitability = Float()
    rule_name = Str()
    class Meta:
        model = model.FaultRouteAlertRuleLog
        fields = ('rule_id', 'started_on', 'finished_on', 'result', 'status', 'mail_sent',
                  'profitable_trunks','profitability','min_profitable_trunks','min_profitability','rule_name')
        search_fields = ('id', 'rule_id', 'result', 'status', 'mail_sent',)
        query_fields = ('started_on_gt', 'started_on_lt', 'finished_on_gt', 'finished_on_lt',)


class FaultRouteAlertRuleLogSchemeModify(FaultRouteAlertRuleLogScheme):
    pass
# endregion ---FaultRouteAlertRuleLog---
