from marshmallow import validate,Schema
from marshmallow.fields import Bool, Str, Decimal, Int, Nested, DateTime, Float, List, UUID, Dict

from api_dnl import model
from api_dnl.fields import Choice
from api_dnl.scheme import BaseModelScheme, Emails, ClientPaymentScheme, PaymentGatewayHistoryGetScheme, \
    RateTableGetScheme, RateGetScheme, DidBillingRelGetScheme, \
    DidBillingPlanGetScheme,  PaymentGatewayHistoryScheme, _valid, ResourcePrefixGetScheme, \
    ResourceIpGetScheme, EmailLogGetScheme, ActualBalanceHistoryGetScheme, IngressTrunkScheme, IngressTrunkModifyScheme, \
    ResourceWithIpsScheme, ResourcePrefixScheme, ResourcePrefixGetScheme, ResourcePrefixModifyScheme, \
    ResourcePrefixWithIPScheme, ResourceWithIpAndAliasGetScheme

from api_dnl.scheme import IP_REGEXP, NAME_REGEXP, PREFIX_REGEXP, TIME_REGEXP, ValidationError, SuccessScheme
from api_dnl.utils.statisticapi2 import FIELD_MAP


class SystemCallStatScheme(BaseModelScheme):
    period = Str(validate=validate.OneOf(['hour', 'hours24', 'today', 'week', 'month', 'year', 'all']))

    class Meta:
        model = model.VoipGateway
        fields = ('period',)


class SystemCallStatGetScheme(Schema):
    inbound_channel = Int()
    inbound_cps = Int()
    outbound_channel = Int()
    outbound_cps = Int()
    connected_calls = Int()
    total_calls = Int()
    total_minutes = Int()
    total_profit = Float()
    total_profitability = Float()


class DashboardGetScheme(SystemCallStatGetScheme):
    pass