from marshmallow import validate
from marshmallow.fields import Bool, Str, Decimal, Int, Nested, DateTime,Float,List,UUID,Dict

from api_dnl import model
from api_dnl.fields import Choice
from api_dnl.scheme import BaseModelScheme, Emails, ClientPaymentScheme, PaymentGatewayHistoryGetScheme, \
    RateTableGetScheme, RateGetScheme, DidBillingRelGetScheme, \
    DidBillingPlanGetScheme,  PaymentGatewayHistoryScheme, _valid, ResourcePrefixGetScheme, \
    ResourceIpGetScheme,EmailLogGetScheme,ActualBalanceHistoryGetScheme,IngressTrunkScheme,IngressTrunkModifyScheme,\
    ResourceWithIpsScheme,ResourcePrefixScheme,ResourcePrefixGetScheme,ResourcePrefixModifyScheme,\
    ResourcePrefixWithIPScheme,ResourceWithIpAndAliasGetScheme

from api_dnl.scheme import IP_REGEXP,NAME_REGEXP,PREFIX_REGEXP

class CallingTrackScheme(BaseModelScheme):
    orig_file = Str()
    class Meta:
        model = model.CallingTrack
        fields = ()

class CallingTrackGetScheme(BaseModelScheme):
    uuid = Str()
    orig_file = Str()
    download_link = Str()
    class Meta:
        model = model.CallingTrack
        fields = ('uuid','orig_file','download_link')

class CallingCallGetScheme(BaseModelScheme):
    rbt_packet = Int()
    track_uuid = Str()
    ring_duration = Int()
    dst_number = Str()
    finish_time = DateTime()
    start_time = DateTime()
    req_uuid = Str()
    call_id = Int()
    response_code = Int()
    call_packet = Int()
    state = Choice()
    sip_pcap_path = Str()
    result = Str()
    call_uuid = Str()
    pdd = Int()
    call_audio_path = Str()
    call_duration = Int()
    rbt_audio_path = Str()
    caller_id = Str()
    pcap = Dict()

    class Meta:
        model = model.CallingCall
        fields = ('rbt_packet','track_uuid','ring_duration','dst_number','finish_time','start_time','req_uuid',
                'call_id','response_code','call_packet','state','sip_pcap_path','result','call_uuid','pdd',
                'call_audio_path','call_duration','rbt_audio_path',
                'caller_id','pcap')

class CallingRequestScheme(BaseModelScheme):
    track_uuid = UUID(validate=lambda value:_valid('CallingTrack','uuid',value))
    calling_list = List(Str())
    caller_id = Str()
    class Meta:
        model = model.CallingRequest
        fields = ('track_uuid','calling_list','caller_id')

class CallingRequestGetScheme(BaseModelScheme):
    status = Str()
    req_uuid = Str()
    finish_time = DateTime()
    start_time = DateTime()
    req_from_port = Int()
    req_from_ip = Int()
    complete_call_cnt = Int()
    total_call_cnt = Int()
    calls = Nested('CallingCallGetScheme',many=True)
    class Meta:
        model = model.CallingRequest
        fields = ('status','req_uuid','finish_time','start_time','req_from_port','req_from_ip',
                'complete_call_cnt','total_call_cnt','calls')

class CallingRequestModifyScheme(BaseModelScheme):
    orig_file = Str()
    class Meta:
        model = model.CallingRequest
        fields = ()