from marshmallow import validate
from marshmallow.fields import Bool, Str, Decimal, Int, Nested, DateTime, Float, List, UUID, Dict

from api_dnl import model
from api_dnl.fields import Choice
from api_dnl.scheme import BaseModelScheme

from api_dnl.scheme import IP_REGEXP, NAME_REGEXP, PREFIX_REGEXP,_valid


class DidRepositoryScheme(BaseModelScheme):
    id = Int()
    did = Str(validate=validate.Regexp(PREFIX_REGEXP))  # validate=lambda value : _valid('Rate','code',value))#
    vendor_trunk_id = Int(validate=lambda value: _valid('Client', 'client_id', value))
    vendor_billing_plan_id = Int(validate=lambda value: _valid('DidBillingPlan', 'id', value))
    vendor_billing_rule_name = Str(validate=lambda value: _valid('DidBillingPlan', 'name', value))
    did_vendor_name = Str()
    did_client_name = Str()
    client_billing_rule_name = Str()
    created_at = DateTime()
    created_by = Int()

    class Meta:
        model = model.DidRepository
        fields = ('did', 'did_vendor_name', 'vendor_billing_rule_name', 'did_client_name', 'client_billing_rule_name')


class DidBillingRelExportScheme(BaseModelScheme):
    did = Str()
    # client_res_id = Int()
    # client_billing_rule_id = Int()
    # vendor_res_id = Int()
    # vendor_billing_rule_id = Int()
    assigned_date = DateTime(required=False)
    end_date = DateTime(required=False)
    did_vendor_name = Str()
    did_client_name = Str()
    client_id = Int()
    vendor_id = Int()
    is_available = Bool()
    is_effective = Bool(dump_only=True)
    is_assigned = Bool(dump_only=True)
    # assigned_client_id = Int()
    ip = Str()
    # note = Str()
    client_billing_rule_name = Str()
    vendor_billing_rule_name = Str()

    class Meta:
        model = model.DidBillingRel
        fields = ('did', 'did_client_name', 'did_vendor_name',
                #   'client_res_id', 'vendor_res_id',
                  'client_billing_rule_name', 'vendor_billing_rule_name',
                  'ip'
                  )


# region +++DidExportAsyncTask+++
class DidExportAsyncTaskScheme(BaseModelScheme):
    id = Int()
    request_client_id = Int(validate=lambda value: _valid('Client', 'client_id', value))
    user_id = Int()
    did_client_id = Int(validate=lambda value: _valid('Client', 'client_id', value))
    did_vendor_id = Int(validate=lambda value: _valid('Client', 'client_id', value))
    did_prefix = Str(validate=[validate.Length(max=15)])
    did_is_active = Bool()
    did_is_assigned = Bool()
    did_end_dated = Bool()
    job_start_time = Int()
    job_end_time = Int()
    msg = Str(validate=[validate.Length(max=512)])
    progress = Str(validate=[validate.Length(max=4)])
    count = Int()
    size = Int()
    status = Choice()
    action = Choice(allow_none=False,required=True)
    orig_file = Str(validate=[validate.Length(max=512)])
    class Meta:
        model = model.DidExportAsyncTask
        fields = (
        'did_client_id', 'did_vendor_id', 'did_prefix', 'did_is_active', 'did_is_assigned', 'did_end_dated', 'action')


class DidExportAsyncTaskSchemeGet(DidExportAsyncTaskScheme):
    download_link = Str(dump_only=True)
    class Meta:
        model = model.DidExportAsyncTask
        fields = ('id', 'request_client_id', 'user_id', 'did_client_id', 'did_vendor_id', 'did_prefix', 'did_is_active',
                  'did_is_assigned', 'did_end_dated', 'job_start_time', 'job_end_time', 'msg', 'progress', 'count',
                  'size', 'status', 'action', 'orig_file', 'download_link')
        search_fields = (
        'id', 'request_client_id', 'user_id', 'did_client_id', 'did_vendor_id', 'did_prefix', 'did_is_active',
        'did_is_assigned', 'did_end_dated', 'job_start_time', 'job_end_time', 'msg', 'progress', 'count', 'size',
        'status', 'action', 'orig_file', 'client', 'user',)
        query_fields = ('job_start_time_gt', 'job_start_time_lt', 'job_end_time_gt', 'job_end_time_lt')


class DidExportAsyncTaskSchemeModify(DidExportAsyncTaskScheme):
    pass
# endregion ---DidExportAsyncTask---
