import celery
from api_dnl import settings
from datetime import date,datetime,timedelta
from pytz import UTC
from time import mktime
import io,csv,gzip,zipfile
import xlwt
import json
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select,alias,case
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import PcapQuery,CdrReportDetail,client_cdr,ClientCdr
from api_dnl.model import PrimaryKeyConstraint,func,query_to_sting,cast
from api_dnl.tasks import app,log,db,SqlAlchemyTask,SchLog
from api_dnl import model
#old
from os.path import exists, join, basename, dirname
import re
import os
import subprocess
from time import sleep, mktime
from shutil import copy, move
from ftplib import FTP
import paramiko
from api_dnl.utils.snippets import Application, compare_file_vs_hash

@app.task(base=SqlAlchemyTask, time_limit=3600, soft_time_limit=3599)
def do_clear_resource_block():
    log.debug("do_clear_resource_block started")
    try:
        from api_dnl.model import ResourceBlock

        # Calculate days since block creation for each block
        expired_blocks = ResourceBlock.filter(
            and_(
                ResourceBlock.unblock_after.isnot(None),
                ResourceBlock.create_time + (ResourceBlock.unblock_after * text_("INTERVAL '1 day'")) <= func.now()
            )
        ).all()
        
        # Delete expired blocks and log
        for block in expired_blocks:
            log.debug(f"Deleting expired resource block: res_block_id={block.res_block_id}, "
                    f"unblock_after={block.unblock_after} days")
            block.delete()
            
        log.debug(f"Cleared {len(expired_blocks)} expired resource blocks")
            
    except Exception as e:
        log.error(f"Error in do_clear_resource_block: {str(e)}")
        
    log.debug("do_clear_resource_block finished")

