"""fault_route_alert_rule

Revision ID: 43360d34f32d
Revises: 1f5088f4e838
Create Date: 2021-04-21 13:30:52.073989

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '43360d34f32d'
down_revision = '1f5088f4e838'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('fault_route_alert_rule',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('rule_name', sa.String(length=100), nullable=True),
    sa.Column('weekly_days', sa.String(length=7), nullable=True),
    sa.Column('daily_time', sa.Time(), nullable=True),
    sa.Column('product_id', sa.Integer(), nullable=True),
    sa.Column('routing_plan_id', sa.Integer(), nullable=True),
    sa.Column('look_days', sa.Integer(), nullable=True),
    sa.Column('min_profitable_trunks', sa.Integer(), nullable=True),
    sa.Column('min_profitablility', sa.Float(), nullable=True),
    sa.Column('from_mail_id', sa.Integer(), nullable=True),
    sa.Column('email_to', sa.String(length=100), nullable=True),
    sa.Column('subject', sa.String(length=200), nullable=True),
    sa.Column('html_content', sa.Text(), nullable=True),
    sa.Column('is_active', sa.Boolean(), server_default='true', nullable=True),
    sa.Column('last_run_on', sa.DateTime(timezone=True), nullable=True),
    sa.Column('next_run_on', sa.DateTime(timezone=True), nullable=True),
    sa.ForeignKeyConstraint(['product_id'], ['product_rout_rate_table.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('rule_name')
    )
    op.create_table('fault_route_alert_rule_log',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('rule_id', sa.Integer(), nullable=True),
    sa.Column('started_on', sa.DateTime(timezone=True), nullable=True),
    sa.Column('finished_on', sa.DateTime(timezone=True), nullable=True),
    sa.Column('result', sa.Text(), nullable=True),
    sa.Column('status', api_dnl.migration_types.ChoiceType(), nullable=True),
    sa.Column('mail_sent', sa.Boolean(), server_default='false', nullable=True),
    sa.ForeignKeyConstraint(['rule_id'], ['fault_route_alert_rule.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('fault_route_alert_rule_log')
    op.drop_table('fault_route_alert_rule')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))