"""SendRateTemplate changes

Revision ID: 6ce5566376fc
Revises: 4a885ade70ae
Create Date: 2017-10-27 03:05:10.990555

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '6ce5566376fc'
down_revision = '4a885ade70ae'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    connection = op.get_bind()

    connection.execute("delete from resource_ip where ctid not in (select max(ctid) from resource_ip s  group by s.ip)")
    connection.execute("delete from resource_prefix where ctid not in (select max(ctid) from resource_prefix s  group by s.tech_pre)")
    connection.execute("delete from send_rate_template where ctid not in (select max(ctid) from send_rate_template s  group by s.name)")
    
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index(op.f('ix_balance_history_actual_date'), 'balance_history_actual', ['date'], unique=False)
    op.drop_column('resource', 'rate_profile')
    op.create_unique_constraint(None, 'resource_ip', ['ip'])
    op.create_unique_constraint(None, 'resource_prefix', ['tech_prefix'])
    op.add_column('send_rate_template', sa.Column('download_method', sa.SmallInteger(), nullable=True))
    op.add_column('send_rate_template', sa.Column('header', sa.Text(), nullable=True))
    op.add_column('send_rate_template', sa.Column('mail_cc', sa.String(length=200), nullable=True))
    op.add_column('send_rate_template', sa.Column('sender_id', sa.Integer(), nullable=True))
    op.create_unique_constraint(None, 'send_rate_template', ['name'])
    op.create_foreign_key(None, 'send_rate_template', 'mail_sender', ['sender_id'], ['id'], ondelete='SET NULL')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'send_rate_template', type_='foreignkey')
    op.drop_constraint(None, 'send_rate_template', type_='unique')
    op.drop_column('send_rate_template', 'sender_id')
    op.drop_column('send_rate_template', 'mail_cc')
    op.drop_column('send_rate_template', 'header')
    op.drop_column('send_rate_template', 'download_method')
    op.drop_constraint(None, 'resource_prefix', type_='unique')
    op.drop_constraint(None, 'resource_ip', type_='unique')
    op.add_column('resource', sa.Column('rate_profile', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True))
    op.drop_index(op.f('ix_balance_history_actual_date'), table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date', 'client_id'], unique=True)
    # ### end Alembic commands ###
