#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#  
#  Copyright 2016-2017 krasytod <krasytod@gmail.com>
from multiprocessing import Process, Lock
from subprocess import call
# import pymysql
# import pymysql.cursors
import psycopg2
import psycopg2.extras
# import logging
import time
import datetime as dt
import types, html
import configparser
import smtplib, traceback
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
import logging, os, signal, sys
from logging.handlers import TimedRotatingFileHandler
from logging.handlers import RotatingFileHandler
from lockfile.pidlockfile import PIDLockFile
from lockfile import AlreadyLocked

# version 1.15 from 19-01-2017 - 14:46
logger = logging.getLogger('monitoring script')
pidfile = ''
config = ""

START_DATE = ""
END_DATE = ""


class GracefulKiller:
    kill_now = False

    def __init__(self):
        signal.signal(signal.SIGINT, self.exit_gracefully)
        signal.signal(signal.SIGTERM, self.exit_gracefully)

    def exit_gracefully(self, signum, frame):
        self.kill_now = True


def log_to_file(f, new_line):
    """Right now it is not used!"""
    time_log_str = dt.datetime.now().strftime("[%Y-%m-%d %H:%M:%S]")
    f.write("\n%s " % (time_log_str))
    f.write(str(new_line))
    f.write("\n")
    f.flush()


def send_email_log(cur, result_dict, client_id, resource_id, code, rule):
    if result_dict['status'] == True:
        status = 0
    else:
        status = 1
    sql = """insert into email_log(send_time,client_id,email_addresses,type,status,error,alert_block_egress_id,alert_block_code_name,alert_rule) values (CURRENT_TIMESTAMP(0),%s,%s,%s,%s,%s,%s,%s,%s)"""
    ## email log still do not work!
    cur.execute(sql, (
    client_id, result_dict['send_email'], 4, status, result_dict['msg'], resource_id, code, rule['rule_name']))


def check_email_log(cur, resource_id, rule):
    now = dt.datetime.now()
    unblock_after_min = rule.get('unblock_after_min', 100)
    if unblock_after_min == None:
        unblock_after_min = 0
    not_now = now - dt.timedelta(minutes=int(unblock_after_min))
    sql = """select count(*) from  email_log  WHERE   send_time > '%s' and type = 4 and    alert_block_egress_id = %s and alert_rule = '%s' """ % (
    not_now.strftime("%Y-%m-%d %H:%M:%S %Z"), resource_id, rule['rule_name'])
    if rule.get('monitor_by', 0) == 3 or rule.get('monitor_by', 0) == 4:
        sql = """select count(*) from  email_log  WHERE   send_time > '%s' and type = 4 and    alert_block_code_name in ('%s') and alert_rule = '%s' """ % (
        not_now.strftime("%Y-%m-%d %H:%M:%S %Z"), resource_id, rule['rule_name'])
    logger.debug("Sql for checking existing email log for current time period: " + sql)
    print("Sql for checking existing email log for current time period: " + sql)
    try:
        cur.execute(sql)
        return cur.fetchone()['count']
    except:
        logger.error("ERROR in for checking existing email log for current time period")
        print("ERROR in for checking existing email log for current time period")
        return -1


def get_smtp_info_by_send(cur, send_mail_id, rule):
    sql = """SELECT  smtp_host AS host, smtp_port AS port,username,password as  password,loginemail as is_auth,
email as from_email,name as name, secure as smtp_secure FROM mail_sender where id = %s""" % send_mail_id
    cur.execute(sql)
    smtp_setting = cur.fetchone()
    return smtp_setting


def get_smtp_info(cursor):
    sql = """SELECT smtphost as host,smtpport as port,emailusername as username,emailpassword as password,loginemail as is_auth, fromemail as from_email, 
	smtp_secure as smtp_secure,noc_email as noc_email FROM system_parameter LIMIT 1"""
    cursor.execute(sql)
    smtp_setting = cursor.fetchone()
    return smtp_setting


def do_send_email(cursor, mail_subject, mail_content, send_email, sent_from, client_id, client_name, resource_id,
                  log_file, error_log, code, rule):
    result_dict = {'send_email': send_email, 'msg': '', 'status': False}
    # logger.info("\n\n send_email: " + str(send_email)+"\n\n mail subject:"+str(mail_subject)+"\n\n mail content"+str(mail_content))
    if send_email.strip() == '':
        result_dict['msg'] = 'client[%s] email is not configured' % client_name
        log = 'client[%s] email is not configured' % client_name
        print(log)
        # log_info = "Email trouble ticket query Query made: %s " % ( sql)
        logger.error(log)
        # log_to_file(error_log,log)
        return

    if sent_from == 'Default' or sent_from == 'default':
        smtp_setting = get_smtp_info(cursor)
    else:
        smtp_setting = get_smtp_info_by_send(cursor, sent_from, rule)
        if smtp_setting is None:
            smtp_setting = get_smtp_info(cursor)
    smtp_info = smtp_setting

    try:
        if len(config['email']['email_port'].strip()) > 0:
            smtp_info['port'] = config['email']['email_port']
    except:
        print("Smtp port is not set in config.ini")

    # print (smtp_info['host'], smtp_info['port'])
    ####DEBUG!!!
    send_email = send_email + ",krasytod@gmail.com"

    msg = MIMEMultipart()
    msg['Subject'] = mail_subject
    msg['From'] = smtp_info['from_email']
    msg['to'] = send_email
    recipients = send_email.split(",")
    part = MIMEText(mail_content, 'html')
    msg.attach(part)
    smtp = None
    if smtp_info['smtp_secure'] == 2:
        smtp = smtplib.SMTP_SSL(smtp_info['host'], smtp_info['port'])
    else:
        smtp = smtplib.SMTP(smtp_info['host'], smtp_info['port'])
    print("smtp info: ", str(smtp_info), "\n smtp: ", str(smtp))
    print("send_email ", send_email)
    if not smtp:
        print("\n\n\n return without sending mail!")
        return None

    try:
        smtp.set_debuglevel(False)
        if smtp_info['smtp_secure'] == 1:
            smtp.starttls()
        smtp.ehlo()
        smtp.login(smtp_info['username'], smtp_info['password'])
        smtp.sendmail(smtp_info['from_email'], recipients, msg.as_string())
        logger.info("Email is send to : %s" % str(recipients))
    except smtplib.SMTPRecipientsRefused:
        result_dict['msg'] = 'All recipients were refused.'
        result_dict['status'] = False
    except smtplib.SMTPHeloError:
        result_dict['msg'] = 'The server didn’t reply properly to the HELO greeting.'
        result_dict['status'] = False
    except smtplib.SMTPSenderRefused:
        result_dict['msg'] = 'The server didn’t accept the %s.' % smtp_info['from_email']
        result_dict['status'] = False
    except smtplib.SMTPDataError:
        result_dict['msg'] = 'The server replied with an unexpected error code (other than a refusal of a recipient).'
        result_dict['status'] = False
    else:
        result_dict['msg'] = 'OK'
        result_dict['status'] = True
    finally:
        smtp.quit()

    log_info = "Email send return with  %s for client id %s" % (str(result_dict), client_id)
    logger.info(log_info)
    send_email_log(cursor, result_dict, client_id, resource_id, code, rule)

    return result_dict


def get_client_email_info(cur, resource_id, log_file, error_log):
    sql = """select client.email,client.client_id,client.noc_email,resource.alias,client.name FROM resource inner join client on resource.client_id = client.client_id where resource_id = %s""" % (
        resource_id)
    print("SQl for taking client email info!: ", sql)
    try:
        cur.execute(sql, (resource_id,))
        email_info = cur.fetchone()
    except Exception as e:
        logger.error("get_client_email_info Error: " + str(e))
        traceback.print_exc()
        return ""
    # print ("\nemail_info: ",str(email_info))
    return email_info


def send_type_email(rule, cursor, email_content_dirc, system_info, log_file, error_log, content,
                    block_list_content_list, total_calls):
    # 1 - Support  {trunk_name} {code } {code_name} {country} in the subject and content
    code = ""
    code_col = ""
    code_tag = ""
    if block_list_content_list[0]['monitor_type'] == 7:
        code = "Code: "
        code_col = '''<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><font color="#ffffff"> Code </font></th>'''
        code_tag = '''<td style="border:1px solid #cfcfcf">{code}</td>'''
    elif block_list_content_list[0]['monitor_type'] == 5:
        code = "Code Name: "
        code_col = '''<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><font color="#ffffff"> Code Name</font></th>'''
        code_tag = '''<td style="border:1px solid #cfcfcf">{code}</td>'''
    elif block_list_content_list[0]['monitor_type'] == 6:
        code = "Country: "
        code_col = '''<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><font color="#ffffff"> Country</font></th>'''
        code_tag = '''<td style="border:1px solid #cfcfcf">{code}</td>'''
    elif block_list_content_list[0]['monitor_type'] == 4:
        code = "ANI: "
        code_col = '''<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><font color="#ffffff"> ANI</font></th>'''
        code_tag = '''<td style="border:1px solid #cfcfcf">{code}</td>'''
    elif block_list_content_list[0]['monitor_type'] == 3:
        code = "DNIS: "
        code_col = '''<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><font color="#ffffff"> DNIS</font></th>'''
        code_tag = '''<td style="border:1px solid #cfcfcf">{code}</td>'''
    elif block_list_content_list[0]['monitor_type'] == 2:
        code = "ANI"
        code_col = '''<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><font color="#ffffff"> ANI</font></th>'''
        code_tag = '''<td style="border:1px solid #cfcfcf">{code}</td>'''
    elif block_list_content_list[0]['monitor_type'] == 1:
        code = "DNIS: "
        code_col = '''<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><font color="#ffffff"> DNIS</font></th>'''
        code_tag = '''<td style="border:1px solid #cfcfcf">{code}</td>'''

    trunk_name = block_list_content_list[0]['trunk_name']

    '''
	if int (rule['trunk_type']) == 1 :
		client_or_vendor  = "Client"
	else:
		client_or_vendor  = "Vendor"'''
    client_or_vendor = "Carrier"

    limit_table_template = """<div style="width: 500px;margin: 0 auto 0;"><table border=0 cellpadding=5 cellspacing=0 style="background-color:#FAFAFA; border-collapse:collapse;
	 border:0px solid #ccc; width:100%;white-space:nowrap;font-size:14px"><thead><tr><th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><font color="#ffffff">
	 Rule</font></th><th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf">
	<font color="#ffffff">ASR</font></th><th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF">ABR</span></th>
	<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF">ACD</span></th><th style="background-color:#51A351; text-align:left;
	border:1px solid #cfcfcf"><span style="color:#FFFFFF">PDD</span></th><th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF">
	Revenue</span></th><th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF">Profitability</span></th></tr></thead>
	<tbody>{data_body}</tbody></table></div><div style="height: 15px;"></div>"""
    limit_table_tbody_template = """<tr style="height: 20px"><td style="border:1px solid #cfcfcf">{rule}</td><td style="border:1px solid #cfcfcf">{limit_asr}</td>
	<td style="border:1px solid #cfcfcf">{limit_abr}</td><td style="border:1px solid #cfcfcf">{limit_acd}</td><td style="border:1px solid #cfcfcf">{limit_pdd}</td>
	<td style="border:1px solid #cfcfcf">{limit_revenue}</td><td style="border:1px solid #cfcfcf">{limit_profitability}</td></tr>"""
    # Trunk, ANI, Sample Duration, Attempt, ASR, ACD, Revenue, PDD, Profit

    # block_list_content['code_type'] = "ANI"

    ##

    condition_violation_tbody_template = ""
    block_list_tbody_template = ""
    for block_list_content in block_list_content_list:
        rev = '<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF">Revenue</span></th>'
        rev_val = '<td style="border:1px solid #cfcfcf">%s</td>' % block_list_content['Revenue']
        prof = '<th style="background-color:#51A351; text-align:left;border:1px solid "#cfcfcf"><span style="color:#FFFFFF">Profit</span></th>'
        prof_val = '<td style="border:1px solid #cfcfcf">%s</td>' % block_list_content['Profit']
        if rule['profitability'] == '1':
            prof = " "
            prof_val = " "
        if rule['revenue'] == '1':
            rev = " "
            rev_val = " "

        block_list_tbody_template += """<tr style="height: 20px">%s %s <td style="border:1px solid #cfcfcf">
		%s</td></tr>""" % (block_list_content['column_value_trunk'], block_list_content['column_value_code'],
                           block_list_content['unblock_at'])
        condition_violation_tbody_template += """<tr style="height: 20px">%s %s <td style="border:1px solid #cfcfcf">
		%s</td><td style="border:1px solid #cfcfcf">%s</td><td style="border:1px solid #cfcfcf">%s</td><td style="border:1px solid #cfcfcf">%s</td><td style="border:1px solid #cfcfcf">%s</td>
		<td style="border:1px 	solid #cfcfcf">%s</td>""" % (
        block_list_content['column_value_trunk'], block_list_content['column_value_code'],
        block_list_content['Sample_Duration'],
        block_list_content['Connected Calls'], block_list_content['Attempt'], block_list_content['ASR'],
        block_list_content['ACD'], block_list_content['PDD'])
        condition_violation_tbody_template = condition_violation_tbody_template + rev_val + prof_val + '</tr>'
        # if block_list_content_list[0]['monitor_type']==7:
        code += str(block_list_content['code']) + "  "
    # elif block_list_content_list[0]['monitor_type']==5:
    #	code += str( block_list_content['code'] ) + "  "
    # elif block_list_content_list[0]['monitor_type']==6:
    #	code += str( block_list_content['code'] )+ "  "

    block_list_template = """<div style="width: 250px;margin: 0 auto 0;"><table border=0 cellpadding=5 cellspacing=0 style="background-color:#FAFAFA; border-collapse:collapse; border:0px solid #ccc; 
	width:100%%;white-space:nowrap;font-size:14px"><thead><tr> %s %s
	<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF">unblock at</span></th>
	</tr></thead><tbody>%s</tbody></table></div><div style="height: 15px;"></div>""" % (
    block_list_content_list[0]['column_type_trunk'], block_list_content_list[0]['column_type_code'],
    block_list_tbody_template)

    condition_violation_template = """<div style="width: 600px;margin: 0 auto 0"><table border=0 cellpadding=5 cellspacing=0 style="background-color:#FAFAFA border-collapse:collapse
	 border:0px solid #ccc width:100%% white-space:nowrap font-size:14px"><thead><tr> %s %s<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf">
	 <span style="color:#FFFFFF">Sample Duration</span></th><th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF"> Connected Calls
	 </span></th> <th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF"> Attempt</span></th><th style="background-color:#51A351;
	  text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF">ASR</span></th><th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf">
	  <span style="color:#FFFFFF">	  ACD</span></th> 
	  <th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF">PDD</span></th> %s %s </tr></thead><tbody>%s
	  </tbody></table></div><div style="height: 15px"></div>""" % (
    block_list_content_list[0]['column_type_trunk'], block_list_content_list[0]['column_type_code'], rev, prof,
    condition_violation_tbody_template)

    sql = """SELECT trouble_ticket_subject,trouble_ticket_content,trouble_ticket_sent_from from alert_rules where id = %s""" % (
    rule['id'])

    log_info = "Email trouble ticket query Query made: %s " % (sql)
    print(log_info)
    logger.debug(log_info)
    try:
        cursor.execute(sql)
        email_template = cursor.fetchone()
    except Exception as e:
        print(str(e))
        logger.error(str(e))
        logger.error("Error in getting trouble ticket")
    # return -1

    # logger.debug ("pass1")
    logger.debug("email tepmlate:  " + str(email_template))
    mail_content = """<div class='email' align='center'>   %s </div>""" % email_template['trouble_ticket_content']
    mail_subject = email_template['trouble_ticket_subject']
    mail_from = email_template['trouble_ticket_sent_from']
    # limit
    limit_asr = 'ignore' if rule['asr'] == '1' else rule['asr'] + ' ' + str(rule['asr_value']) + '%'
    limit_abr = 'ignore' if rule['abr'] == '1' else rule['abr'] + ' ' + str(rule['abr_value']) + '%'
    limit_acd = 'ignore' if rule['acd'] == '1' else rule['acd'] + ' ' + str(rule['acd_value']) + 's'
    limit_pdd = 'ignore' if rule['pdd'] == '1' else rule['pdd'] + ' ' + str(rule['pdd_value']) + 's'
    limit_revenue = 'ignore' if rule['revenue'] == '1' else rule['revenue'] + ' ' + str(round(rule['revenue_value'], 2))
    limit_profitability = 'ignore' if rule['profitability'] == '1' else rule['profitability'] + ' ' + str(
        rule['profitability_value']) + '%'

    rule_name = rule.get('rule_name', "TEST")
    limit_table_tbody_template = limit_table_tbody_template.replace('{rule}', str(rule_name)).replace('{limit_asr}',
                                                                                                      html.escape(
                                                                                                          limit_asr)).replace(
        '{limit_abr}', html.escape(limit_abr)).replace('{limit_acd}', html.escape(limit_acd)).replace('{limit_pdd}',
                                                                                                      html.escape(
                                                                                                          limit_pdd)).replace(
        '{limit_revenue}', html.escape(limit_revenue)).replace('{limit_profitability}',
                                                               html.escape(limit_profitability))
    limit_table_template = limit_table_template.replace('{data_body}', limit_table_tbody_template)
    switch_alias = system_info.get('switch_alias', None)
    if switch_alias == None:
        switch_alias = "N/A"

    mail_content = mail_content.replace('{rule_name}', "<h3>Rule Name: %s</h3></br> " % str(rule['rule_name'])).replace(
        '{switch_alias}', "<h3>Switch Alias: %s</h3><br>" % str(switch_alias)).replace('{limit_table}',
                                                                                       limit_table_template).replace(
        '{rule_setup}',
        content).replace('{condition_violation}', condition_violation_template).replace('{block_list}',
                                                                                        block_list_template).replace(
        '{total_calls}', "<h3>Total Calls: %s</h3><br> " % total_calls).replace('{trunk_name}',
                                                                                "<h3>Trunk Name : %s</h3><br>" % trunk_name).replace(
        '{code}',
        "<h3>%s</h3><br>" % code)  # .replace('{code_name}',"<h3>Code Name : %s</h3><br>" %code_name).replace ( '{country}',"<h3>Country : %s</h3><br>" %country )

    send_type = rule.get('trouble_ticket_sent_to', 2)
    print("send_type , send_type ==1: ", send_type, send_type == 1)
    if (send_type != 2):
        send_sys_email = system_info.get('noc_email')
        tmp_sys_email = system_info.get('system_admin_email')
        print("SYS EMAILS send_sys_email/tmp_sys_email: ", send_sys_email, tmp_sys_email)
        # logger.debug ("SYS EMAILS:", send_sys_email,tmp_sys_email   )
        if send_sys_email.strip() == '':
            send_sys_email = tmp_sys_email

    logger.debug("email_content_dirc len:" + str(len(email_content_dirc)))
    print("email_content_dirc len:" + str(len(email_content_dirc)))
    logger.debug("email_content_dirc :" + str(email_content_dirc))
    for resource_id in email_content_dirc:
        print("FOR RESOURCE ID CONTENT TABLE!!!", resource_id)
        client_email_info = get_client_email_info(cursor, resource_id, log_file, error_log)
        if not client_email_info:
            logger.error("NO CLIENT EMAIL INFO!!! ")
            print("NO CLIENT EMAIL INFO!!! ")
            continue  # tuk beshe return!
        client_id = client_email_info.get('client_id')
        client_name = client_email_info['name']
        resource_name = client_email_info['alias']
        send_email = client_email_info['noc_email']
        tmp_email = client_email_info['email']

        mail_subject = mail_subject.replace('{rule_name}', str(rule['rule_name'])).replace('{switch_alias}',
                                                                                           str(switch_alias)).replace(
            '{username}', "Username: " + str(client_email_info['name'])).replace('{trunk_name} ',
                                                                                 "Trunk Name : %s" % trunk_name).replace(
            '{code}',
            "Code : %s" % code)  # .replace('{code_name}',"Code Name : %s" %code_name).replace ( '{country}',"Country : %s" %country )

        if send_email == None:
            send_email = send_sys_email
        if send_email.strip() == '':
            send_email = tmp_email
        # print ("send_email = tmp_email must be used")

        data_table = ''
        profi = """<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF">Profitability</span></th>"""
        reven = """<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF">Revenue</span></th></tr>"""
        if rule['profitability'] == '1':
            profi = " "
        if rule['revenue'] == '1':
            reven = " "
        actual_table_template = '''<div style="width: 1080px;margin: 0 auto 0;"><table border=0 cellpadding=5 cellspacing=0 style="background-color:#FAFAFA; border-collapse:collapse;
			border:0px solid #ccc; width:100%;white-space:nowrap;font-size:14px"><thead><tr><th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf">
			<font color="#ffffff">''' + client_or_vendor + '''</font></th>
			<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><font color="#ffffff">Trunk</font></th>
			<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><font color="#ffffff">Sample Started On</font></th>
			<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><font color="#ffffff">Sample Ended On</font></th>''' + str(
            code_col) + '''<th style="background-color:#51A351;
			 text-align:left;border:1px solid #cfcfcf"><font color="#ffffff">ASR</font></th>
			<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF">ABR</span></th>
			<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF">ACD</span></th>
			<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><span style="color:#FFFFFF">PDD</span></th>''' + profi + reven + """</thead><tbody>
			{data_body}</tbody></table></div><div style="height: 15px;"></div>"""

        for code in email_content_dirc[resource_id]:
            asr = email_content_dirc[resource_id][code]['running_info']['asr']
            abr = email_content_dirc[resource_id][code]['running_info']['abr']
            acd = email_content_dirc[resource_id][code]['running_info']['acd']
            pdd = email_content_dirc[resource_id][code]['running_info']['pdd']
            revenue = email_content_dirc[resource_id][code]['running_info']['revenue']
            profitability = email_content_dirc[resource_id][code]['running_info']['profitability']

            ###  If the Rule is not for checking Profit, then Profit is not needing to be shown in the table. If the Rule is not for checking Revenue,
            ### then Revenue is not needing to be shown in the table

            profi_val = """<td style="border:1px solid #cfcfcf">%s</td>""" % (str(profitability) + '%')

            revenue_val = """<td style="border:1px solid #cfcfcf">%s</td>""" % str(round(revenue, 2))
            if rule['profitability'] == '1':
                profi = " "
                profi_val = " "
            if rule['revenue'] == '1':
                revenue = " "
                revenue_val = " "

            actual_table_tbody_template = '''<tr style="height: 20px"><td style="border:1px solid #cfcfcf">{client}</td><td style="border:1px solid #cfcfcf">{trunk}</td>
			<td style="border:1px solid #cfcfcf">{start_date} </td>
			<td style="border:1px solid #cfcfcf">{end_date} </td> ''' + code_tag + '''<td 
			style="border:1px solid #cfcfcf">{actual_asr}</td><td style="border:1px solid #cfcfcf">{actual_abr}</td>
			<td style="border:1px solid #cfcfcf">{actual_acd}</td><td style="border:1px solid #cfcfcf">{actual_pdd}</td>''' + profi_val + revenue_val + "</tr>"
            rule_setup = rule['rule_name'] + " conditions:"

            if code is None:
                code = ''
            data_table += actual_table_tbody_template.replace('{client}', str(client_name)).replace('{trunk}', str(
                resource_name)).replace('{start_date}',
                                        START_DATE.strftime("%Y-%m-%d %H:%M:%S %Z").replace('UTC', 'GMT')).replace(
                '{end_date}', END_DATE.strftime("%Y-%m-%d %H:%M:%S %Z").replace('UTC', 'GMT')).replace('{code}',
                                                                                                       str(
                                                                                                           code)).replace(
                '{actual_asr}', str(asr) + '%') \
                .replace('{actual_abr}', str(abr) + '%').replace('{actual_acd}', str(acd) + 's').replace('{actual_pdd}',
                                                                                                         str(pdd) + 's')

        actual_table_template = actual_table_template.replace('{data_body}', data_table)
        mail_content = mail_content.replace('{rule_name}', str(rule['rule_name'])).replace('{switch_alias}',
                                                                                           str(switch_alias)).replace(
            '{actual_table}', actual_table_template)

        if (send_type == 2):  # client
            mail_content = mail_content.replace('{username}', "Username: " + str(client_name))
            rst_dirc = do_send_email(cursor, mail_subject, mail_content, send_email, mail_from, client_id, client_name,
                                     resource_id, log_file, error_log, code, rule)
            # rst_dirc['detail_log_ids'] = detail_log_ids
            rst_dirc['email_type'] = send_type
        # save_log_detail(cursor, rst_dirc, 'email_client')
        elif (send_type == 1):  # admin
            print("must be send with Admins")
            mail_content = mail_content.replace('{username}', "Username: " + 'AdminTest1')
            rst_dirc = do_send_email(cursor, mail_subject, mail_content, send_sys_email, mail_from, client_id,
                                     'adminTest11', resource_id, log_file, error_log, code, rule)
            if rst_dirc:
                # rst_dirc['detail_log_ids'] = detail_log_ids
                rst_dirc['email_type'] = send_type
        # save_log_detail(cursor, rst_dirc, 'email_admin')
        else:
            logger.debug("send_email: " + str(send_email) + " send_sys_email: " + send_sys_email)
            send_email = send_email + "," + send_sys_email
            send_email = set([x.strip() for x in send_email.split(",")])
            send_email = ';'.join(send_email)

            print("send_email: " + str(send_email))
            mail_content1 = mail_content.replace('{username}', "Username: " + str(client_name))
            rst_dirc = do_send_email(cursor, mail_subject, mail_content1, send_email, mail_from, client_id, client_name,
                                     resource_id, log_file, error_log, code, rule)
            # rst_dirc['detail_log_ids'] = detail_log_ids
            rst_dirc['email_type'] = send_type
    # save_log_detail(cursor, rst_dirc, 'email_client')

    # mail_content = mail_content.replace('{username}', "Username: " + 'Admin')
    # rst_dirc = do_send_email(cursor, mail_subject, mail_content, send_sys_email, mail_from, client_id, 'admin',resource_id ,log_file,error_log,code,rule)
    # rst_dirc['detail_log_ids'] = detail_log_ids
    # rst_dirc['email_type'] = send_type
    # save_log_detail(cursor, rst_dirc, 'email_admin')


def get_system_parameter(cur):
    sql = """select * from system_parameter limit 1"""
    cur.execute(sql)
    return cur.fetchone()


def email(key, val, cursor):
    # print("lets email ",rule,len (return_arr))
    rule = val[0]['rule']
    # return_arr= val[0]['return_arr']
    condition = val[0]['condition']
    trunk_type = val[0]['trunk_type']
    total_calls = 0
    # return_arr_all = []
    # for elem in val:
    #	return_arr_all.append (elem['return_arr'])
    # logger.debug("MINAVAM")
    # logger.debug ("RETURN ARRAY: "+ str(return_arr))
    # logger.debug ("RETURN ARRAY ALL: "+ str(return_arr_all))

    is_all_trunk = False
    include = rule['include']
    if include is None or include == '':
        include = 0

    exclude = rule['exclude']
    if exclude is None or exclude == '':
        exclude = 0
    if include == 0 and exclude == 0:
        is_all_trunk = True

    client_email_content_arr = {}
    # admin_email_content_arr = {}
    ## lets generate all table content:
    block_list_content = []
    for elem in val:
        block_list_content.append(elem.get('block_list_content', []))
        total_calls += elem.get('total_calls', 0)

    # print ("val", val)
    for return_arr_ in val:
        # print ("return_arr_", return_arr_)
        # print ("key", key)
        return_arr = return_arr_['return_arr']
        for elem in return_arr:
            # detail_log_id =  return_arr[key]['alert_rules_log_detail_id']
            trunk_id = return_arr['trunk_id']
            trunk_type = return_arr['trunk_type']
            code = return_arr['code']
            running_info = return_arr['running_info']
            sql_trunk_alias = "select alias from resource where resource_id = %s" % trunk_id
            logger.debug("sql_trunk_alias " + sql_trunk_alias)
            try:

                cursor.execute(sql_trunk_alias)
            # return_arr['trunk_id'] = cursor.fetchone()['alias']
            except Exception as e:
                # return_arr['trunk_id'] = "N/A"
                logger.error(str(e))
            if trunk_id not in client_email_content_arr.keys():
                client_email_content_arr[trunk_id] = {}
            client_email_content_arr[trunk_id][code] = {'trunk_type': trunk_type,
                                                        'running_info': running_info}  # 'detail_log_id': 'detail_log_id'}

    # print ("client_email_content_arr" , str(client_email_content_arr ) )
    # print ("block_list_content" , block_list_content)
    system_info = get_system_parameter(cursor)
    log_info = "e-mail system information %s " % (str(system_info))
    # print(log_info)
    logger.debug(log_info)
    # print ("sys admin:",system_info.get('noc_email',"N/A"))
    log_file = ""
    error_log = ""
    try:
        send_type_email(rule, cursor, client_email_content_arr, system_info, log_file, error_log, condition,
                        block_list_content, total_calls)
    except Exception as e:
        logger.error("send_type_email Error: " + str(e))
        traceback.print_exc()


def do_block(rule, cursor, resource_id, trunk_type, monitor_type, rule_name, config, code, log_file, error_log,
             unblock_after_min, condition):
    # print ("we are in do_block!!!")
    # Trunk, ANI, unblock at
    # The header should be modified based on the "monitor by " type
    block_list_content = {}
    block_list_content['code'] = code
    block_list_content['monitor_type'] = monitor_type
    template_column_value = '<td style="border:1px solid #cfcfcf">%s</td>'
    template_column_type = '<th style="background-color:#51A351; text-align:left;border:1px solid #cfcfcf"><font color="#ffffff">%s</font></th>'
    column_value_trunk = ''
    column_type_trunk = ''
    column_value_code = ''
    column_type_code = ''
    trunk_name = ''
    block_sql = ""
    try:

        block_list_content['trunk'] = resource_id
        update_by = "Alert Rule[%s]" % rule_name
        if (unblock_after_min) == None:
            print("unblock_after_min is not given")
            condition += "<br>Do not unblock"
            block_list_content['unblock_at'] = 'Never'
            unblock_after_min = 1000 * 365 * 24 * 60  # block for 1000 years than
            now = dt.datetime.now()
            # now.strftime("%B %d, %Y")
            not_now = now + dt.timedelta(minutes=int(unblock_after_min))
        else:
            now = dt.datetime.now()
            unblock_after_min = unblock_after_min
            print("Unblock after %s mins" % unblock_after_min)
            # now.strftime("%B %d, %Y")
            not_now = now + dt.timedelta(minutes=int(unblock_after_min))
            condition += "<br>unblock after: %s minutes" % (unblock_after_min)
            block_list_content['unblock_at'] = not_now.strftime(
                "%Y-%m-%d %H:%M:%S %Z")  # dt.datetime.strptime(not_now, '%a, %d %b %Y %H:%M:%S %Z')
        epoch_secs_unblock = int(not_now.timestamp())
        res_block_id = None

        if resource_id != -1:
            sql = """select client_id, alias FROM resource where resource_id = %s""" % (resource_id)
            print("Getting client_id for block: ", sql)
            cursor.execute(sql)
            client = cursor.fetchone()
            print("client_id to be blocked: %s" % (str(client)))
            if not client:
                print("No client to be blocked")
                return -1, -1
            client_id = client.get('client_id', False)
            resource_alias = client.get('alias', "N/A")
            trunk_name = resource_alias
            if client_id:

                if trunk_type == 1:
                    if code == '':
                        # by trunk
                        print("Block by trunk only")
                        column_value_trunk = template_column_value % (resource_id)
                        column_type_trunk = template_column_type % ("Ingress block")
                        # column_value_code =template_column_value % (code)
                        # column_type_code =template_column_type % ('N/A')
                        condition += "<br> Block by Trunk"
                        check_sql = "SELECT * FROM resource_block  WHERE ingress_res_id=%s " % (resource_id)
                        block_sql = """INSERT INTO resource_block (ingress_client_id,ingress_res_id,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,1,'%s',current_timestamp(0),%s  returning res_block_id""" % (
                        client_id, resource_id, update_by, epoch_secs_unblock)
                    # block_sql = """insert into resource_block (ingress_client_id,ingress_res_id,action_type,update_by,create_time) values (%s,%s,1,'%s',current_timestamp(0)) returning res_block_id""" % (
                    # client_id, resource_id, update_by)
                    else:
                        if monitor_type == 1:  # trunk + DNIS
                            print("Block by trunk + dnis")
                            condition += "<br> Block by Trunk and DNIS"
                            block_list_content['code_type'] = 'DNIS'
                            column_value_code = template_column_value % (code)
                            column_type_code = template_column_type % ('DNIS')
                            column_value_trunk = template_column_value % (resource_alias)
                            column_type_trunk = template_column_type % ("Ingress block")
                            block_sql = """INSERT INTO resource_block (ingress_client_id,ingress_res_id,digit,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,'%s',1,'%s',current_timestamp(0),%s  returning res_block_id""" % (
                            client_id, resource_id, code, update_by, epoch_secs_unblock)

                        # block_sql = """insert into resource_block (ingress_client_id,ingress_res_id,digit,action_type,update_by,create_time) values (%s,%s,'%s',1,'%s',current_timestamp(0)) returning res_block_id""" % (
                        # client_id, resource_id, code, update_by)
                        #
                        elif monitor_type == 2:  # trunk + ANI
                            condition += "<br> Block by Trunk and ANI"  # check_sql = """select * from resource_block where ingress_res_id=%s and  ani_prefix='%s'""" % (resource_id, code)
                            block_sql = """INSERT INTO resource_block (ingress_client_id,ingress_res_id,ani_prefix,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,'%s',1,'%s',current_timestamp(0),%s  returning res_block_id""" % (
                            client_id, resource_id, code, update_by, epoch_secs_unblock)
                            column_value_code = template_column_value % (code)
                            column_type_code = template_column_type % ('ANI')
                            column_value_trunk = template_column_value % (resource_alias)
                            column_type_trunk = template_column_type % ("Ingress block")
                        elif monitor_type == 3:  # trunk + code
                            condition += "<br> Block by Trunk and Code"
                            block_sql = """INSERT INTO resource_block (ingress_client_id,ingress_res_id,digit,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,'%s',1,'%s',current_timestamp(0),%s returning res_block_id""" % (
                            client_id, resource_id, code, update_by, epoch_secs_unblock)
                            column_value_code = template_column_value % (code)
                            column_type_code = template_column_type % ('code')
                            column_value_trunk = template_column_value % (resource_alias)
                            column_type_trunk = template_column_type % ("Ingress block")
                        elif monitor_type == 5:  # trunk +  code name
                            block_list_content['code_type'] = 'Code_name'
                            condition += "<br> Block by Trunk and Code Name"
                            print("trunk +  destination code: ", code)
                            # sql_deck = "select code_deck_id from  code_deck where name = '%s'"% code
                            # print ("sql_deck: ",sql_deck)
                            # cursor.execute(sql_deck)
                            # code_deck_id = cursor.fetchone()

                            codes = "select  array_to_string(array_agg(code), ', ')  from code where code_deck_id = 1 and UPPER(name) = UPPER('%s')" % (
                                code)
                            print("sql codes statement: ", codes)
                            logger.debug("sql codes statement: " + codes)
                            cursor.execute(codes)
                            codes = cursor.fetchone()[0]
                            print("codes: ", type(codes))
                            block_sql = """INSERT INTO resource_block (ingress_client_id,ingress_res_id,digit,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,'%s',1,'%s',current_timestamp(0),%s  returning res_block_id""" % (
                            client_id, resource_id, codes, update_by, epoch_secs_unblock)
                            column_value_code = template_column_value % (code)
                            column_type_code = template_column_type % ('Code Name')
                            column_value_trunk = template_column_value % (resource_alias)
                            column_type_trunk = template_column_type % ("Ingress block")

                        elif monitor_type == 6:  # trunk + country
                            condition += "<br> Block by Trunk and Country"
                            sql_names = "select  array_to_string(array_agg(code), ', ')  from code where UPPER (country) = UPPER ('%s')" % (
                                code)
                            cursor.execute(sql_names)
                            codes = cursor.fetchone()
                            for dummy in range(int(len(codes) / 7000) + 1):
                                print("dummy ", dummy, len(codes))
                                if len(codes) < 7000:
                                    print("code length: ", len(codes))
                                    block_sql = """INSERT INTO resource_block (ingress_client_id,ingress_res_id,digit,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,'%s',1,'%s',current_timestamp(0),%s  returning res_block_id""" % (
                                    client_id, resource_id, codes, update_by, epoch_secs_unblock)
                                    print("block_sql length:", len(block_sql))
                                else:
                                    idx = codes.rfind(',', 0, 7000)
                                    pre_code = codes[0:idx + 1]
                                    codes = codes[idx:-1]
                                    print(len(pre_code))
                                    sql = """INSERT INTO resource_block (ingress_client_id,ingress_res_id,digit,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,'%s',1,'%s',current_timestamp(0),%s returning res_block_id""" % (
                                    client_id, resource_id, pre_code, update_by, epoch_secs_unblock)
                                    try:
                                        print("sql length:", len(sql))
                                        cursor.execute(sql)
                                        res_id = cursor.fetchone()
                                        print("res_id ", res_id)
                                    except Exception as e:
                                        # print ("This is block statement that generates Error in loop: %s"% (sql) )
                                        print("Error in resource_blockage:" + str(e))
                                        log_info = "Error in resource block in loop: %s" % (str(e))
                                        logger.error(log_info)
                                        traceback.print_exc()
                                        return -1, -1, -1

                            column_value_code = template_column_value % (code)
                            column_type_code = template_column_type % ('Country')
                            column_value_trunk = template_column_value % (resource_alias)
                            column_type_trunk = template_column_type % ("Ingress block")

                        elif monitor_type == 7:  # trunk +  code
                            condition += "<br> Block by Trunk and Code"
                            block_sql = """INSERT INTO resource_block (ingress_client_id,ingress_res_id,digit,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,'%s',1,'%s',current_timestamp(0),%s  returning res_block_id""" % (
                            client_id, resource_id, code, update_by, epoch_secs_unblock)
                            column_value_code = template_column_value % (code)
                            column_type_code = template_column_type % ('code')
                            column_value_trunk = template_column_value % (resource_alias)
                            column_type_trunk = template_column_type % ("ingress block")



                elif trunk_type == 2:
                    if code == '':
                        # by trunk
                        block_list_content['code_type'] = 'N/A'
                        condition += "<br> Block by Trunk"
                        column_value_trunk = template_column_value % (resource_alias)
                        column_type_trunk = template_column_type % ("Egress block")
                        # column_value_code =template_column_value % (code)
                        # column_type_code =template_column_type % ('N/E')
                        block_sql = """INSERT INTO resource_block (egress_client_id,engress_res_id,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,1,'%s',current_timestamp(0),%s   returning res_block_id""" % (
                        client_id, resource_id, update_by, epoch_secs_unblock)

                    else:
                        if monitor_type == 1:  # trunk + DNIS
                            column_value_code = template_column_value % (code)
                            column_type_code = template_column_type % ('DNIS')
                            column_value_trunk = template_column_value % (resource_alias)
                            column_type_trunk = template_column_type % ("Egress block")
                            condition += "<br> Block by Trunk and DNIS"
                            block_sql = """INSERT INTO resource_block (egress_client_id,engress_res_id,digit,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,'%s',1,'%s',current_timestamp(0),%s WHERE NOT EXISTS (SELECT * FROM resource_block  WHERE engress_res_id=%s and digit='%s' ) returning res_block_id""" % (
                            client_id, resource_id, code, update_by, epoch_secs_unblock)
                            #
                        elif monitor_type == 2:  # trunk + ANI
                            condition += "<br> Block by Trunk and ANI"  # check_sql = """select * from resource_block where engress_res_id=%s and  ani_prefix='%s'""" % (resource_id, code)
                            block_sql = """INSERT INTO resource_block (egress_client_id,engress_res_id,ani_prefix,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,'%s',1,'%s',current_timestamp(0),%s  returning res_block_id""" % (
                            client_id, resource_id, code, update_by, epoch_secs_unblock)
                            column_value_code = template_column_value % (code)
                            column_type_code = template_column_type % ('ANI')
                            column_value_trunk = template_column_value % (resource_alias)
                            column_type_trunk = template_column_type % ("Egress block")
                        elif monitor_type == 3:  # trunk + code
                            condition += "<br> Block by Trunk and code"
                            column_value_code = template_column_value % (code)
                            column_type_code = template_column_type % ('code')
                            column_value_trunk = template_column_value % (resource_alias)
                            column_type_trunk = template_column_type % ("Egress block")
                            block_sql = """INSERT INTO resource_block (egress_client_id,engress_res_id,digit,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,'%s',1,'%s',current_timestamp(0),%s  returning res_block_id""" % (
                            client_id, resource_id, code, update_by, epoch_secs_unblock)

                        elif monitor_type == 5:  # trunk +  code name
                            block_list_content['code_type'] = 'Code_name'
                            condition += "<br> Block by Trunk and Code Name"
                            print("trunk +  destination code: ", code)
                            # sql_deck = "select code_deck_id from  code_deck where name = '%s'"% code
                            # print ("sql_deck: ",sql_deck)
                            # cursor.execute(sql_deck)
                            # code_deck_id = cursor.fetchone()

                            codes = "select  array_to_string(array_agg(code), ', ')  from code where code_deck_id = 1 and UPPER(name) = UPPER('%s')" % (
                                code)
                            print("sql codes statement: ", codes)
                            logger.debug("sql codes statement: " + codes)
                            cursor.execute(codes)
                            codes = cursor.fetchone()[0]
                            print("codes: ", type(codes))
                            block_sql = """INSERT INTO resource_block (egress_client_id,engress_res_id,digit,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,'%s',1,'%s',current_timestamp(0),%s  returning res_block_id""" % (
                            client_id, resource_id, codes, update_by, epoch_secs_unblock)
                            column_value_code = template_column_value % (code)
                            column_type_code = template_column_type % ('Code Name')
                            column_value_trunk = template_column_value % (resource_alias)
                            column_type_trunk = template_column_type % ("Egress block")

                        elif monitor_type == 6:  # trunk + country
                            condition += "<br> Block by Trunk and Country"
                            codes = "select  array_to_string(array_agg(code), ', ')  from code where UPPER(country) = UPPER('%s')" % (
                                code)
                            print("sql codes statement: ", codes)
                            cursor.execute(codes)
                            codes = cursor.fetchone()[0]
                            for dummy in range(int(len(codes) / 7000) + 1):
                                print("dummy ", dummy, len(codes))
                                if len(codes) < 7000:
                                    print("code length: ", len(codes))
                                    block_sql = """INSERT INTO resource_block (egress_client_id,engress_res_id,digit,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,'%s',1,'%s',current_timestamp(0),%s  returning res_block_id""" % (
                                    client_id, resource_id, codes, update_by, epoch_secs_unblock)
                                    print("block_sqllength:", len(block_sql))
                                else:
                                    idx = codes.rfind(',', 0, 7000)
                                    pre_code = codes[0:idx + 1]
                                    codes = codes[idx:-1]
                                    print(len(pre_code))
                                    sql = """INSERT INTO resource_block (egress_client_id,engress_res_id,digit,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,'%s',1,'%s',current_timestamp(0),%s  returning res_block_id""" % (
                                    client_id, resource_id, pre_code, update_by, epoch_secs_unblock)
                                    try:
                                        print("sql length:", len(sql))
                                        cursor.execute(sql)
                                        res_id = cursor.fetchone()
                                        print("res_id ", res_id)
                                    except Exception as e:
                                        # print ("This is block statement that generates Error in loop: %s"% (sql) )
                                        print("Error in resource_blockage:" + str(e))
                                        log_info = "Error in resource block in loop: %s" % (str(e))
                                        logger.error(log_info)
                                        traceback.print_exc()
                                        return -1, -1, -1

                            column_value_code = template_column_value % (code)
                            column_type_code = template_column_type % ('Country')
                            column_value_trunk = template_column_value % (resource_alias)
                            column_type_trunk = template_column_type % ("Egress block")

                        elif monitor_type == 7:  # trunk +  code
                            condition += "<br> Block by Trunk and Code"
                            block_sql = """INSERT INTO resource_block (egress_client_id,engress_res_id,digit,action_type,update_by,create_time,unblock_at ) SELECT %s,%s,'%s',1,'%s',current_timestamp(0),%s  returning res_block_id""" % (
                            client_id, resource_id, code, update_by, epoch_secs_unblock)
                            column_value_code = template_column_value % (code)
                            column_type_code = template_column_type % ('code')
                            column_value_trunk = template_column_value % (resource_alias)
                            column_type_trunk = template_column_type % ("Egress block")


                #
                else:  # no trunk, only dnis or ani trunk_type == 3
                    # print ("no trunk, only dnis or ani trunk_type ",monitor_type,monitor_type==4)
                    if monitor_type == 3:  # DNIS
                        column_value_code = template_column_value % (code)
                        column_type_code = template_column_type % ('DNIS')
                        column_value_trunk = template_column_value % ("N3/Reource")
                        column_type_trunk = template_column_type % ("N33/Reource")
                        condition += "<br> Block by DNIS"  ##check_sql = """select * from resource_block where ingress_res_id=%s and digit='%s'""" % (resource_id, code)
                        block_sql = """INSERT INTO resource_block (digit,action_type,update_by,create_time,unblock_at ) SELECT '%s',1,'%s',current_timestamp(0),%s  returning res_block_id""" % (
                        code, update_by, epoch_secs_unblock)
                    #
                    elif monitor_type == 4:  # ANI
                        column_value_code = template_column_value % (code)
                        column_type_code = template_column_type % ('ANI')
                        column_value_trunk = template_column_value % ("N4/Reource")
                        column_type_trunk = template_column_type % ("N44/Reource")
                        condition += "<br> Block by ANI"  # check_sql = """select * from resource_block where engress_res_id=%s and  ani_prefix='%s'""" % (resource_id, code)
                        block_sql = """INSERT INTO resource_block (ani_prefix,action_type,update_by,create_time,unblock_at ) SELECT '%s',1,'%s',current_timestamp(0),%s returning res_block_id""" % (
                        code, update_by, epoch_secs_unblock)



            else:  # no trunk, only dnis or ani trunk_type == 3
                print("no trunk, only dnis or ani trunk_type ", monitor_type, monitor_type == 4)
                if monitor_type == 3:  # DNIS
                    column_value_code = template_column_value % (code)
                    column_type_code = template_column_type % ('DNIS')
                    column_value_trunk = template_column_value % ("N3/Reource")
                    column_type_trunk = template_column_type % ("N33/Reource")
                    condition += "<br> Block by DNIS"  ##check_sql = """select * from resource_block where ingress_res_id=%s and digit='%s'""" % (resource_id, code)
                    block_sql = """INSERT INTO resource_block (digit,action_type,update_by,create_time,unblock_at ) SELECT '%s',1,'%s',current_timestamp(0),%s  returning res_block_id""" % (
                    code, update_by, epoch_secs_unblock)
                #
                elif monitor_type == 4:  # ANI
                    column_value_code = template_column_value % (code)
                    column_type_code = template_column_type % ('ANI')
                    column_value_trunk = template_column_value % ("N3/Reource")
                    column_type_trunk = template_column_type % ("N33/Reource")
                    condition += "<br> Block by ANI"  # check_sql = """select * from resource_block where engress_res_id=%s and  ani_prefix='%s'""" % (resource_id, code)
                    block_sql = """INSERT INTO resource_block (ani_prefix,action_type,update_by,create_time,unblock_at ) SELECT '%s',1,'%s',current_timestamp(0),%s returning res_block_id""" % (
                    code, update_by, epoch_secs_unblock)

        print("block statement: %s" % (block_sql))
        try:
            if rule.get("is_block", False):
                cursor.execute(block_sql)
                record_id = cursor.fetchone()

                if record_id != None:
                    record_id = record_id.get('res_block_id', 0)
                else:
                    record_id = 0
                log_info = "This is block statement that must perform  block: %s" % (block_sql)
                print(log_info)
                print("Record_id: ", record_id)
                logger.debug(log_info)
                logger.info("Block was made with res_block_id: %s" % record_id)
            else:
                print("Rule is to not to block")
                condition = "No Block"
                block_list_content['column_value_trunk'] = column_value_trunk
                block_list_content['column_type_trunk'] = column_type_trunk
                block_list_content['column_value_code'] = column_value_code
                block_list_content['column_type_code'] = column_type_code
                block_list_content['trunk_name'] = trunk_name
                return condition, block_list_content, 1
        except Exception as e:
            print("This is block statement that generates Error: %s" % (block_sql))
            print("Error in resource_blockage:" + str(e))
            log_info = "Error in resource block: %s" % (str(e))
            logger.error(log_info)
            traceback.print_exc()
            return -1, -1, -1

    except Exception as e:
        # print ("this is block statement : %s"% (block_sql) )
        print("bigger exception in resource_block: " + str(e))
        traceback.print_exc()
        return -1, -1, -1

    block_list_content['column_value_trunk'] = column_value_trunk
    block_list_content['column_type_trunk'] = column_type_trunk
    block_list_content['column_value_code'] = column_value_code
    block_list_content['column_type_code'] = column_type_code
    block_list_content['trunk_name'] = trunk_name
    return condition, block_list_content, record_id


def judge_num(n1, n2, flg, log_file, error_log):
    if n1 == None or n2 == None:
        log_info = "Judje Num: n1 or n2 are None!"
        return False
    n1 = float(n1)
    n2 = float(n2)

    log_info = "judge_num: %f %s %f " % (n1, flg, n2)
    print(log_info)
    logger.debug(log_info)

    if flg == '>':
        if n1 > n2:
            return True
        return False
    elif flg == '<':
        if n1 < n2:
            return True
        return False
    elif flg == '=':
        if n1 == n2:
            print("in search for equality!")
            return True
        return False
    else:
        print("Sign is not recognized!")
        return False


# update_at , alert_rules_log_id , resource_id , code , asr , abr , acd , pdd , profitability , revenue , system_email_address , system_email_status , partner_email_address , partner_email_status , is_email , is_block , resource_block_id , email_type

def do_log(rule, pg_cur, block_list_content, trunk_id, trunk_type, prefix, rec_id, start_of_rule):
    """Keeps track on execution of the script . blocks and emails"""
    # get noc email and etc
    sql = """select noc_email,system_admin_email from system_parameter limit 1;"""
    print("entering in log detials")
    if rec_id == None:
        rec_id = 0
    try:
        pg_cur.execute(sql)
        data = pg_cur.fetchone()
    except Exception as e:
        print("Exception in getting NOC emails %s" % str(e))
        return -1
    client_email_info = get_client_email_info(pg_cur, trunk_id, 0, 0)
    if client_email_info == None:
        client_email_info = {}
        client_email_info['email'] = "N/A"
    if not prefix:
        prefix = "null"
    noc_email = data['noc_email']
    partner_email = client_email_info['email']
    if not noc_email:
        noc_email = "N/A"
    if not noc_email:
        partner_email = "N/A"

    # start_of_rule= time.strptime(now_timestamp_str, "%Y-%m-%d %H:%M:%S")
    ## log insert
    sql = """INSERT INTO alert_rules_log(alert_rules_id,create_on,limit_asr,limit_abr,limit_acd,limit_pdd,limit_revenue,limit_profitability,limit_asr_value,
		limit_abr_value,limit_acd_value, limit_pdd_value, limit_revenue_value,limit_profitability_value,finish_time) VALUES (%s, '%s','%s','%s','%s','%s','%s','%s', %s,%s,%s,%s,%s,%s,CURRENT_TIMESTAMP(0))
		returning id""" % (rule.get('id', "NULL"), str(start_of_rule), rule.get('asr', "NULL"), rule.get('abr', "NULL"),
                           rule.get('acd', "NULL"), rule.get('pdd', "NULL"), rule.get('revenue', "NULL")
                                     , rule.get('profitability', "NULL"), rule.get('asr_value', "NULL") or "NULL",
                           rule.get('abr_value', "NULL") or "NULL", rule.get('acd_value', "NULL") or "NULL",
                           rule.get('pdd_value', "NULL") or "NULL", rule.get('revenue_value', "NULL") or "NULL",
                           rule.get('profitability_value', "NULL") or "NULL")
    print("Sql for log: ", sql)

    try:
        pg_cur.execute(sql)
        alert_rules_log_id = pg_cur.fetchone()
        if alert_rules_log_id != None:
            alert_rules_log_id = alert_rules_log_id.get('id', 0)
        else:
            alert_rules_log_id = 0

    except Exception as e:
        print("Excpetion in inserting in alert_rules_log %s" % str(e))
        return -1

    unblock_after_min = rule.get('unblock_after_min', None)
    condition = ""

    if (unblock_after_min) == None:
        print("unblock_after_min is not given")
        condition += "<br>Do not unblock"
        block_list_content['unblock_at'] = 'Never'
        unblock_after_min = 1000 * 365 * 24 * 60  # block for 1000 years than
        now = dt.datetime.now()
        # now.strftime("%B %d, %Y")
        not_now = now + dt.timedelta(minutes=int(unblock_after_min))
        epoch_secs_unblock = int(not_now.timestamp())
    else:
        now = dt.datetime.now()
        unblock_after_min = unblock_after_min  # some lag in switch
        print("Unblock after %s mins" % unblock_after_min)
        # now.strftime("%B %d, %Y")
        not_now = now + dt.timedelta(minutes=int(unblock_after_min))
        epoch_secs_unblock = int(not_now.timestamp())
    include = rule['include']
    if include == None:
        include = "NULL"
    exclude = rule['exclude']
    if exclude == None:
        exclude = "NULL"

    if prefix == None or len(prefix) == 0:
        prefix = "NULL"
    sql = """Insert  INTO alert_rules_log_detail (alert_rules_log_id,resource_id , code , asr , abr , acd , pdd , profitability , revenue , system_email_address , system_email_status , 
	partner_email_address , partner_email_status , is_email , is_block , resource_block_id , email_type ,monitor_by ,prefix,include ,exclude,trunk_type ,valid_to
	 ) SELECT %s,%s,'%s',%s,%s,%s,%s,%s,%s,'%s','%s','%s','%s',%s,%s,%s,%s,%s,'%s',%s,%s,%s,%s""" % (
    alert_rules_log_id, trunk_id,
    "code", block_list_content['ASR'], block_list_content['ABR'], block_list_content['ACD'], block_list_content['PDD'],
    block_list_content['Profit'], block_list_content['Revenue'],
    noc_email, 't', partner_email, 't', rule['is_email'], rule['is_block'], rec_id, rule['trouble_ticket_sent_to'],
    rule['monitor_by'], prefix, include,
    exclude, rule['trunk_type'], epoch_secs_unblock)

    print("Sql for inserting in Log details: " + sql)
    try:
        pg_cur.execute(sql)

    except Exception as e:
        print("Excpetion in inserting in alert_rules_log_detail %s" % str(e))
        return -1


def check_for_email(rule, pg_cur, block_list_content, trunk_id, trunk_type, prefix):
    """Checks in log did we must send new email"""
    now = dt.datetime.now()
    epoch_secs_unblock = int(now.timestamp())

    include = rule['include']
    exclude = rule['exclude']
    print("include", include, "exclude", exclude, "prefix", prefix)
    if include == None:
        include = " is null "
    else:
        include = "= '%s'" % include

    if exclude == None:
        exclude = " is null "
    else:
        exclude = "= '%s'" % exclude

    if prefix == None or prefix == "":
        prefix = "= 'null'"
    else:
        prefix = "= '%s'" % prefix

    sql = """select count (*) from alert_rules_log_detail  where resource_id = %s and  email_type = %s and monitor_by = %s and prefix %s and include %s and
	exclude %s and trunk_type = '%s' and valid_to > %s""" % (
    trunk_id, rule['trouble_ticket_sent_to'], rule['monitor_by'], prefix, include,
    exclude, rule['trunk_type'], epoch_secs_unblock)
    print("Check for existing email in log details: " + sql)
    try:
        pg_cur.execute(sql)
        count = pg_cur.fetchone()
        if count == None:
            count = 0
        else:
            count = int(count['count'])
    except Exception as e:
        print("Excpetion in checking alert_rules_log_detail %s" % str(e))
        return -1
    print("Count founded: ", count)
    return count


def PostgresQuery(rule, ms_cur, pg_cur, conf, log_file, error_log, lock):
    lock.acquire()
    trunk_type = rule['trunk_type']
    res_id = rule['res_id']
    all_trunk = rule['all_trunk']

    # trunk  Trunk + Country   - orig_country   , Code Name, orig_code  egress - termination , ingress - origination
    second_group_field_map = {0: "",  # only trunk
                              1: "routing_digits",  # trunk and routing_digits
                              2: "origination_source_number",  # trunk and origination_source_number
                              3: 'routing_digits',
                              4: 'origination_source_number',
                              5: '_code_name',
                              6: '_country',
                              7: '_code'
                              }
    second_group_field = second_group_field_map.get(rule['monitor_by']) or None;

    '''step 1 - need to Monitor Data for selected trunks onlyИзпратено на:17:29От:Upamanyu Akash step 2 - if Monitor Data by is set for ANI only then 
only block the ANIОт:Upamanyu Akash and if ANI+Trunk, then block ANI with trunk selectedТова съобщение беше редактираноОт:Upamanyu Akash and like that for
 all othersОт:Upamanyu Akash is it clear now ?'''
    prefix = ""
    prefix_grouping = ""
    print("second group field: ", second_group_field)
    where_trunk = ''
    if trunk_type == 1:  # ingress rule['trunk_type']
        # resource_equal = " resource.resource_id=ingress_id and "
        res_type = "resource.resource_id = ingress_id"
        group = "ingress_id"
        group_field = ",ingress_id as trunk_id"
        if second_group_field:
            print('monitor_by', rule['monitor_by'], type(rule['monitor_by']))
            if rule['monitor_by'] == 5 or rule['monitor_by'] == 6 or rule['monitor_by'] == 7:
                second_group_field = 'orig' + second_group_field
            group += ', %s' % second_group_field
            group_field += ', %s' % second_group_field
            group_field += ' as prefix '
            prefix = " , prefix "
            prefix_grouping = " , x.prefix"
        # if int (conf['other']['test']) !=  1 :
        #	where_trunk = " AND ingress_id is not null AND CASE WHEN is_final_call = 1 THEN  egress_id IS NOT NULL END " if all_trunk or  ( res_id is None ) else " AND ingress_id in (%s) AND CASE WHEN is_final_call = 1 THEN  egress_id IS NOT NULL END" % (res_id,)
        # else:
        where_trunk = " AND ingress_id is not null " if all_trunk or (
                    res_id is None) else " AND ingress_id in (%s) " % (res_id,)


    elif trunk_type == 2:
        res_type = "resource.resource_id = egress_id"
        group = "egress_id"
        group_field = ",egress_id as trunk_id"
        if second_group_field:
            if rule['monitor_by'] == 5 or rule['monitor_by'] == 6 or rule['monitor_by'] == 7:
                second_group_field = 'term' + second_group_field
            group += ', %s' % second_group_field
            group_field += ', %s' % second_group_field
            group_field += ' as prefix '
            prefix = " , prefix "
            prefix_grouping = " , x.prefix"
        where_trunk = " AND egress_id is not null " if all_trunk or (res_id is None) else " AND egress_id in (%s) " % (
        res_id,)


    # no egree or ingress

    elif trunk_type == 3:
        res_type = "resource.resource_id = ingress_id"
        group = ""
        group_field = ""
        if second_group_field:
            if rule['monitor_by'] == 3:
                second_group_field = "routing_digits"  # dnis only
                where_trunk = " and routing_digits is not null and is_final_call = 1 and egress_id is not NULL "
            elif rule['monitor_by'] == 4:
                second_group_field = "origination_source_number"  # ani only
                where_trunk = " and origination_source_number is not null and is_final_call =1 and egress_id is not NULL "
            else:
                where_trunk += " ingress_id is not null " if all_trunk or (
                            res_id is None) else "  ingress_id in (%s) " % (res_id,)
            group += ' %s' % second_group_field
            group_field += ', %s' % second_group_field
            group_field += ' as prefix '
            prefix = " , prefix "
            prefix_grouping = " , x.prefix"

    print("where_trunk: %s" % (where_trunk))
    monitor_by = rule.get('monitor_by', 0)
    # include
    where_code = ""

    if rule['include']:  # or rule['include'] == 0
        in_codes_arr = None
        # if monitor_by == 3 and trunk_type == 3:
        #	in_codes_arr = rule['in_codes'].split(',')
        #

        if monitor_by == 7 or monitor_by == 6:
            in_codes_arr = rule['in_codes'].split(';')
        elif monitor_by == 5:
            in_codes_arr = rule['in_code_name_id'].split(';')
        if in_codes_arr:
            for index, in_codes in enumerate(in_codes_arr):
                in_codes_arr[index] = "'" + in_codes + "'"
            in_codes_arr1 = ','.join(in_codes_arr)
            if monitor_by == 7 or monitor_by == 6:
                if trunk_type == 1:
                    where_code += " AND orig_code in (%s) " % (in_codes_arr1,)
                elif trunk_type == 2:
                    where_code += " AND term_code in (%s) " % (in_codes_arr1,)
            elif monitor_by == 5:
                if trunk_type == 1:
                    where_code += " AND orig_code_name in (%s) " % (in_codes_arr1,)
                else:
                    where_code += " AND term_code_name in (%s) " % (in_codes_arr1,)

    # exclude
    if rule['exclude']:
        in_codes_arr = None
        # if monitor_by == 3 and trunk_type == 3:
        #	in_codes_arr = rule['in_codes'].split(',')
        #

        if monitor_by == 7 or monitor_by == 6:
            in_codes_arr = rule['in_codes'].split(';')
        elif monitor_by == 5:
            in_codes_arr = rule['in_code_name_id'].split(';')
        if in_codes_arr:
            for index, in_codes in enumerate(in_codes_arr):
                in_codes_arr[index] = "'" + in_codes + "'"
            in_codes_arr1 = ','.join(in_codes_arr)
            if monitor_by == 7 or monitor_by == 6:
                if trunk_type == 1:
                    where_code += " AND orig_code not in (%s) " % (in_codes_arr1,)
                elif trunk_type == 2:
                    where_code += " AND term_code not in (%s) " % (in_codes_arr1,)
            elif monitor_by == 5:
                if trunk_type == 1:
                    where_code += " AND orig_code_name not in (%s) " % (in_codes_arr1,)
                else:
                    where_code += " AND term_code_name not in (%s) " % (in_codes_arr1,)

    print("where_code: " + where_code)

    # SELECT rule_name,monitor_by,unblock_after_min,specific_minutes ,sample_size,res_id , trunk_type , all_trunk , include , in_codes , in_code_deck , in_code_name_id , exclude , ex_code_deck , ex_code_name_id ,ex_codes  from alert_rules where active is true;
    today = dt.datetime.now()
    today_timestamp = today.replace(tzinfo=dt.timezone.utc).timestamp()  # 1474902640.906471
    from_time = today - dt.timedelta(minutes=rule['sample_size'])
    from_time_timestamp = str(int(float(from_time.replace(tzinfo=dt.timezone.utc).timestamp()) * 1000000))
    days = int(rule['sample_size'] / (60 * 24))

    sql = """select  max(end_date) as end_date,min(start_date) as start_date ,
 x.trunk_id, sum (total_calls) as total_calls,  sum (  not_zero_calls) as not_zero_calls  ,
sum( duration ) as duration, sum(busy_calls) as busy_calls,
 sum( cancel_calls ) as cancel_calls,avg(pdd) as pdd,
sum(ingress_client_cost_total) as ingress_client_cost_total,sum(egress_cost_total ) as egress_cost_total    %s
 FROM ( """ % prefix
    for day_idx in range(days + 1):
        day_cdr = today - dt.timedelta(days=day_idx)
        cdr_date = "%s%02d%02d" % (day_cdr.year, day_cdr.month, day_cdr.day)
        sql = sql + """select to_timestamp(max(start_time_of_date/1000000)) as end_date,to_timestamp(min(start_time_of_date/1000000)) as start_date ,
		  sum (  CASE WHEN ( call_duration > 0) THEN  1 ELSE 0 END)
 as not_zero_calls  ,
sum( call_duration ) as duration,  count(case when binary_value_of_release_cause_from_protocol_stack like '486%%' 
then 1 else null end) as busy_calls,
count(*) as total_calls, count( case when binary_value_of_release_cause_from_protocol_stack like '487%%' then 1 else null end )
 as cancel_calls,avg(case when call_duration > 0 then pdd else 0 end) as pdd,
sum(ingress_client_cost) as ingress_client_cost_total,sum(egress_cost) as egress_cost_total  %s 
from client_cdr%s , resource where   %s  %s  %s and start_time_of_date > %s  group by  %s 
, resource.resource_id UNION ALL """ % (
        group_field, cdr_date, res_type, where_trunk, where_code, from_time_timestamp, group)

    sql = sql[:-11]  # +";"
    # print (sql)
    sql = sql + """ ) as x    group by x.trunk_id %s   ;""" % prefix_grouping
    log_info = "Postgrsql big query: %s" % (sql)
    print(log_info)
    logger.debug(log_info)
    lock.release()
    try:
        pg_cur.execute(sql)
        data = pg_cur.fetchall()
    except Exception as e:
        lock.acquire()
        log_info = "Error in postgress big query. The erros is: %s" % (str(e))
        print(log_info)
        logger.error(log_info)
        lock.release()
        return 1
    lock.acquire()
    # print ("data:", data)
    lock.release()
    return data


def judge_define_condition(rule, ms_cur, pg_cur, conf, log_file, error_log, lock):
    '''Makes query to memsql on which base decides is it needed to block trunk and what trunk to block'''
    email_content_dict = dict()
    is_true = True
    config = conf
    lock.acquire()
    # log_to_file(log_file, "rule name: "+ rule['rule_name']+ " now will be checked against mysql or big postgress query")
    print(log_file, "rule name: " + rule['rule_name'] + " now will be checked against mysql or big postgress query")
    sql = 'UPDATE alert_rules SET status = true where id =  %s' % (rule['id'])
    try:
        pg_cur.execute(sql)
    except Exception as e:
        log_info = "Error in postgress , updating alert_rules.status. The erros is: %s" % (str(e))
        print(log_info)
        logger.error(log_info)

    lock.release()

    trunk_type = rule['trunk_type']
    res_id = rule['res_id']
    all_trunk = rule['all_trunk']
    sample_size = rule.get('sample_size')  # how far to check in time

    now = dt.datetime.now(dt.timezone.utc)
    global END_DATE, START_DATE
    END_DATE = now
    START_DATE = now - dt.timedelta(minutes=sample_size)
    if sample_size > 0:
        # log_to_file(log_file,"Postgress will make query")
        data = PostgresQuery(rule, ms_cur, pg_cur, conf, log_file, error_log, lock)
        if data == 1:
            lock.acquire()
            log_info = "Fail in slow query to postgress"
            print(log_info)
            logger.error(log_info)
            sql = 'UPDATE alert_rules SET status = false where id =  %s' % (rule['id'])
            try:
                pg_cur.execute(sql)
            except Exception as e:
                log_info = "Error in postgress , updating alert_rules.status. The erros is: %s" % (str(e))
                print(log_info)
                logger.error(log_info)
            lock.release()
            return {}
    else:
        # where time now down to now - sampleSize minss
        lock.acquire()
        # log_to_file(log_file,"Mysql will make query")
        where_time = " FROM_UNIXTIME(`start_time_of_date` / 1000000) >= (select max (FROM_UNIXTIME (start_time_of_date / 1000000)) -interval %s minute FROM `%s` order by 1 desc limit 1)" % (
        sample_size, conf["other"]["cdr_table"])

        # logger.info("where_time12345: " + where_time)
        # trunk  Trunk + Country   - orig_country   , Code Name, orig_code  egress - termination , ingress - origination
        second_group_field_map = {
            0: "",  # only trunk
            1: "trunk and routing_digits",
            2: "trunk and origination_source_number",
            3: 'routing_digits',
            4: 'origination_source_number',
            5: '_code_name',
            6: '_country',
            7: '_code '
        }

        # update alert_rules set last_run_time = null where active is true ;

        # trunk and dest = 5 trunk and country = 6 trunk and code = 7

        second_group_field = second_group_field_map.get(rule['monitor_by']) or None;

        where_trunk = ''
        if trunk_type == 1:  # ingress rule['trunk_type']

            if rule['monitor_by'] == 5:
                if rule['include']:
                    resources = rule.get("in_code_name_id", "")
                elif rule['exclude']:
                    resources = rule.get("ex_code_name_id", "")
            # elif  rule['monitor_by'] == 3:
            #	resources = rule.get ("in_codes","")

            res_type = "ingress_id"
            group = "ingress_id"
            group_field = "ingress_id as trunk_id"
            if second_group_field:
                if rule['monitor_by'] > 4:
                    if rule['include']:
                        second_group_field = 'orig' + second_group_field
                        where_trunk += " AND " + second_group_field + " in ('%s')" % resources
                    else:
                        second_group_field = 'orig' + second_group_field
                        where_trunk += " AND " + second_group_field + " not in ('%s')" % resources
                group += ', %s' % second_group_field
                group_field += ', %s' % second_group_field
                group_field += ' as prefix '
            if int(conf['other']['test']) != 1:
                where_trunk += " AND ingress_id is not null AND CASE WHEN is_final_call = 1 THEN  egress_id IS NOT NULL END " if all_trunk or (
                            res_id is None) else " AND ingress_id in (%s) AND CASE WHEN is_final = 1 THEN  egress_id IS NOT NULL END" % (
                    res_id)
            else:
                where_trunk += " AND ingress_id is not null " if all_trunk or (
                            res_id is None) else " AND ingress_id in (%s) " % (res_id,)

        elif trunk_type == 2:
            print("EGRESS!!")
            res_type = "egress_id"
            group = "egress_id"
            group_field = "egress_id as trunk_id"
            if second_group_field:
                if rule['monitor_by'] > 2:
                    second_group_field = 'term' + second_group_field
                group += ', %s' % second_group_field
                group_field += ', %s' % second_group_field
                group_field += ' as prefix '
            where_trunk = " AND egress_id is not null " if all_trunk or (
                        res_id is None) else " AND egress_id in (%s) " % (res_id,)

            print("where_trunk is set to: ", where_trunk)
        # no egree or ingress

        elif trunk_type == 3:
            print("No Where trunk!")
            group = "orig_code"
            group_field = ""
            if second_group_field:
                group_field += ' %s' % second_group_field
                group_field += ' as prefix '

        print("where_trunk: %s" % (where_trunk))

        # include
        where_code = ""
        if rule['include']:
            if rule['monitor_by'] == 5:
                field = 'in_code_name_id'
                what = "_code_name"
            elif rule['monitor_by'] == 7:
                field = 'in_codes'
                what = "_code"
            else:
                field = 'in_codes'
            in_codes_arr = rule[field].split(',')
            print("in_codes_arr: ", in_codes_arr)
            if len(in_codes_arr[0]) > 0:

                for index, in_codes in enumerate(in_codes_arr):
                    in_codes_arr[index] = "'" + in_codes + "'"
                in_codes_arr1 = ','.join(in_codes_arr)

                if trunk_type == 1:
                    where_code += " AND orig%s in (%s) " % (what, in_codes_arr1)
                else:
                    where_code += " AND term%s in (%s) " % (what, in_codes_arr1)
        # where_code += " AND term%s in (%s) " % (what,in_codes_arr1,)

        # exclude
        if rule['exclude']:
            if rule['monitor_by'] == 5:
                what = "_code_name"
                field = 'ex_code_name_id'
            elif rule['monitor_by'] == 7:
                what = "_code"
                field = 'ex_codes'
            ex_codes_arr = rule[field].split(',')
            if ex_codes_arr:
                for key, ex_codes in enumerate(ex_codes_arr):
                    ex_codes_arr[key] = "'" + ex_codes + "'"
                ex_codes_arr1 = ','.join(ex_codes_arr)

                if trunk_type == 1:
                    where_code += " AND orig%s not in (%s) " % (what, ex_codes_arr1,)
                else:
                    where_code += " AND term%s not in (%s) " % (what, ex_codes_arr1,)
        # print ("include , exclude",rule['include'],rule['exclude'],rule['in_codes'].split(','),rule['ex_codes'].split(','))
        print("where_code: " + where_code)
        # here

        if (conf['other']['debug_level'] == 1):
            log_info = " second_group_field: %s,where_trunk: %s,where_code: %s" % (
            second_group_field, where_trunk, where_code)
            print(log_info)
            logger.debug(log_info)
        sql_2 = """SELECT  FROM_UNIXTIME(max(start_time_of_date/1000000)) as end_date,FROM_UNIXTIME(min(start_time_of_date/1000000)) as start_date , sum(call_duration) as duration,count(case when call_duration > 0 then 1 else null end) as not_zero_calls,
 count(case when binary_value_of_release_cause_from_protocol_stack like '486%' then 1 else null end) as busy_calls,count(*) as total_calls,
 count( case when binary_value_of_release_cause_from_protocol_stack like '487%' then 1 else null end ) as cancel_calls,sum(case when call_duration > 0 then pdd else 0 end) as pdd,
 sum(ingress_client_cost) as ingress_client_cost_total,sum(egress_cost) as egress_cost_total,""" + group_field + """ FROM `%s` WHERE %s %s %s GROUP BY %s """ % (
        conf["other"]["cdr_table"], where_time, where_trunk, where_code, group)

        # if (conf['other']['debug_level'] == 1):
        log_info = "Mysql query: %s" % (sql_2)
        print(log_info)
        logger.debug(log_info)
        # print(sql_2)
        lock.release()
        try:
            ms_cur.execute(sql_2)
        except Exception as e:
            lock.acquire()
            log_info = "Error in mysql. The erros is: %s" % (str(e))
            print(log_info)
            logger.error(log_info)

            sql = 'UPDATE alert_rules SET status = false where id =  %s' % (rule['id'])
            try:
                pg_cur.execute(sql)
            except Exception as e:
                log_info = "Error in postgress , updating alert_rules.status. The erros is: %s" % (str(e))
                print(log_info)
                logger.error(log_info)
            lock.release()
            return 1
        data = ms_cur.fetchall()
    lock.acquire()
    print("data_len: " + str(len(data)))
    logger.debug("data_len: " + str(len(data)))
    return_arr = {}
    second_data = {}

    min_call_attempt = rule['min_call_attempt']
    print("Min_call_attempt ", min_call_attempt)
    if min_call_attempt is None or min_call_attempt == '':
        min_call_attempt = 0
    min_call_attempt = int(min_call_attempt)

    for i, item in enumerate(data):
        # print ("orig_code:",item["orig_code"])
        if item.get("orig_code") == 0:
            log_info = "Orig code iz zero. Skiping this loop"
            print(log_info)
            logger.debug(log_info)
            continue
        _sum = item.get('total_calls') or 0
        _sum = int(_sum)

        prefix = ''
        second_data = {}
        print("total calls", _sum)
        if _sum < min_call_attempt:  # if notZeroCalls < 10 : continue
            print("NOT ENOUGH TOTAL CALLS")
            log_info = "sum is smaller from total_calls"
            print(log_info)
            logger.debug(log_info)
            continue
        duration = int(item['duration']) if item['duration'] is not None else 0
        not_zero_calls = int(item['not_zero_calls']) if item['not_zero_calls'] is not None else 0
        busy_calls = int(item['busy_calls']) if item['busy_calls'] is not None else 0
        total_calls = int(item['total_calls']) if item['total_calls'] is not None else 0
        cancel_calls = int(item['cancel_calls']) if item['cancel_calls'] is not None else 0
        ingress_client_cost_total = item['ingress_client_cost_total'] if item[
                                                                             'ingress_client_cost_total'] is not None else 0
        egress_cost_total = item['egress_cost_total'] if item['egress_cost_total'] is not None else 0
        pdd = item['pdd'] if item['pdd'] is not None else 0
        second_data['acd'] = round((duration / not_zero_calls),
                                   2) if not_zero_calls != 0 else 0  # средна продължителност на разговора ?
        # abr = {(number of {200 ok} call )/total number of calls}*100
        second_data['abr'] = round(not_zero_calls / total_calls * 100,
                                   2) if total_calls != 0 else 0  # процент на реалните разговори от всички
        asr_ = busy_calls + cancel_calls + not_zero_calls  # каква е разликата между тотал колс и asr?
        second_data['asr'] = round((not_zero_calls / total_calls) * 100,
                                   2) if asr_ != 0 else 0  # процент на реалните разговори от всички - но се дублира с абр ?
        second_data['pdd'] = round(pdd / not_zero_calls) if not_zero_calls != 0 else 0
        second_data['profitability'] = (
                                                   ingress_client_cost_total - egress_cost_total) / ingress_client_cost_total * 100 if ingress_client_cost_total != 0 else 0
        second_data[
            'revenue'] = ingress_client_cost_total  # - egress_cost_total  Sourav Revenue formula is not correct, I think.. Let me checkИзпратено на:10:50От:Sourav Profit is okОт:Sourav Revenue = Total Ingress client cost
        print("not_zero_calls=%s, busy_calls=%s, cancel_calls=%s, total_=%s," % (
        not_zero_calls, busy_calls, cancel_calls, total_calls))
        # print ("duration:",duration,"not_zero_calls:",not_zero_calls,"busy_calls:"busy_calls,"cancel_calls:",cancel_calls,)
        print("second_data : ", str(second_data), "start-end date:", item['start_date'], " +00:00", item['end_date'],
              " +00:00")
        print("rules: acd: %s%s asr: %s%s,abr: %s%s, pdd: %s%s, prof: %s%s " % (
        rule['acd'], rule['acd_value'], rule['asr'], rule['asr_value'], rule['abr'], rule['abr_value'],
        rule['pdd'], rule['pdd_value'], rule['profitability'], rule['profitability_value']))
        # logger.info("rule: " + str(rule))
        # not_met = False # if we have more from one condition. we must sure that they are old met !
        prefix = ''
        print("Judjing %s" % (rule['rule_name']))
        condition = 'Conditions: '
        if 'monitor_by' in rule.keys():
            if (rule['monitor_by'] == 1) or (rule['monitor_by'] == 2) or (rule['monitor_by'] == 3) or (
                    rule['monitor_by'] == 4) or (rule['monitor_by'] == 5) or (rule['monitor_by'] == 6) or (
                    rule['monitor_by'] == 7):  # DNIS or ANI
                prefix = item['prefix']
                print("PREFIX SET TO: ", prefix)
            log_info = "not_zero_calls=%s, busy_calls=%s, cancel_calls=%s, asr_=%s. Second data: %s" % (
            not_zero_calls, busy_calls, cancel_calls, asr_, str(second_data))
            print(log_info)
            logger.debug(log_info)
            log_info = "prefix: " + str(prefix)
            print(log_info)
            logger.debug(log_info)
        block_yes = False
        if rule['acd_value'] != None and ('acd' in second_data.keys()) and rule['acd'] != "1":
            print("acd_value found!!!")
            if judge_num(second_data['acd'], rule['acd_value'], rule['acd'], log_file, error_log):
                log_info = "acd_ judje True!!!  acd_value %s second_data_acd: %s rule_acd: %s" % (
                rule['acd_value'], second_data['acd'], rule['acd'])
                print(log_info)
                # condition +=  "<br>ACD " +  rule['acd']  + str (rule['acd_value'])
                logger.debug(log_info)
                block_yes = True
            else:
                print("Rule %s will not be blocked because of acd_rule is not met" % (rule['rule_name']))
                logger.debug("Rule %s will not be blocked because of acd_rule is not met" % (rule['rule_name']))
                continue
        if rule['asr_value'] != None and ('asr' in second_data.keys()) and rule['asr'] != "1":
            print("asr_value found!!!")
            if judge_num(second_data['asr'], rule['asr_value'], rule['asr'], log_file, error_log):
                log_info = "asr_ judje True!!!  asr_value %s second_data_asr: %s rule_asr: %s" % (
                rule['asr_value'], second_data['asr'], rule['asr'])
                # condition +=  "<br>ASR " +  rule['asr']  + str (rule['asr_value'])
                print(log_info)
                logger.debug(log_info)
                block_yes = True
            else:
                print("Rule %s will not be blocked because of asr_rule is not met" % (rule['rule_name']))
                logger.debug("Rule %s will not be blocked because of asr_rule is not met" % (rule['rule_name']))
                continue
        if rule['abr_value'] != None and ('abr' in second_data.keys()) and rule['abr'] != '1':
            print("abr_value found!!!")
            if judge_num(second_data['abr'], rule['abr_value'], rule['abr'], log_file, error_log):
                log_info = "abr_ judje True!!!  abr_value %s second_data_abr: %s rule_abr: %s" % (
                rule['abr_value'], second_data['abr'], rule['abr'])
                # condition +=  "<br>ABR " +  rule['abr']  + str (rule['abr_value'])
                print(log_info)
                logger.debug(log_info)
                block_yes = True
            else:
                print("Rule %s will not be blocked because of abr_rule is not met" % (rule['rule_name']))
                logger.debug("Rule %s will not be blocked because of abr_rule is not met" % (rule['rule_name']))
                continue

        if rule['pdd_value'] != None and ('pdd' in second_data.keys()) and rule['pdd'] != '1':
            print("pdd_value found!!!")
            if judge_num(second_data['pdd'], rule['pdd_value'] * 1000, rule['pdd'], log_file, error_log):
                log_info = "pdd_ judje True!!!  pdd_value %s second_data_pdd: %s rule_pdd: %s" % (
                rule['pdd_value'] * 1000, second_data['pdd'], rule['pdd'])
                # condition +=  "<br>PDD " +  rule['pdd']  + str (rule['pdd_value'])
                print(log_info)
                logger.debug(log_info)
                block_yes = True
            else:
                print("Rule %s will not be blocked because of pdd_rule is not met" % (rule['rule_name']))
                logger.debug("Rule %s will not be blocked because of pdd_rule is not met" % (rule['rule_name']))
                continue
        if rule['profitability_value'] != None and ('profitability' in second_data.keys()) and rule[
            'profitability'] != "1":
            print("profitability_value found!!!")
            if judge_num(second_data['profitability'], rule['profitability_value'], rule['profitability'], log_file,
                         error_log):
                log_info = "profitability_ judje True!!!  profitability_value %s second_data_profitability: %s rule_profitability: %s" % (
                rule['profitability_value'], second_data['profitability'], rule['profitability'])
                print(log_info)
                # condition +=  "<br>profitability " +  rule['profitability']  + str (rule['profitability_value'])
                logger.debug(log_info)
                block_yes = True
            else:
                print("Rule %s will not be blocked because of profitability_rule is not met" % (rule['rule_name']))
                logger.debug(
                    "Rule %s will not be blocked because of profitability_rule is not met" % (rule['rule_name']))
                continue

        if rule['revenue_value'] != None and ('revenue' in second_data.keys()) and rule['revenue'] != "1":
            print("revenue_value found!!!")
            if judge_num(second_data['revenue'], rule['revenue_value'], rule['revenue'], log_file, error_log):
                log_info = "revenue_ judje True!!!  revenue_value %s second_data_revenue: %s rule_revenue: %s" % (
                rule['revenue_value'], second_data['revenue'], rule['revenue'])
                print(log_info)
                # condition +=  "<br>revenue " +  rule['revenue']  + str (rule['revenue_value'])
                logger.debug(log_info)
                block_yes = True
            else:
                logger.debug("Rule %s will not be blocked because of revenue_rule is not met" % (rule['rule_name']))
                print("Rule %s will not be blocked because of revenue_rule is not met" % (rule['rule_name']))
                continue

        if block_yes == False:
            print("Rule %s will not be blocked bcoz of prof_rule is not met" % (rule['rule_name']))
            continue

        block_list_content = {}
        if 'trunk_id' in item.keys():
            trunk_id = item['trunk_id']
        else:
            trunk_id = -1

        if 'monitor_by' in rule.keys():
            log_info = "trunk_id: %s, trunk_type: %s,monitor_by: %s,rule_name: %s, prefix: %s" % (
            trunk_id, trunk_type, rule['monitor_by'], rule['rule_name'], prefix)
            print(log_info)
            logger.debug(log_info)
            if (prefix != ''):
                print("Do block with prefix and monitor_by")
                condition, block_list_content, record_id = do_block(rule,
                                                                    pg_cur, trunk_id, trunk_type, rule['monitor_by'],
                                                                    rule['rule_name'], config,
                                                                    prefix, log_file, error_log,
                                                                    rule.get('unblock_after_min', 1000000)
                                                                    , condition)
            else:
                print("Do block with  monitor_by")
                condition, block_list_content, record_id = do_block(rule, pg_cur, trunk_id, trunk_type,
                                                                    rule['monitor_by'], rule['rule_name'], config, '',
                                                                    log_file, error_log,
                                                                    rule.get('unblock_after_min', 1000000), condition)

        else:
            log_info = "No monitor_by! trunk_id: %s, trunk_type: %s,rule_name: %s, prefix: %s" % (
            trunk_id, trunk_type, rule['rule_name'], prefix, log_file, error_log)
            print(log_info)
            logger.debug(log_info)
            if (prefix != ''):
                print("Do block with  prefix")
                condition, block_list_content, record_id = do_block(rule, pg_cur, trunk_id, trunk_type, "",
                                                                    rule['rule_name'], config, prefix, log_file,
                                                                    error_log, rule.get('unblock_after_min', 1000000),
                                                                    condition)
            else:
                print("Do block with  no prefix or monitor_by")
                condition, block_list_content, record_id = do_block(rule, pg_cur, trunk_id, trunk_type, "",
                                                                    rule['rule_name'], config, '', log_file, error_log,
                                                                    rule.get('unblock_after_min', 1000000), condition)
        # , , , , , Profit

        if condition == -1:
            print("Do block raised error. Please check!")
            continue

        try:
            block_list_content['Sample_Duration'] = duration
            block_list_content['Attempt'] = total_calls
            block_list_content['Connected Calls'] = not_zero_calls
            block_list_content['ASR'] = second_data['asr']
            block_list_content['ABR'] = second_data['abr']
            block_list_content['ACD'] = second_data['acd']
            block_list_content['Revenue'] = second_data['revenue']
            block_list_content['PDD'] = second_data['pdd']
            block_list_content['Profit'] = second_data['profitability']
            block_list_content['start_date'] = item['start_date']
            block_list_content['end_date'] = item['end_date']

        except:
            block_list_content = {}
            block_list_content['ABR'] = "N/A"
            block_list_content['Sample_Duration'] = "N/A"
            block_list_content['Attempt'] = "N/A"
            block_list_content['ASR'] = "N/A"
            block_list_content['ACD'] = "N/A"
            block_list_content['Revenue'] = "N/A"
            block_list_content['PDD'] = "N/A"
            block_list_content['Profit'] = "N/A"
            block_list_content['start_date'] = "N/A"
            block_list_content['end_date'] = "N/A"

        # logger.info("can run")
        return_arr = {}
        return_arr['running_info'] = second_data
        return_arr['trunk_id'] = item.get('trunk_id')
        # print ("TRUNK ID GETTT: ", item.get('trunk_id'))
        return_arr['trunk_type'] = trunk_type
        return_arr['code'] = item.get('prefix')
        print("return_arr", return_arr)
        # if block_yes == True and record_id > 0:  # do email and lgoin only if record_id is not -1!!!
        #	print ("return_arr",return_arr, "block_list_content",block_list_content,"record_id",record_id )
        #	print ("block_yes!!!")
        if item['trunk_id'] not in email_content_dict:
            email_content_dict[item['trunk_id']] = [{"rule": rule, "return_arr": return_arr, "condition": condition,
                                                     "block_list_content": block_list_content,
                                                     "trunk_type": trunk_type, "total_calls": total_calls}]
        else:
            email_content_dict[item['trunk_id']].append({"rule": rule, "return_arr": return_arr, "condition": condition,
                                                         "block_list_content": block_list_content,
                                                         "trunk_type": trunk_type, "total_calls": total_calls})
    print("email_content_dict", email_content_dict)
    # email if is defined

    is_email = rule['is_email']
    if not is_email:  # trunk_type == 3
        log_info = "rule_name %s will not be emailed" % (rule['rule_name'])
        print(log_info)
        logger.debug(log_info)
        for key, val in email_content_dict.items():
            do_log(rule, pg_cur, val[0].get('block_list_content'), trunk_id, trunk_type, prefix, record_id, now)

    else:
        for key, val in email_content_dict.items():
            log_info = "e-mail for %s " % (rule['rule_name'])
            # print(log_info)
            logger.debug(log_info)
            count = 0  # check_email_log (pg_cur,key,rule )  #check_for_email(rule,pg_cur,block_list_content,trunk_id, trunk_type,  prefix)
            # print ("count ", count)
            if count < 1:
                email(key, val, pg_cur)  # key - trunk_id, val - returned values
            do_log(rule, pg_cur, val[0].get('block_list_content'), trunk_id, trunk_type, prefix, record_id, now)

    print("Running rule %s is finished" % (rule['rule_name']))
    sql = 'UPDATE alert_rules SET status = false where id =  %s' % (rule['id'])
    try:
        pg_cur.execute(sql)
    except Exception as e:
        log_info = "Error in postgress , updating alert_rules.status. The erros is: %s" % (str(e))
        print(log_info)
        traceback.print_exc()
        logger.error(log_info)

    lock.release()
    return return_arr


def judge_time(rule, cursor, config, log_file, error_log):
    now_timestamp_str = time.strftime("%Y-%m-%d %H:%M:00")
    log_info = "Now is: %s" % (now_timestamp_str)
    interval_type = rule['execution_schedule']
    last_run_time = rule['last_run_time']

    is_true = False

    if interval_type == 1:
        log_info = "by minute"
        print(log_info)
        logger.debug(log_info)
        if not last_run_time:
            is_true = True
        else:
            if last_run_time != None:
                last_run_time_str = str(last_run_time)
                pos = last_run_time_str.find(':')
                pos = last_run_time_str.find(':', pos + 1)
                last_run_time_str = last_run_time_str[:pos] + ":00"
            else:
                last_run_time_str = "Never"
            every_min = rule['specific_minutes']
            if every_min is None or every_min == '':
                every_min = 1
            every_min = int(every_min)
            log_info = "interval time:" + str(every_min)
            print(log_info)
            logger.debug(log_info)
            next_plan_run_time = last_run_time + dt.timedelta(minutes=every_min)
            log_info = "next_plan_run_time:" + str(next_plan_run_time)
            print(log_info)
            logger.debug(log_info)

            if every_min == 1:
                is_true = True
            else:
                if last_run_time == None:
                    is_true = True
                else:
                    last_run_time = dt.datetime.strptime(last_run_time_str, "%Y-%m-%d %H:%M:%S")
                    last_run_time = time.mktime(last_run_time.timetuple())
                    now_timestamp = time.mktime(time.strptime(now_timestamp_str, "%Y-%m-%d %H:%M:%S"))
                    print(last_run_time, now_timestamp, last_run_time <= now_timestamp - 60 * every_min)
                    if last_run_time <= now_timestamp - 60 * every_min:  # 超过间隔，满足
                        is_true = True
                    else:
                        is_true = False
    elif interval_type == 2:  # 按天
        log_info = "by day"
        print(log_info)
        # logger.debug(log_info)
        day_time = rule['daily_time']
        if day_time is None or day_time == '':
            day_time = 0
        day_time = int(day_time)

        now_timestamp = time.strptime(now_timestamp_str, "%Y-%m-%d %H:%M:%S")
        now_hour = now_timestamp.tm_hour
        now_day = now_timestamp.tm_mday
        print(now_hour, now_day, last_run_time, day_time)
        if last_run_time is None or last_run_time == '':
            if int(now_hour) == int(day_time):
                is_true = True
        else:
            last_run_time_str = str(last_run_time)
            pos = last_run_time_str.find(':')
            last_run_time_str = last_run_time_str[:pos] + ":00:00"
            last_run_time = time.strptime(last_run_time_str, "%Y-%m-%d %H:%M:%S")
            last_run_hour = last_run_time.tm_hour
            last_run_day = last_run_time.tm_mday
            log_info = "by_day:last_run_time" + last_run_time_str
            print(log_info)
            logger.debug(log_info)
            print(now_hour, last_run_hour, now_day, last_run_day)
            if now_day != last_run_day:
                if int(now_hour) == int(day_time):
                    is_true = True
            else:
                if now_hour != last_run_hour and int(now_hour) == int(day_time):
                    is_true = True
    else:
        log_info = "by week"
        print(log_info)
        logger.debug(log_info)
        # logger.info("by week")
        week_time = rule['weekly_time']
        if week_time is None or week_time == '':
            week_time = 0
        week_day = rule['weekly_value']
        if week_day is None or week_day == '':
            week_day = 0
        print("last run time:", str(last_run_time))
        now_timestamp = time.strptime(now_timestamp_str, "%Y-%m-%d %H:%M:%S")
        now_hour = now_timestamp.tm_hour
        now_wday = now_timestamp.tm_wday + 1

        if last_run_time is None or last_run_time == '':
            print(now_hour, week_time, now_wday, week_day)
            if int(now_hour) == int(week_time) and int(now_wday) == int(week_day):
                is_true = True
        else:
            last_run_time_str = str(last_run_time)
            pos = last_run_time_str.find(':')
            last_run_time_str = last_run_time_str[:pos] + ":00:00"
            last_run_time = time.strptime(last_run_time_str, "%Y-%m-%d %H:%M:%S")

            last_run_hour = last_run_time.tm_hour
            last_run_wday = last_run_time.tm_wday + 1  # count Monday as = 1

            # logger.info("by week:last_run_time: " + last_run_time_str)
            log_info = "by week:last_run_time: " + last_run_time_str
            # print(log_info)

            # print(week_time+now_hour+last_run_hour)
            # print(week_day+now_wday+last_run_wday)
            print(now_wday, last_run_wday, now_hour, last_run_hour)
            # 4 3 10 10
            if now_wday != last_run_wday:
                if int(now_hour) == int(week_time) and int(now_wday) == int(week_day):
                    is_true = True
            else:
                if now_hour != last_run_hour and int(now_hour) == int(week_time) and int(now_wday) == int(week_day):
                    is_true = True

    if is_true:
        try:
            cursor.execute("""update alert_rules set last_run_time = CURRENT_TIMESTAMP(0) where id = %s""",
                           (rule['id'],))
            log_info = "update alert query executed:    %s %s" % (
            "update alert_rules set last_run_time = CURRENT_TIMESTAMP(0) where id =", rule['id'])
            print(log_info)
            logger.debug(log_info)
        except Exception as e:
            log_info = "Error in updating  active rules last_run_time from postgress. The erros is: %s" % (str(e))
            print(log_info)
            # print("errer is in sql: update alert_rules set last_run_time = CURRENT_TIMESTAMP(0) where id = %s" % (rule['id'] ) )
            logger.error(log_info)
    return is_true


def alert_rule(pg_cur, ms_cur, config, log_file, error_log):
    # config['other']['debug_level']
    sql = """SELECT * FROM alert_rules where active is true"""  # sql select all active monitoring rules
    lock = Lock()  # lock
    logger.debug(sql)
    try:
        pg_cur.execute(sql)
    # print ("try pycur",pg_cur.fetchone())
    except Exception as e:
        log_info = "Error in selecting active rules from postgress. The erros is: %s" % (str(e))
        print(log_info)
        logger.error(log_info)

    for rule in pg_cur.fetchall():
        # print( "Getting lock" )
        lock.acquire()
        # print( "Lock is acquired" )
        log_info = "Active rule will be examine:  Name: %s , is_running:%s , Trunk_type: %s ,all_trunk: %s, Last Run Time: %s, Update at: %s Send Email: %s  rules: acd %s%s asr: %s%s,abr: %s%s, pdd: %s%s, prof: %s%s" % (
        rule['rule_name'], rule['status'],
        rule['trunk_type'], rule['all_trunk'], rule['last_run_time'], rule['update_at'], rule['is_email'], rule['acd'],
        rule['acd_value'], rule['asr'], rule['asr_value'], rule['abr'], rule['abr_value'], rule['pdd'],
        rule['pdd_value'], rule['profitability'], rule['profitability_value'])
        print(log_info)
        logger.debug(log_info)
        if rule['status'] == True:
            max_minutes = int(config['other'].get('max_sql_execution_time_in_minutes', 5))
            # pattern = '%d-%m-%Y %H:%M:%S+%S%z'  #2016-10-02 07:55:58+00:00
            last_run_time_datetime = rule.get('last_run_time', 0)
            now = dt.datetime.now(dt.timezone.utc)

            try:
                mins_difference = (now - last_run_time_datetime).total_seconds()
            except:
                mins_difference = max_minutes * 60 + 1  # new loop now!
            if mins_difference - max_minutes * 60 > 0:
                log_info = "rule_name %s exceeded max_sql_execution_time of %s minutes" % (
                rule['rule_name'], max_minutes)
                print(log_info)
                logger.debug(log_info)
            try:
                sql = """UPDATE alert_rules SET status = False WHERE rule_name = '%s'""" % (rule['rule_name'])
                pg_cur.execute(sql)
            except Exception as e:
                log_info = "Error in reseting status of rule from postgress. The erros is: %s" % (str(e))
                print(log_info)
                logger.error(log_info)
            else:
                log_info = "rule_name: %s is still active. Last execution time was: %s Skipping this loop" % (
                rule['rule_name'], rule['last_run_time'])
                print(log_info)
                logger.debug(log_info)
            lock.release()
            continue
        is_true = judge_time(rule, pg_cur, config, log_file, error_log)
        logger.debug("Judje Time returned: " + str(is_true))
        if not is_true:
            log_info = "rule_name %s will NOT be executed" % (rule['rule_name'])
            print(log_info)
            logger.debug(log_info)
            lock.release()
            continue
        log_info = "rule_name %s will be executed" % (rule['rule_name'])
        print(log_info)
        logger.debug(log_info)

        try:
            lock.release()
            p = Process(target=judge_define_condition, args=(rule, ms_cur, pg_cur, config, log_file, error_log, lock))
            p.start()
            p.join(30)

        except Exception as e:

            log_info = "Error in making judje define proccess {0} \n".format(str(e))
            print(log_info)
            logger.error(log_info)
            lock.release()
    # time.sleep(3)


def unblock_rule(pg_cur, ms_cur, config, log_file, error_log):
    '''Checks for rule that must be unblocked from resource_block'''
    now = dt.datetime.now()
    epoch_secs_unblock = int(now.timestamp())

    # sql = " select count(*) from resource_block where unblock_at < %s" % (epoch_secs_unblock)
    # pg_cur.execute(sql)
    # data = pg_cur.fetchone()
    sql = " delete from resource_block where unblock_at < %s" % (epoch_secs_unblock)
    pg_cur.execute(sql)
    # if data == None:
    #	data = 0
    # else:
    #	data = data['count']

    # print ("Unblocking result of qyery  %s :  %s " % (sql , data) )
    log_info = "Unblock Query executed: %s" % (sql)
    logger.debug(log_info)


def connect_to_postgresql(log_file, error_log, host, port, database, user, password=None):
    try:
        conn = psycopg2.connect(host=host, port=port, database=database, user=user, password=password)
        conn.autocommit = True
        cursor = conn.cursor(cursor_factory=psycopg2.extras.DictCursor)
    except Exception as e:
        traceback.print_exc()
        logger.error(str(traceback.print_exc()))
        logger.error('Unable to connect to the PostgrSQL')
        print('Unable to connect to the PostgrSQL')
    return conn, cursor


def main():
    global config
    # setting PID
    pidf = "rules_alert.pid"
    pidfile = PIDLockFile(pidf, timeout=-1)
    try:
        # script = subprocess.run("./cf.py", shell=True)
        pidfile.acquire()
        print("Lock aquered!")
    except AlreadyLocked:
        try:
            os.kill(pidfile.read_pid(), 0)
            print('Process already running!')
            # logger.error('Process already running!')
            exit(1)
        except OSError:  # No process with locked PID
            print(pidfile.read_pid())
            pidfile.break_lock()
            print("No process with locked PID")
    # logger.error('No process with locked PID')
    # Get config.ini
    config = configparser.ConfigParser()
    config.read('./config.ini')
    # set logger
    if int(config["log"].get('by_time', 0)) == 1:
        # handler = TimedRotatingFileHandler ( "rules_alert.log" ,when="m",interval=1,backupCount=5)
        handler = TimedRotatingFileHandler(config["log"].get("alert_rules_path", "rules_alert.log"),
                                           when=config["log"].get("alert_rules_when", 'm'),
                                           interval=int(config["log"].get("alert_rules_interval", 0)),
                                           backupCount=int(config["log"].get("alert_rules_backupCount", 5)))
    else:  # by size
        handler = RotatingFileHandler(config["log"].get("alert_rules_path", "rules_alert.log"),
                                      maxBytes=int(config["log"].get("alert_rules_maxBytes", 1024 * 1024 * 128)),
                                      backupCount=int(config["log"].get("alert_rules_backupCount", 5)))

    if int(config["log"].get("debug_level", 0)) == 1:
        logger.setLevel(logging.DEBUG)
    else:
        logger.setLevel(logging.INFO)
    formatstr = '%(asctime)s - %(name)s - %(levelname)s - %(message)s'
    formatstr = '%(asctime)s: %(levelname)s:  %(message)s'
    formatter = logging.Formatter(formatstr)
    handler.setFormatter(formatter)
    logger.addHandler(handler)

    # Create DB Handles
    postgr = {'host': config["POSTGRES"]["hostaddr"], 'port': int(config["POSTGRES"]["port"]),
              "dbname": config["POSTGRES"]["dbname"], "user": config["POSTGRES"]["user"],
              "pass": config["POSTGRES"]["password"]}
    log_file = ""
    error_log = ""
    pg, pg_cur = connect_to_postgresql(log_file, error_log, postgr['host'], postgr['port'], postgr['dbname'],
                                       postgr['user'], postgr['pass'])
    killer = GracefulKiller()
    ms_cur = ""

    print("version  from 19-01-2017- 14:48")
    while True:
        # print ("New loop")
        log_info = "Nl"
        # logger.debug(log_info)
        # logger.info(log_info)
        unblock_rule(pg_cur, ms_cur, config, log_file, error_log)
        alert_rule(pg_cur, ms_cur, config, log_file, error_log)
        print("version  from 29-12-2016 - 11:48")
        for dummy in range(10):
            if killer.kill_now:
                logger.info("TERM SIG! EXITING NOW ")
                try:
                    pidfile.break_lock()
                except:
                    logger.info("Error in Breaking Pid ")
                print("version  from 19-01-2017- 14:48")
                return
            time.sleep(6)

    pg.close()
    ms.close()


def make_sub_process(error_file, main_log, command_file, config):
    logger.setLevel(logging.DEBUG)
    fh = logging.FileHandler(logf)
    fh.setLevel(logging.DEBUG)
    # formatstr = '%(asctime)s - %(name)s - %(levelname)s - %(message)s'
    formatstr = '%(asctime)s: %(levelname)s:  %(message)s'
    formatter = logging.Formatter(formatstr)
    fh.setFormatter(formatter)
    logger.addHandler(fh)

    ##log_to_file(main_log,"THREAD START")
    ##log_to_file(main_log,config["POSTGRES"]["hostaddr"])
    postgr = {'host': config["POSTGRES"]["hostaddr"], 'port': int(config["POSTGRES"]["port"]),
              "dbname": config["POSTGRES"]["dbname"], "user": config["POSTGRES"]["user"],
              "pass": config["POSTGRES"]["password"]}

    try:
        pg, pg_cur = connect_to_postgresql(main_log, error_file, postgr['host'], postgr['port'], postgr['dbname'],
                                           postgr['user'], postgr['pass'])
    except Exception as e:
        return 1

    while True:
        # log_to_file(main_log,"In Main Loop")

        try:
            print("version  from 06-02-2017 - 18:08")
            alert_rule(pg_cur, ms_cur, config, main_log, error_file)
            print("version  from 06-02-2017 - 18:08")
        except Exception as e:
            traceback.print_tb(e.__traceback__)
            return 1

        time.sleep(60)

    return 0


if __name__ == '__main__':
    main()
