# coding: utf-8

"""
    DNL API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 1.2.35
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import os
import sys
import unittest

import cli_dnl
from cli_dnl.rest import ApiException
from cli_dnl.apis.route_api import RouteApi
from . settings import *
def route_block_data():
    ingr = rand_trunk(direction='ingress', per_page=100)[0]
    egr = rand_trunk(direction='egress', per_page=100)[0]
    ingc = rand_client(ingress_count_gt=0, per_page=100)[0]
    egc = rand_client(egress_count_gt=0, per_page=100)[0]
    ingg = rand_trunk_group(trunk_type='ingress')[0]
    egg = rand_trunk_group(trunk_type='egress')[0]
    tpr = rand_time_profile()[0]
    data={'DNIS_max': random.randint(0,63), 'ANI_empty': get_rand('bool'), 'egress_trunk_id': egr,
        'ANI_max': random.randint(0,63), 'ANI_prefix': dig(10), 'time_profile_id': tpr,
        'DNIS_min': random.randint(0,63), 'DNIS_prefix': dig(10), 'ingress_group_id': ingg,
        'egress_group_id': egg, 'ingress_client_id': ingc, 'egress_client_id': egc,
        'ingress_trunk_id': ingr, 'ANI_min': random.randint(0,63),
        'block_type': random.choice(['specific group','specific trunk','specific carrier'])}
    data['ANI_max']=data['ANI_min']+random.randint(0,63)
    if data['ANI_max'] > 64:
        data['ANI_max']=64
    data['DNIS_max'] = data['DNIS_min'] + random.randint(0, 63)
    if data['DNIS_max'] > 64:
        data['DNIS_max']=64
    return data

def route_block_data_names():
    ingr = rand_trunk(direction='ingress', per_page=100)[1].trunk_name
    egr = rand_trunk(direction='egress', per_page=100)[1].trunk_name
    ingc = rand_client(ingress_count_gt=0, per_page=100)[1].name
    egc = rand_client(egress_count_gt=0, per_page=100)[1].name
    ingg = rand_trunk_group(trunk_type='ingress')[1].group_name
    egg = rand_trunk_group(trunk_type='egress')[1].group_name
    tpr = rand_time_profile()[1].name
    data={'DNIS_max': random.randint(0,63), 'ANI_empty': get_rand('bool'), 'egress_trunk_name': egr,
        'ANI_max': random.randint(0,63), 'ANI_prefix': dig(10), 'time_profile_name': tpr,
        'DNIS_min': random.randint(0,63), 'DNIS_prefix': dig(10), 'ingress_group_name': ingg,
        'egress_group_name': egg, 'ingress_client_name': ingc, 'egress_client_name': egc,
        'ingress_trunk_name': ingr, 'ANI_min': random.randint(0,63),
        'block_type': random.choice(['specific group','specific trunk','specific carrier'])}
    data['ANI_max']=data['ANI_min']+random.randint(0,63)
    if data['ANI_max'] > 64:
        data['ANI_max']=64
    data['DNIS_max'] = data['DNIS_min'] + random.randint(0, 63)
    if data['DNIS_max'] > 64:
        data['DNIS_max']=64
    return data


class TestRouteApi(unittest.TestCase):
    """ RouteApi unit test stubs """

    def setUp(self):
        self.api = cli_dnl.apis.route_api.RouteApi()
        auth()

    def tearDown(self):
        pass

    def test_route_all_delete(self):
        """
        Test case for route_all_delete


        """
        pass

    def test_route_block_all_delete(self):
        """
        Test case for route_block_all_delete


        """
        pass

    def test_route_block_list_get(self):
        """
        Test case for route_block_list_get

        
        """
        o=['block_type','ingress_trunk_id', 'egress_trunk_id','ingress_group_id', 'egress_group_id',
                         'ingress_client_id', 'egress_client_id','time_profile_name',
                         'ANI_prefix', 'DNIS_prefix', 'block_by','update_by',
                         'ANI_min', 'ANI_max', 'DNIS_min', 'DNIS_max','create_time',
                        'ingress_trunk_name', 'egress_trunk_name', 'ingress_group_name', 'egress_group_name',
                         'ingress_client_name', 'egress_client_name',]
        for ord in o:
            for dir in ['asc','desc']:
                ret = self.api.route_block_list_get(order_by=ord,per_page=3)
                assert(ret.success)

        pass

    def test_route_block_post_names(self):
        auth()
        data = route_block_data_names()
        print(json.dumps(data))
        ret = self.api.route_block_post(body=data)
        print(ret)
        assert (ret.success)

    def test_route_block_post(self):
        """
        Test case for route_block_post

        
        """

        auth()
        data=route_block_data()
        print(data)
        ret=self.api.route_block_post(body=data)
        assert(ret.success)
        print(ret)
        ret1 = self.api.route_block_res_block_id_get(res_block_id=ret.object_id)
        assert (ret1.success)
        print(ret1)
        assert (ret1.payload.update_by == 'admin')
        data['DNIS_max']=100
        try:
            ret = self.api.route_block_post(body=data)
            assert(not ret.success)
        except Exception as e:
            assert ('between' in str(e))
            pass
        data['DNIS_max'] = 1
        data['DNIS_min'] = 32
        try:
            ret = self.api.route_block_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert ('invalid' in str(e))
            pass

        return ret
        pass

    def test_route_block_res_block_id_delete(self):
        """
        Test case for route_block_res_block_id_delete

        
        """
        ret0=self.test_route_block_post()
        ret=self.api.route_block_res_block_id_delete(res_block_id=ret0.object_id)
        assert (ret.success)
        pass

    def test_route_block_res_block_id_get(self):
        """
        Test case for route_block_res_block_id_get

        
        """
        ret0 = self.test_route_block_post()
        ret = self.api.route_block_res_block_id_get(res_block_id=ret0.object_id)
        assert (ret.success)
        pass

    def test_route_block_res_block_id_patch(self):
        """
        Test case for route_block_res_block_id_patch


        """
        ret=self.api.route_block_list_get()
        assert (ret.success and len(ret.payload.items))
        it = random.choice(ret.payload.items)
        data=route_block_data()
        ret=self.api.route_block_res_block_id_patch(res_block_id=it.res_block_id,body=data)
        assert(ret.success)
        assert(ret.payload.update_by=='admin')
        data['DNIS_max'] = 1
        data['DNIS_min'] = 32
        try:
            ret = self.api.route_block_res_block_id_patch(res_block_id=it.res_block_id, body=data)
            assert (not ret.success)
        except Exception as e:
            assert('invalid' in str(e))
        pass

    def test_route_digit_map_all_delete(self):
        """
        Test case for route_digit_map_all_delete


        """
        pass

    def test_route_digit_map_item_all_delete(self):
        """
        Test case for route_digit_map_item_all_delete


        """
        pass

    def test_route_digit_map_item_ref_id_delete(self):
        """
        Test case for route_digit_map_item_ref_id_delete

        
        """
        pass

    def test_route_digit_map_item_ref_id_get(self):
        """
        Test case for route_digit_map_item_ref_id_get

        
        """
        pass

    def test_route_digit_map_item_ref_id_patch(self):
        """
        Test case for route_digit_map_item_ref_id_patch

        
        """
        pass

    def test_route_digit_map_list_get(self):
        """
        Test case for route_digit_map_list_get

        
        """
        pass

    def test_route_digit_map_post(self):
        """
        Test case for route_digit_map_post

        
        """
        pass

    def test_route_digit_map_translation_id_delete(self):
        """
        Test case for route_digit_map_translation_id_delete

        
        """
        pass

    def test_route_digit_map_translation_id_get(self):
        """
        Test case for route_digit_map_translation_id_get

        
        """
        auth()
        order=['digit_map_name', 'ANI_replace_to', 'DNIS_replace_to', 'ANI_prefix', 'DNIS_prefix']

        for o in order:
            ret = self.api.route_digit_map_list_get()
            tr = random.choice(ret.payload.items)
            print (tr.translation_id)
            dir = random.choice(['asc', 'desc'])
            ret=self.api.route_digit_map_translation_id_item_list_get(translation_id=tr.translation_id,
                                                                      order_by=o,order_dir=dir)
            assert(ret.success)
            for item in ret.payload.items:
                assert(item.digit_map_name==tr.digit_map_name)

        pass

    def test_route_digit_map_translation_id_item_list_get(self):
        """
        Test case for route_digit_map_translation_id_item_list_get

        
        """
        pass

    def test_route_digit_map_translation_id_item_post(self):
        """
        Test case for route_digit_map_translation_id_item_post

        
        """
        pass

    def test_route_digit_map_translation_id_patch(self):
        """
        Test case for route_digit_map_translation_id_patch

        
        """
        pass

    def test_route_dynamic_all_delete(self):
        """
        Test case for route_dynamic_all_delete


        """
        pass

    def test_route_dynamic_all_patch(self):
        """
        Test case for route_dynamic_all_patch


        """
        pass

    def test_route_dynamic_dynamic_route_id_add_trunk_post(self):
        """
        Test case for route_dynamic_dynamic_route_id_add_trunk_post

        
        """
        id,tr,xls=rand_dynamic_route()
        ls = rand_trunk(direction='egress')[2]
        random.shuffle(ls)
        i=0
        for t in ls:
            if t.trunk_id not in [t1.trunk.trunk_id for t1 in tr.egress_trunks]:
                tr1 = t.trunk_id
                break

        data={'trunks':[tr1]}
        ret = self.api.route_dynamic_dynamic_route_id_add_trunks_post(dynamic_route_id=id,
                                                                      body=data)
        assert(ret.success)
        pass

    def test_route_dynamic_dynamic_route_id_add_trunks_post(self):
        """
        Test case for route_dynamic_dynamic_route_id_add_trunks_post

        
        """
        pass

    def test_route_dynamic_dynamic_route_id_delete(self):
        """
        Test case for route_dynamic_dynamic_route_id_delete

        
        """
        r=self.test_route_dynamic_post()
        ret=self.api.route_dynamic_dynamic_route_id_delete(dynamic_route_id=r.object_id)
        assert (ret.success)
        pass

    def test_route_dynamic_dynamic_route_id_get(self):
        """
        Test case for route_dynamic_dynamic_route_id_get

        
        """
        ret=self.api.route_dynamic_dynamic_route_id_get(dynamic_route_id=rand_dynamic_route()[0])
        assert(ret.success)
        pass

    def test_route_dynamic_dynamic_route_id_override_create_post(self):
        """
        Test case for route_dynamic_dynamic_route_id_override_create_post


        """
        id = rand_dynamic_route()[0]
        data={'digits':dig(10),
              'resource_id':rand_trunk()[0],
              'percentage':random.random()*100}
        ret= self.api.route_dynamic_dynamic_route_id_override_create_post(dynamic_route_id=id , body=data)
        assert (ret.success)
        pass

    def test_route_dynamic_dynamic_route_id_override_list_get(self):
        """
        Test case for route_dynamic_dynamic_route_id_override_list_get


        """
        id = rand_dynamic_route()[0]
        for i in range(0,3):
            data = {'digits': dig(10),
                'resource_id': rand_trunk()[0],
                'percentage': random.random() * 100}
            ret = self.api.route_dynamic_dynamic_route_id_override_create_post(dynamic_route_id=id, body=data)
            assert (ret.success)
        o = ['id','digits','resource_id','percentage','resource_name']
        for ord in o:
            for dir in ['asc', 'desc']:
                ret=self.api.route_dynamic_dynamic_route_id_override_list_get(dynamic_route_id=id,order_by=ord,order_dir=dir)
                assert(ret.success)
        pass

    def test_route_dynamic_dynamic_route_id_patch_trunks(self):
        tru = cli_dnl.TrunkApi().trunk_list_get(direction='egress', per_page=100)
        random.shuffle(tru.payload.items)
        trunks = []
        for i in range(0, min(4, len(tru.payload.items))):
            trunks.append({'resource_id': tru.payload.items[i].trunk_id})
            trunks.append({'resource_id': tru.payload.items[i].trunk_id})
        id=rand_dynamic_route()[0]
        data = {
            'name': bla(),
            'route_rule_name': random.choice(['LCR', 'By ASR', 'By ACD', 'by maximum ASR', 'by maximum ACD']),
            'egress_trunks': trunks,
            'time_profile_id': rand_time_profile()[0]
        }
        print(json.dumps(data))
        ret=self.api.route_dynamic_dynamic_route_id_patch(dynamic_route_id=id, body=data)
        assert (ret.success)
        print(ret)
        ret = self.api.route_dynamic_dynamic_route_id_patch(dynamic_route_id=id, body=data)
        assert (ret.success)
        print(ret)


    def test_route_dynamic_dynamic_route_id_patch(self):
        """
        Test case for route_dynamic_dynamic_route_id_patch

        
        """
        auth()
        prof = cli_dnl.ConfigApi().config_time_profile_list_get()
        assert (prof.success)
        tpr = random.choice(prof.payload.items)


        tru=cli_dnl.TrunkApi().trunk_list_get(direction='egress',per_page=100)
        random.shuffle(tru.payload.items)
        trunks=[]
        for i in range(0,min(4,len(tru.payload.items))):
            trunks.append({'resource_id': tru.payload.items[i].trunk_id})
            trunks.append({'resource_id': tru.payload.items[i].trunk_id})

        data= {
            'name': bla(),
            'route_rule_name': random.choice(['LCR', 'By ASR',  'By ACD','by maximum ASR','by maximum ACD']),
            'egress_trunks': trunks,
            'time_profile_id': tpr.time_profile_id
        }
        if data['route_rule_name']!='LCR':
            data['qos_cycle'] = random.choice(['15 minutes','30 minutes', '1 hours',  '1 days'])
        dyn=self.api.route_dynamic_post(body=data)
        assert(dyn.success)
        print(dyn)
        if data['route_rule_name'] != 'LCR':
            data['route_rule_name']=random.choice(['LCR', 'By ASR',  'By ACD','by maximum ASR','by maximum ACD'])
        dyn2=self.api.route_dynamic_dynamic_route_id_patch(dynamic_route_id=dyn.object_id,body=data)
        print(dyn2)
        assert (dyn2.success and dyn2.payload.dynamic_route_id==dyn.object_id)
        assert (len(dyn2.payload.egress_trunks)==len(data['egress_trunks']) )

        pass

    def test_route_dynamic_dynamic_route_id_pri_create_post(self):
        """
        Test case for route_dynamic_dynamic_route_id_pri_create_post

        
        """

        pass

    def test_route_dynamic_dynamic_route_id_pri_list_get(self):
        """
        Test case for route_dynamic_dynamic_route_id_pri_list_get

        
        """
        id = rand_dynamic_route()[0]
        o = ['digits', 'resource_pri', 'resource_id' , 'id','trunk_name']
        for ord in o:
            for dir in ['asc', 'desc']:
                ret = self.api.route_dynamic_dynamic_route_id_pri_list_get(dynamic_route_id=id, order_by=ord,
                                                                           order_dir=dir)
                assert (ret.success)

        pass

    def test_route_dynamic_dynamic_route_id_qos_create_post(self):
        """
        Test case for route_dynamic_dynamic_route_id_qos_create_post

        
        """
        id = rand_dynamic_route()[0]
        for i in range(0, 4):
            acd = random.randint(0,100)
            pdd = random.randint(0, 100)
            abr = random.randint(0, 100)
            asr = random.randint(0, 100)
            aloc = random.randint(0, 100)
            data={
                'min_acd': acd,
                'max_acd': acd+random.randint(0, 100),
                'max_pdd': pdd+random.randint(0,100),
                'max_asr': asr-random.randint(0,100),

                'max_aloc': aloc+random.randint(0,100),
                'max_abr': abr+random.randint(0,100),
                'min_pdd': pdd,
                'limit_price': random.randint(0,100)*random.random(),
                'min_abr': abr,
                'min_aloc': aloc,
                'digits': dig(10),
                'min_asr': asr
            }
            ret=self.api.route_dynamic_dynamic_route_id_qos_create_post(dynamic_route_id=id,body=data)
            assert (ret.success)
        pass

    def test_route_dynamic_dynamic_route_id_qos_list_get(self):
        """
        Test case for route_dynamic_dynamic_route_id_qos_list_get

        
        """
        id = rand_dynamic_route()[0]
        o = ['digits', 'min_asr','max_asr','min_acd', 'max_acd','min_pdd','min_aloc', 'limit_price']
        for ord in o:
            for dir in ['asc', 'desc']:
                ret = self.api.route_dynamic_dynamic_route_id_qos_list_get(dynamic_route_id=id, order_by=ord,
                                                                          order_dir=dir)
                assert (ret.success)

        pass

    def test_route_dynamic_dynamic_route_id_remove_trunks_patch(self):
        """
        Test case for route_dynamic_dynamic_route_id_remove_trunks_patch


        """
        ls=rand_dynamic_route()[2]
        random.shuffle(ls)
        for it in ls:
            if len(it.egress_trunks)==1:
                data={'trunks':[it.egress_trunks[0].trunk.resource_id]}
                print(it)
                print(data)
                return
                ret=self.api.route_dynamic_dynamic_route_id_remove_trunks_patch(dynamic_route_id=it.dynamic_route_id,body=data)
                assert(ret.success)
                new=self.api.route_dynamic_dynamic_route_id_get(dynamic_route_id=it.dynamic_route_id).payload
                assert(len(it.egress_trunks)==len(new.egress_trunks)+1)
                print(new)
                ret = self.api.route_dynamic_dynamic_route_id_add_trunks_post(dynamic_route_id=it.dynamic_route_id,
                                                                                  body=data)
                assert (ret.success)
                print(self.api.route_dynamic_dynamic_route_id_get(dynamic_route_id=it.dynamic_route_id))
                break
        pass

    def test_route_dynamic_list_get(self):
        """
        Test case for route_dynamic_list_get

        
        """

        o = ['name','route_rule_name','qos_cycle','time_profile_id','time_profile_name','modified_by','usage_count','egress_trunk_id']
        for ord in o:
            for dir in ['asc', 'desc']:
                ret = self.api.route_dynamic_list_get(order_by=ord, order_dir=dir)
                assert (ret.success)

        ret=self.test_route_dynamic_post()
        ret1=self.api.route_dynamic_dynamic_route_id_get(dynamic_route_id=ret.object_id)
        egress_trunk_id=ret1.payload.egress_trunks[0].resource_id
        print(egress_trunk_id)
        ret2=self.api.route_dynamic_list_get(egress_trunk_id=egress_trunk_id)
        assert(ret2.success and len(ret2.payload.items))
        found=0
        for r in ret2.payload.items:
            for tr in r.egress_trunks:
                if tr.resource_id == egress_trunk_id:
                    found=found+1
        assert(found and found==len(ret2.payload.items))

        pass

    def test_route_dynamic_override_id_delete(self):
        """
        Test case for route_dynamic_override_id_delete


        """
        pass

    def test_route_dynamic_override_id_get(self):
        """
        Test case for route_dynamic_override_id_get


        """
        pass

    def test_route_dynamic_override_id_patch(self):
        """
        Test case for route_dynamic_override_id_patch


        """
        pass

    def test_route_dynamic_post(self):
        """
        Test case for route_dynamic_post

        
        """
        ls=rand_trunk(direction='egress')[2]
        random.shuffle(ls)

        data={
            'time_profile_id': rand_time_profile()[0],
            'egress_trunks': [{'resource_id': ls[0].trunk_id},
                              {'resource_id': ls[1].trunk_id},
                              {'resource_id': ls[2].trunk_id},
                              ],
            'route_rule_name': random.choice(['LCR','By ASR', 'By ACD', 'by maximum ASR', 'by maximum ACD','By LCR']),
            'name': 'dynamic_route_'+bla(8),
            'qos_cycle':random.choice(['not set','15 minutes','30 minutes', '1 hours', '1 days'])
        }
        data['route_rule_name']='LCR'
        data['qos_cycle']=random.choice(['15 minutes','30 minutes', '1 hours', '1 days'])
        try:
            ret = self.api.route_dynamic_post(body=data)
            assert(not ret.success)
        except Exception as e:
            assert('Do not set qos_cycle' in str(e))
        data['route_rule_name'] = random.choice(
            ['By ASR', 'By ACD', 'by maximum ASR', 'by maximum ACD', 'By LCR'])
        data['qos_cycle'] = random.choice(['not set', '15 minutes', '30 minutes', '1 hours', '1 days'])

        ret = self.api.route_dynamic_post(body=data)
        assert(ret.success)
        return ret
        pass

    def test_route_dynamic_pri_id_delete(self):
        """
        Test case for route_dynamic_pri_id_delete

        
        """
        pass

    def test_route_dynamic_pri_id_get(self):
        """
        Test case for route_dynamic_pri_id_get

        
        """
        pass

    def test_route_dynamic_pri_id_patch(self):
        """
        Test case for route_dynamic_pri_id_patch

        
        """
        pass

    def test_route_dynamic_qos_id_delete(self):
        """
        Test case for route_dynamic_qos_id_delete

        
        """
        pass

    def test_route_dynamic_qos_id_get(self):
        """
        Test case for route_dynamic_qos_id_get

        
        """
        pass

    def test_route_dynamic_qos_id_patch(self):
        """
        Test case for route_dynamic_qos_id_patch

        
        """
        pass

    def test_route_dynamic_qos_list_get(self):
        """
        Test case for route_dynamic_qos_list_get


        """
        pass

    def test_route_list_get(self):
        """
        Test case for route_list_get

        
        """
        pass

    def test_route_plan_all_delete(self):
        """
        Test case for route_plan_all_delete


        """
        pass

    def test_route_plan_extended_post(self):
        """
        Test case for route_plan_extended_post


        """
        auth()
        tr=rand_trunk()[0]
        data=dict(name='route ex'+dig(7),type=random.choice(['LCR', 'Top-Down', 'Round-Robin']),
                  egress_trunks=[tr])
        ret=self.api.route_plan_extended_post(body=data)
        assert(ret.success)

        pass

    def test_route_plan_list_get(self):
        """
        Test case for route_plan_list_get

        
        """
        pass

    def test_route_plan_post(self):
        """
        Test case for route_plan_post

        
        """
        pass

    def test_route_plan_route_plan_id_add_route_post(self):
        """
        Test case for route_plan_route_plan_id_add_route_post

        
        """
        id=135
        data = {
            'ANI_prefix': dig(6),
            'ANI_min': random.randint(0, 32),
            'static_route_id': rand_static_route()[0],
            'ANI_max': random.randint(32, 64),
            'DNIS_min': random.randint(0, 32),
            'route_type_flg': 'dynamic routing',#random.choice(['Dynamic Routing', 'Static Routing', 'Static Routing JD', 'Dynamic Routing - Static Routing', 'Dynamic Routing - Static Routing JD', 'Static Routing - Dynamic routing', 'Static Routing JD - Dynamic routing']),
            'DNIS_max': random.randint(32, 64),
            'DNIS_prefix': dig(13),
            'dynamic_route_id': rand_dynamic_route()[0]
        }
        ret = self.api.route_plan_route_plan_id_add_route_post(route_plan_id=id, body=data)
        assert (ret.success)
        print(ret)
        return

        id=rand_route_plan()[0]
        data={
            'ANI_prefix': dig(13),
            'ANI_min': random.randint(0,32),
            'static_route_id': rand_static_route()[0],
            'ANI_max': random.randint(32,64),
            'DNIS_min': random.randint(0,32),
            'route_type_flg': random.choice([ 'Dynamic Routing', 'Static Routing', 'Static Routing JD',
         'Dynamic Routing - Static Routing', 'Dynamic Routing - Static Routing JD',
         'Static Routing - Dynamic routing', 'Static Routing JD - Dynamic routing']),
            'DNIS_max': random.randint(32,64),
            'DNIS_prefix': dig(13),
            'dynamic_route_id': rand_dynamic_route()[0]
        }
        #if data['ANI_min']>data['ANI_max']:
        #    data['ANI_min']=0

        if 'JD' in data['route_type_flg']:

            data['inter_static_route_id']= rand_static_route()[0]
            data['intra_static_route_id'] = rand_static_route()[0]
        ret=self.api.route_plan_route_plan_id_add_route_post(route_plan_id=id,body=data)
        assert(ret.success)
        print(ret)
        pass

    def test_route_plan_route_plan_id_delete(self):
        """
        Test case for route_plan_route_plan_id_delete

        
        """
        pass

    def test_route_plan_route_plan_id_get(self):
        """
        Test case for route_plan_route_plan_id_get

        
        """
        pass

    def test_route_plan_route_plan_id_list_routes_get(self):
        """
        Test case for route_plan_route_plan_id_list_routes_get

        
        """
        pass

    def test_route_plan_route_plan_id_patch(self):
        """
        Test case for route_plan_route_plan_id_patch

        
        """
        pass

    def test_route_route_id_delete(self):
        """
        Test case for route_route_id_delete

        
        """
        pass

    def test_route_route_id_get(self):
        """
        Test case for route_route_id_get

        
        """
        pass

    def test_route_route_id_patch(self):
        """
        Test case for route_route_id_patch

        
        """
        pass

    def test_route_static_all_delete(self):
        """
        Test case for route_static_all_delete


        """
        pass

    def test_route_static_create_post(self):
        """
        Test case for route_static_create_post

        
        """
        data ={
  'routed_by': random.choice(['LRN','DNIS','None']),

  'defined_by': random.choice(['Code', 'Code Name', 'Country']),
  'name': 'static_route_'+bla(8)
}
        if data['defined_by'] == 'Code Name':
            data['code_deck_id']= rand_code_deck()[0]
        print('POST/route/static/create ',data)
        ret0=self.api.route_static_create_post(body=data)
        assert(ret0.success)
        print(ret0)



        try:
            ret1 = self.api.route_static_create_post(body=data)
            assert (not ret1.success)
        except Exception as e:
            assert ('already' in str(e))
        try:
            data = {
                'routed_by': random.choice(['LRN', 'DNIS', 'None']),
                'defined_by': 'Code Name',
                'name': 'static_route_' + bla(8)
            }
            ret = self.api.route_static_create_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert('must present' in str(e))
        try:
            data = {
                'routed_by': random.choice(['LRN', 'DNIS', 'None']),
                'defined_by': random.choice([ 'Code', 'Country']),
                'code_deck_id': rand_code_deck()[0],
                'name': 'static_route_' + bla(8)
            }
            ret = self.api.route_static_create_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert('not needed' in str(e))

        return ret0

        pass

    def test_route_static_item_all_delete(self):
        """
        Test case for route_static_item_all_delete


        """
        pass

    def test_route_static_item_item_id_delete(self):
        """
        Test case for route_static_item_item_id_delete

        
        """
        pass

    def test_route_static_item_item_id_get(self):
        """
        Test case for route_static_item_item_id_get

        
        """
        pass

    def test_route_static_item_item_id_patch(self):
        """
        Test case for route_static_item_item_id_patch

        
        """
        pass

    def test_route_static_items_list_get(self):
        """
        Test case for route_static_items_list_get


        """
        pass

    def test_route_static_list_get(self):
        """
        Test case for route_static_list_get

        
        """
        id=rand_static_route()[0]
        pass

    def test_route_static_static_route_id_delete(self):
        """
        Test case for route_static_static_route_id_delete

        
        """
        new=self.test_route_static_create_post()
        id = new.object_id
        ret = self.api.route_static_static_route_id_get(static_route_id=id)
        assert (ret.success)
        pass

    def test_route_static_static_route_id_get(self):
        """
        Test case for route_static_static_route_id_get

        
        """
        id = rand_static_route()[0]
        ret = self.api.route_static_static_route_id_get(static_route_id=id)
        assert (ret.success)
        pass

    def test_route_static_static_route_id_item_create_post(self):
        """
        Test case for route_static_static_route_id_item_create_post

        
        """
        id = rand_static_route()[0]
        data = {
            'alias': 'static_roite_item_' + dig(8),
            'strategy': random.choice(['Top-Down', 'Round-Robin']),
            'trunks': [{'trunk_id': rand_trunk(direction='ingress')[0],'by_percentage':None}]
        }
        print('POST/route/static/{}/item/create'.format(id), data)
        ret = self.api.route_static_static_route_id_item_create_post(static_route_id=id, body=data)
        assert (ret.success)
        print(ret)

        id=rand_static_route()[0]
        data = {
            'alias': 'static_roite_item_'+dig(8),
            'strategy':'By Percentage',
            'trunks': [{'trunk_id':rand_trunk(direction='ingress')[0],
             'by_percentage':100
             }]
}
        print('POST/route/static/{}/item/create'.format(id),data)
        ret=self.api.route_static_static_route_id_item_create_post(static_route_id=id,body=data)
        assert(ret.success)
        print(ret)

        id = rand_static_route()[0]
        data = {
            'alias': 'static_roite_item_' + dig(8),
            'strategy': 'By Percentage',

        }
        print('POST/route/static/{}/item/create'.format(id), data)
        try:
            ret = self.api.route_static_static_route_id_item_create_post(static_route_id=id, body=data)
            assert (not ret.success)
        except Exception as e:
            assert ('required' in str(e))
        print(ret)

        
        pass

    def test_route_static_static_route_id_item_list_get(self):
        """
        Test case for route_static_static_route_id_item_list_get

        
        """
        id = rand_static_route()[0]
        o = ['item_id','static_route_id','static_route_name', 'did','strategy','time_profile_name','update_by','alias','code_name','update_at']
        for ord in o:
            for dir in ['asc', 'desc']:
                ret = self.api.route_static_static_route_id_item_list_get(static_route_id=id, order_by=ord,
                                                                                order_dir=dir)
                assert (ret.success)
        pass

    def test_route_static_static_route_id_patch(self):
        """
        Test case for route_static_static_route_id_patch

        
        """
        data = {
            'routed_by': random.choice(['LRN', 'DNIS']),
            'code_deck_id': rand_code_deck()[0],
            'defined_by': random.choice(['Code', 'Code Name', 'Country']),
            'name': 'static_route_' + bla(8)
        }
        id=rand_static_route()[0]
        ret = self.api.route_static_static_route_id_patch(static_route_id=id,body=data)
        assert (ret.success)
        r = rand_static_route()[1]
        data['name']=r.name
        try:
            ret = self.api.route_static_static_route_id_patch(static_route_id=id,body=data)
            assert (not ret.success)
        except Exception as e:
            assert ('invalid' in str(e))
        pass


if __name__ == '__main__':
    unittest.main()
