import celery
from api_dnl import settings
from datetime import datetime, timedelta
from dateutil.parser import parse as parse_datetime
from pytz import UTC
from time import mktime
import io, csv, gzip, zipfile
import xlwt, xlrd
import re
import json
from email.utils import parseaddr
from email.header import decode_header
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select, alias, case
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import Client, Client, Resource, Rate, RateTable, RateUploadTask, RateUploadValues, RateSendLog, \
    BalanceHistoryActual, C4ClientBalance, \
    RateSendLogDetail, CrdReportDetailTable, MailSender, FraudDetection, FraudDetectionLog, FraudDetectionLogDetail, \
    ResourceBlock, IngressTrunk, SystemParameter, AlertRule, AlertRuleLog, AlertRulesLogDetail, CdrReportDetail, \
    client_cdr, \
    RateAutoImportRule, RateAutoImportRuleLog,RateAutoImportMailboxLog
from api_dnl.model import PrimaryKeyConstraint, func, query_to_sting, cast, generate_uuid_str
from api_dnl.tasks import app, log, db, SqlAlchemyTask, SchLog
from api_dnl import model
from api_dnl.utils.statisticapi2 import StatisticAPI
from api_dnl.scheme import RateScheme, BaseModelScheme
from api_dnl.utils.imp_exp import (csv2xls, dict_to_csv)
import api_dnl.task.auto_rate_helper as helper

UPLOAD_TO = None


@app.task(base=SqlAlchemyTask)
def do_auto_rate():
    global UPLOAD_TO
    if not settings.AUTO_RATE_ENABLED:
        log.debug('Auto rate disabled')
        return
    UPLOAD_TO = settings.FILES['upload_to'] + '/'
    log.debug('Auto rate started')


    slog = SchLog('auto_rate')
    try:
        status, email_list = check_mail()
        log.debug('Auto rate email status {}'.format(status))
    except Exception as e:
        print(" Exception in check mail:  %s" % (str(e)))
        log.error(" Exception in check mail:  %s" % (str(e)))

    try:
        email_rule_list = email_rule_list_creator(email_list, True)
        for rule in email_rule_list:
            status_dict_default = dict()  # defaultdict(lambda: 0)
            status_dict_default['effective_date'] = 0
            status_dict_default['num_fail'] = 0
            rule.append(status_dict_default)
    except Exception as e:
        print(" Exception in email rule creation:  %s" % (str(e)))
        log.error(" Exception in email rule creation:  %s" % (str(e)))
        # PIDFile.break_lock()
        return -1

    if False:
        try:
            list_rules_email_extracted_info = extract_rate_file_info(email_rule_list)
        except Exception as e:
            print(" Exception in extract_rate_file_info:  %s" % (str(e)))
            log.error(" Exception in extract_rate_file_info:  %s" % (str(e)))
            # PIDFile.break_lock()
            return -1

    # print ("list_rules_email_extracted_info len",len (list_rules_email_extracted_info))

    for item in email_rule_list:
        print(json.dumps(item[0]), item[1])
        print('Auto rate rule {}'.format(item[0]['filename'][0]))
        log.debug('Auto rate rule {}'.format(item[0]['filename']))
        rule = item[1]['rule']
        rule_log = item[1]['rule_log']
        info = rule.info
        effective_date = None
        try:
            if rule.read_effective_date_from == 'subject':
                effective_date = ExtractEffectiveDateFromSubject(item)
            elif rule.read_effective_date_from == 'content':
                effective_date = ExtractEffectiveDateFromContent(item)
            elif rule.read_effective_date_from == 'today':
                effective_date = str(datetime.now(UTC).date())
            elif rule.read_effective_date_from == 'file':
                if 'Effective_date' not in info['fields']:
                    rule_log.error = 'cannot find effective date'
                    rule_log.status = 'upload error'
                    rule_log.save()
                    continue
            if effective_date and str(effective_date) != '-1':
                info['effective_date_default'] = effective_date
            if not rule.egress_trunk.rate_table_id:
                rule.egress_trunk.rate_table_id=model.RateTable(name=rule.egress_trunk.alias,code_deck_id=rule.rate_table_code_deck_id).save()
                rule.egress_trunk.save()
            now = datetime.now(UTC)
            all_rate_end_date = datetime(now.year, 12, 31, 23, 59, 59)
            oid = RateUploadTask(upload_orig_file=item[0]['filename'][0].strip(), upload_file_path=UPLOAD_TO,
                                 rate_table_id=rule.egress_trunk.rate_table_id, info=info,
                                 rate_date_format=rule.rate_date_format,
                                 rate_table_code_deck_id=rule.rate_table_code_deck_id,
                                 all_rate_end_date=all_rate_end_date,
                                 # reduplicate_rate_action=rule.reduplicate_rate_action,
                                 code_deck_flag=rule.code_deck_flag, use_ocn_lata_code=rule.use_ocn_lata_code,
                                 rule_log_id=rule_log.id,
                                 status='error').save()
            rule_log.error = 'task id {} started '.format(oid)
            print(rule_log.error)
            rule_log.status = 'task waiting'
            rule_log.save()
            log.debug('Auto rate save rate_upload_task {}'.format(oid))
            from .upload_rate import upload_rate
            upload_rate(oid)
            task = RateUploadTask.get(oid)
            rule_log.status = 'upload success'
            rule_log.save()
        except Exception as e:
            log.debug('Auto rate email not received {}'.format(str(e)))
            rule_log.error = 'unknown error {}'.format(str(e))
            rule_log.status = 'upload error'
            rule_log.save()

    log.debug('Auto rate finished')
    slog.close()


from multiprocessing import Pool

import psycopg2
import psycopg2.extras
import time, re, zipfile
from datetime import datetime, timedelta
# from decimal import *
import configparser, imaplib, email, mimetypes
import logging, os, sys, signal, shutil
from logging.handlers import TimedRotatingFileHandler
from logging.handlers import RotatingFileHandler
from lockfile.pidlockfile import PIDLockFile
from lockfile import AlreadyLocked
import xlrd, requests

# from openpyxl.reader.excel import load_workbook

logger = logging.getLogger('rate send')
from collections import defaultdict
from lxml import html

PIDF = "import_rate_worker.pid"
TAB_INDEX_LIST = ['STANDARD', 'SPECIAL', 'PREMIUM']


def _decode(s):
    _fn = decode_header(s)[0]
    if _fn[1]:
        return _fn[0].decode(_fn[1])
    else:
        return _fn[0]


def connect_to_postgresql(host, port, database, user, password=None):
    try:
        conn = psycopg2.connect(host=host, port=port, database=database, user=user, password=password)
        conn.autocommit = True
        cursor = conn.cursor(cursor_factory=psycopg2.extras.DictCursor)
        print("connected to DB")
    except Exception as e:
        print(" Exception in DB connecting:  %s" % (str(e)))
        raise 'I am unable to connect to the PostgreSQL. %s' % (str(e))
    return conn, cursor


def setup():
    global config
    config = configparser.ConfigParser()
    config.read('config.ini')

    global DEBUG_LEVEL
    DEBUG_LEVEL = int(config["log"]["debug_level"])
    # logger

    if int(config["log"].get('by_time', 0)) == 1:
        handler = TimedRotatingFileHandler(config["log"].get("sent_rate_path", "sent_rate.log"),
                                           when=config["log"].get("sent_rate_when", 'm'),
                                           interval=int(config["log"].get("sent_rate_interval", 0)),
                                           backupCount=int(config["log"].get("sent_rate_backupCount", 5)))
    else:  # by size
        handler = RotatingFileHandler(config["log"].get("sent_rate_path", "sent_rate.log"),
                                      maxBytes=int(config["log"].get("sent_rate_maxBytes", 1024 * 1024 * 128)),
                                      backupCount=int(config["log"].get("sent_rate_backupCount", 5)))

    if int(config["log"].get("debug_level", 0)) == 1:
        log.setLevel(logging.DEBUG)
    else:
        log.setLevel(logging.INFO)
    formatstr = '%(asctime)s - %(name)s - %(levelname)s - %(message)s'
    formatstr = '%(asctime)s: %(levelname)s:  %(message)s'
    formatter = logging.Formatter(formatstr)
    handler.setFormatter(formatter)
    log.addHandler(handler)

    try:
        pg_conn, pg_cur = connect_to_postgresql(config["POSTGRES"]["hostaddr"], int(config["POSTGRES"]["port"]),
                                                config["POSTGRES"]["dbname"], config["POSTGRES"]["user"],
                                                config["POSTGRES"]["password"])  # config["POSTGRES"]["password"]

        return pg_conn, pg_cur, logger, config
    except Exception as e:
        print(" Exception in connect_to_postgresql:  %s" % (str(e)))
        log.error(" Exception in connect_to_postgresql:  %s" % (str(e)))
        return (-1, -1, -1, -1)


def connectEmail():
    """Connects to mail server and returns imanp handler to 'inbox' folder """
    config = SystemParameter.get(1)
    start = datetime.now(UTC)
    try:
        host = config.auto_rate_smtp
        port = config.auto_rate_smtp_port
        user = config.auto_rate_username
        password = config.auto_rate_pwd
        ssl = config.auto_rate_mail_ssl
        if ssl != None:
            ssl = True
        else:
            ssl = False

        if ssl:
            try:
                mail = imaplib.IMAP4_SSL(host)
            except Exception as e:
                RateAutoImportMailboxLog(start=start, finish=datetime.now(UTC), error=str(e),
                                         ).save()
                RateAutoImportMailboxLog(start=start, finish=datetime.now(UTC), error='Retry with tls',
                                         ).save()
                mail = imaplib.IMAP4(host)
                mail.starttls()
        else:
            mail = imaplib.IMAP4(host)

        mail.login(user, password)
        # print("mail list %s" % str(mail.list() ) )
        # log.debug ("mail list %s" % str(mail.list() ) )
        mail.select("inbox")  # connect to inbox.

        return mail

    except Exception as e:
        RateAutoImportMailboxLog(start=start, finish=datetime.now(UTC), error=str(e),
                                 ).save()
        print(" Exception in connection to mail server:  %s" % (str(e)))
        log.error(" Exception in connection to mail server:  %s" % (str(e)))
        return -1


def getIpFromString(text):
    """"Extracts IPver4 valid Ipaddress (only checks for valid octates)"""
    try:
        ip_list = re.findall(
            r'\b25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?\.25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?\.25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?\.25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?\b',
            text)
        ip = ".".join(ip_list[0:4])
    except Exception as e:
        print("Exception is getting IP %s" % e)
        ip = None

    return ip


def clean_attachments(email):
    for filename in email['filename']:
        os.unlink(UPLOAD_TO + filename)


def getAttachment(part):
    """Downloads attachment and returns its name  """
    filename = None
    try:
        filename = _decode(part.get_filename())
        print("filename", filename)
        try:
            date_str = "{}".format(datetime.now().strftime("%B-%d-%Y-%H%M%S"))
        except Exception as e:
            print("Exception in making date_str %s" % e)
            return -1
        if not filename:
            ext = mimetypes.guess_extension(part.get_content_type())
            if not ext:
                # Use a generic bag-of-bits extension
                ext = '.bin'
            try:
                filename = 'part-%s-%s' % (date_str, ext)
            except Exception as e:
                print("Exception in creating filename in get attachment %s" % e)
                return -1
        log.debug('original filename %s',filename)
        uuid = generate_uuid_str()()
        filename = uuid + os.path.splitext(filename)[1]
        log.debug('saved filename %s', filename)
        with open(os.path.join(UPLOAD_TO, filename), 'wb') as fp:
            fp.write(part.get_payload(decode=True))
    except Exception as e:
        log.error('error in get attachment {} : {}'.format(part.get_content_type(), str(e)))

    return filename


def searchMail(mail):
    """ """
    email_list = []
    start = datetime.now(UTC)
    try:
        result, data = mail.uid('search', None, '(UNSEEN)')  # search and return uids instead
        # print ("list",data)
        email_uids_list = data[0].split()
        msg = "Number of unseen messages {}".format(len(email_uids_list))
        print(msg)
        start = datetime.now(UTC)
        RateAutoImportMailboxLog(start=start, finish=datetime.now(UTC), error=msg,
                                 ).save()
        for uid in email_uids_list:
            result, data = mail.uid('fetch', uid, '(RFC822)')
            try:
                raw_email = data[0][1]
            except Exception as e:
                print(e)
                continue
            # print (raw_email)
            email_message = email.message_from_bytes(raw_email)
            # print (email_message['To'])
            # print ( email.utils.parseaddr(email_message['From']) ) # for parsing "Yuji Tomita" <yuji@grovemade.com>
            # print (email_message.is_multipart()  ,email_message.get_content_type()   ,email_message.keys() )
            try:
                ip = getIpFromString(email_message['Received'])
                new_email = {"from": email_message['From'], "subj": _decode(email_message['Subject']),
                             "date": email_message['Date'], "ip": ip, "body": ""}
            except Exception as e:
                print("Exception in new_email dict %s" % str(e))
                continue

            if email_message.is_multipart():
                filenames = []  # this contails filenames of the downloaded attachments

                for part in email_message.walk():
                    # print("multipart content_type",part.get_content_type())
                    # print ("This is a part")
                    if part.get_content_maintype() == 'multipart':
                        # print ("skipping multipart")
                        continue
                    if part.get_content_type() in ('message/delivery-status', 'message/rfc822', 'text/rfc822-headers'):
                        continue
                    if part.get_content_type() == "text/plain" or part.get_content_type() == "text/html":
                        new_email["body"] = str(new_email["body"]) + str(part.get_payload(decode=True)) if new_email[
                                                                                                               "body"] != None else str(
                            part.get_payload(decode=True))
                        if part.get_content_disposition() == "attachment":
                            # print("This is attachment")
                            filename = getAttachment(part)
                            print(filename)
                            filenames.append(filename)
                        else:
                            print(part.get_content_disposition())
                    else:
                        print("This is attachment ?? {}".format(part.get_content_type()))
                        filename = getAttachment(part)
                        print(filename)
                        if filename:
                            filenames.append(filename)
                        else:
                            print('no')
                new_email['filename'] = filenames
            else:
                print("no multipart, no attachment")
                new_email['filename'] = []
                new_email["body"] = str(email_message.get_payload(decode=True))
            email_list.append(new_email)
        # print ("email_list",email_list )
        return email_list
    except Exception as e:
        RateAutoImportMailboxLog(start=start, finish=datetime.now(UTC),error=str(e),received_letters=len(email_list)).save()
        print(" Exception in fetching mail:  %s" % (str(e)))
        log.error("Exception in fetching mail:  %s" % (str(e)))
        return -1


def handle_zip(filename):
    '''gets file name of the zip archive, extracts in ./files dir and returns list of the file names '''
    extracted_names_list = []
    with zipfile.ZipFile(UPLOAD_TO + filename, "r") as zip_ref:
        extracted_names_list = zip_ref.namelist()
        zip_ref.extractall(UPLOAD_TO)
        return extracted_names_list

    print(" Exception in extraction from zip")
    log.error(" Exception in extraction from zip")
    return -1


def check_mail():
    mail = connectEmail()
    if mail == -1:
        return -1, 0
    email_list = searchMail(mail)
    if email_list == None or email_list == -1:
        return -1, 0
    return 0, email_list


def email_rule_list_creator(email_list, add_email):
    """Gets list of emails, checks rule and returns list of list pair email-rule"""
    email_rule_list = []
    if email_list:
        print("len of emails list", len(email_list))
        for email in email_list:
            ip = email['ip']
            _name, _from = parseaddr(email['from'])
            cls = RateAutoImportRule
            rules = cls.filter(and_(cls.from_email == _from, cls.active == True)).all()
            # check is there match between from and IP for email address in rules
            if rules == None or rules == []:
                print("Unmatched email %s" % str(email))
                clean_attachments(email)
                continue
            found = False
            for rule in rules:
                # check ip filter
                if rule.mail_server_ip and rule.mail_server_ip != ip:
                    print('sender ip does not match')
                # is there rule.keyword that matches email subject
                subject_keyword = rule.subject_keyword.lower()
                print("checking rule subjct", subject_keyword)
                if subject_keyword == None or subject_keyword == "":
                    # subject_keyword we need actual keyword
                    print("subject_keyword is missing")
                    continue
                # _subj=decode_header(email['subj'])[0]
                # subject_email = _subj[0].decode(_subj[1]).lower()
                subject_email = email['subj'].lower()
                if subject_keyword in subject_email:
                    print("Rule email subject %s WAS found in %s" % (subject_keyword, subject_email))
                    # print ("email",email)
                    print("rule name", rule.rule_name, "wit rule id:", rule.id)
                    email['add_email'] = add_email
                    rule_info = rule.as_dict()
                    rule_info['info'] = rule.info
                    rule_log = RateAutoImportRuleLog(start=datetime.now(UTC), rule_id=rule.id, status='email upload',
                                                     received_from_ip=ip)
                    log_id = rule_log.save()
                    rule_info.update(dict(rule=rule, rule_log=rule_log, rule_log_id=log_id))
                    email_rule_list.append([email, rule_info])
                else:
                    clean_attachments(email)
        # print ("Rule email subject %s not found in %s" % ( subject_keyword , subject_email ) )
    return email_rule_list


def minimalist_xldate_as_datetimestr(xldate, datemode=0):
    # datemode: 0 for 1900-based, 1 for 1904-based
    try:
        res = datetime(1899, 12, 30) + timedelta(days=xldate + 1462 * datemode)
        return res.strftime("%Y/%m/%d")
    except Exception as e:
        # print("Error in minimalist xl date convert. Probably string? Error %s for xldate %s  "%(e, str(xldate)))
        if "str implicitly" in str(e):  # it is string date
            # returning "xldate unchanged"
            return xldate
        else:
            res = datetime(1899, 12, 30) + timedelta(days=xldate + 1462 * datemode)
            return res.strftime("%Y/%m/%d")


def stringToDict(dict_str):
    dict_str = dict_str.replace('{', "").replace('}', "")
    lst = dict_str.split(",")
    new_dict = dict()

    for elem in lst:
        pair = elem.split(":")
        try:
            new_dict[pair[0].strip()] = pair[1].strip()
        except:
            pass
    return new_dict


def codesplit(all_rate_list, rule, special_options_dict):
    """special case dialer . when in one row we have more from one code"""
    first_row_checked = False  # the idea is that we need to insert in row and rule the row number of rate status column
    add_col = rule['code_col']  # int(special_options_dict['add'])
    delete_col = int(special_options_dict['delete'])  # ??
    new_col = int(special_options_dict['new'])  # ??
    code_num = rule['code_col']
    status_num = rule['rate_status_col']
    code_delimiter = rule['code_delimiter'] if rule['code_delimiter'] != None else ","
    # print (add_col,new_col)
    new_rate_list = list()
    print("add_col", add_col, code_delimiter, status_num)
    for row in all_rate_list:
        codes_list_add = row[code_num].split(code_delimiter)
        codes_list_del = []  # row [delete_col].split (",")
        codes_list_new = []  # row [new_col].split (",")
        # print ("LENGTH", len(codes_list_add),len(codes_list_new) )
        new_rows_list = []
        for code in codes_list_add:
            if len(code.strip()) == 0:
                continue
            new_row = list(row)
            new_row[add_col] = code.strip()
            new_row.append(row[status_num])
            new_rows_list.append(new_row)
        for code in codes_list_del:
            if len(code.strip()) == 0:
                continue
            new_row = list(row)
            new_row[add_col] = code.strip()
            new_row.append("delete")
            new_rows_list.append(new_row)
        for code in codes_list_new:
            if len(code.strip()) == 0:
                continue
            try:
                int(code)
            except:
                continue

            new_row = list(row)
            new_row[1] = ""
            new_row[add_col] = code.strip()
            new_row[delete_col] = ""
            new_row[new_col] = ""

            new_row.append("new")
            new_rows_list.append(new_row)
        # print (new_row)
        new_rate_list.extend(new_rows_list)
    # rule['rate_status_col'] = len(new_rate_list[0]) - 1
    rule['code_col'] = add_col
    print("new_rate_list", new_rate_list)
    return new_rate_list


def specialCase(all_rate_list, rule, email_rule_list):
    """Dials with special cases"""

    print(rule['special_rule_case'])
    # print (all_rate_list)
    try:
        special_options_dict = stringToDict(str(rule['special_rule_case']))
    except Exception as e:
        print("Exception in specialCase %s" % e)
        return -1
    if special_options_dict['name'] == "codesplit":
        print("codesplit")
        all_rate_list = codesplit(all_rate_list, rule, special_options_dict)
    elif special_options_dict['name'] == "singlecelldate":
        print("singlecelldate")
    # all_rate_list = specialCaseSingleEffectDate(all_rate_list,rule,special_options_dict)
    return all_rate_list


# print ("len of list", len(all_rate_list),all_rate_list[0])


def extract_info(file_list, file_ext, start_from_row, rule, email_rule_list):
    """gets list of files and file type from rule"""
    # start_from_row is not given, try from the beginning - 1 row for header
    print("extract info")
    if start_from_row == None:
        start_from_row = 2
    if start_from_row > 0:
        start_from_row -= 1
    all_rate_list = []
    # if file_ext == 2:  #csv
    # if file_ext == 2:  #csv

    status_dict_default = email_rule_list[0][2]
    status_dict_default['start_from_row'] = start_from_row
    status_dict_default['date_fail'] = 0
    status_dict_default['row_fail'] = 0
    # status_dict_default[start_from_row
    print("file_list", file_list)
    code_delimiter = rule.get('code_delimiter', ',')
    if code_delimiter == None or code_delimiter.strip() == "":
        code_delimiter = ","
    for filename in file_list:
        try:
            file_ext = filename[-3:]
        except:
            print("file ext can`t be get")
            return
        print("file_ext", file_ext)
        if file_ext == "zip":
            filename = handle_zip(filename)[0]
            file_ext = filename[-3:]

        if file_ext == "csv":
            print("in csv")
            with open(UPLOAD_TO + filename) as f:
                lis = [line.strip("\r\n").strip("\n").split(code_delimiter) for line in f]
            try:
                if rule['special'] == True:
                    if 'singlecelldate' in rule['special_rule_case']:
                        name, row, col = rule['special_rule_case'].split(code_delimiter)
                        row = int(row.split(":")[1])
                        col = int(col[:-1].split(":")[1])
                        effect_date = lis[row, col]
                        new_list = []
                        for row in lis[start_from_row:]:
                            row.append(effect_date)
                            new_list.append(row)
                        lis = list(new_list)
                lis = lis[start_from_row:]
                print("start_from_row", start_from_row, "len of res", len(lis))
            except:
                print("Error in csv file extraction", start_from_row, len(lis))
            all_rate_list.extend(lis)
        elif file_ext == "xls":
            wb = xlrd.open_workbook(UPLOAD_TO + filename)
            num_sheets = wb.nsheets
            for idx in range(num_sheets):
                sh1 = wb.sheet_by_index(idx)
                print(sh1.name)
                if rule['filter_by'] == 1:
                    print("filter by sheet name")
                    print("name of the sheet", sh1.name)
                    sheet_name = sh1.name
                    filter_value = rule['filter_val']
                    if sheet_name.strip().lower() != filter_value.strip().lower():
                        print("Sheets name do not match with the rule ", sheet_name.strip().lower(),
                              filter_value.strip().lower())
                        continue
                    else:
                        print("Sheets name do  match with the rule ", sheet_name.strip().lower(),
                              filter_value.strip().lower())
                # print(sh1.nrows)
                data = []
                for rownum in range(sh1.nrows):
                    # print ("rownum",rownum,"start_from_row",start_from_row)
                    if rownum >= start_from_row:
                        # print ("inside",sh1.row_values(rownum))
                        row = sh1.row_values(rownum)
                        if rule['all_info_at_single_column']:
                            # when all info is in single column
                            row = row[:1]
                            row = row[0].split(";")
                        try:
                            row[rule['rate_col']] = str(row[rule['rate_col']])
                            row[rule['code_col']] = str(row[rule['code_col']]).replace(".0", "")
                        except:
                            print("error in xls handling in rate and code ", len(row), rule['rate_col'],
                                  rule['code_col'])
                            status_dict_default['row_fail'] += 1
                            continue
                        try:
                            row[rule['code_name_col']] = str(row[rule['code_name_col']])
                        except:
                            print("error in xls handling code_name_col")
                            # status_dict_default['row_fail']  +=1
                            pass
                        # print (row [rule['effective_date_col'] ],rule['effective_date_col'],"For row %s"%str(row))
                        try:
                            row[rule['effective_date_col']] = minimalist_xldate_as_datetimestr(
                                row[rule['effective_date_col']])
                        except Exception as e:
                            if status_dict_default['effective_date'] == 0:
                                # some error
                                status_dict_default['date_fail'] += 1
                                print("error in xls handling effect_date_col1:", e)
                                print(row, row[rule['effective_date_col']], rule['effective_date_col'])
                                continue
                        # print ("error in xls handling effect_date_col",e)

                        try:
                            row[rule['end_date_col']] = minimalist_xldate_as_datetimestr(row[rule['end_date_col']])
                        except Exception as e:
                            # print ("error in xls handling end_date_col",e)
                            # status_dict_default['row_fail']  +=1
                            pass
                        # data. row
                        if rule['special'] == True:
                            if 'singlecelldate' in rule['special_rule_case']:
                                name, _row, col = rule['special_rule_case'].split(code_delimiter)
                                _row = int(row.split(":")[1])
                                col = int(col[:-1].split(":")[1])
                                effect_date = sh1.row_values(_row)[col]
                                row.append(minimalist_xldate_as_datetimestr(effect_date))
                            rule['effective_date_col'] = len(row) - 1
                        all_rate_list.append(row)
        elif file_ext == "lsx":
            data = []
            # from openpyxl.reader.excel import load_workbook

            wb = xlrd.open_workbook(filename=UPLOAD_TO + filename)  # , use_iterators = True
            counter = 0
            effect_date = 0
            print("Sheet counter", len(wb.get_sheet_names()), wb.get_sheet_names())
            print("Start from row ", rule['start_from_row'])
            for sheet_name in wb.get_sheet_names():  # wb.worksheets:
                print("name of the sheet", str(sheet_name))
                sheet = wb.get_sheet_by_name(sheet_name)

                if rule['filter_by'] == 1:
                    print("filter by sheet name")
                    # print("name of the sheet" , str(sheet_name)  )
                    filter_value = rule['filter_val']
                    if sheet_name.strip().lower() != filter_value.strip().lower():
                        print("Sheets name do not match with the rule ", sheet_name.strip().lower(),
                              filter_value.strip().lower())
                        continue
                    else:
                        print("Sheets name do  match with the rule ", sheet_name.strip().lower(),
                              filter_value.strip().lower())

                # print("starting iter_rows" )
                for row in sheet.iter_rows():

                    data_row = []
                    for cell in row:
                        data_row += [cell.internal_value]
                    if rule['all_info_at_single_column']:
                        # when all info is in single column
                        data_row = data_row[:1]
                        data_row = data_row[0].split(";")
                    try:
                        float(data_row[rule['rate_col']])
                    except:
                        # print ("data_row continue except...")
                        try:
                            float(data_row[rule['rate_col']].replace(",", ".").replace("DELETED", '0.00').replace("$",
                                                                                                                  ''))
                        except Exception as e:
                            # print ( "This row do not have rate", e , data_row,   rule['rate_col'] )
                            print("rate ex", e, rule['rate_col'])
                            counter += 1
                            status_dict_default['row_fail'] += 1
                            continue
                    # print ("data_row continue 11..")
                    try:
                        data_row[rule['rate_col']] = str(data_row[rule['rate_col']]).replace("DELETED", '0.00').replace(
                            "$", '')
                        data_row[rule['code_col']] = str(data_row[rule['code_col']]).replace(".0", "")
                    except Exception as e:
                        status_dict_default['row_fail'] += 1
                        # print ("Error in xlsx rate and code")
                        print(e, row, "here4")
                        counter += 1
                        continue
                    # print ("data_row continue 12..")
                    try:
                        data_row[rule['code_name_col']] = str(data_row[rule['code_name_col']])
                    except:
                        pass
                    # print ("data_row continue 13..")
                    try:
                        _num = data_row[rule['effective_date_col']]
                        data_row[rule['effective_date_col']] = minimalist_xldate_as_datetimestr(
                            data_row[rule['effective_date_col']])
                    except Exception as e:
                        if status_dict_default['effective_date'] == 0:
                            # some error
                            try:
                                data_row[rule['effective_date_col']] = data_row[rule['effective_date_col']]
                            except Exception as e:
                                status_dict_default['date_fail'] += 1
                                print("effective date error %s. " % e)
                                counter += 1
                                continue
                    # print ("data_row continue 14..")

                    try:
                        data_row[rule['end_date_col']] = minimalist_xldate_as_datetimestr(
                            data_row[rule['end_date_col']])
                    # data += row
                    except:
                        pass

                    if rule['special'] == True:
                        print("special", rule['special_rule_case'])
                        effect_date = ""
                        if 'singlecelldate' in rule['special_rule_case']:
                            try:
                                name, row, col = rule['special_rule_case'].split(code_delimiter)
                                row = int(row.split(":")[1])
                                col = int(col[:-1].split(":")[1])
                            except Exception as e:
                                print("d1", e)
                                status_dict_default['row_fail'] += 1
                                counter += 1
                                continue
                            if counter == row:
                                try:
                                    effect_date = data_row[col]
                                except Exception as e:
                                    status_dict_default['row_fail'] += 1
                                    counter += 1
                                    print("d2", e)
                                    continue
                            print(effect_date)
                            try:
                                data_row.append(minimalist_xldate_as_datetimestr(effect_date))
                            except Exception as e:
                                status_dict_default['row_fail'] += 1
                                counter += 1
                                print("d3", e)
                                continue

                        rule['effective_date_col'] = len(data_row) - 1

                    if counter + 1 < rule.get('start_from_row', 0):
                        print("skipped", data_row, counter, rule.get('start_from_row', 0))
                        counter += 1
                        continue
                    # print (data_row)
                    # time.sleep(1.5)
                    # print ("accumulating data ")
                    # print (data_row)
                    data += [data_row]
                    counter += 1
                # print ("acculumated..")
                print("extending data", len(data))
                all_rate_list.extend(data)
                data = []
            # print ("rule",rule)
            if rule['multiple_codes']:
                print("codesplit")
                try:
                    all_rate_list = codesplit(all_rate_list, rule, email_rule_list)
                except Exception as e:
                    print("Exception in code split %s" % str(e))

            if rule['special'] == True:
                try:
                    print("it is special")
                    all_rate_list = specialCase(all_rate_list, rule, email_rule_list)
                except Exception as e:
                    print("Exception in special case %s" % str(e))

    # print (all_rate_list)
    # time.sleep(50)
    # filter by column CLI/NCLI
    if rule["filter_by"] == 2:
        print("len of all_rate_list before filter", len(all_rate_list))
        filtered_all_rate_list = []
        filter_col = rule["filter_col"]
        filter_val = rule["filter_val"]
        print(filter_col, filter_val)
        for row in all_rate_list:
            if filter_val.strip().lower() == row[filter_col].strip().lower():  # not matched
                filtered_all_rate_list.append(row)
        all_rate_list = filtered_all_rate_list
        print("len of all_rate_list after filter", len(all_rate_list))

    if rule['separate_date_time']:
        # connect date with time
        for row in all_rate_list:
            row[rule['effective_date_col']] = row[rule['effective_date_col']] + " " + row[
                rule['effective_date_col'] + 1]
            row[rule['end_date_col']] = row[rule['end_date_col']] + " " + row[rule['end_date_col'] + 1]

    # for cases like 2-9 in code cell. Must iterate and create all possible codes in between
    added_all_rate_list = []
    for row in all_rate_list:
        try:
            ind = row[rule['code_col']].index('-')
            low_num = int(row[rule['code_col']][ind - 1])
            high_num = int(row[rule['code_col']][ind + 1])
            # print ("- found!",row,low_num,high_num)
            for idx in range(low_num, high_num + 1):
                new_code = idx
                new_row = list(row)
                new_row[rule['code_col']] = str(new_code)
                added_all_rate_list.append(new_row)
        except Exception as e:
            # print (e)
            continue
    print("added_all_rate_list", added_all_rate_list)
    all_rate_list.extend(added_all_rate_list)

    if rule['code_in_two_columns']:
        print("getting code from two columns")
        try:
            column1, column2 = rule['code_in_two_columns'].split(";")
        except:
            print("Exception in spliting code in two columns")
        print(column1, column2, type(column1))
        for row in all_rate_list:
            try:
                # print ("row before",row)
                row[int(rule['code_col'])] = str(row[int(column1)]) + str(row[int(column2)])
                # for cases where we have only prefix/country code
                row[int(rule['code_col'])] = row[int(rule['code_col'])].replace("None", "")
            # print ("row after",row)
            # time.sleep(3)
            except Exception as e:
                # pass
                print("Exception in code in two columns ", e, row)
    if rule['add_code_front']:
        print("adding code in front of clodes")
        for row in all_rate_list:
            try:
                # print ("row before",row)
                row[int(rule['code_col'])] = rule['add_code_front'] + row[int(rule['code_col'])]
            except Exception as e:
                # pass
                print("Exception in preappending  code ", e, rule['code_col'], rule['add_code_front'])

    # print (all_rate_list)
    print("all_rate_list len", len(all_rate_list))
    # print ("RSC",rule['rate_status_col'])
    # time.sleep(50)
    return all_rate_list


def ExtractEffectiveDateFromSubject(email_rule_list):
    """Tries to identify date in  email subject"""
    # print ("email_rule_list",email_rule_list)

    subj = email_rule_list[0]['subj']

    date_pattern = email_rule_list[1]['date_pattern']
    date_pattern_mod = date_pattern.replace("%Y", "\d{4}").replace("%y", "\d{2}").replace("%m", "\d{2}").replace("%d",
                                                                                                                 "\d{2}").replace(
        "%H", "\d{2}").replace("%M", "\d{2}").replace("%S", "\d{2}")
    print("subj:", subj, "date_pattern:", date_pattern_mod)
    p = re.compile('(%s)' % date_pattern_mod)
    result = p.findall(subj)
    print("In searching for subject date %s" % result)
    if len(result) > 0:
        # print (result)
        try:
            print(result[0], date_pattern)
            return datetime.strptime(result[0], date_pattern)  # datetime_object
        except Exception as e:
            print("Exception in Read date from Subject datetime operation", e)
            return -1
    else:
        print("pattern not found")
        return -1


def ExtractEffectiveDateFromContent(email_rule_list):
    """Tries to identify date in  email subject"""
    # print ("email_rule_list",email_rule_list)
    if 'body' in email_rule_list[0]:
        cont = email_rule_list[0]['body']

        date_pattern = (email_rule_list[1]['rate_date_format']).upper().replace('MM','%m').replace('YYYY','%Y').replace('DD','%d')
        date_pattern_mod = date_pattern.replace("%Y", "\d{4}").replace("%y", "\d{2}").replace("%m", "\d{2}").replace("%d",
                                                                                                                     "\d{2}").replace(
            "%H", "\d{2}").replace("%M", "\d{2}").replace("%S", "\d{2}")
        print("cont:", 'cont', "date_pattern:", date_pattern_mod)
        # print ("date_pattern_mod",date_pattern_mod)
        p = re.compile('(%s)' % date_pattern_mod)
        result = p.findall(cont)
        print("In searching for content date %s" % result)
        if len(result) > 0:
            # print (result)
            try:
                print(result[0], date_pattern)
                return datetime.strptime(result[0], date_pattern)  # datetime_object
            except Exception as e:
                print("Exception in Read date from Content datetime operation", e)
                return -1
        else:
            print("pattern not found")
            return -1
    else:
        print("missing body")
        return -1


def getFileFromLink(rule, file_list, email_rule_list):
    # print(email_rule_list[0])
    # rule['domain'] =
    cont = email_rule_list[0][0]['body']
    # print ("cont:",cont)
    if "http://gnh.cloudswitch.cc/system" in cont:
        print("Global Net Holdings!")
        urls = re.findall('http[s]?://(?:[a-zA-Z]|[0-9]|[$-_@.&+]|[!*\(\),]|(?:%[0-9a-fA-F][0-9a-fA-F]))+', cont)
        url = urls[0].replace("\\r\\n", "").replace("\n", "").replace("'", "")
        # print ("Name", link.text, "URL", link.get("href") )
        session = requests.Session()

        # HEAD requests ask for *just* the headers, which is all you need to grab the
        # session cookie
        # print(url)
        res = requests.get(url)
        # print(res.text)
        searchObj = re.search(r'var rates = (.*); //', res.text, re.M | re.I)
        rates = searchObj.group(1).split(";")[0]
        URL_AJAX = 'http://gnh.cloudswitch.cc/system/downloadsheet.php?data=getsysrates&rateplan=' + rates + '"&batch=0"'
        print(URL_AJAX)
        # urls = re.findall(' (\d);', cont)

        session.head(url)
        r = session.get(URL_AJAX, stream=True)
        # print(r.text,r.status_code )
        if r.status_code == 200:
            d = r.headers['content-disposition']
            fname = re.findall("filename=(.+)", d)
            print(fname)
            with open(UPLOAD_TO + fname[0], 'wb') as f:
                r.raw.decode_content = True
                shutil.copyfileobj(r.raw, f)
            file_list.append(fname[0][0:])
            return

    else:
        # voxbeam
        domain = 'http://voxbeam.com/email/'  # rule['domain']
        # print("email content len:",len(cont))
        page = html.fromstring(cont)
        counter = 0
        for link in page.xpath("//a"):
            print("Name", link.text, "URL", link.get("href"))
            counter += 1
        if counter == 0:  # no a
            urls = re.findall('http[s]?://(?:[a-zA-Z]|[0-9]|[$-_@.&+]|[!*\(\),]|(?:%[0-9a-fA-F][0-9a-fA-F]))+', cont)
            # print ("urls",urls)
            for url in urls:
                url = url[: url.index("\\r")]
                # print (url)
                r = requests.get(url)
                cont = r.text
                # print( len(cont))
                page = html.fromstring(cont)
                for link in page.xpath("//a"):
                    # print ("Name", link.text, "URL", link.get("href") )
                    if link.get("href") != None and "ratesheet_download?" in link.get("href"):
                        print("file is found")
                        url = domain + link.get("href").strip()
                        print(url)
                        # r = requests.get(  )
                        r = requests.get(url, stream=True)
                        # print ( r.headers,r.text)
                        import cgi
                        params = cgi.parse_header(r.headers['content-disposition'])[1]
                        filename = params['filename']

                        if r.status_code == 200:
                            with open(UPLOAD_TO + filename, 'wb') as f:
                                r.raw.decode_content = True
                                shutil.copyfileobj(r.raw, f)
                            file_list.append("/" + filename)
                            break


def extract_rate_file_info(email_rule_list):
    """extracts information from attachments. Returns list of three lists: email info, rule, all rate extracted"""
    list_rules_email_extracted_info = []
    # print (email_rule_list,len(email_rule_list))
    try:
        status_dict_default = email_rule_list[0][2]
    except:
        # print ("status_dict_default = email_rule_list[0][2]")
        status_dict_default = dict()
    # print (len(email_rule_list) )
    for pair in email_rule_list:
        # print ("pair",pair  )
        file_list = pair[0]['filename']
        file_ext = pair[1].get('file_type', 0)
        read_effective_date_from = pair[1].get('read_effective_date_from')
        # print ("read_effective_rate_from_subject",read_effective_rate_from_subject)

        if read_effective_date_from == 'subject':
            try:
                status_dict_default['effective_date'] = ExtractEffectiveDateFromSubject(pair)
            except Exception as e:
                print("Exception in ExtractEffectiveDateFromSubject %s" % str(e))
                continue

        if read_effective_date_from == 'content':
            try:
                status_dict_default['effective_date'] = ExtractEffectiveDateFromContent(pair)
            except Exception as e:
                print("Exception in ExtractEffectiveDateFromContent %s" % str(e))
                continue
        # status_dict_default['effective_date'] = ExtractEffectiveDateFromSubject(email_rule_list)

        print("pair1", pair[1]['is_link'], pair[1])
        if pair[1]['is_link']:  # is link, not attachment
            try:
                getFileFromLink(pair[1], file_list, email_rule_list)
            except Exception as e:
                print("Exception in getFileFromLink %s" % str(e))
                continue

        try:
            all_rate_list = extract_info(file_list, file_ext, pair[1]['info']['start_from'], pair[1], email_rule_list)
        except Exception as e:
            print("Exception in extract_info %s" % str(e))
            continue
        # print ("all_rate_list len",len(all_rate_list),all_rate_list[0])
        new_pair = list(pair)
        new_pair.append(all_rate_list)
        # new_pair.append(status_dict_default)
        new_pair[2], new_pair[3] = new_pair[3], new_pair[2]
        list_rules_email_extracted_info.append(new_pair)
    return list_rules_email_extracted_info


"""
def extract_all_codes(code_col_num,lst):
	code_list = []


	for row in lst:
		try:
			code_list.append(row[code_col_num])
		except:
			print(code_col_num,row)

	print("code_list",code_list)
	return code_list 

def get_superset(code_list):

	code_list_sorted = list(code_list)
	code_list_sorted.sort(key = len)
	subsets = []
	for elem in code_list_sorted:
		subsets.append(elem)
		set_s = [s for s in code_list_sorted if code_list_sorted.startswith(elem)]
		code_list_sorted.remove(elem)
		for el in set_s:
			code_list_sorted.remove(el)

def getSupersets(list_rules_email_extracted_info):


	for elem in list_rules_email_extracted_info:
		#print ("elem:",elem[2])
		code_col_num = elem[1]['code_col'] 
		code_list  = extract_all_codes(code_col_num,elem[2])
		superset = get_superset(code_list)
"""


def unblock_rule(pg_cur):
    if pg_cur != -1:
        now = datetime.now()
        epoch_secs_unblock = int(now.timestamp())
        sql = " delete from resource_block where unblock_at < %s" % (epoch_secs_unblock)
        pg_cur.execute(sql)


class GracefulKiller():
    def __init__(self, pidlock=""):
        signal.signal(signal.SIGINT, self.exit_gracefully)
        signal.signal(signal.SIGTERM, self.exit_gracefully)
        self.pidlock = pidlock

    def exit_gracefully(self, signum, frame):
        print("Gracefull killer! exiting")
        # self.pidlock.break_lock()
        exit(0)


def pid_setup():
    # setting PID
    global PIDFile
    PIDFile = PIDLockFile(PIDF, timeout=-1)
    try:
        print("Acquiring lock...")
        PIDFile.acquire()
        grace = GracefulKiller(PIDFile)
    # PIDFile.break_lock()
    except AlreadyLocked:
        try:
            os.kill(PIDFile.read_pid(), 0)
            print('dnl_rate_import worker Reporting: Process already running!')
            os.remove(PIDF)
            log.error('dnl_rate_import worker Reporting: Process already running!')
            exit(1)
        except Exception as e:  # No process with locked PID
            print("dnl_rate_import worker Reporting: General error %s. We will try to remove pid file.." % str(e))
            log.error(
                "dnl_rate_import worker Reporting: General error %s. We will try to remove pid file.." % str(e))
            try:
                os.remove(PIDF)
                print("Trying to delete old pid file...")
                log.error("Trying to delete old pid file...")
            except Exception as e:
                print("dnl_rate_import worker Reporting: error in deleting old pid file %s" % str(e))
            exit(1)
    except Exception as e:  # No process with locked PID
        # PIDFile.break_lock()
        print("dnl_rate_import worker Reporting: General error %s. We will try to remove pid file..." % str(e))
        try:
            print("Trying to delete old pid file...")
            log.debug("Trying to delete old pid file...")
            os.remove(PIDF)
        except Exception as e:
            print("dnl_rate_import worker Reporting: error in deleting old pid file %s" % str(e))
        exit(1)


def main(add_email):
    pg_conn = -1
    grace = GracefulKiller()
    while pg_conn == -1:
        pg_conn, pg_cur, logger, config = setup()
        if pg_conn == -1:
            import time
            time.sleep(60)

    try:
        status, email_list = check_mail()
    except Exception as e:
        print(" Exception in check mail:  %s" % (str(e)))
        log.error(" Exception in check mail:  %s" % (str(e)))
    if status == -1:
        # PIDFile.break_lock()
        exit(1)
    try:
        unblock_rule(pg_cur)
    except Exception as e:
        print(" Exception in unblocking:  %s" % (str(e)))
        log.error(" Exception in unblocking:  %s" % (str(e)))

    try:
        email_rule_list = email_rule_list_creator(email_list, pg_cur, add_email)
        for rule in email_rule_list:
            status_dict_default = dict()  # defaultdict(lambda: 0)
            status_dict_default['effective_date'] = 0
            status_dict_default['num_fail'] = 0
            rule.append(status_dict_default)
    except Exception as e:
        print(" Exception in email rule creation:  %s" % (str(e)))
        log.error(" Exception in email rule creation:  %s" % (str(e)))
        # PIDFile.break_lock()
        return -1

    try:
        list_rules_email_extracted_info = extract_rate_file_info(email_rule_list)
    except Exception as e:
        print(" Exception in extract_rate_file_info:  %s" % (str(e)))
        log.error(" Exception in extract_rate_file_info:  %s" % (str(e)))
        # PIDFile.break_lock()
        return -1

    # print ("list_rules_email_extracted_info len",len (list_rules_email_extracted_info))

    for idx in range(0, len(list_rules_email_extracted_info), 5):
        if idx + 5 < len(list_rules_email_extracted_info):
            _max = idx + 5
        else:
            _max = len(list_rules_email_extracted_info)
        p = Pool(5)
        # for elem in list_rules_email_extracted_info:
        p.map(helper.work, list_rules_email_extracted_info[idx: _max], )
        p.close()
        p.join()

    pg_cur.close()
    return 0


if __name__ == '__main__':
    pass

### NOTES
# status_dict_default  - keeps status reports and some other info. Default dict
