from timeit import default_timer as timer
from datetime import datetime, timedelta
import traceback
import decimal
from pytz import UTC
from sqlalchemy.sql import and_, or_, not_, select, cast, case, text, func, literal
from sqlalchemy.orm.attributes import flag_modified
from api_dnl.model import SystemParameter, Invoice, InvoiceSummary, Client, ClientPayment,  InvoiceHistory, \
    DidInvoiceChargeBreakdown, DidInvoiceChargeDetail, DidBillingPlan, \
    DidBillingRel, DidBillingBrief, Resource, DidReport, DidInvoicePortCharge, QosResource, DidChargeDetail, \
    BalanceHistoryActual, DidRepository
from api_dnl.model import log, init_db, DateTime, Integer, client_cdr_iterator
from api_dnl import model
from api_dnl.__version__ import __version__, __date__
from api_dnl.utils.statisticapi2 import StatisticException, StatisticAPI
from decimal import Decimal
import psycopg2.errors as pgerrors

# region body
DECIMAL = 2


def tmstmp2date(t):
    return str(datetime.fromtimestamp(t).date())


def zn(x):
    if x is None:
        return 0.0
    else:
        return float(x)


def znr(x):
    if x is None:
        return 0.0
    else:
        return round(float(x), DECIMAL)


def zni(x):
    if x is None:
        return 0
    else:
        return int(round(x, 0))


class InvoiceSummaryGenerator(InvoiceSummary):

    def update_client_data(self):
        global DECIMAL
        try:
            DECIMAL = self.config.invoice_decimal_digits
            self.data = {}
            if self.json_content:
                self.data = dict(self.json_content)
            if self.task.is_auto:
                self.payment_dur_date = self.client.payment_term.due_date(self.invoice_end_time_tz)
            else:
                self.payment_dur_date = self.task.payment_dur_date
        except Exception as e:
            log.debug('invoice summary general error:{}'.format(e))
            raise e
        client_data = dict(invoice_decimal_digits=self.config.invoice_decimal_digits,
                           client_name=self.client_name,
                           company_name = self.company_name,
                           client_address=self.client_address,
                           logo_url=self.logo_url,
                           company_info=self.company_info or '',
                           company_info_location=self.company_info_location,
                           invoice_number=self.invoice_number,
                           invoice_zone=self.invoice_zone or '+00:00',
                           invoice_date=str(self.invoice_generation_time)[0:10],
                           payment_due_date=str(self.payment_dur_date) or '',
                           billing_period=self.billing_period,
                           billing_info=self.billing_info or '',
                           billing_info_location=self.billing_info_location,
                           version=__version__,
                           version_date=__date__
                           )
        self.data['client_data'] = client_data
        self.session().add(self)
        self.session().commit()
        self.update_acc_summary()

    def update_acc_summary(self):
        """gets and makes acount summary if its needed """
        #
        start = timer()
        log.debug("Entering Get Account Summary")

        start_date = self.invoice_start_time_tz
        end_date = self.invoice_end_time_tz

        # cls = OrigInvoice
        # if self.client.client_type == 'carrier':
        #     cls = Invoice
        # prev_inv = cls.filter(
        #     and_(cls.client_id == self.client_id, not_(cls.state == -1), cls.status > 0, cls.type == 0,
        #          cls.invoice_time < func.now()), not_(cls.invoice_number == str(self.invoice_number))).first()

        previous_balance = None
        payment_credit = 0
        non_recurring_charge = None

        pcls = ClientPayment
        q_sum = pcls.session().query(
            func.sum(
                case([(pcls.payment_type == 8, pcls.amount)],
                     else_=0.0)
            ).label('adjustment'),
            func.sum(
                case([(pcls.payment_type.in_([4, 5]), pcls.amount)], else_=0.0)
            ).label('total_payment'),
            func.sum(
                case([(pcls.payment_type.in_([16]), pcls.amount)], else_=0.0)
            ).label('extra_charges'),
            func.sum(
                case(
                    [(pcls.payment_type.in_([7, 12]), -1 * pcls.amount),(pcls.payment_type.in_([8, 11]), pcls.amount)],
                    else_=0.0
                )
            ).label('total_note'),
        ).filter(
            and_(pcls.client_id == self.client_id),
            pcls.payment_time.between(start_date, end_date),
            pcls.payment_type.in_([3, 4, 5, 6, 7, 8, 11, 12, 16])
        ).first()
        # prev_bal = BalanceHistoryActual.filter(
        #    and_(BalanceHistoryActual.date < start_date, BalanceHistoryActual.client_id == self.client_id)).first()
        inv = Invoice
        last_invoice = inv.filter(inv.client_id == self.client_id).order_by(inv.invoice_id.desc()).first()
        # invoice_amount = last_invoice.total_amount if last_invoice else 0

        previous_balance = 0.0
        previous_amount = 0.0
        if last_invoice:
            previous_balance, previous_amount = znr(last_invoice.current_balance), znr(last_invoice.total_amount)

        payment_credit = zn(q_sum.total_payment)
        non_recurring_charge = zn(q_sum.total_note)

        # print("previous_balance: ", previous_balance)
        self.previous_balance = znr(previous_balance)
        self.payments_and_credits = znr(payment_credit)

        # self.current_charges = non_recurring_charge
        # self.invoice_end_time = end_dat
        adjustment = zn(q_sum.adjustment)

        self.data['acc_summary'] = dict(previous_balance=previous_balance, payments_received=payment_credit,
                                        adjustment=znr(adjustment),
                                        past_due_balance=znr((payment_credit + adjustment) + previous_balance), tax=0.0,
                                        past_due_amount=znr(previous_amount),
                                        finance_charges=0.0, other_charges=0.0, scc_charges=0.0, rec_charges=0.0,
                                        non_rec_charges=0.0,
                                        usage_charges=0.0,
                                        extra_charges=zn(q_sum.extra_charges),
                                        visible=self.task.show_acc_summary)
        self.update_usage_charge()
        #self._update_did_invoice_charge_detail()
        self._update_did_invoice_port_charge()
        self.data['acc_summary']['other_charges'] = znr(self.port_charges)
        # logging
        if not self.scc_amount:
            self.scc_amount = 0
        amount = znr(self.data['acc_summary']['usage_charges']) + znr(self.did_nrc) + znr(self.did_mrc) + znr(self.scc_amount)+znr(self.port_charges)
        if self.task.include_tax:
            self.taxes = (znr(self.client.tax) / 100.0) * amount
            self.data['acc_summary']['tax'] = znr(self.taxes)
        if not self.task.show_acc_summary:
            self.data['acc_summary']['visible'] = False
        self.total_amount = abs(amount + znr(self.taxes))
        log.debug('update_acc_summary. total_amount: {}. tax: {}'.format(self.total_amount, self.data['acc_summary']['tax']))
        log.debug('test invoice amount {} {} {} {}'.format(self.total_amount, previous_amount, payment_credit, adjustment))
        self.data['acc_summary']['total_amount'] = znr(
            abs(self.total_amount + previous_amount - payment_credit - adjustment)
        )

        self.session().add(self)
        self.session().commit()
        end = timer()
        log.debug("previous_balance:" + str(previous_balance) + "  payment_credit: " + str(
            payment_credit) + "  non_recurring_charge: " + str(non_recurring_charge)
                  )

    def _update_scc_charges(self):  # , basic_bill, param_dict, client, cost, minutes, float_form):
        """ generates basic table for client bill with surcharges included."""
        #
        start = timer()
        log.debug("Summery of Short Call Charges")

        # table = [["", "Total Minutes", "Total Calls", "Total Charges(US)"], ["Minutes Usage", minutes, basic_bill.get('not_zero_calls', 0), float_form2 % (cost)]]

        scc_perc = zni(self.client.scc_percent)
        scc_below_sec = zni(self.client.scc_bellow)
        scc_charge = zn(self.client.scc_charge)
        # if this is selected, then the penalty is 200 * short charge
        scc_type = zni(self.client.scc_type)

        if not self.task.include_scc_charges:
            return

        api = StatisticAPI()
        res = api.run(start_time=self.start_time, end_time=self.end_time,
                      field='not_zero_calls',
                      group='ingress_client_id',
                      non_zero_calls='1',
                      scc_below_sec=scc_below_sec,
                      ingress_client_id=self.client_id,
                      ignore_users_limit=True
                      )
        res_all = api.run(start_time=self.start_time, end_time=self.end_time,
                          field='not_zero_calls',
                          group='ingress_client_id',
                          non_zero_calls='1',
                          ingress_client_id=self.client_id,
                          ignore_users_limit=True
                          )
        if res:
            result = res[0]
        else:
            result = dict(not_zero_calls=0)
        if res_all:
            result_all = res_all[0]
        else:
            result_all = dict(not_zero_calls=0)

        log.debug("len of surcharged calls {} {}".format(result['not_zero_calls'], result_all['not_zero_calls']))
        try:
            percent_real = (result['not_zero_calls'] / result_all[
                'not_zero_calls']) * 100  # we need this a whole percent
        except Exception as e:
            percent_real = 0
        num_calls = None
        charge = None
        if scc_type == 0 and percent_real > 0: #percent_real <= scc_perc:
            # "scc will be applied to each call"
            num_calls = result['not_zero_calls']  # len (result_all ) -   len (result)
            if num_calls == None:
                num_calls = 0
            charge = num_calls * scc_charge

        elif scc_type == 1 and percent_real > scc_perc:
            # "scc will be applied to exccess  calls only  "
            num_calls = result['not_zero_calls'] - (scc_perc / 100) * result_all['not_zero_calls']
            charge = num_calls * scc_charge
        else:
            # "Rule is not met percent_real >=<  scc_per"
            self.scc_calls = 0.0
            self.scc_amount = 0.0

        # "Aplying surcharges to table")
        self.scc_calls = num_calls
        self.scc_amount = znr(charge)
        # row_charge = ["Short Charges", "", num_calls, float_form2 % (charge)]
        # row_total = ["TOTAL", "", "", float_form2 % (Decimal(cost) + charge)]
        # basic_bill['call_cost'] = Decimal(cost) + charge
        # table.append(row_charge)
        # table.append(row_total)

        end = timer()
        log.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
        # return table

    def update_scc_charges(self):
        scc_perc = zni(self.client.scc_percent)
        scc_below_sec = zni(self.client.scc_bellow)
        scc_charge = zn(self.client.scc_charge)

        scc_type = zni(self.client.scc_type)

        if not self.task.show_scc_charges:
            return
        trunks = [(r.resource_id,r.alias) for r in
                  Resource.session().query(Resource.resource_id, Resource.client_id, Resource.rating_type, Resource.alias). \
                    filter(and_(Resource.client_id == self.client_id, Resource.rating_type == 0)).all()]
        ret = []
        total_short_calls =0
        total_calls = 0

        for trunk_id, name in trunks:
            calls = []
            for cdr in client_cdr_iterator(self.invoice_start_time_tz,self.invoice_end_time_tz):
                q=self.session().query(cdr.c.call_duration).filter(and_(cdr.c.ingress_id==trunk_id,
                                                                                cdr.c.call_duration>0))
                calls = calls + q.all()
            not_zero_calls = len(calls)
            short_calls = sum(1 for i in calls if i.call_duration < scc_below_sec)
            total_short_calls += short_calls
            total_calls += not_zero_calls
            if not_zero_calls+short_calls > 0:
                ret.append(dict(trunk_name=name,calls=not_zero_calls,short_calls=short_calls))
        ret.append(dict(trunk_name='Total', short_calls=total_short_calls, calls=total_calls))

        if total_calls > 0:
            percent_real = (total_short_calls / total_calls * 100)  # we need this a whole percent
        else:
            percent_real = 0
        num_calls = 0
        charge = None
        if scc_type == 0 and percent_real > 0: #percent_real <= scc_perc:
            # "scc will be applied to each call"
            num_calls = total_short_calls  # len (result_all ) -   len (result)
            if num_calls == None:
                num_calls = 0
            charge = num_calls * scc_charge

        elif scc_type == 1 and percent_real > scc_perc:
            # "scc will be applied to exccess  calls only  "
            num_calls = total_short_calls - (scc_perc / 100) * total_calls
            charge = num_calls * scc_charge
        else:
            # "Rule is not met percent_real >=<  scc_per"
            self.scc_calls = 0.0
            self.scc_amount = 0.0

        # "Aplying surcharges to table")
        self.scc_calls = num_calls
        self.scc_amount = znr(charge)


        summary=dict(scc_below_sec=scc_below_sec,scc_perc=scc_perc,scc_charge=scc_charge,scc_amount=znr(charge))

        self.data['scc_charges'] = dict(items=ret, summary=summary)

    def update_payment_applied(self):
        pcls = ClientPayment
        pay = pcls.session().query(pcls.client_payment_id, pcls.payment_time, pcls.amount).filter(
            and_(pcls.client_id == self.client_id),
            pcls.payment_type.in_((4, 5)),
            pcls.payment_time.between(
                self.invoice_start_time_tz,
                self.invoice_end_time_tz)
        ).order_by(pcls.payment_time)
        pay_list = [dict(payment_id=p.client_payment_id, payment_time=str(p.payment_time)[0:19], amount=znr(p.amount))
                    for p
                    in pay]

        pay_list.sort(key=lambda k: k['payment_time'], reverse=True)

        self.data['payment_applied'] = {'items': pay_list, 'total': znr(sum([p.amount for p in pay]))}

    def _update_did_invoice_charge_detail(self):
        if not hasattr(self, '_did_invoice_charge_detail_updated'):
            cls = DidInvoiceChargeBreakdown
            clsd = DidInvoiceChargeDetail
            rel = DidRepository  # v6
            pln = DidBillingPlan
            rep = DidReport
            trunks = [int(i) for i in self.client._trunks_orig_ids.split(',') if i !='']
            exists = clsd.filter(clsd.invoice_number == self.invoice_number).first()
            if exists is not None:
                clsd.filter(clsd.invoice_number == self.invoice_number).delete(synchronize_session='fetch')
                cls.filter(cls.invoice_number == self.invoice_number).delete(synchronize_session='fetch')
                clsd.session().commit()
            ret = clsd.session().execute(clsd.__table__.insert() \
                .from_select(
                ['invoice_number', 'did_number', 'client_billing_plan_id', 'client_trunk_id', 'nrc', 'mrc', 'pay_type',
                 'start_date', 'end_date'],
                select([literal(self.invoice_number), rel.did, rel.client_billing_plan_id, rel.client_trunk_id,
                        rel.nrc,
                        pln.monthly_charge,
                        pln.pay_type,
                        literal(self.invoice_start_time_tz),
                        literal(self.invoice_end_time_tz),
                        ]
                       ). \
                    where(and_(rel.client_trunk_id.in_(trunks), pln.id == rel.client_billing_plan_id))
            )
            )

            # get min start_date of did
            # date_bounds = rel.session().query(func.max(rel.end_date).label('end_date'),
            #                     func.min(rel.start_date).label('start_date')).filter(and_(
            #                         or_(rel.end_date.is_(None), rel.end_date > self.invoice_start_time_tz),
            #                         rel.start_date <= self.invoice_end_time_tz,
            #                         rel.client_res_id.in_(trunks)
            #                     )).first()
            start_date = self.invoice_start_time_tz#getattr(date_bounds, 'start_date', self.invoice_start_time_tz)
            end_date = self.invoice_end_time_tz#getattr(date_bounds, 'end_date', self.invoice_end_time_tz)
            # print(ret)

            # select -extract(week from cast('2020-01-01' as date))+extract(week from cast('2020-01-13' as date));
            # select count(*) from  (SELECT distinct(date_trunc('month', generate_series('2020-01-01'::timestamp,
            # '2020-02-29', '1 month')))as d) as t where t.d between '2020-01-01' and '2020-02-29';

            # ret = clsd.session().execute(
            q = clsd.__table__.update().values(mrc_number=
                                               case([(clsd.pay_type == 0,
                                                      func.extract('isoyear', clsd.end_date) * 52 +
                                                      func.extract('week', clsd.end_date) - func.extract('week',
                                                                                                         clsd.start_date)
                                                      - func.extract('isoyear', clsd.start_date) * 52

                                                      )],
                                                    else_=func.extract('month',
                                                                       clsd.end_date + timedelta(
                                                                           days=1)) - func.extract(
                                                        'month', clsd.start_date)
                                                          + func.extract('year', clsd.end_date + timedelta(
                                                        days=1)) * 12 - func.extract('year', clsd.start_date) * 12
                                                    )
                                               ).where(clsd.invoice_number == self.invoice_number)
            # print(str(q))
            ret = clsd.session().execute(q)
            day_cdr = start_date
            while day_cdr >= start_date and day_cdr <= end_date:
                day_cdr = day_cdr + timedelta(days=1)
                cdr_date = "%s%02d%02d" % (day_cdr.year, day_cdr.month, day_cdr.day)
                cdr = model.did_report(cdr_date)
                r = select([cdr.c.did, clsd.start_date, clsd.end_date, func.sum(cdr.c.not_zero_calls).label('attempts'),
                            func.sum(func.round(cdr.c.egress_bill_time / 60.0, 0)).label('minutes'),
                            func.sum(cdr.c.egress_call_cost).label('call_charge')]). \
                    where(
                    and_(cdr.c.egress_client_id == self.client_id,
                        cdr.c.not_zero_calls > 0,
                        cdr.c.report_time >= clsd.start_date,
                        cdr.c.report_time < clsd.end_date + timedelta(days=1),
                        clsd.invoice_number == self.invoice_number,
                        clsd.did_number == cdr.c.did
                        )).group_by(
                    cdr.c.did, clsd.start_date, clsd.end_date).alias('rep')
                q = clsd.__table__.update().values(attempts=r.c.attempts,
                                                minutes=r.c.minutes,
                                                call_charge=func.coalesce(r.c.call_charge, text("0")),
                                                ).where(and_(clsd.did_number == r.c.did,
                                                                clsd.start_date == r.c.start_date,
                                                                clsd.end_date == r.c.end_date,
                                                                ))

                clsd.session().execute(q)
            # print(ret)
            clsd.session().commit()
            q = cls.__table__.insert() \
                .from_select(
                ['invoice_number', 'did_count', 'client_billing_plan_id', 'client_trunk_id', 'nrc', 'mrc',
                 'minutes', 'attempts', 'call_charge'],
                select(
                    [literal(self.invoice_number), func.count(clsd.did_number.distinct()), clsd.client_billing_plan_id,
                     clsd.client_trunk_id,
                     func.sum(clsd.nrc), func.sum(clsd.mrc * clsd.mrc_number), func.sum(clsd.minutes),
                     func.sum(clsd.attempts),
                     func.sum(clsd.call_charge),
                     ]
                ).where(clsd.invoice_number == self.invoice_number).group_by(clsd.client_billing_plan_id,
                                                                             clsd.client_trunk_id)
            )
            # print(str(q))
            ret = cls.session().execute(q)
            clsd.session().commit()
            self._did_invoice_charge_detail_updated = True
        else:
            pass

    def update_rec_charge(self):
        cls = DidInvoiceChargeBreakdown
        clsd = DidInvoiceChargeDetail
        self._update_did_invoice_charge_detail()
        # select([func.count(clsd.did_number.distinct()), clsd.client_billing_plan_id,
        #         clsd.client_trunk_id,
        #         func.sum(clsd.nrc), func.sum(clsd.mrc * clsd.mrc_number), func.sum(clsd.minutes),
        #         func.sum(clsd.attempts),
        #         func.sum(clsd.call_charge),
        #         ]
        #        ).where(clsd.invoice_number == self.invoice_number).group_by(clsd.client_billing_plan_id,
        #                                                                     clsd.client_trunk_id)

        r = select([clsd.invoice_number.label('invoice_number'), func.sum(clsd.nrc).label('nrc'),
                    func.sum(clsd.mrc * clsd.mrc_number).label('mrc'), func.sum(clsd.minutes).label('minutes'),
                    func.sum(clsd.attempts).label('attempts'),
                    func.sum(clsd.call_charge).label('call_charge'),
                    func.count(clsd.did_number.distinct()).label('did_count'),
                    func.sum(case([(clsd.nrc > 0, 1)], else_=0)).label('nrc_count'),
                    func.sum(case([(clsd.mrc * clsd.mrc_number > 0, 1)], else_=0)).label('mrc_count'),
                    ]
                   ).where(clsd.invoice_number == self.invoice_number).group_by(clsd.invoice_number).alias('xsum')
        q = self.__table__.update().values(did_nrc=r.c.nrc, did_mrc=r.c.mrc,
                                           total_minutes=r.c.minutes, total_calls=r.c.attempts,
                                           current_charges=r.c.call_charge).where(
            InvoiceSummary.invoice_number == r.c.invoice_number)

        # print(str(q))
        ret = cls.session().execute(q)
        # print(ret)
        rec = cls.session().execute(r).first()
        if rec:
            self.data['acc_summary']['rec_charges'] = znr(rec.mrc)
            self.data['acc_summary']['non_rec_charges'] = znr(rec.nrc)
            items = []
            items.append(dict(name='inbound_call_charge', detail=znr(rec.minutes), charge=znr(rec.call_charge)))
            items.append(dict(name='mrc_charge', detail=znr(rec.mrc_count), charge=znr(rec.mrc)))
            items.append(dict(name='nrc_charge', detail=znr(rec.nrc_count), charge=znr(rec.nrc)))
            self.data['did_charge_summary'] = dict(items=items)
        # DidInvoiceChargeDetail ready
        qmrc = select([clsd.billing_plan_name.label('description'),
                       clsd.billing_plan_mrc_rate.label('rate'),
                       func.sum(clsd.mrc_number/60).label('quantity'),
                       func.sum(clsd.mrc * clsd.mrc_number).label('amount')
                       ]
                      ).where(and_(clsd.invoice_number == self.invoice_number,
                                   clsd.billing_plan_mrc_rate > 0)).group_by(clsd.client_billing_plan_id,
                                                                             clsd.billing_plan_name,
                                                                             clsd.billing_plan_mrc_rate)
        qmrc_data = cls.session().execute(qmrc)
        qmrc_list = []
        qmrc_total = 0.0
        for rec in qmrc_data:
            qmrc_list.append(
                dict(description=rec.description, rate=znr(rec.rate), quantity=rec.quantity, amount=znr(rec.amount)))
            qmrc_total += znr(rec.amount)
        self.data['rec_charge'] = dict(items=qmrc_list, total=qmrc_total)
        clsd.session().commit()
        self.update_did_invoice_port_charge()

    def update_non_rec_charge(self):
        self._update_did_invoice_charge_detail()
        clsd = DidInvoiceChargeDetail
        qnrc = select([clsd.billing_plan_name.label('description'),
                       clsd.billing_plan_nrc_rate.label('rate'),
                       func.sum(clsd.nrc).label('amount'),
                       func.sum(case([(clsd.nrc > 0, 1)], else_=0)).label('quantity')

                       ]
                      ).where(
            and_(clsd.invoice_number == self.invoice_number, clsd.billing_plan_nrc_rate > 0)).group_by(
            clsd.client_billing_plan_id, clsd.billing_plan_name, clsd.billing_plan_mrc_rate)
        qnrc_data = clsd.session().execute(qnrc)
        qnrc_list = []
        qnrc_total = 0.0
        for rec in qnrc_data:
            qnrc_list.append(
                dict(description=rec.description, rate=znr(rec.rate), quantity=rec.quantity, amount=znr(rec.amount)))
            qnrc_total += znr(rec.amount)
        self.data['non_rec_charge'] = dict(items=qnrc_list, total=qnrc_total)

    def update_did_charge_summary(self):
        self._update_did_invoice_charge_detail()
        clsd = DidInvoiceChargeDetail
        r = select([clsd.invoice_number.label('invoice_number'), func.sum(clsd.nrc).label('nrc'),
                    func.sum(clsd.mrc * clsd.mrc_number).label('mrc'), func.sum(clsd.minutes).label('minutes'),
                    func.sum(clsd.attempts).label('attempts'),
                    func.sum(clsd.call_charge).label('call_charge'),
                    func.count(clsd.did_number.distinct()).label('did_count'),
                    func.sum(case([(clsd.nrc > 0, 1)], else_=0)).label('nrc_count'),
                    func.sum(case([(clsd.mrc * clsd.mrc_number > 0, 1)], else_=0)).label('mrc_count'),
                    ]
                   ).where(clsd.invoice_number == self.invoice_number).group_by(clsd.invoice_number).alias('xsum')
        rec = clsd.session().execute(r).first()
        nrc_count_q = clsd.session().query(func.count(clsd.did_number.distinct()).label('did_count')). \
            filter(and_(clsd.invoice_number == self.invoice_number, clsd.mrc * clsd.mrc_number > 0)).first()
        nrc_count = nrc_count_q.did_count if nrc_count_q else 0
        mrc_count_q = clsd.session().query(func.count(clsd.did_number.distinct()).label('did_count')). \
            filter(and_(clsd.invoice_number == self.invoice_number, clsd.nrc > 0)).first()
        mrc_count = mrc_count_q.did_count if nrc_count_q else 0
        items = []
        if rec:
            items.append(
                dict(name='Inbound Traffic', detail='{:.0f} min '.format(rec.minutes), charge=znr(rec.call_charge)))
            items.append(dict(name='MRC', detail='{} Number'.format(mrc_count), charge=znr(rec.mrc)))
            items.append(dict(name='NRC', detail='{} Number'.format(nrc_count), charge=znr(rec.nrc)))
        if self.port_charges:
            cls = DidInvoicePortCharge
            s = cls.session().query(func.sum(cls.port_charge).label('port_charge'),
                                    func.sum(cls.max_channels).label('ports')).filter(
                cls.invoice_number == self.invoice_number).first()
            items.append(
                dict(name='port_charge', detail=zni(s.ports), charge=znr(s.port_charge)))
        total = sum([i['charge'] for i in items])
        items.append(
            dict(name='total', detail='', charge=total))
        self.data['did_charge_summary'] = dict(items=items)

    def update_did_charge_breakdown(self):
        self._update_did_invoice_charge_detail()
        clsd = DidInvoiceChargeDetail
        q = select([clsd.did_number.label('did'),
                    func.sum(clsd.nrc).label('nrc'), func.sum(clsd.mrc * clsd.mrc_number).label('mrc'),
                    func.sum(clsd.minutes).label('minutes'),
                    func.sum(clsd.attempts).label('attempts'),
                    func.sum(clsd.call_charge).label('call_charge')
                    ]
                   ).where(clsd.invoice_number == self.invoice_number).group_by(clsd.did_number)
        # print(str(q))
        did_charge_breakdown_data = clsd.session().execute(q)
        items = []
        total = dict(mrc=0, nrc=0.0, minutes=0.0, attempts=0.0, call_charge=0.0, total=0.0)
        for rec in did_charge_breakdown_data:
            new_item = dict(did=rec.did, nrc=znr(rec.nrc), mrc=znr(rec.mrc), minutes=zni(rec.minutes),
                            attempts=zni(rec.attempts), call_charge=znr(rec.call_charge),
                            total=znr(rec.nrc) + znr(rec.mrc) + znr(rec.call_charge))
            items.append(new_item)
            total = {k: total[k] + new_item[k] for k in total}

        self.data['did_charge_breakdown'] = dict(items=items, total=total)

    def _update_did_invoice_port_charge(self):
        if not hasattr(self, '_did_invoice_port_charge_updated'):
            qos = QosResource
            rel = DidRepository  # v6
            # rel = DidBillingBrief
            cls = DidInvoicePortCharge
            res = Resource
            trunks = [int(i) for i in self.client._trunks_orig_ids.split(',')] if self.client._trunks_orig_ids else []
            exists = cls.filter(cls.invoice_number == self.invoice_number).first()
            if exists is not None:
                cls.filter(cls.invoice_number == self.invoice_number).delete(synchronize_session='fetch')

            ret = cls.session().execute(cls.__table__.insert() \
                .from_select(
                ['invoice_number', 'client_trunk_id', 'billing_port_type', 'price_per_max_channel',
                 'price_per_actual_channel', 'cost_per_port', 'capacity', 'dnis_cap_limit'],
                select([literal(self.invoice_number), res.resource_id, res.billing_port_type, res.price_per_max_channel,
                        res.price_per_actual_channel, res.cost_per_port, res.capacity, res.dnis_cap_limit
                        ]
                       ).where(and_(res.resource_id.in_(trunks)))
            )
            )
            # print(ret)
            # 1.Bill by allowed total port
            q = cls.__table__.update().values(port_charge=cls.capacity * cls.cost_per_port
                                              ).where(and_(cls.invoice_number == self.invoice_number,
                                                           cls.billing_port_type == 'Bill by allowed total port'
                                                           ))
            # print(str(q))
            ret = cls.session().execute(q)
            # print(ret)
            # 2.Bill By allowed per DID port
            r = select([rel.client_trunk_id.label('res_id'), func.count(rel.did.distinct()).label('did_count')]). \
                where(rel.client_trunk_id.in_(trunks)).group_by(
                rel.client_trunk_id).alias('rep')
            q = cls.__table__.update().values(
                port_charge=cls.dnis_cap_limit * cls.price_per_actual_channel * r.c.did_count,
                did_count=r.c.did_count
            ).where(and_(cls.invoice_number == self.invoice_number,
                         cls.billing_port_type == 'Bill By allowed per DID port',
                         cls.client_trunk_id == r.c.res_id
                         ))
            # print(str(q))
            ret = cls.session().execute(q)
            # print(ret)
            # 3.Bill by max total port
            r = select([qos.res_id, func.max(qos.channels).label('channels')]). \
                where(and_(qos.report_time > self.invoice_start_time_tz,
                           qos.report_time <= self.invoice_end_time_tz,
                           qos.res_id.in_(trunks))).group_by(
                qos.res_id).alias('rep_qos')
            q = cls.__table__.update().values(port_charge=r.c.channels * cls.price_per_max_channel,
                                              max_channels=r.c.channels
                                              ).where(and_(cls.invoice_number == self.invoice_number,
                                                           cls.billing_port_type == 'Bill by max total port',
                                                           cls.client_trunk_id == r.c.res_id
                                                           ))
            # print(str(q))
            ret = cls.session().execute(q)
            cls = DidInvoicePortCharge

            s = cls.session().query(func.sum(cls.port_charge).label('port_charge'),
                                    func.sum(cls.max_channels).label('ports')).filter(
                cls.invoice_number == self.invoice_number).first()
            self.port_charges = s.port_charge if s is None else 0.0

            self._did_invoice_port_charge_updated = True
        else:
            pass

    def update_did_invoice_port_charge(self):
        self._update_did_invoice_port_charge()
        cls = DidInvoicePortCharge

        s = cls.session().query(func.sum(cls.port_charge).label('port_charge'),
                                func.sum(cls.max_channels).label('ports')).filter(
            cls.invoice_number == self.invoice_number).first()

        amount = znr(self.current_charges) + znr(self.did_nrc) + znr(self.did_mrc) + znr(self.port_charges)
        if self.task.include_tax:
            self.taxes = (znr(self.client.tax) / 100.0) * amount
            self.data['acc_summary']['tax'] = znr(self.taxes)
        self.total_amount = abs(amount + znr(self.taxes))
        log.debug('update_did_invoice_port_charge. total_amount: {}. tax: {}'.format(self.total_amount, self.data['acc_summary']['tax']))
        cls.session().add(self)
        cls.session().commit()

    def update_summary_of_charges(self):
        api = StatisticAPI()
        res = []
        if self.client._trunks_term_ids:
            res = api.run(start_time=self.start_time, end_time=self.end_time,
                          field='not_zero_calls,ingress_bill_time,ingress_call_cost',
                          non_zero_calls='1',
                          ingress_id=self.client._trunks_term_ids,
                          ignore_users_limit=True
                          )
        items = []
        total = dict(calls=0, minutes=0.0, amount=0.0)
        if res:
            for r in res:
                new_item = dict(calls=r['not_zero_calls'],
                                minutes=zni(r['ingress_bill_time'] / 60.0),
                                amount=znr(r['ingress_call_cost']))
                items.append(new_item)
                total = {k: total[k] + new_item[k] for k in total}
        self.data['summary_of_charges'] = dict(items=items, total=total)

    def update_usage_charge(self):
        out_trunks = [str(r.resource_id) for r in
                      Resource.session().query(Resource.resource_id, Resource.client_id, Resource.trunk_type2). \
                        filter(and_(Resource.client_id == self.client_id, Resource.trunk_type2 == 0)).all()]
        in_trunks = [str(r.resource_id) for r in
                     Resource.session().query(Resource.resource_id, Resource.client_id, Resource.trunk_type2). \
                        filter(and_(Resource.client_id == self.client_id, Resource.trunk_type2 == 1)).all()]

        api = StatisticAPI()
        out_res = []
        if self.client._trunks_term_ids:
            out_res = api.run(start_time=self.start_time, end_time=self.end_time,
                              field='not_zero_calls,ingress_bill_time,ingress_call_cost',
                              non_zero_calls='1',
                              ingress_id=self.client._trunks_term_ids,
                              ignore_users_limit=True
                              )
        in_res = []
        if self.client._trunks_orig_ids:
            in_res = api.run(start_time=self.start_time, end_time=self.end_time,
                             field='not_zero_calls,egress_bill_time,egress_call_cost',
                             non_zero_calls='1',
                             egress_id=self.client._trunks_orig_ids,
                             ignore_users_limit=True
                             )
        usage_items = []
        total = dict(calls=0, minutes=0.0, amount=0.0)
        if out_res:
            r = out_res[0]
            new_item=dict(description='Outbound traffic', calls=r['not_zero_calls'],
                                    minutes=zni(r['ingress_bill_time'] / 60.0),
                                    amount=znr(r['ingress_call_cost']))
            usage_items.append(new_item)
            total = {k: total[k] + new_item[k] for k in total}
            self.total_calls = zni(r['not_zero_calls'])
            self.total_minutes = round(r['ingress_bill_time'] / 60.0, 2)
        if in_res:
            r = in_res[0]
            new_item=dict(description='Inbound traffic', calls=r['not_zero_calls'],
                                    minutes=zni(r['egress_bill_time'] / 60.0),
                                    amount=znr(r['egress_call_cost']))
            usage_items.append(new_item)
            total = {k: total[k] + new_item[k] for k in total}
            self.current_charges = znr(r['egress_call_cost'])
        if self.task.show_usage_charge:
            self.data['usage_charge'] = dict(items=usage_items, total=total)

        self.data['acc_summary']['usage_charges'] = total['amount']

    def update_trunk_detail(self):
        trunks = [str(r.resource_id) for r in
                  Resource.session().query(Resource.resource_id, Resource.client_id, Resource.rating_type). \
                    filter(and_(Resource.client_id == self.client_id, Resource.rating_type > 0)).all()]

        api = StatisticAPI()
        res = []
        if self.client._trunks_term_az_ids:
            res = api.run(start_time=self.start_time, end_time=self.end_time,
                          field='not_zero_calls,ingress_bill_time,ingress_call_cost',
                          non_zero_calls='1',
                          ingress_id=self.client._trunks_term_az_ids,
                          group='ingress_id',
                          ignore_users_limit=True
                          )
        items = []
        total = dict(calls=0, minutes=0.0, amount=0.0)
        if res:
            for r in res:
                new_item = dict(trunk=r['ingress_name'], calls=r['not_zero_calls'],
                                minutes=zni(r['ingress_bill_time'] / 60.0),
                                amount=znr(r['ingress_call_cost']))
                items.append(new_item)
                total = {k: total[k] + new_item[k] for k in total}
        self.data['trunk_detail'] = dict(items=items, total=total)

    def update_daily_summary(self):
        "daily_summary A-Z trunks"
        trunks = [str(r.resource_id) for r in
                  Resource.session().query(Resource.resource_id, Resource.client_id, Resource.rating_type). \
                    filter(and_(Resource.client_id == self.client_id, Resource.rating_type > 0)).all()]
        api = StatisticAPI()
        res = []
        if self.client._trunks_term_ids:
            res = api.run(start_time=self.start_time, end_time=self.end_time,
                          field='not_zero_calls,ingress_bill_time,ingress_call_cost',
                          non_zero_calls='1',
                          ingress_id=self.client._trunks_term_ids,
                          step='day',
                          ignore_users_limit=True
                          )
        items = []
        total = dict(calls=0, minutes=0.0, amount=0.0)
        if res:
            for r in res:
                new_item = dict(date=tmstmp2date(r['report_time']), calls=r['not_zero_calls'],
                                minutes=zni(r['ingress_bill_time'] / 60.0),
                                amount=znr(r['ingress_call_cost']))
                items.append(new_item)
                total = {k: total[k] + new_item[k] for k in total}

        self.data['daily_summary'] = dict(items=items, total=total)

    def update_jd_trunk_detail(self):
        "detail of US JD trunks"
        trunks = [str(r.resource_id) for r in
                  Resource.session().query(Resource.resource_id, Resource.client_id, Resource.rating_type). \
                    filter(and_(Resource.client_id == self.client_id, Resource.rating_type == 0)).all()]

        api = StatisticAPI()
        res = []
        if self.client._trunks_term_us_ids:
            res = api.run(start_time=self.start_time, end_time=self.end_time,
                          field='not_zero_calls,inter_not_zero_calls,intra_not_zero_calls,ingress_bill_time,ingress_call_cost,ingress_bill_time_intra,ingress_call_cost_intra,ingress_bill_time_inter,ingress_call_cost_inter',
                          group='ingress_id', non_zero_calls='1',
                          ingress_id=self.client._trunks_term_us_ids,
                          ignore_users_limit=True
                          )
        items = []
        total = dict(total_calls=0, total_minutes=0, total_amount=0.0, inter_calls=0, intra_calls=0,
                     ij_calls=0, inter_minutes=0, intra_minutes=0, ij_minutes=0, inter_amount=0.0,
                     intra_amount=0.0, ij_amount=0.0)
        if res:
            for item in res:
                new_item = dict(trunk=item['ingress_name'],
                                # trunk_id=item['ingress_id'],
                                total_calls=zni(item['not_zero_calls']),
                                total_minutes=zni(item['ingress_bill_time'] / 60),
                                total_amount=znr(item['ingress_call_cost']),
                                inter_calls=item['inter_not_zero_calls'],
                                intra_calls=item['intra_not_zero_calls'],
                                ij_calls=item['not_zero_calls'] - item['inter_not_zero_calls'] - item[
                                    'intra_not_zero_calls'],
                                inter_minutes=zni(item['ingress_bill_time_inter'] / 60),
                                intra_minutes=zni(item['ingress_bill_time_intra'] / 60),
                                ij_minutes=zni(
                                    (item['ingress_bill_time'] - item['ingress_bill_time_inter'] - item[
                                        'ingress_bill_time_intra']) / 60),
                                inter_amount=znr(item['ingress_call_cost_inter']),
                                intra_amount=znr(item['ingress_call_cost_intra']),
                                ij_amount=znr(zn(item['ingress_call_cost']) - zn(
                                    item['ingress_call_cost_inter']) - zn(
                                    item[
                                        'ingress_call_cost_intra'])),
                                )
                items.append(new_item)
                total = {k: total[k] + new_item[k] for k in total}

        self.data['jd_trunk_detail'] = dict(items=items, total=total)

    def update_jd_daily_summary(self):
        "daily_summary US JD trunks"
        trunks = [str(r.resource_id) for r in
                  Resource.session().query(Resource.resource_id, Resource.client_id). \
                    filter(and_(Resource.client_id == self.client_id, Resource.rating_type == 0)).all()]

        api = StatisticAPI()
        res = []
        if self.client._trunks_term_us_ids:
            res = api.run(start_time=self.start_time, end_time=self.end_time,
                          field='not_zero_calls,inter_not_zero_calls,intra_not_zero_calls,ingress_bill_time,ingress_call_cost,ingress_bill_time_intra,ingress_call_cost_intra,ingress_bill_time_inter,ingress_call_cost_inter',
                          non_zero_calls='1',
                          ingress_id=self.client._trunks_term_us_ids,
                          step='day',
                          ignore_users_limit=True
                          )
        items = []
        total = dict(total_calls=0, total_minutes=0, total_amount=0.0, inter_calls=0, intra_calls=0,
                     ij_calls=0, inter_minutes=0, intra_minutes=0, ij_minutes=0, inter_amount=0.0,
                     intra_amount=0.0, ij_amount=0.0)
        if res:
            for item in res:
                new_item = dict(date=tmstmp2date(item['report_time']),
                                # trunk_id=item['ingress_id'],
                                total_calls=zni(item['not_zero_calls']),
                                total_minutes=zni(item['ingress_bill_time'] / 60),
                                total_amount=znr(item['ingress_call_cost']),
                                inter_calls=item['inter_not_zero_calls'],
                                intra_calls=item['intra_not_zero_calls'],
                                ij_calls=item['not_zero_calls'] - item['inter_not_zero_calls'] - item[
                                    'intra_not_zero_calls'],
                                inter_minutes=zni(item['ingress_bill_time_inter'] / 60),
                                intra_minutes=zni(item['ingress_bill_time_intra'] / 60),
                                ij_minutes=zni(
                                    (item['ingress_bill_time'] - item['ingress_bill_time_inter'] - item[
                                        'ingress_bill_time_intra']) / 60),
                                inter_amount=znr(item['ingress_call_cost_inter']),
                                intra_amount=znr(item['ingress_call_cost_intra']),
                                ij_amount=znr(item['ingress_call_cost']) - zn(
                                    item['ingress_call_cost_inter']) - zn(
                                    item[
                                        'ingress_call_cost_intra']),
                                )
                items.append(new_item)
                total = {k: total[k] + new_item[k] for k in total}

        self.data['jd_daily_summary'] = dict(items=items, total=total)

    def update_prefix_summary(self):
        trunks = [str(r.resource_id) for r in
                  Resource.session().query(Resource.resource_id, Resource.client_id). \
                    filter(and_(Resource.client_id == self.client_id)).all()]

        api = StatisticAPI()
        res = []
        if self.client._trunks_term_ids:
            res = api.run(start_time=self.start_time, end_time=self.end_time,
                          field='not_zero_calls,ingress_bill_time,ingress_call_cost',
                          non_zero_calls='1',
                          ingress_id=self.client._trunks_term_ids,
                          group='ingress_id,ingress_prefix',
                          ignore_users_limit=True
                          )
        items = []
        total = dict(calls=0, minutes=0.0, amount=0.0)
        if res:
            for r in res:
                new_item = dict(trunk=r['ingress_name'], prefix=r['ingress_prefix'], calls=zni(r['not_zero_calls']),
                                minutes=zni(r['ingress_bill_time'] / 60.0),
                                amount=znr(r['ingress_call_cost']))
                items.append(new_item)
                total = {k: total[k] + new_item[k] for k in total}
        self.data['prefix_summary'] = dict(items=items, total=total)

    def update_code_name_summary(self):
        trunks = [str(r.resource_id) for r in
                  Resource.session().query(Resource.resource_id, Resource.client_id). \
                    filter(and_(Resource.client_id == self.client_id)).all()]

        api = StatisticAPI()
        res = []
        if self.client._trunks_term_ids:
            res = api.run(start_time=self.start_time, end_time=self.end_time,
                          field='not_zero_calls,ingress_bill_time,ingress_call_cost',
                          non_zero_calls='1',
                          ingress_id=self.client._trunks_term_ids,
                          group='ingress_country,ingress_code_name',
                          ignore_users_limit=True
                          )
        items = []
        total = dict(calls=0, minutes=0, amount=0.0)
        if res:
            for r in res:
                new_item = dict(country=r['ingress_country'], code_name=r['ingress_code_name'],
                                calls=zni(r['not_zero_calls']),
                                minutes=zni(r['ingress_bill_time'] / 60.0),
                                amount=znr(r['ingress_call_cost']))
                items.append(new_item)
                total = {k: total[k] + new_item[k] for k in total}

        self.data['code_name_summary'] = dict(items=items, total=total)

    def update_country_summary(self):
        trunks = [str(r.resource_id) for r in
                  Resource.session().query(Resource.resource_id, Resource.client_id). \
                    filter(and_(Resource.client_id == self.client_id)).all()]

        api = StatisticAPI()
        res = []
        if self.client._trunks_term_ids:
            res = api.run(start_time=self.start_time, end_time=self.end_time,
                          field='not_zero_calls,ingress_bill_time,ingress_call_cost',
                          non_zero_calls='1',
                          ingress_id=self.client._trunks_term_ids,
                          group='ingress_country',
                          ignore_users_limit=True
                          )
        items = []
        total = dict(calls=0, minutes=0, amount=0.0)
        if res:
            for r in res:
                new_item = dict(country=r['ingress_country'], calls=zni(r['not_zero_calls']),
                                minutes=zni(r['ingress_bill_time'] / 60.0),
                                amount=znr(r['ingress_call_cost']))
                items.append(new_item)
                total = {k: total[k] + new_item[k] for k in total}

        self.data['country_summary'] = dict(items=items, total=total)

    def update_top_100tn_summary(self):
        cls = DidInvoiceChargeBreakdown
        clsd = DidInvoiceChargeDetail
        rel = DidBillingRel  # v6
        # rel = DidBillingBrief
        pln = DidBillingPlan
        rep = DidReport

        if self.client.is_term:
            self.data['top_100tn_summary'] = None
            return None    
        q = rep.session().query(rep.did, func.sum(rep.not_zero_calls).label('calls'),
                                func.sum(rep.egress_bill_time / 60.0).label('minutes'),
                                func.sum(rep.egress_call_cost).label('amount'),
                                func.sum(rep.egress_call_cost / (rep.egress_bill_time / 60.0)).label('rate')).filter(
            and_(rep.egress_bill_time > 0,
                 rep.report_time > self.invoice_start_time_tz,
                 rep.report_time <= self.invoice_end_time_tz,
                 rep.egress_client_id == self.client_id)).group_by(rep.did).order_by(
            func.sum(rep.egress_call_cost).desc()).limit(100)
        items = []
        total = dict(calls=0.0, minutes=0, rate=0.0, amount=0.0)
        for r in q:
            new_item = dict(number=r.did, calls=r.calls,
                            minutes=zni(r.minutes),
                            rate=znr(r.rate),
                            amount=znr(r.amount))
            items.append(new_item)
            total = {k: total[k] + new_item[k] for k in total}

        self.data['top_100tn_summary'] = dict(items=items, total=total)

    def update_inbound_summary(self):
        "daily_summary inbound"
        start = timer()
        trunks = [str(r.resource_id) for r in
                  Resource.session().query(Resource.resource_id, Resource.client_id). \
                    filter(and_(Resource.client_id == self.client_id)).all()]
        api = StatisticAPI()
        res = []
        if trunks:
            res = api.run(start_time=self.start_time, end_time=self.end_time,
                          field='not_zero_calls,ingress_bill_time,ingress_call_cost',
                          non_zero_calls='1',
                          ingress_client_id=str(self.client_id),
                          step='day',
                          ignore_users_limit=True
                          )
        items = []
        total = dict(calls=0.0, minutes=0, amount=0.0)
        if res:
            for r in res:
                new_item = dict(date=tmstmp2date(r['report_time']), calls=r['not_zero_calls'],
                                minutes=zni(r['ingress_bill_time'] / 60.0),
                                amount=znr(r['ingress_call_cost']))
                items.append(new_item)
                total = {k: total[k] + new_item[k] for k in total}
        items.sort(key=lambda item: item['date'], reverse=True)
        self.data['inbound_summary'] = dict(items=items, total=total)

    def update(self):
        try:
            log.debug('start update InvoiceSummaryGenerator. client_id: {}'.format(self.client_id))
            if not self.task:
                raise Exception('invoice summary  task_id not assigned')
            if not self.client:
                raise Exception('invoice summary  client not assigned')
            #pre check
            no_parts = True
            for part in (
                         'acc_summary', 'payment_applied', 'rec_charge', 'non_rec_charge', 'usage_charge',
                         'trunk_detail', 'daily_summary', 'jd_daily_summary', 'jd_trunk_detail', 'prefix_summary',
                         'code_name_summary',
                         'country_summary',
                         'top_100tn_summary',
                         'inbound_summary',
                         'did_charge_summary',
                         'did_charge_breakdown',
                         'summary_of_charges',
                         'scc_charges'
                         ):
                # 'trunk_detail',

                if getattr(self.task, 'show_{}'.format(part)):
                    no_parts = False
            if no_parts:
                setattr(self.task, 'show_usage_charge', True)
                #setattr(self.task, 'show_summary_of_charges', True)
                self.task.save()
            log.debug('start update parts')
            for part in ('client_data',
                         'acc_summary', 'payment_applied', 'rec_charge', 'non_rec_charge', 'usage_charge',
                         'trunk_detail', 'daily_summary', 'jd_daily_summary', 'jd_trunk_detail', 'prefix_summary',
                         'code_name_summary',
                         'country_summary',
                         'top_100tn_summary',
                         'inbound_summary',
                         'did_charge_summary',
                         'did_charge_breakdown',
                         #  'summary_of_charges',
                         'scc_charges'
                         ):
                log.debug('update part {}'.format(part))
                # 'trunk_detail',
                try:
                    if getattr(self.task, 'show_{}'.format(part)):
                        getattr(self, 'update_{}'.format(part))()
                        log.debug('invoice summary successfull part {}'.format(part))
                    else:
                        if not part == 'acc_summary':
                            if part in self.data:
                                del self.data[part]
                                log.debug('invoice summary disabled part {}'.format(part))
                except pgerrors.InFailedSqlTransaction as e:
                    log.debug('invoice summary failed part {} error:{}'.format(part, e))
                    self.session().rollback()
                except Exception as e:
                    log.debug('invoice summary failed part {} error:{}'.format(part, e))
            log.debug('end update parts')
            if 'acc_summary' in self.data:
                total_charges = znr(sum([self.data['acc_summary'][k] for k in (
                    'finance_charges', 'other_charges', 'scc_charges', 'rec_charges',
                    'non_rec_charges', 'usage_charges', 'tax') if k in self.data['acc_summary']
                                         ]))
                if self.task.include_tax:
                    self.taxes = (znr(self.client.tax) / 100.0) * total_charges
                    self.data['acc_summary']['tax'] = znr(self.taxes)
                self.data['acc_summary']['total_charges'] = total_charges
                if 'total_amount' not in self.data['acc_summary'] or not self.data['acc_summary']['total_amount']:
                    self.data['acc_summary']['total_amount'] = total_charges
                self.total_amount = self.data['acc_summary']['total_amount'] if 'total_amount' in self.data[
                    'acc_summary'] else 0.0
                self.current_charges = total_charges
            self.json_content = self.data
            log.debug('end update InvoiceSummaryGenerator. client_id: {}'.format(self.client_id))
        except Exception as e:
            if hasattr(self, 'data'):
                self.json_content = self.data
            log.debug('invoice summary general error:{}'.format(e))
            raise e


# endregion body

if __name__ == '__main__':
    init_db()
    # init_db(conn_string='postgresql://postgres:password@127.0.0.1:5434/softswitch4v5')
    # gen = InvoiceSummaryGenerator.get(3506)
    gen = InvoiceSummaryGenerator.get(6411)
    for part in (
            'acc_summary',
            'payment_applied',
            'rec_charge',
            'non_rec_charge',
            'usage_charge',
            'trunk_detail',
            'daily_summary',
            'jd_daily_summary',
            'jd_trunk_detail',
            'prefix_summary',
            'code_name_summary',
            'country_summary',
            'top_100tn_summary',
            'inbound_summary',
            'did_charge_summary',
            'did_charge_breakdown'
    ):
        setattr(gen.task, 'show_{}'.format(part), True)

    gen.update()
    gen.save()
    gen.create_invoice()
    # query_did_charge('2020-01-01','2020-04-02 23:59:59','4881',None,'15647643333')

