"""dnl_cloud_v2

Revision ID: 1de7138026d5
Revises: b8aaeccf0099
Create Date: 2020-02-19 20:06:18.812127

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '1de7138026d5'
down_revision = 'b8aaeccf0099'
branch_labels = None
depends_on = None


def upgrade():
    connection = op.get_bind()
    
    for table in ['dnl_cloud_sftp_cfg', 'dnl_cloud_gcloud_cfg', 'dnl_cloud_ftp_cfg', 'dnl_cloud_dbman_cfg',
                  'dnl_cloud_storages', 'dnl_cloud_status',  'dnl_cloud_search_cfg',    'dnl_cloud_log',
                  'dnl_cloud_downloader_cfg']:
        connection.execute("drop table if exists {};".format(table))
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('dnl_cloud_downloader_cfg',
    sa.Column('server_name', sa.String(length=256), nullable=False),
    sa.Column('server_use_ssl', sa.Boolean(), server_default='false', nullable=True),
    sa.Column('server_ip', sa.String(length=16), server_default=sa.text('NULL::character varying'), nullable=True),
    sa.Column('server_port', sa.Integer(), nullable=True),
    sa.Column('server_ip_whitelist', sa.Text(), nullable=True),
    sa.Column('server_ip_blacklist', sa.Text(), nullable=True),
    sa.Column('server_con_limit', sa.Integer(), nullable=True),
    sa.Column('server_per_ip_con_limit', sa.Integer(), nullable=True),
    sa.Column('server_con_timeout', sa.Integer(), nullable=True),
    sa.Column('log_level', sa.Integer(), server_default=sa.text('0'), nullable=True),
    sa.Column('log_dir_path', sa.Text(), nullable=True),
    sa.Column('disable_logfile', sa.Boolean(), server_default=sa.text('false'), nullable=True),
    sa.Column('enable_postgresql_log', sa.Boolean(), server_default=sa.text('false'), nullable=True),
    sa.Column('tmp_dir_path', sa.Text(), nullable=True),
    sa.Column('disable_tmp_dir', sa.Boolean(), server_default=sa.text('false'), nullable=True),
    sa.CheckConstraint("(log_level >= '-1'::integer) AND (log_level < 3)"),
    sa.CheckConstraint('((server_ip_whitelist IS NOT NULL) AND (server_ip_blacklist IS NOT NULL)) IS FALSE'),
    sa.CheckConstraint('(server_port > 0) AND (server_port < 65536)'),
    sa.CheckConstraint('server_con_limit > 0'),
    sa.CheckConstraint('server_con_timeout > 0'),
    sa.CheckConstraint('server_per_ip_con_limit > 0'),
    sa.PrimaryKeyConstraint('server_name')
    )
    op.create_table('dnl_cloud_log',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('time', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
    sa.Column('instance', sa.String(length=128), nullable=True),
    sa.Column('level', sa.String(length=16), nullable=False),
    sa.Column('msg', sa.Text(), nullable=False),
    sa.CheckConstraint("(btrim((instance)::text) = ''::text) IS FALSE"),
    sa.CheckConstraint("(btrim((level)::text) = ''::text) IS FALSE"),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('dnl_cloud_search_cfg',
    sa.Column('server_name', sa.String(length=256), nullable=False),
    sa.Column('server_use_ssl', sa.Boolean(), server_default='false', nullable=True),
    sa.Column('pcap_time_margin', sa.Integer(), nullable=True),
    sa.Column('req_exp_time', sa.Integer(), nullable=True),
    sa.Column('threads_max', sa.Integer(), nullable=True),
    sa.Column('server_ip', sa.String(length=16), server_default=sa.text('NULL::character varying'), nullable=True),
    sa.Column('server_port', sa.Integer(), nullable=True),
    sa.Column('server_ip_whitelist', sa.Text(), nullable=True),
    sa.Column('server_ip_blacklist', sa.Text(), nullable=True),
    sa.Column('server_con_limit', sa.Integer(), nullable=True),
    sa.Column('server_per_ip_con_limit', sa.Integer(), nullable=True),
    sa.Column('server_con_timeout', sa.Integer(), nullable=True),
    sa.Column('log_level', sa.Integer(), server_default=sa.text('0'), nullable=True),
    sa.Column('log_dir_path', sa.Text(), nullable=True),
    sa.Column('disable_logfile', sa.Boolean(), server_default=sa.text('false'), nullable=True),
    sa.Column('enable_postgresql_log', sa.Boolean(), server_default=sa.text('false'), nullable=True),
    sa.Column('tmp_dir_path', sa.Text(), nullable=True),
    sa.CheckConstraint("(log_level >= '-1'::integer) AND (log_level < 3)"),
    sa.CheckConstraint('((server_ip_whitelist IS NOT NULL) AND (server_ip_blacklist IS NOT NULL)) IS FALSE'),
    sa.CheckConstraint('(server_port > 0) AND (server_port < 65536)'),
    sa.CheckConstraint('pcap_time_margin >= 0'),
    sa.CheckConstraint('req_exp_time >= 0'),
    sa.CheckConstraint('server_con_limit > 0'),
    sa.CheckConstraint('server_con_timeout > 0'),
    sa.CheckConstraint('server_per_ip_con_limit > 0'),
    sa.CheckConstraint('threads_max >= 0'),
    sa.PrimaryKeyConstraint('server_name')
    )
    op.create_table('dnl_cloud_status',
    sa.Column('server_name', sa.String(length=256), nullable=False),
    sa.Column('instance', sa.String(length=128), nullable=False),
    sa.Column('operation', sa.Text(), nullable=True),
    sa.Column('is_online', sa.Boolean(), server_default='false', nullable=True),
    sa.Column('upd_time', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
    sa.Column('server_ip', sa.String(length=16), server_default=sa.text('NULL::character varying'), nullable=True),
    sa.Column('server_port', sa.Integer(), nullable=True),
    sa.Column('server_use_ssl', sa.Boolean(), server_default='false', nullable=True),
    sa.Column('switch_list', sa.Text(), server_default='NULL', nullable=True),
    sa.CheckConstraint("(TRIM(server_ip) = '') IS FALSE"),
    sa.CheckConstraint('(server_port > 0) AND (server_port < 65536)'),
    sa.PrimaryKeyConstraint('server_name', 'instance')
    )
    op.create_table('dnl_cloud_storages',
    sa.Column('uuid', sa.String(length=36), nullable=False),
    sa.Column('type', sa.String(length=16), nullable=True),
    sa.CheckConstraint("((type)::text = 'ftp'::text) OR ((type)::text = 'sftp'::text) OR ((type)::text = 'gcloud'::text)"),
    sa.CheckConstraint("(btrim(uuid) = ''::text) IS FALSE"),
    sa.PrimaryKeyConstraint('uuid')
    )
    op.create_table('dnl_cloud_dbman_cfg',
    sa.Column('server_name', sa.String(length=256), nullable=False),
    sa.Column('server_use_ssl', sa.Boolean(), server_default='false', nullable=True),
    sa.Column('cdr_storage_cfg_uuid', sa.String(length=36), nullable=True),
    sa.Column('pcap_storage_cfg_uuid', sa.String(length=36), nullable=True),
    sa.Column('keep_cdr', sa.Integer(), nullable=True),
    sa.Column('keep_pcap', sa.Integer(), nullable=True),
    sa.Column('keep_cdr_archives', sa.Integer(), nullable=True),
    sa.Column('keep_pcap_archives', sa.Integer(), nullable=True),
    sa.Column('keep_cdr_remote', sa.Integer(), nullable=True),
    sa.Column('keep_pcap_remote', sa.Integer(), nullable=True),
    sa.Column('hourly_cdr_backup', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('server_ip', sa.String(length=16), server_default=sa.text('NULL::character varying'), nullable=True),
    sa.Column('server_port', sa.Integer(), nullable=True),
    sa.Column('server_ip_whitelist', sa.Text(), nullable=True),
    sa.Column('server_ip_blacklist', sa.Text(), nullable=True),
    sa.Column('server_con_limit', sa.Integer(), nullable=True),
    sa.Column('server_per_ip_con_limit', sa.Integer(), nullable=True),
    sa.Column('server_con_timeout', sa.Integer(), nullable=True),
    sa.Column('log_level', sa.Integer(), server_default=sa.text('0'), nullable=True),
    sa.Column('log_dir_path', sa.Text(), nullable=True),
    sa.Column('disable_logfile', sa.Boolean(), server_default=sa.text('false'), nullable=True),
    sa.Column('enable_postgresql_log', sa.Boolean(), server_default=sa.text('false'), nullable=True),
    sa.Column('tmp_dir_path', sa.Text(), nullable=True),
    sa.Column('disable_tmp_dir', sa.Boolean(), server_default=sa.text('false'), nullable=True),
    sa.Column('startup_delay', sa.Integer(), nullable=True),
    sa.Column('run_on_start', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.CheckConstraint("(log_level >= '-1'::integer) AND (log_level < 3)"),
    sa.CheckConstraint('((server_ip_whitelist IS NOT NULL) AND (server_ip_blacklist IS NOT NULL)) IS FALSE'),
    sa.CheckConstraint('(server_port > 0) AND (server_port < 65536)'),
    sa.CheckConstraint('(startup_delay >= 0) AND (startup_delay < 86400)'),
    sa.CheckConstraint('keep_cdr > 0'),
    sa.CheckConstraint('keep_cdr_archives > 0'),
    sa.CheckConstraint('keep_cdr_remote > 0'),
    sa.CheckConstraint('keep_pcap > 0'),
    sa.CheckConstraint('keep_pcap_archives > 0'),
    sa.CheckConstraint('keep_pcap_remote > 0'),
    sa.CheckConstraint('server_con_limit > 0'),
    sa.CheckConstraint('server_con_timeout > 0'),
    sa.CheckConstraint('server_per_ip_con_limit > 0'),
    sa.ForeignKeyConstraint(['cdr_storage_cfg_uuid'], ['dnl_cloud_storages.uuid'], ),
    sa.ForeignKeyConstraint(['pcap_storage_cfg_uuid'], ['dnl_cloud_storages.uuid'], ),
    sa.PrimaryKeyConstraint('server_name')
    )
    op.create_table('dnl_cloud_ftp_cfg',
    sa.Column('uuid', sa.String(length=36), nullable=False),
    sa.Column('ip', sa.String(length=16), nullable=False),
    sa.Column('port', sa.Integer(), nullable=False),
    sa.Column('username', sa.Text(), nullable=True),
    sa.Column('password', sa.Text(), nullable=True),
    sa.Column('workdir', sa.Text(), nullable=True),
    sa.Column('use_relative_paths', sa.Boolean(), server_default=sa.text('false'), nullable=True),
    sa.Column('netrc_path', sa.Text(), nullable=True),
    sa.Column('debug', sa.Integer(), nullable=True),
    sa.CheckConstraint("((btrim(username) = 'anonymous'::text) AND (password IS NULL)) OR (((btrim(username) = ''::text) IS FALSE) AND ((btrim(password) = ''::text) IS FALSE)) OR ((username IS NULL) AND (password IS NULL) AND ((btrim(netrc_path) = ''::text) IS FALSE))"),
    sa.CheckConstraint("(btrim((ip)::text) = ''::text) IS FALSE"),
    sa.CheckConstraint('(debug >= 0) AND (debug < 3)'),
    sa.CheckConstraint('(port > 0) AND (port < 65536)'),
    sa.ForeignKeyConstraint(['uuid'], ['dnl_cloud_storages.uuid'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('uuid')
    )
    op.create_table('dnl_cloud_gcloud_cfg',
    sa.Column('uuid', sa.String(length=36), nullable=False),
    sa.Column('type', sa.String(length=16), nullable=False),
    sa.Column('bucket', sa.Text(), nullable=False),
    sa.Column('workdir', sa.Text(), nullable=True),
    sa.Column('key_file_path', sa.Text(), nullable=True),
    sa.Column('email', sa.Text(), nullable=True),
    sa.Column('secret', sa.Text(), nullable=True),
    sa.Column('token', sa.Text(), nullable=True),
    sa.Column('debug', sa.Integer(), nullable=True),
    sa.CheckConstraint("(((type)::text = 'service'::text) AND ((btrim(key_file_path) = ''::text) IS FALSE)) OR (((type)::text = 'oauth2'::text) AND ((btrim(email) = ''::text) IS FALSE) AND ((btrim(secret) = ''::text) IS FALSE) AND ((btrim(token) = ''::text) IS FALSE))"),
    sa.CheckConstraint("(btrim(bucket) = ''::text) IS FALSE"),
    sa.CheckConstraint('(debug >= 0) AND (debug < 3)'),
    sa.ForeignKeyConstraint(['uuid'], ['dnl_cloud_storages.uuid'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('uuid')
    )
    op.create_table('dnl_cloud_sftp_cfg',
    sa.Column('uuid', sa.String(length=36), nullable=False),
    sa.Column('ip', sa.String(length=16), nullable=False),
    sa.Column('port', sa.Integer(), nullable=False),
    sa.Column('username', sa.Text(), nullable=True),
    sa.Column('password', sa.Text(), nullable=True),
    sa.Column('workdir', sa.Text(), nullable=True),
    sa.Column('pubkey_path', sa.Text(), nullable=True),
    sa.Column('privkey_path', sa.Text(), nullable=True),
    sa.Column('passphrase', sa.Text(), nullable=True),
    sa.Column('debug', sa.Integer(), nullable=True),
    sa.CheckConstraint("(((btrim(username) = ''::text) IS FALSE) AND ((btrim(password) = ''::text) IS FALSE)) OR ((username IS NULL) AND (password IS NULL) AND ((btrim(privkey_path) = ''::text) IS FALSE))"),
    sa.CheckConstraint("(btrim((ip)::text) = ''::text) IS FALSE"),
    sa.CheckConstraint('(debug >= 0) AND (debug < 3)'),
    sa.CheckConstraint('(port > 0) AND (port < 65536)'),
    sa.ForeignKeyConstraint(['uuid'], ['dnl_cloud_storages.uuid'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('uuid')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('dnl_cloud_sftp_cfg')
    op.drop_table('dnl_cloud_gcloud_cfg')
    op.drop_table('dnl_cloud_ftp_cfg')
    op.drop_table('dnl_cloud_dbman_cfg')
    op.drop_table('dnl_cloud_storages')
    op.drop_table('dnl_cloud_status')
    op.drop_table('dnl_cloud_search_cfg')
    op.drop_table('dnl_cloud_log')
    op.drop_table('dnl_cloud_downloader_cfg')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))