"""Backend schema release 7.4.9 (418d0a2c1c)

Revision ID: 42365ac26f14
Revises: dd2a2939b19a
Create Date: 2025-09-02 23:27:49.820275

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os


# revision identifiers, used by Alembic.
revision = '42365ac26f14'
down_revision = 'dd2a2939b19a'
branch_labels = None
depends_on = None


def upgrade():
    upgrade_sql = """
BEGIN;

/* [CLAS6-29806]: Do not break active calls when balance goes negative */
ALTER TABLE client ADD COLUMN break_call_on_no_balance boolean NOT NULL DEFAULT true;

/* [CLAS6-29910]: P-Access-Network-Info header */
ALTER TABLE resource ADD COLUMN pani smallint;
COMMENT ON COLUMN resource.pani IS
'0 - Drop; 1 - Pass Through; 2 - Always (use text from resource.pani_value)';
ALTER TABLE resource ADD COLUMN pani_value text;

/* [CLAS6-29910]: P-Charge-Info header */
COMMENT ON COLUMN resource.pci IS '0 - Drop; 1 - Pass Through; 2 - Always';

/* [SIPSWITCH-614]: Add "enabled" flag to random ANI generation table */
ALTER TABLE random_ani_generation ADD COLUMN enabled boolean NOT NULL DEFAULT true;

/* [CLAS6-29911]: Verify STIR/SHAKEN only for selected countries */
COMMENT ON COLUMN resource.shaken_vfy_us_ca_only IS 'DEPRECATED';
ALTER TABLE resource ADD COLUMN shaken_vfy_countries text;
COMMENT ON COLUMN resource.shaken_vfy_countries IS 'Comma-separated list of countries';

/* Version 7.4.9 */
UPDATE c4db_version SET version_num = '418d0a2c1c9f14eb1280b57426dfaf6d', tag = '7.4.9';

END;
"""
    connection = op.get_bind()
    connection.execute(upgrade_sql)
    up_rec('client')
    up_rec('resource')
    up_rec('random_ani_generation')


def downgrade():
    # Arch users don't downgrade
    pass


"""
ADDONS
"""
def up_rec(table):
    """
    Update {table}_record schema
    """

    up_rec_sql = """
DO $do$
DECLARE
    rec_id INT := 1;
BEGIN
    -- Check if table exists
    IF NOT EXISTS (SELECT 0 FROM pg_tables WHERE tablename = '{table}') THEN
        RAISE WARNING 'Table {table} does not exist';
    ELSE
        -- Get last record_id
        SELECT record_id FROM {table}_record ORDER BY record_id DESC LIMIT 1
        INTO rec_id;
        -- Delete existing table
        DROP TRIGGER IF EXISTS class4_trig_record_{table} ON {table};
        DROP FUNCTION IF EXISTS class4_trigfun_record_{table};
        DROP TABLE IF EXISTS {table}_record;
        DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
    END IF;

    -- Create new table
    CREATE TABLE {table}_record (LIKE {table},
    "time" integer, flag character(1), record_id SERIAL PRIMARY KEY);
    ALTER TABLE {table}_record OWNER TO class4_user;
    CREATE INDEX IF NOT EXISTS {table}_record_time_idx
    ON {table}_record USING btree ("time");
    EXECUTE format(E'SELECT setval(\\'{table}_record_record_id_seq\\', %%L)',
    rec_id);

    -- Trigger
    CREATE FUNCTION class4_trigfun_record_{table}() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.{table}_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.{table}_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.{table}_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.{table}_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;
    ALTER FUNCTION class4_trigfun_record_{table}() OWNER TO class4_user;
    CREATE TRIGGER class4_trig_record_{table} AFTER INSERT OR DELETE OR UPDATE
    ON {table} FOR EACH ROW EXECUTE PROCEDURE class4_trigfun_record_{table}();
END $do$;
"""
    connection = op.get_bind()
    connection.execute(up_rec_sql.format_map(dict(table=table)))
