"""rate unique constraints

Revision ID: 43d7e983fac5
Revises: 054d100f96ac
Create Date: 2017-11-19 04:26:43.660043

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '43d7e983fac5'
down_revision = '054d100f96ac'
branch_labels = None
depends_on = None


def upgrade():
    connection = op.get_bind()
    connection.execute("delete from rate where ctid not in (select max(ctid) from rate s  group by s.rate_table_id, s.code, s.effective_date)")
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index(op.f('ix_balance_history_actual_date'), 'balance_history_actual', ['date'], unique=False)
    op.create_unique_constraint(None, 'rate', ['rate_table_id', 'code', 'effective_date'])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'rate', type_='unique')
    op.drop_index(op.f('ix_balance_history_actual_date'), table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date', 'client_id'], unique=True)
    # ### end Alembic commands ###
