"""country

Revision ID: 490fa8f8519f
Revises: 02f3eeec36ea
Create Date: 2017-11-27 12:56:51.084504

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '490fa8f8519f'
down_revision = '02f3eeec36ea'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('code_country',
    sa.Column('country_code', sa.String(length=20), nullable=False),
    sa.Column('country', sa.String(length=80), nullable=True),
    sa.PrimaryKeyConstraint('country_code'),
    sa.UniqueConstraint('country')
    )
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index(op.f('ix_balance_history_actual_date'), 'balance_history_actual', ['date'], unique=False)
    op.create_foreign_key(None, 'rate_generation_rate', 'rate_generation_history', ['rate_generation_history_id'], ['id'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'rate_generation_rate', type_='foreignkey')
    op.drop_index(op.f('ix_balance_history_actual_date'), table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date', 'client_id'], unique=True)
    op.drop_table('code_country')
    # ### end Alembic commands ###
