"""ocn filtering

Revision ID: 8ad3ed6d2474
Revises: a85bbcdf3a23
Create Date: 2024-01-30 17:42:37.040316

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '8ad3ed6d2474'
down_revision = 'a85bbcdf3a23'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('ocn_blocklist',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('res_id', sa.Integer(), nullable=True),
    sa.Column('ocn', sa.String(length=100), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('created_by', sa.String(length=100), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('rtp_proxy_log',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('session_uuid', sa.Text(), nullable=False),
    sa.Column('source_addr', sa.String(length=16), nullable=False),
    sa.Column('source_port', sa.Integer(), nullable=False),
    sa.Column('dest_addr', sa.String(length=16), nullable=False),
    sa.Column('dest_port', sa.Integer(), nullable=False),
    sa.Column('timeout', sa.Integer(), nullable=False),
    sa.Column('start_time', sa.DateTime(timezone=True), nullable=False),
    sa.Column('end_time', sa.DateTime(timezone=True), nullable=False),
    sa.Column('is_killed', sa.Boolean(), nullable=False),
    sa.Column('last_caller_packet', sa.DateTime(timezone=True), nullable=True),
    sa.Column('caller_packets', sa.BigInteger(), nullable=False),
    sa.Column('caller_bytes', sa.BigInteger(), nullable=False),
    sa.Column('last_callee_packet', sa.DateTime(timezone=True), nullable=True),
    sa.Column('callee_packets', sa.BigInteger(), nullable=False),
    sa.Column('callee_bytes', sa.BigInteger(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.add_column('client_cdr', sa.Column('orig_shaken_lvl', sa.String(length=1), nullable=True))
    op.add_column('client_cdr', sa.Column('orig_shaken_ocn', sa.String(length=100), nullable=True))
    op.add_column('client_cdr', sa.Column('orig_shaken_status', sa.Integer(), nullable=True))
    op.add_column('client_cdr', sa.Column('orig_shaken_subject', sa.String(length=512), nullable=True))
    op.add_column('client_cdr', sa.Column('term_shaken_lvl', sa.String(length=1), nullable=True))
    op.add_column('client_cdr', sa.Column('term_shaken_ocn', sa.String(length=512), nullable=True))
    op.add_column('client_cdr', sa.Column('term_shaken_status', sa.Integer(), nullable=True))
    op.add_column('client_cdr', sa.Column('term_shaken_subject', sa.String(length=512), nullable=True))
    up_rec('ocn_blocklist')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('client_cdr', 'term_shaken_subject')
    op.drop_column('client_cdr', 'term_shaken_status')
    op.drop_column('client_cdr', 'term_shaken_ocn')
    op.drop_column('client_cdr', 'term_shaken_lvl')
    op.drop_column('client_cdr', 'orig_shaken_subject')
    op.drop_column('client_cdr', 'orig_shaken_status')
    op.drop_column('client_cdr', 'orig_shaken_ocn')
    op.drop_column('client_cdr', 'orig_shaken_lvl')
    op.drop_table('rtp_proxy_log')
    op.drop_table('ocn_blocklist')
    up_rec('ocn_blocklist')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE if not exists {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))