"""merge did_number_upload_task did_billing_brief banned_ip_record

Revision ID: bffb08975e0c
Revises: f94d07d0c5ca
Create Date: 2018-12-21 18:38:08.893688

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'bffb08975e0c'
down_revision = 'f94d07d0c5ca'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('did_billing_brief',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('did_number', sa.String(length=50), nullable=True),
    sa.Column('vendor_billing_plan_id', sa.Integer(), nullable=True),
    sa.Column('client_billing_plan_id', sa.Integer(), nullable=True),
    sa.Column('vendor_trunk_id', sa.Integer(), nullable=True),
    sa.Column('client_trunk_id', sa.Integer(), nullable=True),
    sa.Column('start_date', sa.DateTime(timezone=True), nullable=True),
    sa.Column('enable_for_clients', sa.Boolean(), server_default='false', nullable=True),
    sa.Column('last_charged_monthly_fees', sa.Integer(), server_default='-1', nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('did_number_upload_task',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('operator_user', sa.String(length=40), nullable=True),
    sa.Column('upload_file_path', sa.String(length=256), nullable=True),
    sa.Column('upload_orig_file', sa.String(length=100), nullable=True),
    sa.Column('upload_format_file', sa.String(length=100), nullable=True),
    sa.Column('result_file_path', sa.String(length=256), nullable=True),
    sa.Column('repeated_action', sa.SmallInteger(), nullable=True),
    sa.Column('status', sa.SmallInteger(), server_default='0', nullable=False),
    sa.Column('progress', sa.String(length=200), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('start_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('end_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('import_export_logs_id', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.add_column('version_information', sa.Column('cli_ip', sa.String(length=30), nullable=True))
    op.add_column('version_information', sa.Column('cli_port', sa.Integer(), nullable=True))
    op.add_column('version_information', sa.Column('last_status_time', sa.String(length=100), nullable=True))
    op.add_column('version_information', sa.Column('status', sa.Integer(), nullable=True))
    # ### end Alembic commands ###
    connection = op.get_bind()
    connection.execute("""
CREATE FUNCTION public.process_did_number_upload_task() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
        splited_row varchar[];
        error_count integer;
        success_count integer;
    BEGIN
        --
        -- If operation = update then update import_export_logs_row
        --
        IF (TG_OP = 'UPDATE') THEN
            UPDATE import_export_logs SET finished_time = NEW.end_time, status = NEW.status
            WHERE import_export_logs.id = NEW.import_export_logs_id;

            --
            -- Update uploaded records in import_export_logs when status = success
            --
            IF (NEW.status = 3) THEN

                splited_row = string_to_array(NEW.progress, ',');
                error_count = split_part(splited_row[4], ':', 2)::integer;
                success_count = 0;

                -- Check if progress row has NEW records
                IF (split_part(splited_row[2], ':', 2)::integer > 0) THEN
                    success_count = split_part(splited_row[2], ':', 2)::integer;
                ELSE
                    success_count = split_part(splited_row[3], ':', 2)::integer;
                END IF;

                UPDATE import_export_logs SET (error_row, success_numbers) = (error_count, success_count)
                WHERE import_export_logs.id = NEW.import_export_logs_id;
            ELSEIF (NEW.status = 4) THEN
                UPDATE import_export_logs SET error_file_path = concat(NEW.result_file_path, 'did_upload.log')
                WHERE import_export_logs.id = NEW.import_export_logs_id;
            END IF;

            RETURN NEW;
        END IF;
        RETURN NULL; -- return value for trigger AFTER
    END;
$$;
   
""")
    connection.execute("ALTER FUNCTION public.process_did_number_upload_task() OWNER TO postgres;")
    connection.execute("CREATE TRIGGER process_did_number_upload_task AFTER INSERT OR DELETE OR UPDATE ON public.did_number_upload_task FOR EACH ROW EXECUTE PROCEDURE public.process_did_number_upload_task();")



def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('version_information', 'status')
    op.drop_column('version_information', 'last_status_time')
    op.drop_column('version_information', 'cli_port')
    op.drop_column('version_information', 'cli_ip')
    op.drop_table('did_number_upload_task')
    op.drop_table('did_billing_brief')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger class4_trig_record_{table} on {table};
drop table {table}_record;
DROP FUNCTION class4_trigfun_record_{table}();
DROP SEQUENCE {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))