import celery
from api_dnl import settings
from datetime import datetime,timedelta
from pytz import UTC
from time import mktime
import io,csv,gzip,zipfile
import xlwt
import json
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select,alias,case
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import Client,Client,Resource,Rate,RateTable,RateSendLog,BalanceHistoryActual,C4ClientBalance,\
    RateSendLogDetail,CrdReportDetailTable,MailSender,FraudDetection,FraudDetectionLog,FraudDetectionLogDetail,\
    ResourceBlock,IngressTrunk,SystemParameter,AlertRule,AlertRuleLog,AlertRulesLogDetail,CdrReportDetail,client_cdr
from api_dnl.model import PrimaryKeyConstraint,func,query_to_sting,cast
from api_dnl.tasks import app,log,db,SqlAlchemyTask,SchLog
from api_dnl import model
from api_dnl.utils.statisticapi2 import StatisticAPI

@app.task(base=SqlAlchemyTask)
def do_alert_rule():
    slog=SchLog('alert_detection')
    log.debug('Start alert detection!')
    for ad in AlertRule.filter(AlertRule.active==True).all():
        #print('start',ad.id)
        alert_rule.delay(ad.id)

    epoch_secs_unblock = int(datetime.now().timestamp())
    count=ResourceBlock.filter(ResourceBlock.unblock_after < epoch_secs_unblock).delete()
    db.session.commit()
    if count:
        log.debug('Unblock {} expired rules!'.format(count))
    slog.close()


class CallbackTask(SqlAlchemyTask):
    def on_success(self, retval, task_id, args, kwargs):
        obj = AlertRule.get(args[0])
        obj.finish_time = datetime.now(UTC)
        obj.status = False
        obj.save()
        pass

    def on_failure(self, exc, task_id, args, kwargs, einfo):
        obj = AlertRule.get(args[0])
        obj.finish_time = datetime.now(UTC)
        obj.status = False
        obj.save()
        pass

@app.task(base=CallbackTask)
def alert_rule(id):
    try:
        ar=AlertRule.get(id)
        if ar:
            if not alert_rule_time_to_execute(ar):
                return False
            if ar.status:
                log.warning('Alert rule {} {} already running, skip'.format(id, ar.rule_name))
                return
            ar.status=True
            ar.save()
            ar_log = AlertRuleLog(alert_rules_id=id,status='normal',create_on=datetime.now(UTC))
            update_log( ar_log, ar)
            ar_log_id=ar_log.save()
            log.debug('Alert rule {} {}'.format(id,ar.rule_name))

            decision_query=make_query(ar)
            #print(decision_query)
            for item in decision_query:
                cs = AlertCase(ar, item,ar_log)
                if cs.already_blocked():
                    log.debug('Rule {} {} already blocked, skip'.format(id,str(item)))
                    continue
                try:
                    resource_id=int(item.res_id)
                except:
                    log.warning('Resource  "{}" bad format skip'.format(item.res_id))
                    continue
                trunk = cs.trunk
                block,type_name,value,limit_value  = cs.check()
                if block:
                    log.info('Alert detected of Resource  {} type_name:{} value:{} limit:{}'.\
                              format(resource_id, type_name, value, limit_value))
                    ar_log.status='over limit'
                    ar_log_detail = cs.create_log_detail()
                    ar_log_detail.is_block = ar.is_block
                    if ar.is_block:
                        block = cs.create_block()
                        log.warning('Alert rule {} did block resource {}, resource_block is:{}'.format(id,resource_id,block))
                    ar_log_detail.is_email = ar.is_email
                    if ar.is_email:
                        if ar.from_mail_id:
                            cs.from_mail_id=ar.from_mail_id
                        to=[]
                        sys = SystemParameter.get(1)
                        if ar.trouble_ticket_sent_to in ['Own NOC Email', 'Both']:
                            if sys.noc_email and not sys.noc_email=='':
                                ar_log_detail.system_email_address=sys.noc_email
                                to.append(sys.noc_email)
                            else:
                                ar_log_detail.system_email_address = 'No noc_email in system parameters'
                                ar_log_detail.system_email_status = None
                                log.warning('No noc_email in system_parameters configured')
                        if ar.trouble_ticket_sent_to in ['Partner NOC Email', 'Both']:
                            if not trunk:
                                log.debug('Trunk {} not exists'.format(resource_id))
                                ar_log_detail.partner_email_address = 'Cannot find partner trunk '
                                #to=''
                            else:
                                if trunk.client.noc_email and not trunk.client.noc_email=='':
                                    ar_log_detail.partner_email_address=trunk.client.noc_email
                                    to.append(trunk.client.noc_email)
                                else:
                                    ar_log_detail.partner_email_address = 'No noc_email for client {}'.format(trunk.client.name)
                                    ar_log_detail.partner_email_status = None
                                    log.warning('No noc_email in client {} configured '.format(trunk.client_id))

                        if to:
                            mail_not_sent=MailSender.apply_mail(cs,'alert_email',to=';'.join(to))
                            log.debug('Alert rule email to {} sent'.format(to))
                        else:
                            mail_not_sent = 'no address'
                            log.debug('Alert rule email not sent - no one address')

                        if ar.trouble_ticket_sent_to in ['Own NOC Email', 'Both']:
                            if sys.noc_email and not sys.noc_email=='':
                                ar_log_detail.system_email_status = not bool(mail_not_sent)
                        if ar.trouble_ticket_sent_to in ['Partner NOC Email', 'Both']:
                            if trunk and trunk.client.noc_email and not trunk.client.noc_email == '':
                                ar_log_detail.partner_email_status = not bool(mail_not_sent)
                    ar_log_detail.update_at=datetime.now(UTC)
                    ar_log_detail.save()
            ar_log.finish_time=datetime.now(UTC)
            ar_log.save()
            ar.last_run_time = datetime.now(UTC)
            ar.status = False
            ar.next_run_time = ar._next_run_time
            ar.save()
            log.debug('Alert rule {} finished'.format(id))

    except Exception as e:
        log.error('Alert rule id={} error:{}'.format(id,str(e)))
        db.session.rollback()
        ar=AlertRule.get(id)
        if ar:
            ar.status = False
            ar.save()
    return True


def alert_rule_time_to_execute(rule):
    #0: 'never', 1: 'Every Specific Minutes', 2: 'Daily', 3: 'Weekly'
    now = datetime.now(UTC)
    now_timestamp = int(now.timestamp())#mktime(now.timetuple())
    now_day = now.day
    now_hour = now.hour
    now_wday = now.weekday()

    last_run_time = None
    last_run_day = None
    last_run_hour = None
    last_run_wday = None
    if rule.last_run_time:
        last_run_time = int(rule.last_run_time.timestamp())#mktime(rule.last_run_time.timetuple())
        lr_utc=datetime.fromtimestamp(last_run_time,tz=UTC)
        last_run_day = lr_utc.day
        last_run_hour = lr_utc.hour
        last_run_wday = lr_utc.weekday()

    if rule.execution_schedule=='Every Specific Minutes':
        if not rule.last_run_time:
            return True
        every_min=rule.specific_minutes if rule.specific_minutes else 1
        next_plan_run_time = rule.last_run_time + timedelta(minutes=every_min)
        if every_min == 1:
            return True
        if last_run_time <= now_timestamp - 60 * every_min:
            return True
    elif rule.execution_schedule=='Daily':
        if not rule.last_run_time and rule.daily_time==now_hour:
            return True
        if now_day != last_run_day:
            if int(now_hour) == int(rule.daily_time):
                return True
        else:
            if now_hour != last_run_hour and int(now_hour) == int(rule.daily_time):
                return True
    elif rule.execution_schedule == 'Weekly':
        week_time = rule.weekly_time
        week_day = rule.weekly_value
        if now_wday != last_run_wday:
            if int(now_hour) == int(week_time) and int(now_wday) == int(week_day):
                return True
        else:
            if now_hour != last_run_hour and int(now_hour) == int(week_time) and int(now_wday) == int(week_day):
                return True
    return False


def update_log(log,rule):
    log.limit_acd_value = rule.acd_value
    log.limit_asr_value = rule.asr_value
    log.limit_abr_value = rule.abr_value
    log.limit_pdd_value = rule.pdd_value
    log.limit_profitability_value = rule.profitability_value
    log.limit_revenue_value = rule.revenue_value
    log.limit_acd = rule.acd
    log.limit_asr = rule.asr
    log.limit_abr = rule.abr
    log.limit_pdd = rule.pdd
    log.limit_profitability = rule.profitability
    log.limit_revenue = rule.revenue
        
def _select(cdr,rule):
    ret = (func.to_timestamp(func.min(cdr.c.start_time_of_date/1000000)).label('start_date'),
        func.to_timestamp(func.max(cdr.c.start_time_of_date / 1000000)).label('end_date'),
        func.sum(case([(cdr.c.call_duration > 0,1)],else_=0)).label('not_zero_calls'),
        func.sum(cdr.c.call_duration).label('duration'),
        func.count(case([(cdr.c.binary_value_of_release_cause_from_protocol_stack.like('486%%'), 1)], else_=0)).\
            label('busy_calls'),
        func.count().label('total_calls'),
        func.count(case([(cdr.c.binary_value_of_release_cause_from_protocol_stack.like('487%%'), 1)], else_=0)).\
            label('cancel_calls'),
        func.avg(case([(cdr.c.call_duration > 0,cdr.c.pdd)],else_=0)).label('pdd'),
        func.sum(cdr.c.ingress_client_cost).label('ingress_client_cost_total'),
        func.sum(cdr.c.egress_cost).label('egress_cost_total')
        )
    group=_group(cdr,rule)
    ret = ret + (group[0].label('res_id'),)
    if len(group)>1:
        return ret+(group[1].label('prefix'),)
    return ret

def _filter(cdr,rule):
    if rule.trunk_type=='ingress':
        if rule.all_trunk:
            ret=cdr.c.ingress_id.isnot(None)
        else:
            ret=cdr.c.ingress_id.in_(rule.trunks)
    elif rule.trunk_type=='egress':
        if rule.all_trunk:
            ret=cdr.c.egress_id.isnot(None)
        else:
            ret=cdr.c.egress_id.in_(rule.trunks)
    else:
        if rule.monitor_by == 'DNIS':
            log.debug("cdr.c.is_final_call == 1")
            ret=and_(cdr.c.routing_digits.isnot(None),cdr.c.is_final_call == 1, cdr.c.egress_id.isnot(None) )
        elif rule.monitor_by == 'ANI':
            log.debug("cdr.c.is_final_call == 1")
            ret = and_(cdr.c.origination_source_number.isnot(None), cdr.c.is_final_call == 1, cdr.c.egress_id.isnot(None))
        else:
            if rule.all_trunk or not rule.trunks:
                ret = cdr.c.ingress_id.isnot(None)
            else:
                ret = cdr.c.ingress_id.in_(rule.trunks)

    if rule.include in ['Specific Codes','Specific Code Names']:
        if rule.monitor_by in ['Trunk And Code','Trunk And Country'] and rule.in_codes:
            sep = ',' if ',' in rule.in_codes else ';'
            codes = rule.in_codes.split(sep)
            if codes:
                if rule.trunk_type == 'ingress':
                    ret = and_(ret,cdr.c.orig_code.in_(codes))
                elif rule.trunk_type == 'egress':
                    ret = and_(ret, cdr.c.orig_code.in_(rule.in_codes.split(sep)))
        elif rule.monitor_by == 'Trunk And Destination' and rule.in_code_name_id:
            sep = ',' if ',' in rule.in_code_name_id else ';'
            code_names=rule.in_code_name_id.split(sep)
            if code_names:
                if rule.trunk_type == 'ingress':
                    ret = and_(ret,cdr.c.orig_code_name.in_())
                else:
                    ret = and_(ret, cdr.c.orig_code_name.in_(rule.in_code_name_id.split(sep)))
    if rule.exclude in ['Specific Codes','Specific Code Names']:
        if rule.monitor_by in ['Trunk And Code','Trunk And Country'] and rule.in_codes:
            sep = ',' if ',' in rule.in_codes else ';'
            codes = rule.in_codes.split(sep)
            if codes:
                if rule.trunk_type == 'ingress':
                    ret = and_(ret,cdr.c.orig_code.notin_(codes))
                elif rule.trunk_type == 'egress':
                    ret = and_(ret, cdr.c.orig_code.notin_(rule.in_codes.split(sep)))
        elif rule.monitor_by == 'Trunk And Destination' and rule.in_code_name_id:
            sep = ',' if ',' in rule.in_code_name_id else ';'
            code_names=rule.in_code_name_id.split(sep)
            if code_names:
                if rule.trunk_type == 'ingress':
                    ret = and_(ret,cdr.c.orig_code_name.notin_())
                else:
                    ret = and_(ret, cdr.c.orig_code_name.notin_(rule.in_code_name_id.split(sep)))
    #ret=and_(ret,cdr.c.start_time_of_date > 0)
    return ret

def _group(cdr,rule):
    if rule.trunk_type in ('ingress', 'all'):
        trunk = cdr.c.ingress_id
        code_name = cdr.c.orig_code_name
        country = cdr.c.orig_country
        code = cdr.c.orig_code
    elif rule.trunk_type == 'egress':
        trunk = cdr.c.egress_id
        code_name = cdr.c.term_code_name
        country = cdr.c.term_country
        code = cdr.c.term_code
    monitor_by_map = {'Trunk': None,  # 0
                      'Trunk And DNIS': cdr.c.routing_digits,  # 1
                      'Trunk And ANI': cdr.c.origination_source_number,  # 2
                      'DNIS': cdr.c.routing_digits,  # 3
                      'ANI': cdr.c.origination_source_number,  # 4
                      'Trunk And Destination': code_name,  # 5
                      'Trunk And Country': country,  # 6
                      'Trunk And Code': code  # 7
                      }
    prefix = monitor_by_map[rule.monitor_by]
    if rule.monitor_by in ['DNIS','ANI']:
        return (prefix,)
    if not prefix is None:
        return (trunk, prefix)
    return (trunk,)


def make_query(rule):
    try:
        #con=db.session.connection()
        #con.execute('grant ALL ON ALL TABLES IN SCHEMA public to webbackend')
        # grant ALL ON ALL TABLES IN SCHEMA public to webbackend;
        # grant ALL ON ALL SEQUENCES IN SCHEMA public to webbackend;
        #db.commit()
        #return []
        today = datetime.now(UTC)
        today_timestamp = today.timestamp()  # 1474902640.906471
        from_time = today - timedelta(minutes=rule.sample_size)
        from_time_timestamp = str(int(float(from_time.replace(tzinfo=UTC).timestamp()) * 1000000))
        days = int(rule.sample_size / (60 * 24))
        union = None
        for day_idx in range(days + 1):
            day_cdr = today - timedelta(days=day_idx)
            cdr_date = "%s%02d%02d" % (day_cdr.year, day_cdr.month, day_cdr.day)
            cdr=client_cdr(cdr_date)
            q=db.session.query(*_select(cdr,rule)).\
                filter(_filter(cdr,rule)).\
                filter(cdr.c.start_time_of_date > from_time_timestamp).\
                group_by(*_group(cdr,rule))
            if not union:
                union=q
            else:
                union=q.union_all(union)
        if union:
            u=alias(union.subquery(),'_all_cdr_')
            sel= (u.c.res_id,
                  func.min(u.c.start_date).label('start_date'),
                  func.max(u.c.end_date).label('end_date'),
                  func.sum(u.c.not_zero_calls).label('not_zero_calls'),
                  func.sum(u.c.duration).label('duration'),
                  func.sum(u.c.busy_calls).label('busy_calls'),
                  func.sum(u.c.total_calls).label('total_calls'),
                  func.sum(u.c.cancel_calls).label('cancel_calls'),
                  func.avg(u.c.pdd).label('pdd'),
                  func.sum(u.c.ingress_client_cost_total).label('ingress_client_cost_total'),
                  func.sum(u.c.egress_cost_total).label('egress_cost_total')
                )
            if hasattr(u.c,'prefix'):
                sel=sel+(u.c.prefix,)
            query = db.session.query(*sel).group_by(u.c.res_id)
            if hasattr(u.c, 'prefix'):
                query=query.group_by(u.c.prefix)
            #print(_q_str(query))
            log.debug('Big query:{}'.format(query_to_sting(query)))
            ret=query.all()
            return ret
        return []
    except Exception as e:
        #print(e)
        log.error('Alert rule id={} error:{}'.format(rule.id, str(e)))
        db.session.rollback()
        return []


class AlertCase(object):
    def __init__(self,rule,item,ar_log):
        self.rule=rule
        self.item=item
        self._trunk=None
        self.init_item()
        self.log=ar_log

    def init_item(self):
        try:
            self.acd=round((self.item.duration / self.item.not_zero_calls), 2) if self.item.not_zero_calls != 0 else 0
            self.abr = round(self.item.not_zero_calls / self.item.total_calls * 100, 2) if self.item.total_calls != 0 else 0
            asr_ = self.item.busy_calls + self.item.cancel_calls + self.item.not_zero_calls
            self.asr = round(  (self.item.not_zero_calls / self.item.total_calls)  * 100, 2) if asr_ != 0 else 0
            self.pdd = round(self.item.pdd / self.item.not_zero_calls) if self.item.not_zero_calls != 0 else 0
            self.profitability = round((self.item.ingress_client_cost_total - self.item.egress_cost_total)\
                            /self.item.ingress_client_cost_total * 100,5) if self.item.ingress_client_cost_total != 0 else 0
            self.revenue = round(self.item.ingress_client_cost_total,5)  # - egress_cost_total  Sourav Revenue formula is not correct, I think.. Let me checkИзпратено на:10:50От:Sourav Profit is okОт:Sourav Revenue = Total Ingress client cost
            #print('acd',self.acd,'abr',self.abr,'asr',self.asr,'pdd',self.pdd,'profitability',self.profitability,'revenue',self.revenue)
        except Exception as e:
            log.error('AlertCase cannont calculate {} {}'.format(self.item,str(e)))
    @property
    def trunk(self):
        if self.rule.monitor_by in ['DNIS', 'ANI']:
            return None
        else:
            if self._trunk:
                return self._trunk
            else:
                self._trunk=Resource.get(self.item.res_id)
                return self._trunk

    @property
    def ingress_id(self):
        if self.rule.trunk_type in ('ingress', 'all') and self.trunk:
                return self.trunk.resource_id
        return None

    @property
    def egress_id(self):
        if self.rule.trunk_type in ('egress') and self.trunk:
                return self.trunk.resource_id
        return None

    @property
    def ingress_client_id(self):
        if self.rule.trunk_type in ('ingress', 'all') and self.trunk:
            if self.trunk.client:
                return self.trunk.client.client_id
        return None

    @property
    def egress_client_id(self):
        if self.rule.trunk_type in ('egress') and self.trunk:
            if self.trunk.client:
                return self.trunk.client.client_id
        return None

    @property
    def client(self):
        if self.trunk and self.trunk.client:
                return self.trunk.client
        return None

    @property
    def client_id(self):
        if self.trunk and self.trunk.client:
            return self.trunk.client.client_id
        return None

    def monitoring_result(self):
        head=''
        row=''
        for key in ('acd', 'asr', 'abr', 'pdd', 'profitability', 'revenue'):
            head = head + '<th>{}</th>'.format(key)
            if key in self.type_name:
                row = row + '<td style="background-color: rgba(234, 174, 165, 1)">{}</td>'.format(getattr(self, key))
            else:
                row = row + '<td>{}</td>'.format(getattr(self,key))
        return '<table class="monitoring_result" name="monitoring_result"><tr>{}</tr><tr>{}</tr></table>'.format(head,row)

    def code(self):
        if hasattr(self.item,'prefix'):
            return self.item.prefix
        else:
            if self.rule.monitor_by in ['DNIS', 'ANI']:
                return self.item.res_id
        return None

    def rule_name(self):
        return self.rule.rule_name+' '+self.type_name

    def limit_table(self):
        return """
<table class="limit_table" name="limit_table">
<tr><th></th><th>acd</th><th>asr</th><th>abr</th><th>pdd</th><th>profitability</th><th>revenue</th></tr>
<tr><td>limit value</td><td>{}</td><td>{}</td><td>{}</td><td>{}</td><td>{}</td><td>{}</td></tr>
<tr><td>operator</td><td>{}</td><td>{}</td><td>{}</td><td>{}</td><td>{}</td><td>{}</td></tr>
</table>
""".format(self.rule.acd_value, self.rule.asr_value, self.rule.abr_value, self.rule.pdd_value,
           self.rule.profitability_value, self.rule.revenue_value,
        self.rule.acd, self.rule.asr, self.rule.abr, self.rule.pdd, self.rule.profitability, self.rule.revenue)

    def rule_setup(self):
        all='all' if self.rule.all_trunk else 'selected'
        return """
        <table class="rule_setup" name="rule_setup">
        <tr><th>Name</th><th>Value</th></tr>
        <tr><td>scope</td><td>{} {}</td></tr>
        <tr><td>include</td><td>{}</td></tr>
        <tr><td>exclude</td><td>{}</td></tr>
        <tr><td>monitoring on</td><td>{}</td></tr>
        <tr><td>trunks</td><td>{}</td></tr>
        <tr><td>execution schedule</td><td>{}</td></tr>
        <tr><td>do block</td><td>{}</td></tr>
        </table>
        """.format(all,self.rule.trunk_type,self.rule.in_codes,self.rule.ex_codes,self.rule.monitor_by,
                   self.rule.res_id,self.rule.execution_schedule,self.rule.is_block)

    def block_list(self):
        return self.block.res_block_id

    def total_calls(self):
        return self.item.total_calls

    def sample_start_time(self):
        return self.item.start_date

    def sample_end_time(self):
        return self.item.end_date

    def already_blocked(self):
        b = ResourceBlock
        if self.rule.trunk_type in ('ingress', 'all'):
            trunk = b.ingress_res_id
        else:# self.rule.trunk_type == 'egress':
            trunk = b.egress_res_id
        filt = trunk == self.item.res_id

        monitor_by_map = {'Trunk': lambda:filt,  # 0
                          'Trunk And DNIS': lambda: and_(filt, b.digit == self.item.prefix),  # 1
                          'Trunk And ANI': lambda: and_(filt, b.ani_prefix == self.item.prefix),  # 2
                          'DNIS': lambda:b.digit == self.item.res_id,  # 3
                          'ANI': lambda:b.ani_prefix == self.item.res_id,  # 4
                          'Trunk And Destination': lambda:and_(filt, b.code_name == self.item.prefix),  # 5
                          'Trunk And Country': lambda:and_(filt, b.country == self.item.prefix),  # 6
                          'Trunk And Code': lambda:and_(filt, b.digit == self.item.prefix)  # 7
                          }
        q = b.filter(monitor_by_map[self.rule.monitor_by]())
        ret = q.first()
        return not ret is None

    def compare(self,n1,n2,op):
        if n1 == None or n2 == None:
            return False
        n1 = float(n1)
        n2 = float(n2)
        log.debug("Alert case compare: %f %s %f " % (n1, op, n2))
        if op == '>':
            if n1 > n2:
                return True
            return False
        elif op == '<':
            if n1 < n2:
                return True
            return False
        elif op == '=':
            if n1 == n2:
                return True
            return False
        else:
            log.error('Bad compare operator {}'.format(op))
            raise Exception('Bad compare operator {}'.format(op))
        
    def check(self):
        self.type_name=''
        self.limit_value=0
        self.value = 0
        op_map={
            '=':' equal to',
            '>': ' greater than',
            '<': ' less than',
        }
        checks=[
            (self.acd,self.rule.acd_value,self.rule.acd,'acd'),
            (self.asr, self.rule.asr_value, self.rule.asr, 'asr'),
            (self.abr, self.rule.abr_value, self.rule.abr, 'abr'),
            (self.pdd, self.rule.pdd_value, self.rule.pdd, 'pdd'),
            (self.profitability, self.rule.profitability_value, self.rule.profitability, 'profitability'),
            (self.revenue, self.rule.revenue_value, self.rule.revenue, 'revenue')
        ]
        for n1,n2,op,name in checks:
            if op!='1' and self.compare(n1,n2,op):
                log.info('Rule {} {}. check successful {} value {} {} {}'.format(self.rule.id,self.rule.rule_name,name,n1,op,n2))
                #log.debug('+Rule {},item {} check {} successful'.format(self.rule, self.item, name))
                self.value = n1
                self.limit_value = n2
                self.type_name = name+op_map[op]
                return True,self.type_name,n2,n1
        log.debug('+Rule {},item {} all checks unsuccessful'.format(self.rule,self.item))
        return (False, None, None, None)


       

    def create_log_detail(self):
        ar_log_id=self.log.id
        self.log_detail = AlertRulesLogDetail(alert_rules_log_id=ar_log_id,is_block=self.rule.is_block,
                                              acd=self.acd, abr=self.abr, asr=self.asr, pdd=self.pdd,
                                              profitability=self.profitability, revenue=self.revenue)
        if 'prefix' in self.item and self.item.prefix:
            self.log_detail.code=self.item.prefix
        if self.trunk:
            self.log_detail.resource_id = self.trunk.resource_id
        self.log_detail.update_at = datetime.now(UTC)
        #self.log.detail.append(self.log_detail)
        id=self.log_detail.save()
        
        
        #self.log_detail.id=id
        #self.log_detail = AlertRulesLogDetail.get(id)
        return self.log_detail

    def create_block(self):
        if self.rule.auto_enable_type=='yes' and self.rule.auto_enable:
            unblock_after_min = self.rule.auto_enable
        else:
            unblock_after_min = 1000 * 365 * 24 * 60
        epoch_secs_unblock = (datetime.now(UTC) + timedelta(minutes=int(unblock_after_min))).timestamp()
        self.block = ResourceBlock(ingress_res_id=self.ingress_id, ingress_client_id=self.ingress_client_id,
                        engress_res_id=self.egress_id, egress_client_id=self.egress_client_id,
                        action_type='alert rule',
                        disable_by_alert=True,
                        update_by='alert rule[{}]'.format(self.rule.rule_name),
                        create_by='alert rule[{}]'.format(self.rule.rule_name),
                        block_log_id=self.log_detail.id,
                        unblock_after=epoch_secs_unblock)


        if self.rule.monitor_by in ['ANI']:
            self.block.ani_prefix=self.item.res_id
        if self.rule.monitor_by in ['DNIS']:
            self.block.digit=self.item.res_id
        if self.rule.monitor_by in ['Trunk And DNIS']:
            self.block.digit = self.item.prefix
        if self.rule.monitor_by in ['Trunk And ANI']:
            self.block.ani_prefix = self.item.prefix
        if self.rule.monitor_by in ['Trunk And Code']:
            self.block.digit = self.item.prefix
        if self.rule.monitor_by in ['Trunk And Destination']:
            self.block.code_name = self.item.prefix
        if self.rule.monitor_by in ['Trunk And Country']:
            self.block.country = self.item.prefix

        id=self.block.save()
        self.log_detail.resource_block_id = id
        return self.block

if __name__ == '__main__':

    print('test alert rule 97')
    count=ResourceBlock.query().delete()
    print('delete {}',1)
    db.session.commit()
    ar=AlertRule.get(97)
    ar.auto_enable = 1440
    ar.status=False
    ar.sample_period = 1440
    ar.all_trunk = False
    ar.trunks=[1478]
    ar.trunk_type='ingress'
    ar.monitor_by='Trunk And Code'
    ar.execution_schedule='Every Specific Minutes'
    ar.specific_minutes=60
    ar.acd = '1'
    ar.abr_value = 5
    ar.asr = '>'
    ar.abr_value = 30
    ar.abr='1'
    ar.abr_value=10
    ar.pdd = '1'
    ar.pdd_value = 0
    ar.profitability = '1'
    ar.profitability_value = 30
    ar.revenue = '1'
    ar.revenue_value = 3
    ar.save()

    #alert_rule(97)