import celery
from api_dnl import settings
from datetime import datetime,timedelta
from pytz import UTC
from time import mktime,sleep
import io,csv,gzip,zipfile
import os,shutil
import xlwt
import json
from api_dnl.utils.imp_exp import (csv2xls,dict_to_csv)
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_,or_,not_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select,alias,case
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import Client,Client,Resource,ResourcePrefix,Rate,RateTable,CdrDownloadTask,BalanceHistoryActual,C4ClientBalance,\
    CrdReportDetailTable,MailSender,MailTemplate,FraudDetection,FraudDetectionLog,FraudDetectionLogDetail,\
    ResourceBlock,IngressTrunk,SystemParameter,AlertRule,AlertRuleLog,AlertRulesLogDetail,CdrReportDetail,client_cdr,\
    CdrDownloadTask,SendCdrDirect
from api_dnl.model import PrimaryKeyConstraint,func,query_to_sting,cast,generate_uuid_str,aliased
from api_dnl.tasks import app,log,db,SqlAlchemyTask,SchLog
from api_dnl import model
from api_dnl.utils.statisticapi2 import StatisticAPI
from api_dnl.scheme import RateScheme
from api_dnl.utils.ws_broker_api import WSBrokerAPI

@app.task(base=SqlAlchemyTask)
def do_cdr_download():
    log.debug('cdr_download started')
    return
    sr=CdrDownloadTask.filter(and_(CdrDownloadTask.status=='waiting',CdrDownloadTask.type=='auto')).all()
    log.debug('cdr_download waiting {}'.format(len(sr)))
    # for r in CdrDownloadTask.filter(and_(CdrDownloadTask.status=='waiting',CdrDownloadTask.type=='auto')).all():
    #     cdr_download.delay(r.request_id)
    r = CdrDownloadTask.filter(and_(CdrDownloadTask.status=='waiting',CdrDownloadTask.type=='auto')).first()
    if r:
        cdr_download.delay(r.request_id)

@app.task(base=SqlAlchemyTask)
def cdr_download(request_id):
    slog = SchLog('cdr_download')
    log.debug('cdr_download request_id={} sheduled.'.format(request_id))
    sr = CdrDownloadTask.get(request_id)
    if not sr or sr.status!='waiting':
        #sr = CdrDownloadTask(request_id=request_id, email_to=email_to, method=method)
        log.debug('Cdr download request id={} not exists!'.format(request_id))
        return
    try:
        sr.status='started'
        sr.save()

        ws = WSBrokerAPI()
        ws.set_task_id('cdr_download', id)

        if not sr.orig_file:
            log.debug('Cdr download log id={} will download new file created .'.format(request_id))
            a = StatisticAPI()
            user = model.User.get(1)
            token = user.cdr_api_token
            #wait stage
            i=0
            while sr.status!='Complete' and i < 50:
                res = a.send_request(params={},rt_api='async',cdr_request=request_id,token=token)
                if res.status_code == 200:
                    for k,v in res.json().items():
                        setattr(sr,k,v)
                    sr.save()
                else:
                    sleep(30)
                    i+=1
                    ws.notify(i)
            if i >= 50:
                msg='Cdr download status request id={} status={}'.format(request_id, res.status_code)
                log.error(msg)
                sr.mail_status=msg
                sr.save()
                ws.state('fail')
                return False
            #download stage
            i=0
            res = a.send_request(params={}, rt_api='async', cdr_request=request_id+'/download',token=token)
            while res.status_code != 200 and i < 16:
                sleep(5)
                res = a.send_request(params={}, rt_api='async', cdr_request=request_id + '/download',token=token)
                i = i+1
                ws.notify(i+50)
            if i == 16:
                msg='Cdr download request id={} status={}'.format(request_id, res.status_code)
                log.error(msg)
                sr.mail_status = msg
                sr.save()
                ws.state('fail')
                return False
            ws.notify(66)
            #write local file
            xls=csv2xls(res.content.decode(),'CDR{}'.format(str(sr.fmt_start_time.date()).replace('-','')) )
            sr.orig_file='cdr_{}.xls'.format(request_id)
            f = open(sr.file_name, 'wb')
            f.write(xls)
            f.close()
            ws.notify(75)
        if sr.method != 'not send':
            #send email stage
            errors=None
            err_list=[]
            att=[]
            if sr and sr.orig_file and sr.method=='attachment':
                att = [('xls', sr.file_data)]
            if sr and sr.client:# and not sr.email_status=='sent success':
                cl = sr.client
                cl.fmt_download_link = sr.fmt_download_link
                cl.fmt_start_time = sr.fmt_start_time
                cl.fmt_begin_time = sr.fmt_start_time
                cl.fmt_end_time = sr.fmt_end_time
                cl.fmt_current_day = str(datetime.now(UTC).date())
                cl.fmt_customer_gmt = cl.auto_send_zone
                cl.fmt_cdr_count = sr.count
                if sr.type == 'manual':
                    if sr.direct:
                        res = MailSender.apply_mail(cl, 'sendcdrdirect_{}'.format(sr.request_id), att=att)
                    else:
                        res = MailSender.apply_mail(cl,'send_cdr', att=att)
                    if res:
                        if hasattr(MailSender, 'last_error'):
                            sr.mail_status = MailSender.last_error
                        else:
                            sr.mail_status = 'unknown mail send error'
                        sr.save()
                        return False
                else:
                    #setattr(sr, MailTemplate.get('auto_cdr').to_mail, sr.email_to)
                    if not cl.is_link_cdr:
                        att = [('xls', sr.file_data)]
                    res = MailSender.apply_mail(cl, 'auto_cdr', att=att)
                sr.mail_status = 'sent success'
                sr.save()
                ws.notify(99)
            if sr and sr.email_to:# and not sr.email_status=='sent success':
                if sr.direct:
                    setattr(sr, SendCdrDirect.get(sr.request_id).to_mail, sr.email_to)
                    res = MailSender.apply_mail(sr, 'sendcdrdirect_{}'.format(sr.request_id), att=att)
                else:
                    setattr(sr, MailTemplate.get('send_cdr').to_mail, sr.email_to)
                    res = MailSender.apply_mail(sr,'send_cdr', att=att)
                if res:
                    if hasattr(MailSender, 'last_error'):
                        sr.mail_status = MailSender.last_error
                    else:
                        sr.mail_status = 'unknown mail send error'
                    sr.save()
                    return False
                sr.mail_status = 'sent success'
                sr.save()
                ws.state('success')
        else:
            sr.mail_status = 'download success'
            sr.save()
            ws.state('success')
    except Exception as e:
        ws.state('fail')
        sr.mail_status = 'Cdr download and send failed! request_id={} error={}'.format(request_id, str(e))
        log.error(sr.mail_status)
        try:
            sr.save()
        except Exception as e1:
            log.error('Cdr download id={} fatal error={}'.format(request_id, str(e1)))
            db.session.rollback()
        return False
    slog.close()

    return True


