from SimpleWebSocketServer import SimpleWebSocketServer, WebSocket
import json
import logging
from api_dnl import settings

level = logging._nameToLevel[settings.LOG_LEVEL.upper()]
log_file = (settings.LOG_FILE).split('.')[0] + '_' + __name__ + '.log'
logging.basicConfig(filename=log_file, level=level)
log = logging

log_to_console = getattr(settings, 'LOG_TO_CONSOLE')
if log_to_console:
    console_logger = logging.StreamHandler()
    fmt = "[%(asctime)s | " + "ws_broker.py" + "] %(message)s"
    date_format = "%Y-%m-%d %H:%M:%S"
    console_logger.setFormatter(
        logging.Formatter(fmt, datefmt=date_format)
    )
    logger = logging.getLogger('ws_broker.py')
    logger.addHandler(console_logger)

topics = {}
live = {}

SUCCESS = dict(success=True)


def parse_topic(s):
    l = s.split('/')
    return l[1], l[2]


class ProcessNotifyBroker(WebSocket):
    publish = ('dump', 'notify', 'subscribe')

    def dump(self, data):
        cli = {}
        srv = {}
        for k, v in topics.items():
            cli[k] = [i.address for i in v]
        for k, v in live.items():
            srv[k] = v.address
        log.debug('dump subscribed:{} live{}'.format(cli, srv))
        return dict(clients=cli, servers=srv)

    def notify(self, data):
        # print('notify {} {}'.format(data,getattr(self,'_topic') if hasattr(self,'_topic') else 'no _topic'))
        if not hasattr(self, '_topic'):
            self._topic = '/{}/{}'.format(data['task'], data['id'])
            live[self._topic] = self
            log.info('server {} publish topic {}'.format(self.address, self._topic))
        log.debug('notify from {} topic {} value {}'.format(self.address, self._topic, data['value']))
        self._value = data.get('value', None)
        if hasattr(self, '_topic') and self._topic in topics:
            for client in topics[self._topic]:
                client.sendMessage(json.dumps(data))
        return SUCCESS

    def subscribe(self, data):
        if hasattr(self, 'topic') and self.topic in topics:
            topics[self.topic].remove(self)
            if not topics[self.topic]:
                del topics[self.topic]
        self.topic = '/{}/{}'.format(data['task'], data['id'])
        log.info('client {} subscribe topic {}'.format(self.address, self.topic))
        if self.topic in topics:
            if not self in topics[self.topic]:
                topics[self.topic].append(self)
        else:
            topics[self.topic] = [self]
        if self.topic in live:
            value = None
            if hasattr(live[self.topic], '_value'):
                value = live[self.topic]._value
            return dict(success=True, task=data['task'], id=data['id'], state='run', value=value)
        else:
            return dict(success=True, task=data['task'], id=data['id'], state=None)

    def handleMessage(self):
        # echo message back to client
        try:
            data = json.loads(self.data)
            msg = list(data.keys())[0]
            if not msg:
                self.sendMessage('{"success":false,"error":"not found"}')
            else:
                if msg not in self.publish or not hasattr(self, msg):
                    self.sendMessage('{"success":false,"error":"not implemented"}')
                else:
                    body = data[msg]
                    # print(msg,body)
                    meth = getattr(self, msg)
                    # resp = dict(meth=str(meth),body=body)
                    resp = meth(body)
                    self.sendMessage(json.dumps(resp))
        except Exception as e:
            msg = dict(success=False, error='operational error', cause=str(e))
            log.error('ws_broker error:{}'.format(json.dumps(msg)))
            self.sendMessage(json.dumps(msg))

    def handleConnected(self):
        # clients.append(self)
        log.info('client opened {}'.format(self.address))

    def handleClose(self):
        try:
            log.debug(
                'close {} server {}, client {}'.format(self.address, hasattr(self, '_topic'), hasattr(self, 'topic')))
            if hasattr(self, '_topic'):
                try:
                    if self._topic in topics:
                        for client in topics[self._topic]:
                            task, id_ = parse_topic(self._topic)
                            client.sendMessage(json.dumps(dict(state='closed', task=task, id=id_)))
                    del live[self._topic]
                    del self._topic
                except Exception as e:
                    log.error('error in close server {}'.format(e))
            if hasattr(self, 'topic'):
                topics[self.topic].remove(self)
                if not topics[self.topic]:
                    del topics[self.topic]
                del self.topic
        except Exception as e:
            log.error('error in close {}'.format(e))


def run():
    from api_dnl.settings import WS_HOST
    log.info('start ws_broker on {}'.format(WS_HOST))
    host, port = WS_HOST.split(':')
    server = SimpleWebSocketServer(host, int(port), ProcessNotifyBroker)
    server.serveforever()


if __name__ == "__main__":
    # from api_dnl.settings import WS_HOST
    host, port = '', 8010  # WS_HOST.split(':')
    server = SimpleWebSocketServer(host, int(port), ProcessNotifyBroker)
    server.serveforever()
