"""cdr_async_task

Revision ID: 3a9e96a1a4fd
Revises: 9150d549cea3
Create Date: 2019-09-17 18:31:43.043023

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '3a9e96a1a4fd'
down_revision = '9150d549cea3'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('cdr_async_task',
    sa.Column('request_id', sa.String(length=16), nullable=False),
    sa.Column('client_id', sa.Integer(), nullable=True),
    sa.Column('fields', sa.String(length=1024), nullable=True),
    sa.Column('filter', sa.JSON(), nullable=True),
    sa.Column('download_link', sa.String(length=512), nullable=True),
    sa.Column('expiration_time', sa.Integer(), nullable=True),
    sa.Column('job_start_time', sa.Integer(), nullable=True),
    sa.Column('job_end_time', sa.Integer(), nullable=True),
    sa.Column('msg', sa.String(length=512), nullable=True),
    sa.Column('progress', sa.String(length=4), nullable=True),
    sa.Column('count', sa.Integer(), nullable=True),
    sa.Column('size', sa.Integer(), nullable=True),
    sa.Column('status', sa.String(length=32), nullable=True),
    sa.Column('email', sa.String(length=512), nullable=True),
    sa.Column('orig_file', sa.String(length=512), nullable=True),
    sa.Column('mail_status', sa.String(length=512), nullable=True),
    sa.Column('method', sa.String(length=32), nullable=True),
    sa.Column('sender_id', sa.Integer(), nullable=True),
    sa.Column('subject', sa.String(length=512), nullable=True),
    sa.Column('content', sa.Text(), nullable=True),
    sa.Column('mail_cc', sa.String(length=512), nullable=True),
    sa.Column('type', sa.SmallInteger(), nullable=True,server_default='1'),
    sa.Column('ftp_url', sa.String(length=512), nullable=True),
    sa.Column('ftp_port', sa.SmallInteger(), nullable=True),
    sa.Column('ftp_user', sa.String(length=512), nullable=True),
    sa.Column('ftp_password', sa.String(length=512), nullable=True),
    sa.Column('ftp_dir', sa.String(length=512), nullable=True),
    sa.Column('ftp_file_name', sa.String(length=512), nullable=True),
    sa.Column('ftp_max_lines', sa.Integer(), nullable=True),
    sa.Column('ftp_compress', sa.String(length=512), nullable=True),
    sa.Column('ftp_include_headers', sa.SmallInteger(), nullable=True),
    sa.Column('ftp_file_breakdown', sa.SmallInteger(), nullable=True),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['sender_id'], ['mail_sender.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('request_id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('cdr_async_task')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))