"""mail_sender unique username

Revision ID: ec7378a06bb4
Revises: 22851e94e437
Create Date: 2017-11-14 04:01:22.296129

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'ec7378a06bb4'
down_revision = '22851e94e437'
branch_labels = None
depends_on = None


def upgrade():
    connection = op.get_bind()
    connection.execute("delete from mail_sender where ctid not in (select max(ctid) from mail_sender s  group by s.name)")
    connection.execute("delete from mail_sender where ctid not in (select max(ctid) from mail_sender s  group by s.username)")
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date', 'client_id'], unique=True)
    op.create_unique_constraint(None, 'mail_sender', ['name'])
    op.create_unique_constraint(None, 'mail_sender', ['username'])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'mail_sender', type_='unique')
    op.drop_constraint(None, 'mail_sender', type_='unique')
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date'], unique=False)
    # ### end Alembic commands ###
