"""shaken_ani_group_list_rel

Revision ID: f1a53bda6862
Revises: d21166e81f31
Create Date: 2021-06-16 16:13:40.843133

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = 'f1a53bda6862'
down_revision = 'd21166e81f31'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('shaken_ani_group_list',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Text(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('shaken_ani_group_list_rel',
    sa.Column('ani_group_list_id', sa.Integer(), nullable=False),
    sa.Column('ani_group_id', sa.Integer(), nullable=False),
    sa.Column('attest_lvl', sa.String(length=1), nullable=False),
    sa.CheckConstraint("(attest_lvl = 'A' OR attest_lvl = 'B' OR attest_lvl = 'C')"),
    sa.ForeignKeyConstraint(['ani_group_id'], ['shaken_ani_group.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['ani_group_list_id'], ['shaken_ani_group_list.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('ani_group_list_id', 'ani_group_id')
    )
    op.add_column('resource', sa.Column('shaken_ani_group_list_id', sa.Integer(), nullable=True))
    #op.add_column('resource', sa.Column('shaken_default_attest_lvl', sa.String(length=1), server_default='A', nullable=False))
    op.create_index(op.f('ix_resource_shaken_ani_group_list_id'), 'resource', ['shaken_ani_group_list_id'], unique=False)
    op.drop_index('ix_resource_shaken_ani_group_id', table_name='resource')
    op.drop_constraint('resource_shaken_ani_group_id_fkey', 'resource', type_='foreignkey')
    op.create_foreign_key(None, 'resource', 'shaken_ani_group_list', ['shaken_ani_group_list_id'], ['id'], ondelete='SET NULL')
    op.drop_column('resource', 'shaken_ani_group_id')
    # ### end Alembic commands ###
    connection = op.get_bind()
    connection.execute("""
COMMENT ON COLUMN shaken_ani_group_list_rel.attest_lvl IS
'SHAKEN attestation level: A/B/C';
COMMENT ON COLUMN resource.shaken_ani_group_list_id IS
'SHAKEN ANI pool configuration';
ALTER TABLE resource ADD COLUMN shaken_default_attest_lvl varchar(1) NOT NULL DEFAULT 'A'
CHECK (shaken_default_attest_lvl = 'A' OR shaken_default_attest_lvl = 'B' OR shaken_default_attest_lvl = 'C');
COMMENT ON COLUMN resource.shaken_default_attest_lvl IS
'Default SHAKEN attestation level (for numbers outside of ANI pools)';
    """)

    up_rec('resource')
    up_rec('shaken_ani_group_list_rel')

def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('resource', sa.Column('shaken_ani_group_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.drop_constraint(None, 'resource', type_='foreignkey')
    op.create_foreign_key('resource_shaken_ani_group_id_fkey', 'resource', 'shaken_ani_group', ['shaken_ani_group_id'], ['id'], ondelete='SET NULL')
    op.create_index('ix_resource_shaken_ani_group_id', 'resource', ['shaken_ani_group_id'], unique=False)
    op.drop_index(op.f('ix_resource_shaken_ani_group_list_id'), table_name='resource')
    op.drop_column('resource', 'shaken_default_attest_lvl')
    op.drop_column('resource', 'shaken_ani_group_list_id')
    op.drop_table('shaken_ani_group_list_rel')
    op.drop_table('shaken_ani_group_list')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))