"""client_invoice_settings

Revision ID: f63823344961
Revises: 9238f53a4c08
Create Date: 2019-09-03 22:11:42.120001

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'f63823344961'
down_revision = '9238f53a4c08'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('client_invoice_settings',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('invoice_name', sa.String(length=200), nullable=True),
    sa.Column('tpl_number', sa.Integer(), nullable=True),
    sa.Column('pdf_tpl', sa.Text(), nullable=True),
    sa.Column('company_info', sa.String(length=500), nullable=True),
    sa.Column('overlap_invoice_protection', sa.Boolean(), nullable=True),
    sa.Column('send_cdr_fields', sa.Text(), nullable=True),
    sa.Column('invoice_send_mode', sa.SmallInteger(), nullable=True),
    sa.Column('company_info_location', sa.SmallInteger(), nullable=True),
    sa.Column('invoice_decimal_digits', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.add_column('client', sa.Column('client_invoice_settings_id', sa.Integer(), nullable=True))
    op.create_index(op.f('ix_client_client_invoice_settings_id'), 'client', ['client_invoice_settings_id'], unique=False)
    op.create_foreign_key(None, 'client', 'client_invoice_settings', ['client_invoice_settings_id'], ['id'], ondelete='SET NULL')
    # ### end Alembic commands ###



def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'client', type_='foreignkey')
    op.drop_index(op.f('ix_client_client_invoice_settings_id'), table_name='client')
    op.drop_column('client', 'client_invoice_settings_id')
    op.drop_table('client_invoice_settings')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger class4_trig_record_{table} on {table};
drop table {table}_record;
DROP FUNCTION class4_trigfun_record_{table}();
DROP SEQUENCE {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))