# coding: utf-8
#CLAS-6956
from falcon_rest.db import orm, Column, fields, get_db
from sqlalchemy import (
	Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger, Enum,
	Table, Sequence, ARRAY, FetchedValue, CHAR,JSON,Numeric,text
)
from sqlalchemy.sql import func ,cast,select ,alias,and_,or_
from sqlalchemy.ext.hybrid import hybrid_property, hybrid_method
from sqlalchemy.orm import backref,foreign, remote,column_property
from falcon_rest import schemes
from falcon_rest.logger import log
from falcon_rest.resources import resources
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.fields.choice import ChoiceType
from api_dnl.models.user import User


Base = DnlApiBaseModel
metadata = Base.metadata


t_did_invoice_number_fee_detail = Table(
    'did_invoice_number_fee_detail', metadata,
    Column('invoice_number', Integer, nullable=False, index=True),
    Column('did_number', String(64), nullable=False),
    Column('nrc', Numeric(32, 6), nullable=False, server_default=text("0.00")),
    Column('mrc', Numeric(32, 6), nullable=False, server_default=text("0.00"))
)


t_did_setup_fee = Table(
    'did_setup_fee', metadata,
    Column('invoice_number', Integer, nullable=False, index=True),
    Column('client_id', Integer, nullable=False, index=True),
    Column('did_number', String(64), nullable=False, index=True),
    Column('fee', Numeric(32, 6), nullable=False, server_default=text("0.00"))
)


t_dnl_invoice_history = Table(
    'dnl_invoice_history', metadata,
    Column('client_id', Integer, nullable=False, index=True),
    Column('last_succ_invoice_number', Integer),
    Column('last_succ_invoice_end_time', Numeric),
    Column('invoice_generation_time', DateTime),
    Column('invoice_end_time', Numeric),
    Column('status', SmallInteger, nullable=False, server_default=text("0")),
    Column('result', String(256))
)


t_invoice_code_name_detail = Table(
    'invoice_code_name_detail', metadata,
    Column('invoice_number', Integer, nullable=False, index=True),
    Column('code_name', String(256)),
    Column('rate', Numeric(32, 6)),
    Column('total_calls', Integer, nullable=False, server_default=text("0")),
    Column('total_minutes', Numeric(32, 6), nullable=False, server_default=text("0.00")),
    Column('total_amount', Numeric(32, 6), nullable=False, server_default=text("0.00")),
    Column('inter_calls', Integer),
    Column('intra_calls', Integer),
    Column('ij_calls', Integer),
    Column('inter_minutes', Numeric(32, 6)),
    Column('intra_minutes', Numeric(32, 6)),
    Column('ij_minutes', Numeric(32, 6)),
    Column('inter_amount', Numeric(32, 6)),
    Column('intra_amount', Numeric(32, 6)),
    Column('ij_amount', Numeric(32, 6))
)


t_invoice_country_detail = Table(
    'invoice_country_detail', metadata,
    Column('invoice_number', Integer, nullable=False, index=True),
    Column('country', String(256)),
    Column('total_calls', Integer, nullable=False, server_default=text("0")),
    Column('total_minutes', Numeric(32, 6), nullable=False, server_default=text("0.00")),
    Column('total_amount', Numeric(32, 6), nullable=False, server_default=text("0.00"))
)


t_invoice_daily_detail = Table(
    'invoice_daily_detail', metadata,
    Column('invoice_number', Integer, nullable=False, index=True),
    Column('report_date', Date),
    Column('total_calls', Integer, nullable=False, server_default=text("0")),
    Column('total_minutes', Numeric(32, 6), nullable=False, server_default=text("0.00")),
    Column('total_amount', Numeric(32, 6), nullable=False, server_default=text("0.00")),
    Column('inter_calls', Integer),
    Column('intra_calls', Integer),
    Column('ij_calls', Integer),
    Column('inter_minutes', Numeric(32, 6)),
    Column('intra_minutes', Numeric(32, 6)),
    Column('ij_minutes', Numeric(32, 6)),
    Column('inter_amount', Numeric(32, 6)),
    Column('intra_amount', Numeric(32, 6)),
    Column('ij_amount', Numeric(32, 6)),
    Column('did_number', String(64))
)


class InvoiceSummary(Base):
    __tablename__ = 'invoice_summary'

    invoice_number = Column(Integer, primary_key=True, server_default=text("nextval('invoice_summary_invoice_number_seq'::regclass)"))
    client_id = Column(Integer, nullable=False, index=True)
    invoice_generation_time = Column(DateTime, index=True)
    invoice_start_time = Column(DateTime)
    invoice_end_time = Column(DateTime)
    payment_dur_date = Column(Date)
    invoice_zone = Column(String(20))
    payment_id = Column(Integer)
    current_balance = Column(Numeric(32, 6), nullable=False, server_default=text("0.00"))
    previous_balance = Column(Numeric(32, 6), nullable=False, server_default=text("0.00"))
    payments_and_credits = Column(Numeric(32, 6), nullable=False, server_default=text("0.00"))
    balance_forward = Column(Numeric(32, 6), nullable=False, server_default=text("0.00"))
    long_distance_charges = Column(Numeric(32, 6), nullable=False, server_default=text("0.00"))
    taxes = Column(Numeric(32, 6), nullable=False, server_default=text("0.00"))
    scc_amount = Column(Numeric(32, 6), nullable=False, server_default=text("0.00"))
    current_charges = Column(Numeric(32, 6), nullable=False, server_default=text("0.00"))
    total_calls = Column(Integer, nullable=False, server_default=text("0"))
    total_minutes = Column(Numeric(32, 6), nullable=False, server_default=text("0.00"))
    total_amount = Column(Numeric(32, 6), nullable=False, server_default=text("0.00"))
    unlimited_credit = Column(Boolean, nullable=False, server_default=text("false"))
    include_tax = Column(Boolean, nullable=False, server_default=text("false"))
    include_scc_charges = Column(Boolean, nullable=False, server_default=text("false"))
    include_daily_details = Column(Boolean, nullable=False, server_default=text("false"))
    include_country_details = Column(Boolean, nullable=False, server_default=text("false"))
    include_code_name_details = Column(Boolean, nullable=False, server_default=text("false"))
    include_trunk_details = Column(Boolean, nullable=False, server_default=text("false"))
    include_trunk_prefix_details = Column(Boolean, nullable=False, server_default=text("false"))
    invoice_type = Column(SmallInteger, nullable=False, server_default=text("0"))
    did_mrc = Column(Numeric(32, 6), nullable=False, server_default=text("0.00"))
    did_nrc = Column(Numeric(32, 6), nullable=False, server_default=text("0.00"))
    create_time = Column(DateTime(True), server_default=text("('now'::text)::timestamp(0) with time zone"))


t_invoice_trunk_detail = Table(
    'invoice_trunk_detail', metadata,
    Column('invoice_number', Integer, nullable=False, index=True),
    Column('trunk_id', Integer, nullable=False),
    Column('total_calls', Integer, nullable=False, server_default=text("0")),
    Column('total_minutes', Numeric(32, 6), nullable=False, server_default=text("0.00")),
    Column('total_amount', Numeric(32, 6), nullable=False, server_default=text("0.00")),
    Column('inter_calls', Integer),
    Column('intra_calls', Integer),
    Column('ij_calls', Integer),
    Column('inter_minutes', Numeric(32, 6)),
    Column('intra_minutes', Numeric(32, 6)),
    Column('ij_minutes', Numeric(32, 6)),
    Column('inter_amount', Numeric(32, 6)),
    Column('intra_amount', Numeric(32, 6)),
    Column('ij_amount', Numeric(32, 6))
)


t_invoice_trunk_prefix_detail = Table(
    'invoice_trunk_prefix_detail', metadata,
    Column('invoice_number', Integer, nullable=False, index=True),
    Column('trunk_id', Integer, nullable=False),
    Column('prefix', String(100)),
    Column('total_calls', Integer, nullable=False, server_default=text("0")),
    Column('total_minutes', Numeric(32, 6), nullable=False, server_default=text("0.00")),
    Column('total_amount', Numeric(32, 6), nullable=False, server_default=text("0.00")),
    Column('inter_calls', Integer),
    Column('intra_calls', Integer),
    Column('ij_calls', Integer),
    Column('inter_minutes', Numeric(32, 6)),
    Column('intra_minutes', Numeric(32, 6)),
    Column('ij_minutes', Numeric(32, 6)),
    Column('inter_amount', Numeric(32, 6)),
    Column('intra_amount', Numeric(32, 6)),
    Column('ij_amount', Numeric(32, 6))
)


class ManualInvoiceTask(Base):
    __tablename__ = 'manual_invoice_task'

    id = Column(Integer, primary_key=True, server_default=text("nextval('manual_invoice_task_id_seq'::regclass)"))
    operator_user = Column(String(40))
    client_id = Column(Integer, nullable=False)
    start_date = Column(Date)
    end_date = Column(Date)
    timezone = Column(String(20))
    include_tax = Column(Boolean, nullable=False, server_default=text("false"))
    include_scc_charges = Column(Boolean, nullable=False, server_default=text("false"))
    include_daily_details = Column(Boolean, nullable=False, server_default=text("false"))
    include_country_details = Column(Boolean, nullable=False, server_default=text("false"))
    include_code_name_details = Column(Boolean, nullable=False, server_default=text("false"))
    include_trunk_details = Column(Boolean, nullable=False, server_default=text("false"))
    include_trunk_prefix_details = Column(Boolean, nullable=False, server_default=text("false"))
    status = Column(SmallInteger, nullable=False, server_default=text("0"))
    invoice_number = Column(Integer)
    progress = Column(String(1024))
    proc_start_time = Column(DateTime(True))
    proc_end_time = Column(DateTime(True))
    create_time = Column(DateTime(True), server_default=text("('now'::text)::timestamp(0) with time zone"))





