import json
import sys, os
from urllib.parse import parse_qsl, urlencode
from datetime import date, datetime, timedelta
import traceback
from pytz import UTC
import mimetypes
from time import mktime
from dateutil.parser import parse as parse_datetime
import falcon
from sqlalchemy.orm import aliased, make_transient, foreign
from sqlalchemy import or_, and_, select, inspect, text as text_
from api_dnl import model, settings
from falcon_rest.logger import log
from falcon_rest.responses import responses
from falcon_rest.responses import errors
from falcon_rest.resources.resources import swagger, ResourcesBaseClass, DEFAULT_SECURITY, ATTRIBUTE_ERROR_RE

from api_dnl.resources import DnlResource, DnlList, DnlCreate, CustomAction, CustomPatchAction, ValidationError, \
    client_context, check_context
from api_dnl.schemes.fault_route_alert_rule import *
from api_dnl.view import NoResultFound, DEFAULT_SECURITY, OperationErrorResponse, generate_uuid_str



#region +++FaultRouteAlertRule+++
class FaultRouteAlertRuleCreate(DnlCreate):
    scheme_class = FaultRouteAlertRuleScheme
    model_class = model.FaultRouteAlertRule
    entity = 'FaultRouteAlertRule'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        #obj.created_by=user.name
        #obj.created_on=datetime.now(UTC)
        if obj.product_id and obj.routing_plan_id:
            raise ValidationError("criteria sholud be only product_id or routing_plan_id, not both")
        obj.next_run_on = obj.next_run(datetime.now(UTC))
        return obj

class FaultRouteAlertRuleResource(DnlResource):
    model_class = model.FaultRouteAlertRule
    scheme_class = FaultRouteAlertRuleScheme
    scheme_class_get = FaultRouteAlertRuleSchemeGet
    scheme_class_modify = FaultRouteAlertRuleSchemeModify
    entity = 'FaultRouteAlertRule'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()

    def after_update(self, result, obj, data):
        obj.next_run_on = obj.next_run(datetime.now(UTC))
        obj.save()

class FaultRouteAlertRuleList(DnlList):
    scheme_class = FaultRouteAlertRuleSchemeGet
    model_class = model.FaultRouteAlertRule
    entity_plural = 'FaultRouteAlertRules'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
            #ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret
#endregion ---FaultRouteAlertRule---

#region +++FaultRouteAlertRuleLog+++
class FaultRouteAlertRuleLogCreate(DnlCreate):
    scheme_class = FaultRouteAlertRuleLogScheme
    model_class = model.FaultRouteAlertRuleLog
    entity = 'FaultRouteAlertRuleLog'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        #obj.created_by=user.name
        #obj.created_on=datetime.now(UTC)
        return obj
class FaultRouteAlertRuleLogResource(DnlResource):
    model_class = model.FaultRouteAlertRuleLog
    scheme_class = FaultRouteAlertRuleLogScheme
    scheme_class_get = FaultRouteAlertRuleLogSchemeGet
    scheme_class_modify = FaultRouteAlertRuleLogSchemeModify
    entity = 'FaultRouteAlertRuleLog'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()
class FaultRouteAlertRuleLogList(DnlList):
    scheme_class = FaultRouteAlertRuleLogSchemeGet
    model_class = model.FaultRouteAlertRuleLog
    entity_plural = 'FaultRouteAlertRuleLogs'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
            #ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret
#endregion ---FaultRouteAlertRuleLog---


### end ###