import json
import sys, os
from urllib.parse import parse_qsl, urlencode
from datetime import date, datetime, timedelta
import traceback
from pytz import UTC
import mimetypes
from time import mktime
from dateutil.parser import parse as parse_datetime
import falcon
from sqlalchemy.orm import aliased, make_transient, foreign
from sqlalchemy import or_, and_, select, inspect, text as text_
from api_dnl import model, settings
from falcon_rest.logger import log
from falcon_rest.responses import responses
from falcon_rest.responses import errors
from falcon_rest.resources.resources import swagger, ResourcesBaseClass, DEFAULT_SECURITY, ATTRIBUTE_ERROR_RE

from api_dnl.resources import DnlResource, DnlList, DnlCreate, CustomAction, CustomPatchAction, ValidationError, \
    client_context, check_context
from api_dnl.schemes.log import *
from api_dnl.view import NoResultFound, DEFAULT_SECURITY, OperationErrorResponse, generate_uuid_str


# region +++ AuthorizationLog
class AuthorizationLogList(DnlList):
    scheme_class = AuthorizationLogGetScheme
    model_class = model.AuthorizationLog
    entity_plural = 'AuthorizationLog'
    path_parameters = ()
    security = DEFAULT_SECURITY
    restrict = ()

    def modify_query_from_ordering_for_list(self, ordering, query, **kwargs):
        if ordering and ordering['by'] == 'login_time':
            ordering['by'] = 'time'
        return ordering, query

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        ret = self.model_class.query()
        filt = {}
        query_fields = self.scheme_class.Meta.query_fields if hasattr(self.scheme_class.Meta, 'query_fields') else []
        if filtering:
            for k, v in filtering.items():
                if query_fields and k in query_fields:
                    if 'login_time' in k:
                        k = k.replace('login_time', 'time')
                        d = parse_datetime(v)
                        if not d.tzinfo:
                            d = d.replace(tzinfo=UTC)
                        v = str(int(mktime(d.timetuple())))
                    fop = self.parse_query_field(k, self.model_class)[0]
                    ret = ret.filter(text_(fop.format(v)))
                    continue
                filt[k] = v

        return filt, ret


class PgStatActivityList(DnlList):
    scheme_class = PgStatActivityScheme
    model_class = model.PgStatActivity
    entity_plural = 'PgStatActivity'
    path_parameters = ()
    security = DEFAULT_SECURITY
    restrict = ()


# endregion --- AuthorizationLog


# region +++WatchdogSystemdLog+++
class WatchdogSystemdLogList(DnlList):
    scheme_class = WatchdogSystemdLogSchemeGet
    model_class = model.WatchdogSystemdLog
    entity_plural = 'WatchdogSystemdLogs'
    path_parameters = ()
    security = DEFAULT_SECURITY
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        return filt, ret
# endregion ---WatchdogSystemdLog---

#region +++WatchdogSystemdEvents+++
class WatchdogSystemdEventsList(DnlList):
    scheme_class = WatchdogSystemdEventsSchemeGet
    model_class = model.WatchdogSystemdEvents
    entity_plural = 'WatchdogSystemdEventss'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
            #ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret
#endregion ---WatchdogSystemdEvents---



#region +++DidClientLog+++
class DidClientLogCreate(DnlCreate):
    scheme_class = DidClientLogScheme
    model_class = model.DidClientLog
    entity = 'DidClientLog'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        #obj.created_by=user.name
        #obj.created_on=datetime.now(UTC)
        return obj


class DidClientLogResource(DnlResource):
    model_class = model.DidClientLog
    scheme_class = DidClientLogScheme
    scheme_class_get = DidClientLogSchemeGet
    scheme_class_modify = DidClientLogSchemeModify
    entity = 'DidClientLog'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class DidClientLogList(DnlList):
    scheme_class = DidClientLogSchemeGet
    model_class = model.DidClientLog
    entity_plural = 'DidClientLogs'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
            #ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret


class DidRepositoryLogList(DnlList):
    scheme_class = DidRepositoryLogScheme
    model_class = model.DidRepositoryLog
    entity_plural = 'DidClientLogs'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def get_spec(self):
        sfields_names, search_fields_list = self.get_fields_from_scheme(self.scheme_class)
        fields_names = list(set(sfields_names))
        return swagger.specify.get_spec(
            method='get', description='Gets {}'.format(self.entity_plural.lower()),
            path_parameters=self.path_parameters,
            query_parameters=[{'name': 'fields', 'type': 'string'},
                              {'name': 'page', 'type': 'integer'}, {'name': 'per_page', 'type': 'integer'},
                              {'name': 'order_by', 'enum': fields_names},
                              {'name': 'order_dir', 'enum': ['asc', 'desc']}
                              ] + search_fields_list,
            responses=(
                          responses.SuccessResponseObjectsList(payload_scheme_items=self.scheme_class),
                          responses.AttributeNotExitsErrorResponse()
                      ) + self.get_additional_responses(method='get'),
            security=self.get_security(method='get')
        )



class DidAssignmentsLogList(DnlList):
    scheme_class = DidAssignmentsLogScheme
    model_class = model.DidAssignmentsLog
    entity_plural = 'DidAssignmentsLogs'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()


#endregion ---DidClientLog---


#region +++DidVendorLog+++
class DidVendorLogCreate(DnlCreate):
    scheme_class = DidVendorLogScheme
    model_class = model.DidVendorLog
    entity = 'DidVendorLog'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        #obj.created_by=user.name
        #obj.created_on=datetime.now(UTC)
        return obj
class DidVendorLogResource(DnlResource):
    model_class = model.DidVendorLog
    scheme_class = DidVendorLogScheme
    scheme_class_get = DidVendorLogSchemeGet
    scheme_class_modify = DidVendorLogSchemeModify
    entity = 'DidVendorLog'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()
class DidVendorLogList(DnlList):
    scheme_class = DidVendorLogSchemeGet
    model_class = model.DidVendorLog
    entity_plural = 'DidVendorLogs'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()
    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
            #ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret
#endregion ---DidVendorLog---


