"""lerg

Revision ID: 4074696415cd
Revises: fd66173551bc
Create Date: 2020-05-20 17:11:06.996917

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '4074696415cd'
down_revision = 'fd66173551bc'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('lerg',
    sa.Column('uuid', sa.String(length=36), server_default=sa.text('uuid_generate_v4()'), nullable=False),
    sa.Column('npa', sa.String(length=3), nullable=True),
    sa.Column('nxx', sa.String(length=3), nullable=True),
    sa.Column('thousands', sa.String(length=2), nullable=True),
    sa.Column('state', sa.String(length=2), nullable=True),
    sa.Column('company', sa.String(length=128), nullable=True),
    sa.Column('ocn', sa.String(length=6), nullable=True),
    sa.Column('ratecenter', sa.String(length=16), nullable=True),
    sa.Column('clli', sa.String(length=16), nullable=True),
    sa.Column('assign_date', sa.String(length=10), nullable=True),
    sa.Column('prefix_type', sa.String(length=18), nullable=True),
    sa.Column('switch_name', sa.String(length=48), nullable=True),
    sa.Column('switch_type', sa.String(length=64), nullable=True),
    sa.Column('lata', sa.String(length=3), nullable=True),
    sa.Column('country', sa.String(length=2), nullable=True),
    sa.PrimaryKeyConstraint('uuid')
    )
    op.create_index(op.f('ix_lerg_npa'), 'lerg', ['npa'], unique=False)
    op.create_index(op.f('ix_lerg_nxx'), 'lerg', ['nxx'], unique=False)
    op.create_index(op.f('ix_lerg_thousands'), 'lerg', ['thousands'], unique=False)
    op.create_table('lerg_import_task',
    sa.Column('uuid', sa.String(length=36), server_default=sa.text('uuid_generate_v4()'), nullable=False),
    sa.Column('status', api_dnl.migration_types.ChoiceType({}), server_default='0', nullable=False),
    sa.Column('result', sa.Text(), nullable=True),
    sa.Column('file', sa.String(length=512), nullable=True),
    sa.Column('created_on', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('created_by', sa.String(length=255), nullable=True),
    sa.Column('finished_on', sa.DateTime(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('uuid')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('lerg_import_task')
    op.drop_index(op.f('ix_lerg_thousands'), table_name='lerg')
    op.drop_index(op.f('ix_lerg_nxx'), table_name='lerg')
    op.drop_index(op.f('ix_lerg_npa'), table_name='lerg')
    op.drop_table('lerg')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))