"""produc clients ref used

Revision ID: 72b82a843a71
Revises: 2d5aae6bae08
Create Date: 2018-05-04 16:35:44.792190

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '72b82a843a71'
down_revision = '2d5aae6bae08'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('product_clients_ref_used',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('product_id', sa.Integer(), nullable=True),
    sa.Column('client_id', sa.Integer(), nullable=True),
    sa.Column('rate_last_sent', sa.DateTime(timezone=True), nullable=True),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['product_id'], ['product_rout_rate_table.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('product_id', 'client_id')
    )
    op.create_unique_constraint(None, 'product_clients_ref', ['product_id', 'client_id'])
    op.drop_column('product_clients_ref', 'rate_last_sent')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('product_clients_ref', sa.Column('rate_last_sent', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True))
    op.drop_constraint(None, 'product_clients_ref', type_='unique')
    op.drop_table('product_clients_ref_used')
    # ### end Alembic commands ###
