"""Fix upgrade from 79fe4181f801/fe524019

Revision ID: 8e612290be3a
Revises: 1904f0d9de74
Create Date: 2025-05-21 13:13:56.924063

"""

from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp, os


# revision identifiers, used by Alembic.
revision = "8e612290be3a"
down_revision = "1904f0d9de74"
branch_labels = None
depends_on = None


def upgrade():
    upgrade_sql = """
BEGIN;

ALTER TABLE cdr_report_daily ALTER COLUMN pdd_count TYPE bigint;

--
-- [SIPSWITCH-551]: Fix DID repository
--

--
-- Remove assignments, which belong to deleted clients
--
DO $remove_deleted_clients$
DECLARE
    _rec record;
BEGIN
    FOR _rec IN
        SELECT DISTINCT resource_id FROM resource_record
            WHERE client_id NOT IN (SELECT client_id FROM client)
    LOOP
        DELETE FROM did_assignments WHERE client_trunk_id = _rec.resource_id
            OR vendor_trunk_id = _rec.resource_id;
        DELETE FROM did_assignments_log
            WHERE client_trunk_id = _rec.resource_id
            OR vendor_trunk_id = _rec.resource_id;
        DELETE FROM did_repository WHERE vendor_trunk_id = _rec.resource_id;
        DELETE FROM did_repository_log
            WHERE vendor_trunk_id = _rec.resource_id;
        DELETE FROM did_transaction WHERE client_id = _rec.resource_id;
    END LOOP;
END $remove_deleted_clients$ LANGUAGE plpgsql;


-- Tbl: did_repository
--

-- link to client
ALTER TABLE did_repository ADD COLUMN IF NOT EXISTS vendor_id integer;
ALTER TABLE did_repository
    DROP CONSTRAINT IF EXISTS did_repository_vendor_id_fkey;
ALTER TABLE ONLY did_repository
    ADD CONSTRAINT did_repository_vendor_id_fkey FOREIGN KEY (vendor_id)
    REFERENCES client(client_id) ON DELETE RESTRICT;
UPDATE did_repository SET vendor_id = resource.client_id FROM resource
    WHERE did_repository.vendor_trunk_id = resource.resource_id;
UPDATE did_repository SET vendor_id = res.client_id FROM resource_record AS res
    WHERE vendor_id IS NULL AND vendor_trunk_id = res.resource_id
    AND res.client_id IS NOT NULL;
ALTER TABLE did_repository ALTER COLUMN vendor_id SET NOT NULL;
-- Restrict trunk removal
ALTER TABLE did_repository
    DROP CONSTRAINT IF EXISTS fk_did_repository_vendor_trunk_id;
ALTER TABLE did_repository ADD CONSTRAINT fk_did_repository_vendor_trunk_id
    FOREIGN KEY (vendor_trunk_id)
    REFERENCES resource(resource_id) ON DELETE RESTRICT;
-- Restrict billing plan removal
ALTER TABLE did_repository
    DROP CONSTRAINT IF EXISTS fk_did_repository_vendor_billing_plan_id;
ALTER TABLE did_repository
    ADD CONSTRAINT fk_did_repository_vendor_billing_plan_id
    FOREIGN KEY (vendor_billing_plan_id)
    REFERENCES did_billing_plan(id) ON DELETE RESTRICT;

-- Tbl: did_assignments
--

-- link to client
ALTER TABLE did_assignments ADD COLUMN IF NOT EXISTS client_id bigint
    REFERENCES client(client_id);
UPDATE did_assignments SET client_id = res.client_id FROM resource AS res
    WHERE client_trunk_id = res.resource_id;
UPDATE did_assignments SET client_id = res.client_id
    FROM resource_record AS res
    WHERE did_assignments.client_id IS NULL
    AND client_trunk_id = res.resource_id AND res.client_id IS NOT NULL;
ALTER TABLE did_assignments ALTER COLUMN client_id SET NOT NULL;
-- link to vendor
ALTER TABLE did_assignments ADD COLUMN IF NOT EXISTS vendor_id bigint;
ALTER TABLE did_assignments
    DROP CONSTRAINT IF EXISTS did_assignments_vendor_id_fkey;
ALTER TABLE did_assignments
    ADD CONSTRAINT did_assignments_vendor_id_fkey FOREIGN KEY (vendor_id)
    REFERENCES public.client(client_id) ON DELETE RESTRICT;
UPDATE did_assignments SET vendor_id = res.client_id FROM resource AS res
    WHERE vendor_trunk_id = res.resource_id;
UPDATE did_assignments SET vendor_id = res.client_id
    FROM resource_record AS res
    WHERE vendor_id IS NULL AND vendor_trunk_id = res.resource_id
    AND res.client_id IS NOT NULL;
ALTER TABLE did_assignments ALTER COLUMN vendor_id SET NOT NULL;
-- billing info snapshot at the time of the assignent
ALTER TABLE did_assignments ADD COLUMN IF NOT EXISTS vendor_mrc_cycle integer;
ALTER TABLE did_assignments ADD COLUMN IF NOT EXISTS vendor_mrc numeric;
ALTER TABLE did_assignments ADD COLUMN IF NOT EXISTS vendor_nrc numeric;
ALTER TABLE did_assignments ADD COLUMN IF NOT EXISTS client_mrc_cycle integer;
ALTER TABLE did_assignments ADD COLUMN IF NOT EXISTS client_mrc numeric;
ALTER TABLE did_assignments ADD COLUMN IF NOT EXISTS client_nrc numeric;
-- Restrict trunk deletion
ALTER TABLE did_assignments
    DROP CONSTRAINT IF EXISTS fk_did_assignments_vendor_trunk_id;
ALTER TABLE did_assignments ADD CONSTRAINT fk_did_assignments_vendor_trunk_id
    FOREIGN KEY (vendor_trunk_id)
    REFERENCES resource(resource_id) ON DELETE RESTRICT;
ALTER TABLE did_assignments
    DROP CONSTRAINT IF EXISTS fk_did_assignments_client_trunk_id;
ALTER TABLE did_assignments ADD CONSTRAINT fk_did_assignments_client_trunk_id
    FOREIGN KEY (client_trunk_id)
    REFERENCES resource(resource_id) ON DELETE RESTRICT;
ALTER TABLE did_assignments
    DROP CONSTRAINT IF EXISTS fk_did_assignments_fallback_id;
ALTER TABLE did_assignments ADD CONSTRAINT fk_did_assignments_fallback_id
    FOREIGN KEY (fallback_id)
    REFERENCES resource(resource_id) ON DELETE RESTRICT;
-- Restring billing data deletion
ALTER TABLE did_assignments
    DROP CONSTRAINT IF EXISTS fk_did_assignments_vendor_billing_plan_id;
ALTER TABLE did_assignments ADD CONSTRAINT
    fk_did_assignments_vendor_billing_plan_id
    FOREIGN KEY (vendor_billing_plan_id)
    REFERENCES did_billing_plan(id) ON DELETE RESTRICT;
ALTER TABLE did_assignments
    DROP CONSTRAINT IF EXISTS fk_did_assignments_client_billing_plan_id;
ALTER TABLE did_assignments
    ADD CONSTRAINT fk_did_assignments_client_billing_plan_id
    FOREIGN KEY (client_billing_plan_id)
    REFERENCES did_billing_plan(id) ON DELETE RESTRICT;

-- Tbl: did_repository_log
--

-- Add link to vendor
ALTER TABLE did_repository_log ADD COLUMN IF NOT EXISTS vendor_id integer;
-- Use timestamps instead of dates
ALTER TABLE did_repository_log ADD COLUMN IF NOT EXISTS
    created_at_time timestamp with time zone;
ALTER TABLE did_repository_log ADD COLUMN IF NOT EXISTS
    deleted_at_time timestamp with time zone;

-- Tbl: did_assignments_log
--
ALTER TABLE did_assignments_log ADD COLUMN IF NOT EXISTS vendor_id integer;
ALTER TABLE did_assignments_log ADD COLUMN IF NOT EXISTS vendor_mrc numeric;
ALTER TABLE did_assignments_log
    ADD COLUMN IF NOT EXISTS vendor_mrc_cycle integer;
ALTER TABLE did_assignments_log ADD COLUMN IF NOT EXISTS vendor_nrc numeric;
ALTER TABLE did_assignments_log ADD COLUMN IF NOT EXISTS client_id integer;
ALTER TABLE did_assignments_log ADD COLUMN IF NOT EXISTS client_mrc numeric;
ALTER TABLE did_assignments_log
    ADD COLUMN IF NOT EXISTS client_mrc_cycle integer;
ALTER TABLE did_assignments_log ADD COLUMN IF NOT EXISTS client_nrc numeric;
-- Use timestamps instead of dates
ALTER TABLE did_assignments_log
    ADD COLUMN IF NOT EXISTS created_at_time timestamp with time zone;
ALTER TABLE did_assignments_log
    ADD COLUMN IF NOT EXISTS deleted_at_time timestamp with time zone;

-- Delete port fees from everywhere
ALTER TABLE did_billing_plan DROP COLUMN IF EXISTS fee_per_port;
ALTER TABLE did_billing_plan_record DROP COLUMN IF EXISTS fee_per_port;
ALTER TABLE did_transaction DROP COLUMN IF EXISTS port_fee;

-- Drop invalid switch_profile columns
ALTER TABLE switch_profile DROP COLUMN IF EXISTS self_cap;
ALTER TABLE switch_profile DROP COLUMN IF EXISTS self_cps;


--
-- Set default currency id in client table
--
ALTER TABLE client ALTER COLUMN currency_id SET DEFAULT 1;

--
-- Drop unnecessary triggers
--
DROP TRIGGER IF EXISTS class4_trig_client_cdr_insert ON client_cdr;
DROP FUNCTION IF EXISTS class4_trigfun_cdr_insert;

DROP TRIGGER IF EXISTS class4_trig_client_report_detail_insert
    ON cdr_report_detail;
DROP FUNCTION IF EXISTS class4_trigfun_report_detail_insert;

DROP TRIGGER IF EXISTS class4_trig_did_report_insert ON did_report;
DROP FUNCTION IF EXISTS class4_trigfun_did_report_insert;

DROP TRIGGER IF EXISTS class4_trig_chost_based_report_insert
    ON host_based_report;
DROP FUNCTION IF EXISTS class4_trigfun_host_based_report_insert;

-- Fix invalid trigger
DROP TRIGGER IF EXISTS class4_trig_record_resource_capacity
    ON public.resource_capacity;
DROP FUNCTION IF EXISTS public.class4_trigfun_record_resource_capacity;

CREATE FUNCTION public.class4_trigfun_record_resource_capacity() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    if (TG_OP='INSERT') then
            INSERT INTO public.resource_capacity_record SELECT NEW.*,EXTRACT(EPOCH FROM current_timestamp(0)),'I';
    elseif (TG_OP='DELETE') then
            INSERT INTO public.resource_capacity_record SELECT OLD.*,EXTRACT(EPOCH FROM current_timestamp(0)),'D';
    elseif (TG_OP='UPDATE') then
            INSERT INTO public.resource_capacity_record SELECT OLD.*,EXTRACT(EPOCH FROM current_timestamp(0)),'B';
            INSERT INTO public.resource_capacity_record SELECT NEW.*,EXTRACT(EPOCH FROM current_timestamp(0)),'A';
    end if;
    return null;
END;
$$;
ALTER FUNCTION public.class4_trigfun_record_resource_capacity() OWNER TO class4_user;

CREATE TRIGGER class4_trig_record_resource_capacity
AFTER INSERT OR DELETE OR UPDATE ON public.resource_capacity
FOR EACH ROW EXECUTE FUNCTION public.class4_trigfun_record_resource_capacity();

--
-- Fix release causes
--
UPDATE release_cause_string SET
name = 'All egress no confirmed', err = 503, err_string = 'Service Unavailable'
WHERE id = 27;
INSERT INTO release_cause_string (id, name, err, err_string) VALUES
    (93, 'FTC block', 403, 'Forbidden')
ON CONFLICT DO NOTHING;
INSERT INTO release_cause_string (id, name, err, err_string) VALUES
    (94, 'ANI CLEC type block', 403, 'Forbidden')
ON CONFLICT DO NOTHING;
INSERT INTO release_cause_string (id, name, err, err_string) VALUES
    (95, 'DNIS CLEC type block', 403, 'Forbidden')
ON CONFLICT DO NOTHING;

INSERT INTO global_route_error
    (id, error_code, error_description, to_sip_code, to_sip_string, default_to_sip_code, default_to_sip_string)
VALUES
    (94, 94, 'ANI CLEC type block', 403, 'Forbidden', 403, 'Forbidden')
ON CONFLICT DO NOTHING;
INSERT INTO global_route_error (id, error_code, error_description, to_sip_code, to_sip_string, default_to_sip_code, default_to_sip_string)
VALUES
    (95, 95, 'DNIS CLEC type block', 403, 'Forbidden', 403, 'Forbidden')
ON CONFLICT DO NOTHING;

--
-- Fix egress error codes
--
INSERT INTO egress_error_string (id, name) VALUES (83, 'FTC block')
ON CONFLICT DO NOTHING;
INSERT INTO egress_error_string (id, name) VALUES (84, 'ANI CLEC type block')
ON CONFLICT DO NOTHING;
INSERT INTO egress_error_string (id, name) VALUES (85, 'DNIS CLEC type block')
ON CONFLICT DO NOTHING;

--
-- [SIPSWITCH-553] Database version for backend
--
CREATE TABLE IF NOT EXISTS c4db_version (
    id integer NOT NULL DEFAULT 1 UNIQUE,
    version_num text NOT NULL,
    tag text,
    CHECK (id = 1)
);
ALTER TABLE c4db_version OWNER TO class4_user;

INSERT INTO c4db_version (version_num, tag)
    VALUES ('c5906c7313ff738bb3c2f473fa2a59d0', '7.4.7')
    ON CONFLICT (id) DO UPDATE
    SET version_num = 'c5906c7313ff738bb3c2f473fa2a59d0', tag = '7.4.7';

--
-- Fix sys_submenu
--
INSERT INTO sys_submenu
    (id, display_name, ordering, is_readable, is_editable, is_executable, enabled, main_menu_id, web_url)
    VALUES
    (97, 'Stir Shaken Test', 11, true, false, false, true, 11, '/tools/stir_shaken_test')
    ON CONFLICT DO NOTHING;

INSERT INTO sys_submenu
    (id, display_name, ordering, is_readable, is_editable, is_executable, enabled, main_menu_id, web_url)
    VALUES
    (98, 'Export Log', 5, true, false, true, true, 3, '/log/export_logs')
    ON CONFLICT DO NOTHING;

UPDATE sys_submenu SET ordering = 21 WHERE id = 19;

--
-- Fix permissions
--
ALTER TABLE client_record OWNER TO class4_user;
ALTER FUNCTION class4_trigfun_record_client() OWNER TO class4_user;
ALTER TABLE client_record_record_id_seq OWNER TO class4_user;

ALTER TABLE resource_record OWNER TO class4_user;
ALTER FUNCTION class4_trigfun_record_resource() OWNER TO class4_user;
ALTER TABLE resource_record_record_id_seq OWNER TO class4_user;

ALTER TABLE system_configure_record OWNER TO class4_user;
ALTER FUNCTION class4_trigfun_record_system_configure() OWNER TO class4_user;
ALTER TABLE system_configure_record_record_id_seq OWNER TO class4_user;

--
-- Update default lrn timeout settings
--
UPDATE c4_lrn SET retry_attempts = 3, timeout = 1 WHERE id = 1;

--
-- Remove unique constraint from resource.name and client.name
-- NOTE: following commit 85b16d9a3abd1f85fe42d661cc9c37f2989f419c
-- Author: vahagnsaribekyan <vahagnsaribekyan>
-- Date:   Mon Feb 24 12:23:58 2025 +0000
--
--     Remove client and resource name unique
--
ALTER TABLE client DROP CONSTRAINT IF EXISTS client_name_key;
ALTER TABLE resource DROP CONSTRAINT IF EXISTS resource_name_key;

END;
"""
    connection = op.get_bind()
    connection.execute(upgrade_sql)
    up_rec("agent_client_client")
    up_rec("allowed_sendto_ip")
    up_rec("banned_ip")
    up_rec("c4_lrn")
    up_rec("code")
    up_rec("currency")
    up_rec("currency_updates")
    up_rec("dynamic_route_items")
    up_rec("dynamic_route_qos")
    up_rec("jurisdiction_prefix")
    up_rec("system_configure")
    up_rec("ocn_blocklist")
    up_rec("product")
    up_rec("rate")
    up_rec("rate_table")
    up_rec("resource_block_items")
    up_rec("resource_codecs_ref")
    up_rec("resource_prefix")
    up_rec("resource")
    up_rec("route")
    up_rec("shaken_ani_group_list")
    up_rec("sip_404_number")
    up_rec("sip_error_code")
    up_rec("termination_global_failover")
    up_rec("time_profile")
    up_rec("transaction_fee_items")
    up_rec("c4_livecall_user")
    up_rec("c4_shaken_conf")
    up_rec("c4_shaken_status")
    up_rec("did_billing_plan")
    up_rec("did_billing_rel")
    up_rec("dynamic_route_override")
    up_rec("dynamic_route_pri")
    up_rec("dynamic_route")
    up_rec("egress_profile")
    up_rec("global_route_error")
    up_rec("origination_global_failover")
    up_rec("partition_gateway_ref")
    up_rec("payment_term")
    up_rec("product_items")
    up_rec("product_items_resource")
    up_rec("product_rout_rate_table")
    up_rec("random_ani_generation")
    up_rec("random_ani_group")
    up_rec("rate_type_override")
    up_rec("resource_block")
    up_rec("resource_capacity")
    up_rec("resource_direction")
    up_rec("resource_ip_limit")
    up_rec("resource_ip")
    up_rec("resource_lrn_action")
    up_rec("resource_next_route_rule")
    up_rec("resource_replace_action")
    up_rec("resource_translation_ref")
    up_rec("service_charge_items")
    up_rec("shaken_ani_group_list_rel")
    up_rec("shaken_ani_group_rel")
    up_rec("shaken_sti_sp_conf")
    up_rec("spam_traffic_ip")
    up_rec("translation_item")
    up_rec("client")
    up_rec("switch_profile")


def downgrade():
    # Arch users don't downgrade
    pass


"""
ADDONS
"""


def up_rec(table):
    """
    Update {table}_record schema
    """

    up_rec_sql = """
DO $do$
DECLARE
    rec_id INT := 1;
BEGIN
    -- Check if table exists
    IF NOT EXISTS (SELECT 0 FROM pg_tables WHERE tablename = '{table}') THEN
        RAISE WARNING 'Table {table} does not exist';
    ELSE
        -- Get last record_id
        SELECT record_id FROM {table}_record ORDER BY record_id DESC LIMIT 1
        INTO rec_id;
        -- Delete existing table
        DROP TRIGGER IF EXISTS class4_trig_record_{table} ON {table};
        DROP FUNCTION IF EXISTS class4_trigfun_record_{table};
        DROP TABLE IF EXISTS {table}_record;
        DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
    END IF;

    -- Create new table
    CREATE TABLE {table}_record (LIKE {table},
    "time" integer, flag character(1), record_id SERIAL PRIMARY KEY);
    ALTER TABLE {table}_record OWNER TO class4_user;
    CREATE INDEX IF NOT EXISTS {table}_record_time_idx
    ON {table}_record USING btree ("time");
    EXECUTE format(E'SELECT setval(\\'{table}_record_record_id_seq\\', %%L)',
    rec_id);

    -- Trigger
    CREATE FUNCTION class4_trigfun_record_{table}() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.{table}_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.{table}_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.{table}_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.{table}_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;
    ALTER FUNCTION class4_trigfun_record_{table}() OWNER TO class4_user;
    CREATE TRIGGER class4_trig_record_{table} AFTER INSERT OR DELETE OR UPDATE
    ON {table} FOR EACH ROW EXECUTE PROCEDURE class4_trigfun_record_{table}();
END $do$;
"""
    connection = op.get_bind()
    connection.execute(up_rec_sql.format_map(dict(table=table)))
