"""ftp_conf

Revision ID: 93cc46adde8c
Revises: 5e1e4f99ad1a
Create Date: 2018-04-23 18:23:59.563924

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '93cc46adde8c'
down_revision = '5e1e4f99ad1a'
branch_labels = None
depends_on = None


def upgrade():
    connection = op.get_bind()
    connection.execute("update ftp_conf set egress_carriers_all = CASE WHEN NOT egress_carriers is NULL then False else True END")
    connection.execute("update ftp_conf set ingress_carriers_all = CASE WHEN NOT ingress_carriers is NULL then False else True END")
    connection.execute("update ftp_conf set egresses_all = CASE WHEN NOT egresses is NULL then False else True END")
    connection.execute("update ftp_conf set ingresses_all = CASE WHEN NOT ingresses is NULL then False else True END")
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('ftp_conf', 'egress_carriers_all',
               existing_type=sa.BOOLEAN(),
               nullable=False)
    op.alter_column('ftp_conf', 'egresses_all',
               existing_type=sa.BOOLEAN(),
               nullable=False)
    op.alter_column('ftp_conf', 'ingress_carriers_all',
               existing_type=sa.BOOLEAN(),
               nullable=False)
    op.alter_column('ftp_conf', 'ingresses_all',
               existing_type=sa.BOOLEAN(),
               nullable=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('ftp_conf', 'ingresses_all',
               existing_type=sa.BOOLEAN(),
               nullable=True)
    op.alter_column('ftp_conf', 'ingress_carriers_all',
               existing_type=sa.BOOLEAN(),
               nullable=True)
    op.alter_column('ftp_conf', 'egresses_all',
               existing_type=sa.BOOLEAN(),
               nullable=True)
    op.alter_column('ftp_conf', 'egress_carriers_all',
               existing_type=sa.BOOLEAN(),
               nullable=True)
    # ### end Alembic commands ###
