"""lcr_test

Revision ID: b227cdde25c2
Revises: 33c370d91346
Create Date: 2018-02-05 16:50:10.336958

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'b227cdde25c2'
down_revision = '33c370d91346'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    from sqlalchemy.schema import Sequence, CreateSequence
    op.execute(CreateSequence(Sequence('lcr_test_log_id_seq')))
    op.create_table('lcr_test_log',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('test_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('ani', sa.String(length=64), nullable=True),
    sa.Column('dnis', sa.String(length=64), nullable=True),
    sa.Column('test_result', sa.Text(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.execute(CreateSequence(Sequence('lcr_test_id_seq')))
    op.create_table('lcr_test',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('type', sa.Integer(), nullable=True),
    sa.Column('client_id', sa.Integer(), nullable=True),
    sa.Column('trunk_id', sa.Integer(), nullable=True),
    sa.Column('ip_id', sa.Integer(), nullable=True),
    sa.Column('prefix_id', sa.Integer(), nullable=True),
    sa.Column('rate_table_id', sa.Integer(), nullable=True),
    sa.Column('switch_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['ip_id'], ['resource_ip.resource_ip_id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['prefix_id'], ['resource_prefix.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['rate_table_id'], ['rate_table.rate_table_id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['switch_id'], ['voip_gateway.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['trunk_id'], ['resource.resource_id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('lcr_test')
    op.drop_table('lcr_test_log')
    # ### end Alembic commands ###
