"""ticket

Revision ID: b503ed30015d
Revises: de7588a3eb8e
Create Date: 2018-02-06 20:02:38.357446

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'b503ed30015d'
down_revision = 'de7588a3eb8e'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    from sqlalchemy.schema import Sequence, CreateSequence
    op.execute(CreateSequence(Sequence('ticket_id_seq')))
    op.create_table('ticket',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('user_ip', sa.String(length=32), nullable=True),
    sa.Column('gateway_ip', sa.String(length=32), nullable=True),
    sa.Column('user_name', sa.String(length=100), nullable=True),
    sa.Column('url', sa.String(length=500), nullable=True),
    sa.Column('content', sa.Text(), nullable=True),
    sa.Column('subject', sa.String(length=100), nullable=True),
    sa.Column('create_on', sa.DateTime(timezone=True), nullable=True),
    sa.Column('status', sa.SmallInteger(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.execute(CreateSequence(Sequence('ticket_attachment_id_seq')))
    op.create_table('ticket_attachment',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('ticket_id', sa.Integer(), nullable=True),
    sa.Column('orig_file', sa.String(length=500), nullable=True),
    sa.Column('create_on', sa.DateTime(timezone=True), nullable=True),
    sa.ForeignKeyConstraint(['ticket_id'], ['ticket.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('ticket_attachment')
    op.drop_table('ticket')
    # ### end Alembic commands ###
