"""pcap_query_task

Revision ID: bb0d231334d6
Revises: bb5cec0647d4
Create Date: 2018-11-30 00:46:32.288843

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'bb0d231334d6'
down_revision = 'bb5cec0647d4'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('pcap_query_task',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('operator_user', sa.String(length=40), nullable=True),
    sa.Column('pcap_start_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('pcap_end_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('filter', sa.String(length=1024), nullable=True),
    sa.Column('result_file', sa.String(length=1024), nullable=True),
    sa.Column('status', sa.SmallInteger(), server_default='0', nullable=False),
    sa.Column('progress', sa.String(length=1024), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('proc_start_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('proc_end_time', sa.DateTime(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('pcap_query_task')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger class4_trig_record_{table} on {table};
drop table {table}_record;
DROP FUNCTION class4_trigfun_record_{table}();
DROP SEQUENCE {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))