"""removing cps cap from switch

Revision ID: c6d6cabde673
Revises: 8fa16b5a2c38
Create Date: 2023-12-14 10:00:00.000000

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'c6d6cabde673'
down_revision = '8fa16b5a2c38'
branch_labels = None
depends_on = None


def upgrade():
    # Add src_type and dst_type columns to client_cdr
    op.add_column('client_cdr', sa.Column('src_type', sa.Text()))
    op.add_column('client_cdr', sa.Column('dst_type', sa.Text()))

    # Remove self_cap and self_cps from switch_profile
    op.drop_column('switch_profile', 'self_cap')
    op.drop_column('switch_profile', 'self_cps')

    connection = op.get_bind()
    connection.execute(r"""
    ALTER TABLE system_configure ADD COLUMN id SERIAL PRIMARY KEY;
    """)
    up_rec('system_configure')


def downgrade():
    # Remove id primary key from system_configure
    op.execute('ALTER TABLE system_configure DROP COLUMN id')
    op.execute('ALTER TABLE system_configure ADD PRIMARY KEY (switch_name)')

    # Add back self_cap and self_cps to switch_profile
    op.add_column('switch_profile', sa.Column('self_cap', sa.Integer(), nullable=True))
    op.add_column('switch_profile', sa.Column('self_cps', sa.Integer(), nullable=True))

    # Remove src_type and dst_type columns from client_cdr
    op.drop_column('client_cdr', 'dst_type')
    op.drop_column('client_cdr', 'src_type')


"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))

