from marshmallow import validate, Schema
from marshmallow.fields import Bool, Str, Decimal, Int, Nested, DateTime, Float, List, UUID, Dict

from api_dnl import model
from api_dnl.fields import Choice
from api_dnl.scheme import BaseModelScheme


# region +++SmsRate+++
class SmsRateScheme(BaseModelScheme):
    id = Int()
    sms_rate_table_id = Int()
    code = Str()
    country = Str(validate=[validate.Length(max=1000)])
    effective_date = DateTime()
    end_date = DateTime()
    rate = Float()
    class Meta:
        model = model.SmsRate
        fields = ('sms_rate_table_id', 'code', 'country', 'effective_date', 'end_date', 'rate')


class SmsRateSchemeGet(SmsRateScheme):
    class Meta:
        model = model.SmsRate
        fields = ('id', 'sms_rate_table_id', 'code', 'country', 'effective_date', 'end_date', 'rate')
        search_fields = ('id', 'sms_rate_table_id', 'code', 'country',)
        query_fields = ('effective_date_gt', 'effective_date_lt', 'end_date_gt', 'end_date_lt',)


class SmsRateSchemeModify(SmsRateScheme):
    pass


# endregion ---SmsRate---
# region +++SmsRateTable+++
class SmsRateTableScheme(BaseModelScheme):
    id = Int()
    name = Str(validate=[validate.Length(max=100)])
    created_on = DateTime()
    created_by = Str()

    class Meta:
        model = model.SmsRateTable
        fields = ('name',)


class SmsRateTableSchemeGet(SmsRateTableScheme):
    class Meta:
        model = model.SmsRateTable
        fields = ('id', 'name', 'created_on', 'created_by',)
        search_fields = ('id', 'name', 'created_by',)
        query_fields = ('created_on_gt', 'created_on_lt',)


class SmsRateTableSchemeModify(SmsRateTableScheme):
    pass
# endregion ---SmsRateTable---
